# -*- coding: utf-8 -*-
"""
Created on Fri Jun 23 16:36:44 2017

@author: fabrice+jeremy
"""

from pymba import Vimba
import time
import numpy as np
import imageio
import os
#Specifies frames and position of interest
NFRAMES = 25000
HEIGHT = 480
WIDTH =480
OffsetY=0
OffsetX=160

# start Vimba
with Vimba() as vimba:
    # get system object
    system = vimba.getSystem()
    
    # list available cameras (after enabling discovery for GigE cameras)
    if system.GeVTLIsPresent:                                                      
        system.runFeatureCommand("GeVDiscoveryAllOnce")
        time.sleep(0.2)
    cameraIds = vimba.getCameraIds()
    for cameraId in cameraIds:
        print('Camera ID:', cameraId)
    
    # get and open a camera
    camera0 = vimba.getCamera(cameraIds[0])
    camera0.openCamera()
    
    # list camera features
    cameraFeatureNames = camera0.getFeatureNames()
     
        
        
    camera0.Height = HEIGHT
    camera0.Width = WIDTH
    camera0.Gain=15
    
    camera0.ExposureTime = 100
    
    camera0.OffsetY = OffsetY
    camera0.OffsetX = OffsetX
    #Trigger mode ON
    camera0.TriggerMode = 'On'
    
    camera0.TriggerActivation = 'RisingEdge'
    camera0.PixelFormat = 'Mono8'
    
    camera0.AcquisitionMode = 'Continuous'
    camera0.ExposureMode = 'Timed'
    camera0.LineSelector = 'Line0'

    print ('TriggerMode:', camera0.TriggerMode)
    print ('TriggerSource:', camera0.TriggerSource)
    print ('TriggerActivation:', camera0.TriggerActivation)
    print ('TriggerSelector:', camera0.TriggerSelector)
    
    
    camera0.writeRegister('0xF0F00614', '00000000')#set trigger pins cf manual
    camera0.writeRegister('0xF0F00830', '82000000')#set trigger pins
    camera0.writeRegister('0xF0F0061C', '80000001')#set trigger pins
    
    
    #camera0.writeRegister('0xF1000300', '80020000')#set trigger pins
    
    
    
    print ('TriggerSource:', camera0.TriggerSource)
    
    # Create new frames for the camera
    frame0 = camera0.getFrame()    # creates a frame
    
    
    # Announce frame
    frame0.announceFrame()
    
    # Capture camera images
    camera0.startCapture()
   
    count = 0
    
    camera0.runFeatureCommand('AcquisitionStart')
    frame0.queueFrameCapture()
    
    t0 = time.time()
    while count < NFRAMES:
        
        
        frame0.waitFrameCapture(timeout=2147483648)   # 2**31 -- uses int32
        frame0.queueFrameCapture()
        
       

        data1_np = np.ndarray(buffer=frame0.getBufferByteData(),
                      dtype=np.uint8,
                      shape=(frame0.height, frame0.width))

        #Saves image
        imageio.imsave(os.path.join('Image Collection\Testing\one',
                                 'Image{}.png'.format(count)),data1_np)
        
        print("image {} saved".format(count))

        count+=1
        
    
    dt = time.time() - t0
    
    
    camera0.runFeatureCommand('AcquisitionStop')
    camera0.endCapture()    
    camera0.revokeAllFrames()
    camera0.closeCamera()
    
    print("Got %d frames in %f seconds"%(NFRAMES, dt))
    print("Framerate = %f Hz, i.e. %f seconds/frame"%(NFRAMES/dt, dt/NFRAMES))
    
    
  