classdef DensityMatrix 
     %DensityMatrix Summary of this class goes here
    %   Detailed explanation goes here
    %class for declaration of DensityMatrix
    properties
                
    end
    properties (SetAccess = public)        
        val %value
        N   %number of spins
    end
    methods
        function R=DensityMatrix(SO,varargin)          
            if ischar(SO)
                if strcmp(SO,'100%_Magnetization')
                    if isSpinOperators(varargin{1})
                        S=varargin{1};
                        R.N=S.N;
                        R.val=S.U;
                        for in=1:S.N
                           R.val=R.val+S.norm('z',in);
                        end
                    else
                        error('second input parameter must be SpinOperator!');
                    end
                elseif strcmp(SO,'100%_SingletSpinOrder')
                    if isSpinOperators(varargin{1}) && nargin==4
                        S=varargin{1};
                        Sn1=varargin{2};
                        Sn2=varargin{3};                        
                        R.N=S.N;                        
                        R.val=S.U-SSnorm(S,Sn1,Sn2);                        
                    else
                        error('second input parameter must be SpinOperator, 3d and 4th input parameters are numbers of spins!');
                    end
                elseif strcmp(SO,'parahydrogen')
                    if isSpinOperators(varargin{1}) && nargin==5
                        S=varargin{1};
                        Sn1=varargin{2};
                        Sn2=varargin{3};                        
                        fpH2=varargin{4};
                        R.N=S.N;                        
                        R.val=S.U-SSnorm(S,Sn1,Sn2)*(4*fpH2-1)/3;                        
                    else
                        error('second input parameter must be SpinOperator, 3d and 4th input parameters are numbers of spins!');
                    end
                elseif strcmp(SO,'ThermalPolarization')
                    if isSpinOperators(varargin{1}) && nargin==4
                        S=varargin{1};
                        H=varargin{2};
                        T=varargin{3};                        
                        R.N=S.N;
                        kB=1.38064852*1e-23;% m2 kg s-2 K-1;
                        hbar=1.0545718*1e-34;% m2 kg / s;
                        R.val=expm(-H*hbar/(kB*T));
                        %Q=expm(H*hbar/(kB*T));E=eye(S.Nstates);R.val=E/(Q+E);                                                
                        R.val=R.val/trace(R.val);
                    else
                        error('second input parameter must be SpinOperator, 3d and 4th input parameters are numbers of spins!');
                    end
                else
                    error(['Density matrix constructor has several options:',...
                        '1.DensityMatrix(''combination of spin operators'');',...
                        '2.DensityMatrix(''100%_Magnetization'',SpinOperators);']);
                end
            elseif isnumeric(SO)
                R.val=SO;
                temp=size(SO);
                if isinteger(log2(temp(1)))
                    R.N=log2(temp(1));
                else
                    %display('wrong size');
                    f=factor(temp(1));
                    R.N=sum(f==2)+sum(f==3);
                end
                
            else
                error('wrong specification of density matrix');                
            end
        end
        function out=isDensityMatrix(in)
           if isa(in,'DensityMatrix'); 
               out=1;
           else
               out=0;
           end
        end 
        function obj=Add(obj,SO)            
            obj.val=obj.val+SO;
        end
        function out=Amplitude(obj,Op)
            out=full(trace((obj.val)'*Op)/trace(Op*Op'));
        end
        function out=Amplitudes(obj,SOs)
            out=zeros(1,length(SOs));
            for n=1:length(SOs)
                out(n)=full(trace((obj.val)'*SOs{n})/trace(SOs{n}*SOs{n}'));
            end
        end
        function [req2, S2]=ChangeBasis(obj,S,Q)
           req2=obj;
           req2.val=Q\obj.val*Q;
           S2=S.ChangeBasis(Q);           
        end
        function rho=RemoveCoherences(obj,varargin)
            switch nargin
                case 1
                    rho=obj;
                    rho.val=diag(diag(obj.val));
                case 2
                    rho=obj;
                    Q=varargin{1};
                    rho.val=Q*diag(diag(Q\obj.val*Q))/Q;
                otherwise
                    
            end
        end
        
        function ShowMatrix(obj)
            if isDensityMatrix(obj)
                display(full(obj.val)); 
            else
                error('showMatrix accept only DensityMatrix obj');                
            end
        end 
        function ShowOperators(obj,S,Threshold)
            objT=obj;
            if obj.N<4
                dim=obj.N;                
            else
                dim=4;
                display('we do not show spin orders higher than product of four spin operators');
            end
            if isSpinOperators(S)                              
                if obj.N==S.N 
                    [SRow, StrRow]=SpinOperatorsInRaw(S);                                        
                    %case 1
                    if dim>=1
                        str1='';
                        for in=1:obj.N*3+1
                            a=objT.Amplitude(SRow{in});
                            objT.val=objT.val-a*SRow{in};                            
                            if real(a)>abs(Threshold) 
                                str1=[str1,sprintf(['+%g*' StrRow{in}],real(a))];
                            end
                            if imag(a)>abs(Threshold) 
                                str1=[str1,sprintf(['+%g*i*' StrRow{in}],imag(a))];
                            end
                            if real(a)<-abs(Threshold)
                                str1=[str1,sprintf(['%g*' StrRow{in}],real(a))];
                            end
                            if imag(a)<-abs(Threshold)
                                str1=[str1,sprintf(['%g*i*' StrRow{in}],imag(a))];           
                            end                            
                        end
                        display(sprintf('Density matrix'));
                        display(sprintf('(single spin operator(s) %d)= ',1)); 
                        display([' = ' str1]);
                    end
                    %case 2
                    if dim>=2
                        str2='';
                        for in1=2:obj.N*3+1-1
                            for in2=in1+1:obj.N*3+1
                                a=objT.Amplitude(SRow{in1}*SRow{in2});
                                objT.val=objT.val-a*SRow{in1}*SRow{in2};
                                
                                if real(a)>abs(Threshold)
                                    str2=[str2,sprintf(['+%g*' StrRow{in1} StrRow{in2}],real(a))];
                                end
                                if imag(a)>abs(Threshold)
                                    str2=[str2,sprintf(['+%g*i*' StrRow{in1} StrRow{in2}],imag(a))];
                                end
                                if real(a)<-abs(Threshold)
                                    str2=[str2,sprintf(['%g*' StrRow{in1} StrRow{in2}],real(a))];                                
                                end
                                if imag(a)<-abs(Threshold)
                                    str2=[str2,sprintf(['%g*i*' StrRow{in1} StrRow{in2}],imag(a))];                                
                                end
                            end
                        end  
                        display(sprintf('(product of %d)= ',2)); 
                        display([' = ' str2]);
                    end
                    %case 3                    
                    if dim>=3
                        str3='';
                        for in1=2:obj.N*3+1-2
                            for in2=in1+1:obj.N*3+1-1
                                for in3=in2+1:obj.N*3+1
                                    a=objT.Amplitude(SRow{in1}*SRow{in2}*SRow{in3});
                                    objT.val=objT.val-a*SRow{in1}*SRow{in2}*SRow{in3};
                                    if real(a)>abs(Threshold) 
                                        str3=[str3,sprintf(['+%g*' StrRow{in1} StrRow{in2} StrRow{in3}],real(a))];
                                    end
                                    if imag(a)>abs(Threshold) 
                                        str3=[str3,sprintf(['+%g*i*' StrRow{in1} StrRow{in2} StrRow{in3}],imag(a))];
                                    end
                                    if real(a)<-abs(Threshold)
                                        str3=[str3,sprintf(['%g*' StrRow{in1} StrRow{in2} StrRow{in3}],real(a))];
                                    end
                                    if imag(a)<-abs(Threshold)
                                        str3=[str3,sprintf(['%g*i*' StrRow{in1} StrRow{in2} StrRow{in3}],imag(a))];
                                    end
                                end
                            end
                        end 
                        display(sprintf('(product of %d)= ',3)); 
                        display([' = ' str3]);
                    end
                    %case 4
                    if dim>=4
                        str4='';
                        for in1=2:obj.N*3+1-3
                            for in2=in1+1:obj.N*3+1-2
                                for in3=in2+1:obj.N*3+1-1
                                    for in4=in3+1:obj.N*3+1
                                        a=objT.Amplitude(SRow{in1}*SRow{in2}*SRow{in3}*SRow{in4});
                                        objT.val=objT.val-a*SRow{in1}*SRow{in2}*SRow{in3}*SRow{in4};
                                        if real(a)>abs(Threshold) 
                                            str4=[str4,sprintf(['+%g*' StrRow{in1} StrRow{in2} StrRow{in3} StrRow{in4}],real(a))];
                                        end
                                        if imag(a)>abs(Threshold) 
                                            str4=[str4,sprintf(['+%g*' StrRow{in1} StrRow{in2} StrRow{in3} StrRow{in4}],imag(a))];
                                        end
                                        if real(a)<-abs(Threshold)
                                            str4=[str4,sprintf(['%g*' StrRow{in1} StrRow{in2} StrRow{in3} StrRow{in4}],real(a))];
                                        end
                                        if imag(a)<-abs(Threshold)
                                            str4=[str4,sprintf(['%g*' StrRow{in1} StrRow{in2} StrRow{in3} StrRow{in4}],imag(a))];
                                        end
                                    end
                                end
                            end
                        end
                        display(sprintf('(product of %d)= ',4)); 
                        display([' = ' str4]); 
                    end                                        
                end
            else
                error('showMatrix accept only DensityMatrix obj and scalar for dimention');                
            end
        end
        function D=SetAmplitude(obj,S,Amp)
            D=obj;
            a=D.Amplitude(S);
            D.val=D.val+S*(Amp-a);                                    
        end
        
        function [PPM,FRQ,SPEC]=Spectrum(obj,H,S,SW,TD,v0,ppm0,RegNuc,FWHM,PHrec,varargin)                        
            %%%%%%%%%%%%%%%%%%display spectral parameters  
            dwell=1/SW;         
            ppmWidth=SW*1e6/v0; 
            FRQ=linspace(-SW/2,SW/2,TD)';
            PPM=FRQ*1e6/(v0)+ppm0*1e6;
            if nargin>=11               
                if strcmp(varargin{1},'yes')
                tic
                display('computation of spectrum starts');
                display(sprintf('TD=%g',TD));
                display(sprintf('AQ time=%g s',TD/SW));
                display(sprintf('dwell time=%g ms',dwell*1e3));
                display(sprintf('Spectral width=%g Hz',SW));                        
                display(sprintf('Spectral resolution=%g Hz',SW/TD));
                display(sprintf('Spectral width in ppm%g ppm',ppmWidth));
                end
            end
            %%%%calculate spectrum from FID and save
            [Q, E0]=eig(full(H));
            E0=diag(E0);            
            if nargin<=11
                IxTotQ=0;IzTotQ=0;IyTotQ=0;
                for in=1:length(RegNuc)                
                    IxTotQ=IxTotQ+S.x{RegNuc(in)}; 
                    IyTotQ=IyTotQ+S.y{RegNuc(in)};
                    IzTotQ=IzTotQ+S.z{RegNuc(in)};                        
                end
                IxTotQ=Q\IxTotQ*Q;
                IyTotQ=Q\IyTotQ*Q;
            else
                IxTotQ=Q\varargin{2}*Q;
                IyTotQ=Q\varargin{3}*Q;                                
            end
            
            
            
            
            %IzTotQ=Q\IzTotQ*Q;
            DensMatx=Q\obj.val*Q;
            %IupTotQ=IxTotQ+1i*IyTotQ; 
            %IdownTotQ=IxTotQ+1i*IyTotQ;
            
            SPEC=zeros(TD,1);
            %IntensMatrix=IupTotQ.*DensMatx';
            if strcmp(PHrec,'X')
                RecPH=-IxTotQ;
            elseif strcmp(PHrec,'Y')
                RecPH=-IyTotQ;
            elseif strcmp(PHrec,'-X')
                RecPH=+IxTotQ;
            elseif strcmp(PHrec,'-Y')
                RecPH=+IyTotQ;
            elseif strcmp(PHrec,'+')
                RecPH=IxTotQ+1i*IyTotQ;
            elseif strcmp(PHrec,'-')
                RecPH=IxTotQ-1i*IyTotQ;
            else
                error('phase of receiver can be only ''X'',''Y'',''-X'',''-Y'' ');
            end
            IntensMatrix=RecPH.*DensMatx';
            Max_IntensMatrix=max(max(abs(IntensMatrix)));
            [Nstates, n2]=size(DensMatx);
            
            for in=1:Nstates             
                for jn=1:Nstates                         
                    intens=IntensMatrix(in,jn);
                    if (abs(intens)>Max_IntensMatrix/1000)
                        SPEC=SPEC+intens./(1i*(2*pi*(FRQ+(1+ppm0)*v0)-sign(v0)*(E0(in)-E0(jn)))+pi*FWHM);                                   
                    end        
                end
            end 
            if nargin>10                
                if strcmp(varargin{1},'yes')
            display('computation of spectrum is finished');        
            toc
                end
            end
        end
        
        function rho=traceFirst(obj,S)
            Ns=S.Nstates;
            n=S.SpinVal{1}*2+1;
            rho=obj;
            Nt=Ns/n;
            switch n
                case 2
                    rho.val=obj.val(1:Nt,1:Nt)+...
                            obj.val(Nt+1:Ns,Nt+1:Ns);
                case 3
                    rho.val=obj.val(1:Nt,1:Nt)+...
                            obj.val(Nt+1:2*Nt,Nt+1:2*Nt)+...
                            obj.val(2*Nt+1:Ns,2*Nt+1:Ns);
                otherwise 
                    error('can not take trace over spin 1');
            end
            rho.N=obj.N-1;            
        end
        function rho=trace2First(obj,S)
            Ns=S.Nstates;
            n1=S.SpinVal{1}*2+1;
            n2=S.SpinVal{2}*2+1;
            rho=obj;
            Nt=Ns/(n1*n2);
            rho.val=0;
            for in=1:n1*n2
                rho.val=rho.val+obj.val(Nt*(in-1)+1:Nt*in,Nt*(in-1)+1:Nt*in);                            
            end
            rho.N=obj.N-2;            
        end
        function rho=traceLast(obj,S)
            Ns=S.Nstates;
            n1=S.SpinVal{S.N}*2+1;            
            rho=obj;
            Nt=Ns/n1;
            rho.val=zeros(Nt);
            for k=1:Nt
                for l=1:Nt
            rho.val(k,l)=trace( obj.val((k-1)*n1+1:k*n1,(l-1)*n1+1:l*n1) );                            
                end
            end
            rho.N=obj.N-1;            
        end
        function rho=traceLeave2First(obj,S)
            Ns=S.Nstates;
            n1=S.SpinVal{1}*2+1;            
            n2=S.SpinVal{2}*2+1;
            rho=obj;
            Nt=Ns/(n1*n2);
            rho.val=zeros(Nt);
            for k=1:n1*n2
                for l=1:n1*n2
            rho.val(k,l)=trace( obj.val((k-1)*Nt+1:k*Nt,(l-1)*Nt+1:l*Nt) );                            
                end
            end
            rho.N=2;            
        end        
                
        function objT=RotationSuperOperator(obj,angle,dir,S,spins)%pi/2,'x',[1 2]       
            objT=obj;
            Op=0;
            if strcmp(dir,'X') || strcmp(dir,'x')
                for in=1:length(spins)
                    Op=Op+S.x{spins(in)};
                end
            elseif strcmp(dir,'Y') || strcmp(dir,'y')
                for in=1:length(spins)
                    Op=Op+S.y{spins(in)};
                end
            elseif strcmp(dir,'Z') || strcmp(dir,'z')
                for in=1:length(spins)
                    Op=Op+S.z{spins(in)};
                end
            elseif strcmp(dir,'-x') || strcmp(dir,'-X')
                for in=1:length(spins)
                    Op=Op-S.x{spins(in)};
                end
            elseif strcmp(dir,'-y') || strcmp(dir,'-Y')
                for in=1:length(spins)
                    Op=Op-S.y{spins(in)};
                end
            elseif strcmp(dir,'-z') || strcmp(dir,'-Z')
                for in=1:length(spins)
                    Op=Op-S.z{spins(in)};
                end
            elseif isfloat(dir)
                for in=1:length(spins)
                    Op=Op+S.x{spins(in)}*cos(dir)+S.y{spins(in)}*sin(dir);
                end
            else
               error('dir can be x, X, y, Y, z or Z, -x, -X, -y, -Y, -z, -Z'); 
            end
            objT.val=expm(-1i*Op*angle)*objT.val*expm(1i*Op*angle);
        end
        function [outT,out,objT]=EvolutionConstH(obj,H,t,SOs)
            %tic
            %display('start EvolutionConstH');
            [n1,n2]=size(t);
            if n2>n1
               outT=t'; 
            else
                outT=t;
            end
            if SOs==0            
                objT=obj;
                for it=1:length(t)                
                    objT.val=expm(-1i*H*t(it))*obj.val*expm(1i*H*t(it));                                    
                end
                out=0;
            else
                out=zeros(length(t),length(SOs));
                objT=obj;
                for it=1:length(t)                
                    objT.val=expm(-1i*H*t(it))*obj.val*expm(1i*H*t(it));                
                    out(it,:)=Amplitudes(objT,SOs);                
                end
            end
        end
        
        function [Time,Yout,ro]=EvolutionH_RD(obj,   S,H,Rs,yeq,rd,y0,SOs,t,skip,DEcase)                        
            ro=obj;
            % transformation of time vector
            [n1,n2]=size(t);
            if n2>n1
               Time=t'; 
            else
               Time=t;
            end
            if length(Time)==1
               Time=[0; Time];
            end
                 
%             %normalization
%             devMax=1+0.001; devMin=1-0.001;
%             if trace(ro.val)>devMax ||  trace(ro.val)<devMin
%                 error('trace(rs)!=1');
%             end            
%             %force normalization
%             ro.val =ro.val /trace(ro.val); 
            
            
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %check time step
            Rates=rd;
            dt_max=1/max(Rates);
            dt=Time(2)-Time(1);            
            if dt>dt_max/5               
               error('dt is too long'); 
            end                                                           
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%                        
            %matrices to vectors
            ICv = mtz2vec(ro.val);                        
            y0 =  mtz2vec( y0 ); 
            yeq =  mtz2vec( yeq ); 
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%                    
            Lc = -1i*H2Super(H);
            Lr = Rs;
            
%            fileID = fopen('save.txt','w');
%            fclose(fileID);
            
            
            opts = odeset('RelTol',1e-9,'AbsTol',1e-10); 
            switch DEcase
                case 1
            [Time0,Yt]=ode45(@(t,Y)EvolutionH_RD_sol(t,Y,yeq,S,Lc,Lr,rd,y0),Time,ICv,opts); 
                case 2
            [Time0,Yt]=ode113(@(t,Y)EvolutionH_RD_sol(t,Y,yeq,S,Lc,Lr,rd,y0),Time,ICv,opts); 
                case 3
            [Time0,Yt]=ode15s(@(t,Y)EvolutionH_RD_sol(t,Y,yeq,S,Lc,Lr,rd,y0),Time,ICv,opts); 
                case 4
            [Time0,Yt]=ode23s(@(t,Y)EvolutionH_RD_sol(t,Y,yeq,S,Lc,Lr,rd,y0),Time,ICv,opts); 
            end
            
            
            Yt=Yt.';
            [row, col] = find(isnan(Yt));
            
            if ~isempty(row)                                       
               error(sprintf('error NAN value is found, index=%.0d, Time(index)=%.4f',[row, Time(row)]))
            end

            [n1, n2]=size(Yt);                
            Yout=zeros(n2/skip,length(SOs));            
            Time=zeros(n2/skip,1);
            for it=1:length(Time0)/skip                
                Time(it)=Time0(1+(it-1)*skip);
                vec=Yt(:,1+(it-1)*skip);                                    
                ro.val=vec2mtz(vec);                
                Yout(it,:)=Amplitudes(ro,SOs);                                                
            end                                         
            ro.val=vec2mtz(Yt(:,end)); 
        end
        
          function [Time,Yout,ro]=EvolutionH_RDT(obj,S,H,Rs,    rd,y0,k,SOs,t,skip,DEcase)                        
            %sigmaNoise
              ro=obj;
            % transformation of time vector
            [n1,n2]=size(t);
            if n2>n1
               Time=t'; 
            else
               Time=t;
            end
            if length(Time)==1
               Time=[0; Time];
            end
                            
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %check time step
            Rates=rd;
            dt_max=1/max(Rates);
            dt=Time(2)-Time(1);            
            if dt>dt_max/5               
               error('dt is too long'); 
            end                                                           
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%                        
            %matrices to vectors
            ICv = mtz2vec(ro.val); %initial conditions, vector                       
            y0 =  mtz2vec( y0 );                        
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%                    
            L = -1i*H2Super(H) + Rs;
            
%            fileID = fopen('save.txt','w');
%            fclose(fileID);
            
            
            opts = odeset('RelTol',1e-9,'AbsTol',1e-10); 
            switch DEcase
                %,sigmaNoise
                case 1
            [Time0,Yt]=ode45(@(t,Y)EvolutionH_RDT_sol(t,Y,S,L,rd,y0,k),Time,ICv,opts); 
                case 2
            [Time0,Yt]=ode113(@(t,Y)EvolutionH_RDT_sol(t,Y,S,L,rd,y0,k),Time,ICv,opts); 
                case 3
            [Time0,Yt]=ode15s(@(t,Y)EvolutionH_RDT_sol(t,Y,S,L,rd,y0,k),Time,ICv,opts); 
                case 4
            [Time0,Yt]=ode23s(@(t,Y)EvolutionH_RDT_sol(t,Y,S,L,rd,y0,k),Time,ICv,opts); 
            end
            
            
            Yt=Yt.';
            [row, col] = find(isnan(Yt));
            
            if ~isempty(row)                                       
               error(sprintf('error NAN value is found, index=%.0d, Time(index)=%.4f',[row, Time(row)]))
            end

            [n1, n2]=size(Yt);                
            Yout=zeros(n2/skip,length(SOs));            
            Time=zeros(n2/skip,1);
            for it=1:length(Time0)/skip                
                Time(it)=Time0(1+(it-1)*skip);
                vec=Yt(:,1+(it-1)*skip);                                    
                ro.val=vec2mtz(vec);                
                Yout(it,:)=Amplitudes(ro,SOs);                                                
            end                                         
            ro.val=vec2mtz(Yt(:,end)); 
        end
        
        function [outT,out,objT]=EvolutionConstHRsemi(obj,H,R,rho0,t,SOs)
            %tic
            %display('start EvolutionConstHRsemi');
            [n1,n2]=size(t);
            if n2>n1
               outT=t'; 
            else
                outT=t;
            end           
            out=zeros(length(t),length(SOs));
            objT=obj;
            if ~isscalar(R)                
                error('R is a positive scalar '); 
            else
                R=-abs(R);    
            end
            if isa(rho0,'DensityMatrix')
             %   display('equilibrium dens.matrix');
            elseif rho0==0
                display('equilibrium scalar');
            else
               error('never forget about equilibrium density matrix, it can be zero or DensityMatrix'); 
            end
            ini=obj.val;eq=rho0.val;
            for it=1:length(t)
                objT.val=exp(-abs(R)*t(it))*expm(-1i*H*t(it))*(ini-eq)*expm(1i*H*t(it))-eq;
                for in=1:length(SOs)
                    out(it,in)=Amplitude(objT,SOs{in});
                end
            end
            %display('finish EvolutionConstHRsuper');
            %toc
        end
        function [outT,out,rho]=EvolutionConstHG(obj,H0,GrT,t,S,SOs)
            %tic
            %display('start EvolutionConstHG');
            [n1,n2]=size(t);
            if n2>n1
               outT=t'; 
            else
                outT=t;
            end
                        
            rho=obj;            
            
            out=zeros(length(t),length(SOs));            
            Sztot=0;
            for in=1:S.N
                Sztot=Sztot-S.g_gh{in}*S.z{in};
            end
            
            for it=1:length(t)
                rho.val=rho.val*0;
                for ig=1:length(GrT)                
                    H=H0+Sztot*GrT(ig)*S.gH;                
                    rho.val=rho.val+expm(-1i*H*t(it))*obj.val*expm(1i*H*t(it));
                end                          
                out(it,:)=Amplitudes(rho,SOs);                                
            end
            rho.val=rho.val/length(GrT);
            out=out/length(GrT);
            %display('finish EvolutionConstHG');
        end 
                
        function [outT,out,objT]=EvolutionConstHRsuper(obj,H,R,rho0,t,SOs,show,method)
            %tic
            %display('start EvolutionConstHRsuper');
            [n1,n2]=size(t);
            if n2>n1
               outT=t'; 
            else
                outT=t;
            end
            if H==0
                Hs=0;
            else
                Hs=H2Super(H);
            end
            out=zeros(length(t),length(SOs));
            objT=obj;
            vec=mtz2vec(obj.val);            
            if isa(rho0,'DensityMatrix')
                vec0=mtz2vec(rho0.val);
            elseif rho0==0
                vec0=0;
            else
               error('never forget about equilibrium density matrix, it can be zero or DensityMatrix'); 
            end
            Hs=R-1i*Hs;
            if strcmp(method,'LinearTimeSteps')
                dt=t(2)-t(1);
                A=expm(Hs*dt);
                for it=1:length(t)
                    if strcmp(show,'ShowSteps')
                        disp(it);
                    end                                       
                    vec=A*(vec-vec0)+vec0;                
                    objT.val=vec2mtz(vec);
                    out(it,:)=Amplitudes(objT,SOs);                                                
                end
            else
                for it=1:length(t)
                    if strcmp(show,'ShowSteps')
                        disp(it);
                    end
                    objT.val=vec2mtz(expm(Hs*t(it))*(vec-vec0)+vec0);                
                    out(it,:)=Amplitudes(objT,SOs);                                                
                end
            end

            
            %display('finish EvolutionConstHRsuper');
            %toc
        end 
                                                        
        function [Time, Y, rM]=M2Sev(obj,S,ChSh,Jij,B0,tJ,n1,n2,nuc,SOs)
            %Tayler Levitt DOI: 10.1039/c0cp02293d
            Time=zeros(4+3*n1+3*n2,1);
            Y=zeros(4+3*n1+3*n2,length(SOs));
            rM=obj;
            H0=2*pi*HZJij(S,ChSh,Jij,B0);
            Q=expm(-1i*H0*tJ);
            iQ=expm(1i*H0*tJ);
            r=0;
            %1  
            r=r+1;Time(r)=0;            
            Y(r,:)=Amplitude(rM,SOs);            
            
            
            %2 90_90
            rM=rM.RotationSuperOperator(pi/2,'Y',S,nuc);
            r=r+1;Time(r)=Time(r-1);
            Y(r,:)=Amplitude(rM,SOs);
            
            %3 tJ-(90_0 180_90 90_0)_f,  f={0 0 180? 180?...}
            DIR{1}={'X' 'Y' 'X'};DIR{2}={'X' 'Y' 'X'};
            DIR{3}={'X' 'Y' 'X'};DIR{4}={'X' 'Y' 'X'};
            %DIR{3}={'-X' '-Y' '-X'};%DIR{4}={'-X' '-Y' '-X'};
            for in1=1:n1                
                rM.val=Q*rM.val*iQ;
                r=r+1;Time(r)=Time(r-1)+tJ;
                Y(r,:)=Amplitude(rM,SOs);            
                
                rM=rM.RotationSuperOperator(pi/2,DIR{mod(in1-1,4)+1}{1},S,nuc);
                rM=rM.RotationSuperOperator(pi,DIR{mod(in1-1,4)+1}{2},S,nuc);
                rM=rM.RotationSuperOperator(pi/2,DIR{mod(in1-1,4)+1}{3},S,nuc);
                r=r+1;Time(r)=Time(r-1);
                Y(r,:)=Amplitude(rM,SOs);            
                
                rM.val=Q*rM.val*iQ;
                r=r+1;Time(r)=Time(r-1)+tJ;
                Y(r,:)=Amplitude(rM,SOs);
            end

            rM=rM.RotationSuperOperator(pi/2,'X',S,nuc);
            r=r+1;Time(r)=Time(r-1);
            Y(r,:)=Amplitude(rM,SOs);               
            
            rM.val=Q*rM.val*iQ;
            r=r+1;Time(r)=Time(r-1)+tJ;
            Y(r,:)=Amplitude(rM,SOs);            

            for in2=1:n2                
                rM.val=Q*rM.val*iQ;
                r=r+1;Time(r)=Time(r-1)+tJ;
                Y(r,:)=Amplitude(rM,SOs);            
                
                rM=rM.RotationSuperOperator(pi/2,DIR{mod(in2-1,4)+1}{1},S,nuc);
                rM=rM.RotationSuperOperator(pi,DIR{mod(in2-1,4)+1}{2},S,nuc);
                rM=rM.RotationSuperOperator(pi/2,DIR{mod(in2-1,4)+1}{3},S,nuc);
                r=r+1;Time(r)=Time(r-1);
                Y(r,:)=Amplitude(rM,SOs);            
                
                rM.val=Q*rM.val*iQ;
                r=r+1;Time(r)=Time(r-1)+tJ;
                Y(r,:)=Amplitude(rM,SOs);                            
            end                         
        end
        function [Time, Y, rM]=S2Mev(obj,S,ChSh,Jij,B0,tJ,n2,nuc,SOs)
            %Tayler Levitt DOI: 10.1039/c0cp02293d
            n1=n2*2;
            Time=zeros(4+3*n1+3*n2-1,1);
            Y=zeros(4+3*n1+3*n2-1,length(SOs));
            rM=obj;
            H0=2*pi*HZJij(S,ChSh,Jij,B0);
            Q=expm(-1i*H0*tJ);
            iQ=expm(1i*H0*tJ);
            r=0;
            %1  
            r=r+1;Time(r)=0;            
            Y(r,:)=Amplitudes(rM,SOs);            
            
            %3 tJ-(90_0 180_90 90_0)_f,  f={0 0 180? 180?...}
            DIR{1}={'X' 'Y' 'X'};DIR{2}={'X' 'Y' 'X'};
            DIR{3}={'X' 'Y' 'X'};DIR{4}={'X' 'Y' 'X'};
            %DIR{3}={'-X' '-Y' '-X'};%DIR{4}={'-X' '-Y' '-X'};
            %mod(in2-1,4)+1
            for in2=1:n2                
                rM.val=Q*rM.val*iQ;
                r=r+1;Time(r)=Time(r-1)+tJ;                
                Y(r,:)=Amplitudes(rM,SOs);
                
                rM=rM.RotationSuperOperator(pi/2,DIR{1}{1},S,nuc);
                rM=rM.RotationSuperOperator(pi,  DIR{1}{2},S,nuc);
                rM=rM.RotationSuperOperator(pi/2,DIR{1}{3},S,nuc);
                r=r+1;Time(r)=Time(r-1);
                Y(r,:)=Amplitudes(rM,SOs);                
                
                rM.val=Q*rM.val*iQ;
                r=r+1;Time(r)=Time(r-1)+tJ;                
                Y(r,:)=Amplitudes(rM,SOs);                
            end 
            rM.val=Q*rM.val*iQ;
            r=r+1;Time(r)=Time(r-1)+tJ;            
            Y(r,:)=Amplitudes(rM,SOs); 
            
            rM=rM.RotationSuperOperator(pi/2,'X',S,nuc);
            r=r+1;Time(r)=Time(r-1);            
            Y(r,:)=Amplitudes(rM,SOs);            
            
            for in1=1:n1                
                rM.val=Q*rM.val*iQ;
                r=r+1;Time(r)=Time(r-1)+tJ;                
                Y(r,:)=Amplitudes(rM,SOs); 
                
                rM=rM.RotationSuperOperator(pi/2,DIR{1}{1},S,nuc);
                rM=rM.RotationSuperOperator(pi,  DIR{1}{2},S,nuc);
                rM=rM.RotationSuperOperator(pi/2,DIR{1}{3},S,nuc);
                r=r+1;Time(r)=Time(r-1);
                Y(r,:)=Amplitudes(rM,SOs);
                
                rM.val=Q*rM.val*iQ;
                r=r+1;Time(r)=Time(r-1)+tJ;                
                Y(r,:)=Amplitudes(rM,SOs);                
            end                                
        end 
        
        
        
        function [Time, Y, rM]=M2S(obj,S,ChSh,Jij,B0,tJ,n2,nuc,SOs)
            %Tayler Levitt DOI: 10.1039/c0cp02293d
            n1=n2*2;
            Time=zeros(4+3*n1+3*n2,1);
            %Y=zeros(4+3*n1+3*n2,length(SOs));
            rM=obj;
            H0=2*pi*HZJij(S,ChSh,Jij,B0);
            Q=expm(-1i*H0*tJ);
            iQ=expm(1i*H0*tJ);
            %r=0;
            %1  
            %r=r+1;Time(r)=0;            
            %Y(r,:)=Amplitude(rM,SOs);            
            
            
            %2 90_90
            rM=rM.RotationSuperOperator(pi/2,'Y',S,nuc);
            %r=r+1;Time(r)=Time(r-1);
            %Y(r,:)=Amplitude(rM,SOs);
            
            %3 tJ-(90_0 180_90 90_0)_f,  f={0 0 180? 180?...}
            DIR{1}={'X' 'Y' 'X'};DIR{2}={'X' 'Y' 'X'};
            DIR{3}={'X' 'Y' 'X'};DIR{4}={'X' 'Y' 'X'};
            %DIR{3}={'-X' '-Y' '-X'};%DIR{4}={'-X' '-Y' '-X'};
            for in1=1:n1                
                rM.val=Q*rM.val*iQ;
                %r=r+1;Time(r)=Time(r-1)+tJ;
                %Y(r,:)=Amplitude(rM,SOs);            
                
                rM=rM.RotationSuperOperator(pi/2,DIR{mod(in1-1,4)+1}{1},S,nuc);
                rM=rM.RotationSuperOperator(pi,DIR{mod(in1-1,4)+1}{2},S,nuc);
                rM=rM.RotationSuperOperator(pi/2,DIR{mod(in1-1,4)+1}{3},S,nuc);
                %r=r+1;Time(r)=Time(r-1);
                %Y(r,:)=Amplitude(rM,SOs);            
                
                rM.val=Q*rM.val*iQ;
                %r=r+1;Time(r)=Time(r-1)+tJ;
                %Y(r,:)=Amplitude(rM,SOs);
            end

            rM=rM.RotationSuperOperator(pi/2,'X',S,nuc);
            %r=r+1;Time(r)=Time(r-1);
            %Y(r,:)=Amplitude(rM,SOs);               
            
            rM.val=Q*rM.val*iQ;
            %r=r+1;Time(r)=Time(r-1)+tJ;
            %Y(r,:)=Amplitude(rM,SOs);            

            for in2=1:n2                
                rM.val=Q*rM.val*iQ;
                %r=r+1;Time(r)=Time(r-1)+tJ;
                %Y(r,:)=Amplitude(rM,SOs);            
                
                rM=rM.RotationSuperOperator(pi/2,DIR{mod(in2-1,4)+1}{1},S,nuc);
                rM=rM.RotationSuperOperator(pi,DIR{mod(in2-1,4)+1}{2},S,nuc);
                rM=rM.RotationSuperOperator(pi/2,DIR{mod(in2-1,4)+1}{3},S,nuc);
                %r=r+1;Time(r)=Time(r-1);
                %Y(r,:)=Amplitude(rM,SOs);            
                
                rM.val=Q*rM.val*iQ;
                %r=r+1;Time(r)=Time(r-1)+tJ;
                %Y(r,:)=Amplitude(rM,SOs);                            
            end                         
            Y=Amplitudes(rM,SOs);                            
        end
        function [Time, Y, rM]=S2M(obj,S,ChSh,Jij,B0,tJ,n2,nuc,SOs)
            %Tayler Levitt DOI: 10.1039/c0cp02293d
            n1=n2*2;
            Time=zeros(4+3*n1+3*n2-1,1);
            %Y=zeros(4+3*n1+3*n2-1,length(SOs));
            rM=obj;
            H0=2*pi*HZJij(S,ChSh,Jij,B0);
            Q=expm(-1i*H0*tJ);
            iQ=expm(1i*H0*tJ);
            %r=0;
            %1  
            %r=r+1;Time(r)=0;            
            %Y(r,:)=Amplitudes(rM,SOs);            
            
            %3 tJ-(90_0 180_90 90_0)_f,  f={0 0 180? 180?...}
            DIR{1}={'X' 'Y' 'X'};DIR{2}={'X' 'Y' 'X'};
            DIR{3}={'X' 'Y' 'X'};DIR{4}={'X' 'Y' 'X'};
            %DIR{3}={'-X' '-Y' '-X'};%DIR{4}={'-X' '-Y' '-X'};
            %mod(in2-1,4)+1
            for in2=1:n2                
                rM.val=Q*rM.val*iQ;
                %r=r+1;Time(r)=Time(r-1)+tJ;                
                %Y(r,:)=Amplitudes(rM,SOs);
                
                rM=rM.RotationSuperOperator(pi/2,DIR{1}{1},S,nuc);
                rM=rM.RotationSuperOperator(pi,  DIR{1}{2},S,nuc);
                rM=rM.RotationSuperOperator(pi/2,DIR{1}{3},S,nuc);
                %r=r+1;Time(r)=Time(r-1);
                %Y(r,:)=Amplitudes(rM,SOs);                
                
                rM.val=Q*rM.val*iQ;
                %r=r+1;Time(r)=Time(r-1)+tJ;                
                %Y(r,:)=Amplitudes(rM,SOs);                
            end 
            rM.val=Q*rM.val*iQ;
            %r=r+1;Time(r)=Time(r-1)+tJ;            
            %Y(r,:)=Amplitudes(rM,SOs); 
            
            rM=rM.RotationSuperOperator(pi/2,'X',S,nuc);
            %r=r+1;Time(r)=Time(r-1);            
            %Y(r,:)=Amplitudes(rM,SOs);            
            
            for in1=1:n1                
                rM.val=Q*rM.val*iQ;
                %r=r+1;Time(r)=Time(r-1)+tJ;                
                %Y(r,:)=Amplitudes(rM,SOs); 
                
                rM=rM.RotationSuperOperator(pi/2,DIR{1}{1},S,nuc);
                rM=rM.RotationSuperOperator(pi,  DIR{1}{2},S,nuc);
                rM=rM.RotationSuperOperator(pi/2,DIR{1}{3},S,nuc);
                %r=r+1;Time(r)=Time(r-1);
                %Y(r,:)=Amplitudes(rM,SOs);
                
                rM.val=Q*rM.val*iQ;
                %r=r+1;Time(r)=Time(r-1)+tJ;                
                %Y(r,:)=Amplitudes(rM,SOs);                
            end                                
            rM=rM.RotationSuperOperator(pi/2,'Y',S,nuc);
            Y=Amplitudes(rM,SOs);                
        end 
        
        
        
        function [Time, Y, rM]=ADAPT(obj,S,ChSh,Jij,B0,ppmrf,a,da,m,nuc,SOs)
            Time=zeros(1+m*2,1);
            Y=zeros(1+m*2,length(SOs));
            rM=obj;
            %H0=2*pi*HZJij(S,ChSh,Jij,B0);
            H0=2*pi*HZJij_RF1(S,ChSh,Jij,B0,0,ppmrf,'X',nuc);
            Q=expm(-1i*H0*da);
            iQ=expm(1i*H0*da);
            r=0;
            %1  
            r=r+1;Time(r)=0;
            for in=1:length(SOs)%measure
               Y(r,in)=Amplitude(rM,SOs{in});
            end
            
            for im=1:m                
                rM=rM.RotationSuperOperator(a,'X',S,nuc);
                r=r+1;Time(r)=Time(r-1);
                for in=1:length(SOs)%measure
                   Y(r,in)=Amplitude(rM,SOs{in});
                end                
                rM.val=Q*rM.val*iQ;
                r=r+1;Time(r)=Time(r-1)+da;
                Y(r,:)=Amplitudes(rM,SOs);                
            end
            
            
            
            
        end
        
%         function [Time,Y,r2]=T00_filterGPG(obj,H0,NGr,G1,t1,angle,ph,nuc,G2,t2,S,SOs) %wrong    correction is requared                
%             
%             G1=linspace(-G1/2,G1/2,NGr);      
%             G2=linspace(-G2/2,G2/2,NGr);      
%             
%             r2=obj;
%             r2.val=r2.val*0;     
%             Y=zeros(length(t1)+length(t2),length(SOs)); 
%             
%             
%             for ig=1:NGr
%                 [Time1,Y1,r]=obj.EvolutionConstHG(H0,G1(ig),t1,S,SOs);
%                 r=r.RotationSuperOperator(angle,ph,S,nuc);
%                 [Time2,Y2,r]=  r.EvolutionConstHG(H0,G2(ig),t2,S,SOs);
%                 r2.val=r2.val+r.val/NGr;
%                 Y=Y+[Y1; Y2]/NGr;
%             end            
%             
%             Time=collectX(Time1,Time2); 
%                                      
%         end
%         
%         
%         function [Time,Y,r2]=T00_filterGPGPPG(obj,H0,NGr,G1,t1,G2,t2,G3,t3,nuc,S,SOs)  %wrong    correction is requared              
%             G1=linspace(-G1/2,G1/2,NGr);   % tesla   
%             G2=linspace(-G2/2,G2/2,NGr);   % tesla
%             G3=linspace(-G3/2,G3/2,NGr);   % tesla
%             
%             r2=obj;
%             r2.val=r2.val*0;     
%             Y=zeros(length(t1)+length(t2)+length(t3),length(SOs));
%             
%             for ig=1:NGr                       
%                 [Time1,Y1,r]=obj.EvolutionConstHG(H0,G1(ig),t1,S,SOs);
%             r=r.RotationSuperOperator(pi/2,'Y',S,nuc);
%                 [Time2,Y2,r]=r.EvolutionConstHG(H0,G2(ig),t2,S,SOs);
%             r=r.RotationSuperOperator(pi/2,atan(sqrt(2)),S,nuc);
%             r=r.RotationSuperOperator(pi/2,'-X',S,nuc);
%                 [Time3,Y3,r]=r.EvolutionConstHG(H0,G3(ig),t3,S,SOs);
%                 
%                 r2.val=r2.val+r.val/NGr;
%                 Y=Y+[Y1; Y2; Y3]/NGr;
%             end            
%             Time=collectX(Time1,Time2,Time3);                                       
%         end 
        
        function [Time,GAF_T,Y,rM]=EvolutionRF1V1(obj,S,B0,ChSh,Jij,T,v1,ppmrf,RF_nuc,dir,SOs)
            %tic            
            rM=obj;
            Time=linspace(0,T,length(v1))';
            GAF_T=Time*0;
            dt=Time(2)-Time(1);            
            Y=zeros(length(v1),length(SOs));
            Irf=S.Dir(dir,RF_nuc);            
            H0=HZJij_RF1(S,ChSh,Jij,B0,0,ppmrf,dir,RF_nuc);
            
            H=2*pi*(-Irf*v1(1)+H0);                
            rM.val=expm(-1i*H*dt)*rM.val*expm(1i*H*dt);
            for in=1:length(SOs)
               Y(1,in)=Amplitude(rM,SOs{in});
            end
            
            for iv1=2:length(v1)        
                H=2*pi*(-Irf*v1(iv1)+H0);                
                rM.val=expm(-1i*H*dt)*rM.val*expm(1i*H*dt);
                for in=1:length(SOs)
                   Y(iv1,in)=Amplitude(rM,SOs{in});
                end
                
                [Q, E]=eig(full(H/(2*pi)));         
                QVQ=(v1(iv1)-v1(iv1-1))*(Q'*(Irf)*Q)/(dt*2*pi);
                E=diag(E);
                qcurrent=0;
                for in=1:length(E)-1
                    for im=in+1:length(E)
                        if abs(E(in)-E(im))>0.01
                            qcurrent=qcurrent+(abs(QVQ(in,im))/((E(in)-E(im))^2+0.00001*0))^2;
                        end
                    end
                end
                GAF_T(iv1)=qcurrent^0.5;                
            end
            %toc
        end                             
        function [Time,GAF_T,Y,rM]=EvolutionRF1VRF(obj,S,B0,ChSh,Jij,T,v1,ppmrf,RF_nuc,dir,SOs)
            tic
            rM=obj;
            Time=linspace(0,T,length(ppmrf))';
            GAF_T=Time*0;
            dt=Time(2)-Time(1);
            Y=zeros(length(ppmrf),length(SOs));
            Irf=S.Dir('Z',RF_nuc);            
            H0=HZJij_RF1(S,ChSh,Jij,B0,v1,0,dir,RF_nuc);
            freq=B0*S.g_gh{RF_nuc(1)}*S.gH/(2*pi);
            
            H=2*pi*(Irf*ppmrf(1)*freq+H0);                 
            rM.val=expm(-1i*H*dt)*rM.val*expm(1i*H*dt);
            for in=1:length(SOs)
                Y(1,in)=Amplitude(rM,SOs{in});
            end
            
            for ivrf=2:length(ppmrf)        
                H=2*pi*(Irf*ppmrf(ivrf)*freq+H0);                 
                rM.val=expm(-1i*H*dt)*rM.val*expm(1i*H*dt);
                for in=1:length(SOs)
                    Y(ivrf,in)=Amplitude(rM,SOs{in});
                end
                
                [Q, E]=eig(full(H/(2*pi)));
                QVQ=freq*(ppmrf(nt)-ppmrf(nt-1))*(Q'*(Irf)*Q)/(dt*2*pi);
                E=diag(E);
                qcurrent=0;
                for in=1:length(E)-1
                    for im=in+1:length(E)
                        if abs(E(in)-E(im))>0.01
                            qcurrent=qcurrent+(abs(QVQ(in,im))/((E(in)-E(im))^2+0.00001))^2;
                        end
                    end
                end
                GAF_T(iv1)=qcurrent^0.5;
            end                                    
            toc
        end
        function [Time,GAF_T,Y,rM]=EvolutionRF1V1VRF(obj,S,B0,ChSh,Jij,T,v1,ppmrf,RF_nuc,dir,SOs)
            tic
            rM=obj;
            if length(v1)~=length(ppmrf)
                error('length of v1 is not equial to length of ppmrf!');
            end
            Time=linspace(0,T,length(ppmrf))';
            GAF_T=Time*0;
            dt=Time(2)-Time(1);
            Y=zeros(length(ppmrf),length(SOs));
            IrfZ=S.Dir('Z',RF_nuc);
            Irft=S.Dir(dir,RF_nuc);
            H0=HZJij_RF1(S,ChSh,Jij,B0,0,0,dir,RF_nuc);
            freq=B0*S.g_gh{RF_nuc(1)}*S.gH/(2*pi);
            
            H=2*pi*(-Irft*v1(1)+IrfZ*ppmrf(1)*freq+H0);                 
            rM.val=expm(-1i*H*dt)*rM.val*expm(1i*H*dt);
            for in=1:length(SOs)
                Y(1,in)=Amplitude(rM,SOs{in});
            end
            
            for iv=2:length(ppmrf)        
                H=2*pi*(-Irft*v1(iv)+IrfZ*ppmrf(iv)*freq+H0);                 
                rM.val=expm(-1i*H*dt)*rM.val*expm(1i*H*dt);
                for in=1:length(SOs)
                    Y(iv,in)=Amplitude(rM,SOs{in});
                end
                
                [Q, E]=eig(full(H/(2*pi)));
                QVQ=freq*(ppmrf(iv)-ppmrf(iv-1))*(Q'*(IrfZ)*Q)/(dt*2*pi)+...
                    (v1(iv-1)-v1(iv))*(Q'*(Irft)*Q)/(dt*2*pi);
                E=diag(E);
                qcurrent=0;
                for in=1:length(E)-1
                    for im=in+1:length(E)
                        if abs(E(in)-E(im))>0.01
                            qcurrent=qcurrent+(abs(QVQ(in,im))/((E(in)-E(im))^2+0.00001))^2;
                        end
                    end
                end
                GAF_T(iv)=qcurrent^0.5;
            end            
            toc
        end        
        function [Time,ppmrf,GAF_T,Y,rM]=EvolutionRF1GAFVRF(obj,S,B0,ChSh,Jij,T,v1,ppmrf,nuc,dir,GAF,SOs)
            tic  
            [n1, n2]=size(ppmrf);
            if n1==1
                ppmrf=ppmrf';
            end
            rM=obj;
            Np=length(ppmrf);
            Time=linspace(0,T,Np)';
            dt=Time(2)-Time(1);            
            dtFP=dt*1i*2*pi;
            dppmmax=ppmrf(end)-ppmrf(1);
            ppmF=ppmrf(end);
            dppm0=dppmmax/Np; 
            D=sign(dppmmax);
            Y=zeros(Np,length(SOs));
            GAF_T=zeros(Np,1);    
            
            IrfZ=S.Dir('Z',nuc);
            H0=HZJij_RF1(S,ChSh,Jij,B0,v1,0,dir,nuc);
            freq=B0*S.g_gh{nuc(1)}*S.gH/(2*pi); 
            
            HF=(IrfZ*ppmF*freq+H0);
            [QF, EF]=eig(full(HF));
            
            exp_2piminusH=1;
            for in=1:length(SOs)
                Y(1,in)=Amplitude(obj,SOs{in});
            end             
            for nt=2:Np
                nt
                ppmrf(nt)               
                ppmrf(nt)=ppmrf(nt-1);    
                qcurrent=0;
                dppm=dppm0;                
                state=0;
                precision0=0.0001;
                precision=precision0;
                Cprec=1; 
                err=0;
                goout=0;
                while (GAF/(1+precision)>qcurrent || GAF*(1+precision)<qcurrent) && (goout==0) && (err==0)
                    if D*(ppmF-ppmrf(nt))>0
                        Cprec=Cprec+1;
                        precision=precision0*(1+Cprec-mod(Cprec,25))/25;        
                        ppmrf(nt)=ppmrf(nt)+dppm;
                        if precision>0.5
                            goout=1
                            ppmrf(nt)=ppmrf(nt-1);
                        end
                        H=(IrfZ*ppmrf(nt)*freq+H0);
                        [Q, E]=eig(full(H));         
                        QVQ=freq*(ppmrf(nt)-ppmrf(nt-1))*(Q'*(IrfZ)*Q)/(dt*2*pi);
                        E=diag(E);
                        qcurrent=0;
                        for in=1:length(E)-1
                            for im=in+1:length(E)
                                if abs(E(in)-E(im))>0.01
                                    qcurrent=qcurrent+(abs(QVQ(in,im))/((E(in)-E(im))^2+0.00001))^2;
                                end
                            end
                        end
                        qcurrent=qcurrent^0.5;
                        if GAF<qcurrent && state==0
                            dppm=-dppm/2;          
                            state=1;                     
                        elseif GAF>qcurrent && state==1
                            dppm=-dppm/2;
                            state=0;
                        end
                        if abs(dppm)<1e-30
                            qcurrent            
                            err=1;
                            plot(ppmrf*1e6);
                            stop
                        end
                    else                                                
                        QVQ=freq*(ppmF-ppmrf(nt-1))*(QF'*(IrfZ)*QF)/(dt*2*pi);
                        qcurrent=0; 
                        for in=1:length(EF)-1
                            for im=in+1:length(EF)
                                if abs(EF(in)-EF(im))>0.01
                                    qcurrent=qcurrent+(abs(QVQ(in,im))/((EF(in)-EF(im))^2+0.00001))^2;
                                end
                            end
                        end
                        qcurrent=qcurrent^0.5;
                        if GAF>qcurrent
                            ppmrf(nt)=ppmF;
                            goout=1;
                        else
                            ppmrf(nt)=ppmrf(nt-1);                            
                        end
                    end
                end
                dppm0=D*0.5*abs(ppmrf(nt)-ppmrf(nt-1));
                exp_2piminusH=expm(-dtFP*H)*exp_2piminusH;
                GAF_T(nt)=qcurrent;
                rM.val=exp_2piminusH*(obj.val)/exp_2piminusH;
                for in=1:length(SOs)
                   Y(nt,in)=Amplitude(rM,SOs{in});
                end               
            end 
            toc                                                                                   
        end
        function [Time,v1,GAF_T,Y,rM]=   EvolutionRF1GAFV1 (obj,S,B0,ChSh,Jij,T,v1,ppmrf,nuc,dir,GAF,SOs)
            tic
            [n1, n2]=size(v1);
            if n1==1
                v1=v1';
            end
            rM=obj;
            Np=length(v1);
            Time=linspace(0,T,Np)';
            dt=Time(2)-Time(1);            
            dtFP=dt*1i*2*pi;
            dv1max=v1(end)-v1(1);
            v1F=v1(end);
            dv10=dv1max/100;
            D=sign(dv1max);
            Y=zeros(Np,length(SOs));
            GAF_T=zeros(Np,1);
            
            Irf=S.Dir(dir,nuc);            
            H0=HZJij_RF1(S,ChSh,Jij,B0,0,ppmrf,dir,nuc);
                                                                       
            HF=-Irf*v1F+H0;
            [QF, EF]=eig(full(HF));
            
            exp_2piminusH=1;            
            for in=1:length(SOs)
                Y(1,in)=Amplitude(obj,SOs{in});
            end 
            for nt=2:Np
                %nt
                %v1(nt)
                v1(nt)=v1(nt-1);    
                qcurrent=0;
                dv1=dv10;
                state=0;                    
                precision0=0.0001;
                precision=precision0;
                Cprec=1;
                err=0;
                goout=0;
                while (GAF/(1+precision)>qcurrent || GAF*(1+precision)<qcurrent) && (goout==0) && (err==0)                    
                    if D*(v1F-v1(nt))>0
                        Cprec=Cprec+1;
                        precision=precision0*(1+Cprec-mod(Cprec,25))/25;        
                        v1(nt)=v1(nt)+dv1;
                        if precision>0.5
                            goout=1;
                            v1(nt)=v1(nt-1);
                        end
                        H=-Irf*v1(nt)+H0;
                        [Q, E]=eig(full(H));         
                        QVQ=(v1(nt)-v1(nt-1))*(Q'*(Irf)*Q)/(dt*2*pi);
                        E=diag(E);
                        qcurrent=0;
                        for in=1:length(E)-1
                            for im=in+1:length(E)
                                if abs(E(in)-E(im))>0.01
                                    qcurrent=qcurrent+(abs(QVQ(in,im))/((E(in)-E(im))^2+0.00001))^2;
                                end
                            end
                        end
                        qcurrent=qcurrent^0.5;
                        if GAF<qcurrent && state==0
                            dv1=-dv1/2;          
                            state=1;                     
                        elseif GAF>qcurrent && state==1
                            dv1=-dv1/2;
                            state=0;
                        end
                        if abs(dv1)<1e-20
                            qcurrent            
                            err=1;
                            plot(v1);
                            stop
                        end
                    else                        
                        QVQ=(v1F-v1(nt-1))*(QF'*(Irf)*QF)/(dt*2*pi);                        
                        qcurrent=0;
                        for in=1:length(EF)-1
                            for im=in+1:length(EF)
                                if abs(EF(in)-EF(im))>0.01
                                    qcurrent=qcurrent+(abs(QVQ(in,im))/((EF(in)-EF(im))^2+0.00001))^2;
                                end
                            end
                        end
                        qcurrent=qcurrent^0.5;
                        if GAF>qcurrent
                            v1(nt)=v1F;
                            goout=1;
                        else
                            v1(nt)=v1(nt-1);                            
                        end
                    end
                end
                dv10=D*0.5*abs(v1(nt)-v1(nt-1));
                exp_2piminusH=expm(-dtFP*H)*exp_2piminusH;
                GAF_T(nt)=qcurrent;
                rM.val=exp_2piminusH*(obj.val)/exp_2piminusH;
                for in=1:length(SOs)
                   Y(nt,in)=Amplitude(rM,SOs{in});
                end               
            end 
            toc            
        end
       
        function [GAF] = myGAF_value(obj,E,QVQ)
            GAF=0;
            for in=1:length(E)-1
                for im=in+1:length(E)
                    if abs(E(in)-E(im))>0.01
                        GAF=GAF+(abs(QVQ(in,im))/((E(in)-E(im))^2+0.00001))^2;
                    end
                end
            end
            GAF=GAF^0.5;
        end
        
%         function [Time,Btr,GAF_T,Y,rM]=EvolutionFDGAFB(obj,S,ChSh,Jij,T,Btr,GAF,SOs)
%             tic
%             [n1, n2]=size(Btr);
%             if n1==1
%                 Btr=Btr';
%             end
%             rM=obj;
%             Np=length(Btr);
%             Time=linspace(0,T,Np)';
%             dt=Time(2)-Time(1);            
%             dtFP=dt*1i*2*pi;
%             dBmax=Btr(end)-Btr(1);
%             BF=Btr(end);
%             dB0=dBmax/100;           
%             Y=zeros(Np,length(SOs));
%             GAF_T=zeros(Np,1);
%                                  
%             H0=HZJij(S,ChSh,Jij,0);
%             Iz=0;
%             for in=1:S.N
%                Iz=Iz-(1+ChSh(in))*S.g_gh{in}*S.z{in}; 
%             end
%             Iz=Iz*S.gH/(2*pi); 
%             
%             
%             
%             HF=Iz*BF+H0;
%             [QF, EF]=eig(full(HF));
%             
%             exp_2piminusH=1;            
%             for in=1:length(SOs)
%                 Y(1,in)=Amplitude(obj,SOs{in});
%             end 
%             
%             for nt=2:Np
%                 %nt
%                 %v1(nt)
%                 Btr(nt)=Btr(nt-1);    
%                 qcurrent=0;
%                 dB=dB0;
%                 state=0;                    
%                 precision0=0.001;
%                 precision=precision0;
%                 Cprec=1;
%                 err=0;
%                 goout=0;
%                 while (GAF*(1-precision)>qcurrent || GAF*(1+precision)<qcurrent) && (goout==0) && (err==0)                    
%                     if (BF-Btr(nt))>0
%                         Cprec=Cprec+1;
%                         precision=precision0*(1+Cprec/100);        
%                         Btr(nt)=Btr(nt)+dB;
%                         if precision>0.5
%                             goout=1;
%                             Btr(nt)=Btr(nt-1)+1e-9;
%                         end
%                         H=Iz*Btr(nt)+H0;
%                         [Q, E]=eig(full(H));         
%                         QVQ=(Btr(nt)-Btr(nt-1))*(Q'*(Iz)*Q)/(dt*2*pi);
%                                                                    
%                         qcurrent=obj.myGAF_value(diag(E),QVQ);
%                                                 
%                         if GAF<qcurrent && state==0
%                             dB=-dB/3;          
%                             state=1;                     
%                         elseif GAF>qcurrent && state==1
%                             dB=-dB/3;
%                             state=0;
%                         end
%                         if abs(dB)<1e-11
%                             if (Btr(nt)-Btr(nt-1))>1e-10
%                                 Btr(nt)=Btr(nt);
%                             else
%                                Btr(nt)=Btr(nt-1)+1e-10; 
%                             end
%                         end
%                     else                        
%                         QVQ=(BF-Btr(nt-1))*(QF'*(Iz)*QF)/(dt*2*pi);                        
%                         qcurrent=obj.myGAF_value(diag(E),QVQ);
%                         
%                         if GAF>qcurrent
%                             Btr(nt)=BF;
%                             goout=1;
%                         else
%                             Btr(nt)=Btr(nt-1)+1e-9;                            
%                         end
%                     end
%                 end
%                 dB0=0.5*abs(Btr(nt)-Btr(nt-1));
%                 exp_2piminusH=expm(-dtFP*H)*exp_2piminusH;
%                 GAF_T(nt)=qcurrent;
%                 rM.val=exp_2piminusH*(obj.val)/exp_2piminusH;                 
%                 Y(nt,:)=Amplitudes(rM,SOs);                
%             end 
%             toc            
%         end
        
        
        function [Time,Btr,GAF_T,Y,rM]=EvolutionFDGAFBstraight(obj,S,ChSh,Jij,T,Btr,GAF,SOs,dB)
            tic
            [n1, n2]=size(Btr);
            if n1==1
                Btr=Btr';
            end
            rM=obj;
            Np=length(Btr);
            Time=linspace(0,T,Np)';
            dt=Time(2)-Time(1);            
            dtFP=dt*1i*2*pi;
            %dBmax=Btr(end)-Btr(1);
            BF=Btr(end);
            %dB=dBmax/10000;           
            Y=zeros(Np,length(SOs));
            GAF_T=zeros(Np,1);
                                 
            H0=HZJij(S,ChSh,Jij,0);
            Iz=0;
            for in=1:S.N
               Iz=Iz-(1+ChSh(in))*S.g_gh{in}*S.z{in}; 
            end
            Iz=Iz*S.gH/(2*pi);                                     
            %HF=Iz*BF+H0;
            %[QF, EF]=eig(full(HF));
            
            exp_2piminusH=1;                        
            Y(1,:)=Amplitudes(obj,SOs);                        
            for nt=2:Np
                nt
                %v1(nt)
                Btr(nt)=Btr(nt-1);    
                qcurrent=0;                                                
                if Btr(nt)<BF
                    while (qcurrent<GAF) && (Btr(nt)<BF)
                        Btr(nt)=Btr(nt)+dB; 
                        if Btr(nt)>BF
                            Btr(nt)=BF;                                                                                                                        
                        end                                                    
                        [Q, E]=eig(full(Iz*Btr(nt)+H0));         
                        QVQ=(Btr(nt)-Btr(nt-1))*(Q'*(Iz)*Q)/(dt*2*pi);                                                                   
                        qcurrent=obj.myGAF_value(diag(E),QVQ);                        
                    end 
                else                    
                    qcurrent=0;
                end
                
                exp_2piminusH=expm(-dtFP*(Iz*Btr(nt)+H0))*exp_2piminusH;
                GAF_T(nt)=qcurrent;
                rM.val=exp_2piminusH*(obj.val)/exp_2piminusH;                 
                Y(nt,:)=Amplitudes(rM,SOs);                
            end 
            toc            
        end
        

        
        
        function [Time, Yts, Ytc, rS, rC, A]=SABRE_MOD2(rS, Ss,Hs,RsS,SOs, rC,Sc,Hc,RsC,SOc, Sh, t,fpH,Wa,Kd)
            [n1,n2]=size(t);
            if n2>n1
               Time=t'; 
            else
               Time=t;
            end
            Yts=zeros(length(t),length(SOs));
            Ytc=zeros(length(t),length(SOc));
            
            NS2=Ss.Nstates^2;
            NC2=Sc.Nstates^2;
            K=Wa/Kd;
            fs=1/(1+K);
            fc=K/(1+K);
            rS.val=fs*rS.val/trace(rS.val);
            rC.val=fc*rC.val/trace(rC.val);
            vecS0=mtz2vec(rS.val);
            vecC0=mtz2vec(rC.val);
            vec0=[vecS0' vecC0']';
                                   
            rpH=DensityMatrix('100%_SingletSpinOrder',Sh,1,2);
            %rpH=DensityMatrix(Sh.U-Sh.SSnorm(1,2));
            %rpH=DensityMatrix(Sh.U-Sh.SSzznorm(1,2));
            foH=1-fpH;
            rpH.val=(fpH-foH/3)*rpH.val+(foH/3)*(Sh.U*4);            
                        
            Dir=KronSuper(rpH.val,Sh.Nstates,Ss.Nstates);
            Tr=TraceSuper(Sh.Nstates,Ss.Nstates);
                        
            Ls=-1i*H2Super(Hs)+RsS;
            Lc=-1i*H2Super(Hc)+RsC;
            UsS=Ss.UnitySuper();
            UsC=Sc.UnitySuper();
            
            A=zeros(NS2+NC2);
            A(1:NS2,1:NS2)=Ls-Wa*UsS;
            A(NS2+1:NS2+NC2,NS2+1:NS2+NC2)=Lc-Kd*UsC;
            A(NS2+1:NS2+NC2,1:NS2)=Wa*Dir;
            A(1:NS2,NS2+1:NS2+NC2)=Kd*Tr;
            for it=1:length(t)

                vec=expm(A*t(it))*vec0;             
                rS.val=vec2mtz(vec(1:NS2));
                rC.val=vec2mtz(vec(NS2+1:NS2+NC2));                
                Yts(it,:)=Amplitudes(rS,SOs);                                
                Ytc(it,:)=Amplitudes(rC,SOc);
            end
            Yts=Yts/fs;
            Ytc=Ytc/fc;
            rS.val=rS.val/fs;
            rC.val=rC.val/fc;                
        end
        
        function [Time,   YA, YB,  rA, rB]=ExchangeAB(rA,HA,RsA,SOA,rB,HB,RsB,SOB,S,t,Kab,Kba)
            [n1,n2]=size(t);
            if n2>n1
               Time=t'; 
            else
               Time=t;
            end
            YA=zeros(length(t),length(SOA));
            YB=zeros(length(t),length(SOB));
            
            Ns=S.Nstates^2;                        
            
            K=Kba/Kab;
            fA=1/(1+1/K);
            fB=1/(1+K);
            rA.val=fA*rA.val/trace(rA.val);
            rB.val=fB*rB.val/trace(rB.val);
            vecA0=mtz2vec(rA.val);
            vecB0=mtz2vec(rB.val);
            vec0=[vecA0' vecB0']';                                               
                        
            LA=-1i*H2Super(HA)+RsA;
            LB=-1i*H2Super(HB)+RsB;
            Us=S.UnitySuper();            
            
            M=zeros(2*Ns);
            M(1:Ns,1:Ns)=LA-Kab*Us;
            M(Ns+1:end,Ns+1:end)=LB-Kba*Us;
            M(Ns+1:end,1:Ns)=Kab*Us;
            M(1:Ns,Ns+1:end)=Kba*Us;
            
            %temp=zeros(length(t),1);
            for it=1:length(t)
                vec=expm(M*t(it))*vec0;
                rA.val=vec2mtz(vec(1:Ns));
                rB.val=vec2mtz(vec(Ns+1:end));                
                YA(it,:)=Amplitudes(rA,SOA);                                
                YB(it,:)=Amplitudes(rB,SOB);                
            end
            YA=YA/fA;
            YB=YB/fB;
            rA.val=rA.val/fA;
            rB.val=rB.val/fB;
        end
        
        function [Time, Y_s,Y_c,Y_c1,Y_h, rs,rc,rc1,rh]=SABRE_CAP_const(rs,Ss,Hs,Rs,SOs, rc,Sc,Hc,Rc,SOc, rc1,Sc1,Hc1,Rc1,SOc1, rh,Sh,Hh,Rh,SOh, CAP,t)
            %EE, FF and GG operators are realised only for S=single nuclei 1/2
            %correct if necessary
            CAP.checkTime=1; % SABRE_CAP calculation scheme 0 or 1
            CAP.checkTrace=1; % SABRE_CAP calculation scheme 0 or 1
            CAP.scheme=1;
            
            % transformation of time vector
            [n1,n2]=size(t);
            if n2>n1
               Time=t'; 
            else
               Time=t;
            end
            if length(Time)==1
               Time=[0; Time];
            end
             
            if CAP.checkTrace==1
                devMax=1+0.001; devMin=1-0.001;
                if trace(rs.val)>devMax ||  trace(rs.val)<devMin
                    error('trace(rs)!=1');
                end
                if trace(rc.val)>devMax ||  trace(rc.val)<devMin
                    error('trace(rc)!=1');
                end
                if trace(rc1.val)>devMax || trace(rc1.val)<devMin
                    error('trace(rc1)!=1');
                end
                if trace(rh.val)>devMax ||  trace(rh.val)<devMin
                    error('trace(rh)!=1');
                end            
            end                     
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %calculate concentration of IrH2SaSe2, IrH2SaSe, and S in the solution
            a=1;
            b=CAP.kd/CAP.ka-CAP.S0+3*CAP.Ir0;
            c=(2*CAP.Ir0-CAP.S0)*CAP.kd/CAP.ka;
            if c>0
               error('[S]<[Ir]');
            end
            D=b^2-4*a*c;
            CAP.S =(-b+sqrt(D))/(2*a); %S12=(-b-sqrt(D))/(2*a)
            CAP.c1=CAP.Ir0/(1+CAP.ka*CAP.S/CAP.kd); 
            CAP.c =CAP.Ir0-CAP.c1; 
            %CAP              
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %size of superoperators            
            Ns_2 =Ss .Nstates^2;
            Nc_2 =Sc .Nstates^2;
            Nc1_2=Sc1.Nstates^2;
            Nh_2 =Sh .Nstates^2;
            CAP.Nstates_S=Ss  .Nstates;
            CAP.Nstates_c=Sc  .Nstates;
            CAP.Nstates_c1=Sc1.Nstates;
            CAP.Nstates_h=Sh  .Nstates;
            CAP.Ns_2=Ns_2;
            CAP.Nc_2=Nc_2;
            CAP.Nc1_2=Nc1_2;
            CAP.Nh_2=Nh_2;                                         
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %check time step
            Rates=[CAP.ka*CAP.c1;
                   CAP.kd;
                   CAP.kex*CAP.H2+CAP.ka*CAP.S;
                   CAP.Wout+CAP.kex*CAP.c1;
                   CAP.ka*CAP.S
                   CAP.kex*CAP.c1];               
            dt_max=1/max(Rates);
            dt=Time(2)-Time(1);
            if CAP.checkTime==1
                if dt>dt_max/5
                   dt
                   dt_max
                   dt_max/5
                   error('dt is too long'); 
                end
            end
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%                        
            %pH2 density matrix
            rpH2=DensityMatrix('100%_SingletSpinOrder',Sh,1,2);
            CAP.foH=1-CAP.fpH;
            rpH2.val=(CAP.fpH-CAP.foH/3)*rpH2.val+(CAP.foH/3)*(Sh.U*4);   
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %force normalization
            rs.val =rs.val /trace(rs.val);
            rc.val =rc.val /trace(rc.val);            
            rc1.val=rc1.val/trace(rc1.val);
            rh.val =rh.val /trace(rh.val);            
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%                        
            %matrices to vectors
            v_s =mtz2vec(rs.  val);            
            v_c =mtz2vec(rc.  val);
            v_c1=mtz2vec(rc1. val);
            v_h =mtz2vec(rh.  val);            
            v_pH=mtz2vec(rpH2.val);            
            v=[v_s; v_c; v_c1; v_h];
            y0=[0*v_s; 0*v_c; 0*v_c1; CAP.Wout*v_pH];            
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%            
            AA = -1i*H2Super(Hs) +Rs - CAP.ka*CAP.c1*Ss. UnitySuper(); 
            BB = -1i*H2Super(Hc) +Rc - CAP.kd*Sc. UnitySuper();
            CC = -1i*H2Super(Hc1)+Rc1-(CAP.kex*CAP.H2+CAP.ka*CAP.S)*Sc1.UnitySuper();
            DD = -1i*H2Super(Hh) +Rh-(CAP.Wout+CAP.kex*CAP.c1)*Sh.UnitySuper();
            
            EE = (TraceSuper1(1,2^2)+TraceSuper1(2,2^2))*TraceSuper1(1,2^3)*TraceSuper1(1,2^4)*CAP.ka*CAP.c1/2;            
            FF = 0.5*(TraceSuper1(3,2^4)+TraceSuper1(4,2^4))*CAP.ka*CAP.S;
            GG = TraceSuper1(3,2^3)*CAP.kex*CAP.c1;          
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            AAA=zeros(Ns_2+Nc_2+Nc1_2+Nh_2);
            x0=1;                 x1=Ns_2;
            AAA(x0:x1,x0:x1)=AA;
            x0=1+Ns_2;            x1=Ns_2+Nc_2;
            AAA(x0:x1,x0:x1)=BB;
            x0=1+Ns_2+Nc_2;       x1=Ns_2+Nc_2+Nc1_2;
            AAA(x0:x1,x0:x1)=CC;
            x0=1+Ns_2+Nc_2+Nc1_2; x1=Ns_2+Nc_2+Nc1_2+Nh_2;
            AAA(x0:x1,x0:x1)=DD;                                    
            AAA(1:Ns_2,1+Ns_2:Ns_2+Nc_2)=EE;
            AAA(1+Ns_2+Nc_2:Ns_2+Nc_2+Nc1_2,1+Ns_2:Ns_2+Nc_2)=FF;
            AAA(1+Ns_2+Nc_2+Nc1_2:Ns_2+Nc_2+Nc1_2+Nh_2,1+Ns_2+Nc_2:Ns_2+Nc_2+Nc1_2)=GG;            
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%                                    
            
            
            if CAP.scheme==0 %zero order differential scheme of solving diff equation
                n2=length(Time);
                Y_s =zeros(n2,length(SOs ));
                Y_c =zeros(n2,length(SOc ));
                Y_c1=zeros(n2,length(SOc1));
                Y_h =zeros(n2,length(SOh ));                                
                Y=v;
                rs. val=vec2mtz(Y(1:Ns_2));
                rc. val=vec2mtz(Y(Ns_2+1:Ns_2+Nc_2));                
                rc1.val=vec2mtz(Y(Ns_2+Nc_2+1:Ns_2+Nc_2+Nc1_2));
                rh. val=vec2mtz(Y(Ns_2+Nc_2+Nc1_2+1:Ns_2+Nc_2+Nc1_2+Nh_2));
                Y_s (1,:)=Amplitudes(rs ,SOs);                                
                Y_c (1,:)=Amplitudes(rc ,SOc);                                
                Y_c1(1,:)=Amplitudes(rc1,SOc1);                                
                Y_h (1,:)=Amplitudes(rh ,SOh);
                ind=0;                
            for it=2:length(Time)                            
                NL=SABRE_CAP_NL(Y,CAP);                
                Y=(AAA*Y+NL+y0)*dt+Y;                                
                [row, col] = find(isnan(Y));
                if ~isempty(row)                                       
                   error(sprintf('error NAN value is found, index=%.0d, Time(index)=%.4f',[it, Time(it)]))
                end
                if ind~=fix(it/1000)
                    ind=fix(it/1000);
                    it
                end
                rs. val=vec2mtz(Y(1:Ns_2));
                rc. val=vec2mtz(Y(Ns_2+1:Ns_2+Nc_2));                
                rc1.val=vec2mtz(Y(Ns_2+Nc_2+1:Ns_2+Nc_2+Nc1_2));
                rh. val=vec2mtz(Y(Ns_2+Nc_2+Nc1_2+1:Ns_2+Nc_2+Nc1_2+Nh_2));
                Y_s (it,:)=Amplitudes(rs ,SOs);                                
                Y_c (it,:)=Amplitudes(rc ,SOc);                                
                Y_c1(it,:)=Amplitudes(rc1,SOc1);                                
                Y_h (it,:)=Amplitudes(rh ,SOh);
            end
            
            elseif CAP.scheme==1 %solve equation with one of the matlab diff sol functions (here ode45)
                [Time0,Yout]=ode45(@(t,Y)SABRE_CAP_sol(t,Y,AAA,y0,CAP),Time,v); 
                Yout=Yout';
                [row, col] = find(isnan(Yout));
                if ~isempty(row)                                       
                   error(sprintf('error NAN value is found, index=%.0d, Time(index)=%.4f',[row, Time(row)]))
                end
                
                [n1, n2]=size(Yout);                
                Y_s =zeros(n2/CAP.skip,length(SOs ));
                Y_c =zeros(n2/CAP.skip,length(SOc ));
                Y_c1=zeros(n2/CAP.skip,length(SOc1));
                Y_h =zeros(n2/CAP.skip,length(SOh ));
                Time=zeros(n2/CAP.skip,1);
                for it=1:length(Time0)/CAP.skip                
                    Time(it)=Time0(it*CAP.skip);
                    vec=Yout(:,it*CAP.skip);                                    
                    rs. val=vec2mtz(vec(1:Ns_2));
                    rc. val=vec2mtz(vec(Ns_2+1:Ns_2+Nc_2));                
                    rc1.val=vec2mtz(vec(Ns_2+Nc_2+1:Ns_2+Nc_2+Nc1_2));
                    rh. val=vec2mtz(vec(Ns_2+Nc_2+Nc1_2+1:Ns_2+Nc_2+Nc1_2+Nh_2));
                    
                    Y_s (it,:)=Amplitudes(rs ,SOs);                                
                    Y_c (it,:)=Amplitudes(rc ,SOc);                                
                    Y_c1(it,:)=Amplitudes(rc1,SOc1);                                
                    Y_h (it,:)=Amplitudes(rh ,SOh);                                
                end 
            end                                   
        end
       
        
        function [Time, Yt4, Yt5, r4, r5]=ExchangeX(r4, S4,H4,Rs4,SO4,r5, S5,H5,Rs5,SO5,t,ka,kd,Dir,Tr,f4,f5)
            [n1,n2]=size(t);
            if n2>n1
               Time=t'; 
            else
               Time=t;
            end
            Yt4=zeros(length(t),length(SO4));
            Yt5=zeros(length(t),length(SO5));
            
            N42=S4.Nstates^2;
            N52=S5.Nstates^2;            
            %f4=1/(1+K);
            %f5=K/(1+K);            
          
            r4.val=f4*r4.val/trace(r4.val);
            r5.val=f5*r5.val/trace(r5.val);
            vec40=mtz2vec(r4.val);
            vec50=mtz2vec(r5.val);
            vec0=[vec40' vec50']';                                                        
                        
            
            
                        
            L4=-1i*H2Super(H4)+Rs4;
            L5=-1i*H2Super(H5)+Rs5;
            Us4=S4.UnitySuper();
            Us5=S5.UnitySuper();
            
            A=[L4-ka*Us4 kd*Tr;ka*Dir L5-kd*Us5];
          

            if t(1)~=0
               error('t(1) must be equal to 0')
            end

            if length(t)<2
               error('t must have minimum 2 values') 
            end
            
            dt=t(2)-t(1);
            Pevol=expm(A*dt);
            vec=vec0;
                       
            for it=1:length(t)
              %  it  
              if it~=1
                vec=Pevol*vec;
              end
                r4.val=vec2mtz(vec(1:N42));
                r5.val=vec2mtz(vec(N42+1:N42+N52));                
                Yt4(it,:)=Amplitudes(r4,SO4);                                
                Yt5(it,:)=Amplitudes(r5,SO5);
            end


            Yt4=Yt4/f4;
            Yt5=Yt5/f5;
            r4.val=r4.val/f4;
            r5.val=r5.val/f5;                        
        end
            
        
          function [Time, Yt4, Yt5, r4, r5]=ExchangeX_Source(r4, S4,H4,Rs4,SO4,r5, S5,H5,Rs5,SO5,t,ka,kd,Dir,Tr,f4,f5,r4in,W4in,W4out,r5in,W5in,W5out)
            [n1,n2]=size(t);
            if n2>n1
               Time=t'; 
            else
               Time=t;
            end
            Yt4=zeros(length(t),length(SO4));
            Yt5=zeros(length(t),length(SO5));
            
            N42=S4.Nstates^2;
            N52=S5.Nstates^2;                                 
          
            r4.val=f4*r4.val/trace(r4.val);
            r5.val=f5*r5.val/trace(r5.val);
            
            vec40=mtz2vec(r4.val);
            vec50=mtz2vec(r5.val);
            vec0=[vec40' vec50']';                                                        
            
            r4in.val=r4in.val/trace(r4in.val);
            r5in.val=r5in.val/trace(r5in.val);
                        
            Wvec4in=W4in*mtz2vec(r4in.val);
            Wvec5in=W5in*mtz2vec(r5in.val);
            Wvecin=[Wvec4in' Wvec5in']';                                                        
                                                                                                
            L4=-1i*H2Super(H4)+Rs4;
            L5=-1i*H2Super(H5)+Rs5;
            Us4=S4.UnitySuper();
            Us5=S5.UnitySuper();
            
            A=[(L4)+(-ka-W4out)*Us4 kd*Tr;ka*Dir (L5)+(-kd-W5out)*Us5];

            if t(1)~=0
               error('t(1) must be equal to 0')
            end
            
            if length(t)<2
               error('t must have minimum 2 values') 
            end
            
            dt=t(2)-t(1);
            Pevol=expm(A*dt);
            vec=vec0;
            AWvecin=A\Wvecin;
                                       
            for it=1:length(t)
              %  it       
               if it~=1
                vec=Pevol*(vec+AWvecin)-AWvecin;
               end
                r4.val=vec2mtz(vec(1:N42));
                r5.val=vec2mtz(vec(N42+1:N42+N52));                
                Yt4(it,:)=Amplitudes(r4,SO4);                                
                Yt5(it,:)=Amplitudes(r5,SO5);
            end


            Yt4=Yt4/f4;
            Yt5=Yt5/f5;
            r4.val=r4.val/f4;
            r5.val=r5.val/f5;                        
          end
        
        
          
        %CHIRP
        function r=CHIRP(obj,S,ChSh,Jij,B0,v1,ppmRF,timeRF,RegNuc,GrT)
            Nrf=length(ppmRF);
            Ngr=length(GrT);
            t=linspace(0,timeRF,Nrf);
            dt=t(2)-t(1);            
            r=obj;
            r.val=r.val*0;                         
            for ig=1:Ngr 
                %ig
                r0=obj;
                for irf=1:Nrf        
                    Hrf=2*pi*HZJij_RF1(S,ChSh,Jij,B0,v1,ppmRF(irf),'X',RegNuc);        
                    [Time,Y,r0]=r0.EvolutionConstHG(Hrf,GrT(ig),dt,S,{S.x{1}});        
                end
                r.val=r.val+r0.val;
            end  
            r.val=r.val/Ngr;
        end
        
        %MLEV-16
        function r=MLEV16(obj,S,ppm,Jij,B0,v1,vrf,ExcitedNuc,p90,Ncircles,SOs)
            %S - SpinOperator
            %ppm - chemical shift in ppm e.g. 1e-6
            %Jij - J-coupling matrix
            %B0 - magnetic field Tesla
            %v1 - excitation RF-field  in Hz
            %vrf -frequency of RF-field in ppm
            %ExcitedNuc - numbers of excited nuclei 
            %p90 - duration of 90degree RF-pulse
            %Ncircles - number of mlev16 circles
            %SOs spin operators for computation amplitudes
            %duration of one circle = 16*3*p90
            r=obj;

            Hpx=2*pi*HZJij_RF1(S,ppm,Jij,B0,v1,vrf,'X',ExcitedNuc);
            Hpy=2*pi*HZJij_RF1(S,ppm,Jij,B0,v1,vrf,'Y',ExcitedNuc);
            Hmx=2*pi*HZJij_RF1(S,ppm,Jij,B0,v1,vrf,'-X',ExcitedNuc);
            Hmy=2*pi*HZJij_RF1(S,ppm,Jij,B0,v1,vrf,'-Y',ExcitedNuc);
            for in=1:Ncircles
                %RRrr rRRr rrRR RrrR
                r=MLEV_R(r,Hpx,Hpy,p90,SOs);
                r=MLEV_R(r,Hpx,Hpy,p90,SOs);
                r=MLEV_r(r,Hmx,Hmy,p90,SOs);
                r=MLEV_r(r,Hmx,Hmy,p90,SOs);

                r=MLEV_r(r,Hmx,Hmy,p90,SOs);
                r=MLEV_R(r,Hpx,Hpy,p90,SOs);
                r=MLEV_R(r,Hpx,Hpy,p90,SOs);
                r=MLEV_r(r,Hmx,Hmy,p90,SOs);

                r=MLEV_r(r,Hmx,Hmy,p90,SOs);
                r=MLEV_r(r,Hmx,Hmy,p90,SOs);
                r=MLEV_R(r,Hpx,Hpy,p90,SOs);
                r=MLEV_R(r,Hpx,Hpy,p90,SOs);

                r=MLEV_R(r,Hpx,Hpy,p90,SOs);
                r=MLEV_r(r,Hmx,Hmy,p90,SOs);
                r=MLEV_r(r,Hmx,Hmy,p90,SOs);
                r=MLEV_R(r,Hpx,Hpy,p90,SOs);
            end            
        end
        function r=MLEV_R(obj,Hpx,Hpy,p90,SOs)
            %R
            [Time,Y,r]=obj.EvolutionConstH(Hpx,p90,SOs);
            [Time,Y,r]=r.EvolutionConstH(Hpy,p90,SOs);
            [Time,Y,r]=r.EvolutionConstH(Hpx,p90,SOs);
        end
        function r=MLEV_r(obj,Hmx,Hmy,p90,SOs)            
            %r
            [Time,Y,r]=obj.EvolutionConstH(Hmx,p90,SOs);
            [Time,Y,r]=r.EvolutionConstH(Hmy,p90,SOs);
            [Time,Y,r]=r.EvolutionConstH(Hmx,p90,SOs);
        end
         
        %MLEV-16
        function r=WALTZ16(obj,S,ppm,Jij,B0,v1,vrf,ExcitedNuc,p90,Ncircles,SOs)
            %S - SpinOperator
            %ppm - chemical shift in ppm e.g. 1e-6
            %Jij - J-coupling matrix
            %B0 - magnetic field Tesla
            %v1 - excitation RF-field  in Hz
            %vrf -frequency of RF-field in ppm
            %ExcitedNuc - numbers of excited nuclei 
            %p90 - duration of 90degree RF-pulse
            %Ncircles - number of mlev16 circles
            %SOs spin operators for computation amplitudes
            %duration of one circle = 24*4*p90 = 96*p90
            r=obj;

            Hpx=2*pi*HZJij_RF1(S,ppm,Jij,B0,v1,vrf,'X',ExcitedNuc);
            %Hpy=2*pi*HZJij_RF1(S,ppm,Jij,B0,v1,vrf,'Y',ExcitedNuc);
            Hmx=2*pi*HZJij_RF1(S,ppm,Jij,B0,v1,vrf,'-X',ExcitedNuc);
            %Hmy=2*pi*HZJij_RF1(S,ppm,Jij,B0,v1,vrf,'-Y',ExcitedNuc);
            for in=1:Ncircles
                %RRrr rRRr rrRR RrrR
                r=WALTZ16Q(r,Hpx,Hmx,p90,SOs);
                r=WALTZ16Q(r,Hmx,Hpx,p90,SOs);
                r=WALTZ16Q(r,Hmx,Hpx,p90,SOs);
                r=WALTZ16Q(r,Hpx,Hmx,p90,SOs);
            end            
        end
        function r=WALTZ16Q(obj,Hm,Hp,p90,SOs)
            %Q
            [Time,Y,r]=obj.EvolutionConstH(Hm,p90*3,SOs);  %270-x 3
            [Time,Y,r]=  r.EvolutionConstH(Hp,p90*4,SOs);  %360 x 4
            [Time,Y,r]=  r.EvolutionConstH(Hm,p90*2,SOs);  %180-x 2
            [Time,Y,r]=  r.EvolutionConstH(Hp,p90*3,SOs);  %270 x 3
            [Time,Y,r]=  r.EvolutionConstH(Hm,p90*1,SOs);  %90 -x 1
            [Time,Y,r]=  r.EvolutionConstH(Hp,p90*2,SOs);  %180 x 2
            [Time,Y,r]=  r.EvolutionConstH(Hm,p90*4,SOs);  %360-x 4
            [Time,Y,r]=  r.EvolutionConstH(Hp,p90*2,SOs);  %180 x 2
            [Time,Y,r]=  r.EvolutionConstH(Hm,p90*3,SOs);  %270-x 3
        end

                        
        %DIPSY-2
        function r=DIPSI2(obj,S,ppm,Jij,B0,v1,vrf,ExcitedNuc,p90,Ncircles,dir,SOs)
            r=obj; 
            if strcmp(dir,'X') || strcmp(dir,'x')
                Hp=2*pi*HZJij_RF1(S,ppm,Jij,B0,v1,vrf,'X',ExcitedNuc);            
                Hm=2*pi*HZJij_RF1(S,ppm,Jij,B0,v1,vrf,'-X',ExcitedNuc);
            elseif strcmp(dir,'-X') || strcmp(dir,'-x')
                Hp=2*pi*HZJij_RF1(S,ppm,Jij,B0,v1,vrf,'-X',ExcitedNuc);
                Hm=2*pi*HZJij_RF1(S,ppm,Jij,B0,v1,vrf,'X',ExcitedNuc);
            elseif strcmp(dir,'Y') || strcmp(dir,'y')
                Hp=2*pi*HZJij_RF1(S,ppm,Jij,B0,v1,vrf,'Y',ExcitedNuc);
                Hm=2*pi*HZJij_RF1(S,ppm,Jij,B0,v1,vrf,'-Y',ExcitedNuc);
            elseif strcmp(dir,'-Y') || strcmp(dir,'-y')
                Hp=2*pi*HZJij_RF1(S,ppm,Jij,B0,v1,vrf,'-Y',ExcitedNuc);
                Hm=2*pi*HZJij_RF1(S,ppm,Jij,B0,v1,vrf,'Y',ExcitedNuc);
            else
                error('wrong direction x, X, y, Y, -x, -X, -y, -Y')
            end
            
            for in=1:Ncircles
                %DIPSI-2: R(0)R(0)R(180)R(180) where 
                %R=320(0)-410(180)-290(0)-285(180)-30(0)-245(180)-375(0)-265(180)-370(0)
                r=DIPSI2_R(r,Hp,Hm,p90,SOs);
                r=DIPSI2_R(r,Hp,Hm,p90,SOs);
                r=DIPSI2_R(r,Hm,Hp,p90,SOs);
                r=DIPSI2_R(r,Hm,Hp,p90,SOs);                
            end            
        end
        function r=DIPSI2_R(obj,Hp,Hm,p90,SOs)            
            %R=320(0)-410(180)-290(0)-285(180)-30(0)-245(180)-375(0)-265(180)-370(0)
            [Time,Y,r]=obj.EvolutionConstH(Hp,p90*320/90,SOs); %1  320(0)
            [Time,Y,r]=  r.EvolutionConstH(Hm,p90*410/90,SOs); %2  410(180)
            [Time,Y,r]=  r.EvolutionConstH(Hp,p90*290/90,SOs); %3  290(0)
            [Time,Y,r]=  r.EvolutionConstH(Hm,p90*285/90,SOs); %4  285(180)
            [Time,Y,r]=  r.EvolutionConstH(Hp,p90*30/90 ,SOs); %5  30 (0)
            [Time,Y,r]=  r.EvolutionConstH(Hm,p90*245/90,SOs); %6  245(180)
            [Time,Y,r]=  r.EvolutionConstH(Hp,p90*375/90,SOs); %7  375(0)
            [Time,Y,r]=  r.EvolutionConstH(Hm,p90*265/90,SOs); %8  265(180)
            [Time,Y,r]=  r.EvolutionConstH(Hp,p90*370/90,SOs); %9  370(0)              
        end
        
        
        %DIPSY-2 Op
        function [Q, iQ]=DIPSI2Op(obj,S,ppm,Jij,B0,v1,vrf,ExcitedNuc,p90,dir)
            if strcmp(dir,'X') || strcmp(dir,'x')
                Hp=2*pi*HZJij_RF1(S,ppm,Jij,B0,v1,vrf,'X',ExcitedNuc);            
                Hm=2*pi*HZJij_RF1(S,ppm,Jij,B0,v1,vrf,'-X',ExcitedNuc);
            elseif strcmp(dir,'-X') || strcmp(dir,'-x')
                Hp=2*pi*HZJij_RF1(S,ppm,Jij,B0,v1,vrf,'-X',ExcitedNuc);
                Hm=2*pi*HZJij_RF1(S,ppm,Jij,B0,v1,vrf,'X',ExcitedNuc);
            elseif strcmp(dir,'Y') || strcmp(dir,'y')
                Hp=2*pi*HZJij_RF1(S,ppm,Jij,B0,v1,vrf,'Y',ExcitedNuc);
                Hm=2*pi*HZJij_RF1(S,ppm,Jij,B0,v1,vrf,'-Y',ExcitedNuc);
            elseif strcmp(dir,'-Y') || strcmp(dir,'-y')
                Hp=2*pi*HZJij_RF1(S,ppm,Jij,B0,v1,vrf,'-Y',ExcitedNuc);
                Hm=2*pi*HZJij_RF1(S,ppm,Jij,B0,v1,vrf,'Y',ExcitedNuc);
            else
                error('wrong direction x, X, y, Y, -x, -X, -y, -Y')
            end
            
                %DIPSI-2: R(0)R(0)R(180)R(180) where 
                %R=320(0)-410(180)-290(0)-285(180)-30(0)-245(180)-375(0)-265(180)-370(0)
                
                iQ1=expm(+1i*Hp*p90*320/90)*expm(+1i*Hm*p90*410/90)*...
                    expm(+1i*Hp*p90*290/90)*expm(+1i*Hm*p90*285/90)*...
                    expm(+1i*Hp*p90*30/90 )*expm(+1i*Hm*p90*245/90)*...
                    expm(+1i*Hp*p90*375/90)*expm(+1i*Hm*p90*265/90)*...
                    expm(+1i*Hp*p90*370/90); 
               
                iQ2=expm(+1i*Hm*p90*320/90)*expm(+1i*Hp*p90*410/90)*...
                    expm(+1i*Hm*p90*290/90)*expm(+1i*Hp*p90*285/90)*...
                    expm(+1i*Hm*p90*30/90 )*expm(+1i*Hp*p90*245/90)*...
                    expm(+1i*Hm*p90*375/90)*expm(+1i*Hp*p90*265/90)*...
                    expm(+1i*Hm*p90*370/90); 
                iQ=iQ1*iQ1*iQ2*iQ2;
                Q=inv(iQ);                                                                       
        end
                
        %MLEV-16 random v1 and vrf
        function [r out]=MLEV16RandomV1Vrf(obj,S,ppm,Jij,B0,rndV1,rndPPMrf,ExcitedNuc,p90,Ncircles,N_in_p90steps,SOs)
            r=obj;
            out=zeros(Ncircles,2);
            out(:,1)=(1:Ncircles)';                        
            for nMLEV_circle=1:Ncircles
                nMLEV_circle
                %RRrr rRRr rrRR RrrR
                r=MLEV_RRandomV1Vrf(r,S,ppm,Jij,B0,rndV1,rndPPMrf,ExcitedNuc,p90,N_in_p90steps,SOs);
                r=MLEV_RRandomV1Vrf(r,S,ppm,Jij,B0,rndV1,rndPPMrf,ExcitedNuc,p90,N_in_p90steps,SOs);
                r=MLEV_rRandomV1Vrf(r,S,ppm,Jij,B0,rndV1,rndPPMrf,ExcitedNuc,p90,N_in_p90steps,SOs);
                r=MLEV_rRandomV1Vrf(r,S,ppm,Jij,B0,rndV1,rndPPMrf,ExcitedNuc,p90,N_in_p90steps,SOs);

                r=MLEV_rRandomV1Vrf(r,S,ppm,Jij,B0,rndV1,rndPPMrf,ExcitedNuc,p90,N_in_p90steps,SOs);
                r=MLEV_RRandomV1Vrf(r,S,ppm,Jij,B0,rndV1,rndPPMrf,ExcitedNuc,p90,N_in_p90steps,SOs);
                r=MLEV_RRandomV1Vrf(r,S,ppm,Jij,B0,rndV1,rndPPMrf,ExcitedNuc,p90,N_in_p90steps,SOs);
                r=MLEV_rRandomV1Vrf(r,S,ppm,Jij,B0,rndV1,rndPPMrf,ExcitedNuc,p90,N_in_p90steps,SOs);

                r=MLEV_rRandomV1Vrf(r,S,ppm,Jij,B0,rndV1,rndPPMrf,ExcitedNuc,p90,N_in_p90steps,SOs);
                r=MLEV_rRandomV1Vrf(r,S,ppm,Jij,B0,rndV1,rndPPMrf,ExcitedNuc,p90,N_in_p90steps,SOs);
                r=MLEV_RRandomV1Vrf(r,S,ppm,Jij,B0,rndV1,rndPPMrf,ExcitedNuc,p90,N_in_p90steps,SOs);
                r=MLEV_RRandomV1Vrf(r,S,ppm,Jij,B0,rndV1,rndPPMrf,ExcitedNuc,p90,N_in_p90steps,SOs);

                r=MLEV_RRandomV1Vrf(r,S,ppm,Jij,B0,rndV1,rndPPMrf,ExcitedNuc,p90,N_in_p90steps,SOs);
                r=MLEV_rRandomV1Vrf(r,S,ppm,Jij,B0,rndV1,rndPPMrf,ExcitedNuc,p90,N_in_p90steps,SOs);
                r=MLEV_rRandomV1Vrf(r,S,ppm,Jij,B0,rndV1,rndPPMrf,ExcitedNuc,p90,N_in_p90steps,SOs);
                r=MLEV_RRandomV1Vrf(r,S,ppm,Jij,B0,rndV1,rndPPMrf,ExcitedNuc,p90,N_in_p90steps,SOs);
                                
                out(nMLEV_circle,2)=real(r.Amplitude(SOs{1}));
                save('MLEV_circle_out.dat','out','-ASCII');
            end            
        end
        function r=MLEV_RRandomV1Vrf(obj,S,ppm,Jij,B0,rndV1,rndPPMrf,ExcitedNuc,p90,N_in_p90steps,SOs)
            %R
            r=obj;            
            %90x
            for n=1:N_in_p90steps
                Hpx=2*pi*HZJij_RF1(S,ppm,Jij,B0,random('norm',rndV1(1),rndV1(2),1),random('norm',rndPPMrf(1),rndPPMrf(2),1), 'X',ExcitedNuc);
                [Time,Y,r]=r.EvolutionConstH(Hpx,p90/N_in_p90steps,SOs);
            end
            %180x
            for n=1:2*N_in_p90steps
                Hpy=2*pi*HZJij_RF1(S,ppm,Jij,B0,random('norm',rndV1(1),rndV1(2),1),random('norm',rndPPMrf(1),rndPPMrf(2),1), 'Y',ExcitedNuc);
                [Time,Y,r]=r.EvolutionConstH(Hpy,p90/N_in_p90steps,SOs);
            end
            %90x
            for n=1:N_in_p90steps
                Hpx=2*pi*HZJij_RF1(S,ppm,Jij,B0,random('norm',rndV1(1),rndV1(2),1),random('norm',rndPPMrf(1),rndPPMrf(2),1), 'X',ExcitedNuc);
                [Time,Y,r]=r.EvolutionConstH(Hpx,p90/N_in_p90steps,SOs);
            end                        
        end
        function r=MLEV_rRandomV1Vrf(obj,S,ppm,Jij,B0,rndV1,rndPPMrf,ExcitedNuc,p90,N_in_p90steps,SOs)
            %r
            r=obj;            
            %90-x
            for n=1:N_in_p90steps
                Hmx=2*pi*HZJij_RF1(S,ppm,Jij,B0,random('norm',rndV1(1),rndV1(2),1),random('norm',rndPPMrf(1),rndPPMrf(2),1), '-X',ExcitedNuc);
                [Time,Y,r]=r.EvolutionConstH(Hmx,p90/N_in_p90steps,SOs);
            end
            %180-x
            for n=1:2*N_in_p90steps
                Hmy=2*pi*HZJij_RF1(S,ppm,Jij,B0,random('norm',rndV1(1),rndV1(2),1),random('norm',rndPPMrf(1),rndPPMrf(2),1), '-Y',ExcitedNuc);
                [Time,Y,r]=r.EvolutionConstH(Hmy,p90/N_in_p90steps,SOs);
            end
            %90-x
            for n=1:N_in_p90steps
                Hmx=2*pi*HZJij_RF1(S,ppm,Jij,B0,random('norm',rndV1(1),rndV1(2),1),random('norm',rndPPMrf(1),rndPPMrf(2),1), '-X',ExcitedNuc);
                [Time,Y,r]=r.EvolutionConstH(Hmx,p90/N_in_p90steps,SOs);
            end                        
        end
    end
    
        
    methods (Static)

    end    
end