classdef MRI_MultyResSLICE
    %SLICE Summary of this class goes here
    %   Detailed explanation goes here
    
    properties
        
    end    
    properties (SetAccess = private)
        SLs %slice destribution of different species
        ress %resonance frequencies for corresponding frequencies
        N %number of different species
    end
    methods 
        %{SL1, SL2, SL3...},{frq1, frq2, frq3}
        function MR_SL = MRI_MultyResSLICE(Number, SLs,ress)                       
           MR_SL.N=Number;
           if length(SLs)~=Number
               error('SLs length must be equal to Number');
           end
           if length(ress)~=Number
               error('ress length must be equal to Number');
           end
           MR_SL.SLs=SLs;
           MR_SL.ress=ress; 
        end
        function MR_SL=IdealRotation(obj,angle,dir)
            MR_SL=obj;
            for in=1:MR_SL.N
                MR_SL.SLs{in}=IdealRotation(obj.SLs{in},angle,dir);
            end
        end
        function ShowFrame(obj)
            f1=figure('Name','Name of Image','Color','white','NumberTitle','off');
            
            %s1=subplot(2,2,1);
            Dens=obj.SLs{1}.Dens;
            for n=2:obj.N
               Dens=Dens+obj.SLs{n}.Dens;
            end
            
            imagesc(Dens);
            colorbar('location','EastOutside')
            axis('square');xlabel('X axis');ylabel('Y axis');
            title('proton Dens');


%             s2=subplot(2,2,2);
%             imagesc(obj.T2);
%             colorbar('location','EastOutside')
%             axis('square');xlabel('X axis');ylabel('Y axis');
%             title('T2');
% 
%             s3=subplot(2,2,3);
%             imagesc(obj.T1);
%             colorbar('location','EastOutside')
%             axis('square');xlabel('X axis');ylabel('Y axis');
%             title('T1');            
            
            colormap('Gray');
            %colormap('Summer');
        end
        
        
        function MR_SL=BLOCHe(obj,w0,FH,time)
            MR_SL=obj;
            w=w0;
            for in=1:MR_SL.N
                w(3)=2*pi*obj.ress{in}-w0(3);
                MR_SL.SLs{in}=BLOCHe(obj.SLs{in},w,FH,time);
            end  
        end
        function MR_SL=BLOCHeG(obj,w0,FH,time,G)
            MR_SL=obj;
            w=w0;
            for in=1:MR_SL.N
                w(3)=2*pi*obj.ress{in}-w0(3);
                MR_SL.SLs{in}=BLOCHeG(obj.SLs{in},w,FH,time,G);
            end  
        end                        
        function [Mtr, MR_SL]=BLOCHeGfrq(obj,w0,FH,time,G)
           MR_SL=obj;
           Mtr=0;
           w=w0;
           for in=1:MR_SL.N
               w(3)=2*pi*obj.ress{in}-w0(3);
               [out, MR_SL.SLs{in}]=BLOCHeGfrq(obj.SLs{in},w,FH,time,G);
               Mtr=Mtr+out;
           end
        end
        
        function MR_SL=BLOCHesG(obj,w0z,FHZ,t,G)
           MR_SL=obj;
           for in=1:MR_SL.N
               MR_SL.SLs{in}=BLOCHesG(obj.SLs{in},2*pi*obj.ress{in}-w0z,FHZ,t,G);
           end
        end
        function [Mtr, MR_SL]=BLOCHesGfrq(obj,w0z,FHZ,t,G)
           MR_SL=obj;
           Mtr=0;
           for in=1:MR_SL.N
               [out, MR_SL.SLs{in}]=BLOCHesGfrq(obj.SLs{in},2*pi*obj.ress{in}-w0z,FHZ,t,G);
               Mtr=Mtr+out;
           end
        end
%         function [Mtr, MR_SL]=BLOCHesSpGfrq(obj,w0z,FHZ,t,G)
%            MR_SL=obj;
%            Mtr=0;
%            for in=1:MR_SL.N
%                [out, MR_SL.SLs{in}]=BLOCHesSpGfrq(obj.SLs{in},2*pi*obj.ress{in}-w0z,FHZ,t,G);
%                Mtr=Mtr+out;
%            end
%         end
        
        
        function MR_SL=BLOCHesG2Ex(obj,w0,FHZ,time,G,K)
            MR_SL=obj;
            wA=2*pi*obj.ress{1}-w0;
            wB=2*pi*obj.ress{2}-w0;
                        
            GxV=G(1);GyV=G(2);
            Gx=linspace(GxV/2,-GxV/2,obj.SLs{1}.Nx);
            Gy=linspace(GyV/2,-GyV/2,obj.SLs{1}.Ny);
            MpIC=zeros(2,1);
            MzIC=zeros(2,1);
            M0T=zeros(2,1);

            if length(time)~=1
                error('length of time should be 1');
            end
                                                      
            for iy=1:obj.SLs{1}.Ny
                for ix=1:obj.SLs{1}.Nx                    
                    wAz=wA+obj.SLs{1}.Dx*Gx(ix)+obj.SLs{1}.Dy*Gy(iy)+FHZ(iy,ix); 
                    wBz=wB+obj.SLs{2}.Dx*Gx(ix)+obj.SLs{2}.Dy*Gy(iy)+FHZ(iy,ix); 
                    if obj.SLs{1}.T1(iy,ix)~=0 && obj.SLs{1}.T2(iy,ix)~=0
                        if obj.SLs{2}.T1(iy,ix)~=0 && obj.SLs{2}.T2(iy,ix)~=0
                            C=obj.SLs{1}.Dens(iy,ix)+obj.SLs{2}.Dens(iy,ix);

                            D1=exp(-(K(1)+K(2))*time)*(obj.SLs{1}.Dens(iy,ix)-K(2)*C/(K(1)+K(2)))+K(2)*C/(K(1)+K(2));                                                       
                            D2=C-D1;
                                                                                                                
                            MpIC(1)=(obj.SLs{1}.Mx(iy,ix)+1i*obj.SLs{1}.My(iy,ix))*obj.SLs{1}.Dens(iy,ix);                            
                            MpIC(2)=(obj.SLs{2}.Mx(iy,ix)+1i*obj.SLs{2}.My(iy,ix))*obj.SLs{2}.Dens(iy,ix);
                            KT=[-1i*wAz-K(1)-1/obj.SLs{1}.T2(iy,ix)   K(2); K(1) -1i*wBz-K(2)-1/obj.SLs{2}.T2(iy,ix)];
                            Mp=expm(KT*time)*MpIC;                            
                            
                            MzIC(1)=obj.SLs{1}.Mz(iy,ix)*obj.SLs{1}.Dens(iy,ix);
                            MzIC(2)=obj.SLs{2}.Mz(iy,ix)*obj.SLs{2}.Dens(iy,ix);                                                                                    
                            M0T(1)=obj.SLs{1}.Meq/obj.SLs{1}.T1(iy,ix);
                            M0T(2)=obj.SLs{2}.Meq/obj.SLs{2}.T1(iy,ix);
                            KL=[-K(1)-1/obj.SLs{1}.T1(iy,ix)   K(2); K(1) -K(2)-1/obj.SLs{2}.T1(iy,ix)];
                            
                            Mz=expm(KL*time)*(MzIC+KL\M0T)-KL\M0T;
                            
                            if D1~=0
                                MR_SL.SLs{1}.Dens(iy,ix)=D1;
                                MR_SL.SLs{1}.Mx(iy,ix)=real(Mp(1))/D1;
                                MR_SL.SLs{1}.My(iy,ix)=imag(Mp(1))/D1;
                                MR_SL.SLs{1}.Mz(iy,ix)=Mz(1)/D1;
                            else
                                MR_SL.SLs{1}.Mx(iy,ix)=0;
                                MR_SL.SLs{1}.My(iy,ix)=0;
                                MR_SL.SLs{1}.Mz(iy,ix)=0;
                            end
                            if D2~=0
                                MR_SL.SLs{2}.Dens(iy,ix)=D2;                                                        
                                MR_SL.SLs{2}.Mx(iy,ix)=real(Mp(2))/D2;
                                MR_SL.SLs{2}.My(iy,ix)=imag(Mp(2))/D2;
                                MR_SL.SLs{2}.Mz(iy,ix)=Mz(2)/D2;
                            else                                
                                MR_SL.SLs{2}.Mx(iy,ix)=0;
                                MR_SL.SLs{2}.My(iy,ix)=0;
                                MR_SL.SLs{2}.Mz(iy,ix)=0;
                            end                                                      
                        else
                            error('second type is not specified here!');
                        end                                            
                    end
                end
            end            
        end
                 
        function [Mtr, MR_SL]=BLOCHesGfrq2Ex(obj,w0,FHZ,time,G,K)            
            Mtr=zeros(1,length(time)); 
            MR_SL=obj;
            wA=2*pi*obj.ress{1}-w0;
            wB=2*pi*obj.ress{2}-w0;
            MpIC=zeros(2,1);
            MzIC=zeros(2,1);
            M0T=zeros(2,1);
            GxV=G(1);GyV=G(2);
            Gx=linspace(GxV/2,-GxV/2,obj.SLs{1}.Nx);
            Gy=linspace(GyV/2,-GyV/2,obj.SLs{1}.Ny);

            for iy=1:obj.SLs{1}.Ny
                for ix=1:obj.SLs{1}.Nx                    
                    wAz=wA+obj.SLs{1}.Dx*Gx(ix)+obj.SLs{1}.Dy*Gy(iy)+FHZ(iy,ix); 
                    wBz=wB+obj.SLs{2}.Dx*Gx(ix)+obj.SLs{2}.Dy*Gy(iy)+FHZ(iy,ix); 
                    if obj.SLs{1}.T1(iy,ix)~=0 && obj.SLs{1}.T2(iy,ix)~=0
                        if obj.SLs{2}.T1(iy,ix)~=0 && obj.SLs{2}.T2(iy,ix)~=0
                            C=obj.SLs{1}.Dens(iy,ix)+obj.SLs{2}.Dens(iy,ix);
                            
                            MpIC(1)=(obj.SLs{1}.Mx(iy,ix)+1i*obj.SLs{1}.My(iy,ix))*obj.SLs{1}.Dens(iy,ix);
                            MpIC(2)=(obj.SLs{2}.Mx(iy,ix)+1i*obj.SLs{2}.My(iy,ix))*obj.SLs{2}.Dens(iy,ix);
                            KT=[-1i*wAz-K(1)-1/obj.SLs{1}.T2(iy,ix)   K(2); K(1) -1i*wBz-K(2)-1/obj.SLs{2}.T2(iy,ix)];
                            
                            MzIC(1)=obj.SLs{1}.Mz(iy,ix)*obj.SLs{1}.Dens(iy,ix);
                            MzIC(2)=obj.SLs{2}.Mz(iy,ix)*obj.SLs{2}.Dens(iy,ix);
                            
                            M0T(1)=obj.SLs{1}.Meq/obj.SLs{1}.T1(iy,ix);
                            M0T(2)=obj.SLs{2}.Meq/obj.SLs{2}.T1(iy,ix);
                            KL=[-K(1)-1/obj.SLs{1}.T1(iy,ix)   K(2); K(1) -K(2)-1/obj.SLs{2}.T1(iy,ix)];
                            
                            for it=1:length(time)
                                D1=exp(-(K(1)+K(2))*time(it))*(obj.SLs{1}.Dens(iy,ix)-K(2)*C/(K(1)+K(2)))+K(2)*C/(K(1)+K(2));                                                       
                                D2=C-D1;
                                                                                                                                
                                Mp=expm(KT*time(it))*MpIC;                                                                
                                Mtr(it)=Mtr(it)+Mp(1)+Mp(2);
                            end
                                                                                                                
                            Mz=expm(KL*time(end))*(MzIC+KL\M0T)-KL\M0T;
                                                           
                            if D1~=0
                                MR_SL.SLs{1}.Dens(iy,ix)=D1;
                                MR_SL.SLs{1}.Mx(iy,ix)=real(Mp(1))/D1;
                                MR_SL.SLs{1}.My(iy,ix)=imag(Mp(1))/D1;
                                MR_SL.SLs{1}.Mz(iy,ix)=Mz(1)/D1;
                            else
                                MR_SL.SLs{1}.Mx(iy,ix)=0;
                                MR_SL.SLs{1}.My(iy,ix)=0;
                                MR_SL.SLs{1}.Mz(iy,ix)=0;
                            end
                            if D2~=0
                                MR_SL.SLs{2}.Dens(iy,ix)=D2;                                                        
                                MR_SL.SLs{2}.Mx(iy,ix)=real(Mp(2))/D2;
                                MR_SL.SLs{2}.My(iy,ix)=imag(Mp(2))/D2;
                                MR_SL.SLs{2}.Mz(iy,ix)=Mz(2)/D2;
                            else                                
                                MR_SL.SLs{2}.Mx(iy,ix)=0;
                                MR_SL.SLs{2}.My(iy,ix)=0;
                                MR_SL.SLs{2}.Mz(iy,ix)=0;
                            end
                            
                        else
                            error('second type is not specified here!');
                        end
                    end
                end
            end
        end                   
    end                                      
    
    methods (Static)
        
    end
end

