classdef SPIN
    %SPIN Summary of this class goes here
    %   Detailed explanation goes here
    
    properties
        
    end    
    properties (SetAccess = private)        
        %Dens
        Mx
        My
        Mz
        T1 %[s]
        T2 %[s]        
        M0
        C % concentration
    end
    
    methods 
        function SP=SPIN(M,T,Eq,C)
            SP.Mx=M(1);
            
            SP.My=M(2);
            SP.Mz=M(3);

            SP.T1=T(1);
            SP.T2=T(2);            
            
            %SP.Dens=Dens;
            SP.M0=Eq;        
            
            SP.C=C;        
        end
        
        function [Time,Mout,SP]=BLOCHe(SP,w,time)%calculate evolution in ribbon (OX, sample) with gradient G                       
                                    
            Mic=[SP.Mx,SP.My,SP.Mz];                    
            [Time,Mout]=ode45(@(t,M)Bloch(t,M,SP.T1,SP.T2,w,SP.M0),time,Mic);            
            SP.Mx=Mout(end,1);
            SP.My=Mout(end,2);
            SP.Mz=Mout(end,3);                
        end
        
        function [Time,Mout,SP]=BLOCHeRadDam(SP,tRD,w,time)%calculate evolution in ribbon (OX, sample) with gradient G                       
                                    
            Mic=[SP.Mx,SP.My,SP.Mz];                    
            [Time,Mout]=ode45(@(t,M)BlochRadDam(t,M,SP.T1,SP.T2,tRD,w,SP.M0),time,Mic);            
            SP.Mx=Mout(end,1);
            SP.My=Mout(end,2);
            SP.Mz=Mout(end,3);                
        end
        
        function SP=IdealRotation(obj,angle,dir)
            SP=obj;
            c=cos(angle);
            s=sin(angle);
            switch dir
                case 'X'                    
                    SP.Mx=obj.Mx;
                    SP.My=obj.My*c-s*obj.Mz;
                    SP.Mz=obj.My*s+c*obj.Mz;                        
                case 'Y'                    
                    SP.Mx=obj.Mx*c+s*obj.Mz;
                    SP.My=obj.My;
                    SP.Mz=obj.Mx*(-s)+c*obj.Mz;                        
                case 'Z'                 
                    SP.Mx=obj.Mx*c-s*obj.My;
                    SP.My=obj.Mx*s+c*obj.My;
                    SP.Mz=obj.Mz;                           
                otherwise
                    error('we do not support such direction. You can add it yourown. We have only ''X'', ''Y'', ''Z'' directions');
            end                        
        end
        
        function SP=BLOCH_wz(obj,wz,t)
            SP=obj;
            if length(t)~=1
                error('length of time should be 1');
            end
            if length(wz)~=1
                error('length of w0z should be 1');
            end
           
                                                                
            Gp=(obj.Mx+1i*obj.My)*exp((-1i*wz-1/obj.T2)*t);
            SP.Mx=real(Gp);
            SP.My=imag(Gp);
            SP.Mz=(obj.Mz-obj.M0)*exp(-t/obj.T1)+obj.M0;                    
        end
        
        
        function [Time,Mout,SP]=BLOCHe_wz(obj,wz,Time)
            SP=obj;
            if length(Time)==1
                error('length of time should be more than 1');
            end
            if length(wz)~=1
                error('length of w0z should be 1');
            end
            m=size(Time);
            if m(1)<m(2)
                Time=Time';
            end
            
            
            Mout=zeros(length(Time),3);
               for it=1:length(Time)  
                   t=Time(it);
                   Gp=(obj.Mx+1i*obj.My)*exp((-1i*wz-1/obj.T2)*t);
                   Mout(it,1)=real(Gp);
                   Mout(it,2)=imag(Gp);
                   Mout(it,3)=(obj.Mz-obj.M0)*exp(-t/obj.T1)+obj.M0;                      
               end
               SP.Mx=Mout(end,1);
               SP.My=Mout(end,2);
               SP.Mz=Mout(end,3);
        end
        
        
        function [Time,Mout1,Mout2,C1,C2,S1,S2]=BLOCHe_wzEx(S1,S2,Time,wz,K)            
            if length(Time)==1
                error('length of time should be more than 1');
            end
            if length(wz)~=2
                error('length of w0z should be 2');
            end

            m=size(Time);
            if m(1)<m(2)
                Time=Time';
            end
            
            Mout1=zeros(length(Time),3);
            Mout2=zeros(length(Time),3);
            Ctot=S1.C+S2.C;
            C1=exp(-(K(1)+K(2))*Time)*(S1.C-K(2)*Ctot/(K(1)+K(2)))+K(2)*Ctot/(K(1)+K(2));                                                       
            C2=Ctot-C1;
            C1eq=Ctot/(1+K(1)/K(2));
            C2eq=Ctot-C1eq;
            
            MpIC=zeros(2,1);
            MpIC(1)=(S1.Mx+1i*S1.My)*S1.C;                            
            MpIC(2)=(S2.Mx+1i*S2.My)*S2.C;
            
            MzIC=zeros(2,1);
            MzIC(1)=S1.Mz*S1.C;
            MzIC(2)=S2.Mz*S2.C;
            
            KT=[-1i*wz(1)-K(1)-1/S1.T2     K(2); 
                K(1)                       -1i*wz(2)-K(2)-1/S2.T2];
           
            KL=[-K(1)-1/S1.T1   K(2);
                 K(1)          -K(2)-1/S2.T1];
             
            M0T=zeros(2,1);
            M0T(1)=S1.M0*C1eq/S1.T1;
            M0T(2)=S2.M0*C2eq/S2.T1;
            
            for it=1:length(Time)                                                                                      
                t=Time(it);
                Gp12=expm(KT*t)*MpIC;
                Mz12=expm(KL*t)*(MzIC+KL\M0T)-KL\M0T;                                                                   
                
                Mout1(it,1)=real(Gp12(1));
                Mout1(it,2)=imag(Gp12(1));
                Mout1(it,3)=Mz12(1);                      
                
                Mout2(it,1)=real(Gp12(2));
                Mout2(it,2)=imag(Gp12(2));                                             
                Mout2(it,3)=Mz12(2);                      
            end
            
               S1.Mx=Mout1(end,1)/C1(end);
               S1.My=Mout1(end,2)/C1(end);
               S1.Mz=Mout1(end,3)/C1(end);
               S1.C=C1(end);
               
               S2.Mx=Mout2(end,1)/C2(end);
               S2.My=Mout2(end,2)/C2(end);
               S2.Mz=Mout2(end,3)/C2(end);
               S2.C=C2(end);
        end
        
        
        function SP=RemoveCoherences(SP)
           SP.Mx=0;
           SP.My=0;
        end
    end
end            
        
        
        
    
    


