classdef SpinOperators 
     %SpinOperators Summary of this class goes here
    %   Detailed explanation goes here
    %class for declaration of n*3+1 spin operators for n spin 1/2
    properties
        
    end    
    properties (SetAccess = private)
        x
        y
        z
        N %number of spins
        U
        UStr
        xStr
        yStr
        zStr
        SpinName
        SpinVal
        gamma
        g_gh
        gH
        Nstates
        
    end
    methods 
        function S = SpinOperators(varargin)            
            display('Declaration of spin operators');
            n=varargin{1};            
            Ix{1}=sparse([0 1;1 0]/2);
            Iy{1}=sparse([0 -1i;1i 0]/2);
            Iz{1}=sparse([1 0;0 -1]/2);
            Ix{2}=sparse([0 1 0;1 0 1; 0 1 0]/sqrt(2));
            Iy{2}=sparse(-1i*[0 1 0; -1 0 1; 0 -1 0]/sqrt(2));
            Iz{2}=sparse([1 0 0;0 0 0; 0 0 -1]);
            I0{1}=sparse(eye(2));
            I0{2}=sparse(eye(3));
            
            S.gH=26.75222080*1e7;%rad/(s*T)
            S.x=cell(n,1);
            S.y=cell(n,1);
            S.z=cell(n,1);            
            for k=1:n
                S.x{k}=1;   
                S.y{k}=1;
                S.z{k}=1;
                S.xStr{k}=sprintf('I%dx',k);
                S.yStr{k}=sprintf('I%dy',k);
                S.zStr{k}=sprintf('I%dz',k);
            end         
            if nargin==1 
                for in=1:n
                    S.SpinName{in}='1H';    
                    S.SpinVal{in}=1/2;
                    S.gamma{in}=26.75222080*1e7; %rad/(s*T)
                    S.g_gh{in}=1;
                end
            elseif nargin==2                
                Name=varargin{2};
                for in=1:n
                    S.SpinName{in}=Name{in};
                    switch Name{in}
                        case '1H'
                            S.SpinName{in}='1H'; 
                            S.SpinVal{in}=1/2;
                            S.gamma{in}=26.75222080*1e7; %rad/(s*T)
                            S.g_gh{in}=1;
                        case '2H'
                            S.SpinName{in}='2H'; 
                            S.SpinVal{in}=1;
                            S.gamma{in}=4.106629190*1e7; %rad/(s*T)
                            S.g_gh{in} =4.106629190/26.75222080;
                        case '13C'
                            S.SpinName{in}='13C'; 
                            S.SpinVal{in}=1/2;
                            S.gamma{in}=6.728286*1e7;  %rad/(s*T)
                            S.g_gh{in} =6.728286/26.75222080;
                        case '14N'
                            S.SpinName{in}='14N'; 
                            S.SpinVal{in}=1;
                            S.gamma{in}=1.93377980*1e7; %rad/(s*T)
                            S.g_gh{in} =1.93377980/26.75222080;
                        case '15N'
                            S.SpinName{in}='15N'; 
                            S.SpinVal{in}=1/2;
                            S.gamma{in}=-2.7126189*1e7; %rad/(s*T)
                            S.g_gh{in} =-2.7126189/26.75222080;
                        case '19F'
                            S.SpinName{in}='19F'; 
                            S.SpinVal{in}=1/2;
                            S.gamma{in}=25.16233*1e7; %rad/(s*T)
                            S.g_gh{in} =25.16233/26.75222080;
                        case '29Si'
                            S.SpinName{in}='29Si'; 
                            S.SpinVal{in}=1/2;
                            S.gamma{in}=-5.31903*1e7; %rad/(s*T)
                            S.g_gh{in} =-5.31903/26.75222080;
                        case '31P'
                            S.SpinName{in}='31P'; 
                            S.SpinVal{in}=1/2;
                            S.gamma{in}=10.8394*1e7; %rad/(s*T)
                            S.g_gh{in} =10.8394/26.75222080;
                        case '103Rh'
                            S.SpinName{in}='103Rh'; 
                            S.SpinVal{in}=1/2;
                            S.gamma{in}=-0.84677*1e7; %rad/(s*T)
                            S.g_gh{in} =-0.84677/26.75222080;
                        otherwise
                            error('we have only following nuclei: {''1H'',''2H'',''13C'',''14N'',''15N'',''19F'',''29Si'',''31P'',''103Rh''}, check SpinOperators()');
                    end 
                end
            end
            
            S.U=1;
            for in=1:n
                for k=1:n
                    if k==in
                        S.x{k}=kron(S.x{k},Ix{S.SpinVal{in}*2});   
                        S.y{k}=kron(S.y{k},Iy{S.SpinVal{in}*2});
                        S.z{k}=kron(S.z{k},Iz{S.SpinVal{in}*2});
                    else
                        S.x{k}=kron(S.x{k},I0{S.SpinVal{in}*2});   
                        S.y{k}=kron(S.y{k},I0{S.SpinVal{in}*2});
                        S.z{k}=kron(S.z{k},I0{S.SpinVal{in}*2}); 
                    end                    
                end
                S.U=kron(S.U,I0{S.SpinVal{in}*2});
            end   
            S.Nstates=trace(S.U);
            S.U=S.U/S.Nstates;
            S.UStr='Unity';
            S.N=n;            
        end        
        function out=isSpinOperators(in)
           % out=strcmp( class(in),'SpinOperators');
            out=isa(in,'SpinOperators'); 
        end 
        function out=SS(obj,n1,n2)
            out=obj.x{n1}*obj.x{n2}+obj.y{n1}*obj.y{n2}+obj.z{n1}*obj.z{n2};
        end
        function out=SSnorm(obj,n1,n2)
            out=(obj.SpinVal{n1}*2+1)*(obj.SpinVal{n2}*2+1)/obj.Nstates*(obj.x{n1}*obj.x{n2}+obj.y{n1}*obj.y{n2}+obj.z{n1}*obj.z{n2});%2^(2-obj.N)
        end
        function out=SSzz(obj,n1,n2)
            out=obj.z{n1}*obj.z{n2};
        end
        function out=SSzznorm(obj,n1,n2)
            out=(obj.SpinVal{n1}*2+1)*(obj.SpinVal{n2}*2+1)/obj.Nstates*(obj.z{n1}*obj.z{n2});%2^(2-obj.N)
        end        
        function out=norm(obj,dir,num)
            if num>obj.N
                error('num must be integer equal or below then the number of spins');
            end            
            if dir=='x' || dir=='X'
                out=(obj.SpinVal{num}*2+1)/obj.Nstates*obj.x{num};%2^(1-obj.N)
            elseif dir=='y' || dir=='Y'
                out=(obj.SpinVal{num}*2+1)/obj.Nstates*obj.y{num};%2^(1-obj.N)
            elseif dir=='z' || dir=='Z'
                out=(obj.SpinVal{num}*2+1)/obj.Nstates*obj.z{num};%2^(1-obj.N)
            else
                error('dir can be x, X, y, Y, z or Z'); 
            end            
        end
        function out=norm2(obj,dir1,num1,dir2,num2)
            out=obj.norm(dir1,num1);
            if num2>obj.N
                error('num2 must be integer equal or below then the number of spins');
            end            
            if dir2=='x' || dir2=='X'
                out=out*(obj.SpinVal{num2}*2+1)*obj.x{num2};
            elseif dir2=='y' || dir2=='Y'
                out=out*(obj.SpinVal{num2}*2+1)*obj.y{num2};
            elseif dir2=='z' || dir2=='Z'
                out=out*(obj.SpinVal{num2}*2+1)*obj.z{num2};
            else
                error('dir2 can be x, X, y, Y, z or Z'); 
            end  
        end
        
        function [outS, outStr]=SpinOperatorsInRaw(obj)
            outS=cell(3*obj.N+1,1);
            outStr=cell(3*obj.N+1,1);
            outS{1}=obj.U;
            outStr{1}=obj.UStr;            
            for in=1:obj.N
                outS{1+in}=        obj.x{in};                
                outS{1+in+obj.N}=  obj.y{in};
                outS{1+in+obj.N*2}=obj.z{in};
                
                outStr{1+in}=        obj.xStr{in};
                outStr{1+in+obj.N}=  obj.yStr{in};                
                outStr{1+in+obj.N*2}=obj.zStr{in};
            end
        end                  
        function Irf=Dir(obj,dir,nuc)
            Irf=0;
            for in=1:length(nuc)
                switch dir
                    case 'X'            
                        Irf=Irf+obj.x{nuc(in)};
                    case 'x'            
                        Irf=Irf+obj.x{nuc(in)};
                    case 'Y'            
                        Irf=Irf+obj.y{nuc(in)};
                    case 'y'            
                        Irf=Irf+obj.y{nuc(in)};
                    case 'Z'            
                        Irf=Irf+obj.z{nuc(in)};
                    case 'z'            
                        Irf=Irf+obj.z{nuc(in)};
                    case '-X'            
                        Irf=Irf-obj.x{nuc(in)};
                    case '-x'            
                        Irf=Irf-obj.x{nuc(in)};
                    case '-Y'            
                        Irf=Irf-obj.y{nuc(in)};
                    case '-y'            
                        Irf=Irf-obj.y{nuc(in)};
                    case '-Z'            
                        Irf=Irf-obj.z{nuc(in)};
                    case '-z'            
                        Irf=Irf-obj.z{nuc(in)};
                    otherwise 
                        error('we do not support such direction yet');
                end
            end  
        end
        function out=T1(obj,n1,dir)
            switch dir
                    case '-' 
                        out=obj.x{n1}-1i*obj.y{n1};
                    case '+'
                        out=obj.x{n1}+1i*obj.y{n1};
                    case 'a'
                        out=obj.U+obj.norm('z',n1);
                    case 'b'
                        out=obj.U-obj.norm('z',n1);
                    otherwise 
                        error('we do not support such direction yet');
            end                        
        end
        
        
        function outT2=T2DD(obj,proj,n1,n2)
            In1m=obj.x{n1}-1i*obj.y{n1};
            In1p=obj.x{n1}+1i*obj.y{n1};
            In2m=obj.x{n2}-1i*obj.y{n2};
            In2p=obj.x{n2}+1i*obj.y{n2};
            switch proj
               case +2
                    outT2=0.5*In1p*In2p;                    
               case +1
                    outT2=-0.5*(In1p*obj.z{n2}+obj.z{n1}*In2p);                    
               case 0
                    outT2=(2*obj.z{n1}*obj.z{n2}-(In1p*In2m+In1m*In2p)/2)/sqrt(6);                    
               case -1
                    outT2=+0.5*(In1m*obj.z{n2}+obj.z{n1}*In2m);                    
               case -2
                    outT2=0.5*In1m*In2m;                     
               otherwise 
                   error('error in SpinOperators T2DD');
           end
        end
        function US=UnitySuper(obj)
            US=eye(obj.Nstates*obj.Nstates);
        end
        function S2=ChangeBasis(obj,Q)
           S2=obj;
            for in=1:obj.N
              S2.x{in}=Q\obj.x{in}*Q; 
              S2.y{in}=Q\obj.y{in}*Q;
              S2.z{in}=Q\obj.z{in}*Q;
           end 
        end
        function EP=EmaxPth(obj,n,T,B)
           kB=1.38064852*1e-23;% m2 kg s-2 K-1;
           hbar=1.0545718*1e-34;% m2 kg / s;
           obj.gamma{n}
           EP.Pth=(obj.gamma{n}*hbar*B)/(2*kB*T);
           EP.Emax=1/EP.Pth;
           %hbar*2*pi
        end
       
        
                                
        
    end
    
    methods (Static)
        
    end
end

