function Plot2D(X,Y,varargin)
X=real(X);
Y=real(Y);
ColorRGB={[1 0 0],[0 1 0],[0 0 1],[0 0 0],[0.8,0.5,0.1],[0 1 1],[1 0 1],...
    [0.5 0.5 1],[1 0.5 0.5],[0.5 1 0.5],[0.75 0.5 0.25],[0.5 0.75 0.25],...
    [0.25 0.5 0.75],[0.25 0.75 0.5],[0.5 0.25 0.75],[0.75 0.25 0.5],...
    [0.1 0.5 0.8],[0.1 0.5 0.8],[0.5,0.1,0.8],[1 1 0],[0.5,0.8,0.1],[0.8,0.1,0.5]};
[n1, n2]=size(Y);
if n1==length(X)
    figure('Name','Name of plot','Color','white','NumberTitle','off');
    for in=1:n2
        if nargin>2
            if length(varargin{1})~=n2
                error('check label list!');
            end
            Lg=varargin{1};
            plot(X,Y(:,in),'Color',ColorRGB{in},'LineWidth',2,'DisplayName',sprintf(['%d:' Lg{in}],in));
            hold on;
        else
            plot(X,Y(:,in),'Color',ColorRGB{in},'LineWidth',2,'DisplayName',sprintf('%d:',in));
            hold on;
        end        
    end
    legend('-DynamicLegend')  
    xlabel('X axis');
    ylabel('Y axis');
else
   error('Size of X and Y are not consistent!');
end

end