function Plot2DLog(X,Y,varargin)
X=real(X);
Y=real(Y);
ColorRGB={[1 0 0],[0 1 0],[0 0 1],[0 0 0],[1 1 0],[0 1 1],[1 0 1],[0.5 0.5 1],[1 0.5 0.5],[0.5 1 0.5],[0.75 0.5 0.25],[0.5 0.75 0.25],[0.25 0.5 0.75],[0.25 0.75 0.5],[0.5 0.25 0.75],[0.75 0.25 0.5]};
[n1, n2]=size(Y);
if n1==length(X)
    figure('Name','Name of plot','Color','white','NumberTitle','off');    
    for in=1:n2
        if nargin>2
            Lg=varargin{1};
            semilogx(X,Y(:,in),'Color',ColorRGB{in},'LineWidth',3,'DisplayName',sprintf(['%d:' Lg{in}],in));
            hold on;
        else
            semilogx(X,Y(:,in),'Color',ColorRGB{in},'LineWidth',3,'DisplayName',sprintf('%d:',in));
            hold on;
        end        
    end
    legend('-DynamicLegend')  
    xlabel('X axis');
    ylabel('Y axis');
else
   error('Size of X and Y are not consistent!');
end

end