function Plot3O(M)
[Ny, Nx, Nz]=size(M);
cz=1;
cy=1;
cx=1;
width=7;
hight=7;
x0=1;
y0=1;


f1=figure('Name','Name of Image','Color','white','NumberTitle','off','units','inches','outerposition',[x0 y0 x0+width  y0+hight]);
% Create slider

sliderXY = uicontrol('Style', 'slider',...
    'Min',1,'Max',Nz,'Value',cz,...
    'units','inches',...
    'Position', [1.6*width/10  1.0*hight/2 3.5*width/10 3*hight/100],...
    'SliderStep',[1/(Nz-1) 2/(Nz-1)],...
    'Callback', @callSliderXY);
textXY = uicontrol('Style','Text',...
    'String',sprintf('Z=%.0d',cz),...
    'units','inches',...
    'Position', [1.0*width/10  1.0*hight/2 0.5*width/10 3*hight/100],...
    'BackgroundColor','white');

sliderXZ = uicontrol('Style', 'slider',...
    'Min',1,'Max',Nz,'Value',cy,...
    'units','inches',...
    'Position', [6.5*width/10  1.0*hight/2 3.5*width/10 3*hight/100],...
    'SliderStep',[1/(Ny-1) 2/(Ny-1)],...
    'Callback', @callSliderXZ);
textXZ = uicontrol('Style','Text',...
    'String',sprintf('Y=%.0d',cy),...
    'units','inches',...
    'Position', [5.9*width/10  1.0*hight/2 0.5*width/10 3*hight/100],...
    'BackgroundColor','white');

sliderYZ = uicontrol('Style', 'slider',...
    'Min',1,'Max',Nz,'Value',cy,...
    'units','inches',...
    'Position', [6.5*width/10  1.0*hight/40 3.5*width/10 3*hight/100],...
    'SliderStep',[1/(Ny-1) 2/(Ny-1)],...
    'Callback', @callSliderYZ);
textYZ = uicontrol('Style','Text',...
    'String',sprintf('X=%.0d',cx),...
    'units','inches',...
    'Position', [5.9*width/10  1.0*hight/40 0.5*width/10 3*hight/100],...
    'BackgroundColor','white');

MMM=max(max(max(abs(M))));
mmm=min(min(min(abs(M))));
clim=[0 MMM];


ImageXY=subplot(2,2,1);
ImagePlotXY=imagesc(abs(M(:,:,cz)),clim);
axis('square');
set(gca,'YTick',[]);
set(gca,'XTick',[]);
colormap('Gray');
xlabel('X');
ylabel('Y');
title(sprintf('absmax=%f, absmin=%f',[MMM,mmm]));   

ImageXZ=subplot(2,2,2);
ImagePlotXZ=imagesc(squeeze(abs(M(cy,:,:))),clim);
axis('square');
set(gca,'YTick',[]);
set(gca,'XTick',[]);
colormap('Gray');
xlabel('Z');
ylabel('X');

ImageYZ=subplot(2,2,4);
ImagePlotYZ=imagesc(squeeze(abs(M(:,cx,:))),clim);
axis('square');
set(gca,'YTick',[]);
set(gca,'XTick',[]);
colormap('Gray');
xlabel('Z');
ylabel('Y');

function callSliderXY(source,event)    
    cz = round(source.Value);    
    set(textXY,'String',sprintf('Z=%.0d',cz));    
    set(ImagePlotXY,'CData',abs(M(:,:,cz)));
end

function callSliderXZ(source,event)
    cy = round(source.Value);    
    set(textXZ,'String',sprintf('Y=%.0d',cy));
    set(ImagePlotXZ,'CData',abs(squeeze(M(cy,:,:))));
end

function callSliderYZ(source,event)
    cx = round(source.Value);
    set(textYZ,'String',sprintf('X=%.0d',cx));
    set(ImagePlotYZ,'CData',abs(squeeze(M(:,cx,:))));
end


end