function PlotCSI_Imag(M,SW,varargin)
N=256;
Center=N/2;
Width=N/2;
TD=length(M(1,1,:));
itd=TD/2;
n=size(M(:,:,1));
ABSoluteMax=max(max(max(abs(M))));
ABSoluteMin=min(min(min(abs(M))));
M=(M-ABSoluteMin)/(ABSoluteMax-ABSoluteMin);

MaxABS=max(max(abs(M(:,:,itd))));
AvgABS=sum(sum(abs(M(:,:,itd))))/(n(1)*n(2));
frq=linspace(SW/2,-SW/2,TD);


if nargin==2
    f1=figure('Name','Name of Image','Color','white','NumberTitle','off');
    % Create slider
    sliderCenter = uicontrol('Style', 'slider',...
        'Min',1,'Max',N,'Value',Center,...
        'Position', [315 80 200 20],...
        'Callback', @callSliderCenter); 
    textCenter = uicontrol('Style','Text',...
        'String','Center',...
        'Position', [270 80 50 20],...
        'BackgroundColor','white');
    
    sliderWidth = uicontrol('Style', 'slider',...
        'Min',1,'Max',N,'Value',Width,...
        'Position', [315 30 200 20],...
        'Callback', @callSliderWidth);
    textWidth = uicontrol('Style','Text',...
        'String','Width',...
        'Position', [270 30 50 20],...
        'BackgroundColor','white');
    
    sliderChemShift = uicontrol('Style', 'slider',...
        'Min',1,'Max',TD,'Value',itd,...
        'Position', [50 30 200 20],...
        'SliderStep',[1/(TD-1) 4/(TD-1)],...
        'Callback', @callChemShift);
    textChemShift = uicontrol('Style','Text',...
        'String',sprintf('ChemShift %.1f Hz',frq(itd)),...
        'Position', [20 50 200 20],...
        'BackgroundColor','white');
       
    
    
    textMAXAVG = uicontrol('Style','Text',...
        'String',sprintf('Maximum_ABS=%.1f, average_ABS=%.1f',MaxABS,AvgABS),...
        'Position', [70 315 200 40],...
        'BackgroundColor','white');
    
end

sImage=subplot(1,2,1);
ImagePlot=imagesc(abs(M(:,:,itd)),[0 1]);
axis('square');
set(gca,'YTick',[]);
set(gca,'XTick',[]);
map= GrayMap(Center,Width,N);
colormap(map);
%colormap('Gray');


sGray=subplot(1,2,2);
GrayPlot=plot(map(:,1),'Color','black','LineWidth',2);
axis('square');
axis([0 N 0 1]);
set(gca,'YTick',[]);
set(gca,'XTick',[]);

hold on
svec=sort(reshape(abs(M(:,:,itd)),n(1)*n(2),1));
svec=svec-ABSoluteMin;
svec=svec/ABSoluteMax*N;
HistPlot=histogram(svec,'NumBins',N/4,'BinLimits',[0 256],'Normalization','probability','FaceColor' ,[0.5 0.5 0.5]);


    function callSliderCenter(source,event)
        Center = source.Value;
        map= GrayMap(Center,Width,N);
        colormap(map);
        set(GrayPlot,'YData',map(:,1));
    end
    function callSliderWidth(source,event)
        Width = source.Value;
        map= GrayMap(Center,Width,N);
        colormap(map);
        set(GrayPlot,'YData',map(:,1));
    end
    function callChemShift(source,event)
        itd=round(source.Value);
        HistPlot
        get(HistPlot)
        svec=sort(reshape(abs(M(:,:,itd)),n(1)*n(2),1)); 
        svec=(svec-svec(1))/(svec(end)-svec(1))*N;
        HistPlot.Data=svec;
        set(ImagePlot,'CData',abs(M(:,:,itd)));
        MaxABS=max(max(abs(M(:,:,itd))));
        AvgABS=sum(sum(abs(M(:,:,itd))))/(n(1)*n(2));
        set(textMAXAVG,'String',sprintf('Maximum_ABS=%.1f, average_ABS=%.1f',MaxABS,AvgABS));
        %figure
        %histogram(svec,'NumBins',N/4,'Normalization','probability','FaceColor' ,[0.5 0.5 0.5]);
        set(textChemShift,'String',sprintf('ChemShift %.1f Hz',frq(itd)));
    end
end