function PlotImag(M,varargin)
N=256;
Center=N/2;
Width=N/2;


    f1=figure('Name','Name of Image','Color','white','NumberTitle','off');
    % Create slider
    sliderCenter = uicontrol('Style', 'slider',...
        'Min',1,'Max',N,'Value',Center,...
        'Position', [315 80 200 20],...
        'Callback', @callSliderCenter); 
    textCenter = uicontrol('Style','Text',...
        'String','Center',...
        'Position', [270 80 50 20],...
        'BackgroundColor','white');
    
    sliderWidth = uicontrol('Style', 'slider',...
        'Min',1,'Max',N,'Value',Width,...
        'Position', [315 30 200 20],...
        'Callback', @callSliderWidth);
    textWidth = uicontrol('Style','Text',...
        'String','Width',...
        'Position', [270 30 50 20],...
        'BackgroundColor','white');
    
    

sImage=subplot(1,2,1);
imagesc(abs(M));
axis('square');
set(gca,'YTick',[])
set(gca,'XTick',[])
map= GrayMap(Center,Width,N);
colormap(map);
%colormap('Gray');
if nargin==2
   title(varargin{1}); 
end

n=size(M);
svec=sort(reshape(abs(M),n(1)*n(2),1));
%[svec(1) svec(end)]
svec=svec-svec(1);
%[svec(1) svec(end)]
svec=svec/svec(end)*N;
%[svec(1) svec(end)]






sGray=subplot(1,2,2);
GrayPlot=plot(map(:,1),'Color','black','LineWidth',2);
axis('square');
axis([0 N 0 1]);
set(gca,'YTick',[])
set(gca,'XTick',[])

hold on
histogram(svec,'NumBins',N/4,'Normalization','probability','FaceColor' ,[0.5 0.5 0.5]);


    function callSliderCenter(source,event)
        Center = source.Value;
        map= GrayMap(Center,Width,N);
        colormap(map);
        set(GrayPlot,'YData',map(:,1));
    end
    function callSliderWidth(source,event)
        Width = source.Value;
        map= GrayMap(Center,Width,N);
        colormap(map);
        set(GrayPlot,'YData',map(:,1));
    end

end