function PlotImagProc(kSpace,varargin)
N=256;
Center=N/2;
Width=N/2;
[GaussY GaussX]=size(kSpace);
AddX=GaussX*2;
AddY=GaussY*2;

    f1=figure('Name','Name of Image','Color','white','NumberTitle','off');
    % Create slider
    sliderCenter = uicontrol('Style', 'slider',...
        'Min',1,'Max',N,'Value',Center,...
        'Position', [315 80 200 20],...
        'Callback', @callSliderCenter); 
    textCenter = uicontrol('Style','Text',...
        'String','Center',...
        'Position', [270 80 50 20],...
        'BackgroundColor','white');
    
    sliderWidth = uicontrol('Style', 'slider',...
        'Min',1,'Max',N,'Value',Width,...
        'Position', [315 30 200 20],...
        'Callback', @callSliderWidth);
    textWidth = uicontrol('Style','Text',...
        'String','Width',...
        'Position', [270 30 50 20],...
        'BackgroundColor','white');
    
    GaussXEdit = uicontrol('Style', 'Edit',...
        'String',num2str(GaussX),...
        'Position', [400 370 50 30],...
        'Callback', @callEdit);
    textGx = uicontrol('Style','Text',...
        'String','GaussX',...
        'Position', [350 370 50 20],...
        'BackgroundColor','white');
    GaussYEdit = uicontrol('Style', 'Edit',...
        'String',num2str(GaussY),...
        'Position', [400 330 50 30],...
        'Callback', @callEdit);
    textGy = uicontrol('Style','Text',...
        'String','GaussY',...
        'Position', [350 330 50 20],...
        'BackgroundColor','white');

    AddXEdit = uicontrol('Style', 'Edit',...
        'String',num2str(AddX),...
        'Position', [500 370 50 30],...
        'Callback', @callEdit);
    textAx = uicontrol('Style','Text',...
        'String','AddX',...
        'Position', [450 370 50 20],...
        'BackgroundColor','white');
    AddYEdit = uicontrol('Style', 'Edit',...
        'String',num2str(AddY),...
        'Position', [500 330 50 30],...
        'Callback', @callEdit);
    textAy = uicontrol('Style','Text',...
        'String','AddY',...
        'Position', [450 330 50 20],...
        'BackgroundColor','white');
    
kSpaceGS=GAUSSaround(kSpace,GaussX,GaussY);
kSpaceAdd=addZEROSaround(kSpaceGS,GaussX,GaussY);
M=ifftshift(ifft2(kSpaceAdd));
       
sImage=subplot(1,2,1);
Mimage=imagesc(abs(M));
axis('square');


set(gca,'YTick',[])
set(gca,'XTick',[])
map= GrayMap(Center,Width,N);
colormap(map);
if nargin==2
   title(varargin{1}); 
end

n=size(M);
svec=sort(reshape(abs(M),n(1)*n(2),1));
svec=svec-svec(1);
svec=svec/svec(end)*N;

sGray=subplot(1,2,2);
GrayPlot=plot(map(:,1),'Color','black','LineWidth',2);
axis('square');
axis([0 N 0 1]);
set(gca,'YTick',[])
set(gca,'XTick',[])

hold on
histogram(svec,'NumBins',N/4,'Normalization','probability','FaceColor' ,[0.5 0.5 0.5]);


    function callSliderCenter(source,event)
        Center = source.Value;
        map= GrayMap(Center,Width,N);
        colormap(map);
        set(GrayPlot,'YData',map(:,1));
    end
    function callSliderWidth(source,event)
        Width = source.Value;
        map= GrayMap(Center,Width,N);
        colormap(map);
        set(GrayPlot,'YData',map(:,1));
    end
    function callEdit(source,event)
        GaussX = str2num(GaussXEdit.String);
        GaussY = str2num(GaussYEdit.String);
        AddX = str2num(AddXEdit.String);
        AddY = str2num(AddYEdit.String);
        Draw();
    end
%     function callGy(source,event)
%         GaussY = str2num(source.String);
%         Draw();
%     end
%     function callAddX(source,event)
%         
%         Draw();
%     end
%     function callAddY(source,event)
%         
%         Draw();
 %   end
    function Draw()
        kSpaceGS=GAUSSaround(kSpace,GaussX,GaussY);
        kSpaceAdd=addZEROSaround(kSpaceGS,AddX,AddY);
        M=ifftshift(ifft2(kSpaceAdd));
        set(Mimage,'CData',abs(M));
        [n1 n2]=size(M);        
        axis(sImage,[1 n2 1 n1]);
    end

end