function fig=PlotSLICE_M(SL,varargin)
if nargin==1
    fig=zeros(1,5);
    fig(1)=figure('Name','Name of Image','Color','white','NumberTitle','off');
    fig(2)=subplot(2,2,1);
    fig(6)=imagesc(SL.Mx);
    colorbar('location','EastOutside');
    axis('square');xlabel('X axis');ylabel('Y axis');
    title('Mx');

    fig(3)=subplot(2,2,2);
    fig(7)=imagesc(SL.My);
    colorbar('location','EastOutside');
    axis('square');xlabel('X axis');ylabel('Y axis');
    title('My');
    
    fig(4)=subplot(2,2,3);
    fig(8)=imagesc(SL.Mz);
    colorbar('location','EastOutside');
    axis('square');xlabel('X axis');ylabel('Y axis');
    title('Mz');
    
    fig(5)=subplot(2,2,4);
    fig(9)=imagesc(abs(SL.Mx+1i*SL.My));
    colorbar('location','EastOutside');
    axis('square');xlabel('X axis');ylabel('Y axis');
    title('abs(Mx+1i*My)');
elseif nargin==2
    fig=varargin{1};
    %fig(1)=figure('Name','Name of Image','Color','white','NumberTitle','off');
    %fig(2)=subplot(2,2,1);
    set(fig(6),'CData',SL.Mx);
    colorbar('location','EastOutside');
    axis('square');xlabel('X axis');ylabel('Y axis');


    %fig(3)=subplot(2,2,2);
    set(fig(7),'CData',SL.My);
    colorbar('location','EastOutside');
    axis('square');xlabel('X axis');ylabel('Y axis');

    %fig(4)=subplot(2,2,3);
    set(fig(8),'CData',SL.Mz);
    colorbar('location','EastOutside');
    axis('square');xlabel('X axis');ylabel('Y axis');

    %fig(5)=subplot(2,2,4);
    set(fig(9),'CData',abs(SL.Mx+1i*SL.My));
    colorbar('location','EastOutside');
    axis('square');xlabel('X axis');ylabel('Y axis');
end
colormap('Gray');
%colormap('Summer');
end

%colormap('Gray');
% colormap('Spring');
% colormap('Summer');+
% colormap('Autumn');+
% colormap('Hot');
% colormap('Cool');
% colormap('Copper');
% colormap('Pink');
