function PlotSpec(X,Y,varargin)
%%%%plot spectrum
if nargin==2
figure('Name','Spectrum','Color','white','NumberTitle','off');
end
subplot(3,1,1);
plot(X,real(Y),'Color','blue','LineWidth',2,'DisplayName','Spectrum');
set(gca,'Xdir','reverse')
xlabel('chemical shift,ppm (or Hz)');
title('Real part of spectrum');

subplot(3,1,2);
plot(X,imag(Y),'Color','red','LineWidth',2,'DisplayName','Spectrum');
set(gca,'Xdir','reverse')
xlabel('chemical shift,ppm (or Hz)');
title('Imaginary part of spectrum');

subplot(3,1,3);
plot(X,abs(Y),'Color','red','LineWidth',2,'DisplayName','Spectrum');
set(gca,'Xdir','reverse')
xlabel('chemical shift,ppm (or Hz)');
title('ABS mode of spectrum');
%%%%
end