function R2=RDD(S,r,tauc,H) %local fluctuating fields, extreeme narrowing regime
display('start to calculate relaxation super operator');    
display('RDD_EN');    
%%%%%%%%%%%%%%%%%%%calc  relaxation operator

Nstates=S.Nstates;
N=S.N;
J=zeros(Nstates,Nstates,Nstates,Nstates);
[Q, E]=eig(full(H));
iQ=inv(Q);
E=diag(E);
S=S.ChangeBasis(Q);

%calculate J in eigen basis
for n1=1:N-1
    for n2=n1+1:N
        T1p2=T2DD(S,+2,n1,n2);
        T1p1=T2DD(S,+1,n1,n2);
        T10 =T2DD(S, 0,n1,n2);
        T1m1=T2DD(S,-1,n1,n2);
        T1m2=T2DD(S,-2,n1,n2);
        for m1=1:N-1
            for m2=m1+1:N
                T2p2=T2DD(S,+2,m1,m2);
                T2p1=T2DD(S,+1,m1,m2);
                T20 =T2DD(S, 0,m1,m2);
                T2m1=T2DD(S,-1,m1,m2);
                T2m2=T2DD(S,-2,m1,m2);
                ksi=S.g_gh{n1}*S.g_gh{n2}*S.g_gh{m1}*S.g_gh{m2}*...                    
                P2(CosTheta(r,n1,n2,m1,m2))*(r(n1,n2)*r(m1,m2))^-3;
                for a=1:Nstates
                    for as=1:Nstates
                        for b=1:Nstates
                            for bs=1:Nstates                                                                
                            J(a,as,b,bs)=J(a,as,b,bs)+ksi*...
                                 (T1p2(a,as)*T2m2(bs,b)+...
                             (-1)*T1p1(a,as)*T2m1(bs,b)+...
                                   T10(a,as)* T20(bs,b)+...
                             (-1)*T1m1(a,as)*T2p1(bs,b)+...
                                  T1m2(a,as)*T2p2(bs,b)); 
                            end
                        end
                    end
                end
            end
        end
    end
end
%multiply Jabxy on J(wx-wy)
for a=1:Nstates
    for as=1:Nstates
        for b=1:Nstates
            for bs=1:Nstates                                                                
J(a,as,b,bs)=J(a,as,b,bs)*(1/(1+(tauc*(E(b)-E(bs)))^2)); 
            end
        end
    end
end
%change basis from eigen basis to zeeman basis back
Js=J*0;
for x=1:Nstates
    for y=1:Nstates
        for w=1:Nstates
            for z=1:Nstates
                
                for a=1:Nstates
                    for m=1:Nstates
                        for b=1:Nstates
                            for n=1:Nstates
Js(x,y,w,z)=Js(x,y,w,z)+J(a,m,b,n)*Q(x,a)*Q(z,n)*iQ(m,y)*iQ(b,w); 
                            end
                        end
                    end
                end
                
            end
        end
    end
end
J=Js;
%calculate RelaxationSuperoperator from J
R4=zeros(Nstates,Nstates,Nstates,Nstates);% 4 indexes
for a=1:Nstates
    %percentage=a/Nstates/2*100+50;
   % display(percentage);
    for as=1:Nstates
        for b=1:Nstates
            for bs=1:Nstates
                %if a-as-b+bs==0                    
                    R4(a,as,b,bs)=J(a,b,as,bs)+J(bs,as,b,a);
                    %R4(a,as,b,bs)=J(a,b,as,bs)*2; %Kowalewski
                    if as==bs
                        for g=1:Nstates
                        R4(a,as,b,bs)=R4(a,as,b,bs)-J(a,g,b,g);
                        %R4(a,as,b,bs)=R4(a,as,b,bs)-J(g,b,g,a); %Kowalewski
                        end
                    end
                    if a==b
                        for g=1:Nstates
                        R4(a,as,b,bs)=R4(a,as,b,bs)-J(g,as,g,bs);
                        %R4(a,as,b,bs)=R4(a,as,b,bs)-J(g,as,g,bs); %Kowalewski
                        end   
                    end
                %end
            end
        end
    end
end



%%%%%%%%%%%%%%%%%%%finish population relaxation operator 
R2=zeros(Nstates*Nstates,Nstates*Nstates);
I=0; 
for mu=1:Nstates
    for nu=1:Nstates
        I=I+1; II=0;
        for mus=1:Nstates
            for nus=1:Nstates
                II=II+1;
                R2(I,II)=R4(mu,nu,mus,nus);                                    
            end    
        end
    end    
end


%R2
%R2*(6/5)
%gH=26750;%rad/s /G
%tauc=100e-12; %time of correlation [s] 100ps
r0=1e-8; %value of distance 1e-8[cm]=1A=1e-10[m]
hbar=1.054571*1e-27; %erg*s
%6/5*wDD^2*tc
R2=(6/5)*r0^-6*hbar^2*(S.gH/1e4)^4*tauc*real(R2);
display('finish RLFF_EN');
end
  
  
  
  