function R2=RLFF_POP(S,T1,tauc,E) %local fluctuating fields, extreeme narrowing regime
    %display('start to calculate relaxation super operator');    
    %display('RLFF_EN');    
    %%%%%%%%%%%%%%%%%%%calc  relaxation operator
    Nstates=S.Nstates;
    N=S.N;

    [m1, m2]=size(E);
    if m1~=1 && m2~=1
        E=diag(E);
    end

    %%%%%%%%%%%%%%%%%%%calc population relaxation operator local fields!
    R2=zeros(Nstates,Nstates);% 2 indexes
    E=diag(E);
    for a=1:Nstates
        for b=a+1:Nstates
            for n=1:N
                R2(a,b)=R2(a,b)+1/T1(n)*(abs(S.x{n}(a,b))^2+abs(S.y{n}(a,b))^2+abs(S.z{n}(a,b))^2);                    
            end         
            R2(a,b)=1/(1+(2*pi*tauc*(E(a)-E(b)))^2)*R2(a,b);
            R2(b,a)=R2(a,b);
        end    
    end       
    %diagonal
    for a=1:Nstates  
        R2(a,a)=0;
        for g=1:Nstates
            if g~=a
                R2(a,a)=R2(a,a)-R2(g,a);
            end
        end
    end  
end
  
  
  
  