function ex = load_System(type)
    switch type        
        case "Eth-Acetate-d3-spin3"
            ex.S = SpinOperators(3,{'1H','1H','13C'});
            ex.SOs={ex.S.norm('x',3),ex.S.norm('y',3),ex.S.norm('z',3)};
            ChSh=[4.037, 1.178, 174]*1e-6;%chemical shift
            Jij=zeros(3);
            Jij(1,2)=7.1;
            Jij(1,3)=3.1;Jij(2,3)=-0.13;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;
            ex.eH=[1 2];
            ex.eC=[3];
            ex.n1=1;
            ex.n2=2;
        case "Eth-Acetate-d3-spin3-sCH2"
            ex.S = SpinOperators(3,{'1H','1H','13C'});
            ex.SOs={ex.S.norm('x',3),ex.S.norm('y',3),ex.S.norm('z',3)};
            ChSh=[4.037, 1.178, 174]*1e-6;%chemical shift
            Jij=zeros(3);
            Jij(1,2)=7.1;
            Jij(1,3)=3.1;Jij(2,3)=-0.13;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;
            ex.eH.sel=[1];
            ex.eH.all=[1,2];
            ex.eC=[3];
            ex.n1=1;
            ex.n2=2;
        case "Eth-Acetate-spin6"
            ex.S = SpinOperators(6,{'1H','1H','1H','1H','1H','13C'});
            ex.SOs={ex.S.norm('x',6),ex.S.norm('y',6),ex.S.norm('z',6)};
            d1=4.27;
            d2=2.42;
            ChSh=[d1,d1,d2,d2,d2,174]*1e-6;%chemical shift
            J12=7.15;
            J13=3.06;
            J23=-0.15;
            J00=-16;
            Jij=zeros(6);
            Jij(1,2)=J00;
            Jij(1,3)=J12;Jij(2,3)=J12;
            Jij(1,4)=J12;Jij(2,4)=J12;Jij(3,4)=J00;
            Jij(1,5)=J12;Jij(2,5)=J12;Jij(3,5)=J00;Jij(4,5)=J00;
            Jij(1,6)=J13;Jij(2,6)=J13;Jij(3,6)=J23;Jij(4,6)=J23;Jij(5,6)=J23;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;
            ex.eH=[1 2 3 4 5];
            ex.eC=[6]; 
            ex.n1=1;
            ex.n2=3;
        case "Eth-Acetate-spin6-sCH2"
            ex.S = SpinOperators(6,{'1H','1H','1H','1H','1H','13C'});
            ex.SOs={ex.S.norm('x',6),ex.S.norm('y',6),ex.S.norm('z',6)};
            d1=4.27;
            d2=2.42;
            ChSh=[d1,d1,d2,d2,d2,174]*1e-6;%chemical shift
            J12=7.15;
            J13=3.06;
            J23=-0.15;
            J00=-16;
            Jij=zeros(6);
            Jij(1,2)=J00;
            Jij(1,3)=J12;Jij(2,3)=J12;
            Jij(1,4)=J12;Jij(2,4)=J12;Jij(3,4)=J00;
            Jij(1,5)=J12;Jij(2,5)=J12;Jij(3,5)=J00;Jij(4,5)=J00;
            Jij(1,6)=J13;Jij(2,6)=J13;Jij(3,6)=J23;Jij(4,6)=J23;Jij(5,6)=J23;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;
            ex.eH.sel=[1 2];
            ex.eH.all=[1 2 3 4 5];
            ex.eC=[6];           
            ex.n1=1;
            ex.n2=3;
        case "Eth-Acetate-spin9"
            ex.S = SpinOperators(9,{'1H','1H','1H','1H','1H','1H','1H','1H','13C'});
            ex.SOs={ex.S.norm('x',9),ex.S.norm('y',9),ex.S.norm('z',9)};
            d1=4.27;
            d2=2.42;
            d3=1.5;%?
            ChSh=[d1,d1,d2,d2,d2,d3,d3,d3,174]*1e-6;%chemical shift
            J12=7.15;
            J13=3.06;
            J23=-0.15;
            J43=-6.82;
            J00=-16;
            Jij=zeros(9);
            Jij(1,2)=J00;
            Jij(1,3)=J12;Jij(2,3)=J12;
            Jij(1,4)=J12;Jij(2,4)=J12;Jij(3,4)=J00;
            Jij(1,5)=J12;Jij(2,5)=J12;Jij(3,5)=J00;Jij(4,5)=J00;
            Jij(1,6)=000;Jij(2,6)=000;Jij(3,6)=000;Jij(4,6)=000;Jij(5,6)=000;
            Jij(1,7)=000;Jij(2,7)=000;Jij(3,7)=000;Jij(4,7)=000;Jij(5,7)=000;Jij(6,7)=J00;
            Jij(1,8)=000;Jij(2,8)=000;Jij(3,8)=000;Jij(4,8)=000;Jij(5,8)=000;Jij(6,8)=J00;Jij(7,8)=J00;
            Jij(1,9)=J13;Jij(2,9)=J13;Jij(3,9)=J23;Jij(4,9)=J23;Jij(5,9)=J23;Jij(6,9)=J43;Jij(7,9)=J43;Jij(8,9)=J43;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;
            ex.eH=[1 2 3 4 5 6 7 8];
            ex.eC=[9]; 
            ex.n1=1;
            ex.n2=3;
        case "Eth-Acetate-spin9-sCH2"
            ex.S = SpinOperators(9,{'1H','1H','1H','1H','1H','1H','1H','1H','13C'});
            ex.SOs={ex.S.norm('x',9),ex.S.norm('y',9),ex.S.norm('z',9)};
            d1=4.27;
            d2=2.42;
            d3=1.5;%?
            ChSh=[d1,d1,d2,d2,d2,d3,d3,d3,174]*1e-6;%chemical shift
            J12=7.15;
            J13=3.06;
            J23=-0.15;
            J43=-6.82;
            J00=-16;
            Jij=zeros(9);
            Jij(1,2)=J00;
            Jij(1,3)=J12;Jij(2,3)=J12;
            Jij(1,4)=J12;Jij(2,4)=J12;Jij(3,4)=J00;
            Jij(1,5)=J12;Jij(2,5)=J12;Jij(3,5)=J00;Jij(4,5)=J00;
            Jij(1,6)=000;Jij(2,6)=000;Jij(3,6)=000;Jij(4,6)=000;Jij(5,6)=000;
            Jij(1,7)=000;Jij(2,7)=000;Jij(3,7)=000;Jij(4,7)=000;Jij(5,7)=000;Jij(6,7)=J00;
            Jij(1,8)=000;Jij(2,8)=000;Jij(3,8)=000;Jij(4,8)=000;Jij(5,8)=000;Jij(6,8)=J00;Jij(7,8)=J00;
            Jij(1,9)=J13;Jij(2,9)=J13;Jij(3,9)=J23;Jij(4,9)=J23;Jij(5,9)=J23;Jij(6,9)=J43;Jij(7,9)=J43;Jij(8,9)=J43;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;            
            ex.eH.sel=[1 2];
            ex.eH.all=[1 2 3 4 5 6 7 8];
            ex.eC=[9];           
            ex.n1=1;
            ex.n2=3;
            
        case "Eth-Pyruvate-spin9"
            ex.S = SpinOperators(9,{'1H','1H','1H','1H','1H','1H','1H','1H','13C'});
            ex.SOs={ex.S.norm('x',9),ex.S.norm('y',9),ex.S.norm('z',9)};
            d1=4.27;
            d2=2.43;
            d3=1.32;%?
            ChSh=[d1,d1,d2,d2,d2,d3,d3,d3,174]*1e-6;%chemical shift
            J12=7.1;
            J13=3.0;
            J23=-0.1;
            J43=1.47;
            J00=-16;
            Jij=zeros(9);
            Jij(1,2)=J00;
            Jij(1,3)=J12;Jij(2,3)=J12;
            Jij(1,4)=J12;Jij(2,4)=J12;Jij(3,4)=J00;
            Jij(1,5)=J12;Jij(2,5)=J12;Jij(3,5)=J00;Jij(4,5)=J00;
            Jij(1,6)=000;Jij(2,6)=000;Jij(3,6)=000;Jij(4,6)=000;Jij(5,6)=000;
            Jij(1,7)=000;Jij(2,7)=000;Jij(3,7)=000;Jij(4,7)=000;Jij(5,7)=000;Jij(6,7)=J00;
            Jij(1,8)=000;Jij(2,8)=000;Jij(3,8)=000;Jij(4,8)=000;Jij(5,8)=000;Jij(6,8)=J00;Jij(7,8)=J00;
            Jij(1,9)=J13;Jij(2,9)=J13;Jij(3,9)=J23;Jij(4,9)=J23;Jij(5,9)=J23;Jij(6,9)=J43;Jij(7,9)=J43;Jij(8,9)=J43;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;
            ex.eH=[1 2 3 4 5 6 7 8];
            ex.eC=[9]; 
            ex.n1=1;
            ex.n2=3;
            
        case "Eth-PyruvateD3-spin9"
            ex.S = SpinOperators(9,{'1H','2H','1H','2H','2H','1H','1H','1H','13C'});
            ex.SOs={ex.S.norm('x',9),ex.S.norm('y',9),ex.S.norm('z',9)};
            f=ex.S.g_gh{2};            
            d1=4.27;
            d2=2.43;
            d3=1.32;%?
            ChSh=[d1,d1,d2,d2,d2,d3,d3,d3,174]*1e-6;%chemical shift
            J12=7.1;
            J13=3.0;
            J23=-0.1;
            J43=1.47;
            J00=-16;
            Jij=zeros(9);
            Jij(1,2)=J00*f;
            Jij(1,3)=J12;  Jij(2,3)=J12*f;
            Jij(1,4)=J12*f;Jij(2,4)=J12*f*f;Jij(3,4)=J00*f;
            Jij(1,5)=J12*f;Jij(2,5)=J12*f*f;Jij(3,5)=J00*f;Jij(4,5)=J00*f*f;
            Jij(1,6)=000;  Jij(2,6)=000*f;  Jij(3,6)=000;  Jij(4,6)=000*f;Jij(5,6)=000*f;
            Jij(1,7)=000;  Jij(2,7)=000*f;  Jij(3,7)=000;  Jij(4,7)=000*f;Jij(5,7)=000*f;Jij(6,7)=J00;
            Jij(1,8)=000;  Jij(2,8)=000*f;  Jij(3,8)=000;  Jij(4,8)=000*f;Jij(5,8)=000*f;Jij(6,8)=J00;Jij(7,8)=J00;
            Jij(1,9)=J13  ;Jij(2,9)=J13*f;  Jij(3,9)=J23;  Jij(4,9)=J23*f;Jij(5,9)=J23*f;Jij(6,9)=J43;Jij(7,9)=J43;Jij(8,9)=J43;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;
            ex.eH=[1 2 3 4 5 6 7 8];
            ex.eC=[9]; 
            ex.n1=1;
            ex.n2=3;
            
         case "Eth-PyruvateD6-spin9"
            ex.S = SpinOperators(9,{'1H','2H','1H','2H','2H','2H','2H','2H','13C'});
            ex.SOs={ex.S.norm('x',9),ex.S.norm('y',9),ex.S.norm('z',9)};
            f=ex.S.g_gh{2};            
            d1=4.27;
            d2=2.43;
            d3=1.32;%?
            ChSh=[d1,d1,d2,d2,d2,d3,d3,d3,174]*1e-6;%chemical shift
            J12=7.1;
            J13=3.0;
            J23=-0.1;
            J43=1.47;
            J00=-16;
            Jij=zeros(9);
            Jij(1,2)=J00*f;
            Jij(1,3)=J12;  Jij(2,3)=J12*f;
            Jij(1,4)=J12*f;Jij(2,4)=J12*f*f;Jij(3,4)=J00*f;
            Jij(1,5)=J12*f;Jij(2,5)=J12*f*f;Jij(3,5)=J00*f;Jij(4,5)=J00*f*f;
            Jij(1,6)=000*f;Jij(2,6)=000*f*f;Jij(3,6)=000*f;Jij(4,6)=000*f*f;Jij(5,6)=000*f*f;
            Jij(1,7)=000*f;Jij(2,7)=000*f*f;Jij(3,7)=000*f;Jij(4,7)=000*f*f;Jij(5,7)=000*f*f;Jij(6,7)=J00*f*f;
            Jij(1,8)=000*f;Jij(2,8)=000*f*f;Jij(3,8)=000*f;Jij(4,8)=000*f*f;Jij(5,8)=000*f*f;Jij(6,8)=J00*f*f;Jij(7,8)=J00*f*f;
            Jij(1,9)=J13;  Jij(2,9)=J13*f;  Jij(3,9)=J23;  Jij(4,9)=J23*f;  Jij(5,9)=J23*f;  Jij(6,9)=J43*f;  Jij(7,9)=J43*f;  Jij(8,9)=J43*f;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;
            ex.eH=[1 2 3 4 5 6 7 8];
            ex.eC=[9]; 
            ex.n1=1;
            ex.n2=3;   
                                   
        case "Eth-Pyruvate-spin9-sCH2"
            ex.S = SpinOperators(9,{'1H','1H','1H','1H','1H','1H','1H','1H','13C'});
            ex.SOs={ex.S.norm('x',9),ex.S.norm('y',9),ex.S.norm('z',9)};
            d1=4.27;
            d2=2.43;
            d3=1.32;%?
            ChSh=[d1,d1,d2,d2,d2,d3,d3,d3,174]*1e-6;%chemical shift
            J12=7.1;
            J13=3.0;
            J23=-0.1;
            J43=1.47;
            J00=-16;
            Jij=zeros(9);
            Jij(1,2)=J00;
            Jij(1,3)=J12;Jij(2,3)=J12;
            Jij(1,4)=J12;Jij(2,4)=J12;Jij(3,4)=J00;
            Jij(1,5)=J12;Jij(2,5)=J12;Jij(3,5)=J00;Jij(4,5)=J00;
            Jij(1,6)=000;Jij(2,6)=000;Jij(3,6)=000;Jij(4,6)=000;Jij(5,6)=000;
            Jij(1,7)=000;Jij(2,7)=000;Jij(3,7)=000;Jij(4,7)=000;Jij(5,7)=000;Jij(6,7)=J00;
            Jij(1,8)=000;Jij(2,8)=000;Jij(3,8)=000;Jij(4,8)=000;Jij(5,8)=000;Jij(6,8)=J00;Jij(7,8)=J00;
            Jij(1,9)=J13;Jij(2,9)=J13;Jij(3,9)=J23;Jij(4,9)=J23;Jij(5,9)=J23;Jij(6,9)=J43;Jij(7,9)=J43;Jij(8,9)=J43;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;            
            ex.eH.sel=[1 2];
            ex.eH.all=[1 2 3 4 5 6 7 8];
            ex.eC=[9];           
            ex.n1=1;
            ex.n2=3;
            
        case "Eth-PyruvateD6-spin3"
            ex.S = SpinOperators(3,{'1H','1H','13C'});
            ex.SOs={ex.S.norm('x',3),ex.S.norm('y',3),ex.S.norm('z',3)};
            d1=4.27;
            d2=2.43;            
            ChSh=[d1,d2,174]*1e-6;%chemical shift
            J12=7.1;
            J13=3.0;
            J23=-0.1;                        
            Jij=zeros(3);
            Jij(1,2)=J12;
            Jij(1,3)=J13;Jij(2,3)=J23;                        
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;
            ex.eH=[1 2];
            ex.eC=[3]; 
            ex.n1=1;
            ex.n2=2;
            
        case "Eth-PyruvateD6-spin3-sCH2"
            ex.S = SpinOperators(3,{'1H','1H','13C'});
            ex.SOs={ex.S.norm('x',3),ex.S.norm('y',3),ex.S.norm('z',3)};
            d1=4.27;
            d2=2.43;            
            ChSh=[d1,d2,174]*1e-6;%chemical shift
            J12=7.1;
            J13=3.0;
            J23=-0.1;                        
            Jij=zeros(3);
            Jij(1,2)=J12;
            Jij(1,3)=J13;Jij(2,3)=J23;                        
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;
            ex.eH.sel=[1];
            ex.eH.all=[1 2];
            ex.eC=[3]; 
            ex.n1=1;
            ex.n2=2;
            
            
         case "PLAC-spins-6"
            ex.S = SpinOperators(6,{'1H','1H','1H','1H','31P','13C'});
            ex.SOs={ex.S.norm('x',6),ex.S.norm('y',6),ex.S.norm('z',6)};
            d1=4;%tentative 
            d2=1;%tentative 
            d31P=0;%not relevant
            ChSh=[d1,d2,d2,d2,d31P,174]*1e-6;%chemical shift
            J12=6.9;
            J1C=-3.8;%+-
            J2C=4.07;
            J1P=8.6;
            J2P=0;
            JCP=6.52;
            J00=-16;
            Jij=zeros(6);
            Jij(1,2)=J12;
            Jij(1,3)=J12;Jij(2,3)=J00;
            Jij(1,4)=J12;Jij(2,4)=J00;Jij(3,4)=J00;
            Jij(1,5)=J1P;Jij(2,5)=J2P;Jij(3,5)=J2P;Jij(4,5)=J2P;
            Jij(1,6)=J1C;Jij(2,6)=J2C;Jij(3,6)=J2C;Jij(4,6)=J2C;Jij(5,6)=JCP;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;
            ex.eH=[1 2 3 4];
            ex.eC=[6]; 
            ex.n1=1;
            ex.n2=2;
        case "PLAC-spins-6-sCH"
            ex.S = SpinOperators(6,{'1H','1H','1H','1H','31P','13C'});
            ex.SOs={ex.S.norm('x',6),ex.S.norm('y',6),ex.S.norm('z',6)};
            d1=4;%tentative 
            d2=1;%tentative 
            d31P=0;%not relevant
            ChSh=[d1,d2,d2,d2,d31P,174]*1e-6;%chemical shift
            J12=6.9;
            J1C=-3.8;%+-
            J2C=4.07;
            J1P=8.6;
            J2P=0;
            JCP=6.52;
            J00=-16;
            Jij=zeros(6);
            Jij(1,2)=J12;
            Jij(1,3)=J12;Jij(2,3)=J00;
            Jij(1,4)=J12;Jij(2,4)=J00;Jij(3,4)=J00;
            Jij(1,5)=J1P;Jij(2,5)=J2P;Jij(3,5)=J2P;Jij(4,5)=J2P;
            Jij(1,6)=J1C;Jij(2,6)=J2C;Jij(3,6)=J2C;Jij(4,6)=J2C;Jij(5,6)=JCP;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;
            ex.eH.sel=[1];
            ex.eH.all=[1 2 3 4];
            ex.eC=[6]; 
            ex.n1=1;
            ex.n2=2;     
            
        case "PLAC-spins-6-sCH3"
            ex.S = SpinOperators(6,{'1H','1H','1H','1H','31P','13C'});
            ex.SOs={ex.S.norm('x',6),ex.S.norm('y',6),ex.S.norm('z',6)};
            d1=4;%tentative 
            d2=1;%tentative 
            d31P=0;%not relevant
            ChSh=[d1,d2,d2,d2,d31P,174]*1e-6;%chemical shift
            J12=6.9;
            J1C=-3.8;%+-
            J2C=4.07;
            J1P=8.6;
            J2P=0;
            JCP=6.52;
            J00=-16;
            Jij=zeros(6);
            Jij(1,2)=J12;
            Jij(1,3)=J12;Jij(2,3)=J00;
            Jij(1,4)=J12;Jij(2,4)=J00;Jij(3,4)=J00;
            Jij(1,5)=J1P;Jij(2,5)=J2P;Jij(3,5)=J2P;Jij(4,5)=J2P;
            Jij(1,6)=J1C;Jij(2,6)=J2C;Jij(3,6)=J2C;Jij(4,6)=J2C;Jij(5,6)=JCP;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;
            ex.eH.sel=[2 3 4];
            ex.eH.all=[1 2 3 4];
            ex.eC=[6]; 
            ex.n1=1;
            ex.n2=2;  
            
        case "PLACd2-spins-4"
            ex.S = SpinOperators(4,{'1H','1H','31P','13C'});
            ex.SOs={ex.S.norm('x',4),ex.S.norm('y',4),ex.S.norm('z',4)};
            d1=4;%tentative 
            d2=1;%tentative 
            d31P=0;%not relevant
            ChSh=[d1,d2,d31P,174]*1e-6;%chemical shift
            J12=6.9;
            J1C=-3.8;%+-
            J2C=4.07;
            J1P=8.6;
            J2P=0;
            JCP=6.52;
            J00=-16;
            Jij=zeros(6);
            Jij(1,2)=J12;
            Jij(1,3)=J1P;Jij(2,3)=J2P;            
            Jij(1,4)=J1C;Jij(2,4)=J2C;Jij(3,4)=JCP;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;
            ex.eH=[1 2];
            ex.eC=[4]; 
            ex.n1=1;
            ex.n2=2;
        case "PLACd2-spins-4-sCH"
            ex.S = SpinOperators(4,{'1H','1H','31P','13C'});
            ex.SOs={ex.S.norm('x',4),ex.S.norm('y',4),ex.S.norm('z',4)};
            d1=4;%tentative 
            d2=1;%tentative 
            d31P=0;%not relevant
            ChSh=[d1,d2,d31P,174]*1e-6;%chemical shift
            J12=6.9;
            J1C=-3.8;%+-
            J2C=4.07;
            J1P=8.6;
            J2P=0;
            JCP=6.52;
            J00=-16;
            Jij=zeros(4);
            Jij(1,2)=J12;
            Jij(1,3)=J1P;Jij(2,3)=J2P;            
            Jij(1,4)=J1C;Jij(2,4)=J2C;Jij(3,4)=JCP;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;
            ex.eH.sel=[1];
            ex.eH.all=[1 2];
            ex.eC=[4]; 
            ex.n1=1;
            ex.n2=2;   
            
        case "PLACd2-spins-4-sCH3"
            ex.S = SpinOperators(4,{'1H','1H','31P','13C'});
            ex.SOs={ex.S.norm('x',4),ex.S.norm('y',4),ex.S.norm('z',4)};
            d1=4;%tentative 
            d2=1;%tentative 
            d31P=0;%not relevant
            ChSh=[d1,d2,d31P,174]*1e-6;%chemical shift
            J12=6.9;
            J1C=-3.8;%+-
            J2C=4.07;
            J1P=8.6;
            J2P=0;
            JCP=6.52;
            J00=-16;
            Jij=zeros(4);
            Jij(1,2)=J12;
            Jij(1,3)=J1P;Jij(2,3)=J2P;            
            Jij(1,4)=J1C;Jij(2,4)=J2C;Jij(3,4)=JCP;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;
            ex.eH.sel=[2];
            ex.eH.all=[1 2];
            ex.eC=[4]; 
            ex.n1=1;
            ex.n2=2;  
            
        case "HEP-d3"
            ex.S = SpinOperators(3,{'1H','1H','13C'});
            ex.SOs={ex.S.norm('x',3),ex.S.norm('y',3),ex.S.norm('z',3)};
            ChSh=[2.41, 1.14, 174]*1e-6;%chemical shift
            Jij=zeros(3);
            Jij(1,2)=7.57;
            Jij(1,3)=7.24;Jij(2,3)=-5.62;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;
            ex.eH=[1 2];
            ex.eC=[3];
            ex.n1=1;
            ex.n2=2;
            
        case 'HEP-d3-sCH3'
            ex.S = SpinOperators(3,{'1H','1H','13C'});
            ex.SOs={ex.S.norm('x',3),ex.S.norm('y',3),ex.S.norm('z',3)};
            ChSh=[2.41, 1.14, 174]*1e-6;%chemical shift
            Jij=zeros(3);
            Jij(1,2)=7.57;
            Jij(1,3)=7.24;Jij(2,3)=-5.62;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;
            ex.eH.sel=[2];
            ex.eH.all=[1,2];
            ex.eC=[3];
            ex.n1=1;
            ex.n2=2;
        case 'HEP-d3-sCH2'
            ex.S = SpinOperators(3,{'1H','1H','13C'});
            ex.SOs={ex.S.norm('x',3),ex.S.norm('y',3),ex.S.norm('z',3)};
            ChSh=[2.41, 1.14, 174]*1e-6;%chemical shift
            Jij=zeros(3);
            Jij(1,2)=7.57;
            Jij(1,3)=7.24;Jij(2,3)=-5.62;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;
            ex.eH.sel=[1];
            ex.eH.all=[1,2];
            ex.eC=[3];
            ex.n1=1;
            ex.n2=2;
             
        case "HEP-d3-spins-5"
            ex.S = SpinOperators(5,{'1H','1H','13C','1H','1H'});
            ex.SOs={ex.S.norm('x',3),ex.S.norm('y',3),ex.S.norm('z',3)};
            ChSh=[2.41, 1.14, 174, 3.7, 3.7]*1e-6;%chemical shift
            Jij=zeros(5);
            Jij(1,2)=7.57;
            Jij(1,3)=7.24;Jij(2,3)=-5.62;
            Jij(1,4)=0000;Jij(2,4)=00000;Jij(3,4)=3.1;
            Jij(1,5)=0000;Jij(2,5)=00000;Jij(3,5)=3.1;Jij(4,5)=-15;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;
            ex.eH=[1 2 4 5];
            ex.eC=[3];
            ex.n1=1;
            ex.n2=2;
            
        case "HEP-d3-spins-5-sCH3"
            ex.S = SpinOperators(5,{'1H','1H','13C','1H','1H'});
            ex.SOs={ex.S.norm('x',3),ex.S.norm('y',3),ex.S.norm('z',3)};
            ChSh=[2.41, 1.14, 174, 3.7, 3.7]*1e-6;%chemical shift
            Jij=zeros(5);
            Jij(1,2)=7.57;
            Jij(1,3)=7.24;Jij(2,3)=-5.62;
            Jij(1,4)=0000;Jij(2,4)=00000;Jij(3,4)=3.1;
            Jij(1,5)=0000;Jij(2,5)=00000;Jij(3,5)=3.1;Jij(4,5)=-15;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;            
            ex.eH.sel=[2];
            ex.eH.all=[1 2 4 5];
            ex.eC=[3];
            ex.n1=1;
            ex.n2=2;
            
        case "HEP-d3-spins-5-sCH2"
            ex.S = SpinOperators(5,{'1H','1H','13C','1H','1H'});
            ex.SOs={ex.S.norm('x',3),ex.S.norm('y',3),ex.S.norm('z',3)};
            ChSh=[2.41, 1.14, 174, 3.7, 3.7]*1e-6;%chemical shift
            Jij=zeros(5);
            Jij(1,2)=7.57;
            Jij(1,3)=7.24;Jij(2,3)=-5.62;
            Jij(1,4)=0000;Jij(2,4)=00000;Jij(3,4)=3.1;
            Jij(1,5)=0000;Jij(2,5)=00000;Jij(3,5)=3.1;Jij(4,5)=-15;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;            
            ex.eH.sel=[1];
            ex.eH.all=[1 2 4 5];
            ex.eC=[3];
            ex.n1=1;
            ex.n2=2;
            
            
        case "HEP-spins-6"
            ex.S = SpinOperators(6,{'1H','1H','1H','1H','1H','13C'});
            ex.SOs={ex.S.norm('x',6),ex.S.norm('y',6),ex.S.norm('z',6)};
            d1=2.41;
            d2=1.14;
            ChSh=[d1,d1,d2,d2,d2,174]*1e-6;%chemical shift
            J12=7.57;
            J13=7.24;
            J23=-5.62;            
            J00=-16;
            Jij=zeros(6);
            Jij(1,2)=J00;
            Jij(1,3)=J12;Jij(2,3)=J12;
            Jij(1,4)=J12;Jij(2,4)=J12;Jij(3,4)=J00;
            Jij(1,5)=J12;Jij(2,5)=J12;Jij(3,5)=J00;Jij(4,5)=J00;
            Jij(1,6)=J13;Jij(2,6)=J13;Jij(3,6)=J23;Jij(4,6)=J23;Jij(5,6)=J23;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;
            ex.eH=[1 2 3 4 5];
            ex.eC=[6]; 
            ex.n1=1;
            ex.n2=3;
            

        case "HEP-spins-6-sCH3"
            ex.S = SpinOperators(6,{'1H','1H','1H','1H','1H','13C'});
            ex.SOs={ex.S.norm('x',6),ex.S.norm('y',6),ex.S.norm('z',6)};
            d1=2.41;
            d2=1.14;
            ChSh=[d1,d1,d2,d2,d2,174]*1e-6;%chemical shift
            J12=7.57;
            J13=7.24;
            J23=-5.62;
            J00=-16;
            Jij=zeros(6);
            Jij(1,2)=J00;
            Jij(1,3)=J12;Jij(2,3)=J12;
            Jij(1,4)=J12;Jij(2,4)=J12;Jij(3,4)=J00;
            Jij(1,5)=J12;Jij(2,5)=J12;Jij(3,5)=J00;Jij(4,5)=J00;
            Jij(1,6)=J13;Jij(2,6)=J13;Jij(3,6)=J23;Jij(4,6)=J23;Jij(5,6)=J23;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;
            ex.eH.sel=[3 4 5];
            ex.eH.all=[1 2 3 4 5];
            ex.eC=[6]; 
            ex.n1=1;
            ex.n2=3;
            
        case "HEP-spins-6-sCH2"
            ex.S = SpinOperators(6,{'1H','1H','1H','1H','1H','13C'});
            ex.SOs={ex.S.norm('x',6),ex.S.norm('y',6),ex.S.norm('z',6)};
            d1=2.41;
            d2=1.14;
            ChSh=[d1,d1,d2,d2,d2,174]*1e-6;%chemical shift
            J13=7.24;
            J23=-5.62;
            J23=7.24;
            J00=-16;
            Jij=zeros(6);
            Jij(1,2)=J00;
            Jij(1,3)=J12;Jij(2,3)=J12;
            Jij(1,4)=J12;Jij(2,4)=J12;Jij(3,4)=J00;
            Jij(1,5)=J12;Jij(2,5)=J12;Jij(3,5)=J00;Jij(4,5)=J00;
            Jij(1,6)=J13;Jij(2,6)=J13;Jij(3,6)=J23;Jij(4,6)=J23;Jij(5,6)=J23;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;
            ex.eH.sel=[1 2];
            ex.eH.all=[1 2 3 4 5];
            ex.eC=[6]; 
            ex.n1=1;
            ex.n2=3;     
            
            
        case "ABX_7Hz-sA"
            ex.S = SpinOperators(3,{'1H','1H','13C'});
            ex.SOs={ex.S.norm('x',3),ex.S.norm('y',3),ex.S.norm('z',3)};
            ChSh=[3, 0, 170]*1e-6;%chemical shift
            Jij=zeros(3);
            Jij(1,2)=7;
            Jij(1,3)=3.1;Jij(2,3)=-0.13;
            Jij=Jij+Jij';%Hz
            
            ex.J=Jij;
            ex.ChSh=ChSh;
            ex.eH.sel=[1];
            ex.eH.all=[1,2];
            ex.eC=[3];
            ex.n1=1;
            ex.n2=2;
            
            
            
        otherwise
            error
    end
end

