%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all; %clear all and delete all previous data
LoadPath();
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
tic 
%%%%%%%%%%%%%%%%%  phINEPT+, start from S, evolution during seq %%%%%%
%___1__ 2___3____4____5___6____7___8_____9__10
%phINEPTplus
%1H%__(45)Y-t1-(180)X-t1-(90)Y-t2-(180)X-t2
% X%_______-t1-(180)X-t1-(90)X-t2-(180)X-t2-FID
%sel90_phINEPTplus
%1H%__(90)Ysel-t1-(180)X-t1-(90)Y-t2-(180)X-t2
% X%__________-t1-(180)X-t1-(90)X-t2-(180)X-t2-FID

System=load_System_name();
System_index=2;

INEPT_type{1}=         "phINEPTplus";
INEPT_type{2}=   "sel90_phINEPTplus";
INEPT_type_index=2;

ex = load_System(System{System_index});
ex.B0=9.4;% Tesla
ex.t1v = linspace(0.0,0.2,31)';
ex.t2v = linspace(0.0,0.2,30)';

Ymap = get_INEPTmap(ex,INEPT_type{INEPT_type_index});

plot_Ymap(ex,Ymap);

Folder="out/";
save_Ymap(Folder,INEPT_type{INEPT_type_index},System{System_index},ex,Ymap)

toc








