classdef MRI_3DO
    %O3ICE Summary of this class goes here
    %   Detailed explanation goes here
    
    properties
        
    end    
    properties (SetAccess = public)
        Nx %[integer] column
        Ny %[integer] row
        Nz
        Dx %[cm]
        Dy %[cm]
        Dz
        
        
        Dens %[a.u]
        T1 %[s]
        T2 %[s]
        Mx
        My
        Mz
        M0
        Vx
        Vy
        Vz        
    end
    methods 
        function O3 = MRI_3DO(varargin)    
            %name,  size os spins, size in cm,  size of box,  ,Hdens, T1,T2, coord of tube and rad            
            % 1  ,    2,                3    ,       4                   ,5       
            %Name, [Ny,Nx,Nz],      [Dx,Dy,Dz], [ry0,ry1,rx0,rx1,rz0,rz1], [Dens,T1,T2]
                O3.M0=1;    
            if strcmp(varargin{1},'Box') 
                display('create Box');
                
                O3.Ny=varargin{2}(1);
                O3.Nx=varargin{2}(2);
                O3.Nz=varargin{2}(3);
                
                O3.Dx=varargin{3}(1);%[cm]            
                O3.Dy=varargin{3}(2);%[cm] 
                O3.Dz=varargin{3}(3);%[cm] 
                
                O3.Dens=zeros(O3.Ny,O3.Nx,O3.Nz);
                O3.T1 = O3.Dens;
                O3.T2 = O3.Dens;
                
                O3.Mx = O3.Dens;
                O3.My = O3.Dens;
                O3.Mz = O3.Dens;
                
                O3.Vx = O3.Dens;
                O3.Vy = O3.Dens;
                O3.Vz = O3.Dens;                                                
                
                x1=varargin{4}(3);y1=varargin{4}(1);z1=varargin{4}(5);
                x2=varargin{4}(4);y2=varargin{4}(2);z2=varargin{4}(6);
                O3.Dens(y1:y2,x1:x2,z1:z2)=varargin{5}(1);
                O3.T1(y1:y2,x1:x2,z1:z2)=varargin{5}(2);
                O3.T2(y1:y2,x1:x2,z1:z2)=varargin{5}(3);
                O3.Mz(y1:y2,x1:x2,z1:z2)=O3.M0;
            else
                error('we do not support anything else but ''Box'' ');
            end                                                                                  
        end        
        
        function O3 = AddObj(obj,Name,SZ,DTT,varargin)
            %TubeOZ [y0,x0,R](pixels), [Dens, T1(sec),T2(sec)], Vz(cm/sec)
            O3=obj;
            if strcmp(Name,'TubeOZ')
                x0=SZ(2);
                y0=SZ(1);
                R=SZ(3);
                v0=varargin{1}(1);                
                for xi=1:O3.Nx
                    for yi=1:O3.Ny    
                        r=sqrt((xi-x0)^2+(yi-y0)^2);
                        if r<=R                                                    
                            O3.Vz(yi,xi,:)=v0*(1-(r/R)^2);
                            O3.Dens(yi,xi,:)=DTT(1);
                            O3.T1(yi,xi,:)=DTT(2);
                            O3.T2(yi,xi,:)=DTT(3);
                        end
                    end
                end
            else
                error('we do not support anything else but ''Tube'' ');
            end
            
        end        
        
        function obj = SetIC(obj,x,y,z)
%             for iy=1:obj.Ny                
%                 for ix=1:obj.Nx
%                     if obj.T1(iy,ix)~=0 && obj.T2(iy,ix)~=0 && obj.Dens(iy,ix)~=0
%                         obj.Mx(iy,ix)=x;
%                         obj.My(iy,ix)=y;
%                         obj.Mz(iy,ix)=z;
%                     end
%                 end
%             end             
         end
                
        function ShowFrame(obj)
%             f1=figure('Name','Name of Image','Color','white','NumberTitle','off');
%             
%             s1=subplot(2,2,1);
%             imagesc(obj.Dens);
%             colorbar('location','EastOutside')
%             axis('square');xlabel('X axis');ylabel('Y axis');
%             title('proton Dens');
% 
%             s2=subplot(2,2,2);
%             imagesc(obj.T2);
%             colorbar('location','EastOutside')
%             axis('square');xlabel('X axis');ylabel('Y axis');
%             title('T2');
% 
%             s3=subplot(2,2,3);
%             imagesc(obj.T1);
%             colorbar('location','EastOutside')
%             axis('square');xlabel('X axis');ylabel('Y axis');
%             title('T1');            
%             
%             colormap('Gray');
%             %colormap('Summer');
        end
        
        function ShowFieldHomogeneity(obj,varargin)
%             figure('Name','Name of Image','Color','white','NumberTitle','off');
%             if nargin==2
%                 FHZ=varargin{1};
%                 FHX=FHZ*0;
%                 FHY=FHZ*0;                
%             elseif nargin==4
%                 FHX=varargin{1};
%                 FHY=varargin{2};
%                 FHZ=varargin{3};
%             else
%                 error('error');
%             end
%                         
%             subplot(2,2,1);
%             imagesc(FHX);
%             colorbar('location','EastOutside')
%             axis('square');xlabel('X axis');ylabel('Y axis');
%             title('Homogeneity Bx');
% 
%             subplot(2,2,2);
%             imagesc(FHY);
%             colorbar('location','EastOutside')
%             axis('square');xlabel('X axis');ylabel('Y axis');
%             title('Homogeneity By');
% 
%             subplot(2,2,3);
%             imagesc(FHZ);
%             colorbar('location','EastOutside')
%             axis('square');xlabel('X axis');ylabel('Y axis');
%             title('Homogeneity Bz');            
%             
%             colormap('Gray');
%             %colormap('Summer');
        end
        
        function O3=IdealRotation(obj,angle,dir,YYXXZZ)
            O3=obj;
            c=cos(angle);
            s=sin(angle);
            XX=YYXXZZ{2};
            YY=YYXXZZ{1};
            ZZ=YYXXZZ{3};
            NXX=length(XX);
            NYY=length(YY);
            NZZ=length(ZZ);
            switch dir
                case 'X'
                    for iz=1:NZZ
                    for iy=1:NYY                
                        for ix=1:NXX
                            O3.Mx(YY(iy),XX(ix),ZZ(iz))=obj.Mx(YY(iy),XX(ix),ZZ(iz));
                            O3.My(YY(iy),XX(ix),ZZ(iz))=obj.My(YY(iy),XX(ix),ZZ(iz))*c-s*obj.Mz(YY(iy),XX(ix),ZZ(iz));
                            O3.Mz(YY(iy),XX(ix),ZZ(iz))=obj.My(YY(iy),XX(ix),ZZ(iz))*s+c*obj.Mz(YY(iy),XX(ix),ZZ(iz));
                        end
                    end
                    end
                case 'Y'
                    for iz=1:NZZ
                    for iy=1:NYY                
                        for ix=NXX
                            O3.Mx(YY(iy),XX(ix),ZZ(iz))=obj.Mx(YY(iy),XX(ix),ZZ(iz))*c+s*obj.Mz(YY(iy),XX(ix),ZZ(iz));
                            O3.My(YY(iy),XX(ix),ZZ(iz))=obj.My(YY(iy),XX(ix),ZZ(iz));
                            O3.Mz(YY(iy),XX(ix),ZZ(iz))=obj.Mx(YY(iy),XX(ix),ZZ(iz))*(-s)+c*obj.Mz(YY(iy),XX(ix),ZZ(iz));
                        end
                    end
                    end
                case 'Z'
                    for iz=1:NZZ
                    for iy=1:NYY                
                        for ix=NXX
                            O3.Mx(YY(iy),XX(ix),ZZ(iz))=obj.Mx(YY(iy),XX(ix),ZZ(iz))*c-s*obj.My(YY(iy),XX(ix),ZZ(iz));
                            O3.My(YY(iy),XX(ix),ZZ(iz))=obj.Mx(YY(iy),XX(ix),ZZ(iz))*s+c*obj.My(YY(iy),XX(ix),ZZ(iz));
                            O3.Mz(YY(iy),XX(ix),ZZ(iz))=obj.Mz(YY(iy),XX(ix),ZZ(iz));
                        end
                    end 
                    end
                otherwise
                    error('we do not support such direction. You can add it yourown. We have only ''X'', ''Y'', ''Z'' directions');
            end
                        
        end
        
        function [Shape, Integral]=Shape(obj,Name,Npoint,varargin)
%         Shape=zeros(Npoint,1);        
%             switch Name
%                 case 'Rectengular'
%                     Shape=Shape+1;
%                 case 'Sine'
%                     x=(1:Npoint)';
%                     Shape=sin(pi*(x-1)/(Npoint-1));                
%                 case 'Parabolic'
%                     x=linspace(-1,1,Npoint)';
%                     Shape=-x.^2+1;                                    
%                 case 'Trapezoidal'
%                     O3opeFraction=varargin{1};
%                     Ns=round(Npoint*O3opeFraction);                    
%                     Shape(1:Ns,1)=linspace(0,1,Ns)';
%                     Shape(Ns+1:end-Ns,1)=1;
%                     Shape(end-Ns+1:end,1)=linspace(1,0,Ns)';                                                                                                                 
%                 otherwise 
%                     error('do not support yet such a shape');
%             end
%             Integral=trapz(Shape)/(Npoint-1);            
        end
        
        function obj=BLOCHe(obj,w0,FH,time)%calculate evolution in ribbon (OX, sample) with gradient G
%             FHX=FH{1};
%             FHY=FH{2};
%             FHZ=FH{3};
%             for iy=1:obj.Ny
%                 %iy
%                 for ix=1:obj.Nx
%                     if obj.T1(iy,ix)~=0 && obj.T2(iy,ix)~=0 && obj.Dens(iy,ix)~=0
%                         w(1)=w0(1)+FHX(iy,ix);
%                         w(2)=w0(2)+FHY(iy,ix);
%                         w(3)=w0(3)+FHZ(iy,ix);
%                         M0=[obj.Mx(iy,ix),obj.My(iy,ix),obj.Mz(iy,ix)];                    
%                         [time,Mout]=ode45(@(t,M)Bloch(t,M,obj.T1(iy,ix),obj.T2(iy,ix),w,obj.M0),time,M0);            
%                         obj.Mx(iy,ix)=Mout(end,1);
%                         obj.My(iy,ix)=Mout(end,2);
%                         obj.Mz(iy,ix)=Mout(end,3);
%                     else
%                         O3.Mx(iy,ix)=0;
%                         O3.My(iy,ix)=0;
%                         O3.Mz(iy,ix)=0;
%                     end                          
%                 end
%             end            
%         end
%         function O3=BLOCHeG(obj,w0,FH,t,G)
%             O3=obj;
%             GxV=G(1);GyV=G(2);
%             Gx=linspace(GxV/2,-GxV/2,obj.Nx);
%             Gy=linspace(GyV/2,-GyV/2,obj.Ny);
%             w=w0;
%             FHX=FH{1};
%             FHY=FH{2};
%             FHZ=FH{3};
%             for iy=1:obj.Ny
%                 %iy
%                 for ix=1:obj.Nx
%                     if obj.T1(iy,ix)~=0 && obj.T2(iy,ix)~=0 && obj.Dens(iy,ix)~=0
%                         w(1)=w0(1)+FHX(iy,ix);
%                         w(2)=w0(2)+FHY(iy,ix);
%                         w(3)=w0(3)+obj.Dx*Gx(ix)+obj.Dy*Gy(iy)+FHZ(iy,ix);
%                         M0=[obj.Mx(iy,ix),obj.My(iy,ix),obj.Mz(iy,ix)];
%                         [time,Mout]=ode45(@(t,M)Bloch(t,M,obj.T1(iy,ix),obj.T2(iy,ix),w,obj.M0),t,M0);                                
%                         O3.Mx(iy,ix)=Mout(end,1);
%                         O3.My(iy,ix)=Mout(end,2);
%                         O3.Mz(iy,ix)=Mout(end,3);
%                     else
%                         O3.Mx(iy,ix)=0;
%                         O3.My(iy,ix)=0;
%                         O3.Mz(iy,ix)=0;
%                     end
%                 end
%             end            
        end
        
        function [Mtr, O3]=BLOCHeGfrq(obj,w0,FH,t,G)
%             O3=obj;
%             GxV=G(1);GyV=G(2);
%             Gx=linspace(GxV/2,-GxV/2,obj.Nx);
%             Gy=linspace(GyV/2,-GyV/2,obj.Ny);
%             w=w0;
%             Mtr=zeros(1,length(t)); 
%             norm=0;
%             FHX=FH{1};
%             FHY=FH{2};
%             FHZ=FH{3};
%             for iy=1:obj.Ny
%                 for ix=1:obj.Nx 
%                     if obj.T1(iy,ix)~=0 && obj.T2(iy,ix)~=0 && obj.Dens(iy,ix)~=0
%                     w(1)=w0(1)+FHX(iy,ix);
%                     w(2)=w0(2)+FHY(iy,ix);
%                     w(3)=w0(3)+obj.Dx*Gx(ix)+obj.Dy*Gy(iy)+FHZ(iy,ix);
%                     M0=[obj.Mx(iy,ix),obj.My(iy,ix),obj.Mz(iy,ix)];
%                     [time,Mout]=ode45(@(t,M)Bloch(t,M,obj.T1(iy,ix),obj.T2(iy,ix),w,obj.M0),t,M0);            
%                     O3.Mx(iy,ix)=Mout(end,1);
%                     O3.My(iy,ix)=Mout(end,2);
%                     O3.Mz(iy,ix)=Mout(end,3);
%                     Mtr=Mtr+O3.Dens(iy,ix)*(Mout(:,1)'+1i*Mout(:,2)');
%                     norm=norm+O3.Dens(iy,ix);
%                     else
%                         O3.Mx(iy,ix)=0;
%                         O3.My(iy,ix)=0;
%                         O3.Mz(iy,ix)=0; 
%                     end
%                 end
%             end             
        end        
        
        function O3=BLOCHesG(obj,w0z,FHZ,t,G)
            O3=obj;
            GxV=G(1);GyV=G(2);
            Gx=linspace(GxV/2,-GxV/2,obj.Nx);
            Gy=linspace(GyV/2,-GyV/2,obj.Ny);
            if length(t)~=1
                error('length of time should be 1');
            end
            if length(w0z)~=1
                error('length of w0z should be 1');
            end                                 
            
            for it=1:obj.Nz         
                for iz=1:obj.Nz         
                for iy=1:obj.Ny
                    for ix=1:obj.Nx                    
                        wz=w0z+obj.Dx*Gx(ix)+obj.Dy*Gy(iy)+FHZ(iy,ix,iz);                    
                        if obj.T1(iy,ix,iz)~=0 && obj.T2(iy,ix,iz)~=0 && obj.Dens(iy,ix,iz)~=0
                            Gp=(obj.Mx(iy,ix,iz)+1i*obj.My(iy,ix,iz))*exp((-1i*wz-1/obj.T2(iy,ix,iz))*t);
                            O3.Mx(iy,ix,iz)=real(Gp);
                            O3.My(iy,ix,iz)=imag(Gp);
                            O3.Mz(iy,ix,iz)=(obj.Mz(iy,ix,iz)-obj.M0)*exp(-t/obj.T1(iy,ix,iz))+obj.M0;
                        else 
                            O3.Mx(iy,ix,iz)=0;
                            O3.My(iy,ix,iz)=0;
                            O3.Mz(iy,ix,iz)=0;
                        end
                    end
                end      
                end
            end
        end                        
        
         function O3=BLOCHesGV(obj,w0z,FHZ,t,G)
            O3=obj;
            GxV=G(1);GyV=G(2);
            Gx=linspace(GxV/2,-GxV/2,obj.Nx);
            Gy=linspace(GyV/2,-GyV/2,obj.Ny);
            if length(t)~=1
                error('length of time should be 1');
            end
            if length(w0z)~=1
                error('length of w0z should be 1');
            end                                 
            
            vm=max(max(max(abs(O3.Vz))));
            dt=(obj.Dz/vm)/50;
            nt=round(t/dt);
            if nt<2
                nt=2;
            end               
            time=linspace(0,t,nt);
            dt=time(2)-time(1);
            
            for it=2:length(time)  
                O30=O3;
                for iz=1:obj.Nz         
                for iy=1:obj.Ny
                    for ix=1:obj.Nx                    
                        wz=w0z+O30.Dx*Gx(ix)+O30.Dy*Gy(iy)+FHZ(iy,ix,iz);                    
                        if O30.T1(iy,ix,iz)~=0 && O30.T2(iy,ix,iz)~=0 && O30.Dens(iy,ix,iz)~=0
                            Gp=(O30.Mx(iy,ix,iz)+1i*O30.My(iy,ix,iz))*exp((-1i*wz-1/O30.T2(iy,ix,iz))*dt);
                            O3.Mx(iy,ix,iz)=real(Gp);
                            O3.My(iy,ix,iz)=imag(Gp);
                            O3.Mz(iy,ix,iz)=(O30.Mz(iy,ix,iz)-O30.M0)*exp(-dt/O30.T1(iy,ix,iz))+O30.M0;
                        else 
                            O3.Mx(iy,ix,iz)=0;
                            O3.My(iy,ix,iz)=0;
                            O3.Mz(iy,ix,iz)=0;
                        end
                    end
                end      
                end
                O3=O3.MoveVz(dt);
            end
        end
        
        function O3=MoveVz(obj,dt)
            O3=obj;
            dz=obj.Dz/obj.Nz;
            dnz=O3.Vz*dt/dz;
                       
            dnzf=fix(dnz);
            
            f=dnz-dnzf;
            O3.Dens=O3.Dens*0;
            O3.Mx = O3.Dens;
            O3.My = O3.Dens;
            O3.Mz = O3.Dens;
            
            for iz=1:obj.Nz         
                for iy=1:obj.Ny
                    for ix=1:obj.Nx
                        if obj.T1(iy,ix,iz)~=0 && obj.T2(iy,ix,iz)~=0 && obj.Dens(iy,ix,iz)~=0
                            izdnz=iz+dnzf(iy,ix,iz);
                            ff=f(iy,ix,iz);
                            if izdnz<=obj.Nz
O3.Dens(iy,ix,izdnz)=O3.Dens(iy,ix,izdnz)+obj.Dens(iy,ix,iz)*(1-ff);
  O3.Mx(iy,ix,izdnz)=O3.  Mx(iy,ix,izdnz)+obj.  Mx(iy,ix,iz)*(1-ff);
  O3.My(iy,ix,izdnz)=O3.  My(iy,ix,izdnz)+obj.  My(iy,ix,iz)*(1-ff);
  O3.Mz(iy,ix,izdnz)=O3.  Mz(iy,ix,izdnz)+obj.  Mz(iy,ix,iz)*(1-ff);                                
                            end 
                            if izdnz+1<=obj.Nz
O3.Dens(iy,ix,izdnz+1)=O3.Dens(iy,ix,izdnz+1)+obj.Dens(iy,ix,iz)*ff;
  O3.Mx(iy,ix,izdnz+1)=O3.  Mx(iy,ix,izdnz+1)+obj.  Mx(iy,ix,iz)*ff;
  O3.My(iy,ix,izdnz+1)=O3.  My(iy,ix,izdnz+1)+obj.  My(iy,ix,iz)*ff;
  O3.Mz(iy,ix,izdnz+1)=O3.  Mz(iy,ix,izdnz+1)+obj.  Mz(iy,ix,iz)*ff;                                
                            end 
                        end
                    end
                end
            end   
            
            %fill zeroes
            f=1-O3.Dens./obj.Dens;
            f(isnan(f))=0;
%             O3.Dens(:,:,1)
%             obj.Dens(:,:,1)
%             f(:,:,1)
            O3.Dens=O3.Dens+obj.Dens.*f;              
            O3.Mz=O3.Mz+obj.M0*f;                             
        end
                                            
        
        function [Mtr, O3]=BLOCHesGfrq(obj,w0z,FHZ,t,G)
            O3=obj;                        
            Mtr=zeros(1,length(t)); 
            norm=0;
            if length(t)==1
                error('length of time should be Nx or Ny');
            end
            if length(w0z)~=1
                error('length of w0z should be 1');
            end  
            
            [n1 n2]=size(G);    
            GxV=G(:,1);GyV=G(:,2);
            Gx=linspace(GxV/2,-GxV/2,obj.Nx);
            Gy=linspace(GyV/2,-GyV/2,obj.Ny);
            for iz=1:obj.Nz 
            for iy=1:obj.Ny                                
                for ix=1:obj.Nx                                                                                                     
                    wz=w0z+obj.Dx*Gx(ix)+obj.Dy*Gy(iy)+FHZ(iy,ix,iz);    
                    if obj.T1(iy,ix,iz)~=0 && obj.T2(iy,ix,iz)~=0 && obj.Dens(iy,ix,iz)~=0
                        Gp=(obj.Mx(iy,ix,iz)+1i*obj.My(iy,ix,iz))*exp((-1i*wz-1/obj.T2(iy,ix,iz))*t);
                        O3.Mx(iy,ix,iz)=real(Gp(end));
                        O3.My(iy,ix,iz)=imag(Gp(end));
                        O3.Mz(iy,ix,iz)=(obj.Mz(iy,ix,iz)-obj.M0)*exp(-t(end)/obj.T1(iy,ix,iz))+obj.M0;
                        Mtr=Mtr+O3.Dens(iy,ix,iz)*Gp;
                        norm=norm+O3.Dens(iy,ix,iz);
                    else
                        O3.Mx(iy,ix,iz)=0;
                        O3.My(iy,ix,iz)=0;
                        O3.Mz(iy,ix,iz)=0; 
                    end
                end
            end             
            end
        end
        
        function [Mtr, O3]=BLOCHesGfrqV(obj,w0z,FHZ,tAQ,G)
            O3=obj;                        
            Mtr=zeros(1,length(tAQ));
            if length(tAQ)==1
                error('length of time should be Nx or Ny');
            end
            if length(w0z)~=1
                error('length of w0z should be 1');
            end 
            
            vm=max(max(max(abs(O3.Vz))));
            dt=(obj.Dz/vm)/50;
            t=tAQ(2)-tAQ(1);
            nt=round(t/dt);
            if nt<2
                nt=2;
            end
            time=linspace(0,t,nt);
            dt=time(2)-time(1);
            
            
            [n1 n2]=size(G);    
            GxV=G(:,1);GyV=G(:,2);
            Gx=linspace(GxV/2,-GxV/2,obj.Nx);
            Gy=linspace(GyV/2,-GyV/2,obj.Ny);            
           
            Mtr(1)=sum(sum(sum(O3.Dens.*(O3.Mx+1i*O3.My))));
            for itAQ=2:length(tAQ)
            for it=2:nt
                O30=O3;
                for iz=1:obj.Nz 
                for iy=1:obj.Ny                                
                for ix=1:obj.Nx                                                                                                     
                    wz=w0z+O30.Dx*Gx(ix)+O30.Dy*Gy(iy)+FHZ(iy,ix,iz);    
                    if O30.T1(iy,ix,iz)~=0 && O30.T2(iy,ix,iz)~=0 && O30.Dens(iy,ix,iz)~=0
                        Gp=(O30.Mx(iy,ix,iz)+1i*O30.My(iy,ix,iz))*exp((-1i*wz-1/O30.T2(iy,ix,iz))*dt);
                        O3.Mx(iy,ix,iz)=real(Gp);
                        O3.My(iy,ix,iz)=imag(Gp);
                        O3.Mz(iy,ix,iz)=(O30.Mz(iy,ix,iz)-O30.M0)*exp(-dt/O30.T1(iy,ix,iz))+O30.M0;                        
                    else
                        O3.Mx(iy,ix,iz)=0;
                        O3.My(iy,ix,iz)=0;
                        O3.Mz(iy,ix,iz)=0; 
                    end
                end
                end             
                end
                O3=O3. MoveVz(dt);
            end             
                Mtr(itAQ)=sum(sum(sum(O3.Dens.*(O3.Mx+1i*O3.My))));               
            end
            Mtr=Mtr/sum(sum(sum(O3.Dens)));
        end
        
        
        function FH=FieldHomogeneity(obj,varargin)            
            if nargin==2
                if strcmp(varargin{1},'Homogenious')
                    FH=zeros(obj.Ny,obj.Nx,obj.Nz);                    
                else
                    error('nargin=2, you can write only ''Homogenious'' in this case');
                end                    
            elseif nargin==3
                if strcmp(varargin{1},'Gauss')
                    A=varargin{2}(1);                      
                    sX=varargin{2}(3)*obj.Nx;                      
                    sY=varargin{2}(2)*obj.Ny;                      
                    sZ=varargin{2}(4)*obj.Nz; 
                    y=1:obj.Ny; x=1:obj.Nx;
                    z=1:obj.Nz;
                    gX=exp(-(x-obj.Nx/2).^2/(2*sX^2));
                    gY=exp(-(y-obj.Ny/2).^2/(2*sY^2));                  
                    gZ=exp(-(z-obj.Nz/2).^2/(2*sZ^2)); 
                    FHXY=gY'*gX;
                    FH=zeros(obj.Ny,obj.Nx,obj.Nz);
                    for iz=1:obj.Nz
                       FH(:,:,iz)=FHXY*gZ(iz); 
                    end
                    mmm=max(max(max(FH)));
                    mm=min(min(min(FH)));
                    FH=A*(FH-mm)/(mmm-mm);
                elseif strcmp(varargin{1},'RandomUniform')
                    my=varargin{2}(1);
                    mx=varargin{2}(2);
                    mz=varargin{2}(2);
                    rng default;  % for reproducibility
                    FH=random('unif',my,mx,mz,[obj.Ny,obj.Nx,obj.Nz]);
                else
                    error('nargin=3, you can write only ''Gauss'' or ''RandomUniform'' in this case');
                end                    
            end
        end
                                
        function O3=RemoveMtr(O3)
            O3.Mx=O3.Mx*0;
            O3.My=O3.My*0;
            %O3.Mz
        end
    end 
    methods (Static)
        
    end
end

