classdef MRI_SLICE
    %SLICE Summary of this class goes here
    %   Detailed explanation goes here
    
    properties
        
    end    
    properties (SetAccess = public)
        Nx %[integer] column
        Ny %[integer] row
        Dx %[cm]
        Dy %[cm]
        Dens %[a.u]
        T1 %[s]
        T2 %[s]
        Mx
        My
        Mz
        Meq
    end
    methods 
        function SL = MRI_SLICE(varargin)                       
            if  strcmp(varargin{1},'SampleSlice')
                display('create templete SLICE');
                SL.Ny=varargin{2}(1);
                SL.Nx=varargin{2}(2);
                SL.Dens=load('in\Dens.dat','-ASCII');
                SL.T1=load('in\T1.dat','-ASCII');
                SL.T2=load('in\T2.dat','-ASCII');                
            elseif strcmp(varargin{1},'Rectengular')
                display('create RectengularDOTS filled SLICE');
                SL.Ny=varargin{2}(1);
                SL.Nx=varargin{2}(2);
                SL.Dens=zeros(SL.Ny,SL.Nx);
                SL.T1 = zeros(SL.Ny,SL.Nx);
                SL.T2 = zeros(SL.Ny,SL.Nx);                
                x1=varargin{4}(1);y1=varargin{4}(2);
                x2=varargin{4}(3);y2=varargin{4}(4);                
                SL.Dens(y1:y2,x1:x2)=varargin{5};
                SL.T1(y1:y2,x1:x2)  =varargin{6};
                SL.T2(y1:y2,x1:x2)  =varargin{7};                                           
            elseif strcmp(varargin{1},'RectengularDOTS')
                display('create RectengularDOTS filled SLICE');
                SL.Ny=varargin{2}(1);
                SL.Nx=varargin{2}(2);
                SL.Dens=zeros(SL.Ny,SL.Nx);
                SL.T1  =zeros(SL.Ny,SL.Nx);
                SL.T2  =zeros(SL.Ny,SL.Nx);                
                c=varargin{4}(1);r=varargin{4}(2);
                c1=round((SL.Nx-c)/2+1);r1=round((SL.Ny-r)/2+1);
                SL.Dens(r1:r+r1-1,c1:c+c1-1)=varargin{5};
                SL.T1(r1:r+r1,c1-1:c+c1-1)  =varargin{6};
                SL.T2(r1:r+r1,c1-1:c+c1-1)  =varargin{7};                 
                st=varargin{8};                 
                SL.Dens(r1+1*st:r1+2*st-1,c1+1*st:c1+2*st-1)=SL.Dens(c1+1*st:c1+2*st-1,r1+1*st:r1+2*st-1)*0.5;
                
                SL.T1(r1+3*st:r1+4*st-1,c1+1*st:c1+2*st-1)=SL.T1(r1+3*st:r1+4*st-1,c1+1*st:c1+2*st-1)*0.5;
                SL.T1(r1+3*st:r1+4*st-1,c1+3*st:c1+4*st-1)=SL.T1(r1+3*st:r1+4*st-1,c1+3*st:c1+4*st-1)*0.5;
                
                SL.T2(r1+5*st:r1+6*st-1,c1+1*st:c1+2*st-1)=SL.T2(r1+5*st:r1+6*st-1,c1+1*st:c1+2*st-1)*0.5;
                SL.T2(r1+5*st:r1+6*st-1,c1+3*st:c1+4*st-1)=SL.T2(r1+5*st:r1+6*st-1,c1+3*st:c1+4*st-1)*0.5;
                SL.T2(r1+5*st:r1+6*st-1,c1+5*st:c1+6*st-1)=SL.T2(r1+5*st:r1+6*st-1,c1+5*st:c1+6*st-1)*0.5;
                                
            else
                error('we do not support anything else but SampleSlice and Rectengular');
            end
            SL.Meq=1;
            SL.Mx=zeros(SL.Ny,SL.Nx);
            SL.My=zeros(SL.Ny,SL.Nx);
            SL.Mz=zeros(SL.Ny,SL.Nx)+SL.Meq;
            SL.Dx=varargin{3}(1);%[cm]            
            SL.Dy=varargin{3}(2);%[cm]            
        end
        function obj = SetIC(obj,x,y,z)
            for iy=1:obj.Ny                
                for ix=1:obj.Nx
                    if obj.T1(iy,ix)~=0 && obj.T2(iy,ix)~=0 && obj.Dens(iy,ix)~=0
                        obj.Mx(iy,ix)=x;
                        obj.My(iy,ix)=y;
                        obj.Mz(iy,ix)=z;
                    end
                end
            end
            
        end
        function ShowFrame(obj)
            f1=figure('Name','Name of Image','Color','white','NumberTitle','off');
            
            s1=subplot(2,2,1);
            imagesc(obj.Dens);
            colorbar('location','EastOutside')
            axis('square');xlabel('X axis');ylabel('Y axis');
            title('proton Dens');


            s2=subplot(2,2,2);
            imagesc(obj.T2);
            colorbar('location','EastOutside')
            axis('square');xlabel('X axis');ylabel('Y axis');
            title('T2');

            s3=subplot(2,2,3);
            imagesc(obj.T1);
            colorbar('location','EastOutside')
            axis('square');xlabel('X axis');ylabel('Y axis');
            title('T1');            
            
            colormap('Gray');
            %colormap('Summer');
        end
        function ShowFieldHomogeneity(obj,varargin)
            figure('Name','Name of Image','Color','white','NumberTitle','off');
            if nargin==2
                FHZ=varargin{1};
                FHX=FHZ*0;
                FHY=FHZ*0;                
            elseif nargin==4
                FHX=varargin{1};
                FHY=varargin{2};
                FHZ=varargin{3};
            else
                error('error');
            end
                        
            subplot(2,2,1);
            imagesc(FHX);
            colorbar('location','EastOutside')
            axis('square');xlabel('X axis');ylabel('Y axis');
            title('Homogeneity Bx');

            subplot(2,2,2);
            imagesc(FHY);
            colorbar('location','EastOutside')
            axis('square');xlabel('X axis');ylabel('Y axis');
            title('Homogeneity By');

            subplot(2,2,3);
            imagesc(FHZ);
            colorbar('location','EastOutside')
            axis('square');xlabel('X axis');ylabel('Y axis');
            title('Homogeneity Bz');            
            
            colormap('Gray');
            %colormap('Summer');
        end
        function SL=IdealRotation(obj,angle,dir)
            SL=obj;
            c=cos(angle);
            s=sin(angle);
            switch dir
                case 'X'
                    for iy=1:SL.Ny                
                        for ix=1:SL.Nx
                            SL.Mx(iy,ix)=obj.Mx(iy,ix);
                            SL.My(iy,ix)=obj.My(iy,ix)*c-s*obj.Mz(iy,ix);
                            SL.Mz(iy,ix)=obj.My(iy,ix)*s+c*obj.Mz(iy,ix);
                        end
                    end
                case 'Y'
                    for iy=1:SL.Ny                
                        for ix=1:SL.Nx
                            SL.Mx(iy,ix)=obj.Mx(iy,ix)*c+s*obj.Mz(iy,ix);
                            SL.My(iy,ix)=obj.My(iy,ix);
                            SL.Mz(iy,ix)=obj.Mx(iy,ix)*(-s)+c*obj.Mz(iy,ix);
                        end
                    end
                case 'Z'
                    for iy=1:SL.Ny                
                        for ix=1:SL.Nx
                            SL.Mx(iy,ix)=obj.Mx(iy,ix)*c-s*obj.My(iy,ix);
                            SL.My(iy,ix)=obj.Mx(iy,ix)*s+c*obj.My(iy,ix);
                            SL.Mz(iy,ix)=obj.Mz(iy,ix);
                        end
                    end    
                otherwise
                    error('we do not support such direction. You can add it yourown. We have only ''X'', ''Y'', ''Z'' directions');
            end
                        
        end
        
        function [Shape, Integral]=Shape(obj,Name,Npoint,varargin)
        Shape=zeros(Npoint,1);        
            switch Name
                case 'Rectengular'
                    Shape=Shape+1;
                case 'Sine'
                    x=(1:Npoint)';
                    Shape=sin(pi*(x-1)/(Npoint-1));                
                case 'Parabolic'
                    x=linspace(-1,1,Npoint)';
                    Shape=-x.^2+1;                                    
                case 'Trapezoidal'
                    SlopeFraction=varargin{1};
                    Ns=round(Npoint*SlopeFraction);                    
                    Shape(1:Ns,1)=linspace(0,1,Ns)';
                    Shape(Ns+1:end-Ns,1)=1;
                    Shape(end-Ns+1:end,1)=linspace(1,0,Ns)';                                                                                                                 
                otherwise 
                    error('do not support yet such a shape');
            end
            Integral=trapz(Shape)/(Npoint-1);            
        end
        
        function obj=BLOCHe(obj,w0,FH,time)%calculate evolution in ribbon (OX, sample) with gradient G
            FHX=FH{1};
            FHY=FH{2};
            FHZ=FH{3};
            for iy=1:obj.Ny
                %iy
                for ix=1:obj.Nx
                    if obj.T1(iy,ix)~=0 && obj.T2(iy,ix)~=0 && obj.Dens(iy,ix)~=0
                        w(1)=w0(1)+FHX(iy,ix);
                        w(2)=w0(2)+FHY(iy,ix);
                        w(3)=w0(3)+FHZ(iy,ix);
                        M0=[obj.Mx(iy,ix),obj.My(iy,ix),obj.Mz(iy,ix)];                    
                        [time,Mout]=ode45(@(t,M)Bloch(t,M,obj.T1(iy,ix),obj.T2(iy,ix),w,obj.Meq),time,M0);            
                        obj.Mx(iy,ix)=Mout(end,1);
                        obj.My(iy,ix)=Mout(end,2);
                        obj.Mz(iy,ix)=Mout(end,3);
                    else
                        SL.Mx(iy,ix)=0;
                        SL.My(iy,ix)=0;
                        SL.Mz(iy,ix)=0;
                    end                          
                end
            end            
        end
        
        function SL=BLOCHeG(obj,w0,FH,t,G)
            SL=obj;
            GxV=G(1);GyV=G(2);
            Gx=linspace(GxV/2,-GxV/2,obj.Nx);
            Gy=linspace(GyV/2,-GyV/2,obj.Ny);
            w=w0;
            FHX=FH{1};
            FHY=FH{2};
            FHZ=FH{3};
            for iy=1:obj.Ny
                %iy
                for ix=1:obj.Nx
                    if obj.T1(iy,ix)~=0 && obj.T2(iy,ix)~=0 && obj.Dens(iy,ix)~=0
                        w(1)=w0(1)+FHX(iy,ix);
                        w(2)=w0(2)+FHY(iy,ix);
                        w(3)=w0(3)+obj.Dx*Gx(ix)+obj.Dy*Gy(iy)+FHZ(iy,ix);
                        M0=[obj.Mx(iy,ix),obj.My(iy,ix),obj.Mz(iy,ix)];
                        [time,Mout]=ode45(@(t,M)Bloch(t,M,obj.T1(iy,ix),obj.T2(iy,ix),w,obj.Meq),t,M0);                                
                        SL.Mx(iy,ix)=Mout(end,1);
                        SL.My(iy,ix)=Mout(end,2);
                        SL.Mz(iy,ix)=Mout(end,3);
                    else
                        SL.Mx(iy,ix)=0;
                        SL.My(iy,ix)=0;
                        SL.Mz(iy,ix)=0;
                    end
                end
            end            
        end
        
        function [Mtr, SL]=BLOCHeGfrq(obj,w0,FH,t,G)
            SL=obj;
            GxV=G(1);GyV=G(2);
            Gx=linspace(GxV/2,-GxV/2,obj.Nx);
            Gy=linspace(GyV/2,-GyV/2,obj.Ny);
            w=w0;
            Mtr=zeros(1,length(t)); 
            norm=0;
            FHX=FH{1};
            FHY=FH{2};
            FHZ=FH{3};
            for iy=1:obj.Ny
                for ix=1:obj.Nx 
                    if obj.T1(iy,ix)~=0 && obj.T2(iy,ix)~=0 && obj.Dens(iy,ix)~=0
                    w(1)=w0(1)+FHX(iy,ix);
                    w(2)=w0(2)+FHY(iy,ix);
                    w(3)=w0(3)+obj.Dx*Gx(ix)+obj.Dy*Gy(iy)+FHZ(iy,ix);
                    M0=[obj.Mx(iy,ix),obj.My(iy,ix),obj.Mz(iy,ix)];
                    [time,Mout]=ode45(@(t,M)Bloch(t,M,obj.T1(iy,ix),obj.T2(iy,ix),w,obj.Meq),t,M0);            
                    SL.Mx(iy,ix)=Mout(end,1);
                    SL.My(iy,ix)=Mout(end,2);
                    SL.Mz(iy,ix)=Mout(end,3);
                    Mtr=Mtr+SL.Dens(iy,ix)*(Mout(:,1)'+1i*Mout(:,2)');
                    norm=norm+SL.Dens(iy,ix);
                    else
                        SL.Mx(iy,ix)=0;
                        SL.My(iy,ix)=0;
                        SL.Mz(iy,ix)=0; 
                    end
                end
            end  
            
        end        
        
        function SL=BLOCHesG(obj,w0z,FHZ,t,G)
            SL=obj;
            GxV=G(1);GyV=G(2);
            Gx=linspace(GxV/2,-GxV/2,obj.Nx);
            Gy=linspace(GyV/2,-GyV/2,obj.Ny);
            if length(t)~=1
                error('length of time should be 1');
            end
            if length(w0z)~=1
                error('length of w0z should be 1');
            end                     
                        
            for iy=1:obj.Ny
                for ix=1:obj.Nx                    
                    wz=w0z+obj.Dx*Gx(ix)+obj.Dy*Gy(iy)+FHZ(iy,ix);                    
                    if obj.T1(iy,ix)~=0 && obj.T2(iy,ix)~=0 && obj.Dens(iy,ix)~=0
                        Gp=(obj.Mx(iy,ix)+1i*obj.My(iy,ix))*exp((-1i*wz-1/obj.T2(iy,ix))*t);
                        SL.Mx(iy,ix)=real(Gp);
                        SL.My(iy,ix)=imag(Gp);
                        SL.Mz(iy,ix)=(obj.Mz(iy,ix)-obj.Meq)*exp(-t/obj.T1(iy,ix))+obj.Meq;
                    else 
                        SL.Mx(iy,ix)=0;
                        SL.My(iy,ix)=0;
                        SL.Mz(iy,ix)=0;
                    end
                end
            end            
        end 
        
        function [Mxyz, SL]=BLOCHesGt(obj,w0z,FHZ,tv,G)
            
            GxV=G(1);GyV=G(2);
            Gx=linspace(GxV/2,-GxV/2,obj.Nx);
            Gy=linspace(GyV/2,-GyV/2,obj.Ny);
            if length(w0z)~=1
                error('length of w0z should be 1');
            end
            
            Mxyz=zeros(length(tv),3);            
            for itv=1:length(tv)
                t=tv(itv);
                SL=obj;
                for iy=1:obj.Ny
                    for ix=1:obj.Nx                    
                        wz=w0z+obj.Dx*Gx(ix)+obj.Dy*Gy(iy)+FHZ(iy,ix);                    
                        if obj.T1(iy,ix)~=0 && obj.T2(iy,ix)~=0 && obj.Dens(iy,ix)~=0
                            Gp=(obj.Mx(iy,ix)+1i*obj.My(iy,ix))*exp((-1i*wz-1/obj.T2(iy,ix))*t);
                            SL.Mx(iy,ix)=real(Gp);
                            SL.My(iy,ix)=imag(Gp);
                            SL.Mz(iy,ix)=(obj.Mz(iy,ix)-obj.Meq)*exp(-t/obj.T1(iy,ix))+obj.Meq;
                        else 
                            SL.Mx(iy,ix)=0;
                            SL.My(iy,ix)=0;
                            SL.Mz(iy,ix)=0;
                        end
                    end
                end
                Mxyz(itv,1)=sum(sum(SL.Mx));
                Mxyz(itv,2)=sum(sum(SL.My));
                Mxyz(itv,3)=sum(sum(SL.Mz));
            end
            
        end 
        
        function [Mtr, SL]=BLOCHesGfrq(obj,w0z,FHZ,t,G)
            SL=obj;                        
            Mtr=zeros(1,length(t)); 
            norm=0;
            if length(t)==1
                error('length of time should be Nx or Ny');
            end
            if length(w0z)~=1
                error('length of w0z should be 1');
            end            
            [n1 n2]=size(G);    
            GxV=G(:,1);GyV=G(:,2);
            Gx=linspace(GxV/2,-GxV/2,obj.Nx);
            Gy=linspace(GyV/2,-GyV/2,obj.Ny);
            for iy=1:obj.Ny                                
                for ix=1:obj.Nx                                                                                                     
                    wz=w0z+obj.Dx*Gx(ix)+obj.Dy*Gy(iy)+FHZ(iy,ix);    
                    if obj.T1(iy,ix)~=0 && obj.T2(iy,ix)~=0 && obj.Dens(iy,ix)~=0
                        Gp=(obj.Mx(iy,ix)+1i*obj.My(iy,ix))*exp((-1i*wz-1/obj.T2(iy,ix))*t);
                        SL.Mx(iy,ix)=real(Gp(end));
                        SL.My(iy,ix)=imag(Gp(end));
                        SL.Mz(iy,ix)=(obj.Mz(iy,ix)-obj.Meq)*exp(-t(end)/obj.T1(iy,ix))+obj.Meq;
                        Mtr=Mtr+SL.Dens(iy,ix)*Gp;
                        norm=norm+SL.Dens(iy,ix);
                    else
                        SL.Mx(iy,ix)=0;
                        SL.My(iy,ix)=0;
                        SL.Mz(iy,ix)=0; 
                    end
                end
            end             
        end
%         function [Mtr, SL]=BLOCHesSpGfrq(obj,w0z,FHZ,t,G)
%             SL=obj;                        
%             Mtr=zeros(1,length(t));
%             dt=t(2)-t(1);
%             norm=0;
%             if length(t)==1
%                 error('length of time should be Nx or Ny');
%             end
%             if length(w0z)~=1
%                 error('length of w0z should be 1');
%             end               
%             GxV=G(:,1);GyV=G(:,2); 
%             for iy=1:obj.Ny                                
%                 for ix=1:obj.Nx                                                                                                                           
%                     if obj.T1(iy,ix)~=0 && obj.T2(iy,ix)~=0 && obj.Dens(iy,ix)~=0
%                         for it=1:length(t)
%                             Gx=linspace(GxV(it)/2,-GxV(it)/2,SL.Nx);
%                             Gy=linspace(GyV(it)/2,-GyV(it)/2,SL.Ny);
%                             wz=w0z+obj.Dx*Gx(ix)+obj.Dy*Gy(iy)+FHZ(iy,ix);
%                             
%                             Gp=(SL.Mx(iy,ix)+1i*SL.My(iy,ix))*exp((-1i*wz-1/SL.T2(iy,ix))*dt);
%                             SL.Mx(iy,ix)=real(Gp);
%                             SL.My(iy,ix)=imag(Gp);
%                             SL.Mz(iy,ix)=(SL.Mz(iy,ix)-SL.Meq)*exp(-dt/SL.T1(iy,ix))+SL.Meq;
%                             Mtr(it)=Mtr(it)+SL.Dens(iy,ix)*Gp;
%                         end
%                         norm=norm+SL.Dens(iy,ix);
%                     else
%                         SL.Mx(iy,ix)=0;
%                         SL.My(iy,ix)=0;
%                         SL.Mz(iy,ix)=0; 
%                     end
%                 end
%             end                         
%         end
                
        function FH=FieldHomogeneity(obj,varargin)            
            if nargin==2
                if strcmp(varargin{1},'Homogenious')
                    FH=zeros(obj.Ny,obj.Nx);                    
                else
                    error('nargin=2, you can write only ''Homogenious'' in this case');
                end                    
            elseif nargin==3
                if strcmp(varargin{1},'Gauss')
                    A=varargin{2}(1);                      
                    sX=varargin{2}(2)*obj.Nx;                      
                    sY=varargin{2}(3)*obj.Ny;                      
                    y=1:obj.Ny; x=1:obj.Nx;
                    gX=exp(-(x-obj.Nx/2).^2/(2*sX^2));
                    gY=exp(-(y-obj.Ny/2).^2/(2*sY^2));                  
                    FH=gY'*gX;
                    FH=(FH-1);
                    FH=A*FH/max(max(abs(FH)));
                elseif strcmp(varargin{1},'RandomUniform')
                    m1=varargin{2}(1);
                    m2=varargin{2}(2);
                    rng default;  % for reproducibility
                    FH=random('unif',m1,m2,[obj.Ny,obj.Nx]);
                else
                    error('nargin=3, you can write only ''Gauss'' or ''RandomUniform'' in this case');
                end                    
            end
        end
                                
        function SL=RemoveMtr(SL)
            SL.Mx=SL.Mx*0;
            SL.My=SL.My*0;
            %SL.Mz
        end
    end 
    methods (Static)
        
    end
end

