classdef SPIN
    %SPIN Summary of this class goes here
    %   Detailed explanation goes here
    
    properties
        
    end    
    properties (SetAccess = private)        
        %Dens
        Mx
        My
        Mz
        T1 %[s]
        T2 %[s]        
        M0
    end
    
    methods 
        function SP=SPIN(M,T,Eq)
            SP.Mx=M(1);
            
            SP.My=M(2);
            SP.Mz=M(3);

            SP.T1=T(1);
            SP.T2=T(2);            
            
            %SP.Dens=Dens;
            SP.M0=Eq;        
        end
        
        function [Time,Mout,SP]=BLOCHe(SP,w,time)%calculate evolution in ribbon (OX, sample) with gradient G                       
                                    
            Mic=[SP.Mx,SP.My,SP.Mz];                    
            [Time,Mout]=ode45(@(t,M)Bloch(t,M,SP.T1,SP.T2,w,SP.M0),time,Mic);            
            SP.Mx=Mout(end,1);
            SP.My=Mout(end,2);
            SP.Mz=Mout(end,3);                
        end
        
        function [Time,Mout,SP]=BLOCHeRadDam(SP,tRD,w,time)%calculate evolution in ribbon (OX, sample) with gradient G                       
                                    
            Mic=[SP.Mx,SP.My,SP.Mz];                    
            [Time,Mout]=ode45(@(t,M)BlochRadDam(t,M,SP.T1,SP.T2,tRD,w,SP.M0),time,Mic);            
            SP.Mx=Mout(end,1);
            SP.My=Mout(end,2);
            SP.Mz=Mout(end,3);                
        end
        
        function SP=IdealRotation(obj,angle,dir)
            SP=obj;
            c=cos(angle);
            s=sin(angle);
            switch dir
                case 'X'                    
                    SP.Mx=obj.Mx;
                    SP.My=obj.My*c-s*obj.Mz;
                    SP.Mz=obj.My*s+c*obj.Mz;                        
                case 'Y'                    
                    SP.Mx=obj.Mx*c+s*obj.Mz;
                    SP.My=obj.My;
                    SP.Mz=obj.Mx*(-s)+c*obj.Mz;                        
                case 'Z'                 
                    SP.Mx=obj.Mx*c-s*obj.My;
                    SP.My=obj.Mx*s+c*obj.My;
                    SP.Mz=obj.Mz;                           
                otherwise
                    error('we do not support such direction. You can add it yourown. We have only ''X'', ''Y'', ''Z'' directions');
            end                        
        end
        
        function SP=BLOCH_wz(obj,wz,t)
            SP=obj;
            if length(t)~=1
                error('length of time should be 1');
            end
            if length(wz)~=1
                error('length of w0z should be 1');
            end
           
                                                                
            Gp=(obj.Mx+1i*obj.My)*exp((-1i*wz-1/obj.T2)*t);
            SP.Mx=real(Gp);
            SP.My=imag(Gp);
            SP.Mz=(obj.Mz-obj.M0)*exp(-t/obj.T1)+obj.M0;                    
        end
        
        function SP=RemoveCoherences(SP)
           SP.Mx=0;
           SP.My=0;
        end
    end
end            
        
        
        
    
    


