function cos_angle=CosTheta(r,n1,n2,m1,m2)

if n1==n2
    error('n1=n2');
end
if m1==m2
    error('m1==m2');
end

if n1==m1
    cos_angle=(r(n1,n2)^2+r(n1,m2)^2-r(n2,m2)^2)/(r(n1,n2)*r(n1,m2)*2);
elseif n1==m2
    cos_angle=(r(n1,n2)^2+r(n1,m1)^2-r(n2,m1)^2)/(r(n1,n2)*r(n1,m1)*2);
elseif n2==m1
    cos_angle=-(r(n2,n1)^2+r(n2,m2)^2-r(n1,m2)^2)/(r(n2,n1)*r(n2,m2)*2);
elseif n2==m2
    cos_angle=(r(n2,n1)^2+r(n2,m1)^2-r(n1,m1)^2)/(r(n2,n1)*r(n2,m1)*2);
else
    a=acos((r(n1,n2)^2+r(n1,m1)^2-r(n2,m1)^2)/(r(n1,n2)*r(n1,m1)*2));
    b=acos((r(n1,m1)^2+r(m1,m2)^2-r(n1,m2)^2)/(r(n1,m1)*r(m1,m2)*2));
    cos_angle=cos(a+b-pi);
end


end