function [v1, v2, v3, vtot]=Create_V1(N1,N2,N3,v1max,Type)
%Type
%1-"x"
%2-x^2
%3-cos^2 
%the other profiles are additable.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

x1=(1:N1);
x2=ones(1,N2);
x3=(1:N3);

switch Type
    case 'Line'
        v1=x1/N1; 
        v2=x2; 
        v3=fliplr(x3/N3);
    case 'x^2'
        v1=x1.^2/N1^2;
        v2=x2;
        v3=fliplr(x3.^2/N3^2);
    case 'cos^2'
        v1=1/4*(1-cos(x1/N1*pi)).^2;
        v2=x2;
        v3=fliplr(1/4*(1-cos(x3/N3*pi)).^2); 
    otherwise 
        error('Create_V1 supports yet only folowing profiles: ''Line'', ''x^2'', ''cos^2'' ');        
end
vtot=v1max*[v1 v2 v3]';
v1=v1max*v1';
v2=v1max*v2';
v3=v1max*v3';
end