function R2=RLFF(S0,T1,tauc,H) %local fluctuating fields, extreeme narrowing regime
%display('start to calculate relaxation super operator');    
%display('RLFF_EN');    
%%%%%%%%%%%%%%%%%%%calc  relaxation operator
Nstates=S0.Nstates;
N=S0.N;
J=zeros(Nstates,Nstates,Nstates,Nstates);        
[Q, E]=eig(full(H));
iQ=inv(Q);
E=real(diag(E));
S=S0.ChangeBasis(Q);

%calculate J in eigen basis



for a=1:Nstates
   % percentage=a/Nstates/2*100;
    %display(percentage);
    for as=1:Nstates
        for b=1:Nstates
            for bs=1:Nstates 
                Jbbs=(1/(1+(tauc*(E(b)-E(bs)))^2));
                for j=1:N
                    J(a,as,b,bs)=J(a,as,b,bs)+1.0/T1(j)*...
                        (S.x{j}(a,as)*S.x{j}(bs,b)+...
                         S.y{j}(a,as)*S.y{j}(bs,b)+...
                         S.z{j}(a,as)*S.z{j}(bs,b))*Jbbs;
                     %multiply Jabxy on J(wx-wy)
                end
            end
        end
    end
end

% %multiply Jabxy on J(wx-wy)
% for a=1:Nstates
%     for as=1:Nstates
%         for b=1:Nstates
%             for bs=1:Nstates                                                                
% J(a,as,b,bs)=J(a,as,b,bs)*(1/(1+(tauc*(E(b)-E(bs)))^2)); 
%             end
%         end
%     end
% end

%change basis from eigen basis to zeeman basis back
Js=J*0;
for x=1:Nstates
    for y=1:Nstates
        for w=1:Nstates
            for z=1:Nstates
                
                for a=1:Nstates
                    for m=1:Nstates
                        for b=1:Nstates
                            for n=1:Nstates
Js(x,y,w,z)=Js(x,y,w,z)+J(a,m,b,n)*Q(x,a)*Q(z,n)*iQ(m,y)*iQ(b,w); 
                            end
                        end
                    end
                end
                
            end
        end
    end
end
J=Js;
%calculate RelaxationSuperoperator from J
R4=zeros(Nstates,Nstates,Nstates,Nstates);% 4 indexes
for a=1:Nstates
    %percentage=a/Nstates/2*100+50;
   % display(percentage);
    for as=1:Nstates
        for b=1:Nstates
            for bs=1:Nstates
                %if a-as-b+bs==0
                    R4(a,as,b,bs)=J(a,b,as,bs)+J(bs,as,b,a);
                    %R4(a,as,b,bs)=J(a,b,as,bs)*2; %Kowalewski
                    if as==bs
                        for g=1:Nstates
                        R4(a,as,b,bs)=R4(a,as,b,bs)-J(a,g,b,g);
                        %R4(a,as,b,bs)=R4(a,as,b,bs)-J(g,b,g,a); %Kowalewski
                        end
                    end
                    if a==b
                        for g=1:Nstates
                        R4(a,as,b,bs)=R4(a,as,b,bs)-J(g,as,g,bs);
                        %R4(a,as,b,bs)=R4(a,as,b,bs)-J(g,as,g,bs); %Kowalewski
                        end   
                    end
                %end
            end
        end
    end
end
R4=R4/2;

%%%%%%%%%%%%%%%%%%%finish population relaxation operator 
R2=zeros(Nstates*Nstates,Nstates*Nstates);
I=0; 
for mu=1:Nstates
    for nu=1:Nstates
        I=I+1; II=0;
        for mus=1:Nstates
            for nus=1:Nstates
                II=II+1;
                R2(I,II)=R4(mu,nu,mus,nus);                                    
            end    
        end
    end    
end
 % display('finish RLFF_EN');
end
  
  
  
  