function dYdt = SABRE_CAP_sol(t,Y,AAA,y0,CAP)
    L=length(Y);
    if L~=CAP.Ns_2+    CAP.Nc_2+    CAP.Nc1_2+    CAP.Nh_2       
       error
    end    
    NL=0*y0;
    %t
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %calculate first nonlinear term
    %vs=Y(1:CAP.Ns_2);
    %vc1=Y(1+CAP.Ns_2+CAP.Nc_2:CAP.Ns_2+CAP.Nc_2+CAP.Nc1_2);        
    %see vec2mtz      
    n1=CAP.Nstates_S;
    rs=zeros(n1,n1);
    x=0;
    for m=1:n1
        for q=1:n1
            x=x+1;   
            rs(m,q)=Y(x);
        end
    end
    %see vec2mtz    
    n1=CAP.Nstates_c1;
    rc1=zeros(n1,n1);
    x=CAP.Ns_2+CAP.Nc_2;
    for m=1:n1
        for q=1:n1
            x=x+1;   
            rc1(m,q)=Y(x);
        end
    end
    Pc=CAP.kd*kron(rc1,rs);
    %see mtz2vec    
    [n1,n2]=size(Pc);
    if n1*n2~=CAP.Nc_2
        error
    end    
    x=CAP.Ns_2;
    for m=1:n1
        for q=1:n2            
            x=x+1;
            NL(x)=Pc(m,q);
        end
    end
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %calculate second nonlinear term    
    Tr=TraceSuper1(1,2^2)*TraceSuper1(1,2^3);
    Trc1_v=Tr*Y(CAP.Ns_2+CAP.Nc_2+1:CAP.Ns_2+CAP.Nc_2+CAP.Nc1_2);
    %see vec2mtz    
    n1=CAP.Nstates_S;
    Trc1=zeros(n1,n1);
    x=0;
    for m=1:n1
        for q=1:n1
            x=x+1;   
            Trc1(m,q)=Trc1_v(x);
        end
    end
    %see vec2mtz    
    n1=CAP.Nstates_h;
    rh=zeros(n1,n1);
    x=CAP.Ns_2+CAP.Nc_2+CAP.Nc1_2;    
    for m=1:n1
        for q=1:n1
            x=x+1;   
            rh(m,q)=Y(x);
        end
    end
    Pc1=CAP.kex*CAP.H2*kron(rh,Trc1);
    %see mtz2vec    
    [n1,n2]=size(Pc1);
    if n1*n2~=CAP.Nc1_2
        error
    end    
    x=CAP.Ns_2+CAP.Nc_2;
    for m=1:n1
        for q=1:n2            
            x=x+1;
            NL(x)=Pc1(m,q);
        end
    end    
    
    
    dYdt=AAA*Y+NL+y0;
end

