###############################################################################
# Author : Arijit Dutta
# Date	 : 18-03-2020 
# This script extracts json files for DFT results for a set
# of materials from a connected database. The appropriate lines
# in the script to connect to a database, and to select materials
# with a chosen set of perperties can be easily identified.
###############################################################################

import numpy as np
#----------------------------------------------------------------------------
from ase import Atoms
import ase.db # ASE library: https://wiki.fysik.dtu.dk/ase/about.html

# Connect to database
db = ase.db.connect('c2db.db')

# PS added on 1 May, 2020
#compounds = open('MAE-compounds','r+')
#for index in range(599):
#	now = next(compounds)
#	current_compound = 'formula='+now
#  PS

rows = db.select('hform<0, is_magnetic=True,  magstate=AFM,  has_asr_magnetic_anisotropy=True', sort='gap')
#rows = db.select('hform<0, is_magnetic=True,  magstate=FM', sort='gap')
for row in rows:
	name = row.formula+'-'+row.asr_id[:12] # Name of the compound: formula + unique 'asr_id'
	# Extract structural information from the database
	atoms = row.toatoms()
	atoms.write('atoms-'+name+'.json')
