data {
	int<lower=0> I; // number of solutes
	int<lower=0> J; // number of solvents
	int<lower=0> K; // number of latent dimensions
	real R[I,J]; // matrix of residuals of logarithmic diffusion coefficients
	real<lower=0> sigma_0; // prior standard deviation
	real<lower=0> lambda; // likelihood scale
}

parameters {
	vector[K] u[I]; // solute feature vectors
	vector[K] v[J]; // solvent feature vectors
}

model {
	// prior: draw feature vectors for all solutes and solvents:
	for (i in 1:I)
		u[i] ~ normal(0,sigma_0);
	for (j in 1:J)
		v[j] ~ normal(0,sigma_0);
	
	// likelihood: model the probability of R as a normal distribution
	// around the dot product of the feature vectors:
	for (i in 1:I) {
		for (j in 1:J) {
			if (R[i,j] != -99) { // train to available data only
				R[i,j] ~ normal(u[i]' * v[j], lambda);
			}
		}
	}
}