data {
	int<lower=0> I; // number of solutes
	int<lower=0> J; // number of solvents
	int<lower=0> K; // number of latent dimensions
	real ln_D[I,J]; // matrix of logarithmic diffusion coefficients
	real<lower=0> lambda; // likelihood scale
	vector<lower=0>[K] sigma_0_u[I]; // Prior standard deviation (Solutes)
	vector<lower=0>[K] sigma_0_v[J]; // Prior standard deviation (Solvents)
	vector[K] mu_0_u[I]; // prior mean (Solutes)
	vector[K] mu_0_v[J]; // prior mean (Solvents)
}

parameters {
	vector[K] u[I]; // solute feature vectors
	vector[K] v[J]; // solvent feature vectors
}

model {
	// prior: draw feature vectors for all solutes and solvents:
	for (i in 1:I)
		u[i] ~ normal(mu_0_u[i],sigma_0_u[i]);
	for (j in 1:J)
		v[j] ~ normal(mu_0_v[j],sigma_0_v[j]);
		
	// likelihood: model the probability of ln_D as a normal distribution
	// around the dot product of the feature vectors:
	for (i in 1:I) {
		for (j in 1:J) {
			if (ln_D[i,j] != -99) { // train to available data only
				ln_D[i,j] ~ normal(u[i]' * v[j], lambda);
			}
		}
	}
}