# -*- coding: cp1252 -*-
# Class for controlling Ismatec peristaltic pumps via seriel interface
# Communication errors with pump are not intercepted!
# But self.response shows last answer of the pump.
#
# To do:
#               
#
# Completed:
#
# 26.03.2021 - Version 3.0 rewritten for Python 3  WORK IN PROGRESS !
# 05.02.2020 - Version 2.4 'IP-Adresse:Port' are now assigned during instantiation.
# 14.06.2019 - Version 2.3 timeout added again
# 18.06.2018 - Version 2.2  Control via Telnet
# 21.11.2016 - Version 2.1 New functions speedmodus(), ratemodus(), rate() und send()
# 22.02.2016 - Switching from 'pump mode' to 'channel mode' possible (Important für REGLO ICC)
# 09.07.2014 - Basic functions implemented


import serial,time

class ismatec:
    def __init__(self,socket):
        self.pumpe = serial.Serial(port = socket, baudrate = 9600, timeout = 0.1)
        #self.pumpe = serial.serial_for_url("socket://10.115.1.166:1471", timeout = 1)
        #self.pumpe = serial.serial_for_url(socket, timeout = 1)
        #Jannik: timeout = 0.1 --> Pumps / pump channels start ~simultaneously
        
    def kanalmodus(self,adr):
        res = self.send(adr,"~1") # Switch to 'channel mode': Addresses are assigned to pump channels
        return res    
            
    def pumpenmodus(self,adr):
        res = self.send(adr,"~0")  # Switch to 'pump mode': Addresses are assigned to individual pumps in a network
            
        
        
    def version(self,adr):
        res = self.send(adr,"#")  #Show pump version
        return res
    
    def speedmodus(self,adr):
        res = self.send(adr,"L") # Switch to flow control via rpm
        return res
            
    def ratemodus(self,adr):
        self.response = self.send(adr,"M") # Switch to flow control via volume flow
            
    def start(self,adr):
        res = self.send(adr,"H") # Start pumping
        return res    

    def stop(self,adr):
        res = self.send(adr,"I") # Stop pumping
        return res
            
    def rate(self,adr,ra):
        ra = ra*100             # Floating point number is converted to integer e.g.: 12.34 --> 1234
        r = "%04d" % ra
        cmd = "f"+r+"+1"
        res = self.send(adr,cmd)
        return res
            
    def speed(self,adr,sp):
        sp = sp*100
        s = "%06d" % sp
        cmd = "S"+s
        res = self.send(adr,cmd)
        return res
            

    def direction(self,adr,di): # Direction of rotation
        if di == 'r':
            s = 'J'
        elif di == 'l':
            s = 'K'
        else:
            raise RuntimeError("Unknown direction")
        res = self.send(adr,s)
        return res   

    def send(self,adr,cmd):
        if adr<1 or adr>8:
            raise RuntimeError("Address outside 1..8")
        else:
            self.pumpe.flushInput()
            tmp = str(adr)+ cmd +"\r"
            tmp = tmp.encode("utf8")
            self.pumpe.write(tmp) # Sends tmp
            tmp = self.pumpe.read_until("\r",20)
            return tmp.decode("utf8")
        

def test():
    global p
    #p = ismatec("socket://10.115.1.166:1471")
    #p = ismatec("com20")
    #p = ismatec("/dev/ttyUSB0")
    print (p.version(1))
    #
    #p.kanalmodus(1)
    #p.speedmodus(1)
    while(True):
        p.start(1)
        p.speed(1,10)
        time.sleep(2)
        p.speed(1,20)
        time.sleep(2)
        p.stop(1)
        time.sleep(1)
    
if __name__== "__main__":
    p = ismatec("/dev/ttyUSB0")


