# hal_labonachip
# Classes for controlling Maestro, Aladdin syringe pump and Pi-Servo-pHAT
#
# Version 1.1
# 01.06.2021 - Class for Pi-Servo-pHAT added
#
# Version 1.0
# 03.09.2020  - Basic functions implemented
# 07.09.2020  - New function cmd() for pump communication

# STATUS :
# work in progress

import serial,time
import pi_servo_hat as psh

class servo:
    def __init__(self):
        self.hat = psh.PiServoHat()
        self.hat.restart()
        
    def move(self,channel,position):
        self.hat.move_servo_position(channel,position)
        
    def pwm(self,channel,dutycycle):
        self.hat.set_duty_cycle(channel,dutycycle)
    
    def on(self):
        # Relay connected to channel 15 
        self.pwm(15,100)
    
    def off(self):
        self.pwm(15,0)
        time.sleep(1)
        self.sleep()
    
    def sleep(self):
        # Setting the frequency ceases generation of PWM signal
        self.hat.set_pwm_frequency(50)
        
class maestro:
    def __init__(self,socket):
        self.controller = serial.Serial(port = socket, baudrate = 9600, timeout = 1)
    
    def miniscc(self,nr,pos):
        # Send und receive without error handling
        cmd = bytes([0xff,nr , pos])
        self.controller.write(cmd) # Sends cmd
        return
            
    def close(self):     # Cleanup by closing USB serial port
        self.controller.close()
        
# Communication errors with pump are not intercepted!
# But self.response shows last answer of the pump.

class aladin:
    def __init__(self,socket):
        self.pumpe = serial.Serial(port = socket, baudrate = 9600, timeout = 0.1)
        #self.pumpe = serial.serial_for_url("socket://10.115.1.166:1471", timeout = 1)
        #self.pumpe = serial.serial_for_url(socket, timeout = 1)
        #Jannik: timeout = 0.1 --> Pumps start ~simultaneously
        
       
    def version(self,adr):
        typ = self.cmd(adr,"VER")
        return typ
    
            
    def start(self,adr):
        res = self.cmd(adr,"RUN")
        return res

    def stop(self,adr):
        res = self.cmd(adr,"STP")
        return res
            
    def rate(self,adr,ra,un="UM"):
        tmp = "RAT" + str(ra)[:5] + un
        #print (tmp)
        res = self.cmd(adr,tmp)
        return res
            
    def speed(self,adr,sp):
        pass

    def direction(self,adr,di):
        if di == 'r':
            s = 'J'
        elif di == 'l':
            s = 'K'
        else:
            raise RuntimeError("Unknown Direction")
        

    def cmd(self,adr,tmp):
        # Send and receive with error handling
        self.pumpe.flushInput()
        if adr<0 or adr>9:
            raise RuntimeError("Address outside 0..9")
        else:
            res = self.tur(str(adr)+tmp) 
        if len(res) == 0:
            raise RuntimeError("No answer from pump")
        return res
        
    def tur(self,cmd):
        # Send and receive without error handling
        self.pumpe.flushInput()
        tmp = cmd +"\r"
        self.pumpe.write(tmp.encode("utf8")) # Sends cmd
        return self.pumpe.read_until("\r",25)
        

if __name__ == "__main__" :
    #ala = aladin("com5")
    #ala = aladin("/dev/ttyUSB0")
    print("Loaded")
    s=servo()
    def test():
        for n in range(15):
            print("Servo",n)
            s.move(n,45)
        s.on()
        for n in range(15):
            print("Servo",n)
            s.move(n,10)
            time.sleep(1)
            s.move(n,80)
            time.sleep(1)
            
    
    
