import Commands_LabOnAChip as hal, time # import command libraries
import openpyxl

# implement device

ala = hal.aladin("/dev/ttyUSB0") # enter port for pump/pump-network
#ala3 = hal.aladin("/dev/ttyUSB1") # optional third pump
adress_ala1 = 0
adress_ala2 = 1
#adress_ala3 = 0
servo = hal.servo() # enter port for servo microcontroller


excel_file = openpyxl.load_workbook('Pumpsystem_Sequence_Parameters.xlsx', data_only=True) # load sequence parameters from excel sheet
excel_sheet1 = excel_file['Tabelle1']

sequencestart = []
for col in excel_sheet1['A']:
    sequencestart.append(col.value)
sequencestart.pop(0)

servonr = []
for col in excel_sheet1['B']:
    servonr.append(col.value)
servonr.pop(0)

rate_pump1 = []
for col in excel_sheet1['C']:
    rate_pump1.append(col.value)
rate_pump1.pop(0)

rate_pump2 = []
for col in excel_sheet1['D']:
    rate_pump2.append(col.value)
rate_pump2.pop(0)

rate_pump3 = [] 
for col in excel_sheet1['E']:
    rate_pump3.append(col.value)
rate_pump3.pop(0)

pumped_volume = []
for col in excel_sheet1['G']:
    pumped_volume.append(col.value)
pumped_volume.pop(0)
   
startingpos = 60 # define servo positions for openend/closed valves
closed = 90
opened = -15

def servostartingpos(): # define commands addressing all servos
    servo.move(0,startingpos)
    servo.move(1,startingpos)
    servo.move(2,startingpos)
    servo.move(3,startingpos)
    servo.move(4,startingpos)
    servo.move(5,startingpos)
    servo.move(6,startingpos)
    servo.move(7,startingpos)
    servo.move(9,startingpos)

def allservoclosed():
    servo.move(0,closed)
    servo.move(1,closed)
    servo.move(2,closed)
    servo.move(3,closed)
    servo.move(4,closed)
    servo.move(5,closed)
    servo.move(6,closed)
    servo.move(7,closed)
    servo.move(9,closed)
    
def allservoopened():
    servo.move(0,opened)
    servo.move(1,opened)
    servo.move(2,opened)
    servo.move(3,opened)
    servo.move(4,opened)
    servo.move(5,opened)
    servo.move(6,opened)
    servo.move(7,opened)
    servo.move(9,opened)
  

def sequence(): # valve actuation and pumping sequence
    print("Sequence", i, "starts. servonr =", servonr[position], "rate_pump1 =", rate_pump1[position], "rate_pump2 =", rate_pump2[position], "rate_pump3 =", rate_pump3[position], "Pumpvolumen= ", pumped_volume[position])
    print("Time since t0 =", time.strftime('%H:%M:%S', time.gmtime(int(time.time()) - t0)))
    servo.on()
    if oldposition == "empty":
        allservoclosed()
    elif servonr[oldposition] != 9:
        servo.move((servonr[oldposition]-1), closed)
    elif servonr[oldposition] == 9:
        servo.move((servonr[oldposition]), closed)
    if servonr[position] != 9:
        servo.move((servonr[position]-1), opened)
    elif servonr[position] == 9:
        servo.move((servonr[position]), opened)
    time.sleep(0.2)
    servo.off()
    ala.rate(adress_ala1, rate_pump1[position])
    ala.rate(adress_ala2, rate_pump2[position])
    #ala3.rate(adress_ala3, rate_pump3[position])
    p = (pumped_volume[position] * 60) / (rate_pump1[position] + rate_pump2[position] + rate_pump3[position])
    time.sleep(1)
    ala.start(adress_ala1)
    ala.start(adress_ala2)
    #ala3.start(adress_ala3)
    time.sleep(p)
    ala.stop(adress_ala1)
    ala.stop(adress_ala2)
    #ala3.stop(adress_ala3)
    print("Sequence", i,"completed at", time.strftime('%H:%M:%S', time.gmtime(int(time.time()) - t0)))

servo.on() # preparing for assembly of servos onto chip
servostartingpos()
servo.off()

print("System ready. Press Enter to continue.")
input()
t0 = int(time.time())
i=1

if i==1:
    while True: # 'pre' loop for first sequence
        if min(sequencestart) == int(time.time()) - t0 or min(sequencestart) == int(time.time()) - t0 - 1:
        
            position = sequencestart.index(min(sequencestart))
            oldposition = "empty"
            sequence() # next sequence starts using parameters from Excel file
            servonr.remove(servonr[position])
            rate_pump1.remove(rate_pump1[position])
            rate_pump2.remove(rate_pump2[position])
            rate_pump3.remove(rate_pump3[position])
            pumped_volume.remove(pumped_volume[position])
            sequencestart.remove(min(sequencestart))
            i = i + 1
        
        if sequencestart == []:
            break

    
while True: # main loop: sequences imported from excel sheet are carried out
    if min(sequencestart, default = "empty") == int(time.time()) - t0 or min(sequencestart, default = "empty") == int(time.time()) - t0 - 1:
        
        position = sequencestart.index(min(sequencestart))
        sequence() # next sequence starts using parameters from Excel file
        oldposition = position
        servonr.remove(servonr[position])
        rate_pump1.remove(rate_pump1[position])
        rate_pump2.remove(rate_pump2[position])
        rate_pump3.remove(rate_pump3[position])
        pumped_volume.remove(pumped_volume[position])
        sequencestart.remove(min(sequencestart, default = "empty"))
        i = i + 1
               
    if sequencestart == []:
        break

print("All sequences completed after", time.strftime('%H:%M:%S', time.gmtime(int(time.time()) - t0)), ". See you later!")

                
