import Commands_LabOnAChip as hal, time # import command libraries 
import Commands_Ismatec as ismatec_pump

pumpe = ismatec_pump.ismatec("/dev/ttyUSB0") # enter port for pump/pump-network

pumpe.kanalmodus(2) # configure operating mode of pump

for n in range(1,5):
    pumpe.ratemodus(n)

servo = hal.servo() # enter port for servo microcontroller

startingpos = 80 # define servo positions for openend/closed valves
closed = 90
opened = -15

def allservoclosed(): # define commands addressing all servos
    servo.move(0,closed)
    servo.move(1,closed)
    servo.move(2,closed)
    servo.move(3,closed)
    servo.move(4,closed)
    servo.move(5,closed)
    servo.move(6,closed)
    servo.move(7,closed)
    servo.move(8,closed)
    
def allservoopened():
    servo.move(0,opened)
    servo.move(1,opened)
    servo.move(2,opened)
    servo.move(3,opened)
    servo.move(4,opened)
    servo.move(5,opened)
    servo.move(6,opened)
    servo.move(7,opened)
    servo.move(8,opened)
    
def servostartingpos():
    servo.move(0,startingpos)
    servo.move(1,startingpos)
    servo.move(2,startingpos)
    servo.move(3,startingpos)
    servo.move(4,startingpos)
    servo.move(5,startingpos)
    servo.move(6,startingpos)
    servo.move(7,startingpos)
    servo.move(8,startingpos)
    

servo.on() # preparing for assembly of servos onto chip
servostartingpos()
servo.off()
print("Press Enter")
input()

t0 = int(time.time())
i = 0
servo.on()
time.sleep(1)
o = 1
while True: # main loop: valves open sequentially, one at a time; flow is generated while valve is opened
    allservoclosed()
    servo.move(i, opened)
    servo.off()
    time.sleep(0.02)
    pumpe.rate(1, 0.5)
    pumpe.start(1)
    time.sleep(10)
    pumpe.stop(1)
    servo.on()
    time.sleep(0.1)
    print(time.strftime('%H:%M:%S', time.gmtime(int(time.time()) - t0)), "Ventil", i, "wurde geöffnet. Durchgang", o, ".")
  
    i = i+1
    o = o+1
    if i == 8:
        i = 0

    

                

