import numpy as np
from pyscf import ao2mo
from pyscf import gto
from pyscf.mcscf import CASCI, CASSCF

molA = gto.M(
        atom='MnNO_CN2_NH3_HF_mA.xyz',
        basis = {'Mn' :'6-31G', 'O' : '6-31g','C': 'sto-3g','N': 'sto-3g','N@' : '6-31g','H': 'sto-3g','H@': '6-31G','F': '6-31G'}, 
        spin=0, charge=0, verbose=4)

casA = (6,6)
path_cA = 'MnNO_CN2_NH3_HF_c0_s0_cas_6_6_coeff.npy'

creadA=np.load(path_cA)
mfA = molA.RHF()
solverA = CASCI(mfA, casA[1], casA[0])
solverA.kernel(creadA)
h1eff, h0 = solverA.get_h1eff()
cAact = solverA.mo_coeff[:,solverA.ncore:solverA.ncore+solverA.ncas]
h2e = ao2mo.kernel(solverA.mol, cAact, aosym=1).reshape((cAact.shape[1],)*4)

np.savez('hamiltonian.npz',
        c=creadA,
        h0=h0,
        h1=h1eff,
        h2= h2e
        )
#vqe0 = your_vqe_code(h0=h0, h1 = h1eff, h2 = h2e,...
