# Supporting Files for "Thermal site energy fluctuations in photosystem I: New insights from MD/QM/MM calculations"

Authors: Sebastian Reiter, Ferdinand L. Kiss, Jürgen Hauer, Regina de Vivie-Riedle

These files are for review only and will be uploaded to the public Zenodo repository https://doi.org/10.5281/zenodo.6576313 upon publication of the manuscript.

## tukey.csv

Raw results of Tukey's HSD test on the data set of all chlorophylls in 40 MD snapshots. 
The null hypothesis is "There is no statistical significant difference between the mean site energies of two chlorophylls.". If p-adj<0.05, the null hypothesis is rejected and the result is statistically significant.

    - group1 : Residue ID of the first chlorophyll as used in the MD simulations
    - group2 : Residue ID of the second chlorophyll as used in the MD simulations
    - name1 : Canonical name of the first chlorophyll
    - name2 : Canonical name of the second chlorophyll
    - meandiff : Pairwise mean difference in the site energy of these two chlorophylls.
    - p-adj : p-value
    - lower : Lower bound of the confidence interval of the mean differences.
    - upper : Upper bound of the confidence interval of the mean differences.

## tukey_rc.csv

Raw results of Tukey's HSD test on the data set of the reaction center chlorophylls in 200 MD snapshots. 
The null hypothesis is "There is no statistical significant difference between the mean site energies of two chlorophylls.". If p-adj<0.05, the null hypothesis is rejected and the result is statistically significant.

Table columns: See tukey.csv

## tukey_shift_elec.csv

Raw results of Tukey's HSD test on the data set of all chlorophylls in 40 MD snapshots. 
The null hypothesis is "There is no statistical significant difference between the mean electrostatic site energy shifts of two chlorophylls.". If p-adj<0.05, the null hypothesis is rejected and the result is statistically significant.

Table columns: See tukey.csv

## tukey_shift_struct.csv

Raw results of Tukey's HSD test on the data set of all chlorophylls in 40 MD snapshots. 
The null hypothesis is "There is no statistical significant difference between the mean structural site energy shifts of two chlorophylls.". If p-adj<0.05, the null hypothesis is rejected and the result is statistically significant.

Table columns: See tukey.csv

## coupling_ida.csv

Excitonic couplings of all chlorophylls in all MD snapshots in the point dipole approximation.

    - index : index column
    - traj : Number of the MD trajectory
    - snap : Number of the MD snapshot (0 to 95 in increments of 5)
    - donor : Residue ID of the donor chlorophyll as used in the MD simulations
    - acceptor : Residue ID of the donor chlorophyll as used in the MD simulations
    - r : Center of mass distance between the chlorophylls in Angstrom
    - v : Excitonic coupling in eV
    - v_scaled : Excitonic coupling in eV, scaled by 0.79 to include environmental screening effects
    - v_abs : Magnitude of the scaled excitonic coupling in eV
