MODULE CRP_Python_Wrapper

  USE CRP_General
  USE CRP_Wrapper
  USE PotentialData
  USE UnitConversion

  IMPLICIT NONE

  TYPE ( CRP_MoleculeSurface_PES ), SAVE :: PES
  TYPE ( Units ), SAVE :: FriendlyUnits

  INTEGER :: ModuleSetUp = 0

  PRIVATE :: ModuleSetUp

CONTAINS

  SUBROUTINE Initialize( )
    IMPLICIT NONE

    CALL Initialize_CRP_Wrapper_Module()
    IF ( ModuleSetUp .LT. 1 ) THEN
      CALL Standard_Potential_Data_Folders()
      ModuleSetUp = ModuleSetUp + 1
    END IF

    FriendlyUnits%LengthUnit = UNITS_ANGSTROM
    FriendlyUnits%EnergyUnit = UNITS_EV
    FriendlyUnits%MassUnit   = UNITS_MELEC
    FriendlyUnits%TimeUnit   = UNITS_PS
  END SUBROUTINE

  SUBROUTINE SetUp_CRP_Potential( DataSet )
    IMPLICIT NONE

    CHARACTER( LEN=* ), INTENT(IN) :: DataSet

    CALL SetUp_CRP_MoleculeSurface_PES( DataSet, PES )
  END SUBROUTINE

  SUBROUTINE Calculate_CRP_Potential( R, V, F )
    IMPLICIT NONE

    REAL, INTENT(IN) :: R(6)
    REAL, INTENT(OUT) :: V, F(6)

    CALL Calculate_CRP_MoleculeSurface_PES( PES, R, V, F, FriendlyUnits )
  END SUBROUTINE

  SUBROUTINE Destroy_CRP_Potential( )
    IMPLICIT NONE

    CALL Destroy_CRP_MoleculeSurface_PES( PES )
  END SUBROUTINE

  SUBROUTINE Get_Potential_Info( LatticeConstantX, LatticeConstantY, SkewingAngle )
    IMPLICIT NONE

    REAL, INTENT(OUT) :: LatticeConstantX, LatticeConstantY, SkewingAngle

    IF ( PES%Symmetry .EQ. 4 ) THEN
      LatticeConstantX = Convert_Length_Units( PES%Geometry%LatticeConstant, InternalUnits, FriendlyUnits )
      LatticeConstantY = Convert_Length_Units( PES%Geometry%LatticeConstant, InternalUnits, FriendlyUnits )
      SkewingAngle = 90
    ELSE IF ( PES%Symmetry .EQ. 3 .OR. PES%Symmetry .EQ. 6 ) THEN
      LatticeConstantX = Convert_Length_Units( PES%Geometry%LatticeConstant, InternalUnits, FriendlyUnits )
      LatticeConstantY = Convert_Length_Units( PES%Geometry%LatticeConstant, InternalUnits, FriendlyUnits )
      SkewingAngle = 60
    END IF
  END SUBROUTINE

END MODULE
