from simtk.openmm.app import *
from simtk.openmm import *
from simtk.unit import *


total_steps = 500000000


forcefield = ForceField('mimetic_ff.xml', 'amber14/tip3p.xml')
pdb = PDBFile('mimetic_137mM_NaCl.pdb')

system = forcefield.createSystem(pdb.topology, 
                                 nonbondedMethod=PME, nonbondedCutoff=1*nanometer, 
                                 constraints=HBonds)

f = system.getForce(3)
for ndx in range(f.getNumExceptions()):
    p = f.getExceptionParameters(ndx)
    if sorted(p[:2]) in [[57, 63]]:
        continue
    if p[0] > 104 or p[1] > 104:
        continue
    if p[2]._value == 0 and p[4]._value == 0:
        continue
    p[2] = p[2]/0.8333333333333334
    p[4] = p[4]/0.5
    f.setExceptionParameters(ndx, *p)


system.addForce(MonteCarloBarostat(1*bar, 300*kelvin))

integrator = LangevinIntegrator(300*kelvin, 1/picosecond, 0.002*picoseconds)

platform = Platform.getPlatformByName('OpenCL')
prop = dict(Precision='mixed')

simulation = Simulation(pdb.topology, system, integrator, platform, prop)
simulation.context.setPositions(pdb.positions)
simulation.context.setPeriodicBoxVectors(*pdb.topology.getPeriodicBoxVectors())

simulation.minimizeEnergy()

simulation.reporters.append(DCDReporter(f'run.dcd', 500))
simulation.reporters.append(StateDataReporter(f'run.log', reportInterval=10000,
                        step=True, time=True, potentialEnergy=True, kineticEnergy=True, totalEnergy=True,
                        temperature=True, volume=True, density=True, progress=True, remainingTime=True,
                        totalSteps=total_steps))
simulation.reporters.append(CheckpointReporter(f'run.chk', 100000))

simulation.step(total_steps)

