from simtk.openmm.app import *
from simtk.openmm import *
from simtk.unit import *


total_steps = 500000000


forcefield = ForceField('protein.ff14SB_gbsa2.xml', 'mimetic_ff_gbsa.xml')
pdb = PDBFile('FGF2_mimetic.pdb')

system = forcefield.createSystem(pdb.topology,
                                 nonbondedMethod=NoCutoff,
                                 constraints=HBonds)

f = system.getForce(3)
for ndx in range(f.getNumExceptions()):
    p = f.getExceptionParameters(ndx)
    if sorted(p[:2]) in [[57+2018, 63+2018]]:
        continue
    if p[0] < 2018 or p[1] < 2018:
        continue
    if p[0] > 2018+104 or p[1] > 2018+104:
        continue
    if p[2]._value == 0 and p[4]._value == 0:
        continue
    p[2] = p[2]/0.8333333333333334
    p[4] = p[4]/0.5
    f.setExceptionParameters(ndx, *p)


integrator = LangevinIntegrator(300*kelvin, 1/picosecond, 0.002*picoseconds)

platform = Platform.getPlatformByName('OpenCL')
prop = dict(Precision='mixed')

simulation = Simulation(pdb.topology, system, integrator, platform, prop)
simulation.context.setPositions(pdb.positions)

simulation.minimizeEnergy()

simulation.context.setVelocitiesToTemperature(300*kelvin)

simulation.reporters.append(DCDReporter(f'run.dcd', 500))
simulation.reporters.append(StateDataReporter(f'run.log', reportInterval=10000,
                        step=True, time=True, potentialEnergy=True, kineticEnergy=True, totalEnergy=True,
                        temperature=True, volume=True, density=True, progress=True, remainingTime=True,
                        totalSteps=total_steps))
simulation.reporters.append(CheckpointReporter(f'run.chk', 100000))

simulation.step(total_steps)

