/*
 * Spherical_Vapour_Coupled_ViscoElastic.java
 */

import com.comsol.model.*;
import com.comsol.model.util.*;

/** Model exported on May 19 2024, 12:18 by COMSOL 6.1.0.252. */
public class Spherical_Vapour_Coupled_ViscoElastic {

  public static Model run() {
    Model model = ModelUtil.create("Model");

    model
         .modelPath("C:\\Users\\sman001\\OneDrive - Wageningen University & Research\\General _Luciano\\.mph FIles\\1D_Sphere_Cavity_Skin\\ViscoElastic");

    model.label("Spherical_Vapour_Coupled_ViscoElsatic_Temp_TgT1_Correct_Fig2.mph");

    model.param().set("Gd", "G_ref", "Dry Shear Modulus");
    model.param().set("RT1", "R_gas*Temp", "Universal gas constant * temperature");
    model.param().set("chi", "0.5", "dis-affinity parameter");
    model.param().set("Omega", "1.8*10^(-5)[m^3/mol]", "Water molar volume");
    model.param().set("DD", "10^-9[m^2/s]", "Diffusivity");
    model.param().set("Tt", "20[s]", "Evolution time of external chemical potential");
    model.param().set("mu_end", "-100[J/mol]", "Final value of external chemical potential");
    model.param().set("lamo", "1.5269815", "Initial swollen stretch");
    model.param().set("Tf", "1e8 [s]", "Final time of simulation");
    model.param().set("Rc", "fac_Rin*Rd", "Inner radius in dry reference");
    model.param().set("Rd", "0.01[m]", "Outer radius in dry reference");
    model.param().set("patm", "1.01*10^5[Pa]", "Atmospheric pressure");
    model.param().set("phi_ref", "0.05", "Reference volume fraction = stress free");
    model.param().set("Lambda_0", "1.5^third");
    model.param().set("third", "1.0/3.0");
    model.param().set("beta", "9/4", "Cloizeaux scaling parameter");
    model.param().set("G_ref", "2e5 [Pa]", "Reference Modulus");
    model.param().set("A_cx", "(2.0*third)^(third-beta)", "Constaint in Cloiseaux Law");
    model.param().set("phi_w_ext", "0.75");
    model.param().set("rho_air", "1.29 [kg/m^3]", "Density of air");
    model.param().set("cp_air", "1000 [J/kg/K]", "Specific heat air");
    model.param().set("u_air", "4", "Air velocity around object");
    model.param().set("h_air", "(6+u_air*10) [W/m^2/K]", "Heat transfer coefficient");
    model.param().set("beta_air", "h_air/(rho_air*cp_air)", "Mass transfer coefficient");
    model.param().set("Temp", "T0+25", "Initial Product Temperature");
    model.param().set("TempCelsius", "Temp-273.15");
    model.param().set("M_w", "18 [g/mol]");
    model.param().set("RH_air", "RH_AIR", "Relative humidity");
    model.param().set("T0", "273.15 [K]");
    model.param().set("R_gas", "8.31 [J/mol/K]", "Universal gas constant");
    model.param().set("T_air", "T_end");
    model.param().set("rho_w", "1000 [kg/m^3]", "Density liquid water");
    model.param().set("rho_s", "1550 [kg/m^3]", "Density of polysaccharides");
    model.param().set("p0", "G_ref*Lambda_0+patm", "Initial mechanical pressure");
    model.param().set("RH_cav0", "1");
    model.param().set("N_vap0", "p_vap0*Vc0/(R_gas*T_init)");
    model.param().set("R_cav0", "Rc");
    model.param().set("Vc0", "4*pi/3*R_cav0^3", "Initial Volume");
    model.param().set("p_vap0", "RH_init*p_sat(T_init)");
    model.param().set("p_air0", "p_init-p_vap0");
    model.param().set("p_init", "patm");
    model.param().set("G_skin", "fac_GG*G_ref");
    model.param().set("phi_skin", "phi_ref*(G_skin/G_ref)^(1/beta)");
    model.param().set("p1", "G_skin*Lambda_0+patm");
    model.param().set("thickness_skin", "Rd*0.05");
    model.param().set("T_end", "T_init+15", "Final drying temperature");
    model.param().set("T_init", "Temp", "Initial temperature");
    model.param().set("rho_eff", "rho_w");
    model.param().set("cp_eff", "4200 [J/kg/K]", "Specific heat");
    model.param().set("k_w", "0.6 [W/m/K]", "Thermal conductivity");
    model.param().set("dHm_evap", "40.65 [kJ/mol]", "Latent Heat of evaporation");
    model.param().set("D_vap", "2e-5 [m^2/s]", "Vapour diffusion is air");
    model.param().set("dH_evap", "dHm_evap/Omega");
    model.param().set("cp_w", "4200 [J/kg/K]");
    model.param().set("cp_s", "2000 [J/kg/K]");
    model.param().set("k_s", "0.2 [W/m/K]", "Thermal conductivity solids");
    model.param().set("Tp0", "T_init");
    model.param().set("N_air", "p_air0*Vc0/(R_gas*T_init)");
    model.param().set("RH_init", "1");
    model.param().set("Tf0", "1e7");
    model.param().set("fac_GG", "20 [1]");
    model.param().set("Pi_air", "fac_Pi*G_ref");
    model.param().set("fac_Pi", "50 [1]");
    model.param().set("RH_AIR", "exp(-Pi_air*Omega/(R_gas*T_init))");
    model.param().set("Rm", "Rd-thickness_skin");
    model.param().set("fac_Rin", "0.5 [1]");
    model.param().set("pvap_sat", "p_sat(T_init)");
    model.param().set("tau_min_core", "1e4 [s]");
    model.param().set("tau_min_skin", "1e7 [s]");
    model.param().set("dCpw", "1.92 [kJ/kg/K]", "dCP water");
    model.param().set("dCps", "0.42 [kJ/kg/K]", "dCP starch");
    model.param().set("Tg_w", "139 [K]", "Glass T water");
    model.param().set("Tg_s", "500 [K]", "Glass STarch");
    model.param().set("eta_a", "0.22 [Pa*s]", "REf viscosity");
    model.param().set("G_inf", "1e10 [Pa]", "Glassy Modulus");

    model.component().create("comp1", true);

    model.component("comp1").geom().create("geom1", 1);

    model.component("comp1").curvedInterior(false);

    model.result().table().create("evl2", "Table");
    model.result().table().create("tbl1", "Table");
    model.result().table().create("tbl2", "Table");

    model.component("comp1").func().create("step1", "Step");
    model.func().create("an1", "Analytic");
    model.func().create("an2", "Analytic");
    model.component("comp1").func().create("step2", "Step");
    model.func().create("an3", "Analytic");
    model.func().create("an4", "Analytic");
    model.func().create("an5", "Analytic");
    model.func().create("an6", "Analytic");
    model.func().create("an7", "Analytic");
    model.component("comp1").func("step1").set("location", "Tt");
    model.component("comp1").func("step1").set("smooth", "Tt");
    model.func("an1").label("saturated pressure");
    model.func("an1").set("funcname", "p_sat");
    model.func("an1").set("expr", "0.61078e3*exp( 17.27*(T-T0) / (T-T0+237.3))");
    model.func("an1").set("args", new String[]{"T"});
    model.func("an1").set("fununit", "Pa");
    model.func("an1").set("argunit", new String[]{"K"});
    model.func("an1").set("plotargs", new String[][]{{"T", "0", "1"}});
    model.func("an2").active(false);
    model.func("an2").label("saturated concentration");
    model.func("an2").set("funcname", "c_sat");
    model.func("an2").set("expr", "p_sat(T)*M_w/R_gas*T");
    model.func("an2").set("args", new String[]{"T"});
    model.func("an2").set("fununit", "kg/m^3");
    model.func("an2").set("argunit", new String[]{"K"});
    model.func("an2").set("plotargs", new String[][]{{"T", "0", "1"}});
    model.component("comp1").func("step2").set("location", "Tt");
    model.component("comp1").func("step2").set("smooth", "Tt");
    model.func("an3").label("saturated concentration NEW");
    model.func("an3").set("funcname", "c_sat");
    model.func("an3").set("expr", "p_sat(T)*M_w/(R_gas*T)");
    model.func("an3").set("args", new String[]{"T"});
    model.func("an3").set("fununit", "kg/m^3");
    model.func("an3").set("argunit", new String[]{"K"});
    model.func("an3").set("plotargs", new String[][]{{"T", "250", "350"}});
    model.func("an4").label("Couchman-Karasz");
    model.func("an4").set("funcname", "T_g");
    model.func("an4").set("expr", "(Tg_w*dCpw*y_w+Tg_s*dCps*(1-y_w))/(dCpw*y_w+dCps*(1-y_w))");
    model.func("an4").set("args", new String[]{"y_w"});
    model.func("an4").set("fununit", "K");
    model.func("an4").set("argunit", new String[]{"1"});
    model.func("an4").set("plotargs", new String[][]{{"y_w", "0", "1"}});
    model.func("an5").label("Viscosity matrix");
    model.func("an5").set("funcname", "eta_0");
    model.func("an5").set("expr", "eta_a*10^PolyQ(TgT-0.35)");
    model.func("an5").set("args", new String[]{"TgT"});
    model.func("an5").set("fununit", "Pa*s");
    model.func("an5").set("argunit", new String[]{"1"});
    model.func("an5").set("plotargs", new String[][]{{"TgT", "0", "1"}});
    model.func("an6").label("polynomial eta");
    model.func("an6").set("funcname", "PolyQ");
    model.func("an6").set("expr", "4*q+11*q^2+12*q^3");
    model.func("an6").set("args", new String[]{"q"});
    model.func("an6").set("fununit", "1");
    model.func("an6").set("argunit", new String[]{"1"});
    model.func("an6").set("plotargs", new String[][]{{"q", "0", "1"}});
    model.func("an7").label("tau_alpha");
    model.func("an7").set("funcname", "tau_TgT");
    model.func("an7").set("expr", "eta_0(TgT)/G_inf");
    model.func("an7").set("args", new String[]{"TgT"});
    model.func("an7").set("fununit", "s");
    model.func("an7").set("argunit", new String[]{"1"});
    model.func("an7").set("plotargs", new String[][]{{"TgT", "0", "1"}});

    model.component("comp1").mesh().create("mesh1");

    model.component("comp1").geom("geom1").create("i1", "Interval");
    model.component("comp1").geom("geom1").feature("i1").set("coord", new String[]{"Rc", "Rd-thickness_skin"});
    model.component("comp1").geom("geom1").create("pt1", "Point");
    model.component("comp1").geom("geom1").feature("pt1").set("p", new String[]{"Rc"});
    model.component("comp1").geom("geom1").create("i2", "Interval");
    model.component("comp1").geom("geom1").feature("i2").set("coord", new String[]{"Rd-thickness_skin", "Rd"});
    model.component("comp1").geom("geom1").run();
    model.component("comp1").geom("geom1").run("fin");

    model.component("comp1").variable().create("var4");
    model.component("comp1").variable("var4").set("Vco", "4/3*pi*Rc^3", "Initial cavity volume");
    model.component("comp1").variable("var4").set("pI", "patm*Vc0/Vc", "Inner pressure");
    model.component("comp1").variable("var4").set("pO", "patm", "Outer pressure");
    model.component("comp1").variable("var4").set("p_air", "N_air*R_gas*T_gas/Vc", "Air pressure in cavity");
    model.component("comp1").variable("var4").set("p_gas", "p_air + p_vap");
    model.component("comp1").variable("var4").set("p_IN", "p_gas");
    model.component("comp1").variable("var4").set("p_OUT", "p_init");
    model.component("comp1").variable("var4").set("R_c", "intop2(Lambda_q)*Rc");
    model.component("comp1").variable("var4").set("Vc", "4*pi/3*R_c^3");
    model.component("comp1").variable("var4").set("J_CAV", "intop2(J_cav)*A_cav");
    model.component("comp1").variable("var4").set("A_cav", "4*pi*R_c^2", "Area Cavity");
    model.component("comp1").variable("var4").set("N_vap", "NVAP");
    model.component("comp1").variable("var4").set("p_vap", "N_vap*R_gas*T_gas/Vc", "vapour pressure");
    model.component("comp1").variable("var4").set("R_cav", "R_c", "Current Cavity Radius");
    model.component("comp1").variable("var4").set("RH_CAV", "p_vap/p_sat(T_gas)");
    model.component("comp1").variable("var4").set("T_gas", "intop2(Tp)");
    model.component("comp1").variable("var4").set("beta_cav", "D_vap/(R_cav/4)");
    model.component("comp1").variable("var4").set("R_gel", "intop3(Lambda_q)*Rd");
    model.component("comp1").variable("var4").set("cd0", "(1-phi_s0)/Omega");
    model.component("comp1").variable().create("var1");
    model.component("comp1").variable("var1").set("Lambda_r", "1+ux", "Radial stretch");
    model.component("comp1").variable("var1").set("Lambda_q", "1+u/x", "Hoop stretch ; Defined from InitDomain");
    model.component("comp1").variable("var1")
         .set("Srr_o", "G_ref/Lambda_r*(1/(Lambda_q^4*A^2)-1)-p*Lambda_q^2", "Radial Stress");
    model.component("comp1").variable("var1").set("Jd", "Lambda_r*Lambda_q^2", "Volume deformation");
    model.component("comp1").variable("var1").set("Js", "phi_ref/phi_s");
    model.component("comp1").variable("var1")
         .set("Pi_mix_c", "(A_cx*G_ref*(phi_s/phi_ref)^beta-p)", "Osmotic pressure dimensionless");
    model.component("comp1").variable("var1").set("flux_muw_r", "D_contra/(R_gas*Tp)*d(Pi_mix_c,x)");
    model.component("comp1").variable("var1").set("a_w_int", "exp((-Pi_mix - p_gas)*Omega/(R_gas*Tp))");
    model.component("comp1").variable("var1").set("phi_s", "phi_s0/Jd");
    model.component("comp1").variable("var1").set("J0", "Lambda_0^3");
    model.component("comp1").variable("var1").set("phi_w_init", "1-phi_s0");
    model.component("comp1").variable("var1").set("phi_w", "1-phi_s");
    model.component("comp1").variable("var1").set("phi_s0", "phi_ref/J0");
    model.component("comp1").variable("var1").set("C_eff_0", "phi_w_init*cp_w*rho_w+phi_s0*cp_s*rho_s");
    model.component("comp1").variable("var1").set("C_eff", "phi_w*cp_w*rho_w+phi_s*cp_s*rho_s");
    model.component("comp1").variable("var1").set("k_eff", "phi_w*k_w+phi_s*k_s");
    model.component("comp1").variable("var1").set("k_contra", "k_eff*Lambda_q^2/Lambda_r");
    model.component("comp1").variable("var1").set("C_w", "cp_w*rho_w");
    model.component("comp1").variable("var1").set("Qr", "-k_contra*d(Tp,x)+flux_muw_r*C_w*Tp*Omega");
    model.component("comp1").variable("var1").set("Jhat", "phi_s0 + Omega * cc");
    model.component("comp1").variable("var1").set("po", "G_ref/Lambda_0+patm");
    model.component("comp1").variable("var1").set("cc0", "(1-phi_s0)/Omega");
    model.component("comp1").variable("var1").set("Pi_mix", "Pi_mix_c");
    model.component("comp1").variable("var1").set("cd", "cc");
    model.component("comp1").variable("var1")
         .set("J_cav", "Lambda_q^2*beta_cav*(a_w_int - RH_CAV)*c_sat(T_gas)/M_w");
    model.component("comp1").variable("var1").set("ps", "(-Srr+G_ref*Lambda_r/Lambda_0)/Lambda_q^2");
    model.component("comp1").variable("var1").set("pmu", "-Pi_mix+A_cx*G_ref*(phi_s/phi_ref)^beta");
    model.component("comp1").variable("var1").set("sigma_rr", "Srr/(Lambda_q^2)");
    model.component("comp1").variable("var1")
         .set("Sqq_o", "G_ref/Lambda_q*(Lambda_q^2*A-1)-p*Lambda_r*Lambda_q", "Hoop Stress");
    model.component("comp1").variable("var1").set("TgT", "T_g(y_w)/Tp", "TgT for tau");
    model.component("comp1").variable("var1")
         .set("tau_core", "tau_min_core+tau_TgT(TgT)", "relaxation time TgT dependent");
    model.component("comp1").variable("var1").set("Srr", "(G_ref/(Lambda_q^4*A^2)-p)*Lambda_q^2", "Radial Stress");
    model.component("comp1").variable("var1").set("Sqq", "(G_ref*Lambda_q^2*A-p)*Lambda_r*Lambda_q", "Hoop Stress");
    model.component("comp1").variable("var1").selection().geom("geom1", 1);
    model.component("comp1").variable("var1").selection().set(1);
    model.component("comp1").variable().create("var8");
    model.component("comp1").variable("var8").set("phi_s", "phi_s0/Jd");
    model.component("comp1").variable("var8").set("phi_w", "1-phi_s");
    model.component("comp1").variable("var8").set("Jhat", "phi_s0 + Omega * cs");
    model.component("comp1").variable("var8").set("Pi_mix", "Pi_mix_s");
    model.component("comp1").variable("var8").set("cs0", "(1-phi_s0)/Omega");
    model.component("comp1").variable("var8").set("flux_muw_r", "D_contra/(R_gas*Tp)*d(Pi_mix_s,x)");
    model.component("comp1").variable("var8").set("T_out", "intop3(Tp)");
    model.component("comp1").variable("var8").set("J0", "Lambda_0^3");
    model.component("comp1").variable("var8").set("C_w", "cp_w*rho_w");
    model.component("comp1").variable("var8").set("Js", "phi_skin/phi_s");
    model.component("comp1").variable("var8").set("Lambda_r", "1+ux", "Radial stretch");
    model.component("comp1").variable("var8").set("cd", "cs");
    model.component("comp1").variable("var8").set("C_eff", "phi_w*cp_w*rho_w+phi_s*cp_s*rho_s");
    model.component("comp1").variable("var8").set("C_eff_0", "phi_w_init*cp_w*rho_w+phi_s0*cp_s*rho_s");
    model.component("comp1").variable("var8")
         .set("Pi_mix_s", "(A_cx*G_skin*(phi_s/phi_skin)^beta-p)", "Osmotic pressure dimensionless");
    model.component("comp1").variable("var8").set("k_contra", "k_eff*Lambda_q^2/Lambda_r");
    model.component("comp1").variable("var8").set("phi_s0", "phi_skin/J0");
    model.component("comp1").variable("var8").set("Lambda_q", "1+u/x", "Hoop stretch");
    model.component("comp1").variable("var8").set("phi_w_init", "1-phi_s0");
    model.component("comp1").variable("var8")
         .set("J_evap", "Lambda_q^2*beta_air*(a_w_ext*c_sat(T_out)-RH_ext*c_sat(T_ext))/M_w", "evaporative flux");
    model.component("comp1").variable("var8").set("po", "G_skin/Lambda_0+patm");
    model.component("comp1").variable("var8").set("Qr", "-k_contra*d(Tp,x)+flux_muw_r*C_w*Tp*Omega");
    model.component("comp1").variable("var8").set("a_w_ext", "exp((-Pi_mix-patm)*Omega/(R_gas*Tp))");
    model.component("comp1").variable("var8").set("Jd", "Lambda_r*Lambda_q^2", "Volume deformation");
    model.component("comp1").variable("var8").set("k_eff", "phi_w*k_w+phi_s*k_s");
    model.component("comp1").variable("var8").set("ps", "(-Srr+G_skin*Lambda_r/Lambda_0)/Lambda_q^2");
    model.component("comp1").variable("var8").set("pmu", "-Pi_mix+A_cx*G_skin*(phi_s/phi_skin)^beta");
    model.component("comp1").variable("var8").set("sigma_rr", "Srr/(Lambda_q^2)");
    model.component("comp1").variable("var8")
         .set("Srr", "G_skin/Lambda_r*(1/(Lambda_q^4*A^2)-1)-p*Lambda_q^2", "Radial Stress");
    model.component("comp1").variable("var8")
         .set("Sqq", "G_skin/Lambda_q*(Lambda_q^2*A-1)-p*Lambda_r*Lambda_q", "Hoop Stress");
    model.component("comp1").variable("var8").set("TgT", "T_g(y_w)/Tp", "TgT for tau");
    model.component("comp1").variable("var8")
         .set("tau_skin", "tau_min_skin+tau_TgT(TgT)", "relaxation time TgT dependent");
    model.component("comp1").variable("var8").selection().geom("geom1", 1);
    model.component("comp1").variable("var8").selection().set(2);
    model.component("comp1").variable().create("var6");
    model.component("comp1").variable("var6")
         .set("Ds_gel", "Ds_w0*phi_s_lim/(phi_s_lim+(1-phi_w)^1.5)", "Tokita Relation");
    model.component("comp1").variable("var6").set("phi_s_lim", "0.01");
    model.component("comp1").variable("var6").set("Af", "y_w*Vc_w + xi_b*(1-y_w)*Vc_s");
    model.component("comp1").variable("var6").set("y_w", "phi_w*rho_w/(phi_w*rho_w+(1-phi_w)*rho_s)");
    model.component("comp1").variable("var6").set("D_m", "phi_w*Ds_gel+(1-phi_w)*D_sw");
    model.component("comp1").variable("var6").set("Bf", "y_w*K_ww*(K_sw-T_gw+Tp)+(1-y_w)*K_ws*(K_ss-T_gs+Tp)");
    model.component("comp1").variable("var6").set("D_sw", "Ds_w0*exp(-dE/(R_gas*Tp))*exp(-Af/Bf)");
    model.component("comp1").variable("var6").set("D_contra", "D_m*Lambda_q^2/Lambda_r");
    model.component("comp1").variable("var6").set("RT", "R_gas*Tp");
    model.component("comp1").variable("var6").set("Dmu", "1e-4");
    model.variable().create("var7");
    model.variable("var7").set("Vc_w", "0.91 [ml/g]", "critical volume");
    model.variable("var7").set("T_gw", "136 [K]", "Glass transition Temp water");
    model.variable("var7").set("dE", "1.98e3 [J/mol]", "Activation energy for diffusion");
    model.variable("var7").set("K_sw", "-19.73 [K]", "FV parameter");
    model.variable("var7").set("K_ww", "1.945e-3 [ml/g/K]", "FV Parameter");
    model.variable("var7").set("Vc_s", "0.59 [ml/g]", "critical volume");
    model.variable("var7").set("T_gs", "347.15 [K]", "glass temperature (sucrose)");
    model.variable("var7").set("xi_b", "0.79", "fit parameter");
    model.variable("var7").set("K_ss", "69.21 [K]", "FV Parameter");
    model.variable("var7").set("K_ws", "3.36e-4 [ml/g/K]", "FV parameter");
    model.variable("var7").set("Ds_w0", "1.39e-7 [m^2/s]", "Self Diffusion pure water");
    model.component("comp1").variable().create("var5");
    model.component("comp1").variable("var5").set("RH_ext", "RH_air");
    model.component("comp1").variable("var5").set("RH_start", "1");
    model.component("comp1").variable().create("var9");
    model.component("comp1").variable("var9").set("T_ext", "T_end");
    model.component("comp1").variable().create("var10");
    model.component("comp1").variable("var10").set("Qr", "-k_contra*d(Tp,x)+flux_muw_r*Omega*C_w*Tp");
    model.component("comp1").variable("var10").set("C_eff", "phi_w*cp_w*rho_w+phi_s*cp_s*rho_s");
    model.component("comp1").variable("var10").set("k_eff", "phi_w*k_w+phi_s*k_s");
    model.component("comp1").variable("var10").set("k_contra", "k_eff*Lambda_q^2/Lambda_r");
    model.component("comp1").variable("var10").set("C_eff_0", "phi_w_init*cp_w*rho_w+phi_s0*cp_s*rho_s");
    model.component("comp1").variable("var10").set("C_w", "cp_w*rho_w");
    model.component("comp1").variable().create("var11");
    model.component("comp1").variable("var11").set("NVAP", "1.5*p_vap0*Vc0/(R_gas*T_gas)");
    model.component("comp1").variable("var11").set("cd", "cd0");
    model.component("comp1").variable().create("var12");
    model.component("comp1").variable("var12").set("phi_s_skin", "intop6(phi_s)/intop6(1)");
    model.component("comp1").variable("var12").set("tilde_phi_skin", "phi_s_skin/phi_skin");
    model.component("comp1").variable("var12").set("phi_s_core", "intop5(phi_s)/intop5(1)");
    model.component("comp1").variable("var12").set("tilde_phi_core", "phi_s_core/phi_ref");
    model.component("comp1").variable("var12").set("Lambda_skin", "intop3(Lambda_q)*Lambda_0");
    model.component("comp1").variable("var12").set("Lambda_cav", "intop2(Lambda_q)*Lambda_0");
    model.component("comp1").variable("var12").set("Lambda_inter", "intop4(Lambda_q)*Lambda_0");
    model.component("comp1").variable("var12")
         .set("FacA_skin", "(1+4*tilde_phi_skin*Lambda_inter^3)/(tilde_phi_skin*Lambda_inter^4)");
    model.component("comp1").variable("var12")
         .set("FacB_skin", "(1+4*tilde_phi_skin*Lambda_skin^3)/(tilde_phi_skin*Lambda_skin^4)");
    model.component("comp1").variable("var12")
         .set("FacB_core", "(1+4*tilde_phi_core*Lambda_inter^3)/(tilde_phi_core*Lambda_inter^4)");
    model.component("comp1").variable("var12")
         .set("FacA_core", "(1+4*tilde_phi_core*Lambda_cav^3)/(tilde_phi_core*Lambda_cav^4)");
    model.component("comp1").variable("var12").set("dp_skin", "G_skin/2*(FacA_skin-FacB_skin)");
    model.component("comp1").variable("var12").set("dp_core", "G_ref/2*(FacA_core-FacB_core)");
    model.component("comp1").variable("var12").set("dsigmaskin", "intop3(Srr)/intop3(1)-intop4(Srr)/intop4(1)");
    model.component("comp1").variable("var12").set("dsigmacore", "intop4(Srr)/intop4(1)-intop2(Srr)/intop2(1)");
    model.component("comp1").variable("var12").set("dp_all", "dp_skin+dp_core");
    model.component("comp1").variable("var12").set("phi_skin_est", "(Pi_ext/(A_cx*G_skin))^(1/beta)*phi_skin");
    model.component("comp1").variable("var12").set("Pi_ext", "R_gas*Tp/Omega*log(a_w_ext)");

    model.view().create("view2", 2);
    model.view().create("view3", 2);

    model.component("comp1").cpl().create("intop1", "Integration");
    model.component("comp1").cpl().create("intop2", "Integration");
    model.component("comp1").cpl().create("intop3", "Integration");
    model.component("comp1").cpl().create("intop4", "Integration");
    model.component("comp1").cpl().create("intop5", "Integration");
    model.component("comp1").cpl().create("intop6", "Integration");
    model.component("comp1").cpl("intop1").selection().set(1, 2);
    model.component("comp1").cpl("intop2").selection().geom("geom1", 0);
    model.component("comp1").cpl("intop2").selection().set(1);
    model.component("comp1").cpl("intop3").selection().geom("geom1", 0);
    model.component("comp1").cpl("intop3").selection().set(3);
    model.component("comp1").cpl("intop4").selection().geom("geom1", 0);
    model.component("comp1").cpl("intop4").selection().set(2);
    model.component("comp1").cpl("intop5").selection().set(1);
    model.component("comp1").cpl("intop6").selection().set(2);

    model.component("comp1").physics().create("w", "WeakFormPDE", "geom1");
    model.component("comp1").physics("w").prop("Units").set("DependentVariableQuantity", "displacement");
    model.component("comp1").physics("w").create("flux1", "FluxBoundary", 0);
    model.component("comp1").physics("w").feature("flux1").selection().set(1);
    model.component("comp1").physics("w").create("flux2", "FluxBoundary", 0);
    model.component("comp1").physics("w").feature("flux2").selection().set(3);
    model.component("comp1").physics("w").create("weak1", "WeakContribution", 0);
    model.component("comp1").physics("w").feature("weak1").selection().set(1);
    model.component("comp1").physics("w").create("weak2", "WeakContribution", 0);
    model.component("comp1").physics("w").feature("weak2").selection().set(3);
    model.component("comp1").physics().create("w2", "WeakFormPDE", "geom1");
    model.component("comp1").physics("w2").field("dimensionless").field("p");
    model.component("comp1").physics("w2").field("dimensionless").component(new String[]{"p"});
    model.component("comp1").physics("w2").prop("Units").set("DependentVariableQuantity", "none");
    model.component("comp1").physics("w2").prop("Units").set("CustomDependentVariableUnit", "Pa");
    model.component("comp1").physics().create("w4", "WeakFormPDE", "geom1");
    model.component("comp1").physics("w4").identifier("w4");
    model.component("comp1").physics("w4").field("dimensionless").field("cc");
    model.component("comp1").physics("w4").field("dimensionless").component(new String[]{"cc"});
    model.component("comp1").physics("w4").prop("Units").set("DependentVariableQuantity", "none");
    model.component("comp1").physics("w4").prop("Units").set("CustomDependentVariableUnit", "mol/m^3");
    model.component("comp1").physics("w4").selection().set(1);
    model.component("comp1").physics("w4").create("dir1", "DirichletBoundary", 0);
    model.component("comp1").physics("w4").feature("dir1").selection().set(2);
    model.component("comp1").physics("w4").create("flux1", "FluxBoundary", 0);
    model.component("comp1").physics("w4").feature("flux1").selection().set(3);
    model.component("comp1").physics("w4").create("flux2", "FluxBoundary", 0);
    model.component("comp1").physics("w4").feature("flux2").selection().set(1);
    model.component("comp1").physics("w4").create("weak1", "WeakContribution", 0);
    model.component("comp1").physics("w4").feature("weak1").selection().set(1);
    model.component("comp1").physics("w4").create("weak2", "WeakContribution", 0);
    model.component("comp1").physics("w4").feature("weak2").selection().set(2, 3);
    model.component("comp1").physics("w4").create("ge1", "GlobalEquations", -1);
    model.component("comp1").physics("w4").feature("ge1").set("DependentVariableQuantity", "none");
    model.component("comp1").physics("w4").feature("ge1").set("CustomDependentVariableUnit", "mol");
    model.component("comp1").physics().create("w3", "WeakFormPDE", "geom1");
    model.component("comp1").physics("w3").field("dimensionless").field("Tp");
    model.component("comp1").physics("w3").field("dimensionless").component(new String[]{"Tp"});
    model.component("comp1").physics("w3").prop("Units").set("DependentVariableQuantity", "none");
    model.component("comp1").physics("w3").prop("Units").set("CustomDependentVariableUnit", "K");
    model.component("comp1").physics("w3").create("flux1", "FluxBoundary", 0);
    model.component("comp1").physics("w3").feature("flux1").selection().set(3);
    model.component("comp1").physics("w3").create("flux2", "FluxBoundary", 0);
    model.component("comp1").physics("w3").feature("flux2").selection().set(1);
    model.component("comp1").physics().create("w5", "WeakFormPDE", "geom1");
    model.component("comp1").physics("w5").field("dimensionless").field("cs");
    model.component("comp1").physics("w5").field("dimensionless").component(new String[]{"cs"});
    model.component("comp1").physics("w5").prop("Units").set("DependentVariableQuantity", "none");
    model.component("comp1").physics("w5").prop("Units").set("CustomDependentVariableUnit", "mol/m^3");
    model.component("comp1").physics("w5").selection().set(2);
    model.component("comp1").physics("w5").create("weak1", "WeakContribution", 0);
    model.component("comp1").physics("w5").feature("weak1").selection().set(3);
    model.component("comp1").physics("w5").create("weak2", "WeakContribution", 0);
    model.component("comp1").physics("w5").feature("weak2").selection().set(2);
    model.component("comp1").physics().create("dode", "DomainODE", "geom1");
    model.component("comp1").physics("dode").field("dimensionless").field("A");
    model.component("comp1").physics("dode").field("dimensionless").component(new String[]{"A"});
    model.component("comp1").physics("dode").selection().set(1);
    model.component("comp1").physics().create("dode2", "DomainODE", "geom1");
    model.component("comp1").physics("dode2").field("dimensionless").field("A");
    model.component("comp1").physics("dode2").selection().set(2);

    model.component("comp1").mesh("mesh1").autoMeshSize(2);

    model.component("comp1").probe().create("var1", "GlobalVariable");
    model.component("comp1").probe().create("var2", "GlobalVariable");
    model.component("comp1").probe().create("var3", "GlobalVariable");
    model.component("comp1").probe().create("var4", "GlobalVariable");
    model.component("comp1").probe().create("var5", "GlobalVariable");
    model.component("comp1").probe().create("var6", "GlobalVariable");
    model.component("comp1").probe().create("var7", "GlobalVariable");
    model.component("comp1").probe().create("var8", "GlobalVariable");
    model.component("comp1").probe().create("var9", "GlobalVariable");

    model.result().table("evl2").label("Evaluation 2D");
    model.result().table("evl2").comments("Interactive 2D values");
    model.result().table("tbl2").label("Probe Table 2");

    model.component("comp1").variable("var4").label("Global Volumes");
    model.component("comp1").variable("var1").label("Variables System core");
    model.component("comp1").variable("var8").label("Variables System skin");
    model.component("comp1").variable("var6").label("DiffusionSystem");
    model.variable("var7").label("Diff Parameters");
    model.component("comp1").variable("var5").label("Outer c_air");
    model.component("comp1").variable("var9").label("Outer T_air");
    model.component("comp1").variable("var10").active(false);
    model.component("comp1").variable("var10").label("Energy");
    model.component("comp1").variable("var11").active(false);
    model.component("comp1").variable("var11").label("MassInit");
    model.component("comp1").variable("var12").label("Analyt");

    model.component("comp1").view("view1").axis().set("xmin", 0.0047499993816018105);
    model.component("comp1").view("view1").axis().set("xmax", 0.010249999351799488);
    model.view("view2").axis().set("xmin", -4.483293741941452E-5);
    model.view("view2").axis().set("xmax", 0.010238165967166424);
    model.view("view2").axis().set("ymin", -3504.72412109375);
    model.view("view2").axis().set("ymax", 13277.095703125);
    model.view("view2").axis().set("viewscaletype", "automatic");
    model.view("view3").axis().set("xmin", -0.0047769262455403805);
    model.view("view3").axis().set("xmax", 0.014976922422647476);
    model.view("view3").axis().set("ymin", -205790.671875);
    model.view("view3").axis().set("ymax", 1208480.75);
    model.view("view3").axis().set("viewscaletype", "automatic");

    model.component("comp1").cpl("intop1").label("AvgAll");
    model.component("comp1").cpl("intop2").label("PointCav");
    model.component("comp1").cpl("intop3").label("PointSkin");
    model.component("comp1").cpl("intop4").label("PointInter");
    model.component("comp1").cpl("intop5").label("AvgCore");
    model.component("comp1").cpl("intop6").label("AvgSkin");

    model.common("cminpt").label("Common model inputs 1");

    model.component("comp1").physics("w").label("Weak Form Force");

    return model;
  }

  public static Model run2(Model model) {
    model.component("comp1").physics("w").prop("Units").set("CustomSourceTermUnit", "N/m^3");
    model.component("comp1").physics("w").feature("wfeq1").set("weak", "(-test(ux)*Srr-2/x*Sqq*test(u))*4*pi*x^2");
    model.component("comp1").physics("w").feature("dcont1").set("pairDisconnect", true);
    model.component("comp1").physics("w").feature("dcont1").label("Continuity");
    model.component("comp1").physics("w").feature("flux1").set("g", "p_IN*Lambda_q^2*4*pi*x^2");
    model.component("comp1").physics("w").feature("flux1").active(false);
    model.component("comp1").physics("w").feature("flux2").set("g", "-p_OUT*Lambda_q^2*4*pi*x^2");
    model.component("comp1").physics("w").feature("flux2").active(false);
    model.component("comp1").physics("w").feature("weak1")
         .set("weakExpression", "(p_IN*Lambda_q^2*test(u))*4*pi*x^2");
    model.component("comp1").physics("w").feature("weak1").label("Weak Contribution In NEW");
    model.component("comp1").physics("w").feature("weak2")
         .set("weakExpression", "(-p_OUT*Lambda_q^2*test(u))*4*pi*x^2");
    model.component("comp1").physics("w").feature("weak2").label("Weak Contribution Out NEW");
    model.component("comp1").physics("w2").label("Weak Form Pressure");
    model.component("comp1").physics("w2").prop("ShapeProperty").set("shapeFunctionType", "shdisc");
    model.component("comp1").physics("w2").prop("ShapeProperty").set("order", 1);
    model.component("comp1").physics("w2").feature("wfeq1").set("weak", "(Jd-Jhat)*4*pi*x^2*test(p)");
    model.component("comp1").physics("w2").feature("init1").set("p", "po");
    model.component("comp1").physics("w2").feature("dcont1").set("pairDisconnect", true);
    model.component("comp1").physics("w2").feature("dcont1").label("Continuity");
    model.component("comp1").physics("w4").label("Weak Form Cd Core");
    model.component("comp1").physics("w4").prop("ShapeProperty").set("order", 1);
    model.component("comp1").physics("w4").prop("Units").set("CustomSourceTermUnit", "mol/m^3/s");
    model.component("comp1").physics("w4").feature("wfeq1")
         .set("weak", "(cct*test(cc)-flux_muw_r*test(ccx))*4*pi*x^2");
    model.component("comp1").physics("w4").feature("init1").set("cc", "cc0");
    model.component("comp1").physics("w4").feature("dir1").set("r", "phi_w_ext");
    model.component("comp1").physics("w4").feature("dir1").active(false);
    model.component("comp1").physics("w4").feature("flux1").set("g", "J_evap");
    model.component("comp1").physics("w4").feature("flux1").active(false);
    model.component("comp1").physics("w4").feature("flux2").set("g", "J_cav");
    model.component("comp1").physics("w4").feature("flux2").active(false);
    model.component("comp1").physics("w4").feature("weak1").set("weakExpression", "J_cav*test(cc)*4*pi*x^2");
    model.component("comp1").physics("w4").feature("weak1").label("Weak Contribution J_cav");
    model.component("comp1").physics("w4").feature("weak2")
         .set("weakExpression", "-(Pi_mix_c-Pi_mix_s)*Dmu*test(cc)*4*pi*x^2");
    model.component("comp1").physics("w4").feature("weak2").label("Weak Contribution Eq_Pi_mix");
    model.component("comp1").physics("w4").feature("ge1").set("name", "NVAP");
    model.component("comp1").physics("w4").feature("ge1").set("equation", "d(NVAP,t) - J_CAV");
    model.component("comp1").physics("w4").feature("ge1").set("initialValueU", "N_vap0");
    model.component("comp1").physics("w4").feature("ge1").set("SourceTermQuantity", "none");
    model.component("comp1").physics("w4").feature("ge1").set("CustomSourceTermUnit", "mol/s");
    model.component("comp1").physics("w3").label("Weak From Energy Blance");
    model.component("comp1").physics("w3").prop("Units").set("CustomSourceTermUnit", "J/m^3/s");
    model.component("comp1").physics("w3").feature("wfeq1")
         .set("weak", "(test(Tp)*Tpt*C_eff*Jd-test(Tpx)*Qr)*4*pi*x^2");
    model.component("comp1").physics("w3").feature("init1").set("Tp", "T_init");
    model.component("comp1").physics("w3").feature("flux1")
         .set("g", "Lambda_q^2*(h_air*(Tp-T_ext)+J_evap*Omega*dH_evap)");
    model.component("comp1").physics("w3").feature("flux2").set("g", "Lambda_q^2*J_cav*dH_evap");
    model.component("comp1").physics("w3").feature("flux2").active(false);
    model.component("comp1").physics("w5").label("Weak Form Cd Skin");
    model.component("comp1").physics("w5").prop("ShapeProperty").set("order", 1);
    model.component("comp1").physics("w5").prop("EquationForm").set("form", "Automatic");
    model.component("comp1").physics("w5").prop("Units").set("CustomSourceTermUnit", "mol/m^3/s");
    model.component("comp1").physics("w5").feature("wfeq1")
         .set("weak", "(cst*test(cs)-flux_muw_r*test(csx))*4*pi*x^2");
    model.component("comp1").physics("w5").feature("init1").set("cs", "cs0");
    model.component("comp1").physics("w5").feature("weak1").set("weakExpression", "J_evap*test(cs)*4*pi*x^2");
    model.component("comp1").physics("w5").feature("weak1").label("Weak Contribution J_evap");
    model.component("comp1").physics("w5").feature("weak2")
         .set("weakExpression", "+(Pi_mix_c-Pi_mix_s)*Dmu*test(cs)*4*pi*x^2");
    model.component("comp1").physics("w5").feature("weak2").label("Weak Contribution Eq_Pi_Mix");
    model.component("comp1").physics("dode").label("Relaxation Core");
    model.component("comp1").physics("dode").prop("EquationForm").set("form", "Automatic");
    model.component("comp1").physics("dode").feature("dode1").set("f", "-(A-1/Lambda_q^2)/tau_core");
    model.component("comp1").physics("dode").feature("init1").set("A", 1);
    model.component("comp1").physics("dode2").label("Relaxation Skin");
    model.component("comp1").physics("dode2").prop("EquationForm").set("form", "Automatic");
    model.component("comp1").physics("dode2").feature("dode1").set("f", "-(A-1/Lambda_q^2)/tau_skin");
    model.component("comp1").physics("dode2").feature("init1").set("A", 1);

    model.component("comp1").probe("var1").label("Pgas probe");
    model.component("comp1").probe("var1").set("probename", "p_gas_probe");
    model.component("comp1").probe("var1").set("expr", "p_gas/patm");
    model.component("comp1").probe("var1").set("descr", "p_gas/patm");
    model.component("comp1").probe("var1").set("table", "tbl2");
    model.component("comp1").probe("var1").set("window", "window1");
    model.component("comp1").probe("var2").label("p_vap");
    model.component("comp1").probe("var2").set("probename", "tp_core");
    model.component("comp1").probe("var2").set("expr", "p_vap/patm");
    model.component("comp1").probe("var2").set("descr", "p_vap/patm");
    model.component("comp1").probe("var2").set("table", "tbl2");
    model.component("comp1").probe("var2").set("window", "window1");
    model.component("comp1").probe("var3").label("p_air");
    model.component("comp1").probe("var3").set("probename", "tp_phi_skin");
    model.component("comp1").probe("var3").set("expr", "p_air/patm");
    model.component("comp1").probe("var3").set("descr", "p_air/patm");
    model.component("comp1").probe("var3").set("table", "tbl2");
    model.component("comp1").probe("var3").set("window", "window1");
    model.component("comp1").probe("var4").label("panalyt_probe");
    model.component("comp1").probe("var4").set("probename", "p_ana_probe");
    model.component("comp1").probe("var4").set("expr", "-dp_all/patm");
    model.component("comp1").probe("var4").set("descr", "-dp_all/patm");
    model.component("comp1").probe("var4").set("table", "tbl2");
    model.component("comp1").probe("var4").set("window", "window1");
    model.component("comp1").probe("var5").label("Lambda_b");
    model.component("comp1").probe("var5").set("probename", "Lb");
    model.component("comp1").probe("var5").set("expr", "intop3(Lambda_q)");
    model.component("comp1").probe("var5").set("descr", "PointSkin");
    model.component("comp1").probe("var5").set("table", "tbl2");
    model.component("comp1").probe("var5").set("window", "window1");
    model.component("comp1").probe("var6").label("Lambda_br");
    model.component("comp1").probe("var6").set("probename", "Lbr");
    model.component("comp1").probe("var6").set("expr", "intop3(Lambda_r)");
    model.component("comp1").probe("var6").set("descr", "PointSkin");
    model.component("comp1").probe("var6").set("table", "tbl2");
    model.component("comp1").probe("var6").set("window", "window1");
    model.component("comp1").probe("var7").label("Lambda_a");
    model.component("comp1").probe("var7").set("probename", "La");
    model.component("comp1").probe("var7").set("expr", "intop2(Lambda_q)");
    model.component("comp1").probe("var7").set("descr", "PointCav");
    model.component("comp1").probe("var7").set("table", "tbl2");
    model.component("comp1").probe("var7").set("window", "window1");
    model.component("comp1").probe("var8").label("Lambda_m");
    model.component("comp1").probe("var8").set("probename", "Lm");
    model.component("comp1").probe("var8").set("expr", "intop4(Lambda_q)");
    model.component("comp1").probe("var8").set("descr", "PointInter");
    model.component("comp1").probe("var8").set("table", "tbl2");
    model.component("comp1").probe("var8").set("window", "window1");
    model.component("comp1").probe("var9").label("pdp_skin");
    model.component("comp1").probe("var9").set("probename", "pdp_skin");
    model.component("comp1").probe("var9").set("expr", "(-intop4(Srr)/patm)");
    model.component("comp1").probe("var9").set("descr", "(-intop4(Srr)/patm)");
    model.component("comp1").probe("var9").set("table", "tbl2");
    model.component("comp1").probe("var9").set("window", "window1");

    model.study().create("std2");
    model.study("std2").create("param", "Parametric");
    model.study("std2").create("time", "Transient");

    model.sol().create("sol1");
    model.sol("sol1").study("std2");
    model.sol("sol1").attach("std2");
    model.sol("sol1").create("st1", "StudyStep");
    model.sol("sol1").create("v1", "Variables");
    model.sol("sol1").create("t1", "Time");
    model.sol("sol1").feature("t1").create("fc1", "FullyCoupled");
    model.sol("sol1").feature("t1").feature().remove("fcDef");
    model.sol().create("sol2");
    model.sol("sol2").study("std2");
    model.sol("sol2").label("Parametric Solutions 1");

    model.batch().create("p1", "Parametric");
    model.batch().create("p2", "Parametric");
    model.batch("p1").create("so1", "Solutionseq");
    model.batch("p2").create("so1", "Solutionseq");
    model.batch("p1").study("std2");
    model.batch("p2").study("std2");

    model.result().dataset().create("dset3", "Solution");
    model.result().dataset().create("dset4", "Solution");
    model.result().dataset().create("dset5", "Solution");
    model.result().dataset().create("dset6", "Solution");
    model.result().dataset("dset4").set("solution", "none");
    model.result().dataset("dset5").set("solution", "sol2");
    model.result().dataset("dset6").set("probetag", "var9");
    model.result().dataset().remove("dset1");
    model.result().dataset().remove("dset2");
    model.result().numerical().create("av1", "AvVolume");
    model.result().numerical().create("gev1", "EvalGlobal");
    model.result().numerical().create("gev2", "EvalGlobal");
    model.result().numerical().create("gev3", "EvalGlobal");
    model.result().numerical().create("gev4", "EvalGlobal");
    model.result().numerical().create("gev5", "EvalGlobal");
    model.result().numerical().create("gev6", "EvalGlobal");
    model.result().numerical().create("gev7", "EvalGlobal");
    model.result().numerical().create("gev8", "EvalGlobal");
    model.result().numerical().create("gev9", "EvalGlobal");
    model.result().numerical("av1").set("probetag", "none");
    model.result().numerical("gev1").set("data", "dset6");
    model.result().numerical("gev1").set("probetag", "var1");
    model.result().numerical("gev2").set("data", "dset6");
    model.result().numerical("gev2").set("probetag", "var2");
    model.result().numerical("gev3").set("data", "dset6");
    model.result().numerical("gev3").set("probetag", "var3");
    model.result().numerical("gev4").set("data", "dset6");
    model.result().numerical("gev4").set("probetag", "var4");
    model.result().numerical("gev5").set("data", "dset6");
    model.result().numerical("gev5").set("probetag", "var5");
    model.result().numerical("gev6").set("data", "dset6");
    model.result().numerical("gev6").set("probetag", "var6");
    model.result().numerical("gev7").set("data", "dset6");
    model.result().numerical("gev7").set("probetag", "var7");
    model.result().numerical("gev8").set("data", "dset6");
    model.result().numerical("gev8").set("probetag", "var8");
    model.result().numerical("gev9").set("data", "dset6");
    model.result().numerical("gev9").set("probetag", "var9");
    model.result().create("pg33", "PlotGroup1D");
    model.result().create("pg29", "PlotGroup1D");
    model.result().create("pg45", "PlotGroup1D");
    model.result().create("pg31", "PlotGroup1D");
    model.result().create("pg27", "PlotGroup1D");
    model.result().create("pg28", "PlotGroup1D");
    model.result().create("pg30", "PlotGroup1D");
    model.result().create("pg19", "PlotGroup1D");
    model.result().create("pg16", "PlotGroup1D");
    model.result().create("pg17", "PlotGroup1D");
    model.result().create("pg18", "PlotGroup1D");
    model.result().create("pg20", "PlotGroup1D");
    model.result().create("pg15", "PlotGroup1D");
    model.result().create("pg23", "PlotGroup1D");
    model.result().create("pg32", "PlotGroup1D");
    model.result().create("pg35", "PlotGroup1D");
    model.result().create("pg36", "PlotGroup1D");
    model.result().create("pg37", "PlotGroup1D");
    model.result().create("pg38", "PlotGroup1D");
    model.result().create("pg39", "PlotGroup1D");
    model.result().create("pg40", "PlotGroup1D");
    model.result().create("pg41", "PlotGroup1D");
    model.result().create("pg42", "PlotGroup1D");
    model.result().create("pg43", "PlotGroup1D");
    model.result().create("pg44", "PlotGroup1D");
    model.result("pg33").set("data", "dset5");
    model.result("pg33").create("lngr1", "LineGraph");
    model.result("pg33").create("lngr2", "LineGraph");
    model.result("pg33").feature("lngr1").set("xdata", "expr");
    model.result("pg33").feature("lngr1").selection().set(1);
    model.result("pg33").feature("lngr1").set("expr", "R_cav/Rd");
    model.result("pg33").feature("lngr2").set("xdata", "expr");
    model.result("pg33").feature("lngr2").selection().set(1);
    model.result("pg33").feature("lngr2").set("expr", "intop3(Lambda_q)");
    model.result("pg29").set("data", "dset5");
    model.result("pg29").create("lngr1", "LineGraph");
    model.result("pg29").feature("lngr1").set("xdata", "expr");
    model.result("pg29").feature("lngr1").selection().set(1, 2);
    model.result("pg29").feature("lngr1").set("expr", "Tp");
    model.result("pg45").set("data", "dset5");
    model.result("pg45").create("lngr1", "LineGraph");
    model.result("pg45").feature("lngr1").set("xdata", "expr");
    model.result("pg45").feature("lngr1").selection().set(1, 2);
    model.result("pg45").feature("lngr1").set("expr", "phi_s");
    model.result("pg31").create("lngr1", "LineGraph");
    model.result("pg31").feature("lngr1").set("xdata", "expr");
    model.result("pg31").feature("lngr1").selection().set(1);
    model.result("pg31").feature("lngr1").set("expr", "intop3(Tp)");
    model.result("pg27").set("data", "dset5");
    model.result("pg27").create("lngr1", "LineGraph");
    model.result("pg27").create("lngr2", "LineGraph");
    model.result("pg27").feature("lngr1").set("xdata", "expr");
    model.result("pg27").feature("lngr1").selection().set(1);
    model.result("pg27").feature("lngr1").set("expr", "p_vap");
    model.result("pg27").feature("lngr2").set("xdata", "expr");
    model.result("pg27").feature("lngr2").selection().set(1);
    model.result("pg27").feature("lngr2").set("expr", "p_air");
    model.result("pg28").set("data", "dset5");
    model.result("pg28").create("lngr1", "LineGraph");
    model.result("pg28").create("lngr2", "LineGraph");
    model.result("pg28").create("lngr3", "LineGraph");
    model.result("pg28").create("lngr4", "LineGraph");
    model.result("pg28").create("lngr5", "LineGraph");
    model.result("pg28").feature("lngr1").set("data", "dset5");
    model.result("pg28").feature("lngr1").set("xdata", "expr");
    model.result("pg28").feature("lngr1").selection().set(1);
    model.result("pg28").feature("lngr1").set("expr", "p_gas");
    model.result("pg28").feature("lngr2").set("data", "dset5");
    model.result("pg28").feature("lngr2").set("xdata", "expr");
    model.result("pg28").feature("lngr2").selection().set(1);
    model.result("pg28").feature("lngr2").set("expr", "patm-dp_all");
    model.result("pg28").feature("lngr3").set("data", "dset5");
    model.result("pg28").feature("lngr3").set("xdata", "expr");
    model.result("pg28").feature("lngr3").selection().set(1);
    model.result("pg28").feature("lngr3").set("expr", "p_vap");
    model.result("pg28").feature("lngr4").set("data", "dset5");
    model.result("pg28").feature("lngr4").set("xdata", "expr");
    model.result("pg28").feature("lngr4").selection().set(1);
    model.result("pg28").feature("lngr4").set("expr", "p_sat(Tp)*intop2(a_w_int)");
    model.result("pg28").feature("lngr5").set("data", "dset5");
    model.result("pg28").feature("lngr5").set("xdata", "expr");
    model.result("pg28").feature("lngr5").selection().set(1);
    model.result("pg28").feature("lngr5").set("expr", "p_air");
    model.result("pg30").create("lngr1", "LineGraph");
    model.result("pg30").feature("lngr1").set("xdata", "expr");
    model.result("pg30").feature("lngr1").selection().set(1);
    model.result("pg30").feature("lngr1").set("expr", "T_gas");
    model.result("pg19").set("data", "dset5");
    model.result("pg19").create("lngr1", "LineGraph");
    model.result("pg19").create("lngr2", "LineGraph");
    model.result("pg19").create("lngr3", "LineGraph");
    model.result("pg19").feature("lngr1").set("xdata", "expr");
    model.result("pg19").feature("lngr1").selection().set(1, 2);
    model.result("pg19").feature("lngr1").set("expr", "Jd");
    model.result("pg19").feature("lngr2").set("xdata", "expr");
    model.result("pg19").feature("lngr2").selection().set(1, 2);
    model.result("pg19").feature("lngr2").set("expr", "Jhat");
    model.result("pg19").feature("lngr3").set("xdata", "expr");
    model.result("pg19").feature("lngr3").selection().set(1, 2);
    model.result("pg19").feature("lngr3").set("expr", "phi_s0/phi_s");
    model.result("pg16").set("data", "dset5");
    model.result("pg16").create("lngr1", "LineGraph");
    model.result("pg16").feature("lngr1").set("xdata", "expr");
    model.result("pg16").feature("lngr1").selection().all();
    model.result("pg16").feature("lngr1").set("expr", "Lambda_r");
    model.result("pg17").set("data", "dset4");
    model.result("pg17").create("glob1", "Global");
    model.result("pg18").set("data", "dset5");
    model.result("pg18").create("lngr1", "LineGraph");
    model.result("pg18").feature("lngr1").set("xdata", "expr");
    model.result("pg18").feature("lngr1").selection().set(1, 2);
    model.result("pg18").feature("lngr1").set("expr", "Srr");
    model.result("pg20").create("glob1", "Global");
    model.result("pg15").set("data", "dset5");
    model.result("pg15").create("lngr1", "LineGraph");
    model.result("pg15").create("lngr2", "LineGraph");
    model.result("pg15").create("lngr3", "LineGraph");
    model.result("pg15").create("lngr4", "LineGraph");
    model.result("pg15").feature("lngr1").set("xdata", "expr");
    model.result("pg15").feature("lngr1").selection().set(1, 2);
    model.result("pg15").feature("lngr1").set("expr", "p");
    model.result("pg15").feature("lngr2").set("xdata", "expr");
    model.result("pg15").feature("lngr2").selection().set(1, 2);
    model.result("pg15").feature("lngr2").set("expr", "ps");
    model.result("pg15").feature("lngr3").set("xdata", "expr");
    model.result("pg15").feature("lngr3").selection().set(1, 2);
    model.result("pg15").feature("lngr3").set("expr", "po");
    model.result("pg15").feature("lngr4").set("xdata", "expr");
    model.result("pg15").feature("lngr4").selection().set(1, 2);
    model.result("pg15").feature("lngr4").set("expr", "pmu");
    model.result("pg23").set("data", "dset5");
    model.result("pg23").create("glob1", "Global");
    model.result("pg32").create("lngr1", "LineGraph");
    model.result("pg32").feature("lngr1").set("xdata", "expr");
    model.result("pg32").feature("lngr1").selection().set(1);
    model.result("pg32").feature("lngr1").set("expr", "intop3(J_evap)");
    model.result("pg35").create("lngr1", "LineGraph");
    model.result("pg35").feature("lngr1").set("data", "dset3");
    model.result("pg35").feature("lngr1").set("xdata", "expr");
    model.result("pg35").feature("lngr1").selection().all();
    model.result("pg35").feature("lngr1").set("expr", "phi_s");
    model.result("pg36").create("lngr1", "LineGraph");
    model.result("pg36").feature("lngr1").set("xdata", "expr");
    model.result("pg36").feature("lngr1").selection().all();
    model.result("pg36").feature("lngr1").set("expr", "flux_muw_r");
    model.result("pg37").create("lngr1", "LineGraph");
    model.result("pg37").feature("lngr1").set("xdata", "expr");
    model.result("pg37").feature("lngr1").selection().all();
    model.result("pg37").feature("lngr1").set("expr", "Qr");
    model.result("pg38").create("lngr1", "LineGraph");
    model.result("pg38").create("lngr2", "LineGraph");
    model.result("pg38").create("lngr3", "LineGraph");
    model.result("pg38").feature("lngr1").set("xdata", "expr");
    model.result("pg38").feature("lngr1").selection().set(1);
    model.result("pg38").feature("lngr1").set("expr", "phi_s_skin/phi_skin");
    model.result("pg38").feature("lngr2").set("data", "dset3");
    model.result("pg38").feature("lngr2").set("xdata", "expr");
    model.result("pg38").feature("lngr2").selection().set(1);
    model.result("pg38").feature("lngr2").set("expr", "phi_s_core/phi_ref");
    model.result("pg38").feature("lngr3").set("data", "dset3");
    model.result("pg38").feature("lngr3").set("xdata", "expr");
    model.result("pg38").feature("lngr3").selection().set(1);
    model.result("pg38").feature("lngr3").set("expr", "phi_skin_est");
    model.result("pg39").create("lngr1", "LineGraph");
    model.result("pg39").create("lngr2", "LineGraph");
    model.result("pg39").feature("lngr1").set("data", "dset3");
    model.result("pg39").feature("lngr1").set("xdata", "expr");
    model.result("pg39").feature("lngr1").selection().set(1);
    model.result("pg39").feature("lngr1").set("expr", "(-intop4(Srr)-patm)/G_ref");
    model.result("pg39").feature("lngr2").set("data", "dset3");
    model.result("pg39").feature("lngr2").set("xdata", "expr");
    model.result("pg39").feature("lngr2").selection().set(1);
    model.result("pg39").feature("lngr2").set("expr", "-dp_skin");
    model.result("pg40").set("data", "dset5");
    model.result("pg40").create("lngr1", "LineGraph");
    model.result("pg40").create("lngr2", "LineGraph");
    model.result("pg40").create("lngr3", "LineGraph");
    model.result("pg40").feature("lngr1").set("data", "dset3");
    model.result("pg40").feature("lngr1").set("xdata", "expr");
    model.result("pg40").feature("lngr1").selection().set(1);
    model.result("pg40").feature("lngr1").set("expr", "intop5(a_w_int)/intop5(1)");
    model.result("pg40").feature("lngr2").set("data", "dset3");
    model.result("pg40").feature("lngr2").set("xdata", "expr");
    model.result("pg40").feature("lngr2").selection().set(1);
    model.result("pg40").feature("lngr2").set("expr", "intop6(a_w_ext)/intop6(1)");
    model.result("pg40").feature("lngr3").set("data", "dset3");
    model.result("pg40").feature("lngr3").set("xdata", "expr");
    model.result("pg40").feature("lngr3").selection().set(1);
    model.result("pg40").feature("lngr3").set("expr", "RH_ext");
    model.result("pg41").create("lngr1", "LineGraph");
    model.result("pg41").feature("lngr1").set("xdata", "expr");
    model.result("pg41").feature("lngr1").selection().all();
    model.result("pg41").feature("lngr1").set("expr", "Pi_mix");
    model.result("pg42").set("data", "dset5");
    model.result("pg42").create("lngr1", "LineGraph");
    model.result("pg42").feature("lngr1").set("xdata", "expr");
    model.result("pg42").feature("lngr1").selection().all();
    model.result("pg42").feature("lngr1").set("expr", "cd");
    model.result("pg43").set("probetag", "window1_default");
    model.result("pg43").create("tblp1", "Table");
    model.result("pg43").feature("tblp1").set("probetag", "var1,var2,var3,var4,var5,var6,var7,var8,var9");
    model.result("pg44").create("glob1", "Global");
    model.result().export().create("data1", "Data");
    model.result().export().create("data2", "Data");
    model.result().export().create("data3", "Data");
    model.result().export().create("data4", "Data");

    model.component("comp1").probe("var1").genResult(null);
    model.component("comp1").probe("var2").genResult(null);
    model.component("comp1").probe("var3").genResult(null);
    model.component("comp1").probe("var4").genResult(null);
    model.component("comp1").probe("var5").genResult(null);
    model.component("comp1").probe("var6").genResult(null);
    model.component("comp1").probe("var7").genResult(null);
    model.component("comp1").probe("var8").genResult(null);
    model.component("comp1").probe("var9").genResult(null);

    model.study("std2").label("Time Dependent");
    model.study("std2").feature("param").set("sweeptype", "filled");
    model.study("std2").feature("param").set("pname", new String[]{"fac_Rin", "fac_Pi"});
    model.study("std2").feature("param").set("plistarr", new String[]{"0.35", "50, 100, 200, 500, 1000"});
    model.study("std2").feature("param").set("punit", new String[]{"1", "1"});
    model.study("std2").feature("param").set("useaccumtable", true);
    model.study("std2").feature("param").set("accumtable", "evl2");
    model.study("std2").feature("param").set("keeprom", false);
    model.study("std2").feature("time").set("tlist", "0 10^{range(log10(Tf/100000[s]),1/200,log10(Tf/1[s]))} Tf");
    model.study("std2").feature("time").set("usertol", true);
    model.study("std2").feature("time").set("rtol", 0.001);

    model.sol("sol1").attach("std2");
    model.sol("sol1").label("First Contraction");
    model.sol("sol1").feature("st1").label("Compile Equations: Time Dependent");
    model.sol("sol1").feature("v1").label("Dependent Variables 1.1");
    model.sol("sol1").feature("v1").set("resscalemethod", "auto");
    model.sol("sol1").feature("v1")
         .set("clist", new String[]{"0 10^{range(log10(Tf/100000[s]),1/200,log10(Tf/1[s]))} Tf", "0.001[s]"});
    model.sol("sol1").feature("t1").label("Time-Dependent Solver 1.1");
    model.sol("sol1").feature("t1").set("tlist", "0 10^{range(log10(Tf/100000[s]),1/200,log10(Tf/1[s]))} Tf");
    model.sol("sol1").feature("t1").set("rtol", 0.001);
    model.sol("sol1").feature("t1").set("tstepsbdf", "intermediate");
    model.sol("sol1").feature("t1").set("initialstepbdfactive", true);
    model.sol("sol1").feature("t1").feature("dDef").label("Direct 1");
    model.sol("sol1").feature("t1").feature("dDef").set("thresh", 0.1);
    model.sol("sol1").feature("t1").feature("aDef").label("Advanced 1");
    model.sol("sol1").feature("t1").feature("fc1").label("Fully Coupled 1.1");
    model.sol("sol1").feature("t1").feature("fc1").set("dtech", "auto");
    model.sol("sol1").runAll();

    model.batch("p1").set("control", "param");
    model.batch("p1").set("sweeptype", "filled");
    model.batch("p1").set("pname", new String[]{"fac_Rin", "fac_Pi"});
    model.batch("p1").set("plistarr", new String[]{"0.35", "50, 100, 200, 500, 1000"});
    model.batch("p1").set("punit", new String[]{"1", "1"});
    model.batch("p1").set("useaccumtable", true);
    model.batch("p1").set("accumtable", "evl2");
    model.batch("p1").set("err", true);
    model.batch("p1").feature("so1").set("seq", "sol1");
    model.batch("p1").feature("so1").set("param", new String[]{"\"patm\",\"1010000\",\"lamo\",\"1.52698\""});
    model.batch("p1").run();
    model.batch("p2").set("control", "param");
    model.batch("p2").set("sweeptype", "filled");
    model.batch("p2").set("pname", new String[]{"fac_Rin", "fac_Pi"});
    model.batch("p2").set("plistarr", new String[]{"0.35", "50, 100, 200, 500, 1000"});
    model.batch("p2").set("punit", new String[]{"1", "1"});
    model.batch("p2").set("useaccumtable", true);
    model.batch("p2").set("accumtable", "evl2");
    model.batch("p2").set("err", true);
    model.batch("p2").feature("so1").set("seq", "sol1");
    model.batch("p2").feature("so1").set("psol", "sol2");
    model.batch("p2").feature("so1")
         .set("param", new String[]{"\"fac_Rin\",\"0.35\",\"fac_Pi\",\"50\"", "\"fac_Rin\",\"0.35\",\"fac_Pi\",\"100\"", "\"fac_Rin\",\"0.35\",\"fac_Pi\",\"200\"", "\"fac_Rin\",\"0.35\",\"fac_Pi\",\"500\"", "\"fac_Rin\",\"0.35\",\"fac_Pi\",\"1000\""});
    model.batch("p2").attach("std2");
    model.batch("p2").run();

    model.result().dataset("dset6").label("Probe Solution 6");
    model.result().numerical("av1").label("Jd_avg");
    model.result().numerical("av1").set("expr", new String[]{"Jd"});
    model.result().numerical("av1").set("unit", new String[]{""});
    model.result().numerical("av1").set("descr", new String[]{""});
    model.result().numerical("gev1").set("table", "evl2");
    model.result().numerical("gev2").set("table", "evl2");
    model.result().numerical("gev3").set("table", "evl2");
    model.result().numerical("gev4").set("table", "evl2");
    model.result().numerical("gev5").set("table", "evl2");
    model.result().numerical("gev6").set("table", "evl2");
    model.result().numerical("gev7").set("table", "evl2");
    model.result().numerical("gev8").set("table", "evl2");
    model.result().numerical("gev9").set("table", "evl2");
    model.result("pg33").label("R_gas");
    model.result("pg33").set("xlabel", "t (s)");
    model.result("pg33").set("xlabelactive", true);
    model.result("pg33").set("ylabel", "R_cav (m)");
    model.result("pg33").set("ylabelactive", true);
    model.result("pg33").set("xlog", true);
    model.result("pg33").feature("lngr1").set("xdataexpr", "t");
    model.result("pg33").feature("lngr1").set("xdataunit", "s");
    model.result("pg33").feature("lngr1").set("xdatadescr", "Time");
    model.result("pg33").feature("lngr1").set("linecolor", "blue");
    model.result("pg33").feature("lngr1").set("smooth", "internal");
    model.result("pg33").feature("lngr1").set("resolution", "normal");
    model.result("pg33").feature("lngr2").set("xdataexpr", "t");
    model.result("pg33").feature("lngr2").set("xdataunit", "s");
    model.result("pg33").feature("lngr2").set("xdatadescr", "Time");
    model.result("pg33").feature("lngr2").set("linecolor", "red");
    model.result("pg33").feature("lngr2").set("smooth", "internal");
    model.result("pg33").feature("lngr2").set("resolution", "normal");
    model.result("pg29").label("Tp vs R");
    model.result("pg29").set("looplevelinput", new String[]{"interp", "all", "all"});
    model.result("pg29").set("interp", new String[]{"1e3, 1e4, 1e5, 1e6", "", ""});
    model.result("pg29").set("xlabel", "R (m)");
    model.result("pg29").set("xlabelactive", true);

    return model;
  }

  public static Model run3(Model model) {
    model.result("pg29").set("ylabel", "T_p");
    model.result("pg29").set("ylabelactive", true);
    model.result("pg29").set("axislimits", true);
    model.result("pg29").set("xmin", 0);
    model.result("pg29").set("xmax", "Rd");
    model.result("pg29").set("ymin", "T_init");
    model.result("pg29").set("ymax", "T_end+1");
    model.result("pg29").feature("lngr1").label("LineW");
    model.result("pg29").feature("lngr1").set("descractive", true);
    model.result("pg29").feature("lngr1").set("descr", "Product Temperature");
    model.result("pg29").feature("lngr1").set("xdataexpr", "x+u");
    model.result("pg29").feature("lngr1").set("xdatadescr", "x+u");
    model.result("pg29").feature("lngr1").set("resolution", "normal");
    model.result("pg45").label("phi_s  vs R");
    model.result("pg45").set("looplevelinput", new String[]{"interp", "all", "all"});
    model.result("pg45").set("interp", new String[]{"1e3, 1e4, 1e5, 1e6, 1e7, 1e8", "", ""});
    model.result("pg45").set("xlabel", "R (m)");
    model.result("pg45").set("xlabelactive", true);
    model.result("pg45").set("ylabel", "phi_s");
    model.result("pg45").set("ylabelactive", true);
    model.result("pg45").set("axislimits", true);
    model.result("pg45").set("xmin", 0);
    model.result("pg45").set("xmax", "Rd");
    model.result("pg45").set("ymin", 0);
    model.result("pg45").set("ymax", ".2");
    model.result("pg45").feature("lngr1").label("LineW");
    model.result("pg45").feature("lngr1").set("descractive", true);
    model.result("pg45").feature("lngr1").set("descr", "Product Temperature");
    model.result("pg45").feature("lngr1").set("xdataexpr", "x+u");
    model.result("pg45").feature("lngr1").set("xdatadescr", "x+u");
    model.result("pg45").feature("lngr1").set("resolution", "normal");
    model.result("pg31").label("T_p,surface");
    model.result("pg31").set("xlabel", "t (s)");
    model.result("pg31").set("xlabelactive", true);
    model.result("pg31").set("ylabelactive", true);
    model.result("pg31").set("xlog", true);
    model.result("pg31").set("ylog", true);
    model.result("pg31").feature("lngr1").set("descr", "Integration 3");
    model.result("pg31").feature("lngr1").set("xdataexpr", "t");
    model.result("pg31").feature("lngr1").set("xdataunit", "s");
    model.result("pg31").feature("lngr1").set("xdatadescr", "Time");
    model.result("pg31").feature("lngr1").set("resolution", "normal");
    model.result("pg27").label("p_vap");
    model.result("pg27").set("xlabel", "t (s)");
    model.result("pg27").set("xlabelactive", true);
    model.result("pg27").set("ylabel", "p_vap (Pa)");
    model.result("pg27").set("ylabelactive", true);
    model.result("pg27").set("xlog", true);
    model.result("pg27").set("ylog", true);
    model.result("pg27").feature("lngr1").set("xdataexpr", "t");
    model.result("pg27").feature("lngr1").set("xdataunit", "s");
    model.result("pg27").feature("lngr1").set("xdatadescr", "Time");
    model.result("pg27").feature("lngr1").set("smooth", "internal");
    model.result("pg27").feature("lngr1").set("resolution", "normal");
    model.result("pg27").feature("lngr2").set("xdataexpr", "t");
    model.result("pg27").feature("lngr2").set("xdataunit", "s");
    model.result("pg27").feature("lngr2").set("xdatadescr", "Time");
    model.result("pg27").feature("lngr2").set("smooth", "internal");
    model.result("pg27").feature("lngr2").set("resolution", "normal");
    model.result("pg28").label("p_gas");
    model.result("pg28").set("xlabel", "t (s)");
    model.result("pg28").set("xlabelactive", true);
    model.result("pg28").set("ylabel", "p_gas (Pa)");
    model.result("pg28").set("ylabelactive", true);
    model.result("pg28").set("xlog", true);
    model.result("pg28").set("ylog", true);
    model.result("pg28").feature("lngr1").set("titletype", "manual");
    model.result("pg28").feature("lngr1").set("xdataexpr", "t");
    model.result("pg28").feature("lngr1").set("xdataunit", "s");
    model.result("pg28").feature("lngr1").set("xdatadescr", "Time");
    model.result("pg28").feature("lngr1").set("linecolor", "red");
    model.result("pg28").feature("lngr1").set("legendmethod", "evaluated");
    model.result("pg28").feature("lngr1").set("smooth", "internal");
    model.result("pg28").feature("lngr1").set("resolution", "normal");
    model.result("pg28").feature("lngr2").active(false);
    model.result("pg28").feature("lngr2").set("titletype", "none");
    model.result("pg28").feature("lngr2").set("xdataexpr", "t");
    model.result("pg28").feature("lngr2").set("xdataunit", "s");
    model.result("pg28").feature("lngr2").set("xdatadescr", "Time");
    model.result("pg28").feature("lngr2").set("linestyle", "dotted");
    model.result("pg28").feature("lngr2").set("linecolor", "blue");
    model.result("pg28").feature("lngr2").set("linemarker", "point");
    model.result("pg28").feature("lngr2").set("markers", "1e4");
    model.result("pg28").feature("lngr2").set("smooth", "internal");
    model.result("pg28").feature("lngr2").set("resolution", "normal");
    model.result("pg28").feature("lngr3").active(false);
    model.result("pg28").feature("lngr3").set("titletype", "manual");
    model.result("pg28").feature("lngr3").set("xdataexpr", "t");
    model.result("pg28").feature("lngr3").set("xdataunit", "s");
    model.result("pg28").feature("lngr3").set("xdatadescr", "Time");
    model.result("pg28").feature("lngr3").set("linestyle", "dashed");
    model.result("pg28").feature("lngr3").set("linecolor", "gray");
    model.result("pg28").feature("lngr3").set("legendmethod", "evaluated");
    model.result("pg28").feature("lngr3").set("smooth", "internal");
    model.result("pg28").feature("lngr3").set("resolution", "normal");
    model.result("pg28").feature("lngr4").active(false);
    model.result("pg28").feature("lngr4").set("unit", "J/m^3");
    model.result("pg28").feature("lngr4").set("titletype", "manual");
    model.result("pg28").feature("lngr4").set("xdataexpr", "t");
    model.result("pg28").feature("lngr4").set("xdataunit", "s");
    model.result("pg28").feature("lngr4").set("xdatadescr", "Time");
    model.result("pg28").feature("lngr4").set("linecolor", "blue");
    model.result("pg28").feature("lngr4").set("legendmethod", "evaluated");
    model.result("pg28").feature("lngr4").set("smooth", "internal");
    model.result("pg28").feature("lngr4").set("resolution", "normal");
    model.result("pg28").feature("lngr5").active(false);
    model.result("pg28").feature("lngr5").set("titletype", "manual");
    model.result("pg28").feature("lngr5").set("xdataexpr", "t");
    model.result("pg28").feature("lngr5").set("xdataunit", "s");
    model.result("pg28").feature("lngr5").set("xdatadescr", "Time");
    model.result("pg28").feature("lngr5").set("linestyle", "dashed");
    model.result("pg28").feature("lngr5").set("linecolor", "black");
    model.result("pg28").feature("lngr5").set("legendmethod", "evaluated");
    model.result("pg28").feature("lngr5").set("smooth", "internal");
    model.result("pg28").feature("lngr5").set("resolution", "normal");
    model.result("pg30").label("T_gas");
    model.result("pg30").set("xlabel", "t (s)");
    model.result("pg30").set("xlabelactive", true);
    model.result("pg30").set("ylabel", "T_gas (K)");
    model.result("pg30").set("ylabelactive", true);
    model.result("pg30").set("xlog", true);
    model.result("pg30").set("ylog", true);
    model.result("pg30").feature("lngr1").set("descr", "T_gas");
    model.result("pg30").feature("lngr1").set("xdataexpr", "t");
    model.result("pg30").feature("lngr1").set("xdataunit", "s");
    model.result("pg30").feature("lngr1").set("xdatadescr", "Time");
    model.result("pg30").feature("lngr1").set("resolution", "normal");
    model.result("pg19").label("Jd vs R");
    model.result("pg19").set("looplevelinput", new String[]{"interp", "all", "all"});
    model.result("pg19").set("interp", new String[]{"1e2, 1e4, 1e6, 1e8", "", ""});
    model.result("pg19").set("xlabel", "R (m)");
    model.result("pg19").set("xlabelactive", true);
    model.result("pg19").set("ylabel", "Jd");
    model.result("pg19").set("ylabelactive", true);
    model.result("pg19").feature("lngr1").set("xdataexpr", "x+u");
    model.result("pg19").feature("lngr1").set("xdatadescr", "x+u");
    model.result("pg19").feature("lngr1").set("linecolor", "red");
    model.result("pg19").feature("lngr1").set("resolution", "normal");
    model.result("pg19").feature("lngr2").active(false);
    model.result("pg19").feature("lngr2").set("xdataexpr", "x+u");
    model.result("pg19").feature("lngr2").set("xdatadescr", "x+u");
    model.result("pg19").feature("lngr2").set("linestyle", "dashed");
    model.result("pg19").feature("lngr2").set("linecolor", "green");
    model.result("pg19").feature("lngr2").set("resolution", "normal");
    model.result("pg19").feature("lngr3").active(false);
    model.result("pg19").feature("lngr3").set("xdataexpr", "x+u");
    model.result("pg19").feature("lngr3").set("xdatadescr", "x+u");
    model.result("pg19").feature("lngr3").set("linestyle", "dotted");
    model.result("pg19").feature("lngr3").set("linecolor", "blue");
    model.result("pg19").feature("lngr3").set("resolution", "normal");
    model.result("pg16").label("lambdar vs R");
    model.result("pg16").set("xlabel", "R (m)");
    model.result("pg16").set("xlabelactive", true);
    model.result("pg16").set("ylabel", "\\lambda r");
    model.result("pg16").set("ylabelactive", true);
    model.result("pg16").feature("lngr1").set("xdataexpr", "x");
    model.result("pg16").feature("lngr1").set("xdatadescr", "x-coordinate");
    model.result("pg16").feature("lngr1").set("smooth", "internal");
    model.result("pg16").feature("lngr1").set("resolution", "normal");
    model.result("pg17").label("Vc/Vco vs Time");
    model.result("pg17").set("ylabel", "V_cav/V_cav_0");
    model.result("pg17").set("ylabelactive", true);
    model.result("pg17").set("xlog", true);
    model.result("pg17").set("showlegends", false);
    model.result("pg17").feature("glob1").set("expr", new String[]{"Vc/Vco"});
    model.result("pg17").feature("glob1").set("unit", new String[]{"1"});
    model.result("pg17").feature("glob1").set("descr", new String[]{""});
    model.result("pg18").label("Sr vs R");
    model.result("pg18").set("xlabel", "R (m)");
    model.result("pg18").set("xlabelactive", true);
    model.result("pg18").set("ylabel", "Srr (Pa)");
    model.result("pg18").set("ylabelactive", true);
    model.result("pg18").feature("lngr1").set("descractive", true);
    model.result("pg18").feature("lngr1").set("descr", "Radial Cauchy stress");
    model.result("pg18").feature("lngr1").set("xdataexpr", "u+x");
    model.result("pg18").feature("lngr1").set("xdatadescr", "u+x");
    model.result("pg18").feature("lngr1").set("smooth", "internal");
    model.result("pg18").feature("lngr1").set("resolution", "normal");
    model.result("pg20").label("average Jd vs Time");
    model.result("pg20").set("xlabel", "Time (s)");
    model.result("pg20").set("xlog", true);
    model.result("pg20").set("ylog", true);
    model.result("pg20").set("xlabelactive", false);
    model.result("pg20").feature("glob1").set("expr", new String[]{"intop1(Jd*4*pi*x^2)/intop1(4*pi*x^2)"});
    model.result("pg20").feature("glob1").set("unit", new String[]{"1"});
    model.result("pg20").feature("glob1").set("descr", new String[]{""});
    model.result("pg15").label("p vs R");
    model.result("pg15").set("looplevelinput", new String[]{"interp", "last", "last"});
    model.result("pg15").set("interp", new String[]{"1e2, 1e3, 1e4, 1e5, 1e6, 1e7, 1e8", "", ""});
    model.result("pg15").set("xlabel", "R (m)");
    model.result("pg15").set("xlabelactive", true);
    model.result("pg15").set("ylabel", "p (Pa)");
    model.result("pg15").set("ylabelactive", true);
    model.result("pg15").feature("lngr1").set("xdataexpr", "x+u");
    model.result("pg15").feature("lngr1").set("xdatadescr", "x+u");
    model.result("pg15").feature("lngr1").set("linecolor", "red");
    model.result("pg15").feature("lngr1").set("smooth", "internal");
    model.result("pg15").feature("lngr1").set("resolution", "normal");
    model.result("pg15").feature("lngr2").set("unit", "J/m^3");
    model.result("pg15").feature("lngr2").set("descr", "ps");
    model.result("pg15").feature("lngr2").set("xdataexpr", "x+u");
    model.result("pg15").feature("lngr2").set("xdatadescr", "x+u");
    model.result("pg15").feature("lngr2").set("linestyle", "dashed");
    model.result("pg15").feature("lngr2").set("linecolor", "blue");
    model.result("pg15").feature("lngr2").set("smooth", "internal");
    model.result("pg15").feature("lngr2").set("resolution", "normal");
    model.result("pg15").feature("lngr3").set("unit", "J/m^3");
    model.result("pg15").feature("lngr3").set("xdataexpr", "x+u");
    model.result("pg15").feature("lngr3").set("xdatadescr", "x+u");
    model.result("pg15").feature("lngr3").set("linestyle", "dotted");
    model.result("pg15").feature("lngr3").set("linecolor", "black");
    model.result("pg15").feature("lngr3").set("smooth", "internal");
    model.result("pg15").feature("lngr3").set("resolution", "normal");
    model.result("pg15").feature("lngr4").set("unit", "J/m^3");
    model.result("pg15").feature("lngr4").set("xdataexpr", "x+u");
    model.result("pg15").feature("lngr4").set("xdatadescr", "x+u");
    model.result("pg15").feature("lngr4").set("linestyle", "dotted");
    model.result("pg15").feature("lngr4").set("linecolor", "cyan");
    model.result("pg15").feature("lngr4").set("smooth", "internal");
    model.result("pg15").feature("lngr4").set("resolution", "normal");
    model.result("pg23").label("Pressure versus time");
    model.result("pg23").set("xlabel", "Solution number");
    model.result("pg23").set("xlabelactive", false);
    model.result("pg23").feature("glob1").set("expr", new String[]{"pI", "-pO"});
    model.result("pg23").feature("glob1").set("unit", new String[]{"Pa", "Pa"});
    model.result("pg23").feature("glob1").set("descr", new String[]{"Inner pressure", "Outer pressure"});
    model.result("pg23").feature("glob1").set("xdatasolnumtype", "all");
    model.result("pg32").label("J_evap");
    model.result("pg32").set("xlabel", "t (s)");
    model.result("pg32").set("xlabelactive", true);
    model.result("pg32").set("ylabel", "intop3(J_evap)");
    model.result("pg32").set("ylabelactive", true);
    model.result("pg32").set("xlog", true);
    model.result("pg32").set("ylog", true);
    model.result("pg32").feature("lngr1").set("descr", "Integration 3");
    model.result("pg32").feature("lngr1").set("xdataexpr", "t");
    model.result("pg32").feature("lngr1").set("xdataunit", "s");
    model.result("pg32").feature("lngr1").set("xdatadescr", "Time");
    model.result("pg32").feature("lngr1").set("resolution", "normal");
    model.result("pg35").label("phi_s vs R");
    model.result("pg35").set("looplevelinput", new String[]{"interp"});
    model.result("pg35").set("xlabel", "R (m)");
    model.result("pg35").set("xlabelactive", true);
    model.result("pg35").set("ylabel", "phi_s");
    model.result("pg35").set("ylabelactive", true);
    model.result("pg35").set("axislimits", true);
    model.result("pg35").set("xmin", 5.444319460067491E-4);
    model.result("pg35").set("xmax", 0.010455568053993251);
    model.result("pg35").set("ymin", "0.0");
    model.result("pg35").set("ymax", 0.3);
    model.result("pg35").feature("lngr1").set("looplevelinput", new String[]{"interp"});
    model.result("pg35").feature("lngr1").set("xdataexpr", "x+u");
    model.result("pg35").feature("lngr1").set("xdatadescr", "x+u");
    model.result("pg35").feature("lngr1").set("resolution", "normal");
    model.result("pg36").label("Jw vs R ");
    model.result("pg36").set("looplevelinput", new String[]{"manualindices"});
    model.result("pg36")
         .set("looplevelindices", new String[]{"1, 10, 100, 200, 300, 400, 500, 600, 700, 800, 900, 1000"});
    model.result("pg36").set("xlabel", "R (m)");
    model.result("pg36").set("xlabelactive", true);
    model.result("pg36").set("ylabel", "J_w");
    model.result("pg36").set("ylabelactive", true);
    model.result("pg36").feature("lngr1").label("LineW");
    model.result("pg36").feature("lngr1").set("descractive", true);
    model.result("pg36").feature("lngr1").set("descr", "Product Temperature");
    model.result("pg36").feature("lngr1").set("xdataexpr", "x+u");
    model.result("pg36").feature("lngr1").set("xdatadescr", "x+u");
    model.result("pg36").feature("lngr1").set("resolution", "normal");
    model.result("pg37").label("Qr vs R ");
    model.result("pg37").set("looplevelinput", new String[]{"manualindices"});
    model.result("pg37").set("looplevelindices", new String[]{"100, 200, 300, 400, 500, 600, 700, 800, 900, 1000"});
    model.result("pg37").set("xlabel", "R (m)");
    model.result("pg37").set("xlabelactive", true);
    model.result("pg37").set("ylabel", "Q_r");
    model.result("pg37").set("ylabelactive", true);
    model.result("pg37").feature("lngr1").label("LineW");
    model.result("pg37").feature("lngr1").set("descractive", true);
    model.result("pg37").feature("lngr1").set("descr", "Product Temperature");
    model.result("pg37").feature("lngr1").set("xdataexpr", "x+u");
    model.result("pg37").feature("lngr1").set("xdatadescr", "x+u");
    model.result("pg37").feature("lngr1").set("resolution", "normal");
    model.result("pg38").label("phi_s");
    model.result("pg38").set("xlabel", "t (s)");
    model.result("pg38").set("xlabelactive", true);
    model.result("pg38").set("ylabel", "phi_s");
    model.result("pg38").set("ylabelactive", true);
    model.result("pg38").set("xlog", true);
    model.result("pg38").feature("lngr1").set("xdataexpr", "t");
    model.result("pg38").feature("lngr1").set("xdataunit", "s");
    model.result("pg38").feature("lngr1").set("xdatadescr", "Time");
    model.result("pg38").feature("lngr1").set("linecolor", "red");
    model.result("pg38").feature("lngr1").set("smooth", "internal");
    model.result("pg38").feature("lngr1").set("resolution", "normal");
    model.result("pg38").feature("lngr2").set("xdataexpr", "t");
    model.result("pg38").feature("lngr2").set("xdataunit", "s");
    model.result("pg38").feature("lngr2").set("xdatadescr", "Time");
    model.result("pg38").feature("lngr2").set("linecolor", "blue");
    model.result("pg38").feature("lngr2").set("smooth", "internal");
    model.result("pg38").feature("lngr2").set("resolution", "normal");
    model.result("pg38").feature("lngr3").active(false);
    model.result("pg38").feature("lngr3").set("descr", "phi_skin_est");
    model.result("pg38").feature("lngr3").set("xdataexpr", "t");
    model.result("pg38").feature("lngr3").set("xdataunit", "s");
    model.result("pg38").feature("lngr3").set("xdatadescr", "Time");
    model.result("pg38").feature("lngr3").set("linecolor", "gray");
    model.result("pg38").feature("lngr3").set("smooth", "internal");
    model.result("pg38").feature("lngr3").set("resolution", "normal");
    model.result("pg39").label("dSigma");
    model.result("pg39").set("xlabel", "t (s)");
    model.result("pg39").set("xlabelactive", true);
    model.result("pg39").set("ylabel", "p_gas (Pa)");
    model.result("pg39").set("ylabelactive", true);
    model.result("pg39").set("xlog", true);
    model.result("pg39").feature("lngr1").set("titletype", "manual");
    model.result("pg39").feature("lngr1").set("xdataexpr", "t");
    model.result("pg39").feature("lngr1").set("xdataunit", "s");
    model.result("pg39").feature("lngr1").set("xdatadescr", "Time");
    model.result("pg39").feature("lngr1").set("linecolor", "red");
    model.result("pg39").feature("lngr1").set("legendmethod", "evaluated");
    model.result("pg39").feature("lngr1").set("smooth", "internal");
    model.result("pg39").feature("lngr1").set("resolution", "normal");
    model.result("pg39").feature("lngr2").active(false);
    model.result("pg39").feature("lngr2").set("titletype", "none");
    model.result("pg39").feature("lngr2").set("xdataexpr", "t");
    model.result("pg39").feature("lngr2").set("xdataunit", "s");
    model.result("pg39").feature("lngr2").set("xdatadescr", "Time");
    model.result("pg39").feature("lngr2").set("linestyle", "dashed");
    model.result("pg39").feature("lngr2").set("linecolor", "blue");
    model.result("pg39").feature("lngr2").set("linemarker", "circle");
    model.result("pg39").feature("lngr2").set("markers", "1e4");
    model.result("pg39").feature("lngr2").set("smooth", "internal");
    model.result("pg39").feature("lngr2").set("resolution", "normal");
    model.result("pg40").label("aw_avg");
    model.result("pg40").set("xlabel", "t (s)");
    model.result("pg40").set("xlabelactive", true);
    model.result("pg40").set("ylabel", "a_w");
    model.result("pg40").set("ylabelactive", true);
    model.result("pg40").set("xlog", true);
    model.result("pg40").feature("lngr1").set("xdataexpr", "t");
    model.result("pg40").feature("lngr1").set("xdataunit", "s");
    model.result("pg40").feature("lngr1").set("xdatadescr", "Time");
    model.result("pg40").feature("lngr1").set("linecolor", "red");
    model.result("pg40").feature("lngr1").set("smooth", "internal");
    model.result("pg40").feature("lngr1").set("resolution", "normal");
    model.result("pg40").feature("lngr2").set("xdataexpr", "t");
    model.result("pg40").feature("lngr2").set("xdataunit", "s");
    model.result("pg40").feature("lngr2").set("xdatadescr", "Time");
    model.result("pg40").feature("lngr2").set("linecolor", "blue");
    model.result("pg40").feature("lngr2").set("smooth", "internal");
    model.result("pg40").feature("lngr2").set("resolution", "normal");
    model.result("pg40").feature("lngr3").set("xdataexpr", "t");
    model.result("pg40").feature("lngr3").set("xdataunit", "s");
    model.result("pg40").feature("lngr3").set("xdatadescr", "Time");
    model.result("pg40").feature("lngr3").set("linecolor", "gray");
    model.result("pg40").feature("lngr3").set("smooth", "internal");
    model.result("pg40").feature("lngr3").set("resolution", "normal");
    model.result("pg41").label("Pi vs R");
    model.result("pg41").set("looplevelinput", new String[]{"interp"});
    model.result("pg41").set("xlabel", "R (m)");
    model.result("pg41").set("xlabelactive", true);
    model.result("pg41").set("ylabel", "Pi_mix");
    model.result("pg41").set("ylabelactive", true);
    model.result("pg41").feature("lngr1").set("xdataexpr", "x+u");
    model.result("pg41").feature("lngr1").set("xdatadescr", "x+u");
    model.result("pg41").feature("lngr1").set("resolution", "normal");
    model.result("pg42").label("Cd vs R");
    model.result("pg42").set("looplevelinput", new String[]{"interp", "all", "all"});
    model.result("pg42").set("interp", new String[]{"1e2, 1e4, 1e6", "", ""});
    model.result("pg42").set("xlabel", "R (m)");
    model.result("pg42").set("xlabelactive", true);
    model.result("pg42").set("ylabel", "cd");
    model.result("pg42").set("ylabelactive", true);
    model.result("pg42").feature("lngr1").set("descr", "Dependent variable cd");
    model.result("pg42").feature("lngr1").set("xdataexpr", "x+u");
    model.result("pg42").feature("lngr1").set("xdatadescr", "x+u");
    model.result("pg42").feature("lngr1").set("resolution", "normal");
    model.result("pg43").label("Probe Plot Group 43");
    model.result("pg43").set("xlabel", "Time (s)");
    model.result("pg43").set("windowtitle", "Probe Plot 1");
    model.result("pg43").set("xlabelactive", false);
    model.result("pg43").create("tblp1", "Table");
    model.result("pg43").feature("tblp1").label("Probe Table Graph 1");
    model.result("pg43").feature("tblp1").set("table", "tbl2");
    model.result("pg43").feature("tblp1").set("plotcolumninput", "manual");
    model.result("pg43").feature("tblp1").set("legend", true);
    model.result("pg43").feature().remove("tblp2");
    model.result("pg44").label("average Tp vs Time 1");
    model.result("pg44").set("xlabel", "Time (s)");
    model.result("pg44").set("xlog", true);
    model.result("pg44").set("ylog", true);
    model.result("pg44").set("xlabelactive", false);
    model.result("pg44").feature("glob1").set("expr", new String[]{"intop1(Tp*4*pi*x^2)/intop1(4*pi*x^2)"});
    model.result("pg44").feature("glob1").set("unit", new String[]{"K"});
    model.result("pg44").feature("glob1").set("descr", new String[]{""});
    model.result().export("data1").label("FinalSol");
    model.result().export("data1").set("data", "dset5");
    model.result().export("data1").set("looplevelinput", new String[]{"all", "all", "all"});
    model.result().export("data1").set("expr", new String[]{"Lambda_q"});
    model.result().export("data1").set("unit", new String[]{"1"});
    model.result().export("data1").set("descr", new String[]{"Hoop stretch ; Defined from InitDomain"});
    model.result().export("data1").set("filename", "5RinLambdaq.txt");
    model.result().export("data2").label("FinalSol 1");
    model.result().export("data2").set("data", "dset5");
    model.result().export("data2").set("looplevelinput", new String[]{"all", "all", "all"});
    model.result().export("data2").set("expr", new String[]{"Lambda_r"});
    model.result().export("data2").set("unit", new String[]{"1"});
    model.result().export("data2").set("descr", new String[]{"Radial stretch"});
    model.result().export("data2").set("filename", "1RinLambdaR.txt");
    model.result().export("data3").label("FinalSol 1.1");
    model.result().export("data3").set("data", "dset5");
    model.result().export("data3").set("looplevelinput", new String[]{"all", "all", "all"});
    model.result().export("data3").set("expr", new String[]{"-sigma_rr/patm"});
    model.result().export("data3").set("unit", new String[]{"1"});
    model.result().export("data3").set("descr", new String[]{""});
    model.result().export("data3").set("filename", "1RinSrr.txt");
    model.result().export("data4").label("FinalSol 2");
    model.result().export("data4").set("data", "dset5");
    model.result().export("data4").set("looplevelinput", new String[]{"all", "all", "all"});
    model.result().export("data4").set("expr", new String[]{"phi_s", "Lambda_q"});
    model.result().export("data4").set("unit", new String[]{"1", "1"});
    model.result().export("data4").set("descr", new String[]{"", "Hoop stretch ; Defined from InitDomain"});
    model.result().export("data4").set("filename", "1RinPhiS.txt");

    return model;
  }

  public static void main(String[] args) {
    Model model = run();
    model = run2(model);
    run3(model);
  }

}
