(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   2093753,      38029]
NotebookOptionsPosition[   2091907,      37967]
NotebookOutlinePosition[   2092283,      37983]
CellTagsIndexPosition[   2092240,      37980]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "NMER.wl"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.9258733049025664`*^9, 3.9258733259994926`*^9}, {
   3.9258734394779925`*^9, 3.925873447540912*^9}, 3.941099507740823*^9, {
   3.9422086414130416`*^9, 3.942208645255968*^9}, {3.9543908737321277`*^9, 
   3.9543908779065585`*^9}, {3.9543909210028453`*^9, 3.954390921123247*^9}, {
   3.9543913652388415`*^9, 3.954391368906309*^9}, {3.954391839063712*^9, 
   3.954391873355954*^9}, {3.954392231688773*^9, 3.954392252176685*^9}, {
   3.9543923643774567`*^9, 3.954392368036597*^9}, {3.95439399334472*^9, 
   3.9543939965125413`*^9}, {3.954395040281087*^9, 3.9543950637527046`*^9}, {
   3.954395252744151*^9, 3.9543952652240486`*^9}, {3.954395915496191*^9, 
   3.9543959198155804`*^9}, {3.954397091559326*^9, 3.9543970963052936`*^9}, {
   3.9543985589683104`*^9, 3.9543985617452435`*^9}, 3.9543988724913645`*^9, {
   3.954399632109002*^9, 3.954399634441659*^9}, {3.9544003732324505`*^9, 
   3.9544003753590393`*^9}, {3.954400817263729*^9, 3.95440084323335*^9}, {
   3.9544012528068953`*^9, 3.954401257466012*^9}, {3.95440179678384*^9, 
   3.9544017998463564`*^9}, {3.9544021880544243`*^9, 3.954402190950574*^9}, {
   3.954402989139971*^9, 3.954403016877221*^9}, {3.954403337964389*^9, 
   3.9544033380892916`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ProbabilityEllipsoid", "=", 
   RowBox[{"ProbabilityEllipsoidPlot", "[", 
    RowBox[{"\"\<Data//33.gro_lf.dat\>\"", ",", 
     RowBox[{"1000", " ", 
      RowBox[{"828", "/", "0.1"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.954391821212604*^9, 3.9543918270013843`*^9}, {
   3.9543918847636757`*^9, 3.954391896288605*^9}, {3.9543959862916794`*^9, 
   3.9543960091683044`*^9}, 3.954403121672748*^9, {3.954476841988415*^9, 
   3.9544768431485634`*^9}, {3.9586352258821516`*^9, 3.958635226049772*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"rMatrix", ",", "angle", ",", "alphaC", ",", "coords"}], "}"}], 
   "=", 
   RowBox[{
   "FindMolecularFrame", "[", "\"\<Data//TFP_lowest_energy.xyz\>\"", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{
  3.9543922828650055`*^9, {3.954393293645871*^9, 3.954393294925455*^9}, 
   3.954396013062875*^9, {3.9544768515257335`*^9, 3.9544768523266296`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"tfp", "=", 
   RowBox[{"TransformToMolecularFrame", "[", 
    RowBox[{"rMatrix", ",", "alphaC", ",", "coords", ",", "\"\<TFP\>\""}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9543922592181325`*^9, 3.9543922805620966`*^9}, 
   3.9543924148385825`*^9, {3.954393767529536*^9, 3.954393777610882*^9}, 
   3.9543960189595957`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"dipoleFunc", "=", 
   RowBox[{"TransformDipoles", "[", 
    RowBox[{"\"\<Data//me.dat\>\"", ",", "rMatrix"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.9543960255352564`*^9, {3.954476860148988*^9, 3.9544768610922832`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", "\[IndentingNewLine]", 
  RowBox[{"{", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\"\<Antisymmetric Shielding\>\"", ",", 
      "\"\<Antisymmetric Coupling\>\""}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
      "Define", " ", "centers", " ", "and", " ", "rotation", " ", "matrix"}], 
      "*)"}], "\[IndentingNewLine]", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"p1", "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.8559"}], ",", 
          RowBox[{"-", "0.5255"}], ",", 
          RowBox[{"-", "1.3623"}]}], "}"}]}], ";", "\n", "        ", 
       RowBox[{"p2", "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.0085"}], ",", 
          RowBox[{"-", "0.0077"}], ",", 
          RowBox[{"-", "2.3564"}]}], "}"}]}], ";", "\n", "        ", 
       RowBox[{"p3", "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.2135"}], ",", 
          RowBox[{"-", "1.9241"}], ",", 
          RowBox[{"-", "1.3926"}]}], "}"}]}], ";", "\n", "        ", 
       RowBox[{"\[Sigma]1Func", "=", 
        RowBox[{"TransformShieldingVectors", "[", 
         RowBox[{"\"\<Data//sF1.dat\>\"", ",", "rMatrix"}], "]"}]}], ";", 
       "\n", "        ", 
       RowBox[{"\[Sigma]2Func", "=", 
        RowBox[{"TransformShieldingVectors", "[", 
         RowBox[{"\"\<Data//sF2.dat\>\"", ",", "rMatrix"}], "]"}]}], ";", 
       "\n", "        ", 
       RowBox[{"\[Sigma]3Func", "=", 
        RowBox[{"TransformShieldingVectors", "[", 
         RowBox[{"\"\<Data//sF3.dat\>\"", ",", "rMatrix"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"VisualizeMolecularProperties3D", "[", "\[IndentingNewLine]", 
        RowBox[{
        "tfp", ",", "\[IndentingNewLine]", "ProbabilityEllipsoid", ",", 
         "\[IndentingNewLine]", "dipoleFunc", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "90"}], ",", "180", ",", "30", ",", 
           RowBox[{"-", "60"}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"\[Sigma]2Func", ",", "\[Sigma]3Func"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"p2", ",", "p3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "120"}], ",", "180", ",", "30", ",", 
           RowBox[{"-", "60"}]}], "}"}], ",", "\[IndentingNewLine]", 
         "\"\<Shieldings\>\""}], "\[IndentingNewLine]", "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
       "Define", " ", "center", " ", "point", " ", "and", " ", "rotation", 
        " ", "matrix"}], "*)"}], "\[IndentingNewLine]", " ", 
      RowBox[{
       RowBox[{"p1", "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.8559"}], ",", 
          RowBox[{"-", "0.5255"}], ",", 
          RowBox[{"-", "1.3623"}]}], "}"}]}], ";", "\n", "        ", 
       RowBox[{"p2", "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.0085"}], ",", 
          RowBox[{"-", "0.0077"}], ",", 
          RowBox[{"-", "2.3564"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"Generate", " ", "interpolations"}], "*)"}], "\n", "       ", 
       RowBox[{"j1Func", "=", 
        RowBox[{"TransformCouplingVectors", "[", 
         RowBox[{"\"\<Data//JFH1.dat\>\"", ",", "rMatrix"}], "]"}]}], ";", 
       "\n", "       ", 
       RowBox[{"j2Func", "=", 
        RowBox[{"TransformCouplingVectors", "[", 
         RowBox[{"\"\<Data//JFH2.dat\>\"", ",", "rMatrix"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"j3Func", "=", 
        RowBox[{"TransformCouplingVectors", "[", 
         RowBox[{"\"\<Data//JFH3.dat\>\"", ",", "rMatrix"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"VisualizeMolecularProperties3D", "[", "\[IndentingNewLine]", 
        RowBox[{
        "tfp", ",", "\[IndentingNewLine]", "ProbabilityEllipsoid", ",", 
         "\[IndentingNewLine]", "dipoleFunc", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "90"}], ",", "180", ",", "30", ",", 
           RowBox[{"-", "60"}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"j1Func", ",", "j2Func"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"p1", ",", "p2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "120"}], ",", "180", ",", "60", ",", 
           RowBox[{"-", "60"}]}], "}"}], ",", "\[IndentingNewLine]", 
         "\"\<Couplings\>\""}], "\[IndentingNewLine]", "]"}]}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}]}], 
   "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.9543959341309094`*^9, 3.9543959481766367`*^9}, {
   3.9543961077157335`*^9, 3.9543961638353868`*^9}, {3.9543980499280186`*^9, 
   3.954398125767515*^9}, {3.9544031616500645`*^9, 3.9544032199509273`*^9}, {
   3.9544768876938715`*^9, 3.954476895616888*^9}, {3.9586243897219505`*^9, 
   3.958624443518571*^9}, {3.958634648362653*^9, 3.958634651912285*^9}, {
   3.95863471514215*^9, 3.958634783522427*^9}, {3.958635195778796*^9, 
   3.9586351985542974`*^9}, 3.9586356679923096`*^9, {3.9586357969051943`*^9, 
   3.958635821723655*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Antisymmetric Shielding\"\>", "\<\"Antisymmetric Coupling\"\>"},
    {
     Graphics3DBox[{
       {AbsoluteThickness[3], EdgeForm[None], Specularity[
         GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJxTTMoPSmViYGAQBWJmIPbpaZvG/c/5QAvr9eLk/kgHBgLAbtbPmlWtiWB1
B4T/2kBEV+5hLQh9VFye6nBDtu5Vp7Cng8j9CdYxt4MOPMuq+Jb20P3Aro/i
UqcnBh0QOLXj2IEpcQ6X7B4fv/FO4YBNf1/9n9+pBwIddrbkTopzuH1cM1q1
TP3A+62HP19UNj+geTOlXT43y4HlzLEnKycmH3igq/flflPwgeOGagW8yfEO
izQ2f1pi53Xg0K1jOR/X+x/41jih+CNnwoGKnLzvz4zSD4it2LN+lZvXAcco
wVUh7IkHrjZ4bLVzfr3f9jPXnp2bXuw3W839sbck98Adk57p/yJND5yZ4jGD
gzfjQN0Dppu5GYkHIOFjDA0fTwfUcAiEhsNbaDjM3KPUuly/vy7Z4SY4HCyh
4eB04O4dJ98P+2wPmN3nmL4/yuOAxPyEr/tvpzjse5ayiLkr8sBZfuX2UK7g
A29q86Wf/45zmGVVqCEra3NAsmMWzyOX+AMGrDtVp0+Oc+hYaCN/qdTpQK13
1WeWn/EHrDZ6LtPfmXBgoZm0yYRDsQdyDjry+f32OSDz7gLf4o6EA0u9Ot5u
XG11wKP5tmYcp8OBaWJ+m+z3px0AAM2N4QE=
         "], {
          {RGBColor[0.65, 0.7, 0.7], SphereBox[1, 24.], SphereBox[4, 24.], 
           SphereBox[6, 24.], SphereBox[7, 24.], SphereBox[8, 24.]}, 
          {RGBColor[0.4, 0.4, 0.4], SphereBox[2, 34.], SphereBox[5, 34.], 
           SphereBox[9, 34.]}, 
          {RGBColor[0.800498, 0.201504, 0.192061], SphereBox[3, 31.]}, 
          {RGBColor[0.578462, 0.85539, 0.408855], SphereBox[10, 30.], 
           SphereBox[11, 30.], SphereBox[12, 30.]}, 
          {RGBColor[0.65, 0.7, 0.7], CylinderBox[{1, 13}, 15.], 
           CylinderBox[{15, 4}, 15.], CylinderBox[{16, 7}, 15.], 
           CylinderBox[{17, 8}, 15.], CylinderBox[{18, 6}, 15.]}, 
          {RGBColor[0.4, 0.4, 0.4], CylinderBox[{13, 2}, 15.], 
           CylinderBox[{2, 14}, 15.], CylinderBox[{2, 5}, 15.], 
           CylinderBox[{2, 9}, 15.], CylinderBox[{5, 16}, 15.], 
           CylinderBox[{5, 17}, 15.], CylinderBox[{5, 18}, 15.], 
           CylinderBox[{9, 19}, 15.], CylinderBox[{9, 20}, 15.], 
           CylinderBox[{9, 21}, 15.]}, 
          {RGBColor[0.800498, 0.201504, 0.192061], CylinderBox[{14, 3}, 15.], 
           CylinderBox[{3, 15}, 15.]}, 
          {RGBColor[0.578462, 0.85539, 0.408855], CylinderBox[{19, 12}, 15.], 
           CylinderBox[{20, 10}, 15.], CylinderBox[{21, 11}, 15.]}}]}, 
       {RGBColor[
         NCache[
          Rational[1, 3], 0.3333333333333333], 
         NCache[
          Rational[1, 3], 0.3333333333333333], 1], Opacity[0.9], 
        InterpretationBox[
         GeometricTransformation3DBox[
          SphereBox[{0, 0, 0}], {{{57.820809760323456`, 0., 0.}, {
           7.168859144439402, 59.1866936801642, 0.}, {-0.8894382202090443, 
           0.347245695043027, 83.03771738234502}}, {0, 0, 0}}],
         Ellipsoid[{0, 0, 0}, {{3343.246041339516, 
          414.5092407891858, -51.42803812426783}, {414.5092407891858, 
          3554.457250222401, 14.176067265907836`}, {-51.42803812426783, 
          14.176067265907836`, 6896.1741879904985`}}]]}, 
       {GrayLevel[0], Opacity[1], 
        Arrow3DBox[TubeBox[{{{0., 0., 0.}, {400., 0., 0.}}}]], Text3DBox[
         StyleBox["\<\"x\"\>",
          StripOnInput->False,
          FontSize->Large], {420, 0, 0}], 
        Arrow3DBox[TubeBox[{{{0., 0., 0.}, {0., 400., 0.}}}]], Text3DBox[
         StyleBox["\<\"y\"\>",
          StripOnInput->False,
          FontSize->Large], {0, 420, 0}], 
        Arrow3DBox[TubeBox[{{{0., 0., 0.}, {0., 0., 400.}}}]], Text3DBox[
         StyleBox["\<\"z\"\>",
          StripOnInput->False,
          FontSize->Large], {0, 0, 420}]}, {
        {RGBColor[0, 
          NCache[
           Rational[2, 3], 0.6666666666666666], 0], Opacity[0.1], 
         Arrow3DBox[TubeBox[{{{0., 0., 0.}, {-28.219649365855982`, 
          99.39600742149766, 106.8267825246728}}}]], 
         {Opacity[0.5], Text3DBox[
           StyleBox["\<\"-90\[Degree]\"\>",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->16,
            FontColor->GrayLevel[0]], {-28.219649365855982`, 
           99.39600742149766, 106.8267825246728}]}}, 
        {RGBColor[0, 
          NCache[
           Rational[2, 3], 0.6666666666666666], 0], Opacity[1.], 
         Arrow3DBox[TubeBox[{{{0., 0., 0.}, {-18.422278666722317`, 
          202.2633707976596, 142.40956926518007`}}}]], 
         {Opacity[0.5], Text3DBox[
           StyleBox["\<\"-60\[Degree]\"\>",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->16,
            FontColor->GrayLevel[0]], {-18.422278666722317`, 
           202.2633707976596, 142.40956926518007`}]}}, 
        {RGBColor[0, 
          NCache[
           Rational[2, 3], 0.6666666666666666], 0], Opacity[0.1], 
         Arrow3DBox[TubeBox[{{{0., 0., 0.}, {-1.2158625909292804`, 
          290.16259561542324`, 214.53563690249777`}}}]], 
         {Opacity[0.5], Text3DBox[
           StyleBox["\<\"-30\[Degree]\"\>",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->16,
            FontColor->GrayLevel[0]], {-1.2158625909292804`, 
           290.16259561542324`, 214.53563690249777`}]}}, 
        {RGBColor[0, 
          NCache[
           Rational[2, 3], 0.6666666666666666], 0], Opacity[0.1], 
         Arrow3DBox[TubeBox[{{{0., 0., 0.}, {9.879867148927053, 
          333.9985628503912, 310.02691262397343`}}}]], 
         {Opacity[0.5], Text3DBox[
           StyleBox["\<\"0\[Degree]\"\>",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->16,
            FontColor->GrayLevel[0]], {9.879867148927053, 333.9985628503912, 
           310.02691262397343`}]}}, 
        {RGBColor[0, 
          NCache[
           Rational[2, 3], 0.6666666666666666], 0], Opacity[0.1], 
         Arrow3DBox[TubeBox[{{{0., 0., 0.}, {11.395065882712203`, 
          311.9569353764612, 410.7945488081056}}}]], 
         {Opacity[0.5], Text3DBox[
           StyleBox["\<\"30\[Degree]\"\>",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->16,
            FontColor->GrayLevel[0]], {11.395065882712203`, 311.9569353764612,
            410.7945488081056}]}}, 
        {RGBColor[0, 
          NCache[
           Rational[2, 3], 0.6666666666666666], 0], Opacity[0.1], 
         Arrow3DBox[TubeBox[{{{0., 0., 0.}, {1.7269616644147965`, 
          226.06340816073578`, 492.7332808699674}}}]], 
         {Opacity[0.5], Text3DBox[
           StyleBox["\<\"60\[Degree]\"\>",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->16,
            FontColor->GrayLevel[0]], {1.7269616644147965`, 
           226.06340816073578`, 492.7332808699674}]}}, 
        {RGBColor[0, 
          NCache[
           Rational[2, 3], 0.6666666666666666], 0], Opacity[0.1], 
         Arrow3DBox[TubeBox[{{{0., 0., 0.}, {-10.522644646802636`, 
          108.73344083254308`, 531.7031242238407}}}]], 
         {Opacity[0.5], Text3DBox[
           StyleBox["\<\"90\[Degree]\"\>",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->16,
            FontColor->GrayLevel[0]], {-10.522644646802636`, 
           108.73344083254308`, 531.7031242238407}]}}, 
        {RGBColor[0, 
          NCache[
           Rational[2, 3], 0.6666666666666666], 0], Opacity[0.1], 
         Arrow3DBox[TubeBox[{{{0., 0., 0.}, {-19.990237278895854`, 
          3.84190322241036, 510.82211851207376`}}}]], 
         {Opacity[0.5], Text3DBox[
           StyleBox["\<\"120\[Degree]\"\>",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->16,
            FontColor->GrayLevel[0]], {-19.990237278895854`, 3.84190322241036,
            510.82211851207376`}]}}, 
        {RGBColor[0, 
          NCache[
           Rational[2, 3], 0.6666666666666666], 0], Opacity[0.1], 
         Arrow3DBox[TubeBox[{{{0., 0., 
          0.}, {-26.720778724946804`, -58.39619291801941, 
          431.7572430933543}}}]], 
         {Opacity[0.5], Text3DBox[
           StyleBox["\<\"150\[Degree]\"\>",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->16,
            
            FontColor->GrayLevel[
             0]], {-26.720778724946804`, -58.39619291801941, 
           431.7572430933543}]}}, 
        {RGBColor[0, 
          NCache[
           Rational[2, 3], 0.6666666666666666], 0], Opacity[0.1], 
         Arrow3DBox[TubeBox[{{{0., 0., 
          0.}, {-36.23556864657541, -73.35110302135291, 
          320.4713024773516}}}]], 
         {Opacity[0.5], Text3DBox[
           StyleBox["\<\"180\[Degree]\"\>",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->16,
            FontColor->GrayLevel[0]], {-36.23556864657541, -73.35110302135291,
            320.4713024773516}]}}}, {{
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-0.8500000000000001, -0.77, -235.64}, \
{-37.21652900826054, -278.3317916807774, -585.3675652087609}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"-120\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             
             FontColor->GrayLevel[
              0]], {-40.85318190908659, -306.0879708488552, \
-620.3403217296369}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-0.8500000000000001, -0.77, -235.64}, \
{-131.57275722519623`, -347.31015463375763`, -613.1491713718408}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"-90\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             
             FontColor->GrayLevel[
              0]], {-144.64503294771586`, -381.9641700971334, \
-650.9000885090248}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[1.], 
          Arrow3DBox[
           TubeBox[{{{-0.8500000000000001, -0.77, -235.64}, \
{-129.66179777829439`, -357.0132810150961, -555.2103021006851}}}]], 
          {Opacity[1.], Text3DBox[
            StyleBox["\<\"-60\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             
             FontColor->GrayLevel[
              0]], {-142.54297755612382`, -392.63760911660574`, \
-587.1673323107535}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-0.8500000000000001, -0.77, -235.64}, \
{-80.04185983484736, -360.117149264295, -545.1122696002379}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"-30\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             
             FontColor->GrayLevel[
              0]], {-87.9610458183321, -396.0518641907245, \
-576.0594965602618}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-0.8500000000000001, -0.77, -235.64}, \
{-60.34888696498159, -345.2510352250248, -557.5730269174376}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"0\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             
             FontColor->GrayLevel[
              0]], {-66.29877566147974, -379.6991387475273, \
-589.7663296091814}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-0.8500000000000001, -0.77, -235.64}, \
{-25.500500958530175`, -297.8124801773644, -556.127866810233}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"30\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             
             FontColor->GrayLevel[
              0]], {-27.965551054383194`, -327.5167281951009, \
-588.1766534912562}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[TubeBox[{{{-0.8500000000000001, -0.77, -235.64}, {
           29.87923727674912, -245.4211840501922, -549.0607469508492}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"60\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             FontColor->GrayLevel[0]], {
            32.952161004424035`, -269.8863024552114, -580.4028216459342}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[TubeBox[{{{-0.8500000000000001, -0.77, -235.64}, {
           41.40486627184337, -248.8343640976607, -536.3515936261384}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"90\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             FontColor->GrayLevel[0]], {
            45.630352899027706`, -273.6408005074268, -566.4227529887523}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[TubeBox[{{{-0.8500000000000001, -0.77, -235.64}, {
           14.229563636797645`, -302.4106427044798, -530.6226934403985}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"120\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             FontColor->GrayLevel[0]], {
            15.737520000477408`, -332.57470697492784`, -560.1209627844383}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-0.8500000000000001, -0.77, -235.64}, \
{-2.1630538832118194`, -328.5180514272549, -536.2144552937546}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"150\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             
             FontColor->GrayLevel[
              0]], {-2.2943592715330015`, -361.29285656998036`, \
-566.2719008231301}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-0.8500000000000001, -0.77, -235.64}, \
{-0.9739927546513545, -297.3481183496228, -540.2423462516235}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"180\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             
             FontColor->GrayLevel[
              
              0]], {-0.98639203011649, -327.00593018458505`, \
-570.7025808767858}]}}}, {
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-21.349999999999998`, -192.41, -139.26000000000002`}, \
{-92.10339353404628, -111.67879283062146`, 43.74550399480137}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"-120\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             
             FontColor->GrayLevel[
              0]], {-99.1787328874509, -103.60567211368361`, 
            62.046054394281526`}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-21.349999999999998`, -192.41, -139.26000000000002`}, \
{-191.07812336501553`, -75.11656848649298, -41.29836177984616}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"-90\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             
             FontColor->GrayLevel[
              0]], {-208.05093570151706`, -63.38722533514229, \
-31.502197957830774`}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[1.], 
          Arrow3DBox[
           TubeBox[{{{-21.349999999999998`, -192.41, -139.26000000000002`}, \
{-149.94001249005132`, -98.93597559738957, 22.733635522475453`}}}]], 
          {Opacity[1.], Text3DBox[
            StyleBox["\<\"-60\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             
             FontColor->GrayLevel[
              0]], {-162.79901373905645`, -89.58857315712854, 
            38.932999074723}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-21.349999999999998`, -192.41, -139.26000000000002`}, \
{-118.8231857289683, -133.1557381631525, 50.81522989073659}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"-30\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             
             FontColor->GrayLevel[
              0]], {-128.57050430186513`, -127.23031197946776`, 
            69.82275287981022}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-21.349999999999998`, -192.41, -139.26000000000002`}, \
{-128.83049779936098`, -152.9932632791999, 35.958537715290504`}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"0\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             
             FontColor->GrayLevel[
              0]], {-139.5785475792971, -149.0515896071199, 
            53.48039148681957}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-21.349999999999998`, -192.41, -139.26000000000002`}, \
{-157.21177345977722`, -135.31530787136512`, 5.288917820579229}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"30\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             
             FontColor->GrayLevel[
              0]], {-170.79795080575497`, -129.60583865850163`, 
            19.743809602637157`}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-21.349999999999998`, -192.41, -139.26000000000002`}, \
{-168.02411570954123`, -114.39005830755741`, -6.92663316029487}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"60\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             
             FontColor->GrayLevel[
              0]], {-182.69152728049534`, -106.58806413831316`, 
            6.306703523675623}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-21.349999999999998`, -192.41, -139.26000000000002`}, \
{-130.8982107818106, -126.46243680564652`, 15.709838753322373`}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"90\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             
             FontColor->GrayLevel[
              0]], {-141.85303185999166`, -119.86768048621117`, 
            31.206822628654606`}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-21.349999999999998`, -192.41, -139.26000000000002`}, \
{-91.06420500067594, -141.18972214604685`, 59.64637309469893}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"120\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             
             FontColor->GrayLevel[
              0]], {-98.03562550074354, -136.06769436065156`, 
            79.53701040416883}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-21.349999999999998`, -192.41, -139.26000000000002`}, \
{-66.28067514430505, -151.73158435110454`, 96.99842510135511}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"150\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             FontColor->GrayLevel[0]], {-70.77374265873556, -147.663742786215,
             120.62426761149064`}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-21.349999999999998`, -192.41, -139.26000000000002`}, \
{-6.767885904739419, -184.7381740479488, 144.31689880361242`}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"180\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             
             FontColor->GrayLevel[
              0]], {-5.309674495213361, -183.9709914527437, 
            172.67458868397367`}]}}}}},
      Boxed->False,
      ImageSize->600,
      Lighting->"Neutral",
      ViewPoint->{3.035873713164359, -1.3600481890772866`, 0.5984477597127729},
      ViewVertical->{-0.39058885797034093`, 0.0971852696009899, 
       0.9754154561170143},
      ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], 
     Graphics3DBox[{
       {AbsoluteThickness[3], EdgeForm[None], Specularity[
         GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJxTTMoPSmViYGAQBWJmIPbpaZvG/c/5QAvr9eLk/kgHBgLAbtbPmlWtiWB1
B4T/2kBEV+5hLQh9VFye6nBDtu5Vp7Cng8j9CdYxt4MOPMuq+Jb20P3Aro/i
UqcnBh0QOLXj2IEpcQ6X7B4fv/FO4YBNf1/9n9+pBwIddrbkTopzuH1cM1q1
TP3A+62HP19UNj+geTOlXT43y4HlzLEnKycmH3igq/flflPwgeOGagW8yfEO
izQ2f1pi53Xg0K1jOR/X+x/41jih+CNnwoGKnLzvz4zSD4it2LN+lZvXAcco
wVUh7IkHrjZ4bLVzfr3f9jPXnp2bXuw3W839sbck98Adk57p/yJND5yZ4jGD
gzfjQN0Dppu5GYkHIOFjDA0fTwfUcAiEhsNbaDjM3KPUuly/vy7Z4SY4HCyh
4eB04O4dJ98P+2wPmN3nmL4/yuOAxPyEr/tvpzjse5ayiLkr8sBZfuX2UK7g
A29q86Wf/45zmGVVqCEra3NAsmMWzyOX+AMGrDtVp0+Oc+hYaCN/qdTpQK13
1WeWn/EHrDZ6LtPfmXBgoZm0yYRDsQdyDjry+f32OSDz7gLf4o6EA0u9Ot5u
XG11wKP5tmYcp8OBaWJ+m+z3px0AAM2N4QE=
         "], {
          {RGBColor[0.65, 0.7, 0.7], SphereBox[1, 24.], SphereBox[4, 24.], 
           SphereBox[6, 24.], SphereBox[7, 24.], SphereBox[8, 24.]}, 
          {RGBColor[0.4, 0.4, 0.4], SphereBox[2, 34.], SphereBox[5, 34.], 
           SphereBox[9, 34.]}, 
          {RGBColor[0.800498, 0.201504, 0.192061], SphereBox[3, 31.]}, 
          {RGBColor[0.578462, 0.85539, 0.408855], SphereBox[10, 30.], 
           SphereBox[11, 30.], SphereBox[12, 30.]}, 
          {RGBColor[0.65, 0.7, 0.7], CylinderBox[{1, 13}, 15.], 
           CylinderBox[{15, 4}, 15.], CylinderBox[{16, 7}, 15.], 
           CylinderBox[{17, 8}, 15.], CylinderBox[{18, 6}, 15.]}, 
          {RGBColor[0.4, 0.4, 0.4], CylinderBox[{13, 2}, 15.], 
           CylinderBox[{2, 14}, 15.], CylinderBox[{2, 5}, 15.], 
           CylinderBox[{2, 9}, 15.], CylinderBox[{5, 16}, 15.], 
           CylinderBox[{5, 17}, 15.], CylinderBox[{5, 18}, 15.], 
           CylinderBox[{9, 19}, 15.], CylinderBox[{9, 20}, 15.], 
           CylinderBox[{9, 21}, 15.]}, 
          {RGBColor[0.800498, 0.201504, 0.192061], CylinderBox[{14, 3}, 15.], 
           CylinderBox[{3, 15}, 15.]}, 
          {RGBColor[0.578462, 0.85539, 0.408855], CylinderBox[{19, 12}, 15.], 
           CylinderBox[{20, 10}, 15.], CylinderBox[{21, 11}, 15.]}}]}, 
       {RGBColor[
         NCache[
          Rational[1, 3], 0.3333333333333333], 
         NCache[
          Rational[1, 3], 0.3333333333333333], 1], Opacity[0.9], 
        InterpretationBox[
         GeometricTransformation3DBox[
          SphereBox[{0, 0, 0}], {{{57.820809760323456`, 0., 0.}, {
           7.168859144439402, 59.1866936801642, 0.}, {-0.8894382202090443, 
           0.347245695043027, 83.03771738234502}}, {0, 0, 0}}],
         Ellipsoid[{0, 0, 0}, {{3343.246041339516, 
          414.5092407891858, -51.42803812426783}, {414.5092407891858, 
          3554.457250222401, 14.176067265907836`}, {-51.42803812426783, 
          14.176067265907836`, 6896.1741879904985`}}]]}, 
       {GrayLevel[0], Opacity[1], 
        Arrow3DBox[TubeBox[{{{0., 0., 0.}, {400., 0., 0.}}}]], Text3DBox[
         StyleBox["\<\"x\"\>",
          StripOnInput->False,
          FontSize->Large], {420, 0, 0}], 
        Arrow3DBox[TubeBox[{{{0., 0., 0.}, {0., 400., 0.}}}]], Text3DBox[
         StyleBox["\<\"y\"\>",
          StripOnInput->False,
          FontSize->Large], {0, 420, 0}], 
        Arrow3DBox[TubeBox[{{{0., 0., 0.}, {0., 0., 400.}}}]], Text3DBox[
         StyleBox["\<\"z\"\>",
          StripOnInput->False,
          FontSize->Large], {0, 0, 420}]}, {
        {RGBColor[0, 
          NCache[
           Rational[2, 3], 0.6666666666666666], 0], Opacity[0.1], 
         Arrow3DBox[TubeBox[{{{0., 0., 0.}, {-28.219649365855982`, 
          99.39600742149766, 106.8267825246728}}}]], 
         {Opacity[0.5], Text3DBox[
           StyleBox["\<\"-90\[Degree]\"\>",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->16,
            FontColor->GrayLevel[0]], {-28.219649365855982`, 
           99.39600742149766, 106.8267825246728}]}}, 
        {RGBColor[0, 
          NCache[
           Rational[2, 3], 0.6666666666666666], 0], Opacity[1.], 
         Arrow3DBox[TubeBox[{{{0., 0., 0.}, {-18.422278666722317`, 
          202.2633707976596, 142.40956926518007`}}}]], 
         {Opacity[0.5], Text3DBox[
           StyleBox["\<\"-60\[Degree]\"\>",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->16,
            FontColor->GrayLevel[0]], {-18.422278666722317`, 
           202.2633707976596, 142.40956926518007`}]}}, 
        {RGBColor[0, 
          NCache[
           Rational[2, 3], 0.6666666666666666], 0], Opacity[0.1], 
         Arrow3DBox[TubeBox[{{{0., 0., 0.}, {-1.2158625909292804`, 
          290.16259561542324`, 214.53563690249777`}}}]], 
         {Opacity[0.5], Text3DBox[
           StyleBox["\<\"-30\[Degree]\"\>",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->16,
            FontColor->GrayLevel[0]], {-1.2158625909292804`, 
           290.16259561542324`, 214.53563690249777`}]}}, 
        {RGBColor[0, 
          NCache[
           Rational[2, 3], 0.6666666666666666], 0], Opacity[0.1], 
         Arrow3DBox[TubeBox[{{{0., 0., 0.}, {9.879867148927053, 
          333.9985628503912, 310.02691262397343`}}}]], 
         {Opacity[0.5], Text3DBox[
           StyleBox["\<\"0\[Degree]\"\>",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->16,
            FontColor->GrayLevel[0]], {9.879867148927053, 333.9985628503912, 
           310.02691262397343`}]}}, 
        {RGBColor[0, 
          NCache[
           Rational[2, 3], 0.6666666666666666], 0], Opacity[0.1], 
         Arrow3DBox[TubeBox[{{{0., 0., 0.}, {11.395065882712203`, 
          311.9569353764612, 410.7945488081056}}}]], 
         {Opacity[0.5], Text3DBox[
           StyleBox["\<\"30\[Degree]\"\>",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->16,
            FontColor->GrayLevel[0]], {11.395065882712203`, 311.9569353764612,
            410.7945488081056}]}}, 
        {RGBColor[0, 
          NCache[
           Rational[2, 3], 0.6666666666666666], 0], Opacity[0.1], 
         Arrow3DBox[TubeBox[{{{0., 0., 0.}, {1.7269616644147965`, 
          226.06340816073578`, 492.7332808699674}}}]], 
         {Opacity[0.5], Text3DBox[
           StyleBox["\<\"60\[Degree]\"\>",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->16,
            FontColor->GrayLevel[0]], {1.7269616644147965`, 
           226.06340816073578`, 492.7332808699674}]}}, 
        {RGBColor[0, 
          NCache[
           Rational[2, 3], 0.6666666666666666], 0], Opacity[0.1], 
         Arrow3DBox[TubeBox[{{{0., 0., 0.}, {-10.522644646802636`, 
          108.73344083254308`, 531.7031242238407}}}]], 
         {Opacity[0.5], Text3DBox[
           StyleBox["\<\"90\[Degree]\"\>",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->16,
            FontColor->GrayLevel[0]], {-10.522644646802636`, 
           108.73344083254308`, 531.7031242238407}]}}, 
        {RGBColor[0, 
          NCache[
           Rational[2, 3], 0.6666666666666666], 0], Opacity[0.1], 
         Arrow3DBox[TubeBox[{{{0., 0., 0.}, {-19.990237278895854`, 
          3.84190322241036, 510.82211851207376`}}}]], 
         {Opacity[0.5], Text3DBox[
           StyleBox["\<\"120\[Degree]\"\>",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->16,
            FontColor->GrayLevel[0]], {-19.990237278895854`, 3.84190322241036,
            510.82211851207376`}]}}, 
        {RGBColor[0, 
          NCache[
           Rational[2, 3], 0.6666666666666666], 0], Opacity[0.1], 
         Arrow3DBox[TubeBox[{{{0., 0., 
          0.}, {-26.720778724946804`, -58.39619291801941, 
          431.7572430933543}}}]], 
         {Opacity[0.5], Text3DBox[
           StyleBox["\<\"150\[Degree]\"\>",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->16,
            
            FontColor->GrayLevel[
             0]], {-26.720778724946804`, -58.39619291801941, 
           431.7572430933543}]}}, 
        {RGBColor[0, 
          NCache[
           Rational[2, 3], 0.6666666666666666], 0], Opacity[0.1], 
         Arrow3DBox[TubeBox[{{{0., 0., 
          0.}, {-36.23556864657541, -73.35110302135291, 
          320.4713024773516}}}]], 
         {Opacity[0.5], Text3DBox[
           StyleBox["\<\"180\[Degree]\"\>",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->16,
            FontColor->GrayLevel[0]], {-36.23556864657541, -73.35110302135291,
            320.4713024773516}]}}}, {{
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-185.59, -52.55, -136.23000000000002`}, \
{-90.19566670085437, -99.77862439437084, 61.21120191142211}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"-120\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             
             FontColor->GrayLevel[
              0]], {-80.65623337093982, -104.50148683380792`, 
            80.95532210256434}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[1.], 
          Arrow3DBox[
           TubeBox[{{{-185.59, -52.55, -136.23000000000002`}, \
{-91.01235538541889, -102.52010556811308`, 77.26976039487636}}}]], 
          {Opacity[1.], Text3DBox[
            StyleBox["\<\"-60\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             
             FontColor->GrayLevel[
              0]], {-81.55459092396076, -107.5171161249244, 
            98.619736434364}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-185.59, -52.55, -136.23000000000002`}, \
{-84.1270741606852, -98.46394960202534, 61.715002240694076`}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"0\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             
             FontColor->GrayLevel[
              0]], {-73.98078157675373, -103.05534456222787`, 
            81.50950246476347}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-185.59, -52.55, -136.23000000000002`}, \
{-92.1607960662598, -100.52629743451868`, 59.10424875526098}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"60\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             
             FontColor->GrayLevel[
              0]], {-82.81787567288578, -105.32392717797055`, 
            78.63767363078708}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-185.59, -52.55, -136.23000000000002`}, \
{-83.79570510866091, -106.16873793324083`, 67.88480218255006}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"120\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             
             FontColor->GrayLevel[
              0]], {-73.616275619527, -111.53061172656493`, 
            88.29628240080507}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-185.59, -52.55, -136.23000000000002`}, \
{-79.61285876037876, -101.82755645912988`, 46.84227524694896}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"180\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             
             FontColor->GrayLevel[
              0]], {-69.01514463641662, -106.75531210504286`, 
            65.14950277164385}]}}}, {
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-0.8500000000000001, -0.77, -235.64}, \
{-141.33092029349936`, 31.418494584008645`, -339.28411150618604`}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"-120\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             FontColor->GrayLevel[0]], {-155.3790123228493, 
            34.6373440424095, -349.64852265680463`}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[1.], 
          Arrow3DBox[
           TubeBox[{{{-0.8500000000000001, -0.77, -235.64}, \
{-133.0640628118212, 36.9411186545812, -334.8153655128727}}}]], 
          {Opacity[1.], Text3DBox[
            StyleBox["\<\"-60\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             FontColor->GrayLevel[0]], {-146.28546909300331`, 
            40.71223052003932, -344.73290206415993`}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-0.8500000000000001, -0.77, -235.64}, \
{-161.21018091766692`, 25.680421740112468`, -339.0204505978926}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"0\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             FontColor->GrayLevel[0]], {-177.2461990094336, 
            28.325463914123716`, -349.3584956576819}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-0.8500000000000001, -0.77, -235.64}, \
{-153.23430706448104`, 25.180367008496816`, -351.55501806324435`}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"60\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             FontColor->GrayLevel[0]], {-168.47273777092914`, 
            27.7754037093465, -363.1465198695688}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-0.8500000000000001, -0.77, -235.64}, \
{-158.98907029823684`, 32.182563869372316`, -349.0188912436713}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"120\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             FontColor->GrayLevel[0]], {-174.8029773280605, 
            35.47782025630955, -360.3567803680384}]}}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          Arrow3DBox[
           TubeBox[{{{-0.8500000000000001, -0.77, -235.64}, \
{-169.77693368560952`, 34.08189724659617, -344.4533095438714}}}]], 
          {Opacity[0], Text3DBox[
            StyleBox["\<\"180\[Degree]\"\>",
             StripOnInput->False,
             LineColor->GrayLevel[0],
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->16,
             FontColor->GrayLevel[0]], {-186.6696270541705, 
            37.56708697125579, -355.3346404982585}]}}}}},
      Boxed->False,
      ImageSize->600,
      Lighting->"Neutral",
      ViewPoint->{1.15429023163078, -3.1505653003334753`, 
       0.40737249477156534`},
      ViewVertical->{-0.06986108449332668, 0.2163846485811813, 
       0.9866138444203639}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.9543960944095078`*^9, 3.9543961640870743`*^9}, {
   3.9543977075937614`*^9, 3.954397715579936*^9}, 3.954398126887557*^9, 
   3.9544030657976627`*^9, 3.954403138000596*^9, {3.9544031970873036`*^9, 
   3.9544032214754877`*^9}, 3.954403306990293*^9, 3.95440335918643*^9, 
   3.9544036101819363`*^9, 3.954403763280342*^9, 3.9544768979297504`*^9, {
   3.95862438482197*^9, 3.9586244177867064`*^9}, 3.9586343414279013`*^9, 
   3.9586346008580356`*^9, 3.9586346527621107`*^9, {3.958634721803455*^9, 
   3.9586347327022867`*^9}, {3.958634764662156*^9, 3.9586347839121714`*^9}, {
   3.9586348780188904`*^9, 3.9586348980665617`*^9}, 3.9586350858993998`*^9, 
   3.958635208087659*^9, 3.95863540567234*^9, {3.958635652992118*^9, 
   3.9586356683923664`*^9}, {3.958635798634981*^9, 3.958635822002415*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
     "\"\<\>\"", ",", "\"\<Antisymmetric Shielding\>\"", ",", 
      "\"\<Antisymmetric Coupling\>\""}], "\[IndentingNewLine]", "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"\"\<XZ-projection\>\"", ",", "\[IndentingNewLine]", 
      RowBox[{"VisualizeMolecularProperties2D", "[", "\[IndentingNewLine]", 
       RowBox[{
       "\"\<Shieldings\>\"", ",", "\"\<XZ\>\"", ",", "\[IndentingNewLine]", 
        "dipoleFunc", ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
         "\[Sigma]1Func", ",", "\[Sigma]2Func", ",", "\[Sigma]3Func"}], "}"}],
         ",", "\[IndentingNewLine]", 
        RowBox[{"DipoleThetaRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "120"}], ",", "0"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"FieldThetaRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "120"}], ",", "0"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"StepSize", "\[Rule]", "10"}], ",", "\[IndentingNewLine]", 
        RowBox[{"HighlightAngle", "\[Rule]", 
         RowBox[{"-", "60"}]}]}], "\[IndentingNewLine]", "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"VisualizeMolecularProperties2D", "[", "\[IndentingNewLine]", 
       RowBox[{
       "\"\<Couplings\>\"", ",", "\"\<XZ\>\"", ",", "\[IndentingNewLine]", 
        "dipoleFunc", ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"j1Func", ",", "j2Func"}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"DipoleThetaRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "70"}], ",", 
           RowBox[{"-", "50"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"FieldThetaRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "70"}], ",", 
           RowBox[{"-", "50"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"StepSize", "\[Rule]", "10"}], ",", "\[IndentingNewLine]", 
        RowBox[{"HighlightAngle", "\[Rule]", 
         RowBox[{"-", "60"}]}]}], "\[IndentingNewLine]", "]"}]}], 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"\"\<YZ-projection\>\"", ",", "\[IndentingNewLine]", 
      RowBox[{"VisualizeMolecularProperties2D", "[", "\[IndentingNewLine]", 
       RowBox[{
       "\"\<Shieldings\>\"", ",", "\"\<YZ\>\"", ",", "\[IndentingNewLine]", 
        "dipoleFunc", ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"\[Sigma]2Func", ",", "\[Sigma]3Func"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"DipoleThetaRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "150"}], ",", "180"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"FieldThetaRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "150"}], ",", "180"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"StepSize", "\[Rule]", "30"}], ",", "\[IndentingNewLine]", 
        RowBox[{"HighlightAngle", "\[Rule]", 
         RowBox[{"-", "60"}]}]}], "\[IndentingNewLine]", "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"VisualizeMolecularProperties2D", "[", "\[IndentingNewLine]", 
       RowBox[{
       "\"\<Couplings\>\"", ",", "\"\<YZ\>\"", ",", "\[IndentingNewLine]", 
        "dipoleFunc", ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"j1Func", ",", "j2Func"}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"DipoleThetaRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "150"}], ",", "180"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"FieldThetaRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "150"}], ",", "180"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"StepSize", "\[Rule]", "30"}], ",", "\[IndentingNewLine]", 
        RowBox[{"HighlightAngle", "\[Rule]", 
         RowBox[{"-", "60"}]}]}], "\[IndentingNewLine]", "]"}]}], 
     "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "}"}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.95439754099924*^9, 3.9543975916893377`*^9}, {
   3.9543977426181707`*^9, 3.954397762754885*^9}, {3.9543978156956606`*^9, 
   3.954398018724944*^9}, {3.954400010534831*^9, 3.954400158153613*^9}, 
   3.958635954232205*^9, {3.958636030582204*^9, 3.958636100663602*^9}, {
   3.9586361350115423`*^9, 3.958636147623802*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"\"\>", "\<\"Antisymmetric Shielding\"\>", "\<\"Antisymmetric \
Coupling\"\>"},
    {"\<\"XZ-projection\"\>", 
     GraphicsBox[{{{
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {-14.321337669953344`, 63.887042875418196`}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-120\"\>",
             StripOnInput->False,
             FontSize->16], {-15.75347143694868, 70.27574716296003}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {-13.18190883460318, 56.484430090269115`}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-110\"\>",
             StripOnInput->False,
             FontSize->16], {-14.500099718063499, 62.13287309929603}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {-13.663347569270364`, 53.07835824342847}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-100\"\>",
             StripOnInput->False,
             FontSize->16], {-15.029682326197403, 58.38619406777132}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {-14.109824682927991`, 53.4133912623364}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-90\"\>",
             StripOnInput->False,
             FontSize->16], {-15.520807151220792, 58.754730388570046}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {-13.45854601598192, 56.84087109200205}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-80\"\>",
             StripOnInput->False,
             FontSize->16], {-14.804400617580114, 62.52495820120225}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {-11.718641038017894`, 62.89293975266749}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-70\"\>",
             StripOnInput->False,
             FontSize->16], {-12.890505141819686, 69.18223372793425}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[1.], 
          ArrowBox[{{0, 0}, {-9.211139333361158, 71.20478463259003}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-60\"\>",
             StripOnInput->False,
             FontSize->16], {-10.132253266697276, 78.32526309584905}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {-6.233792317398213, 81.50875625407483}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-50\"\>",
             StripOnInput->False,
             FontSize->16], {-6.857171549138036, 89.65963187948233}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {-3.282408263847705, 93.6076341471232}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-40\"\>",
             StripOnInput->False,
             FontSize->16], {-3.6106490902324757, 102.96839756183554}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {-0.6079312954646402, 107.26781845124889`}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-30\"\>",
             StripOnInput->False,
             FontSize->16], {-0.6687244250111043, 117.99460029637379}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {1.6595695116915012`, 122.26782807307347`}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-20\"\>",
             StripOnInput->False,
             FontSize->16], {1.8255264628606516, 134.49461088038083}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {3.525487781596464, 138.2979350850916}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-10\"\>",
             StripOnInput->False,
             FontSize->16], {3.878036559756111, 152.12772859360078}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {4.939933574463526, 155.01345631198672`}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"0\"\>",
             StripOnInput->False,
             FontSize->16], {5.4339269319098795, 170.5148019431854}]}}}, 
        {RGBColor[
          NCache[
           Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
         Opacity[0.1], 
         ArrowBox[{{0, 0}, {20.022734847255222`, 78.62101897518701}}], 
         {Opacity[0], InsetBox[
           StyleBox["\<\"-120\"\>",
            StripOnInput->False,
            FontSize->16], {22.025008331980747, 86.48312087270573}]}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          ArrowBox[{{0, 0}, {20.374180186861555`, 79.55727048975577}}], 
          {Opacity[0], InsetBox[
            StyleBox["\<\"-110\"\>",
             StripOnInput->False,
             FontSize->16], {22.411598205547712, 87.51299753873134}]}, 
          {RGBColor[
            NCache[
             Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
           Opacity[0.1], 
           ArrowBox[{{0, 0}, {15.869805626310086`, 69.92928218581812}}], 
           {Opacity[0], InsetBox[
             StyleBox["\<\"-100\"\>",
              StripOnInput->False,
              FontSize->16], {17.456786188941095, 76.92221040439995}]}, 
           {RGBColor[
             NCache[
              Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
            Opacity[0.1], 
            ArrowBox[{{0, 0}, {5.577762127252471, 56.74455096412896}}], 
            {Opacity[0], InsetBox[
              StyleBox["\<\"-90\"\>",
               StripOnInput->False,
               FontSize->16], {6.135538339977719, 62.41900606054186}]}, 
            {RGBColor[
              NCache[
               Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
             Opacity[0.1], 
             ArrowBox[{{0, 0}, {-4.330292797594706, 45.14211825358898}}], 
             {Opacity[0], InsetBox[
               StyleBox["\<\"-80\"\>",
                StripOnInput->False,
                FontSize->16], {-4.763322077354177, 49.65633007894789}]}, 
             {RGBColor[
               NCache[
                Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0],
               Opacity[0.1], 
              ArrowBox[{{0, 0}, {-9.371314611059187, 36.649567052367566`}}], 
              {Opacity[0], InsetBox[
                StyleBox["\<\"-70\"\>",
                 StripOnInput->False,
                 FontSize->16], {-10.308446072165106, 40.31452375760433}]}, 
              {RGBColor[
                NCache[
                 Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 
                0], Opacity[1.], 
               ArrowBox[{{0, 0}, {-8.776685046986504, 32.90957188154457}}], 
               {Opacity[1.], InsetBox[
                 StyleBox["\<\"-60\"\>",
                  StripOnInput->False,
                  FontSize->16], {-9.654353551685157, 36.20052906969903}]}, 
               {RGBColor[
                 NCache[
                  Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 
                 0], Opacity[0.1], 
                ArrowBox[{{0, 0}, {-4.334605272070445, 34.529028243937546`}}], 
                {Opacity[0], InsetBox[
                  StyleBox["\<\"-50\"\>",
                   StripOnInput->False,
                   FontSize->16], {-4.76806579927749, 37.9819310683313}]}, 
                {RGBColor[
                  NCache[
                   Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 
                  0], Opacity[0.1], 
                 ArrowBox[{{0, 0}, {0.8568640879999482, 
                   40.932320371861685`}}], 
                 {Opacity[0], InsetBox[
                   StyleBox["\<\"-40\"\>",
                    StripOnInput->False,
                    FontSize->16], {0.9425504967999432, 45.02555240904786}]}, 
                 {RGBColor[
                   NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                    0], Opacity[0.1], 
                  ArrowBox[{{0, 0}, {5.799334862887539, 50.80547857429413}}], 
                  {Opacity[0], InsetBox[
                    StyleBox["\<\"-30\"\>",
                    StripOnInput->False,
                    FontSize->16], {6.379268349176295, 55.88602643172355}]}, 
                  {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                   ArrowBox[{{0, 0}, {11.067577161991759`, 
                    62.24826262691819}}], 
                   {Opacity[0], InsetBox[
                    StyleBox["\<\"-20\"\>",
                    StripOnInput->False,
                    FontSize->16], {12.174334878190935, 68.47308888961003}]}, 
                   {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {13.51314957747474, 
                    73.80737555997896}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-10\"\>",
                    StripOnInput->False,
                    FontSize->16], {14.864464535222215, 81.18811311597688}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {12.84524614899993, 
                    83.37487377342883}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"0\"\>",
                    StripOnInput->False,
                    FontSize->16], {14.129770763899925, 91.71236115077173}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 
                    0}, {-36.366529008260535`, -349.72756520876084`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-120\"\>",
                    StripOnInput->False,
                    FontSize->16], {-40.00318190908659, -384.700321729637}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 
                    0}, {-73.26288279085264, -377.87097019938807`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-110\"\>",
                    StripOnInput->False,
                    
                    FontSize->
                    16], {-80.58917106993792, -415.65806721932694}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 
                    0}, {-106.80523382281493`, -387.46614243606217`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-100\"\>",
                    StripOnInput->False,
                    
                    FontSize->
                    16], {-117.48575720509643, -426.2127566796684}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 
                    0}, {-130.72275722519623`, -377.50917137184075`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-90\"\>",
                    StripOnInput->False,
                    FontSize->16], {-143.7950329477159, -415.2600885090249}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 
                    0}, {-142.2395312051667, -357.700879531311}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-80\"\>",
                    StripOnInput->False,
                    
                    FontSize->
                    16], {-156.46348432568342, -393.4709674844421}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 
                    0}, {-141.13741743351036`, -336.502272943369}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-70\"\>",
                    StripOnInput->False,
                    
                    FontSize->
                    16], {-155.25115917686142, -370.15250023770596}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[1.], 
                    ArrowBox[{{0, 
                    0}, {-128.8117977782944, -319.57030210068507`}}], 
                    {Opacity[1.], InsetBox[
                    StyleBox["\<\"-60\"\>",
                    StripOnInput->False,
                    
                    FontSize->
                    16], {-141.69297755612385, -351.5273323107536}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 
                    0}, {-110.40932788377327`, -309.947445023539}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-50\"\>",
                    StripOnInput->False,
                    FontSize->16], {-121.4502606721506, -340.9421895258929}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 
                    0}, {-92.54153419927876, -307.3735995357611}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-40\"\>",
                    StripOnInput->False,
                    
                    FontSize->
                    16], {-101.79568761920665, -338.1109594893373}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 
                    0}, {-79.19185983484736, -309.47226960023795`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-30\"\>",
                    StripOnInput->False,
                    FontSize->16], {-87.11104581833212, -340.4194965602618}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 
                    0}, {-69.73810719953113, -313.7289584382813}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-20\"\>",
                    StripOnInput->False,
                    FontSize->16], {-76.71191791948425, -345.1018542821095}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 
                    0}, {-63.57200298484644, -318.76386632062685`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-10\"\>",
                    StripOnInput->False,
                    
                    FontSize->
                    16], {-69.92920328333109, -350.64025295268954}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 
                    0}, {-59.49888696498159, -321.93302691743764`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"0\"\>",
                    StripOnInput->False,
                    FontSize->16], {-65.44877566147976, -354.1263296091814}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {-70.75339353404628, 
                    183.0055039948014}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-120\"\>",
                    StripOnInput->False,
                    FontSize->16], {-77.82873288745093, 201.30605439428157}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {-130.61613660670716`, 
                    119.47878728574861`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-110\"\>",
                    StripOnInput->False,
                    FontSize->16], {-143.6777502673779, 131.4266660143235}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {-163.42014408332147`, 
                    92.68511798633541}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-100\"\>",
                    StripOnInput->False,
                    
                    FontSize->
                    16], {-179.76215849165362, 101.95362978496897}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {-169.72812336501553`, 
                    97.96163822015386}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-90\"\>",
                    StripOnInput->False,
                    FontSize->16], {-186.7009357015171, 107.75780204216926}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {-160.74665730975678`, 
                    117.86948475715546`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-80\"\>",
                    StripOnInput->False,
                    FontSize->16], {-176.8213230407325, 129.65643323287102}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], ArrowBox[{{0, 
                    0}, {-145.46237608447828`, 140.67854415328677`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-70\"\>",
                    StripOnInput->False,
                    
                    FontSize->
                    16], {-160.00861369292613, 154.74639856861546}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[1.], ArrowBox[{{0, 0}, {-128.59001249005132`,
                     161.99363552247547`}}], 
                    {Opacity[1.], InsetBox[
                    StyleBox["\<\"-60\"\>",
                    StripOnInput->False,
                    
                    FontSize->
                    16], {-141.44901373905648, 178.19299907472305}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], ArrowBox[{{0, 
                    0}, {-113.09766387715352`, 177.76229159264608`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-50\"\>",
                    StripOnInput->False,
                    
                    FontSize->
                    16], {-124.40743026486889, 195.53852075191074}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], ArrowBox[{{0, 
                    0}, {-102.60598236534697`, 186.68707009372187`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-40\"\>",
                    StripOnInput->False,
                    
                    FontSize->
                    16], {-112.86658060188168, 205.35577710309408}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], ArrowBox[{{0, 0}, {-97.4731857289683, 
                    190.0752298907366}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-30\"\>",
                    StripOnInput->False,
                    
                    FontSize->
                    16], {-107.22050430186515, 209.08275287981027}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], ArrowBox[{{0, 0}, {-96.03495466051312, 
                    189.79820870875167`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-20\"\>",
                    StripOnInput->False,
                    FontSize->16], {-105.63845012656445, 208.7780295796269}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], ArrowBox[{{0, 0}, {-99.34352419311308, 
                    184.68824346640042`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-10\"\>",
                    StripOnInput->False,
                    FontSize->16], {-109.27787661242441, 203.1570678130405}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], ArrowBox[{{0, 
                    0}, {-107.48049779936099`, 175.21853771529052`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"0\"\>",
                    StripOnInput->False,
                    
                    FontSize->
                    16], {-118.22854757929711, 192.7403914868196}]}}}}}}}}}}}}\
}}}}}}}}}}}}}}}}}}}}}}}}}}}}}, {
        {GrayLevel[1], LineBox[{{-150, 0}, {100, 0}}]}, 
        {GrayLevel[0], ArrowBox[{{0, 0}, {200, 0}}], InsetBox[
          StyleBox["\<\"x\"\>",
           StripOnInput->False,
           FontSize->Large], {220, 0}], ArrowBox[{{0, 0}, {0, 200}}], InsetBox[
          StyleBox["\<\"z\"\>",
           StripOnInput->False,
           FontSize->Large], {0, 220}], 
         {Thickness[0.006], CircleBox[{0, 0}, 10], DiskBox[{0, 0}, 3]}}}},
      ImageSize->400,
      ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], 
     GraphicsBox[{{{
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {-11.718641038017894`, 62.89293975266749}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-70\"\>",
             StripOnInput->False,
             FontSize->16], {-12.890505141819686, 69.18223372793425}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[1.], 
          ArrowBox[{{0, 0}, {-9.211139333361158, 71.20478463259003}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-60\"\>",
             StripOnInput->False,
             FontSize->16], {-10.132253266697276, 78.32526309584905}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {-6.233792317398213, 81.50875625407483}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-50\"\>",
             StripOnInput->False,
             FontSize->16], {-6.857171549138036, 89.65963187948233}]}}}, 
        {RGBColor[
          NCache[
           Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
         Opacity[0.1], 
         ArrowBox[{{0, 0}, {91.3837411680208, 214.07403045375452`}}], 
         {Opacity[0], InsetBox[
           StyleBox["\<\"-70\"\>",
            StripOnInput->False,
            FontSize->16], {100.5221152848229, 235.48143349913}]}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[1.], 
          ArrowBox[{{0, 0}, {94.57764461458112, 213.49976039487638`}}], 
          {Opacity[1.], InsetBox[
            StyleBox["\<\"-60\"\>",
             StripOnInput->False,
             FontSize->16], {104.03540907603924, 234.84973643436405}]}, 
          {RGBColor[
            NCache[
             Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
           Opacity[0.1], 
           ArrowBox[{{0, 0}, {97.50558243460557, 212.32028901041082`}}], 
           {Opacity[0], InsetBox[
             StyleBox["\<\"-50\"\>",
              StripOnInput->False,
              FontSize->16], {107.25614067806615, 233.55231791145192}]}, 
           {RGBColor[
             NCache[
              Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
            Opacity[0.1], 
            ArrowBox[{{0, 0}, {-123.02309400571193`, -95.25449297135457}}], 
            {Opacity[0], InsetBox[
              StyleBox["\<\"-70\"\>",
               StripOnInput->False,
               FontSize->16], {-135.32540340628313, -104.77994226849003}]}, 
            {RGBColor[
              NCache[
               Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
             Opacity[1.], 
             ArrowBox[{{0, 0}, {-132.2140628118212, -99.1753655128727}}], 
             {Opacity[1.], InsetBox[
               StyleBox["\<\"-60\"\>",
                StripOnInput->False,
                FontSize->16], {-145.43546909300335, -109.09290206415999}]}, 
             {RGBColor[
               NCache[
                Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0],
               Opacity[0.1], 
              ArrowBox[{{0, 
                0}, {-141.08748487020216`, -102.30027367176832`}}], 
              {Opacity[0], InsetBox[
                StyleBox["\<\"-50\"\>",
                 StripOnInput->False,
                 
                 FontSize->
                  16], {-155.19623335722238, -112.53030103894517}]}}}}}}}}, {
        {GrayLevel[1], LineBox[{{-150, 0}, {100, 0}}]}, 
        {GrayLevel[0], ArrowBox[{{0, 0}, {200, 0}}], InsetBox[
          StyleBox["\<\"x\"\>",
           StripOnInput->False,
           FontSize->Large], {220, 0}], ArrowBox[{{0, 0}, {0, 200}}], InsetBox[
          StyleBox["\<\"z\"\>",
           StripOnInput->False,
           FontSize->Large], {0, 220}], 
         {Thickness[0.006], CircleBox[{0, 0}, 10], DiskBox[{0, 0}, 3]}}}},
      ImageSize->400]},
    {"\<\"YZ-projection\"\>", 
     GraphicsBox[{{{
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {-25.57728754307021, 104.69466332377095`}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-150\"\>",
             StripOnInput->False,
             FontSize->16], {-28.135016297377234, 115.16412965614806}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {3.1413926366585048`, 63.887042875418196`}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-120\"\>",
             StripOnInput->False,
             FontSize->16], {3.4555319003243556, 70.27574716296003}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {49.69800371074883, 53.4133912623364}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-90\"\>",
             StripOnInput->False,
             FontSize->16], {54.66780408182372, 58.754730388570046}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[1.], 
          ArrowBox[{{0, 0}, {101.1316853988298, 71.20478463259003}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-60\"\>",
             StripOnInput->False,
             FontSize->16], {111.2448539387128, 78.32526309584905}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {145.08129780771162`, 107.26781845124889`}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-30\"\>",
             StripOnInput->False,
             FontSize->16], {159.5894275884828, 117.99460029637379}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {166.9992814251956, 155.01345631198672`}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"0\"\>",
             StripOnInput->False,
             FontSize->16], {183.69920956771517, 170.5148019431854}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {155.9784676882306, 205.3972744040528}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"30\"\>",
             StripOnInput->False,
             FontSize->16], {171.57631445705368, 225.93700184445814}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {113.03170408036789`, 246.3666404349837}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"60\"\>",
             StripOnInput->False,
             FontSize->16], {124.3348744884047, 271.0033044784821}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {54.36672041627154, 265.8515621119204}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"90\"\>",
             StripOnInput->False,
             FontSize->16], {59.8033924578987, 292.4367183231124}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {1.92095161120518, 255.41105925603688`}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"120\"\>",
             StripOnInput->False,
             FontSize->16], {2.1130467723256983, 280.9521651816406}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {-29.198096459009705`, 215.87862154667715`}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"150\"\>",
             StripOnInput->False,
             FontSize->16], {-32.11790610491068, 237.4664837013449}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {-36.675551510676456`, 160.2356512386758}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"180\"\>",
             StripOnInput->False,
             FontSize->16], {-40.34310666174411, 176.25921636254344}]}}}, 
        {RGBColor[
          NCache[
           Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
         Opacity[0.1], 
         ArrowBox[{{0, 0}, {-242.27699621143847`, -297.7699316441834}}], 
         {Opacity[0], InsetBox[
           StyleBox["\<\"-150\"\>",
            StripOnInput->False,
            FontSize->16], {-266.50469583258234, -327.5469248086017}]}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          ArrowBox[{{0, 0}, {-277.56179168077745`, -349.72756520876084`}}], 
          {Opacity[0], InsetBox[
            StyleBox["\<\"-120\"\>",
             StripOnInput->False,
             FontSize->16], {-305.3179708488552, -384.700321729637}]}, 
          {RGBColor[
            NCache[
             Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
           Opacity[0.1], 
           ArrowBox[{{0, 0}, {-346.54015463375765`, -377.50917137184075`}}], 
           {Opacity[0], InsetBox[
             StyleBox["\<\"-90\"\>",
              StripOnInput->False,
              FontSize->16], {-381.19417009713345, -415.2600885090249}]}, 
           {RGBColor[
             NCache[
              Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
            Opacity[1.], 
            ArrowBox[{{0, 0}, {-356.2432810150961, -319.57030210068507`}}], 
            {Opacity[1.], InsetBox[
              StyleBox["\<\"-60\"\>",
               StripOnInput->False,
               FontSize->16], {-391.86760911660576, -351.5273323107536}]}, 
            {RGBColor[
              NCache[
               Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
             Opacity[0.1], 
             ArrowBox[{{0, 0}, {-359.347149264295, -309.47226960023795`}}], 
             {Opacity[0], InsetBox[
               StyleBox["\<\"-30\"\>",
                StripOnInput->False,
                FontSize->16], {-395.28186419072455, -340.4194965602618}]}, 
             {RGBColor[
               NCache[
                Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0],
               Opacity[0.1], 
              ArrowBox[{{0, 0}, {-344.4810352250248, -321.93302691743764`}}], 
              {Opacity[0], InsetBox[
                StyleBox["\<\"0\"\>",
                 StripOnInput->False,
                 FontSize->16], {-378.9291387475273, -354.1263296091814}]}, 
              {RGBColor[
                NCache[
                 Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 
                0], Opacity[0.1], 
               ArrowBox[{{0, 0}, {-297.04248017736444`, -320.4878668102329}}], 
               {Opacity[0], InsetBox[
                 StyleBox["\<\"30\"\>",
                  StripOnInput->False,
                  FontSize->16], {-326.7467281951009, -352.53665349125623}]}, 
               {RGBColor[
                 NCache[
                  Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 
                 0], Opacity[0.1], 
                ArrowBox[{{0, 0}, {-244.6511840501922, -313.4207469508492}}], 
                {Opacity[0], InsetBox[
                  StyleBox["\<\"60\"\>",
                   StripOnInput->False,
                   FontSize->16], {-269.11630245521144, -344.7628216459342}]}, 
                {RGBColor[
                  NCache[
                   Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 
                  0], Opacity[0.1], 
                 ArrowBox[{{0, 
                   0}, {-248.0643640976607, -300.71159362613844`}}], 
                 {Opacity[0], InsetBox[
                   StyleBox["\<\"90\"\>",
                    StripOnInput->False,
                    
                    FontSize->
                    16], {-272.8708005074268, -330.78275298875235}]}, 
                 {RGBColor[
                   NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                    0], Opacity[0.1], 
                  ArrowBox[{{0, 
                    0}, {-301.64064270447983`, -294.9826934403985}}], 
                  {Opacity[0], InsetBox[
                    StyleBox["\<\"120\"\>",
                    StripOnInput->False,
                    FontSize->16], {-331.8047069749279, -324.4809627844384}]}, 
                  {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                   ArrowBox[{{0, 
                    0}, {-327.7480514272549, -300.5744552937546}}], 
                   {Opacity[0], InsetBox[
                    StyleBox["\<\"150\"\>",
                    StripOnInput->False,
                    
                    FontSize->
                    16], {-360.52285656998043, -330.63190082313014}]}, 
                   {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 
                    0}, {-296.5781183496228, -304.6023462516235}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"180\"\>",
                    StripOnInput->False,
                    FontSize->16], {-326.2359301845851, -335.0625808767859}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {4.934395964757056, 
                    323.0817342419047}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-150\"\>",
                    StripOnInput->False,
                    FontSize->16], {5.4278355612327625, 355.3899076660952}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {80.73120716937854, 
                    183.0055039948014}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-120\"\>",
                    StripOnInput->False,
                    FontSize->16], {88.8043278863164, 201.30605439428157}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {117.29343151350702`, 
                    97.96163822015386}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-90\"\>",
                    StripOnInput->False,
                    FontSize->16], {129.02277466485774, 107.75780204216926}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[1.], 
                    ArrowBox[{{0, 0}, {93.47402440261042, 
                    161.99363552247547`}}], 
                    {Opacity[1.], InsetBox[
                    StyleBox["\<\"-60\"\>",
                    StripOnInput->False,
                    FontSize->16], {102.82142684287147, 178.19299907472305}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {59.25426183684749, 
                    190.0752298907366}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-30\"\>",
                    StripOnInput->False,
                    FontSize->16], {65.17968802053224, 209.08275287981027}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {39.41673672080009, 
                    175.21853771529052`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"0\"\>",
                    StripOnInput->False,
                    FontSize->16], {43.3584103928801, 192.7403914868196}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {57.09469212863488, 
                    144.54891782057925`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"30\"\>",
                    StripOnInput->False,
                    FontSize->16], {62.80416134149838, 159.0038096026372}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {78.01994169244259, 
                    132.33336683970515`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"60\"\>",
                    StripOnInput->False,
                    FontSize->16], {85.82193586168685, 145.56670352367567}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {65.94756319435348, 
                    154.9698387533224}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"90\"\>",
                    StripOnInput->False,
                    FontSize->16], {72.54231951378883, 170.46682262865465}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {51.220277853953135`, 
                    198.90637309469895`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"120\"\>",
                    StripOnInput->False,
                    FontSize->16], {56.34230563934845, 218.79701040416887}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {40.678415648895445`, 
                    236.25842510135513`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"150\"\>",
                    StripOnInput->False,
                    FontSize->16], {44.74625721378499, 259.88426761149066}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {7.671825952051184, 
                    283.57689880361244`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"180\"\>",
                    StripOnInput->False,
                    
                    FontSize->
                    16], {8.439008547256304, 311.93458868397374}]}}}}}}}}}}}}}\
}}}}}}}}}}}}}, {
        {GrayLevel[1], LineBox[{{-150, 0}, {100, 0}}]}, 
        {GrayLevel[0], ArrowBox[{{0, 0}, {200, 0}}], InsetBox[
          StyleBox["\<\"y\"\>",
           StripOnInput->False,
           FontSize->Large], {220, 0}], ArrowBox[{{0, 0}, {0, 200}}], InsetBox[
          StyleBox["\<\"z\"\>",
           StripOnInput->False,
           FontSize->Large], {0, 220}], 
         {Thickness[0.006], CircleBox[{0, 0}, 10], DiskBox[{0, 0}, 3]}}}},
      ImageSize->400], 
     GraphicsBox[{{{
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {-25.57728754307021, 104.69466332377095`}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-150\"\>",
             StripOnInput->False,
             FontSize->16], {-28.135016297377234, 115.16412965614806}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {3.1413926366585048`, 63.887042875418196`}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-120\"\>",
             StripOnInput->False,
             FontSize->16], {3.4555319003243556, 70.27574716296003}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {49.69800371074883, 53.4133912623364}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-90\"\>",
             StripOnInput->False,
             FontSize->16], {54.66780408182372, 58.754730388570046}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[1.], 
          ArrowBox[{{0, 0}, {101.1316853988298, 71.20478463259003}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-60\"\>",
             StripOnInput->False,
             FontSize->16], {111.2448539387128, 78.32526309584905}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {145.08129780771162`, 107.26781845124889`}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"-30\"\>",
             StripOnInput->False,
             FontSize->16], {159.5894275884828, 117.99460029637379}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {166.9992814251956, 155.01345631198672`}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"0\"\>",
             StripOnInput->False,
             FontSize->16], {183.69920956771517, 170.5148019431854}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {155.9784676882306, 205.3972744040528}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"30\"\>",
             StripOnInput->False,
             FontSize->16], {171.57631445705368, 225.93700184445814}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {113.03170408036789`, 246.3666404349837}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"60\"\>",
             StripOnInput->False,
             FontSize->16], {124.3348744884047, 271.0033044784821}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {54.36672041627154, 265.8515621119204}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"90\"\>",
             StripOnInput->False,
             FontSize->16], {59.8033924578987, 292.4367183231124}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {1.92095161120518, 255.41105925603688`}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"120\"\>",
             StripOnInput->False,
             FontSize->16], {2.1130467723256983, 280.9521651816406}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {-29.198096459009705`, 215.87862154667715`}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"150\"\>",
             StripOnInput->False,
             FontSize->16], {-32.11790610491068, 237.4664837013449}]}}, 
         {RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0], Opacity[0.3], 
          ArrowBox[{{0, 0}, {-36.675551510676456`, 160.2356512386758}}], 
          {Opacity[0.8], InsetBox[
            StyleBox["\<\"180\"\>",
             StripOnInput->False,
             FontSize->16], {-40.34310666174411, 176.25921636254344}]}}}, 
        {RGBColor[
          NCache[
           Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
         Opacity[0.1], 
         ArrowBox[{{0, 0}, {-43.643312338218706`, 179.86989248841266`}}], 
         {Opacity[0], InsetBox[
           StyleBox["\<\"-150\"\>",
            StripOnInput->False,
            FontSize->16], {-48.007643572040585, 197.85688173725396}]}, 
         {RGBColor[
           NCache[
            Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
          Opacity[0.1], 
          ArrowBox[{{0, 0}, {-47.22862439437083, 197.44120191142213`}}], 
          {Opacity[0], InsetBox[
            StyleBox["\<\"-120\"\>",
             StripOnInput->False,
             FontSize->16], {-51.95148683380792, 217.18532210256438}]}, 
          {RGBColor[
            NCache[
             Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
           Opacity[0.1], 
           ArrowBox[{{0, 0}, {-55.778934213973784`, 212.42800351856977`}}], 
           {Opacity[0], InsetBox[
             StyleBox["\<\"-90\"\>",
              StripOnInput->False,
              FontSize->16], {-61.356827635371175, 233.67080387042677}]}, 
           {RGBColor[
             NCache[
              Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
            Opacity[1.], 
            ArrowBox[{{0, 0}, {-49.97010556811309, 213.49976039487638`}}], 
            {Opacity[1.], InsetBox[
              StyleBox["\<\"-60\"\>",
               StripOnInput->False,
               FontSize->16], {-54.9671161249244, 234.84973643436405}]}, 
            {RGBColor[
              NCache[
               Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0], 
             Opacity[0.1], 
             ArrowBox[{{0, 0}, {-46.4029478536062, 208.23869846091023`}}], 
             {Opacity[0], InsetBox[
               StyleBox["\<\"-30\"\>",
                StripOnInput->False,
                FontSize->16], {-51.04324263896683, 229.06256830700127}]}, 
             {RGBColor[
               NCache[
                Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 0],
               Opacity[0.1], 
              ArrowBox[{{0, 0}, {-45.91394960202534, 197.9450022406941}}], 
              {Opacity[0], InsetBox[
                StyleBox["\<\"0\"\>",
                 StripOnInput->False,
                 FontSize->16], {-50.50534456222788, 217.73950246476352}]}, 
              {RGBColor[
                NCache[
                 Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 
                0], Opacity[0.1], 
               ArrowBox[{{0, 0}, {-46.23332675014729, 190.15117946151415`}}], 
               {Opacity[0], InsetBox[
                 StyleBox["\<\"30\"\>",
                  StripOnInput->False,
                  FontSize->16], {-50.85665942516203, 209.16629740766558}]}, 
               {RGBColor[
                 NCache[
                  Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 
                 0], Opacity[0.1], 
                ArrowBox[{{0, 0}, {-47.97629743451869, 195.334248755261}}], 
                {Opacity[0], InsetBox[
                  StyleBox["\<\"60\"\>",
                   StripOnInput->False,
                   FontSize->16], {-52.77392717797056, 214.86767363078712}]}, 
                {RGBColor[
                  NCache[
                   Rational[2, 3], 0.6666666666666666], 0.33333333333333337`, 
                  0], Opacity[0.1], 
                 ArrowBox[{{0, 0}, {-51.437085894954784`, 
                   205.27270845293248`}}], 
                 {Opacity[0], InsetBox[
                   StyleBox["\<\"90\"\>",
                    StripOnInput->False,
                    
                    FontSize->
                    16], {-56.580794484450266, 225.79997929822576}]}, 
                 {RGBColor[
                   NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                    0], Opacity[0.1], 
                  ArrowBox[{{0, 0}, {-53.618737933240844`, 
                    204.11480218255008`}}], 
                  {Opacity[0], InsetBox[
                    StyleBox["\<\"120\"\>",
                    StripOnInput->False,
                    FontSize->16], {-58.98061172656494, 224.52628240080512}]}, 
                  {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                   ArrowBox[{{0, 0}, {-52.98942671527042, 
                    193.71066757316066`}}], 
                   {Opacity[0], InsetBox[
                    StyleBox["\<\"150\"\>",
                    StripOnInput->False,
                    FontSize->16], {-58.28836938679746, 213.08173433047676}]}, 
                   {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {-49.277556459129876`, 
                    183.07227524694898`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"180\"\>",
                    StripOnInput->False,
                    FontSize->16], {-54.205312105042864, 201.3795027716439}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {
                    30.831205721962846`, -112.16819496757473`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-150\"\>",
                    StripOnInput->False,
                    FontSize->16], {33.91432629415913, -123.38501446433222}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {
                    32.188494584008644`, -103.64411150618606`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-120\"\>",
                    StripOnInput->False,
                    FontSize->16], {35.40734404240951, -114.00852265680469}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {
                    43.1634045647336, -88.94907996457663}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-90\"\>",
                    StripOnInput->False,
                    FontSize->16], {47.479745021206966, -97.8439879610343}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[1.], 
                    ArrowBox[{{0, 0}, {
                    37.711118654581206`, -99.1753655128727}}], 
                    {Opacity[1.], InsetBox[
                    StyleBox["\<\"-60\"\>",
                    StripOnInput->False,
                    FontSize->16], {41.48223052003933, -109.09290206415999}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {
                    29.683167525102476`, -104.94570616834196`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"-30\"\>",
                    StripOnInput->False,
                    FontSize->16], {32.65148427761273, -115.44027678517617}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {
                    26.450421740112468`, -103.38045059789263`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"0\"\>",
                    StripOnInput->False,
                    FontSize->16], {29.09546391412372, -113.7184956576819}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {
                    25.370614823438743`, -106.50705159829535`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"30\"\>",
                    StripOnInput->False,
                    FontSize->16], {27.90767630578262, -117.15775675812489}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {
                    25.950367008496816`, -115.91501806324437`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"60\"\>",
                    StripOnInput->False,
                    
                    FontSize->
                    16], {28.545403709346502, -127.50651986956883}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {
                    29.68224313035477, -119.45358582559871`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"90\"\>",
                    StripOnInput->False,
                    FontSize->16], {32.65046744339025, -131.3989444081586}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {
                    32.95256386937232, -113.3788912436713}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"120\"\>",
                    StripOnInput->False,
                    FontSize->16], {36.24782025630956, -124.71678036803846}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {
                    34.868524563562346`, -108.03238831102928`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"150\"\>",
                    StripOnInput->False,
                    
                    FontSize->
                    16], {38.355377019918585, -118.83562714213222}]}, 
                    {RGBColor[
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0.33333333333333337`,
                     0], Opacity[0.1], 
                    ArrowBox[{{0, 0}, {
                    34.851897246596174`, -108.81330954387143`}}], 
                    {Opacity[0], InsetBox[
                    StyleBox["\<\"180\"\>",
                    StripOnInput->False,
                    
                    FontSize->
                    16], {38.3370869712558, -119.6946404982586}]}}}}}}}}}}}}}}\
}}}}}}}}}}}}, {
        {GrayLevel[1], LineBox[{{-150, 0}, {100, 0}}]}, 
        {GrayLevel[0], ArrowBox[{{0, 0}, {200, 0}}], InsetBox[
          StyleBox["\<\"y\"\>",
           StripOnInput->False,
           FontSize->Large], {220, 0}], ArrowBox[{{0, 0}, {0, 200}}], InsetBox[
          StyleBox["\<\"z\"\>",
           StripOnInput->False,
           FontSize->Large], {0, 220}], 
         {Thickness[0.006], CircleBox[{0, 0}, 10], DiskBox[{0, 0}, 3]}}}},
      ImageSize->400]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.9543978611394405`*^9, 3.954397888012564*^9}, {
   3.954397947468858*^9, 3.95439801919733*^9}, 3.9543992700183125`*^9, 
   3.9544000176700354`*^9, {3.9544000481037073`*^9, 3.954400158548517*^9}, 
   3.954403068255108*^9, {3.954403199596342*^9, 3.954403229162893*^9}, 
   3.9544033743642116`*^9, 3.9544036106917105`*^9, 3.9544037637173195`*^9, 
   3.9544769156931744`*^9, 3.958635625812048*^9, {3.958635927521369*^9, 
   3.9586359550800867`*^9}, {3.9586360388021555`*^9, 
   3.9586361010339546`*^9}, {3.958636138001994*^9, 3.9586361480048857`*^9}, {
   3.9586362253821883`*^9, 3.9586362522920637`*^9}, {3.958636287866841*^9, 
   3.9586363267693124`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"props", "=", 
    RowBox[{"GenerateMolecularPropertiesFunctions", "[", "]"}]}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "VisualizeIsotropicAndAntisymmetricPart", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\"\<Type\>\"", "\[Rule]", "\"\<Shieldings\>\""}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"\"\<Functions\>\"", "\[Rule]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"props", "[", 
        RowBox[{"\"\<Shieldings\>\"", ",", "\"\<Isotropic\>\""}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"props", "[", 
        RowBox[{"\"\<Shieldings\>\"", ",", "\"\<Antisymmetric\>\""}], "]"}]}],
       "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"\"\<GridScale\>\"", "\[Rule]", "500"}]}], "  ", 
   RowBox[{"(*", 
    RowBox[{"fixed", " ", "manual", " ", "size"}], "*)"}], 
   "\[IndentingNewLine]", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"VisualizeIsotropicAndAntisymmetricPart", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"\"\<Type\>\"", "\[Rule]", "\"\<Couplings\>\""}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"\"\<Functions\>\"", "\[Rule]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"props", "[", 
       RowBox[{"\"\<Couplings\>\"", ",", "\"\<Isotropic\>\""}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"props", "[", 
       RowBox[{"\"\<Couplings\>\"", ",", "\"\<Antisymmetric\>\""}], "]"}]}], 
     "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"\"\<GridScale\>\"", "\[Rule]", "50"}]}], "  ", 
  RowBox[{"(*", 
   RowBox[{"fixed", " ", "manual", " ", "size"}], "*)"}], 
  "\[IndentingNewLine]", "]"}], "\n"}], "Input",
 CellChangeTimes->{{3.9543996015958643`*^9, 3.9543996198342266`*^9}, {
  3.954399653493549*^9, 3.954399670330497*^9}, {3.954399924929206*^9, 
  3.9543999704394693`*^9}, {3.9544033320050945`*^9, 3.9544033335254974`*^9}, {
  3.9544035494986477`*^9, 3.9544035496404667`*^9}, {3.957484083701603*^9, 
  3.9574840956406145`*^9}, {3.9574844550025473`*^9, 3.9574844551923485`*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     InterpretationBox[Cell[BoxData[
       FormBox[
        StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Sigma]\\), \\(iso\\)]\\)(\\!\
\\(\\*SuperscriptBox[\\(\[InvisiblePrefixScriptBase]\\), \\(19\\)]\\)F)\"\>",
         StripOnInput->False,
         FontSize->50], TextForm]], "InlineText"],
      Text[
       Style[
       "\!\(\*SubscriptBox[\(\[Sigma]\), \(iso\)]\)(\!\(\*SuperscriptBox[\(\
\[InvisiblePrefixScriptBase]\), \(19\)]\)F)", 50]]], 
     InterpretationBox[Cell[BoxData[
       FormBox[
        StyleBox["\<\"\\!\\(\\*SuperscriptBox[\\(\[Sigma]\\), \
\\(\[Star]\\)]\\)(\\!\\(\\*SuperscriptBox[\\(\[InvisiblePrefixScriptBase]\\), \
\\(19\\)]\\)F)\"\>",
         StripOnInput->False,
         FontSize->50], TextForm]], "InlineText"],
      Text[
       Style[
       "\!\(\*SuperscriptBox[\(\[Sigma]\), \
\(\[Star]\)]\)(\!\(\*SuperscriptBox[\(\[InvisiblePrefixScriptBase]\), \(19\)]\
\)F)", 50]]]},
    {
     GraphicsBox[{
       {Opacity[
        0.9], {LineBox[{{0, 0}, {0, 500}}], 
         LineBox[NCache[{{0, 0}, {250, 250 3^Rational[1, 2]}}, {{0, 0}, {
            250, 433.0127018922193}}]], 
         LineBox[NCache[{{0, 0}, {250 3^Rational[1, 2], 250}}, {{0, 0}, {
            433.0127018922193, 250}}]], LineBox[{{0, 0}, {500, 0}}], 
         LineBox[NCache[{{0, 0}, {250 3^Rational[1, 2], -250}}, {{0, 0}, {
            433.0127018922193, -250}}]], 
         LineBox[NCache[{{0, 0}, {250, (-250) 3^Rational[1, 2]}}, {{0, 0}, {
            250, -433.0127018922193}}]], LineBox[{{0, 0}, {0, -500}}], 
         LineBox[NCache[{{0, 0}, {-250, (-250) 3^Rational[1, 2]}}, {{0, 
            0}, {-250, -433.0127018922193}}]], 
         LineBox[NCache[{{0, 0}, {(-250) 3^Rational[1, 2], -250}}, {{0, 
            0}, {-433.0127018922193, -250}}]], LineBox[{{0, 0}, {-500, 0}}], 
         LineBox[NCache[{{0, 0}, {(-250) 3^Rational[1, 2], 250}}, {{0, 
            0}, {-433.0127018922193, 250}}]], 
         LineBox[NCache[{{0, 0}, {-250, 250 3^Rational[1, 2]}}, {{0, 
            0}, {-250, 433.0127018922193}}]], LineBox[{{0, 0}, {0, 500}}]}, {
         InsetBox[
          StyleBox[
           TemplateBox[{"\"0\"","\"\[Degree]\""},
            "Superscript"],
           StripOnInput->False,
           FontSize->30], {550., 0.}], InsetBox[
          StyleBox[
           TemplateBox[{"\"30\"","\"\[Degree]\""},
            "Superscript"],
           StripOnInput->False,
           FontSize->30], {476.31397208144125, 275.}], InsetBox[
          StyleBox[
           TemplateBox[{"\"60\"","\"\[Degree]\""},
            "Superscript"],
           StripOnInput->False,
           FontSize->30], {275., 476.31397208144125}], InsetBox[
          StyleBox[
           TemplateBox[{"\"90\"","\"\[Degree]\""},
            "Superscript"],
           StripOnInput->False,
           FontSize->30], {0., 550.}], InsetBox[
          StyleBox[
           TemplateBox[{"\"120\"","\"\[Degree]\""},
            "Superscript"],
           StripOnInput->False,
           FontSize->30], {-275., 476.31397208144125}], InsetBox[
          StyleBox[
           TemplateBox[{"\"150\"","\"\[Degree]\""},
            "Superscript"],
           StripOnInput->False,
           FontSize->30], {-476.31397208144125, 275.}], InsetBox[
          StyleBox[
           TemplateBox[{"\"180\"","\"\[Degree]\""},
            "Superscript"],
           StripOnInput->False,
           FontSize->30], {-550., 0.}], InsetBox[
          StyleBox[
           TemplateBox[{"\"210\"","\"\[Degree]\""},
            "Superscript"],
           StripOnInput->False,
           FontSize->30], {-476.31397208144125, -275.}], InsetBox[
          StyleBox[
           TemplateBox[{"\"240\"","\"\[Degree]\""},
            "Superscript"],
           StripOnInput->False,
           FontSize->30], {-275., -476.31397208144125}], InsetBox[
          StyleBox[
           TemplateBox[{"\"270\"","\"\[Degree]\""},
            "Superscript"],
           StripOnInput->False,
           FontSize->30], {0., -550.}], InsetBox[
          StyleBox[
           TemplateBox[{"\"300\"","\"\[Degree]\""},
            "Superscript"],
           StripOnInput->False,
           FontSize->30], {275., -476.31397208144125}], InsetBox[
          StyleBox[
           TemplateBox[{"\"330\"","\"\[Degree]\""},
            "Superscript"],
           StripOnInput->False,
           FontSize->30], {476.31397208144125, -275.}]}, {
         BezierCurveBox[
          NCache[{{0, 500}, {
            500 Sin[Rational[1, 60] Pi], 500 Cos[Rational[1, 60] Pi]}, {
            500 Sin[Rational[1, 30] Pi], 500 Cos[Rational[1, 30] Pi]}, {
            500 Sin[Rational[1, 20] Pi], 500 Cos[Rational[1, 20] Pi]}, {
            500 Sin[Rational[1, 15] Pi], 500 Cos[Rational[1, 15] Pi]}, {
            125 2^Rational[1, 2] (-1 + 3^Rational[1, 2]), 125 
             2^Rational[1, 2] (1 + 3^Rational[1, 2])}, {
            125 (-1 + 5^Rational[1, 2]), 
             500 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {
            500 Sin[Rational[7, 60] Pi], 500 Cos[Rational[7, 60] Pi]}, {
            500 Sin[Rational[2, 15] Pi], 500 Cos[Rational[2, 15] Pi]}, {
            500 Sin[Rational[3, 20] Pi], 500 Cos[Rational[3, 20] Pi]}, {
            250, 250 3^Rational[1, 2]}, {
            500 Sin[Rational[11, 60] Pi], 500 Cos[Rational[11, 60] Pi]}, {
            500 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2], 125 (1 + 5^Rational[1, 2])}, {
            500 Sin[Rational[13, 60] Pi], 500 Cos[Rational[13, 60] Pi]}, {
            500 Sin[Rational[7, 30] Pi], 500 Cos[Rational[7, 30] Pi]}, {
            250 2^Rational[1, 2], 250 2^Rational[1, 2]}, {
            500 Cos[Rational[7, 30] Pi], 500 Sin[Rational[7, 30] Pi]}, {
            500 Cos[Rational[13, 60] Pi], 500 Sin[Rational[13, 60] Pi]}, {
            125 (1 + 5^Rational[1, 2]), 
             500 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {
            500 Cos[Rational[11, 60] Pi], 500 Sin[Rational[11, 60] Pi]}, {
            250 3^Rational[1, 2], 250}, {
            500 Cos[Rational[3, 20] Pi], 500 Sin[Rational[3, 20] Pi]}, {
            500 Cos[Rational[2, 15] Pi], 500 Sin[Rational[2, 15] Pi]}, {
            500 Cos[Rational[7, 60] Pi], 500 Sin[Rational[7, 60] Pi]}, {
            500 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], 125 (-1 + 5^Rational[1, 2])}, {
            125 2^Rational[1, 2] (1 + 3^Rational[1, 2]), 125 
             2^Rational[1, 2] (-1 + 3^Rational[1, 2])}, {
            500 Cos[Rational[1, 15] Pi], 500 Sin[Rational[1, 15] Pi]}, {
            500 Cos[Rational[1, 20] Pi], 500 Sin[Rational[1, 20] Pi]}, {
            500 Cos[Rational[1, 30] Pi], 500 Sin[Rational[1, 30] Pi]}, {
            500 Cos[Rational[1, 60] Pi], 500 Sin[Rational[1, 60] Pi]}, {500, 
            0}, {500 Cos[Rational[1, 60] Pi], (-500) 
             Sin[Rational[1, 60] Pi]}, {
            500 Cos[Rational[1, 30] Pi], (-500) Sin[Rational[1, 30] Pi]}, {
            500 Cos[Rational[1, 20] Pi], (-500) Sin[Rational[1, 20] Pi]}, {
            500 Cos[Rational[1, 15] Pi], (-500) Sin[Rational[1, 15] Pi]}, {
            125 2^Rational[1, 2] (1 + 3^Rational[1, 2]), (-125) 
             2^Rational[1, 2] (-1 + 3^Rational[1, 2])}, {
            500 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], 125 (1 - 5^Rational[1, 2])}, {
            500 Cos[Rational[7, 60] Pi], (-500) Sin[Rational[7, 60] Pi]}, {
            500 Cos[Rational[2, 15] Pi], (-500) Sin[Rational[2, 15] Pi]}, {
            500 Cos[Rational[3, 20] Pi], (-500) Sin[Rational[3, 20] Pi]}, {
            250 3^Rational[1, 2], -250}, {
            500 Cos[Rational[11, 60] Pi], (-500) Sin[Rational[11, 60] Pi]}, {
            125 (1 + 5^Rational[1, 2]), (-500) (Rational[5, 8] + 
               Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
            500 Cos[Rational[13, 60] Pi], (-500) Sin[Rational[13, 60] Pi]}, {
            500 Cos[Rational[7, 30] Pi], (-500) Sin[Rational[7, 30] Pi]}, {
            250 2^Rational[1, 2], (-250) 2^Rational[1, 2]}, {
            500 Sin[Rational[7, 30] Pi], (-500) Cos[Rational[7, 30] Pi]}, {
            500 Sin[Rational[13, 60] Pi], (-500) Cos[Rational[13, 60] Pi]}, {
            500 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2], 125 (-1 - 5^Rational[1, 2])}, {
            500 Sin[Rational[11, 60] Pi], (-500) Cos[Rational[11, 60] Pi]}, {
            250, (-250) 3^Rational[1, 2]}, {
            500 Sin[Rational[3, 20] Pi], (-500) Cos[Rational[3, 20] Pi]}, {
            500 Sin[Rational[2, 15] Pi], (-500) Cos[Rational[2, 15] Pi]}, {
            500 Sin[Rational[7, 60] Pi], (-500) Cos[Rational[7, 60] Pi]}, {
            125 (-1 + 5^Rational[1, 2]), (-500) (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
            125 2^Rational[1, 2] (-1 + 3^Rational[1, 2]), (-125) 
             2^Rational[1, 2] (1 + 3^Rational[1, 2])}, {
            500 Sin[Rational[1, 15] Pi], (-500) Cos[Rational[1, 15] Pi]}, {
            500 Sin[Rational[1, 20] Pi], (-500) Cos[Rational[1, 20] Pi]}, {
            500 Sin[Rational[1, 30] Pi], (-500) Cos[Rational[1, 30] Pi]}, {
            500 Sin[Rational[1, 60] Pi], (-500) Cos[Rational[1, 60] Pi]}, {
            0, -500}, {(-500) Sin[Rational[1, 60] Pi], (-500) 
             Cos[Rational[1, 60] Pi]}, {(-500) 
             Sin[Rational[1, 30] Pi], (-500) 
             Cos[Rational[1, 30] Pi]}, {(-500) 
             Sin[Rational[1, 20] Pi], (-500) 
             Cos[Rational[1, 20] Pi]}, {(-500) 
             Sin[Rational[1, 15] Pi], (-500) 
             Cos[Rational[1, 15] Pi]}, {(-125) 
             2^Rational[1, 2] (-1 + 3^Rational[1, 2]), (-125) 
             2^Rational[1, 2] (1 + 3^Rational[1, 2])}, {
            125 (1 - 5^
              Rational[1, 2]), (-500) (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {(-500) 
             Sin[Rational[7, 60] Pi], (-500) 
             Cos[Rational[7, 60] Pi]}, {(-500) 
             Sin[Rational[2, 15] Pi], (-500) 
             Cos[Rational[2, 15] Pi]}, {(-500) 
             Sin[Rational[3, 20] Pi], (-500) 
             Cos[Rational[3, 20] Pi]}, {-250, (-250) 
             3^Rational[1, 2]}, {(-500) Sin[Rational[11, 60] Pi], (-500) 
             Cos[Rational[11, 60] Pi]}, {(-500) (Rational[5, 8] + 
               Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
             125 (-1 - 5^Rational[1, 2])}, {(-500) 
             Sin[Rational[13, 60] Pi], (-500) 
             Cos[Rational[13, 60] Pi]}, {(-500) 
             Sin[Rational[7, 30] Pi], (-500) 
             Cos[Rational[7, 30] Pi]}, {(-250) 2^Rational[1, 2], (-250) 
             2^Rational[1, 2]}, {(-500) Cos[Rational[7, 30] Pi], (-500) 
             Sin[Rational[7, 30] Pi]}, {(-500) 
             Cos[Rational[13, 60] Pi], (-500) Sin[Rational[13, 60] Pi]}, {
            125 (-1 - 5^
              Rational[1, 2]), (-500) (Rational[5, 8] + 
               Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {(-500) 
             Cos[Rational[11, 60] Pi], (-500) 
             Sin[Rational[11, 60] Pi]}, {(-250) 
             3^Rational[1, 2], -250}, {(-500) Cos[Rational[3, 20] Pi], (-500) 
             Sin[Rational[3, 20] Pi]}, {(-500) 
             Cos[Rational[2, 15] Pi], (-500) 
             Sin[Rational[2, 15] Pi]}, {(-500) 
             Cos[Rational[7, 60] Pi], (-500) 
             Sin[Rational[7, 60] Pi]}, {(-500) (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
             125 (1 - 5^Rational[1, 2])}, {(-125) 
             2^Rational[1, 2] (1 + 3^Rational[1, 2]), (-125) 
             2^Rational[1, 2] (-1 + 3^Rational[1, 2])}, {(-500) 
             Cos[Rational[1, 15] Pi], (-500) 
             Sin[Rational[1, 15] Pi]}, {(-500) 
             Cos[Rational[1, 20] Pi], (-500) 
             Sin[Rational[1, 20] Pi]}, {(-500) 
             Cos[Rational[1, 30] Pi], (-500) 
             Sin[Rational[1, 30] Pi]}, {(-500) 
             Cos[Rational[1, 60] Pi], (-500) Sin[Rational[1, 60] Pi]}, {-500, 
            0}, {(-500) Cos[Rational[1, 60] Pi], 500 
             Sin[Rational[1, 60] Pi]}, {(-500) Cos[Rational[1, 30] Pi], 500 
             Sin[Rational[1, 30] Pi]}, {(-500) Cos[Rational[1, 20] Pi], 500 
             Sin[Rational[1, 20] Pi]}, {(-500) Cos[Rational[1, 15] Pi], 500 
             Sin[Rational[1, 15] Pi]}, {(-125) 
             2^Rational[1, 2] (1 + 3^Rational[1, 2]), 125 
             2^Rational[1, 2] (-1 + 
              3^Rational[1, 2])}, {(-500) (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
             125 (-1 + 5^Rational[1, 2])}, {(-500) Cos[Rational[7, 60] Pi], 
             500 Sin[Rational[7, 60] Pi]}, {(-500) Cos[Rational[2, 15] Pi], 
             500 Sin[Rational[2, 15] Pi]}, {(-500) Cos[Rational[3, 20] Pi], 
             500 Sin[Rational[3, 20] Pi]}, {(-250) 3^Rational[1, 2], 
             250}, {(-500) Cos[Rational[11, 60] Pi], 500 
             Sin[Rational[11, 60] Pi]}, {
            125 (-1 - 5^Rational[1, 2]), 
             500 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {(-500) Cos[Rational[13, 60] Pi], 500 
             Sin[Rational[13, 60] Pi]}, {(-500) Cos[Rational[7, 30] Pi], 500 
             Sin[Rational[7, 30] Pi]}, {(-250) 2^Rational[1, 2], 250 
             2^Rational[1, 2]}, {(-500) Sin[Rational[7, 30] Pi], 500 
             Cos[Rational[7, 30] Pi]}, {(-500) Sin[Rational[13, 60] Pi], 500 
             Cos[Rational[13, 60] Pi]}, {(-500) (Rational[5, 8] + 
               Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
             125 (1 + 5^Rational[1, 2])}, {(-500) Sin[Rational[11, 60] Pi], 
             500 Cos[Rational[11, 60] Pi]}, {-250, 250 
             3^Rational[1, 2]}, {(-500) Sin[Rational[3, 20] Pi], 500 
             Cos[Rational[3, 20] Pi]}, {(-500) Sin[Rational[2, 15] Pi], 500 
             Cos[Rational[2, 15] Pi]}, {(-500) Sin[Rational[7, 60] Pi], 500 
             Cos[Rational[7, 60] Pi]}, {
            125 (1 - 5^Rational[1, 2]), 
             500 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {(-125) 
             2^Rational[1, 2] (-1 + 3^Rational[1, 2]), 125 
             2^Rational[1, 2] (1 + 3^Rational[1, 2])}, {(-500) 
             Sin[Rational[1, 15] Pi], 500 Cos[Rational[1, 15] Pi]}, {(-500) 
             Sin[Rational[1, 20] Pi], 500 Cos[Rational[1, 20] Pi]}, {(-500) 
             Sin[Rational[1, 30] Pi], 500 Cos[Rational[1, 30] Pi]}, {(-500) 
             Sin[Rational[1, 60] Pi], 500 Cos[Rational[1, 60] Pi]}, {0, 
            500}}, {{0, 500}, {26.167978121471915`, 499.3147673772869}, {
            52.264231633826725`, 497.2609476841366}, {78.21723252011543, 
            493.8441702975689}, {103.95584540887965`, 489.07380036690284`}, {
            129.40952255126038`, 482.9629131445341}, {154.50849718747372`, 
            475.52825814757676`}, {179.18397477265015`, 466.7902132486009}, {
            203.36832153790007`, 456.77272882130046`}, {226.99524986977337`, 
            445.5032620941839}, {250, 433.0127018922193}, {
            272.31951750751347`, 419.33528397271203`}, {293.8926261462366, 
            404.5084971874737}, {314.6601955249188, 388.5729807284854}, {
            334.5653031794291, 371.5724127386971}, {353.5533905932738, 
            353.5533905932738}, {371.5724127386971, 334.5653031794291}, {
            388.5729807284854, 314.6601955249188}, {404.5084971874737, 
            293.8926261462366}, {419.33528397271203`, 272.31951750751347`}, {
            433.0127018922193, 250}, {445.5032620941839, 
            226.99524986977337`}, {456.77272882130046`, 
            203.36832153790007`}, {466.7902132486009, 179.18397477265015`}, {
            475.52825814757676`, 154.50849718747372`}, {482.9629131445341, 
            129.40952255126038`}, {489.07380036690284`, 
            103.95584540887965`}, {493.8441702975689, 78.21723252011543}, {
            497.2609476841366, 52.264231633826725`}, {499.3147673772869, 
            26.167978121471915`}, {500, 0}, {
            499.3147673772869, -26.167978121471915`}, {
            497.2609476841366, -52.264231633826725`}, {
            493.8441702975689, -78.21723252011543}, {
            489.07380036690284`, -103.95584540887965`}, {
            482.9629131445341, -129.40952255126038`}, {
            475.52825814757676`, -154.50849718747372`}, {
            466.7902132486009, -179.18397477265015`}, {
            456.77272882130046`, -203.36832153790007`}, {
            445.5032620941839, -226.99524986977337`}, {
            433.0127018922193, -250}, {
            419.33528397271203`, -272.31951750751347`}, {
            404.5084971874737, -293.8926261462366}, {
            388.5729807284854, -314.6601955249188}, {
            371.5724127386971, -334.5653031794291}, {
            353.5533905932738, -353.5533905932738}, {
            334.5653031794291, -371.5724127386971}, {
            314.6601955249188, -388.5729807284854}, {
            293.8926261462366, -404.5084971874737}, {
            272.31951750751347`, -419.33528397271203`}, {
            250, -433.0127018922193}, {
            226.99524986977337`, -445.5032620941839}, {
            203.36832153790007`, -456.77272882130046`}, {
            179.18397477265015`, -466.7902132486009}, {
            154.50849718747372`, -475.52825814757676`}, {
            129.40952255126038`, -482.9629131445341}, {
            103.95584540887965`, -489.07380036690284`}, {
            78.21723252011543, -493.8441702975689}, {
            52.264231633826725`, -497.2609476841366}, {
            26.167978121471915`, -499.3147673772869}, {
            0, -500}, {-26.167978121471915`, -499.3147673772869}, \
{-52.264231633826725`, -497.2609476841366}, {-78.21723252011543, \
-493.8441702975689}, {-103.95584540887965`, -489.07380036690284`}, \
{-129.40952255126038`, -482.9629131445341}, {-154.50849718747372`, \
-475.52825814757676`}, {-179.18397477265015`, -466.7902132486009}, \
{-203.36832153790007`, -456.77272882130046`}, {-226.99524986977337`, \
-445.5032620941839}, {-250, -433.0127018922193}, {-272.31951750751347`, \
-419.33528397271203`}, {-293.8926261462366, -404.5084971874737}, \
{-314.6601955249188, -388.5729807284854}, {-334.5653031794291, \
-371.5724127386971}, {-353.5533905932738, -353.5533905932738}, \
{-371.5724127386971, -334.5653031794291}, {-388.5729807284854, \
-314.6601955249188}, {-404.5084971874737, -293.8926261462366}, \
{-419.33528397271203`, -272.31951750751347`}, {-433.0127018922193, -250}, \
{-445.5032620941839, -226.99524986977337`}, {-456.77272882130046`, \
-203.36832153790007`}, {-466.7902132486009, -179.18397477265015`}, \
{-475.52825814757676`, -154.50849718747372`}, {-482.9629131445341, \
-129.40952255126038`}, {-489.07380036690284`, -103.95584540887965`}, \
{-493.8441702975689, -78.21723252011543}, {-497.2609476841366, \
-52.264231633826725`}, {-499.3147673772869, -26.167978121471915`}, {-500, 
            0}, {-499.3147673772869, 
            26.167978121471915`}, {-497.2609476841366, 
            52.264231633826725`}, {-493.8441702975689, 
            78.21723252011543}, {-489.07380036690284`, 
            103.95584540887965`}, {-482.9629131445341, 
            129.40952255126038`}, {-475.52825814757676`, 
            154.50849718747372`}, {-466.7902132486009, 
            179.18397477265015`}, {-456.77272882130046`, 
            203.36832153790007`}, {-445.5032620941839, 
            226.99524986977337`}, {-433.0127018922193, 
             250}, {-419.33528397271203`, 
            272.31951750751347`}, {-404.5084971874737, 
            293.8926261462366}, {-388.5729807284854, 
            314.6601955249188}, {-371.5724127386971, 
            334.5653031794291}, {-353.5533905932738, 
            353.5533905932738}, {-334.5653031794291, 
            371.5724127386971}, {-314.6601955249188, 
            388.5729807284854}, {-293.8926261462366, 
            404.5084971874737}, {-272.31951750751347`, 
            419.33528397271203`}, {-250, 
             433.0127018922193}, {-226.99524986977337`, 
            445.5032620941839}, {-203.36832153790007`, 
            456.77272882130046`}, {-179.18397477265015`, 
            466.7902132486009}, {-154.50849718747372`, 
            475.52825814757676`}, {-129.40952255126038`, 
            482.9629131445341}, {-103.95584540887965`, 
            489.07380036690284`}, {-78.21723252011543, 
            493.8441702975689}, {-52.264231633826725`, 
            497.2609476841366}, {-26.167978121471915`, 499.3147673772869}, {0,
             500}}]], 
         BezierCurveBox[
          NCache[{{0, Rational[1000, 3]}, {
            Rational[1000, 3] Sin[Rational[1, 60] Pi], Rational[1000, 3] 
             Cos[Rational[1, 60] Pi]}, {
            Rational[1000, 3] Sin[Rational[1, 30] Pi], Rational[1000, 3] 
             Cos[Rational[1, 30] Pi]}, {
            Rational[1000, 3] Sin[Rational[1, 20] Pi], Rational[1000, 3] 
             Cos[Rational[1, 20] Pi]}, {
            Rational[1000, 3] Sin[Rational[1, 15] Pi], Rational[1000, 3] 
             Cos[Rational[1, 15] Pi]}, {
            Rational[250, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2]), 
             Rational[250, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2])}, {
            Rational[250, 3] (-1 + 5^Rational[1, 2]), 
             Rational[
              1000, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {
            Rational[1000, 3] Sin[Rational[7, 60] Pi], Rational[1000, 3] 
             Cos[Rational[7, 60] Pi]}, {
            Rational[1000, 3] Sin[Rational[2, 15] Pi], Rational[1000, 3] 
             Cos[Rational[2, 15] Pi]}, {
            Rational[1000, 3] Sin[Rational[3, 20] Pi], Rational[1000, 3] 
             Cos[Rational[3, 20] Pi]}, {
            Rational[500, 3], 500 3^Rational[-1, 2]}, {
            Rational[1000, 3] Sin[Rational[11, 60] Pi], Rational[1000, 3] 
             Cos[Rational[11, 60] Pi]}, {
            Rational[
              1000, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[250, 3] (1 + 5^Rational[1, 2])}, {
            Rational[1000, 3] Sin[Rational[13, 60] Pi], Rational[1000, 3] 
             Cos[Rational[13, 60] Pi]}, {
            Rational[1000, 3] Sin[Rational[7, 30] Pi], Rational[1000, 3] 
             Cos[Rational[7, 30] Pi]}, {
            Rational[500, 3] 2^Rational[1, 2], Rational[500, 3] 
             2^Rational[1, 2]}, {
            Rational[1000, 3] Cos[Rational[7, 30] Pi], Rational[1000, 3] 
             Sin[Rational[7, 30] Pi]}, {
            Rational[1000, 3] Cos[Rational[13, 60] Pi], Rational[1000, 3] 
             Sin[Rational[13, 60] Pi]}, {
            Rational[250, 3] (1 + 5^Rational[1, 2]), 
             Rational[
              1000, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {
            Rational[1000, 3] Cos[Rational[11, 60] Pi], Rational[1000, 3] 
             Sin[Rational[11, 60] Pi]}, {
            500 3^Rational[-1, 2], Rational[500, 3]}, {
            Rational[1000, 3] Cos[Rational[3, 20] Pi], Rational[1000, 3] 
             Sin[Rational[3, 20] Pi]}, {
            Rational[1000, 3] Cos[Rational[2, 15] Pi], Rational[1000, 3] 
             Sin[Rational[2, 15] Pi]}, {
            Rational[1000, 3] Cos[Rational[7, 60] Pi], Rational[1000, 3] 
             Sin[Rational[7, 60] Pi]}, {
            Rational[
              1000, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[250, 3] (-1 + 5^Rational[1, 2])}, {
            Rational[250, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2]), 
             Rational[250, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2])}, {
            Rational[1000, 3] Cos[Rational[1, 15] Pi], Rational[1000, 3] 
             Sin[Rational[1, 15] Pi]}, {
            Rational[1000, 3] Cos[Rational[1, 20] Pi], Rational[1000, 3] 
             Sin[Rational[1, 20] Pi]}, {
            Rational[1000, 3] Cos[Rational[1, 30] Pi], Rational[1000, 3] 
             Sin[Rational[1, 30] Pi]}, {
            Rational[1000, 3] Cos[Rational[1, 60] Pi], Rational[1000, 3] 
             Sin[Rational[1, 60] Pi]}, {Rational[1000, 3], 0}, {
            Rational[1000, 3] Cos[Rational[1, 60] Pi], Rational[-1000, 3] 
             Sin[Rational[1, 60] Pi]}, {
            Rational[1000, 3] Cos[Rational[1, 30] Pi], Rational[-1000, 3] 
             Sin[Rational[1, 30] Pi]}, {
            Rational[1000, 3] Cos[Rational[1, 20] Pi], Rational[-1000, 3] 
             Sin[Rational[1, 20] Pi]}, {
            Rational[1000, 3] Cos[Rational[1, 15] Pi], Rational[-1000, 3] 
             Sin[Rational[1, 15] Pi]}, {
            Rational[250, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2]), 
             Rational[-250, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2])}, {
            Rational[
              1000, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[250, 3] (1 - 5^Rational[1, 2])}, {
            Rational[1000, 3] Cos[Rational[7, 60] Pi], Rational[-1000, 3] 
             Sin[Rational[7, 60] Pi]}, {
            Rational[1000, 3] Cos[Rational[2, 15] Pi], Rational[-1000, 3] 
             Sin[Rational[2, 15] Pi]}, {
            Rational[1000, 3] Cos[Rational[3, 20] Pi], Rational[-1000, 3] 
             Sin[Rational[3, 20] Pi]}, {
            500 3^Rational[-1, 2], Rational[-500, 3]}, {
            Rational[1000, 3] Cos[Rational[11, 60] Pi], Rational[-1000, 3] 
             Sin[Rational[11, 60] Pi]}, {
            Rational[250, 3] (1 + 5^Rational[1, 2]), 
             Rational[-1000, 3] (Rational[5, 8] + 
               Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
            Rational[1000, 3] Cos[Rational[13, 60] Pi], Rational[-1000, 3] 
             Sin[Rational[13, 60] Pi]}, {
            Rational[1000, 3] Cos[Rational[7, 30] Pi], Rational[-1000, 3] 
             Sin[Rational[7, 30] Pi]}, {
            Rational[500, 3] 2^Rational[1, 2], Rational[-500, 3] 
             2^Rational[1, 2]}, {
            Rational[1000, 3] Sin[Rational[7, 30] Pi], Rational[-1000, 3] 
             Cos[Rational[7, 30] Pi]}, {
            Rational[1000, 3] Sin[Rational[13, 60] Pi], Rational[-1000, 3] 
             Cos[Rational[13, 60] Pi]}, {
            Rational[
              1000, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[250, 3] (-1 - 5^Rational[1, 2])}, {
            Rational[1000, 3] Sin[Rational[11, 60] Pi], Rational[-1000, 3] 
             Cos[Rational[11, 60] Pi]}, {
            Rational[500, 3], (-500) 3^Rational[-1, 2]}, {
            Rational[1000, 3] Sin[Rational[3, 20] Pi], Rational[-1000, 3] 
             Cos[Rational[3, 20] Pi]}, {
            Rational[1000, 3] Sin[Rational[2, 15] Pi], Rational[-1000, 3] 
             Cos[Rational[2, 15] Pi]}, {
            Rational[1000, 3] Sin[Rational[7, 60] Pi], Rational[-1000, 3] 
             Cos[Rational[7, 60] Pi]}, {
            Rational[250, 3] (-1 + 5^Rational[1, 2]), 
             Rational[-1000, 3] (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
            Rational[250, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2]), 
             Rational[-250, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2])}, {
            Rational[1000, 3] Sin[Rational[1, 15] Pi], Rational[-1000, 3] 
             Cos[Rational[1, 15] Pi]}, {
            Rational[1000, 3] Sin[Rational[1, 20] Pi], Rational[-1000, 3] 
             Cos[Rational[1, 20] Pi]}, {
            Rational[1000, 3] Sin[Rational[1, 30] Pi], Rational[-1000, 3] 
             Cos[Rational[1, 30] Pi]}, {
            Rational[1000, 3] Sin[Rational[1, 60] Pi], Rational[-1000, 3] 
             Cos[Rational[1, 60] Pi]}, {0, Rational[-1000, 3]}, {
            Rational[-1000, 3] Sin[Rational[1, 60] Pi], Rational[-1000, 3] 
             Cos[Rational[1, 60] Pi]}, {
            Rational[-1000, 3] Sin[Rational[1, 30] Pi], Rational[-1000, 3] 
             Cos[Rational[1, 30] Pi]}, {
            Rational[-1000, 3] Sin[Rational[1, 20] Pi], Rational[-1000, 3] 
             Cos[Rational[1, 20] Pi]}, {
            Rational[-1000, 3] Sin[Rational[1, 15] Pi], Rational[-1000, 3] 
             Cos[Rational[1, 15] Pi]}, {
            Rational[-250, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2]), 
             Rational[-250, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2])}, {
            Rational[250, 3] (1 - 5^Rational[1, 2]), 
             Rational[-1000, 3] (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
            Rational[-1000, 3] Sin[Rational[7, 60] Pi], Rational[-1000, 3] 
             Cos[Rational[7, 60] Pi]}, {
            Rational[-1000, 3] Sin[Rational[2, 15] Pi], Rational[-1000, 3] 
             Cos[Rational[2, 15] Pi]}, {
            Rational[-1000, 3] Sin[Rational[3, 20] Pi], Rational[-1000, 3] 
             Cos[Rational[3, 20] Pi]}, {
            Rational[-500, 3], (-500) 3^Rational[-1, 2]}, {
            Rational[-1000, 3] Sin[Rational[11, 60] Pi], Rational[-1000, 3] 
             Cos[Rational[11, 60] Pi]}, {
            Rational[-1000, 3] (Rational[5, 8] + 
               Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[250, 3] (-1 - 5^Rational[1, 2])}, {
            Rational[-1000, 3] Sin[Rational[13, 60] Pi], Rational[-1000, 3] 
             Cos[Rational[13, 60] Pi]}, {
            Rational[-1000, 3] Sin[Rational[7, 30] Pi], Rational[-1000, 3] 
             Cos[Rational[7, 30] Pi]}, {
            Rational[-500, 3] 2^Rational[1, 2], Rational[-500, 3] 
             2^Rational[1, 2]}, {
            Rational[-1000, 3] Cos[Rational[7, 30] Pi], Rational[-1000, 3] 
             Sin[Rational[7, 30] Pi]}, {
            Rational[-1000, 3] Cos[Rational[13, 60] Pi], Rational[-1000, 3] 
             Sin[Rational[13, 60] Pi]}, {
            Rational[250, 3] (-1 - 5^Rational[1, 2]), 
             Rational[-1000, 3] (Rational[5, 8] + 
               Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
            Rational[-1000, 3] Cos[Rational[11, 60] Pi], Rational[-1000, 3] 
             Sin[Rational[11, 60] Pi]}, {(-500) 3^Rational[-1, 2], 
             Rational[-500, 3]}, {
            Rational[-1000, 3] Cos[Rational[3, 20] Pi], Rational[-1000, 3] 
             Sin[Rational[3, 20] Pi]}, {
            Rational[-1000, 3] Cos[Rational[2, 15] Pi], Rational[-1000, 3] 
             Sin[Rational[2, 15] Pi]}, {
            Rational[-1000, 3] Cos[Rational[7, 60] Pi], Rational[-1000, 3] 
             Sin[Rational[7, 60] Pi]}, {
            Rational[-1000, 3] (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[250, 3] (1 - 5^Rational[1, 2])}, {
            Rational[-250, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2]), 
             Rational[-250, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2])}, {
            Rational[-1000, 3] Cos[Rational[1, 15] Pi], Rational[-1000, 3] 
             Sin[Rational[1, 15] Pi]}, {
            Rational[-1000, 3] Cos[Rational[1, 20] Pi], Rational[-1000, 3] 
             Sin[Rational[1, 20] Pi]}, {
            Rational[-1000, 3] Cos[Rational[1, 30] Pi], Rational[-1000, 3] 
             Sin[Rational[1, 30] Pi]}, {
            Rational[-1000, 3] Cos[Rational[1, 60] Pi], Rational[-1000, 3] 
             Sin[Rational[1, 60] Pi]}, {Rational[-1000, 3], 0}, {
            Rational[-1000, 3] Cos[Rational[1, 60] Pi], Rational[1000, 3] 
             Sin[Rational[1, 60] Pi]}, {
            Rational[-1000, 3] Cos[Rational[1, 30] Pi], Rational[1000, 3] 
             Sin[Rational[1, 30] Pi]}, {
            Rational[-1000, 3] Cos[Rational[1, 20] Pi], Rational[1000, 3] 
             Sin[Rational[1, 20] Pi]}, {
            Rational[-1000, 3] Cos[Rational[1, 15] Pi], Rational[1000, 3] 
             Sin[Rational[1, 15] Pi]}, {
            Rational[-250, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2]), 
             Rational[250, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2])}, {
            Rational[-1000, 3] (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[250, 3] (-1 + 5^Rational[1, 2])}, {
            Rational[-1000, 3] Cos[Rational[7, 60] Pi], Rational[1000, 3] 
             Sin[Rational[7, 60] Pi]}, {
            Rational[-1000, 3] Cos[Rational[2, 15] Pi], Rational[1000, 3] 
             Sin[Rational[2, 15] Pi]}, {
            Rational[-1000, 3] Cos[Rational[3, 20] Pi], Rational[1000, 3] 
             Sin[Rational[3, 20] Pi]}, {(-500) 3^Rational[-1, 2], Rational[
             500, 3]}, {
            Rational[-1000, 3] Cos[Rational[11, 60] Pi], Rational[1000, 3] 
             Sin[Rational[11, 60] Pi]}, {
            Rational[250, 3] (-1 - 5^Rational[1, 2]), 
             Rational[
              1000, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {
            Rational[-1000, 3] Cos[Rational[13, 60] Pi], Rational[1000, 3] 
             Sin[Rational[13, 60] Pi]}, {
            Rational[-1000, 3] Cos[Rational[7, 30] Pi], Rational[1000, 3] 
             Sin[Rational[7, 30] Pi]}, {
            Rational[-500, 3] 2^Rational[1, 2], Rational[500, 3] 
             2^Rational[1, 2]}, {
            Rational[-1000, 3] Sin[Rational[7, 30] Pi], Rational[1000, 3] 
             Cos[Rational[7, 30] Pi]}, {
            Rational[-1000, 3] Sin[Rational[13, 60] Pi], Rational[1000, 3] 
             Cos[Rational[13, 60] Pi]}, {
            Rational[-1000, 3] (Rational[5, 8] + 
               Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[250, 3] (1 + 5^Rational[1, 2])}, {
            Rational[-1000, 3] Sin[Rational[11, 60] Pi], Rational[1000, 3] 
             Cos[Rational[11, 60] Pi]}, {
            Rational[-500, 3], 500 3^Rational[-1, 2]}, {
            Rational[-1000, 3] Sin[Rational[3, 20] Pi], Rational[1000, 3] 
             Cos[Rational[3, 20] Pi]}, {
            Rational[-1000, 3] Sin[Rational[2, 15] Pi], Rational[1000, 3] 
             Cos[Rational[2, 15] Pi]}, {
            Rational[-1000, 3] Sin[Rational[7, 60] Pi], Rational[1000, 3] 
             Cos[Rational[7, 60] Pi]}, {
            Rational[250, 3] (1 - 5^Rational[1, 2]), 
             Rational[
              1000, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {
            Rational[-250, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2]), 
             Rational[250, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2])}, {
            Rational[-1000, 3] Sin[Rational[1, 15] Pi], Rational[1000, 3] 
             Cos[Rational[1, 15] Pi]}, {
            Rational[-1000, 3] Sin[Rational[1, 20] Pi], Rational[1000, 3] 
             Cos[Rational[1, 20] Pi]}, {
            Rational[-1000, 3] Sin[Rational[1, 30] Pi], Rational[1000, 3] 
             Cos[Rational[1, 30] Pi]}, {
            Rational[-1000, 3] Sin[Rational[1, 60] Pi], Rational[1000, 3] 
             Cos[Rational[1, 60] Pi]}, {0, Rational[1000, 3]}}, {{
            0, 333.3333333333333}, {17.445318747647942`, 
            332.87651158485795`}, {34.842821089217814`, 
            331.50729845609106`}, {52.14482168007695, 329.22944686504593`}, {
            69.30389693925311, 326.0492002446019}, {86.27301503417358, 
            321.9752754296894}, {103.00566479164914`, 317.01883876505116`}, {
            119.45598318176675`, 311.19347549906723`}, {135.5788810252667, 
            304.5151525475336}, {151.3301665798489, 297.00217472945593`}, {
            166.66666666666666`, 288.6751345948129}, {181.546345005009, 
            279.556855981808}, {195.92841743082437`, 269.6723314583158}, {
            209.77346368327915`, 259.04865381899026`}, {223.04353545295274`, 
            247.71494182579806`}, {235.70226039551585`, 
            235.70226039551585`}, {247.71494182579806`, 
            223.04353545295274`}, {259.04865381899026`, 
            209.77346368327915`}, {269.6723314583158, 195.92841743082437`}, {
            279.556855981808, 181.546345005009}, {288.6751345948129, 
            166.66666666666666`}, {297.00217472945593`, 151.3301665798489}, {
            304.5151525475336, 135.5788810252667}, {311.19347549906723`, 
            119.45598318176675`}, {317.01883876505116`, 
            103.00566479164914`}, {321.9752754296894, 86.27301503417358}, {
            326.0492002446019, 69.30389693925311}, {329.22944686504593`, 
            52.14482168007695}, {331.50729845609106`, 34.842821089217814`}, {
            332.87651158485795`, 17.445318747647942`}, {
            333.3333333333333, 0}, {
            332.87651158485795`, -17.445318747647942`}, {
            331.50729845609106`, -34.842821089217814`}, {
            329.22944686504593`, -52.14482168007695}, {
            326.0492002446019, -69.30389693925311}, {
            321.9752754296894, -86.27301503417358}, {
            317.01883876505116`, -103.00566479164914`}, {
            311.19347549906723`, -119.45598318176675`}, {
            304.5151525475336, -135.5788810252667}, {
            297.00217472945593`, -151.3301665798489}, {
            288.6751345948129, -166.66666666666666`}, {
            279.556855981808, -181.546345005009}, {
            269.6723314583158, -195.92841743082437`}, {
            259.04865381899026`, -209.77346368327915`}, {
            247.71494182579806`, -223.04353545295274`}, {
            235.70226039551585`, -235.70226039551585`}, {
            223.04353545295274`, -247.71494182579806`}, {
            209.77346368327915`, -259.04865381899026`}, {
            195.92841743082437`, -269.6723314583158}, {
            181.546345005009, -279.556855981808}, {
            166.66666666666666`, -288.6751345948129}, {
            151.3301665798489, -297.00217472945593`}, {
            135.5788810252667, -304.5151525475336}, {
            119.45598318176675`, -311.19347549906723`}, {
            103.00566479164914`, -317.01883876505116`}, {
            86.27301503417358, -321.9752754296894}, {
            69.30389693925311, -326.0492002446019}, {
            52.14482168007695, -329.22944686504593`}, {
            34.842821089217814`, -331.50729845609106`}, {
            17.445318747647942`, -332.87651158485795`}, {
            0, -333.3333333333333}, {-17.445318747647942`, \
-332.87651158485795`}, {-34.842821089217814`, -331.50729845609106`}, \
{-52.14482168007695, -329.22944686504593`}, {-69.30389693925311, \
-326.0492002446019}, {-86.27301503417358, -321.9752754296894}, \
{-103.00566479164914`, -317.01883876505116`}, {-119.45598318176675`, \
-311.19347549906723`}, {-135.5788810252667, -304.5151525475336}, \
{-151.3301665798489, -297.00217472945593`}, {-166.66666666666666`, \
-288.6751345948129}, {-181.546345005009, -279.556855981808}, \
{-195.92841743082437`, -269.6723314583158}, {-209.77346368327915`, \
-259.04865381899026`}, {-223.04353545295274`, -247.71494182579806`}, \
{-235.70226039551585`, -235.70226039551585`}, {-247.71494182579806`, \
-223.04353545295274`}, {-259.04865381899026`, -209.77346368327915`}, \
{-269.6723314583158, -195.92841743082437`}, {-279.556855981808, \
-181.546345005009}, {-288.6751345948129, -166.66666666666666`}, \
{-297.00217472945593`, -151.3301665798489}, {-304.5151525475336, \
-135.5788810252667}, {-311.19347549906723`, -119.45598318176675`}, \
{-317.01883876505116`, -103.00566479164914`}, {-321.9752754296894, \
-86.27301503417358}, {-326.0492002446019, -69.30389693925311}, \
{-329.22944686504593`, -52.14482168007695}, {-331.50729845609106`, \
-34.842821089217814`}, {-332.87651158485795`, -17.445318747647942`}, \
{-333.3333333333333, 0}, {-332.87651158485795`, 
            17.445318747647942`}, {-331.50729845609106`, 
            34.842821089217814`}, {-329.22944686504593`, 
            52.14482168007695}, {-326.0492002446019, 
            69.30389693925311}, {-321.9752754296894, 
            86.27301503417358}, {-317.01883876505116`, 
            103.00566479164914`}, {-311.19347549906723`, 
            119.45598318176675`}, {-304.5151525475336, 
            135.5788810252667}, {-297.00217472945593`, 
            151.3301665798489}, {-288.6751345948129, 
            166.66666666666666`}, {-279.556855981808, 
            181.546345005009}, {-269.6723314583158, 
            195.92841743082437`}, {-259.04865381899026`, 
            209.77346368327915`}, {-247.71494182579806`, 
            223.04353545295274`}, {-235.70226039551585`, 
            235.70226039551585`}, {-223.04353545295274`, 
            247.71494182579806`}, {-209.77346368327915`, 
            259.04865381899026`}, {-195.92841743082437`, 
            269.6723314583158}, {-181.546345005009, 
            279.556855981808}, {-166.66666666666666`, 
            288.6751345948129}, {-151.3301665798489, 
            297.00217472945593`}, {-135.5788810252667, 
            304.5151525475336}, {-119.45598318176675`, 
            311.19347549906723`}, {-103.00566479164914`, 
            317.01883876505116`}, {-86.27301503417358, 
            321.9752754296894}, {-69.30389693925311, 
            326.0492002446019}, {-52.14482168007695, 
            329.22944686504593`}, {-34.842821089217814`, 
            331.50729845609106`}, {-17.445318747647942`, 
            332.87651158485795`}, {0, 333.3333333333333}}]], 
         BezierCurveBox[
          NCache[{{0, Rational[500, 3]}, {
            Rational[500, 3] Sin[Rational[1, 60] Pi], Rational[500, 3] 
             Cos[Rational[1, 60] Pi]}, {
            Rational[500, 3] Sin[Rational[1, 30] Pi], Rational[500, 3] 
             Cos[Rational[1, 30] Pi]}, {
            Rational[500, 3] Sin[Rational[1, 20] Pi], Rational[500, 3] 
             Cos[Rational[1, 20] Pi]}, {
            Rational[500, 3] Sin[Rational[1, 15] Pi], Rational[500, 3] 
             Cos[Rational[1, 15] Pi]}, {
            Rational[125, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2]), 
             Rational[125, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2])}, {
            Rational[125, 3] (-1 + 5^Rational[1, 2]), 
             Rational[
              500, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {
            Rational[500, 3] Sin[Rational[7, 60] Pi], Rational[500, 3] 
             Cos[Rational[7, 60] Pi]}, {
            Rational[500, 3] Sin[Rational[2, 15] Pi], Rational[500, 3] 
             Cos[Rational[2, 15] Pi]}, {
            Rational[500, 3] Sin[Rational[3, 20] Pi], Rational[500, 3] 
             Cos[Rational[3, 20] Pi]}, {
            Rational[250, 3], 250 3^Rational[-1, 2]}, {
            Rational[500, 3] Sin[Rational[11, 60] Pi], Rational[500, 3] 
             Cos[Rational[11, 60] Pi]}, {
            Rational[
              500, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[125, 3] (1 + 5^Rational[1, 2])}, {
            Rational[500, 3] Sin[Rational[13, 60] Pi], Rational[500, 3] 
             Cos[Rational[13, 60] Pi]}, {
            Rational[500, 3] Sin[Rational[7, 30] Pi], Rational[500, 3] 
             Cos[Rational[7, 30] Pi]}, {
            Rational[250, 3] 2^Rational[1, 2], Rational[250, 3] 
             2^Rational[1, 2]}, {
            Rational[500, 3] Cos[Rational[7, 30] Pi], Rational[500, 3] 
             Sin[Rational[7, 30] Pi]}, {
            Rational[500, 3] Cos[Rational[13, 60] Pi], Rational[500, 3] 
             Sin[Rational[13, 60] Pi]}, {
            Rational[125, 3] (1 + 5^Rational[1, 2]), 
             Rational[
              500, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {
            Rational[500, 3] Cos[Rational[11, 60] Pi], Rational[500, 3] 
             Sin[Rational[11, 60] Pi]}, {
            250 3^Rational[-1, 2], Rational[250, 3]}, {
            Rational[500, 3] Cos[Rational[3, 20] Pi], Rational[500, 3] 
             Sin[Rational[3, 20] Pi]}, {
            Rational[500, 3] Cos[Rational[2, 15] Pi], Rational[500, 3] 
             Sin[Rational[2, 15] Pi]}, {
            Rational[500, 3] Cos[Rational[7, 60] Pi], Rational[500, 3] 
             Sin[Rational[7, 60] Pi]}, {
            Rational[
              500, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[125, 3] (-1 + 5^Rational[1, 2])}, {
            Rational[125, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2]), 
             Rational[125, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2])}, {
            Rational[500, 3] Cos[Rational[1, 15] Pi], Rational[500, 3] 
             Sin[Rational[1, 15] Pi]}, {
            Rational[500, 3] Cos[Rational[1, 20] Pi], Rational[500, 3] 
             Sin[Rational[1, 20] Pi]}, {
            Rational[500, 3] Cos[Rational[1, 30] Pi], Rational[500, 3] 
             Sin[Rational[1, 30] Pi]}, {
            Rational[500, 3] Cos[Rational[1, 60] Pi], Rational[500, 3] 
             Sin[Rational[1, 60] Pi]}, {Rational[500, 3], 0}, {
            Rational[500, 3] Cos[Rational[1, 60] Pi], Rational[-500, 3] 
             Sin[Rational[1, 60] Pi]}, {
            Rational[500, 3] Cos[Rational[1, 30] Pi], Rational[-500, 3] 
             Sin[Rational[1, 30] Pi]}, {
            Rational[500, 3] Cos[Rational[1, 20] Pi], Rational[-500, 3] 
             Sin[Rational[1, 20] Pi]}, {
            Rational[500, 3] Cos[Rational[1, 15] Pi], Rational[-500, 3] 
             Sin[Rational[1, 15] Pi]}, {
            Rational[125, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2]), 
             Rational[-125, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2])}, {
            Rational[
              500, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[125, 3] (1 - 5^Rational[1, 2])}, {
            Rational[500, 3] Cos[Rational[7, 60] Pi], Rational[-500, 3] 
             Sin[Rational[7, 60] Pi]}, {
            Rational[500, 3] Cos[Rational[2, 15] Pi], Rational[-500, 3] 
             Sin[Rational[2, 15] Pi]}, {
            Rational[500, 3] Cos[Rational[3, 20] Pi], Rational[-500, 3] 
             Sin[Rational[3, 20] Pi]}, {
            250 3^Rational[-1, 2], Rational[-250, 3]}, {
            Rational[500, 3] Cos[Rational[11, 60] Pi], Rational[-500, 3] 
             Sin[Rational[11, 60] Pi]}, {
            Rational[125, 3] (1 + 5^Rational[1, 2]), 
             Rational[-500, 3] (Rational[5, 8] + 
               Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
            Rational[500, 3] Cos[Rational[13, 60] Pi], Rational[-500, 3] 
             Sin[Rational[13, 60] Pi]}, {
            Rational[500, 3] Cos[Rational[7, 30] Pi], Rational[-500, 3] 
             Sin[Rational[7, 30] Pi]}, {
            Rational[250, 3] 2^Rational[1, 2], Rational[-250, 3] 
             2^Rational[1, 2]}, {
            Rational[500, 3] Sin[Rational[7, 30] Pi], Rational[-500, 3] 
             Cos[Rational[7, 30] Pi]}, {
            Rational[500, 3] Sin[Rational[13, 60] Pi], Rational[-500, 3] 
             Cos[Rational[13, 60] Pi]}, {
            Rational[
              500, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[125, 3] (-1 - 5^Rational[1, 2])}, {
            Rational[500, 3] Sin[Rational[11, 60] Pi], Rational[-500, 3] 
             Cos[Rational[11, 60] Pi]}, {
            Rational[250, 3], (-250) 3^Rational[-1, 2]}, {
            Rational[500, 3] Sin[Rational[3, 20] Pi], Rational[-500, 3] 
             Cos[Rational[3, 20] Pi]}, {
            Rational[500, 3] Sin[Rational[2, 15] Pi], Rational[-500, 3] 
             Cos[Rational[2, 15] Pi]}, {
            Rational[500, 3] Sin[Rational[7, 60] Pi], Rational[-500, 3] 
             Cos[Rational[7, 60] Pi]}, {
            Rational[125, 3] (-1 + 5^Rational[1, 2]), 
             Rational[-500, 3] (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
            Rational[125, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2]), 
             Rational[-125, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2])}, {
            Rational[500, 3] Sin[Rational[1, 15] Pi], Rational[-500, 3] 
             Cos[Rational[1, 15] Pi]}, {
            Rational[500, 3] Sin[Rational[1, 20] Pi], Rational[-500, 3] 
             Cos[Rational[1, 20] Pi]}, {
            Rational[500, 3] Sin[Rational[1, 30] Pi], Rational[-500, 3] 
             Cos[Rational[1, 30] Pi]}, {
            Rational[500, 3] Sin[Rational[1, 60] Pi], Rational[-500, 3] 
             Cos[Rational[1, 60] Pi]}, {0, Rational[-500, 3]}, {
            Rational[-500, 3] Sin[Rational[1, 60] Pi], Rational[-500, 3] 
             Cos[Rational[1, 60] Pi]}, {
            Rational[-500, 3] Sin[Rational[1, 30] Pi], Rational[-500, 3] 
             Cos[Rational[1, 30] Pi]}, {
            Rational[-500, 3] Sin[Rational[1, 20] Pi], Rational[-500, 3] 
             Cos[Rational[1, 20] Pi]}, {
            Rational[-500, 3] Sin[Rational[1, 15] Pi], Rational[-500, 3] 
             Cos[Rational[1, 15] Pi]}, {
            Rational[-125, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2]), 
             Rational[-125, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2])}, {
            Rational[125, 3] (1 - 5^Rational[1, 2]), 
             Rational[-500, 3] (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
            Rational[-500, 3] Sin[Rational[7, 60] Pi], Rational[-500, 3] 
             Cos[Rational[7, 60] Pi]}, {
            Rational[-500, 3] Sin[Rational[2, 15] Pi], Rational[-500, 3] 
             Cos[Rational[2, 15] Pi]}, {
            Rational[-500, 3] Sin[Rational[3, 20] Pi], Rational[-500, 3] 
             Cos[Rational[3, 20] Pi]}, {
            Rational[-250, 3], (-250) 3^Rational[-1, 2]}, {
            Rational[-500, 3] Sin[Rational[11, 60] Pi], Rational[-500, 3] 
             Cos[Rational[11, 60] Pi]}, {
            Rational[-500, 3] (Rational[5, 8] + 
               Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[125, 3] (-1 - 5^Rational[1, 2])}, {
            Rational[-500, 3] Sin[Rational[13, 60] Pi], Rational[-500, 3] 
             Cos[Rational[13, 60] Pi]}, {
            Rational[-500, 3] Sin[Rational[7, 30] Pi], Rational[-500, 3] 
             Cos[Rational[7, 30] Pi]}, {
            Rational[-250, 3] 2^Rational[1, 2], Rational[-250, 3] 
             2^Rational[1, 2]}, {
            Rational[-500, 3] Cos[Rational[7, 30] Pi], Rational[-500, 3] 
             Sin[Rational[7, 30] Pi]}, {
            Rational[-500, 3] Cos[Rational[13, 60] Pi], Rational[-500, 3] 
             Sin[Rational[13, 60] Pi]}, {
            Rational[125, 3] (-1 - 5^Rational[1, 2]), 
             Rational[-500, 3] (Rational[5, 8] + 
               Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
            Rational[-500, 3] Cos[Rational[11, 60] Pi], Rational[-500, 3] 
             Sin[Rational[11, 60] Pi]}, {(-250) 3^Rational[-1, 2], 
             Rational[-250, 3]}, {
            Rational[-500, 3] Cos[Rational[3, 20] Pi], Rational[-500, 3] 
             Sin[Rational[3, 20] Pi]}, {
            Rational[-500, 3] Cos[Rational[2, 15] Pi], Rational[-500, 3] 
             Sin[Rational[2, 15] Pi]}, {
            Rational[-500, 3] Cos[Rational[7, 60] Pi], Rational[-500, 3] 
             Sin[Rational[7, 60] Pi]}, {
            Rational[-500, 3] (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[125, 3] (1 - 5^Rational[1, 2])}, {
            Rational[-125, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2]), 
             Rational[-125, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2])}, {
            Rational[-500, 3] Cos[Rational[1, 15] Pi], Rational[-500, 3] 
             Sin[Rational[1, 15] Pi]}, {
            Rational[-500, 3] Cos[Rational[1, 20] Pi], Rational[-500, 3] 
             Sin[Rational[1, 20] Pi]}, {
            Rational[-500, 3] Cos[Rational[1, 30] Pi], Rational[-500, 3] 
             Sin[Rational[1, 30] Pi]}, {
            Rational[-500, 3] Cos[Rational[1, 60] Pi], Rational[-500, 3] 
             Sin[Rational[1, 60] Pi]}, {Rational[-500, 3], 0}, {
            Rational[-500, 3] Cos[Rational[1, 60] Pi], Rational[500, 3] 
             Sin[Rational[1, 60] Pi]}, {
            Rational[-500, 3] Cos[Rational[1, 30] Pi], Rational[500, 3] 
             Sin[Rational[1, 30] Pi]}, {
            Rational[-500, 3] Cos[Rational[1, 20] Pi], Rational[500, 3] 
             Sin[Rational[1, 20] Pi]}, {
            Rational[-500, 3] Cos[Rational[1, 15] Pi], Rational[500, 3] 
             Sin[Rational[1, 15] Pi]}, {
            Rational[-125, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2]), 
             Rational[125, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2])}, {
            Rational[-500, 3] (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[125, 3] (-1 + 5^Rational[1, 2])}, {
            Rational[-500, 3] Cos[Rational[7, 60] Pi], Rational[500, 3] 
             Sin[Rational[7, 60] Pi]}, {
            Rational[-500, 3] Cos[Rational[2, 15] Pi], Rational[500, 3] 
             Sin[Rational[2, 15] Pi]}, {
            Rational[-500, 3] Cos[Rational[3, 20] Pi], Rational[500, 3] 
             Sin[Rational[3, 20] Pi]}, {(-250) 3^Rational[-1, 2], Rational[
             250, 3]}, {
            Rational[-500, 3] Cos[Rational[11, 60] Pi], Rational[500, 3] 
             Sin[Rational[11, 60] Pi]}, {
            Rational[125, 3] (-1 - 5^Rational[1, 2]), 
             Rational[
              500, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {
            Rational[-500, 3] Cos[Rational[13, 60] Pi], Rational[500, 3] 
             Sin[Rational[13, 60] Pi]}, {
            Rational[-500, 3] Cos[Rational[7, 30] Pi], Rational[500, 3] 
             Sin[Rational[7, 30] Pi]}, {
            Rational[-250, 3] 2^Rational[1, 2], Rational[250, 3] 
             2^Rational[1, 2]}, {
            Rational[-500, 3] Sin[Rational[7, 30] Pi], Rational[500, 3] 
             Cos[Rational[7, 30] Pi]}, {
            Rational[-500, 3] Sin[Rational[13, 60] Pi], Rational[500, 3] 
             Cos[Rational[13, 60] Pi]}, {
            Rational[-500, 3] (Rational[5, 8] + 
               Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[125, 3] (1 + 5^Rational[1, 2])}, {
            Rational[-500, 3] Sin[Rational[11, 60] Pi], Rational[500, 3] 
             Cos[Rational[11, 60] Pi]}, {
            Rational[-250, 3], 250 3^Rational[-1, 2]}, {
            Rational[-500, 3] Sin[Rational[3, 20] Pi], Rational[500, 3] 
             Cos[Rational[3, 20] Pi]}, {
            Rational[-500, 3] Sin[Rational[2, 15] Pi], Rational[500, 3] 
             Cos[Rational[2, 15] Pi]}, {
            Rational[-500, 3] Sin[Rational[7, 60] Pi], Rational[500, 3] 
             Cos[Rational[7, 60] Pi]}, {
            Rational[125, 3] (1 - 5^Rational[1, 2]), 
             Rational[
              500, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {
            Rational[-125, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2]), 
             Rational[125, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2])}, {
            Rational[-500, 3] Sin[Rational[1, 15] Pi], Rational[500, 3] 
             Cos[Rational[1, 15] Pi]}, {
            Rational[-500, 3] Sin[Rational[1, 20] Pi], Rational[500, 3] 
             Cos[Rational[1, 20] Pi]}, {
            Rational[-500, 3] Sin[Rational[1, 30] Pi], Rational[500, 3] 
             Cos[Rational[1, 30] Pi]}, {
            Rational[-500, 3] Sin[Rational[1, 60] Pi], Rational[500, 3] 
             Cos[Rational[1, 60] Pi]}, {0, Rational[500, 3]}}, {{
            0, 166.66666666666666`}, {8.722659373823971, 
            166.43825579242898`}, {17.421410544608907`, 
            165.75364922804553`}, {26.072410840038476`, 
            164.61472343252296`}, {34.651948469626554`, 
            163.02460012230094`}, {43.13650751708679, 160.9876377148447}, {
            51.50283239582457, 158.50941938252558`}, {59.72799159088338, 
            155.59673774953362`}, {67.78944051263335, 152.2575762737668}, {
            75.66508328992445, 148.50108736472797`}, {83.33333333333333, 
            144.33756729740645`}, {90.7731725025045, 139.778427990904}, {
            97.96420871541218, 134.8361657291579}, {104.88673184163957`, 
            129.52432690949513`}, {111.52176772647637`, 
            123.85747091289903`}, {117.85113019775793`, 
            117.85113019775793`}, {123.85747091289903`, 
            111.52176772647637`}, {129.52432690949513`, 
            104.88673184163957`}, {134.8361657291579, 97.96420871541218}, {
            139.778427990904, 90.7731725025045}, {144.33756729740645`, 
            83.33333333333333}, {148.50108736472797`, 75.66508328992445}, {
            152.2575762737668, 67.78944051263335}, {155.59673774953362`, 
            59.72799159088338}, {158.50941938252558`, 51.50283239582457}, {
            160.9876377148447, 43.13650751708679}, {163.02460012230094`, 
            34.651948469626554`}, {164.61472343252296`, 
            26.072410840038476`}, {165.75364922804553`, 
            17.421410544608907`}, {166.43825579242898`, 8.722659373823971}, {
            166.66666666666666`, 0}, {
            166.43825579242898`, -8.722659373823971}, {
            165.75364922804553`, -17.421410544608907`}, {
            164.61472343252296`, -26.072410840038476`}, {
            163.02460012230094`, -34.651948469626554`}, {
            160.9876377148447, -43.13650751708679}, {
            158.50941938252558`, -51.50283239582457}, {
            155.59673774953362`, -59.72799159088338}, {
            152.2575762737668, -67.78944051263335}, {
            148.50108736472797`, -75.66508328992445}, {
            144.33756729740645`, -83.33333333333333}, {
            139.778427990904, -90.7731725025045}, {
            134.8361657291579, -97.96420871541218}, {
            129.52432690949513`, -104.88673184163957`}, {
            123.85747091289903`, -111.52176772647637`}, {
            117.85113019775793`, -117.85113019775793`}, {
            111.52176772647637`, -123.85747091289903`}, {
            104.88673184163957`, -129.52432690949513`}, {
            97.96420871541218, -134.8361657291579}, {
            90.7731725025045, -139.778427990904}, {
            83.33333333333333, -144.33756729740645`}, {
            75.66508328992445, -148.50108736472797`}, {
            67.78944051263335, -152.2575762737668}, {
            59.72799159088338, -155.59673774953362`}, {
            51.50283239582457, -158.50941938252558`}, {
            43.13650751708679, -160.9876377148447}, {
            34.651948469626554`, -163.02460012230094`}, {
            26.072410840038476`, -164.61472343252296`}, {
            17.421410544608907`, -165.75364922804553`}, {
            8.722659373823971, -166.43825579242898`}, {
            0, -166.66666666666666`}, {-8.722659373823971, \
-166.43825579242898`}, {-17.421410544608907`, -165.75364922804553`}, \
{-26.072410840038476`, -164.61472343252296`}, {-34.651948469626554`, \
-163.02460012230094`}, {-43.13650751708679, -160.9876377148447}, \
{-51.50283239582457, -158.50941938252558`}, {-59.72799159088338, \
-155.59673774953362`}, {-67.78944051263335, -152.2575762737668}, \
{-75.66508328992445, -148.50108736472797`}, {-83.33333333333333, \
-144.33756729740645`}, {-90.7731725025045, -139.778427990904}, \
{-97.96420871541218, -134.8361657291579}, {-104.88673184163957`, \
-129.52432690949513`}, {-111.52176772647637`, -123.85747091289903`}, \
{-117.85113019775793`, -117.85113019775793`}, {-123.85747091289903`, \
-111.52176772647637`}, {-129.52432690949513`, -104.88673184163957`}, \
{-134.8361657291579, -97.96420871541218}, {-139.778427990904, \
-90.7731725025045}, {-144.33756729740645`, -83.33333333333333}, \
{-148.50108736472797`, -75.66508328992445}, {-152.2575762737668, \
-67.78944051263335}, {-155.59673774953362`, -59.72799159088338}, \
{-158.50941938252558`, -51.50283239582457}, {-160.9876377148447, \
-43.13650751708679}, {-163.02460012230094`, -34.651948469626554`}, \
{-164.61472343252296`, -26.072410840038476`}, {-165.75364922804553`, \
-17.421410544608907`}, {-166.43825579242898`, -8.722659373823971}, \
{-166.66666666666666`, 0}, {-166.43825579242898`, 
            8.722659373823971}, {-165.75364922804553`, 
            17.421410544608907`}, {-164.61472343252296`, 
            26.072410840038476`}, {-163.02460012230094`, 
            34.651948469626554`}, {-160.9876377148447, 
            43.13650751708679}, {-158.50941938252558`, 
            51.50283239582457}, {-155.59673774953362`, 
            59.72799159088338}, {-152.2575762737668, 
            67.78944051263335}, {-148.50108736472797`, 
            75.66508328992445}, {-144.33756729740645`, 
            83.33333333333333}, {-139.778427990904, 
            90.7731725025045}, {-134.8361657291579, 
            97.96420871541218}, {-129.52432690949513`, 
            104.88673184163957`}, {-123.85747091289903`, 
            111.52176772647637`}, {-117.85113019775793`, 
            117.85113019775793`}, {-111.52176772647637`, 
            123.85747091289903`}, {-104.88673184163957`, 
            129.52432690949513`}, {-97.96420871541218, 
            134.8361657291579}, {-90.7731725025045, 
            139.778427990904}, {-83.33333333333333, 
            144.33756729740645`}, {-75.66508328992445, 
            148.50108736472797`}, {-67.78944051263335, 
            152.2575762737668}, {-59.72799159088338, 
            155.59673774953362`}, {-51.50283239582457, 
            158.50941938252558`}, {-43.13650751708679, 
            160.9876377148447}, {-34.651948469626554`, 
            163.02460012230094`}, {-26.072410840038476`, 
            164.61472343252296`}, {-17.421410544608907`, 
            165.75364922804553`}, {-8.722659373823971, 166.43825579242898`}, {
            0, 166.66666666666666`}}]]}}, {{{}, {}}, {}, {{}, 
         GraphicsComplexBox[CompressedData["
1:eJxdlAlU01cWhyNWLSKgLAVcUGhFELdBKSnTyAUxFIu2CRqlEk1sUknmT/KU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          "], {{}, {}, 
           {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
            0.009166666666666668], Thickness[0.01], 
            LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 
             17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 
             33, 34, 35, 36, 37}]}, 
           {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
            0.009166666666666668], Thickness[0.01], 
            LineBox[{38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
             52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 
             68, 69, 70, 71, 72, 73, 74}]}, 
           {RGBColor[0.560181, 0.691569, 0.194885], PointSize[
            0.009166666666666668], Thickness[0.01], 
            LineBox[{75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 
             89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 
             104, 105, 106, 107, 108, 109, 110, 
             111}]}}], {}, {}, {{}, {}}}, {}, {}, {{}, {}}, {}, {{{}, {}, {}, \
{}}, {}}}},
      ImageSize->600,
      ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], 
     TemplateBox[{GraphicsBox[{{
          Opacity[0.9], {
           LineBox[{{0, 0}, {0, 50}}], 
           LineBox[
            
            NCache[{{0, 0}, {25, 25 3^Rational[1, 2]}}, {{0, 0}, {
              25, 43.30127018922193}}]], 
           LineBox[
            
            NCache[{{0, 0}, {25 3^Rational[1, 2], 25}}, {{0, 0}, {
              43.30127018922193, 25}}]], 
           LineBox[{{0, 0}, {50, 0}}], 
           LineBox[
            
            NCache[{{0, 0}, {25 3^Rational[1, 2], -25}}, {{0, 0}, {
              43.30127018922193, -25}}]], 
           LineBox[
            
            NCache[{{0, 0}, {25, (-25) 3^Rational[1, 2]}}, {{0, 0}, {
              25, -43.30127018922193}}]], 
           LineBox[{{0, 0}, {0, -50}}], 
           LineBox[
            
            NCache[{{0, 0}, {-25, (-25) 3^Rational[1, 2]}}, {{0, 
              0}, {-25, -43.30127018922193}}]], 
           LineBox[
            
            NCache[{{0, 0}, {(-25) 3^Rational[1, 2], -25}}, {{0, 
              0}, {-43.30127018922193, -25}}]], 
           LineBox[{{0, 0}, {-50, 0}}], 
           LineBox[
            
            NCache[{{0, 0}, {(-25) 3^Rational[1, 2], 25}}, {{0, 
              0}, {-43.30127018922193, 25}}]], 
           LineBox[
            
            NCache[{{0, 0}, {-25, 25 3^Rational[1, 2]}}, {{0, 
              0}, {-25, 43.30127018922193}}]], 
           LineBox[{{0, 0}, {0, 50}}]}, {
           InsetBox[
            FormBox[
             StyleBox[
              
              TemplateBox[{"\"0\"", "\"\[Degree]\""}, "Superscript", 
               SyntaxForm -> SuperscriptBox], 30, StripOnInput -> False], 
             TraditionalForm], {55.00000000000001, 0.}], 
           InsetBox[
            FormBox[
             StyleBox[
              
              TemplateBox[{"\"30\"", "\"\[Degree]\""}, "Superscript", 
               SyntaxForm -> SuperscriptBox], 30, StripOnInput -> False], 
             TraditionalForm], {47.63139720814413, 27.500000000000004`}], 
           InsetBox[
            FormBox[
             StyleBox[
              
              TemplateBox[{"\"60\"", "\"\[Degree]\""}, "Superscript", 
               SyntaxForm -> SuperscriptBox], 30, StripOnInput -> False], 
             TraditionalForm], {27.500000000000004`, 47.63139720814413}], 
           InsetBox[
            FormBox[
             StyleBox[
              
              TemplateBox[{"\"90\"", "\"\[Degree]\""}, "Superscript", 
               SyntaxForm -> SuperscriptBox], 30, StripOnInput -> False], 
             TraditionalForm], {0., 55.00000000000001}], 
           InsetBox[
            FormBox[
             StyleBox[
              
              TemplateBox[{"\"120\"", "\"\[Degree]\""}, "Superscript", 
               SyntaxForm -> SuperscriptBox], 30, StripOnInput -> False], 
             TraditionalForm], {-27.500000000000004`, 47.63139720814413}], 
           InsetBox[
            FormBox[
             StyleBox[
              
              TemplateBox[{"\"150\"", "\"\[Degree]\""}, "Superscript", 
               SyntaxForm -> SuperscriptBox], 30, StripOnInput -> False], 
             TraditionalForm], {-47.63139720814413, 27.500000000000004`}], 
           InsetBox[
            FormBox[
             StyleBox[
              
              TemplateBox[{"\"180\"", "\"\[Degree]\""}, "Superscript", 
               SyntaxForm -> SuperscriptBox], 30, StripOnInput -> False], 
             TraditionalForm], {-55.00000000000001, 0.}], 
           InsetBox[
            FormBox[
             StyleBox[
              
              TemplateBox[{"\"210\"", "\"\[Degree]\""}, "Superscript", 
               SyntaxForm -> SuperscriptBox], 30, StripOnInput -> False], 
             TraditionalForm], {-47.63139720814413, -27.500000000000004`}], 
           InsetBox[
            FormBox[
             StyleBox[
              
              TemplateBox[{"\"240\"", "\"\[Degree]\""}, "Superscript", 
               SyntaxForm -> SuperscriptBox], 30, StripOnInput -> False], 
             TraditionalForm], {-27.500000000000004`, -47.63139720814413}], 
           InsetBox[
            FormBox[
             StyleBox[
              
              TemplateBox[{"\"270\"", "\"\[Degree]\""}, "Superscript", 
               SyntaxForm -> SuperscriptBox], 30, StripOnInput -> False], 
             TraditionalForm], {0., -55.00000000000001}], 
           InsetBox[
            FormBox[
             StyleBox[
              
              TemplateBox[{"\"300\"", "\"\[Degree]\""}, "Superscript", 
               SyntaxForm -> SuperscriptBox], 30, StripOnInput -> False], 
             TraditionalForm], {27.500000000000004`, -47.63139720814413}], 
           InsetBox[
            FormBox[
             StyleBox[
              
              TemplateBox[{"\"330\"", "\"\[Degree]\""}, "Superscript", 
               SyntaxForm -> SuperscriptBox], 30, StripOnInput -> False], 
             TraditionalForm], {47.63139720814413, -27.500000000000004`}]}, {
           BezierCurveBox[
            
            NCache[{{0, 50}, {
              50 Sin[Rational[1, 60] Pi], 50 Cos[Rational[1, 60] Pi]}, {
              50 Sin[Rational[1, 30] Pi], 50 Cos[Rational[1, 30] Pi]}, {
              50 Sin[Rational[1, 20] Pi], 50 Cos[Rational[1, 20] Pi]}, {
              50 Sin[Rational[1, 15] Pi], 50 Cos[Rational[1, 15] Pi]}, {
              25 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 25 
               2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
              Rational[25, 2] (-1 + 5^Rational[1, 2]), 
               50 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2]}, {
              50 Sin[Rational[7, 60] Pi], 50 Cos[Rational[7, 60] Pi]}, {
              50 Sin[Rational[2, 15] Pi], 50 Cos[Rational[2, 15] Pi]}, {
              50 Sin[Rational[3, 20] Pi], 50 Cos[Rational[3, 20] Pi]}, {
              25, 25 3^Rational[1, 2]}, {
              50 Sin[Rational[11, 60] Pi], 50 Cos[Rational[11, 60] Pi]}, {
              50 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], Rational[25, 2] (1 + 5^Rational[1, 2])}, {
              50 Sin[Rational[13, 60] Pi], 50 Cos[Rational[13, 60] Pi]}, {
              50 Sin[Rational[7, 30] Pi], 50 Cos[Rational[7, 30] Pi]}, {
              25 2^Rational[1, 2], 25 2^Rational[1, 2]}, {
              50 Cos[Rational[7, 30] Pi], 50 Sin[Rational[7, 30] Pi]}, {
              50 Cos[Rational[13, 60] Pi], 50 Sin[Rational[13, 60] Pi]}, {
              Rational[25, 2] (1 + 5^Rational[1, 2]), 
               50 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2]}, {
              50 Cos[Rational[11, 60] Pi], 50 Sin[Rational[11, 60] Pi]}, {
              25 3^Rational[1, 2], 25}, {
              50 Cos[Rational[3, 20] Pi], 50 Sin[Rational[3, 20] Pi]}, {
              50 Cos[Rational[2, 15] Pi], 50 Sin[Rational[2, 15] Pi]}, {
              50 Cos[Rational[7, 60] Pi], 50 Sin[Rational[7, 60] Pi]}, {
              50 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], Rational[25, 2] (-1 + 5^Rational[1, 2])}, {
              25 2^Rational[-1, 2] (1 + 3^Rational[1, 2]), 25 
               2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {
              50 Cos[Rational[1, 15] Pi], 50 Sin[Rational[1, 15] Pi]}, {
              50 Cos[Rational[1, 20] Pi], 50 Sin[Rational[1, 20] Pi]}, {
              50 Cos[Rational[1, 30] Pi], 50 Sin[Rational[1, 30] Pi]}, {
              50 Cos[Rational[1, 60] Pi], 50 Sin[Rational[1, 60] Pi]}, {50, 
              0}, {50 Cos[Rational[1, 60] Pi], (-50) 
               Sin[Rational[1, 60] Pi]}, {
              50 Cos[Rational[1, 30] Pi], (-50) Sin[Rational[1, 30] Pi]}, {
              50 Cos[Rational[1, 20] Pi], (-50) Sin[Rational[1, 20] Pi]}, {
              50 Cos[Rational[1, 15] Pi], (-50) Sin[Rational[1, 15] Pi]}, {
              25 2^Rational[-1, 2] (1 + 3^Rational[1, 2]), (-25) 
               2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {
              50 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], Rational[25, 2] (1 - 5^Rational[1, 2])}, {
              50 Cos[Rational[7, 60] Pi], (-50) Sin[Rational[7, 60] Pi]}, {
              50 Cos[Rational[2, 15] Pi], (-50) Sin[Rational[2, 15] Pi]}, {
              50 Cos[Rational[3, 20] Pi], (-50) Sin[Rational[3, 20] Pi]}, {
              25 3^Rational[1, 2], -25}, {
              50 Cos[Rational[11, 60] Pi], (-50) Sin[Rational[11, 60] Pi]}, {
              Rational[25, 2] (1 + 
                5^Rational[1, 2]), (-50) (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              50 Cos[Rational[13, 60] Pi], (-50) Sin[Rational[13, 60] Pi]}, {
              50 Cos[Rational[7, 30] Pi], (-50) Sin[Rational[7, 30] Pi]}, {
              25 2^Rational[1, 2], (-25) 2^Rational[1, 2]}, {
              50 Sin[Rational[7, 30] Pi], (-50) Cos[Rational[7, 30] Pi]}, {
              50 Sin[Rational[13, 60] Pi], (-50) Cos[Rational[13, 60] Pi]}, {
              50 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], Rational[25, 2] (-1 - 5^Rational[1, 2])}, {
              50 Sin[Rational[11, 60] Pi], (-50) Cos[Rational[11, 60] Pi]}, {
              25, (-25) 3^Rational[1, 2]}, {
              50 Sin[Rational[3, 20] Pi], (-50) Cos[Rational[3, 20] Pi]}, {
              50 Sin[Rational[2, 15] Pi], (-50) Cos[Rational[2, 15] Pi]}, {
              50 Sin[Rational[7, 60] Pi], (-50) Cos[Rational[7, 60] Pi]}, {
              Rational[25, 2] (-1 + 
                5^Rational[1, 2]), (-50) (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              25 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), (-25) 
               2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
              50 Sin[Rational[1, 15] Pi], (-50) Cos[Rational[1, 15] Pi]}, {
              50 Sin[Rational[1, 20] Pi], (-50) Cos[Rational[1, 20] Pi]}, {
              50 Sin[Rational[1, 30] Pi], (-50) Cos[Rational[1, 30] Pi]}, {
              50 Sin[Rational[1, 60] Pi], (-50) Cos[Rational[1, 60] Pi]}, {
              0, -50}, {(-50) Sin[Rational[1, 60] Pi], (-50) 
               Cos[Rational[1, 60] Pi]}, {(-50) 
               Sin[Rational[1, 30] Pi], (-50) 
               Cos[Rational[1, 30] Pi]}, {(-50) 
               Sin[Rational[1, 20] Pi], (-50) 
               Cos[Rational[1, 20] Pi]}, {(-50) 
               Sin[Rational[1, 15] Pi], (-50) 
               Cos[Rational[1, 15] Pi]}, {(-25) 
               2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), (-25) 
               2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
              Rational[25, 2] (1 - 5^
                Rational[1, 2]), (-50) (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {(-50) 
               Sin[Rational[7, 60] Pi], (-50) 
               Cos[Rational[7, 60] Pi]}, {(-50) 
               Sin[Rational[2, 15] Pi], (-50) 
               Cos[Rational[2, 15] Pi]}, {(-50) 
               Sin[Rational[3, 20] Pi], (-50) 
               Cos[Rational[3, 20] Pi]}, {-25, (-25) 
               3^Rational[1, 2]}, {(-50) Sin[Rational[11, 60] Pi], (-50) 
               Cos[Rational[11, 60] Pi]}, {(-50) (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[25, 2] (-1 - 5^Rational[1, 2])}, {(-50) 
               Sin[Rational[13, 60] Pi], (-50) 
               Cos[Rational[13, 60] Pi]}, {(-50) 
               Sin[Rational[7, 30] Pi], (-50) 
               Cos[Rational[7, 30] Pi]}, {(-25) 2^Rational[1, 2], (-25) 
               2^Rational[1, 2]}, {(-50) Cos[Rational[7, 30] Pi], (-50) 
               Sin[Rational[7, 30] Pi]}, {(-50) 
               Cos[Rational[13, 60] Pi], (-50) Sin[Rational[13, 60] Pi]}, {
              Rational[25, 2] (-1 - 5^
                Rational[1, 2]), (-50) (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {(-50) 
               Cos[Rational[11, 60] Pi], (-50) 
               Sin[Rational[11, 60] Pi]}, {(-25) 
               3^Rational[1, 2], -25}, {(-50) Cos[Rational[3, 20] Pi], (-50) 
               Sin[Rational[3, 20] Pi]}, {(-50) 
               Cos[Rational[2, 15] Pi], (-50) 
               Sin[Rational[2, 15] Pi]}, {(-50) 
               Cos[Rational[7, 60] Pi], (-50) 
               Sin[Rational[7, 60] Pi]}, {(-50) (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[25, 2] (1 - 5^Rational[1, 2])}, {(-25) 
               2^Rational[-1, 2] (1 + 3^Rational[1, 2]), (-25) 
               2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {(-50) 
               Cos[Rational[1, 15] Pi], (-50) 
               Sin[Rational[1, 15] Pi]}, {(-50) 
               Cos[Rational[1, 20] Pi], (-50) 
               Sin[Rational[1, 20] Pi]}, {(-50) 
               Cos[Rational[1, 30] Pi], (-50) 
               Sin[Rational[1, 30] Pi]}, {(-50) 
               Cos[Rational[1, 60] Pi], (-50) Sin[Rational[1, 60] Pi]}, {-50, 
              0}, {(-50) Cos[Rational[1, 60] Pi], 50 
               Sin[Rational[1, 60] Pi]}, {(-50) Cos[Rational[1, 30] Pi], 50 
               Sin[Rational[1, 30] Pi]}, {(-50) Cos[Rational[1, 20] Pi], 50 
               Sin[Rational[1, 20] Pi]}, {(-50) Cos[Rational[1, 15] Pi], 50 
               Sin[Rational[1, 15] Pi]}, {(-25) 
               2^Rational[-1, 2] (1 + 3^Rational[1, 2]), 25 
               2^Rational[-1, 2] (-1 + 
                3^Rational[1, 2])}, {(-50) (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[25, 2] (-1 + 5^Rational[1, 2])}, {(-50) 
               Cos[Rational[7, 60] Pi], 50 Sin[Rational[7, 60] Pi]}, {(-50) 
               Cos[Rational[2, 15] Pi], 50 Sin[Rational[2, 15] Pi]}, {(-50) 
               Cos[Rational[3, 20] Pi], 50 Sin[Rational[3, 20] Pi]}, {(-25) 
               3^Rational[1, 2], 25}, {(-50) Cos[Rational[11, 60] Pi], 50 
               Sin[Rational[11, 60] Pi]}, {
              Rational[25, 2] (-1 - 5^Rational[1, 2]), 
               50 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2]}, {(-50) Cos[Rational[13, 60] Pi], 50 
               Sin[Rational[13, 60] Pi]}, {(-50) Cos[Rational[7, 30] Pi], 50 
               Sin[Rational[7, 30] Pi]}, {(-25) 2^Rational[1, 2], 25 
               2^Rational[1, 2]}, {(-50) Sin[Rational[7, 30] Pi], 50 
               Cos[Rational[7, 30] Pi]}, {(-50) Sin[Rational[13, 60] Pi], 50 
               Cos[Rational[13, 60] Pi]}, {(-50) (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[25, 2] (1 + 5^Rational[1, 2])}, {(-50) 
               Sin[Rational[11, 60] Pi], 50 Cos[Rational[11, 60] Pi]}, {-25, 
               25 3^Rational[1, 2]}, {(-50) Sin[Rational[3, 20] Pi], 50 
               Cos[Rational[3, 20] Pi]}, {(-50) Sin[Rational[2, 15] Pi], 50 
               Cos[Rational[2, 15] Pi]}, {(-50) Sin[Rational[7, 60] Pi], 50 
               Cos[Rational[7, 60] Pi]}, {
              Rational[25, 2] (1 - 5^Rational[1, 2]), 
               50 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2]}, {(-25) 
               2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 25 
               2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {(-50) 
               Sin[Rational[1, 15] Pi], 50 Cos[Rational[1, 15] Pi]}, {(-50) 
               Sin[Rational[1, 20] Pi], 50 Cos[Rational[1, 20] Pi]}, {(-50) 
               Sin[Rational[1, 30] Pi], 50 Cos[Rational[1, 30] Pi]}, {(-50) 
               Sin[Rational[1, 60] Pi], 50 Cos[Rational[1, 60] Pi]}, {0, 
              50}}, {{0, 50}, {2.6167978121471913`, 49.931476737728694`}, {
              5.226423163382673, 49.72609476841367}, {7.821723252011544, 
              49.38441702975689}, {10.395584540887965`, 
              48.907380036690284`}, {12.940952255126033`, 
              48.296291314453406`}, {15.450849718747373`, 
              47.552825814757675`}, {17.918397477265014`, 
              46.67902132486009}, {20.336832153790006`, 45.67727288213004}, {
              22.699524986977337`, 44.550326209418394`}, {
              25, 43.30127018922193}, {27.23195175075135, 41.9335283972712}, {
              29.389262614623657`, 40.45084971874737}, {31.466019552491876`, 
              38.857298072848536`}, {33.456530317942914`, 
              37.157241273869715`}, {35.35533905932738, 35.35533905932738}, {
              37.157241273869715`, 33.456530317942914`}, {38.857298072848536`,
               31.466019552491876`}, {40.45084971874737, 
              29.389262614623657`}, {41.9335283972712, 27.23195175075135}, {
              43.30127018922193, 25}, {44.550326209418394`, 
              22.699524986977337`}, {45.67727288213004, 
              20.336832153790006`}, {46.67902132486009, 
              17.918397477265014`}, {47.552825814757675`, 
              15.450849718747373`}, {48.296291314453406`, 
              12.940952255126033`}, {48.907380036690284`, 
              10.395584540887965`}, {49.38441702975689, 7.821723252011544}, {
              49.72609476841367, 5.226423163382673}, {49.931476737728694`, 
              2.6167978121471913`}, {50, 0}, {
              49.931476737728694`, -2.6167978121471913`}, {
              49.72609476841367, -5.226423163382673}, {
              49.38441702975689, -7.821723252011544}, {
              48.907380036690284`, -10.395584540887965`}, {
              48.296291314453406`, -12.940952255126033`}, {
              47.552825814757675`, -15.450849718747373`}, {
              46.67902132486009, -17.918397477265014`}, {
              45.67727288213004, -20.336832153790006`}, {
              44.550326209418394`, -22.699524986977337`}, {
              43.30127018922193, -25}, {
              41.9335283972712, -27.23195175075135}, {
              40.45084971874737, -29.389262614623657`}, {
              38.857298072848536`, -31.466019552491876`}, {
              37.157241273869715`, -33.456530317942914`}, {
              35.35533905932738, -35.35533905932738}, {
              33.456530317942914`, -37.157241273869715`}, {
              31.466019552491876`, -38.857298072848536`}, {
              29.389262614623657`, -40.45084971874737}, {
              27.23195175075135, -41.9335283972712}, {
              25, -43.30127018922193}, {
              22.699524986977337`, -44.550326209418394`}, {
              20.336832153790006`, -45.67727288213004}, {
              17.918397477265014`, -46.67902132486009}, {
              15.450849718747373`, -47.552825814757675`}, {
              12.940952255126033`, -48.296291314453406`}, {
              10.395584540887965`, -48.907380036690284`}, {
              7.821723252011544, -49.38441702975689}, {
              5.226423163382673, -49.72609476841367}, {
              2.6167978121471913`, -49.931476737728694`}, {
              0, -50}, {-2.6167978121471913`, -49.931476737728694`}, \
{-5.226423163382673, -49.72609476841367}, {-7.821723252011544, \
-49.38441702975689}, {-10.395584540887965`, -48.907380036690284`}, \
{-12.940952255126033`, -48.296291314453406`}, {-15.450849718747373`, \
-47.552825814757675`}, {-17.918397477265014`, -46.67902132486009}, \
{-20.336832153790006`, -45.67727288213004}, {-22.699524986977337`, \
-44.550326209418394`}, {-25, -43.30127018922193}, {-27.23195175075135, \
-41.9335283972712}, {-29.389262614623657`, -40.45084971874737}, \
{-31.466019552491876`, -38.857298072848536`}, {-33.456530317942914`, \
-37.157241273869715`}, {-35.35533905932738, -35.35533905932738}, \
{-37.157241273869715`, -33.456530317942914`}, {-38.857298072848536`, \
-31.466019552491876`}, {-40.45084971874737, -29.389262614623657`}, \
{-41.9335283972712, -27.23195175075135}, {-43.30127018922193, -25}, \
{-44.550326209418394`, -22.699524986977337`}, {-45.67727288213004, \
-20.336832153790006`}, {-46.67902132486009, -17.918397477265014`}, \
{-47.552825814757675`, -15.450849718747373`}, {-48.296291314453406`, \
-12.940952255126033`}, {-48.907380036690284`, -10.395584540887965`}, \
{-49.38441702975689, -7.821723252011544}, {-49.72609476841367, \
-5.226423163382673}, {-49.931476737728694`, -2.6167978121471913`}, {-50, 
              0}, {-49.931476737728694`, 
              2.6167978121471913`}, {-49.72609476841367, 
              5.226423163382673}, {-49.38441702975689, 
              7.821723252011544}, {-48.907380036690284`, 
              10.395584540887965`}, {-48.296291314453406`, 
              12.940952255126033`}, {-47.552825814757675`, 
              15.450849718747373`}, {-46.67902132486009, 
              17.918397477265014`}, {-45.67727288213004, 
              20.336832153790006`}, {-44.550326209418394`, 
              22.699524986977337`}, {-43.30127018922193, 
               25}, {-41.9335283972712, 
              27.23195175075135}, {-40.45084971874737, 
              29.389262614623657`}, {-38.857298072848536`, 
              31.466019552491876`}, {-37.157241273869715`, 
              33.456530317942914`}, {-35.35533905932738, 
              35.35533905932738}, {-33.456530317942914`, 
              37.157241273869715`}, {-31.466019552491876`, 
              38.857298072848536`}, {-29.389262614623657`, 
              40.45084971874737}, {-27.23195175075135, 
              41.9335283972712}, {-25, 
               43.30127018922193}, {-22.699524986977337`, 
              44.550326209418394`}, {-20.336832153790006`, 
              45.67727288213004}, {-17.918397477265014`, 
              46.67902132486009}, {-15.450849718747373`, 
              47.552825814757675`}, {-12.940952255126033`, 
              48.296291314453406`}, {-10.395584540887965`, 
              48.907380036690284`}, {-7.821723252011544, 
              49.38441702975689}, {-5.226423163382673, 
              49.72609476841367}, {-2.6167978121471913`, 
              49.931476737728694`}, {0, 50}}]], 
           BezierCurveBox[
            NCache[{{0, 
               Rational[100, 3]}, {
              Rational[100, 3] Sin[Rational[1, 60] Pi], Rational[100, 3] 
               Cos[Rational[1, 60] Pi]}, {
              Rational[100, 3] Sin[Rational[1, 30] Pi], Rational[100, 3] 
               Cos[Rational[1, 30] Pi]}, {
              Rational[100, 3] Sin[Rational[1, 20] Pi], Rational[100, 3] 
               Cos[Rational[1, 20] Pi]}, {
              Rational[100, 3] Sin[Rational[1, 15] Pi], Rational[100, 3] 
               Cos[Rational[1, 15] Pi]}, {
              Rational[25, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2]), 
               Rational[25, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2])}, {
              Rational[25, 3] (-1 + 5^Rational[1, 2]), 
               Rational[
                100, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2]}, {
              Rational[100, 3] Sin[Rational[7, 60] Pi], Rational[100, 3] 
               Cos[Rational[7, 60] Pi]}, {
              Rational[100, 3] Sin[Rational[2, 15] Pi], Rational[100, 3] 
               Cos[Rational[2, 15] Pi]}, {
              Rational[100, 3] Sin[Rational[3, 20] Pi], Rational[100, 3] 
               Cos[Rational[3, 20] Pi]}, {
               Rational[50, 3], 50 3^Rational[-1, 2]}, {
              Rational[100, 3] Sin[Rational[11, 60] Pi], Rational[100, 3] 
               Cos[Rational[11, 60] Pi]}, {
              Rational[
                100, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], Rational[25, 3] (1 + 5^Rational[1, 2])}, {
              Rational[100, 3] Sin[Rational[13, 60] Pi], Rational[100, 3] 
               Cos[Rational[13, 60] Pi]}, {
              Rational[100, 3] Sin[Rational[7, 30] Pi], Rational[100, 3] 
               Cos[Rational[7, 30] Pi]}, {
              Rational[50, 3] 2^Rational[1, 2], Rational[50, 3] 
               2^Rational[1, 2]}, {
              Rational[100, 3] Cos[Rational[7, 30] Pi], Rational[100, 3] 
               Sin[Rational[7, 30] Pi]}, {
              Rational[100, 3] Cos[Rational[13, 60] Pi], Rational[100, 3] 
               Sin[Rational[13, 60] Pi]}, {
              Rational[25, 3] (1 + 5^Rational[1, 2]), 
               Rational[
                100, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2]}, {
              Rational[100, 3] Cos[Rational[11, 60] Pi], Rational[100, 3] 
               Sin[Rational[11, 60] Pi]}, {50 3^Rational[-1, 2], 
               Rational[50, 3]}, {
              Rational[100, 3] Cos[Rational[3, 20] Pi], Rational[100, 3] 
               Sin[Rational[3, 20] Pi]}, {
              Rational[100, 3] Cos[Rational[2, 15] Pi], Rational[100, 3] 
               Sin[Rational[2, 15] Pi]}, {
              Rational[100, 3] Cos[Rational[7, 60] Pi], Rational[100, 3] 
               Sin[Rational[7, 60] Pi]}, {
              Rational[
                100, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], Rational[25, 3] (-1 + 5^Rational[1, 2])}, {
              Rational[25, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2]), 
               Rational[25, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2])}, {
              Rational[100, 3] Cos[Rational[1, 15] Pi], Rational[100, 3] 
               Sin[Rational[1, 15] Pi]}, {
              Rational[100, 3] Cos[Rational[1, 20] Pi], Rational[100, 3] 
               Sin[Rational[1, 20] Pi]}, {
              Rational[100, 3] Cos[Rational[1, 30] Pi], Rational[100, 3] 
               Sin[Rational[1, 30] Pi]}, {
              Rational[100, 3] Cos[Rational[1, 60] Pi], Rational[100, 3] 
               Sin[Rational[1, 60] Pi]}, {
               Rational[100, 3], 0}, {
              Rational[100, 3] Cos[Rational[1, 60] Pi], Rational[-100, 3] 
               Sin[Rational[1, 60] Pi]}, {
              Rational[100, 3] Cos[Rational[1, 30] Pi], Rational[-100, 3] 
               Sin[Rational[1, 30] Pi]}, {
              Rational[100, 3] Cos[Rational[1, 20] Pi], Rational[-100, 3] 
               Sin[Rational[1, 20] Pi]}, {
              Rational[100, 3] Cos[Rational[1, 15] Pi], Rational[-100, 3] 
               Sin[Rational[1, 15] Pi]}, {
              Rational[25, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2]), 
               Rational[-25, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2])}, {
              Rational[
                100, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], Rational[25, 3] (1 - 5^Rational[1, 2])}, {
              Rational[100, 3] Cos[Rational[7, 60] Pi], Rational[-100, 3] 
               Sin[Rational[7, 60] Pi]}, {
              Rational[100, 3] Cos[Rational[2, 15] Pi], Rational[-100, 3] 
               Sin[Rational[2, 15] Pi]}, {
              Rational[100, 3] Cos[Rational[3, 20] Pi], Rational[-100, 3] 
               Sin[Rational[3, 20] Pi]}, {50 3^Rational[-1, 2], 
               Rational[-50, 3]}, {
              Rational[100, 3] Cos[Rational[11, 60] Pi], Rational[-100, 3] 
               Sin[Rational[11, 60] Pi]}, {
              Rational[25, 3] (1 + 5^Rational[1, 2]), 
               Rational[-100, 3] (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              Rational[100, 3] Cos[Rational[13, 60] Pi], Rational[-100, 3] 
               Sin[Rational[13, 60] Pi]}, {
              Rational[100, 3] Cos[Rational[7, 30] Pi], Rational[-100, 3] 
               Sin[Rational[7, 30] Pi]}, {
              Rational[50, 3] 2^Rational[1, 2], Rational[-50, 3] 
               2^Rational[1, 2]}, {
              Rational[100, 3] Sin[Rational[7, 30] Pi], Rational[-100, 3] 
               Cos[Rational[7, 30] Pi]}, {
              Rational[100, 3] Sin[Rational[13, 60] Pi], Rational[-100, 3] 
               Cos[Rational[13, 60] Pi]}, {
              Rational[
                100, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], Rational[25, 3] (-1 - 5^Rational[1, 2])}, {
              Rational[100, 3] Sin[Rational[11, 60] Pi], Rational[-100, 3] 
               Cos[Rational[11, 60] Pi]}, {
               Rational[50, 3], (-50) 3^Rational[-1, 2]}, {
              Rational[100, 3] Sin[Rational[3, 20] Pi], Rational[-100, 3] 
               Cos[Rational[3, 20] Pi]}, {
              Rational[100, 3] Sin[Rational[2, 15] Pi], Rational[-100, 3] 
               Cos[Rational[2, 15] Pi]}, {
              Rational[100, 3] Sin[Rational[7, 60] Pi], Rational[-100, 3] 
               Cos[Rational[7, 60] Pi]}, {
              Rational[25, 3] (-1 + 5^Rational[1, 2]), 
               Rational[-100, 3] (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              Rational[25, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2]), 
               Rational[-25, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2])}, {
              Rational[100, 3] Sin[Rational[1, 15] Pi], Rational[-100, 3] 
               Cos[Rational[1, 15] Pi]}, {
              Rational[100, 3] Sin[Rational[1, 20] Pi], Rational[-100, 3] 
               Cos[Rational[1, 20] Pi]}, {
              Rational[100, 3] Sin[Rational[1, 30] Pi], Rational[-100, 3] 
               Cos[Rational[1, 30] Pi]}, {
              Rational[100, 3] Sin[Rational[1, 60] Pi], Rational[-100, 3] 
               Cos[Rational[1, 60] Pi]}, {0, 
               Rational[-100, 3]}, {
              Rational[-100, 3] Sin[Rational[1, 60] Pi], Rational[-100, 3] 
               Cos[Rational[1, 60] Pi]}, {
              Rational[-100, 3] Sin[Rational[1, 30] Pi], Rational[-100, 3] 
               Cos[Rational[1, 30] Pi]}, {
              Rational[-100, 3] Sin[Rational[1, 20] Pi], Rational[-100, 3] 
               Cos[Rational[1, 20] Pi]}, {
              Rational[-100, 3] Sin[Rational[1, 15] Pi], Rational[-100, 3] 
               Cos[Rational[1, 15] Pi]}, {
              Rational[-25, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2]), 
               Rational[-25, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2])}, {
              Rational[25, 3] (1 - 5^Rational[1, 2]), 
               Rational[-100, 3] (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              Rational[-100, 3] Sin[Rational[7, 60] Pi], Rational[-100, 3] 
               Cos[Rational[7, 60] Pi]}, {
              Rational[-100, 3] Sin[Rational[2, 15] Pi], Rational[-100, 3] 
               Cos[Rational[2, 15] Pi]}, {
              Rational[-100, 3] Sin[Rational[3, 20] Pi], Rational[-100, 3] 
               Cos[Rational[3, 20] Pi]}, {
               Rational[-50, 3], (-50) 3^Rational[-1, 2]}, {
              Rational[-100, 3] Sin[Rational[11, 60] Pi], Rational[-100, 3] 
               Cos[Rational[11, 60] Pi]}, {
              Rational[-100, 3] (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[25, 3] (-1 - 5^Rational[1, 2])}, {
              Rational[-100, 3] Sin[Rational[13, 60] Pi], Rational[-100, 3] 
               Cos[Rational[13, 60] Pi]}, {
              Rational[-100, 3] Sin[Rational[7, 30] Pi], Rational[-100, 3] 
               Cos[Rational[7, 30] Pi]}, {
              Rational[-50, 3] 2^Rational[1, 2], Rational[-50, 3] 
               2^Rational[1, 2]}, {
              Rational[-100, 3] Cos[Rational[7, 30] Pi], Rational[-100, 3] 
               Sin[Rational[7, 30] Pi]}, {
              Rational[-100, 3] Cos[Rational[13, 60] Pi], Rational[-100, 3] 
               Sin[Rational[13, 60] Pi]}, {
              Rational[25, 3] (-1 - 5^Rational[1, 2]), 
               Rational[-100, 3] (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              Rational[-100, 3] Cos[Rational[11, 60] Pi], Rational[-100, 3] 
               Sin[Rational[11, 60] Pi]}, {(-50) 3^Rational[-1, 2], 
               Rational[-50, 3]}, {
              Rational[-100, 3] Cos[Rational[3, 20] Pi], Rational[-100, 3] 
               Sin[Rational[3, 20] Pi]}, {
              Rational[-100, 3] Cos[Rational[2, 15] Pi], Rational[-100, 3] 
               Sin[Rational[2, 15] Pi]}, {
              Rational[-100, 3] Cos[Rational[7, 60] Pi], Rational[-100, 3] 
               Sin[Rational[7, 60] Pi]}, {
              Rational[-100, 3] (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[25, 3] (1 - 5^Rational[1, 2])}, {
              Rational[-25, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2]), 
               Rational[-25, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2])}, {
              Rational[-100, 3] Cos[Rational[1, 15] Pi], Rational[-100, 3] 
               Sin[Rational[1, 15] Pi]}, {
              Rational[-100, 3] Cos[Rational[1, 20] Pi], Rational[-100, 3] 
               Sin[Rational[1, 20] Pi]}, {
              Rational[-100, 3] Cos[Rational[1, 30] Pi], Rational[-100, 3] 
               Sin[Rational[1, 30] Pi]}, {
              Rational[-100, 3] Cos[Rational[1, 60] Pi], Rational[-100, 3] 
               Sin[Rational[1, 60] Pi]}, {
               Rational[-100, 3], 0}, {
              Rational[-100, 3] Cos[Rational[1, 60] Pi], Rational[100, 3] 
               Sin[Rational[1, 60] Pi]}, {
              Rational[-100, 3] Cos[Rational[1, 30] Pi], Rational[100, 3] 
               Sin[Rational[1, 30] Pi]}, {
              Rational[-100, 3] Cos[Rational[1, 20] Pi], Rational[100, 3] 
               Sin[Rational[1, 20] Pi]}, {
              Rational[-100, 3] Cos[Rational[1, 15] Pi], Rational[100, 3] 
               Sin[Rational[1, 15] Pi]}, {
              Rational[-25, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2]), 
               Rational[25, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2])}, {
              Rational[-100, 3] (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[25, 3] (-1 + 5^Rational[1, 2])}, {
              Rational[-100, 3] Cos[Rational[7, 60] Pi], Rational[100, 3] 
               Sin[Rational[7, 60] Pi]}, {
              Rational[-100, 3] Cos[Rational[2, 15] Pi], Rational[100, 3] 
               Sin[Rational[2, 15] Pi]}, {
              Rational[-100, 3] Cos[Rational[3, 20] Pi], Rational[100, 3] 
               Sin[Rational[3, 20] Pi]}, {(-50) 3^Rational[-1, 2], 
               Rational[50, 3]}, {
              Rational[-100, 3] Cos[Rational[11, 60] Pi], Rational[100, 3] 
               Sin[Rational[11, 60] Pi]}, {
              Rational[25, 3] (-1 - 5^Rational[1, 2]), 
               Rational[
                100, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2]}, {
              Rational[-100, 3] Cos[Rational[13, 60] Pi], Rational[100, 3] 
               Sin[Rational[13, 60] Pi]}, {
              Rational[-100, 3] Cos[Rational[7, 30] Pi], Rational[100, 3] 
               Sin[Rational[7, 30] Pi]}, {
              Rational[-50, 3] 2^Rational[1, 2], Rational[50, 3] 
               2^Rational[1, 2]}, {
              Rational[-100, 3] Sin[Rational[7, 30] Pi], Rational[100, 3] 
               Cos[Rational[7, 30] Pi]}, {
              Rational[-100, 3] Sin[Rational[13, 60] Pi], Rational[100, 3] 
               Cos[Rational[13, 60] Pi]}, {
              Rational[-100, 3] (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[25, 3] (1 + 5^Rational[1, 2])}, {
              Rational[-100, 3] Sin[Rational[11, 60] Pi], Rational[100, 3] 
               Cos[Rational[11, 60] Pi]}, {
               Rational[-50, 3], 50 3^Rational[-1, 2]}, {
              Rational[-100, 3] Sin[Rational[3, 20] Pi], Rational[100, 3] 
               Cos[Rational[3, 20] Pi]}, {
              Rational[-100, 3] Sin[Rational[2, 15] Pi], Rational[100, 3] 
               Cos[Rational[2, 15] Pi]}, {
              Rational[-100, 3] Sin[Rational[7, 60] Pi], Rational[100, 3] 
               Cos[Rational[7, 60] Pi]}, {
              Rational[25, 3] (1 - 5^Rational[1, 2]), 
               Rational[
                100, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2]}, {
              Rational[-25, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2]), 
               Rational[25, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2])}, {
              Rational[-100, 3] Sin[Rational[1, 15] Pi], Rational[100, 3] 
               Cos[Rational[1, 15] Pi]}, {
              Rational[-100, 3] Sin[Rational[1, 20] Pi], Rational[100, 3] 
               Cos[Rational[1, 20] Pi]}, {
              Rational[-100, 3] Sin[Rational[1, 30] Pi], Rational[100, 3] 
               Cos[Rational[1, 30] Pi]}, {
              Rational[-100, 3] Sin[Rational[1, 60] Pi], Rational[100, 3] 
               Cos[Rational[1, 60] Pi]}, {0, 
               Rational[100, 3]}}, {{0, 33.333333333333336`}, {
              1.7445318747647944`, 33.287651158485794`}, {3.484282108921782, 
              33.15072984560911}, {5.214482168007696, 32.92294468650459}, {
              6.930389693925311, 32.60492002446019}, {8.627301503417359, 
              32.19752754296895}, {10.300566479164916`, 31.70188387650512}, {
              11.945598318176677`, 31.119347549906728`}, {13.557888102526674`,
               30.451515254753364`}, {15.133016657984893`, 
              29.7002174729456}, {16.666666666666668`, 28.86751345948129}, {
              18.1546345005009, 27.955685598180803`}, {19.592841743082438`, 
              26.967233145831585`}, {20.977346368327918`, 
              25.90486538189903}, {22.304353545295275`, 24.77149418257981}, {
              23.57022603955159, 23.57022603955159}, {24.77149418257981, 
              22.304353545295275`}, {25.90486538189903, 
              20.977346368327918`}, {26.967233145831585`, 
              19.592841743082438`}, {27.955685598180803`, 18.1546345005009}, {
              28.86751345948129, 16.666666666666668`}, {29.7002174729456, 
              15.133016657984893`}, {30.451515254753364`, 
              13.557888102526674`}, {31.119347549906728`, 
              11.945598318176677`}, {31.70188387650512, 
              10.300566479164916`}, {32.19752754296895, 8.627301503417359}, {
              32.60492002446019, 6.930389693925311}, {32.92294468650459, 
              5.214482168007696}, {33.15072984560911, 3.484282108921782}, {
              33.287651158485794`, 1.7445318747647944`}, {
              33.333333333333336`, 0}, {
              33.287651158485794`, -1.7445318747647944`}, {
              33.15072984560911, -3.484282108921782}, {
              32.92294468650459, -5.214482168007696}, {
              32.60492002446019, -6.930389693925311}, {
              32.19752754296895, -8.627301503417359}, {
              31.70188387650512, -10.300566479164916`}, {
              31.119347549906728`, -11.945598318176677`}, {
              30.451515254753364`, -13.557888102526674`}, {
              29.7002174729456, -15.133016657984893`}, {
              28.86751345948129, -16.666666666666668`}, {
              27.955685598180803`, -18.1546345005009}, {
              26.967233145831585`, -19.592841743082438`}, {
              25.90486538189903, -20.977346368327918`}, {
              24.77149418257981, -22.304353545295275`}, {
              23.57022603955159, -23.57022603955159}, {
              22.304353545295275`, -24.77149418257981}, {
              20.977346368327918`, -25.90486538189903}, {
              19.592841743082438`, -26.967233145831585`}, {
              18.1546345005009, -27.955685598180803`}, {
              16.666666666666668`, -28.86751345948129}, {
              15.133016657984893`, -29.7002174729456}, {
              13.557888102526674`, -30.451515254753364`}, {
              11.945598318176677`, -31.119347549906728`}, {
              10.300566479164916`, -31.70188387650512}, {
              8.627301503417359, -32.19752754296895}, {
              6.930389693925311, -32.60492002446019}, {
              5.214482168007696, -32.92294468650459}, {
              3.484282108921782, -33.15072984560911}, {
              1.7445318747647944`, -33.287651158485794`}, {
              0, -33.333333333333336`}, {-1.7445318747647944`, \
-33.287651158485794`}, {-3.484282108921782, -33.15072984560911}, \
{-5.214482168007696, -32.92294468650459}, {-6.930389693925311, \
-32.60492002446019}, {-8.627301503417359, -32.19752754296895}, \
{-10.300566479164916`, -31.70188387650512}, {-11.945598318176677`, \
-31.119347549906728`}, {-13.557888102526674`, -30.451515254753364`}, \
{-15.133016657984893`, -29.7002174729456}, {-16.666666666666668`, \
-28.86751345948129}, {-18.1546345005009, -27.955685598180803`}, \
{-19.592841743082438`, -26.967233145831585`}, {-20.977346368327918`, \
-25.90486538189903}, {-22.304353545295275`, -24.77149418257981}, \
{-23.57022603955159, -23.57022603955159}, {-24.77149418257981, \
-22.304353545295275`}, {-25.90486538189903, -20.977346368327918`}, \
{-26.967233145831585`, -19.592841743082438`}, {-27.955685598180803`, \
-18.1546345005009}, {-28.86751345948129, -16.666666666666668`}, \
{-29.7002174729456, -15.133016657984893`}, {-30.451515254753364`, \
-13.557888102526674`}, {-31.119347549906728`, -11.945598318176677`}, \
{-31.70188387650512, -10.300566479164916`}, {-32.19752754296895, \
-8.627301503417359}, {-32.60492002446019, -6.930389693925311}, \
{-32.92294468650459, -5.214482168007696}, {-33.15072984560911, \
-3.484282108921782}, {-33.287651158485794`, -1.7445318747647944`}, \
{-33.333333333333336`, 0}, {-33.287651158485794`, 
              1.7445318747647944`}, {-33.15072984560911, 
              3.484282108921782}, {-32.92294468650459, 
              5.214482168007696}, {-32.60492002446019, 
              6.930389693925311}, {-32.19752754296895, 
              8.627301503417359}, {-31.70188387650512, 
              10.300566479164916`}, {-31.119347549906728`, 
              11.945598318176677`}, {-30.451515254753364`, 
              13.557888102526674`}, {-29.7002174729456, 
              15.133016657984893`}, {-28.86751345948129, 
              16.666666666666668`}, {-27.955685598180803`, 
              18.1546345005009}, {-26.967233145831585`, 
              19.592841743082438`}, {-25.90486538189903, 
              20.977346368327918`}, {-24.77149418257981, 
              22.304353545295275`}, {-23.57022603955159, 
              23.57022603955159}, {-22.304353545295275`, 
              24.77149418257981}, {-20.977346368327918`, 
              25.90486538189903}, {-19.592841743082438`, 
              26.967233145831585`}, {-18.1546345005009, 
              27.955685598180803`}, {-16.666666666666668`, 
              28.86751345948129}, {-15.133016657984893`, 
              29.7002174729456}, {-13.557888102526674`, 
              30.451515254753364`}, {-11.945598318176677`, 
              31.119347549906728`}, {-10.300566479164916`, 
              31.70188387650512}, {-8.627301503417359, 
              32.19752754296895}, {-6.930389693925311, 
              32.60492002446019}, {-5.214482168007696, 
              32.92294468650459}, {-3.484282108921782, 
              33.15072984560911}, {-1.7445318747647944`, 
              33.287651158485794`}, {0, 33.333333333333336`}}]], 
           BezierCurveBox[
            NCache[{{0, 
               Rational[50, 3]}, {
              Rational[50, 3] Sin[Rational[1, 60] Pi], Rational[50, 3] 
               Cos[Rational[1, 60] Pi]}, {
              Rational[50, 3] Sin[Rational[1, 30] Pi], Rational[50, 3] 
               Cos[Rational[1, 30] Pi]}, {
              Rational[50, 3] Sin[Rational[1, 20] Pi], Rational[50, 3] 
               Cos[Rational[1, 20] Pi]}, {
              Rational[50, 3] Sin[Rational[1, 15] Pi], Rational[50, 3] 
               Cos[Rational[1, 15] Pi]}, {
              Rational[25, 3] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 
               Rational[25, 3] 2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
              Rational[25, 6] (-1 + 5^Rational[1, 2]), 
               Rational[
                50, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2]}, {
              Rational[50, 3] Sin[Rational[7, 60] Pi], Rational[50, 3] 
               Cos[Rational[7, 60] Pi]}, {
              Rational[50, 3] Sin[Rational[2, 15] Pi], Rational[50, 3] 
               Cos[Rational[2, 15] Pi]}, {
              Rational[50, 3] Sin[Rational[3, 20] Pi], Rational[50, 3] 
               Cos[Rational[3, 20] Pi]}, {
               Rational[25, 3], 25 3^Rational[-1, 2]}, {
              Rational[50, 3] Sin[Rational[11, 60] Pi], Rational[50, 3] 
               Cos[Rational[11, 60] Pi]}, {
              Rational[
                50, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], Rational[25, 6] (1 + 5^Rational[1, 2])}, {
              Rational[50, 3] Sin[Rational[13, 60] Pi], Rational[50, 3] 
               Cos[Rational[13, 60] Pi]}, {
              Rational[50, 3] Sin[Rational[7, 30] Pi], Rational[50, 3] 
               Cos[Rational[7, 30] Pi]}, {
              Rational[25, 3] 2^Rational[1, 2], Rational[25, 3] 
               2^Rational[1, 2]}, {
              Rational[50, 3] Cos[Rational[7, 30] Pi], Rational[50, 3] 
               Sin[Rational[7, 30] Pi]}, {
              Rational[50, 3] Cos[Rational[13, 60] Pi], Rational[50, 3] 
               Sin[Rational[13, 60] Pi]}, {
              Rational[25, 6] (1 + 5^Rational[1, 2]), 
               Rational[
                50, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2]}, {
              Rational[50, 3] Cos[Rational[11, 60] Pi], Rational[50, 3] 
               Sin[Rational[11, 60] Pi]}, {25 3^Rational[-1, 2], 
               Rational[25, 3]}, {
              Rational[50, 3] Cos[Rational[3, 20] Pi], Rational[50, 3] 
               Sin[Rational[3, 20] Pi]}, {
              Rational[50, 3] Cos[Rational[2, 15] Pi], Rational[50, 3] 
               Sin[Rational[2, 15] Pi]}, {
              Rational[50, 3] Cos[Rational[7, 60] Pi], Rational[50, 3] 
               Sin[Rational[7, 60] Pi]}, {
              Rational[
                50, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], Rational[25, 6] (-1 + 5^Rational[1, 2])}, {
              Rational[25, 3] 2^Rational[-1, 2] (1 + 3^Rational[1, 2]), 
               Rational[25, 3] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {
              Rational[50, 3] Cos[Rational[1, 15] Pi], Rational[50, 3] 
               Sin[Rational[1, 15] Pi]}, {
              Rational[50, 3] Cos[Rational[1, 20] Pi], Rational[50, 3] 
               Sin[Rational[1, 20] Pi]}, {
              Rational[50, 3] Cos[Rational[1, 30] Pi], Rational[50, 3] 
               Sin[Rational[1, 30] Pi]}, {
              Rational[50, 3] Cos[Rational[1, 60] Pi], Rational[50, 3] 
               Sin[Rational[1, 60] Pi]}, {
               Rational[50, 3], 0}, {
              Rational[50, 3] Cos[Rational[1, 60] Pi], Rational[-50, 3] 
               Sin[Rational[1, 60] Pi]}, {
              Rational[50, 3] Cos[Rational[1, 30] Pi], Rational[-50, 3] 
               Sin[Rational[1, 30] Pi]}, {
              Rational[50, 3] Cos[Rational[1, 20] Pi], Rational[-50, 3] 
               Sin[Rational[1, 20] Pi]}, {
              Rational[50, 3] Cos[Rational[1, 15] Pi], Rational[-50, 3] 
               Sin[Rational[1, 15] Pi]}, {
              Rational[25, 3] 2^Rational[-1, 2] (1 + 3^Rational[1, 2]), 
               Rational[-25, 3] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {
              Rational[
                50, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], Rational[25, 6] (1 - 5^Rational[1, 2])}, {
              Rational[50, 3] Cos[Rational[7, 60] Pi], Rational[-50, 3] 
               Sin[Rational[7, 60] Pi]}, {
              Rational[50, 3] Cos[Rational[2, 15] Pi], Rational[-50, 3] 
               Sin[Rational[2, 15] Pi]}, {
              Rational[50, 3] Cos[Rational[3, 20] Pi], Rational[-50, 3] 
               Sin[Rational[3, 20] Pi]}, {25 3^Rational[-1, 2], 
               Rational[-25, 3]}, {
              Rational[50, 3] Cos[Rational[11, 60] Pi], Rational[-50, 3] 
               Sin[Rational[11, 60] Pi]}, {
              Rational[25, 6] (1 + 5^Rational[1, 2]), 
               Rational[-50, 3] (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              Rational[50, 3] Cos[Rational[13, 60] Pi], Rational[-50, 3] 
               Sin[Rational[13, 60] Pi]}, {
              Rational[50, 3] Cos[Rational[7, 30] Pi], Rational[-50, 3] 
               Sin[Rational[7, 30] Pi]}, {
              Rational[25, 3] 2^Rational[1, 2], Rational[-25, 3] 
               2^Rational[1, 2]}, {
              Rational[50, 3] Sin[Rational[7, 30] Pi], Rational[-50, 3] 
               Cos[Rational[7, 30] Pi]}, {
              Rational[50, 3] Sin[Rational[13, 60] Pi], Rational[-50, 3] 
               Cos[Rational[13, 60] Pi]}, {
              Rational[
                50, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], Rational[25, 6] (-1 - 5^Rational[1, 2])}, {
              Rational[50, 3] Sin[Rational[11, 60] Pi], Rational[-50, 3] 
               Cos[Rational[11, 60] Pi]}, {
               Rational[25, 3], (-25) 3^Rational[-1, 2]}, {
              Rational[50, 3] Sin[Rational[3, 20] Pi], Rational[-50, 3] 
               Cos[Rational[3, 20] Pi]}, {
              Rational[50, 3] Sin[Rational[2, 15] Pi], Rational[-50, 3] 
               Cos[Rational[2, 15] Pi]}, {
              Rational[50, 3] Sin[Rational[7, 60] Pi], Rational[-50, 3] 
               Cos[Rational[7, 60] Pi]}, {
              Rational[25, 6] (-1 + 5^Rational[1, 2]), 
               Rational[-50, 3] (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              Rational[25, 3] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 
               Rational[-25, 3] 2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
              Rational[50, 3] Sin[Rational[1, 15] Pi], Rational[-50, 3] 
               Cos[Rational[1, 15] Pi]}, {
              Rational[50, 3] Sin[Rational[1, 20] Pi], Rational[-50, 3] 
               Cos[Rational[1, 20] Pi]}, {
              Rational[50, 3] Sin[Rational[1, 30] Pi], Rational[-50, 3] 
               Cos[Rational[1, 30] Pi]}, {
              Rational[50, 3] Sin[Rational[1, 60] Pi], Rational[-50, 3] 
               Cos[Rational[1, 60] Pi]}, {0, 
               Rational[-50, 3]}, {
              Rational[-50, 3] Sin[Rational[1, 60] Pi], Rational[-50, 3] 
               Cos[Rational[1, 60] Pi]}, {
              Rational[-50, 3] Sin[Rational[1, 30] Pi], Rational[-50, 3] 
               Cos[Rational[1, 30] Pi]}, {
              Rational[-50, 3] Sin[Rational[1, 20] Pi], Rational[-50, 3] 
               Cos[Rational[1, 20] Pi]}, {
              Rational[-50, 3] Sin[Rational[1, 15] Pi], Rational[-50, 3] 
               Cos[Rational[1, 15] Pi]}, {
              Rational[-25, 3] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 
               Rational[-25, 3] 2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
              Rational[25, 6] (1 - 5^Rational[1, 2]), 
               Rational[-50, 3] (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              Rational[-50, 3] Sin[Rational[7, 60] Pi], Rational[-50, 3] 
               Cos[Rational[7, 60] Pi]}, {
              Rational[-50, 3] Sin[Rational[2, 15] Pi], Rational[-50, 3] 
               Cos[Rational[2, 15] Pi]}, {
              Rational[-50, 3] Sin[Rational[3, 20] Pi], Rational[-50, 3] 
               Cos[Rational[3, 20] Pi]}, {
               Rational[-25, 3], (-25) 3^Rational[-1, 2]}, {
              Rational[-50, 3] Sin[Rational[11, 60] Pi], Rational[-50, 3] 
               Cos[Rational[11, 60] Pi]}, {
              Rational[-50, 3] (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[25, 6] (-1 - 5^Rational[1, 2])}, {
              Rational[-50, 3] Sin[Rational[13, 60] Pi], Rational[-50, 3] 
               Cos[Rational[13, 60] Pi]}, {
              Rational[-50, 3] Sin[Rational[7, 30] Pi], Rational[-50, 3] 
               Cos[Rational[7, 30] Pi]}, {
              Rational[-25, 3] 2^Rational[1, 2], Rational[-25, 3] 
               2^Rational[1, 2]}, {
              Rational[-50, 3] Cos[Rational[7, 30] Pi], Rational[-50, 3] 
               Sin[Rational[7, 30] Pi]}, {
              Rational[-50, 3] Cos[Rational[13, 60] Pi], Rational[-50, 3] 
               Sin[Rational[13, 60] Pi]}, {
              Rational[25, 6] (-1 - 5^Rational[1, 2]), 
               Rational[-50, 3] (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              Rational[-50, 3] Cos[Rational[11, 60] Pi], Rational[-50, 3] 
               Sin[Rational[11, 60] Pi]}, {(-25) 3^Rational[-1, 2], 
               Rational[-25, 3]}, {
              Rational[-50, 3] Cos[Rational[3, 20] Pi], Rational[-50, 3] 
               Sin[Rational[3, 20] Pi]}, {
              Rational[-50, 3] Cos[Rational[2, 15] Pi], Rational[-50, 3] 
               Sin[Rational[2, 15] Pi]}, {
              Rational[-50, 3] Cos[Rational[7, 60] Pi], Rational[-50, 3] 
               Sin[Rational[7, 60] Pi]}, {
              Rational[-50, 3] (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[25, 6] (1 - 5^Rational[1, 2])}, {
              Rational[-25, 3] 2^Rational[-1, 2] (1 + 3^Rational[1, 2]), 
               Rational[-25, 3] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {
              Rational[-50, 3] Cos[Rational[1, 15] Pi], Rational[-50, 3] 
               Sin[Rational[1, 15] Pi]}, {
              Rational[-50, 3] Cos[Rational[1, 20] Pi], Rational[-50, 3] 
               Sin[Rational[1, 20] Pi]}, {
              Rational[-50, 3] Cos[Rational[1, 30] Pi], Rational[-50, 3] 
               Sin[Rational[1, 30] Pi]}, {
              Rational[-50, 3] Cos[Rational[1, 60] Pi], Rational[-50, 3] 
               Sin[Rational[1, 60] Pi]}, {
               Rational[-50, 3], 0}, {
              Rational[-50, 3] Cos[Rational[1, 60] Pi], Rational[50, 3] 
               Sin[Rational[1, 60] Pi]}, {
              Rational[-50, 3] Cos[Rational[1, 30] Pi], Rational[50, 3] 
               Sin[Rational[1, 30] Pi]}, {
              Rational[-50, 3] Cos[Rational[1, 20] Pi], Rational[50, 3] 
               Sin[Rational[1, 20] Pi]}, {
              Rational[-50, 3] Cos[Rational[1, 15] Pi], Rational[50, 3] 
               Sin[Rational[1, 15] Pi]}, {
              Rational[-25, 3] 2^Rational[-1, 2] (1 + 3^Rational[1, 2]), 
               Rational[25, 3] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {
              Rational[-50, 3] (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[25, 6] (-1 + 5^Rational[1, 2])}, {
              Rational[-50, 3] Cos[Rational[7, 60] Pi], Rational[50, 3] 
               Sin[Rational[7, 60] Pi]}, {
              Rational[-50, 3] Cos[Rational[2, 15] Pi], Rational[50, 3] 
               Sin[Rational[2, 15] Pi]}, {
              Rational[-50, 3] Cos[Rational[3, 20] Pi], Rational[50, 3] 
               Sin[Rational[3, 20] Pi]}, {(-25) 3^Rational[-1, 2], 
               Rational[25, 3]}, {
              Rational[-50, 3] Cos[Rational[11, 60] Pi], Rational[50, 3] 
               Sin[Rational[11, 60] Pi]}, {
              Rational[25, 6] (-1 - 5^Rational[1, 2]), 
               Rational[
                50, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2]}, {
              Rational[-50, 3] Cos[Rational[13, 60] Pi], Rational[50, 3] 
               Sin[Rational[13, 60] Pi]}, {
              Rational[-50, 3] Cos[Rational[7, 30] Pi], Rational[50, 3] 
               Sin[Rational[7, 30] Pi]}, {
              Rational[-25, 3] 2^Rational[1, 2], Rational[25, 3] 
               2^Rational[1, 2]}, {
              Rational[-50, 3] Sin[Rational[7, 30] Pi], Rational[50, 3] 
               Cos[Rational[7, 30] Pi]}, {
              Rational[-50, 3] Sin[Rational[13, 60] Pi], Rational[50, 3] 
               Cos[Rational[13, 60] Pi]}, {
              Rational[-50, 3] (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[25, 6] (1 + 5^Rational[1, 2])}, {
              Rational[-50, 3] Sin[Rational[11, 60] Pi], Rational[50, 3] 
               Cos[Rational[11, 60] Pi]}, {
               Rational[-25, 3], 25 3^Rational[-1, 2]}, {
              Rational[-50, 3] Sin[Rational[3, 20] Pi], Rational[50, 3] 
               Cos[Rational[3, 20] Pi]}, {
              Rational[-50, 3] Sin[Rational[2, 15] Pi], Rational[50, 3] 
               Cos[Rational[2, 15] Pi]}, {
              Rational[-50, 3] Sin[Rational[7, 60] Pi], Rational[50, 3] 
               Cos[Rational[7, 60] Pi]}, {
              Rational[25, 6] (1 - 5^Rational[1, 2]), 
               Rational[
                50, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2]}, {
              Rational[-25, 3] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 
               Rational[25, 3] 2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
              Rational[-50, 3] Sin[Rational[1, 15] Pi], Rational[50, 3] 
               Cos[Rational[1, 15] Pi]}, {
              Rational[-50, 3] Sin[Rational[1, 20] Pi], Rational[50, 3] 
               Cos[Rational[1, 20] Pi]}, {
              Rational[-50, 3] Sin[Rational[1, 30] Pi], Rational[50, 3] 
               Cos[Rational[1, 30] Pi]}, {
              Rational[-50, 3] Sin[Rational[1, 60] Pi], Rational[50, 3] 
               Cos[Rational[1, 60] Pi]}, {0, 
               Rational[50, 3]}}, {{0, 16.666666666666668`}, {
              0.8722659373823972, 16.643825579242897`}, {1.742141054460891, 
              16.575364922804557`}, {2.607241084003848, 
              16.461472343252296`}, {3.4651948469626555`, 
              16.302460012230096`}, {4.313650751708679, 16.09876377148447}, {
              5.150283239582458, 15.85094193825256}, {5.972799159088338, 
              15.559673774953364`}, {6.778944051263337, 
              15.225757627376682`}, {7.566508328992446, 14.8501087364728}, {
              8.333333333333334, 14.433756729740645`}, {9.07731725025045, 
              13.977842799090402`}, {9.796420871541219, 
              13.483616572915793`}, {10.488673184163959`, 
              12.952432690949514`}, {11.152176772647637`, 
              12.385747091289906`}, {11.785113019775794`, 
              11.785113019775794`}, {12.385747091289906`, 
              11.152176772647637`}, {12.952432690949514`, 
              10.488673184163959`}, {13.483616572915793`, 
              9.796420871541219}, {13.977842799090402`, 9.07731725025045}, {
              14.433756729740645`, 8.333333333333334}, {14.8501087364728, 
              7.566508328992446}, {15.225757627376682`, 6.778944051263337}, {
              15.559673774953364`, 5.972799159088338}, {15.85094193825256, 
              5.150283239582458}, {16.09876377148447, 4.313650751708679}, {
              16.302460012230096`, 3.4651948469626555`}, {16.461472343252296`,
               2.607241084003848}, {16.575364922804557`, 1.742141054460891}, {
              16.643825579242897`, 0.8722659373823972}, {
              16.666666666666668`, 0}, {
              16.643825579242897`, -0.8722659373823972}, {
              16.575364922804557`, -1.742141054460891}, {
              16.461472343252296`, -2.607241084003848}, {
              16.302460012230096`, -3.4651948469626555`}, {
              16.09876377148447, -4.313650751708679}, {
              15.85094193825256, -5.150283239582458}, {
              15.559673774953364`, -5.972799159088338}, {
              15.225757627376682`, -6.778944051263337}, {
              14.8501087364728, -7.566508328992446}, {
              14.433756729740645`, -8.333333333333334}, {
              13.977842799090402`, -9.07731725025045}, {
              13.483616572915793`, -9.796420871541219}, {
              12.952432690949514`, -10.488673184163959`}, {
              12.385747091289906`, -11.152176772647637`}, {
              11.785113019775794`, -11.785113019775794`}, {
              11.152176772647637`, -12.385747091289906`}, {
              10.488673184163959`, -12.952432690949514`}, {
              9.796420871541219, -13.483616572915793`}, {
              9.07731725025045, -13.977842799090402`}, {
              8.333333333333334, -14.433756729740645`}, {
              7.566508328992446, -14.8501087364728}, {
              6.778944051263337, -15.225757627376682`}, {
              5.972799159088338, -15.559673774953364`}, {
              5.150283239582458, -15.85094193825256}, {
              4.313650751708679, -16.09876377148447}, {
              3.4651948469626555`, -16.302460012230096`}, {
              2.607241084003848, -16.461472343252296`}, {
              1.742141054460891, -16.575364922804557`}, {
              0.8722659373823972, -16.643825579242897`}, {
              0, -16.666666666666668`}, {-0.8722659373823972, \
-16.643825579242897`}, {-1.742141054460891, -16.575364922804557`}, \
{-2.607241084003848, -16.461472343252296`}, {-3.4651948469626555`, \
-16.302460012230096`}, {-4.313650751708679, -16.09876377148447}, \
{-5.150283239582458, -15.85094193825256}, {-5.972799159088338, \
-15.559673774953364`}, {-6.778944051263337, -15.225757627376682`}, \
{-7.566508328992446, -14.8501087364728}, {-8.333333333333334, \
-14.433756729740645`}, {-9.07731725025045, -13.977842799090402`}, \
{-9.796420871541219, -13.483616572915793`}, {-10.488673184163959`, \
-12.952432690949514`}, {-11.152176772647637`, -12.385747091289906`}, \
{-11.785113019775794`, -11.785113019775794`}, {-12.385747091289906`, \
-11.152176772647637`}, {-12.952432690949514`, -10.488673184163959`}, \
{-13.483616572915793`, -9.796420871541219}, {-13.977842799090402`, \
-9.07731725025045}, {-14.433756729740645`, -8.333333333333334}, \
{-14.8501087364728, -7.566508328992446}, {-15.225757627376682`, \
-6.778944051263337}, {-15.559673774953364`, -5.972799159088338}, \
{-15.85094193825256, -5.150283239582458}, {-16.09876377148447, \
-4.313650751708679}, {-16.302460012230096`, -3.4651948469626555`}, \
{-16.461472343252296`, -2.607241084003848}, {-16.575364922804557`, \
-1.742141054460891}, {-16.643825579242897`, -0.8722659373823972}, \
{-16.666666666666668`, 0}, {-16.643825579242897`, 
              0.8722659373823972}, {-16.575364922804557`, 
              1.742141054460891}, {-16.461472343252296`, 
              2.607241084003848}, {-16.302460012230096`, 
              3.4651948469626555`}, {-16.09876377148447, 
              4.313650751708679}, {-15.85094193825256, 
              5.150283239582458}, {-15.559673774953364`, 
              5.972799159088338}, {-15.225757627376682`, 
              6.778944051263337}, {-14.8501087364728, 
              7.566508328992446}, {-14.433756729740645`, 
              8.333333333333334}, {-13.977842799090402`, 
              9.07731725025045}, {-13.483616572915793`, 
              9.796420871541219}, {-12.952432690949514`, 
              10.488673184163959`}, {-12.385747091289906`, 
              11.152176772647637`}, {-11.785113019775794`, 
              11.785113019775794`}, {-11.152176772647637`, 
              12.385747091289906`}, {-10.488673184163959`, 
              12.952432690949514`}, {-9.796420871541219, 
              13.483616572915793`}, {-9.07731725025045, 
              13.977842799090402`}, {-8.333333333333334, 
              14.433756729740645`}, {-7.566508328992446, 
              14.8501087364728}, {-6.778944051263337, 
              15.225757627376682`}, {-5.972799159088338, 
              15.559673774953364`}, {-5.150283239582458, 
              15.85094193825256}, {-4.313650751708679, 
              16.09876377148447}, {-3.4651948469626555`, 
              16.302460012230096`}, {-2.607241084003848, 
              16.461472343252296`}, {-1.742141054460891, 
              16.575364922804557`}, {-0.8722659373823972, 
              16.643825579242897`}, {
              0, 16.666666666666668`}}]]}}, {{{}, {}}, {}, {{}, 
           GraphicsComplexBox[CompressedData["
1:eJxdlHs4FOgXx81k3MZczDBuO0QuoURrf1KzvW9Rbmv9Qq3kaeWSzGpdQm65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            "], {{{}, {}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                PointSize[0.009166666666666668], 
                RGBColor[0.368417, 0.506779, 0.709798], 
                AbsoluteThickness[1.6], 
                Thickness[0.01]], 
               
               LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 
                32, 33, 34, 35, 36, 37}]}, {
               Hue[0.9060679774997897, 0.6, 0.6], 
               Directive[
                PointSize[0.009166666666666668], 
                RGBColor[0.880722, 0.611041, 0.142051], 
                AbsoluteThickness[1.6], 
                Thickness[0.01]], 
               
               LineBox[{38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 
                51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 
                66, 67, 68, 69, 70, 71, 72, 73, 74}]}, {
               Hue[0.1421359549995791, 0.6, 0.6], 
               Directive[
                PointSize[0.009166666666666668], 
                RGBColor[0.560181, 0.691569, 0.194885], 
                AbsoluteThickness[1.6], 
                Thickness[0.01]], 
               
               LineBox[{75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 
                88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102,
                 103, 104, 105, 106, 107, 108, 109, 110, 
                111}]}}}], {}, {}, {{}, {}}}, {}, {}, {{}, {}}, {}, {{{}, {}, \
{}, {}}, {}}}}, {ImageSize -> 600}],FormBox[
        FormBox[
         TemplateBox[{
           StyleBox[
           "\"\\!\\(\\*SubscriptBox[\\\"F\\\", \\\"a\\\"]\\)\"", 50, 
            StripOnInput -> False], 
           StyleBox[
           "\"\\!\\(\\*SubscriptBox[\\\"F\\\", \\\"b\\\"]\\)\"", 50, 
            StripOnInput -> False], 
           StyleBox[
           "\"\\!\\(\\*SubscriptBox[\\\"F\\\", \\\"c\\\"]\\)\"", 50, 
            StripOnInput -> False]}, "PointLegend", 
          DisplayFunction -> (FormBox[
            StyleBox[
             StyleBox[
              PaneBox[
               TagBox[
                GridBox[{{
                   TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[0.18]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[0.18]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[0.18]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[0.18]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6], 
                    Thickness[0.18]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6], 
                    Thickness[0.18]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                 False, GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                "Grid"], Alignment -> Left, AppearanceElements -> None, 
               ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
               "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
             FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
             False], TraditionalForm]& ), 
          InterpretationFunction :> (RowBox[{"PointLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.01`", "]"}]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.01`", "]"}]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.560181, 0.691569, 0.194885]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.01`", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
               RowBox[{"LegendMarkers", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
               RowBox[{"Joined", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"{", "}"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
          Editable -> True], TraditionalForm], TraditionalForm]},
      "Legended",
      DisplayFunction->(GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"], 
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ),
      Editable->True,
      InterpretationFunction->(RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.9543996225752163`*^9, 3.9543996398418007`*^9}, 
   3.954399672039648*^9, 3.9543998776592503`*^9, {3.9543999320903387`*^9, 
   3.954399970919401*^9}, 3.954400165466818*^9, {3.954400208821863*^9, 
   3.95440021727326*^9}, 3.9544002508189926`*^9, {3.9544030707866335`*^9, 
   3.9544030787074413`*^9}, 3.9544032357784305`*^9, 3.954403319519314*^9, 
   3.9544033778409014`*^9, 3.9544036116280384`*^9, 3.954403764448978*^9, 
   3.954476920960204*^9, 3.9544769793444605`*^9, 3.9574833978025465`*^9, 
   3.9574834512499747`*^9, 3.957483529750285*^9, 3.957483585638762*^9, 
   3.9574836531947355`*^9, 3.9574837607594814`*^9, {3.9574840845887175`*^9, 
   3.9574840962590575`*^9}, 3.957484472286878*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     InterpretationBox[Cell[BoxData[
       FormBox[
        StyleBox["\<\"\\!\\(\\*SuperscriptBox[\\(\[InvisiblePrefixScriptBase]\
\\), \\(3\\)]\\)\\!\\(\\*SubscriptBox[\\(J\\), \
\\(iso\\)]\\)(\\!\\(\\*SuperscriptBox[\\(\[InvisiblePrefixScriptBase]\\), \
\\(19\\)]\\)F, \\!\\(\\*SuperscriptBox[\\(\[InvisiblePrefixScriptBase]\\), \
\\(1\\)]\\)H)\"\>",
         StripOnInput->False,
         FontSize->50], TextForm]], "InlineText"],
      Text[
       Style[
       "\!\(\*SuperscriptBox[\(\[InvisiblePrefixScriptBase]\), \
\(3\)]\)\!\(\*SubscriptBox[\(J\), \(iso\)]\)(\!\(\*SuperscriptBox[\(\
\[InvisiblePrefixScriptBase]\), \(19\)]\)F, \!\(\*SuperscriptBox[\(\
\[InvisiblePrefixScriptBase]\), \(1\)]\)H)", 50]]], 
     InterpretationBox[Cell[BoxData[
       FormBox[
        StyleBox["\<\"\\!\\(\\*SuperscriptBox[\\(J\\), \
\\(\[Star]\\)]\\)(\\!\\(\\*SuperscriptBox[\\(\[InvisiblePrefixScriptBase]\\), \
\\(19\\)]\\)F, \\!\\(\\*SuperscriptBox[\\(\[InvisiblePrefixScriptBase]\\), \
\\(1\\)]\\)H)\"\>",
         StripOnInput->False,
         FontSize->50], TextForm]], "InlineText"],
      Text[
       Style[
       "\!\(\*SuperscriptBox[\(J\), \(\[Star]\)]\)(\!\(\*SuperscriptBox[\(\
\[InvisiblePrefixScriptBase]\), \(19\)]\)F, \!\(\*SuperscriptBox[\(\
\[InvisiblePrefixScriptBase]\), \(1\)]\)H)", 50]]]},
    {
     GraphicsBox[{
       {Opacity[
        0.9], {LineBox[{{0, 0}, {0, 50}}], 
         LineBox[NCache[{{0, 0}, {25, 25 3^Rational[1, 2]}}, {{0, 0}, {
            25, 43.30127018922193}}]], 
         LineBox[NCache[{{0, 0}, {25 3^Rational[1, 2], 25}}, {{0, 0}, {
            43.30127018922193, 25}}]], LineBox[{{0, 0}, {50, 0}}], 
         LineBox[NCache[{{0, 0}, {25 3^Rational[1, 2], -25}}, {{0, 0}, {
            43.30127018922193, -25}}]], 
         LineBox[NCache[{{0, 0}, {25, (-25) 3^Rational[1, 2]}}, {{0, 0}, {
            25, -43.30127018922193}}]], LineBox[{{0, 0}, {0, -50}}], 
         LineBox[NCache[{{0, 0}, {-25, (-25) 3^Rational[1, 2]}}, {{0, 
            0}, {-25, -43.30127018922193}}]], 
         LineBox[NCache[{{0, 0}, {(-25) 3^Rational[1, 2], -25}}, {{0, 
            0}, {-43.30127018922193, -25}}]], LineBox[{{0, 0}, {-50, 0}}], 
         LineBox[NCache[{{0, 0}, {(-25) 3^Rational[1, 2], 25}}, {{0, 
            0}, {-43.30127018922193, 25}}]], 
         LineBox[NCache[{{0, 0}, {-25, 25 3^Rational[1, 2]}}, {{0, 
            0}, {-25, 43.30127018922193}}]], LineBox[{{0, 0}, {0, 50}}]}, {
         InsetBox[
          StyleBox[
           TemplateBox[{"\"0\"","\"\[Degree]\""},
            "Superscript"],
           StripOnInput->False,
           FontSize->30], {55.00000000000001, 0.}], InsetBox[
          StyleBox[
           TemplateBox[{"\"30\"","\"\[Degree]\""},
            "Superscript"],
           StripOnInput->False,
           FontSize->30], {47.63139720814413, 27.500000000000004}], InsetBox[
          StyleBox[
           TemplateBox[{"\"60\"","\"\[Degree]\""},
            "Superscript"],
           StripOnInput->False,
           FontSize->30], {27.500000000000004, 47.63139720814413}], InsetBox[
          StyleBox[
           TemplateBox[{"\"90\"","\"\[Degree]\""},
            "Superscript"],
           StripOnInput->False,
           FontSize->30], {0., 55.00000000000001}], InsetBox[
          StyleBox[
           TemplateBox[{"\"120\"","\"\[Degree]\""},
            "Superscript"],
           StripOnInput->False,
           FontSize->30], {-27.500000000000004, 47.63139720814413}], InsetBox[
          StyleBox[
           TemplateBox[{"\"150\"","\"\[Degree]\""},
            "Superscript"],
           StripOnInput->False,
           FontSize->30], {-47.63139720814413, 27.500000000000004}], InsetBox[
          StyleBox[
           TemplateBox[{"\"180\"","\"\[Degree]\""},
            "Superscript"],
           StripOnInput->False,
           FontSize->30], {-55.00000000000001, 0.}], InsetBox[
          StyleBox[
           TemplateBox[{"\"210\"","\"\[Degree]\""},
            "Superscript"],
           StripOnInput->False,
           FontSize->30], {-47.63139720814413, -27.500000000000004}], InsetBox[
          StyleBox[
           TemplateBox[{"\"240\"","\"\[Degree]\""},
            "Superscript"],
           StripOnInput->False,
           FontSize->30], {-27.500000000000004, -47.63139720814413}], InsetBox[
          StyleBox[
           TemplateBox[{"\"270\"","\"\[Degree]\""},
            "Superscript"],
           StripOnInput->False,
           FontSize->30], {0., -55.00000000000001}], InsetBox[
          StyleBox[
           TemplateBox[{"\"300\"","\"\[Degree]\""},
            "Superscript"],
           StripOnInput->False,
           FontSize->30], {27.500000000000004, -47.63139720814413}], InsetBox[
          StyleBox[
           TemplateBox[{"\"330\"","\"\[Degree]\""},
            "Superscript"],
           StripOnInput->False,
           FontSize->30], {47.63139720814413, -27.500000000000004}]}, {
         BezierCurveBox[
          NCache[{{0, 50}, {
            50 Sin[Rational[1, 60] Pi], 50 Cos[Rational[1, 60] Pi]}, {
            50 Sin[Rational[1, 30] Pi], 50 Cos[Rational[1, 30] Pi]}, {
            50 Sin[Rational[1, 20] Pi], 50 Cos[Rational[1, 20] Pi]}, {
            50 Sin[Rational[1, 15] Pi], 50 Cos[Rational[1, 15] Pi]}, {
            25 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 25 
             2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
            Rational[25, 2] (-1 + 5^Rational[1, 2]), 
             50 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {
            50 Sin[Rational[7, 60] Pi], 50 Cos[Rational[7, 60] Pi]}, {
            50 Sin[Rational[2, 15] Pi], 50 Cos[Rational[2, 15] Pi]}, {
            50 Sin[Rational[3, 20] Pi], 50 Cos[Rational[3, 20] Pi]}, {
            25, 25 3^Rational[1, 2]}, {
            50 Sin[Rational[11, 60] Pi], 50 Cos[Rational[11, 60] Pi]}, {
            50 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[25, 2] (1 + 5^Rational[1, 2])}, {
            50 Sin[Rational[13, 60] Pi], 50 Cos[Rational[13, 60] Pi]}, {
            50 Sin[Rational[7, 30] Pi], 50 Cos[Rational[7, 30] Pi]}, {
            25 2^Rational[1, 2], 25 2^Rational[1, 2]}, {
            50 Cos[Rational[7, 30] Pi], 50 Sin[Rational[7, 30] Pi]}, {
            50 Cos[Rational[13, 60] Pi], 50 Sin[Rational[13, 60] Pi]}, {
            Rational[25, 2] (1 + 5^Rational[1, 2]), 
             50 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {
            50 Cos[Rational[11, 60] Pi], 50 Sin[Rational[11, 60] Pi]}, {
            25 3^Rational[1, 2], 25}, {
            50 Cos[Rational[3, 20] Pi], 50 Sin[Rational[3, 20] Pi]}, {
            50 Cos[Rational[2, 15] Pi], 50 Sin[Rational[2, 15] Pi]}, {
            50 Cos[Rational[7, 60] Pi], 50 Sin[Rational[7, 60] Pi]}, {
            50 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[25, 2] (-1 + 5^Rational[1, 2])}, {
            25 2^Rational[-1, 2] (1 + 3^Rational[1, 2]), 25 
             2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {
            50 Cos[Rational[1, 15] Pi], 50 Sin[Rational[1, 15] Pi]}, {
            50 Cos[Rational[1, 20] Pi], 50 Sin[Rational[1, 20] Pi]}, {
            50 Cos[Rational[1, 30] Pi], 50 Sin[Rational[1, 30] Pi]}, {
            50 Cos[Rational[1, 60] Pi], 50 Sin[Rational[1, 60] Pi]}, {50, 
            0}, {50 Cos[Rational[1, 60] Pi], (-50) Sin[Rational[1, 60] Pi]}, {
            50 Cos[Rational[1, 30] Pi], (-50) Sin[Rational[1, 30] Pi]}, {
            50 Cos[Rational[1, 20] Pi], (-50) Sin[Rational[1, 20] Pi]}, {
            50 Cos[Rational[1, 15] Pi], (-50) Sin[Rational[1, 15] Pi]}, {
            25 2^Rational[-1, 2] (1 + 3^Rational[1, 2]), (-25) 
             2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {
            50 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[25, 2] (1 - 5^Rational[1, 2])}, {
            50 Cos[Rational[7, 60] Pi], (-50) Sin[Rational[7, 60] Pi]}, {
            50 Cos[Rational[2, 15] Pi], (-50) Sin[Rational[2, 15] Pi]}, {
            50 Cos[Rational[3, 20] Pi], (-50) Sin[Rational[3, 20] Pi]}, {
            25 3^Rational[1, 2], -25}, {
            50 Cos[Rational[11, 60] Pi], (-50) Sin[Rational[11, 60] Pi]}, {
            Rational[25, 2] (1 + 
              5^Rational[1, 2]), (-50) (Rational[5, 8] + 
               Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
            50 Cos[Rational[13, 60] Pi], (-50) Sin[Rational[13, 60] Pi]}, {
            50 Cos[Rational[7, 30] Pi], (-50) Sin[Rational[7, 30] Pi]}, {
            25 2^Rational[1, 2], (-25) 2^Rational[1, 2]}, {
            50 Sin[Rational[7, 30] Pi], (-50) Cos[Rational[7, 30] Pi]}, {
            50 Sin[Rational[13, 60] Pi], (-50) Cos[Rational[13, 60] Pi]}, {
            50 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[25, 2] (-1 - 5^Rational[1, 2])}, {
            50 Sin[Rational[11, 60] Pi], (-50) Cos[Rational[11, 60] Pi]}, {
            25, (-25) 3^Rational[1, 2]}, {
            50 Sin[Rational[3, 20] Pi], (-50) Cos[Rational[3, 20] Pi]}, {
            50 Sin[Rational[2, 15] Pi], (-50) Cos[Rational[2, 15] Pi]}, {
            50 Sin[Rational[7, 60] Pi], (-50) Cos[Rational[7, 60] Pi]}, {
            Rational[25, 2] (-1 + 
              5^Rational[1, 2]), (-50) (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
            25 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), (-25) 
             2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
            50 Sin[Rational[1, 15] Pi], (-50) Cos[Rational[1, 15] Pi]}, {
            50 Sin[Rational[1, 20] Pi], (-50) Cos[Rational[1, 20] Pi]}, {
            50 Sin[Rational[1, 30] Pi], (-50) Cos[Rational[1, 30] Pi]}, {
            50 Sin[Rational[1, 60] Pi], (-50) Cos[Rational[1, 60] Pi]}, {
            0, -50}, {(-50) Sin[Rational[1, 60] Pi], (-50) 
             Cos[Rational[1, 60] Pi]}, {(-50) Sin[Rational[1, 30] Pi], (-50) 
             Cos[Rational[1, 30] Pi]}, {(-50) Sin[Rational[1, 20] Pi], (-50) 
             Cos[Rational[1, 20] Pi]}, {(-50) Sin[Rational[1, 15] Pi], (-50) 
             Cos[Rational[1, 15] Pi]}, {(-25) 
             2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), (-25) 
             2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
            Rational[25, 2] (1 - 5^
              Rational[1, 2]), (-50) (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {(-50) 
             Sin[Rational[7, 60] Pi], (-50) Cos[Rational[7, 60] Pi]}, {(-50) 
             Sin[Rational[2, 15] Pi], (-50) Cos[Rational[2, 15] Pi]}, {(-50) 
             Sin[Rational[3, 20] Pi], (-50) 
             Cos[Rational[3, 20] Pi]}, {-25, (-25) 3^Rational[1, 2]}, {(-50) 
             Sin[Rational[11, 60] Pi], (-50) 
             Cos[Rational[11, 60] Pi]}, {(-50) (Rational[5, 8] + 
               Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[25, 2] (-1 - 5^Rational[1, 2])}, {(-50) 
             Sin[Rational[13, 60] Pi], (-50) 
             Cos[Rational[13, 60] Pi]}, {(-50) Sin[Rational[7, 30] Pi], (-50) 
             Cos[Rational[7, 30] Pi]}, {(-25) 2^Rational[1, 2], (-25) 
             2^Rational[1, 2]}, {(-50) Cos[Rational[7, 30] Pi], (-50) 
             Sin[Rational[7, 30] Pi]}, {(-50) Cos[Rational[13, 60] Pi], (-50) 
             Sin[Rational[13, 60] Pi]}, {
            Rational[25, 2] (-1 - 5^
              Rational[1, 2]), (-50) (Rational[5, 8] + 
               Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {(-50) 
             Cos[Rational[11, 60] Pi], (-50) 
             Sin[Rational[11, 60] Pi]}, {(-25) 3^Rational[1, 2], -25}, {(-50) 
             Cos[Rational[3, 20] Pi], (-50) Sin[Rational[3, 20] Pi]}, {(-50) 
             Cos[Rational[2, 15] Pi], (-50) Sin[Rational[2, 15] Pi]}, {(-50) 
             Cos[Rational[7, 60] Pi], (-50) 
             Sin[Rational[7, 60] Pi]}, {(-50) (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[25, 2] (1 - 5^Rational[1, 2])}, {(-25) 
             2^Rational[-1, 2] (1 + 3^Rational[1, 2]), (-25) 
             2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {(-50) 
             Cos[Rational[1, 15] Pi], (-50) Sin[Rational[1, 15] Pi]}, {(-50) 
             Cos[Rational[1, 20] Pi], (-50) Sin[Rational[1, 20] Pi]}, {(-50) 
             Cos[Rational[1, 30] Pi], (-50) Sin[Rational[1, 30] Pi]}, {(-50) 
             Cos[Rational[1, 60] Pi], (-50) Sin[Rational[1, 60] Pi]}, {-50, 
            0}, {(-50) Cos[Rational[1, 60] Pi], 50 
             Sin[Rational[1, 60] Pi]}, {(-50) Cos[Rational[1, 30] Pi], 50 
             Sin[Rational[1, 30] Pi]}, {(-50) Cos[Rational[1, 20] Pi], 50 
             Sin[Rational[1, 20] Pi]}, {(-50) Cos[Rational[1, 15] Pi], 50 
             Sin[Rational[1, 15] Pi]}, {(-25) 
             2^Rational[-1, 2] (1 + 3^Rational[1, 2]), 25 
             2^Rational[-1, 2] (-1 + 
              3^Rational[1, 2])}, {(-50) (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[25, 2] (-1 + 5^Rational[1, 2])}, {(-50) 
             Cos[Rational[7, 60] Pi], 50 Sin[Rational[7, 60] Pi]}, {(-50) 
             Cos[Rational[2, 15] Pi], 50 Sin[Rational[2, 15] Pi]}, {(-50) 
             Cos[Rational[3, 20] Pi], 50 Sin[Rational[3, 20] Pi]}, {(-25) 
             3^Rational[1, 2], 25}, {(-50) Cos[Rational[11, 60] Pi], 50 
             Sin[Rational[11, 60] Pi]}, {
            Rational[25, 2] (-1 - 5^Rational[1, 2]), 
             50 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {(-50) Cos[Rational[13, 60] Pi], 50 
             Sin[Rational[13, 60] Pi]}, {(-50) Cos[Rational[7, 30] Pi], 50 
             Sin[Rational[7, 30] Pi]}, {(-25) 2^Rational[1, 2], 25 
             2^Rational[1, 2]}, {(-50) Sin[Rational[7, 30] Pi], 50 
             Cos[Rational[7, 30] Pi]}, {(-50) Sin[Rational[13, 60] Pi], 50 
             Cos[Rational[13, 60] Pi]}, {(-50) (Rational[5, 8] + 
               Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[25, 2] (1 + 5^Rational[1, 2])}, {(-50) 
             Sin[Rational[11, 60] Pi], 50 Cos[Rational[11, 60] Pi]}, {-25, 25 
             3^Rational[1, 2]}, {(-50) Sin[Rational[3, 20] Pi], 50 
             Cos[Rational[3, 20] Pi]}, {(-50) Sin[Rational[2, 15] Pi], 50 
             Cos[Rational[2, 15] Pi]}, {(-50) Sin[Rational[7, 60] Pi], 50 
             Cos[Rational[7, 60] Pi]}, {
            Rational[25, 2] (1 - 5^Rational[1, 2]), 
             50 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {(-25) 
             2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 25 
             2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {(-50) 
             Sin[Rational[1, 15] Pi], 50 Cos[Rational[1, 15] Pi]}, {(-50) 
             Sin[Rational[1, 20] Pi], 50 Cos[Rational[1, 20] Pi]}, {(-50) 
             Sin[Rational[1, 30] Pi], 50 Cos[Rational[1, 30] Pi]}, {(-50) 
             Sin[Rational[1, 60] Pi], 50 Cos[Rational[1, 60] Pi]}, {0, 
            50}}, {{0, 50}, {2.6167978121471913`, 49.931476737728694`}, {
            5.226423163382673, 49.72609476841367}, {7.821723252011544, 
            49.38441702975689}, {10.395584540887965`, 48.907380036690284`}, {
            12.940952255126033`, 48.296291314453406`}, {15.450849718747373`, 
            47.552825814757675`}, {17.918397477265014`, 46.67902132486009}, {
            20.336832153790006`, 45.67727288213004}, {22.699524986977337`, 
            44.550326209418394`}, {25, 43.30127018922193}, {27.23195175075135,
             41.9335283972712}, {29.389262614623657`, 40.45084971874737}, {
            31.466019552491876`, 38.857298072848536`}, {33.456530317942914`, 
            37.157241273869715`}, {35.35533905932738, 35.35533905932738}, {
            37.157241273869715`, 33.456530317942914`}, {38.857298072848536`, 
            31.466019552491876`}, {40.45084971874737, 29.389262614623657`}, {
            41.9335283972712, 27.23195175075135}, {43.30127018922193, 25}, {
            44.550326209418394`, 22.699524986977337`}, {45.67727288213004, 
            20.336832153790006`}, {46.67902132486009, 17.918397477265014`}, {
            47.552825814757675`, 15.450849718747373`}, {48.296291314453406`, 
            12.940952255126033`}, {48.907380036690284`, 
            10.395584540887965`}, {49.38441702975689, 7.821723252011544}, {
            49.72609476841367, 5.226423163382673}, {49.931476737728694`, 
            2.6167978121471913`}, {50, 0}, {
            49.931476737728694`, -2.6167978121471913`}, {
            49.72609476841367, -5.226423163382673}, {
            49.38441702975689, -7.821723252011544}, {
            48.907380036690284`, -10.395584540887965`}, {
            48.296291314453406`, -12.940952255126033`}, {
            47.552825814757675`, -15.450849718747373`}, {
            46.67902132486009, -17.918397477265014`}, {
            45.67727288213004, -20.336832153790006`}, {
            44.550326209418394`, -22.699524986977337`}, {
            43.30127018922193, -25}, {41.9335283972712, -27.23195175075135}, {
            40.45084971874737, -29.389262614623657`}, {
            38.857298072848536`, -31.466019552491876`}, {
            37.157241273869715`, -33.456530317942914`}, {
            35.35533905932738, -35.35533905932738}, {
            33.456530317942914`, -37.157241273869715`}, {
            31.466019552491876`, -38.857298072848536`}, {
            29.389262614623657`, -40.45084971874737}, {
            27.23195175075135, -41.9335283972712}, {25, -43.30127018922193}, {
            22.699524986977337`, -44.550326209418394`}, {
            20.336832153790006`, -45.67727288213004}, {
            17.918397477265014`, -46.67902132486009}, {
            15.450849718747373`, -47.552825814757675`}, {
            12.940952255126033`, -48.296291314453406`}, {
            10.395584540887965`, -48.907380036690284`}, {
            7.821723252011544, -49.38441702975689}, {
            5.226423163382673, -49.72609476841367}, {
            2.6167978121471913`, -49.931476737728694`}, {
            0, -50}, {-2.6167978121471913`, -49.931476737728694`}, \
{-5.226423163382673, -49.72609476841367}, {-7.821723252011544, \
-49.38441702975689}, {-10.395584540887965`, -48.907380036690284`}, \
{-12.940952255126033`, -48.296291314453406`}, {-15.450849718747373`, \
-47.552825814757675`}, {-17.918397477265014`, -46.67902132486009}, \
{-20.336832153790006`, -45.67727288213004}, {-22.699524986977337`, \
-44.550326209418394`}, {-25, -43.30127018922193}, {-27.23195175075135, \
-41.9335283972712}, {-29.389262614623657`, -40.45084971874737}, \
{-31.466019552491876`, -38.857298072848536`}, {-33.456530317942914`, \
-37.157241273869715`}, {-35.35533905932738, -35.35533905932738}, \
{-37.157241273869715`, -33.456530317942914`}, {-38.857298072848536`, \
-31.466019552491876`}, {-40.45084971874737, -29.389262614623657`}, \
{-41.9335283972712, -27.23195175075135}, {-43.30127018922193, -25}, \
{-44.550326209418394`, -22.699524986977337`}, {-45.67727288213004, \
-20.336832153790006`}, {-46.67902132486009, -17.918397477265014`}, \
{-47.552825814757675`, -15.450849718747373`}, {-48.296291314453406`, \
-12.940952255126033`}, {-48.907380036690284`, -10.395584540887965`}, \
{-49.38441702975689, -7.821723252011544}, {-49.72609476841367, \
-5.226423163382673}, {-49.931476737728694`, -2.6167978121471913`}, {-50, 
            0}, {-49.931476737728694`, 
            2.6167978121471913`}, {-49.72609476841367, 
            5.226423163382673}, {-49.38441702975689, 
            7.821723252011544}, {-48.907380036690284`, 
            10.395584540887965`}, {-48.296291314453406`, 
            12.940952255126033`}, {-47.552825814757675`, 
            15.450849718747373`}, {-46.67902132486009, 
            17.918397477265014`}, {-45.67727288213004, 
            20.336832153790006`}, {-44.550326209418394`, 
            22.699524986977337`}, {-43.30127018922193, 
             25}, {-41.9335283972712, 27.23195175075135}, {-40.45084971874737,
             29.389262614623657`}, {-38.857298072848536`, 
            31.466019552491876`}, {-37.157241273869715`, 
            33.456530317942914`}, {-35.35533905932738, 
            35.35533905932738}, {-33.456530317942914`, 
            37.157241273869715`}, {-31.466019552491876`, 
            38.857298072848536`}, {-29.389262614623657`, 
            40.45084971874737}, {-27.23195175075135, 
            41.9335283972712}, {-25, 
             43.30127018922193}, {-22.699524986977337`, 
            44.550326209418394`}, {-20.336832153790006`, 
            45.67727288213004}, {-17.918397477265014`, 
            46.67902132486009}, {-15.450849718747373`, 
            47.552825814757675`}, {-12.940952255126033`, 
            48.296291314453406`}, {-10.395584540887965`, 
            48.907380036690284`}, {-7.821723252011544, 
            49.38441702975689}, {-5.226423163382673, 
            49.72609476841367}, {-2.6167978121471913`, 49.931476737728694`}, {
            0, 50}}]], 
         BezierCurveBox[
          NCache[{{0, Rational[100, 3]}, {
            Rational[100, 3] Sin[Rational[1, 60] Pi], Rational[100, 3] 
             Cos[Rational[1, 60] Pi]}, {
            Rational[100, 3] Sin[Rational[1, 30] Pi], Rational[100, 3] 
             Cos[Rational[1, 30] Pi]}, {
            Rational[100, 3] Sin[Rational[1, 20] Pi], Rational[100, 3] 
             Cos[Rational[1, 20] Pi]}, {
            Rational[100, 3] Sin[Rational[1, 15] Pi], Rational[100, 3] 
             Cos[Rational[1, 15] Pi]}, {
            Rational[25, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2]), 
             Rational[25, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2])}, {
            Rational[25, 3] (-1 + 5^Rational[1, 2]), 
             Rational[
              100, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {
            Rational[100, 3] Sin[Rational[7, 60] Pi], Rational[100, 3] 
             Cos[Rational[7, 60] Pi]}, {
            Rational[100, 3] Sin[Rational[2, 15] Pi], Rational[100, 3] 
             Cos[Rational[2, 15] Pi]}, {
            Rational[100, 3] Sin[Rational[3, 20] Pi], Rational[100, 3] 
             Cos[Rational[3, 20] Pi]}, {
            Rational[50, 3], 50 3^Rational[-1, 2]}, {
            Rational[100, 3] Sin[Rational[11, 60] Pi], Rational[100, 3] 
             Cos[Rational[11, 60] Pi]}, {
            Rational[
              100, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[25, 3] (1 + 5^Rational[1, 2])}, {
            Rational[100, 3] Sin[Rational[13, 60] Pi], Rational[100, 3] 
             Cos[Rational[13, 60] Pi]}, {
            Rational[100, 3] Sin[Rational[7, 30] Pi], Rational[100, 3] 
             Cos[Rational[7, 30] Pi]}, {
            Rational[50, 3] 2^Rational[1, 2], Rational[50, 3] 
             2^Rational[1, 2]}, {
            Rational[100, 3] Cos[Rational[7, 30] Pi], Rational[100, 3] 
             Sin[Rational[7, 30] Pi]}, {
            Rational[100, 3] Cos[Rational[13, 60] Pi], Rational[100, 3] 
             Sin[Rational[13, 60] Pi]}, {
            Rational[25, 3] (1 + 5^Rational[1, 2]), 
             Rational[
              100, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {
            Rational[100, 3] Cos[Rational[11, 60] Pi], Rational[100, 3] 
             Sin[Rational[11, 60] Pi]}, {
            50 3^Rational[-1, 2], Rational[50, 3]}, {
            Rational[100, 3] Cos[Rational[3, 20] Pi], Rational[100, 3] 
             Sin[Rational[3, 20] Pi]}, {
            Rational[100, 3] Cos[Rational[2, 15] Pi], Rational[100, 3] 
             Sin[Rational[2, 15] Pi]}, {
            Rational[100, 3] Cos[Rational[7, 60] Pi], Rational[100, 3] 
             Sin[Rational[7, 60] Pi]}, {
            Rational[
              100, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[25, 3] (-1 + 5^Rational[1, 2])}, {
            Rational[25, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2]), 
             Rational[25, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2])}, {
            Rational[100, 3] Cos[Rational[1, 15] Pi], Rational[100, 3] 
             Sin[Rational[1, 15] Pi]}, {
            Rational[100, 3] Cos[Rational[1, 20] Pi], Rational[100, 3] 
             Sin[Rational[1, 20] Pi]}, {
            Rational[100, 3] Cos[Rational[1, 30] Pi], Rational[100, 3] 
             Sin[Rational[1, 30] Pi]}, {
            Rational[100, 3] Cos[Rational[1, 60] Pi], Rational[100, 3] 
             Sin[Rational[1, 60] Pi]}, {Rational[100, 3], 0}, {
            Rational[100, 3] Cos[Rational[1, 60] Pi], Rational[-100, 3] 
             Sin[Rational[1, 60] Pi]}, {
            Rational[100, 3] Cos[Rational[1, 30] Pi], Rational[-100, 3] 
             Sin[Rational[1, 30] Pi]}, {
            Rational[100, 3] Cos[Rational[1, 20] Pi], Rational[-100, 3] 
             Sin[Rational[1, 20] Pi]}, {
            Rational[100, 3] Cos[Rational[1, 15] Pi], Rational[-100, 3] 
             Sin[Rational[1, 15] Pi]}, {
            Rational[25, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2]), 
             Rational[-25, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2])}, {
            Rational[
              100, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[25, 3] (1 - 5^Rational[1, 2])}, {
            Rational[100, 3] Cos[Rational[7, 60] Pi], Rational[-100, 3] 
             Sin[Rational[7, 60] Pi]}, {
            Rational[100, 3] Cos[Rational[2, 15] Pi], Rational[-100, 3] 
             Sin[Rational[2, 15] Pi]}, {
            Rational[100, 3] Cos[Rational[3, 20] Pi], Rational[-100, 3] 
             Sin[Rational[3, 20] Pi]}, {
            50 3^Rational[-1, 2], Rational[-50, 3]}, {
            Rational[100, 3] Cos[Rational[11, 60] Pi], Rational[-100, 3] 
             Sin[Rational[11, 60] Pi]}, {
            Rational[25, 3] (1 + 5^Rational[1, 2]), 
             Rational[-100, 3] (Rational[5, 8] + 
               Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
            Rational[100, 3] Cos[Rational[13, 60] Pi], Rational[-100, 3] 
             Sin[Rational[13, 60] Pi]}, {
            Rational[100, 3] Cos[Rational[7, 30] Pi], Rational[-100, 3] 
             Sin[Rational[7, 30] Pi]}, {
            Rational[50, 3] 2^Rational[1, 2], Rational[-50, 3] 
             2^Rational[1, 2]}, {
            Rational[100, 3] Sin[Rational[7, 30] Pi], Rational[-100, 3] 
             Cos[Rational[7, 30] Pi]}, {
            Rational[100, 3] Sin[Rational[13, 60] Pi], Rational[-100, 3] 
             Cos[Rational[13, 60] Pi]}, {
            Rational[
              100, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[25, 3] (-1 - 5^Rational[1, 2])}, {
            Rational[100, 3] Sin[Rational[11, 60] Pi], Rational[-100, 3] 
             Cos[Rational[11, 60] Pi]}, {
            Rational[50, 3], (-50) 3^Rational[-1, 2]}, {
            Rational[100, 3] Sin[Rational[3, 20] Pi], Rational[-100, 3] 
             Cos[Rational[3, 20] Pi]}, {
            Rational[100, 3] Sin[Rational[2, 15] Pi], Rational[-100, 3] 
             Cos[Rational[2, 15] Pi]}, {
            Rational[100, 3] Sin[Rational[7, 60] Pi], Rational[-100, 3] 
             Cos[Rational[7, 60] Pi]}, {
            Rational[25, 3] (-1 + 5^Rational[1, 2]), 
             Rational[-100, 3] (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
            Rational[25, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2]), 
             Rational[-25, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2])}, {
            Rational[100, 3] Sin[Rational[1, 15] Pi], Rational[-100, 3] 
             Cos[Rational[1, 15] Pi]}, {
            Rational[100, 3] Sin[Rational[1, 20] Pi], Rational[-100, 3] 
             Cos[Rational[1, 20] Pi]}, {
            Rational[100, 3] Sin[Rational[1, 30] Pi], Rational[-100, 3] 
             Cos[Rational[1, 30] Pi]}, {
            Rational[100, 3] Sin[Rational[1, 60] Pi], Rational[-100, 3] 
             Cos[Rational[1, 60] Pi]}, {0, Rational[-100, 3]}, {
            Rational[-100, 3] Sin[Rational[1, 60] Pi], Rational[-100, 3] 
             Cos[Rational[1, 60] Pi]}, {
            Rational[-100, 3] Sin[Rational[1, 30] Pi], Rational[-100, 3] 
             Cos[Rational[1, 30] Pi]}, {
            Rational[-100, 3] Sin[Rational[1, 20] Pi], Rational[-100, 3] 
             Cos[Rational[1, 20] Pi]}, {
            Rational[-100, 3] Sin[Rational[1, 15] Pi], Rational[-100, 3] 
             Cos[Rational[1, 15] Pi]}, {
            Rational[-25, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2]), 
             Rational[-25, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2])}, {
            Rational[25, 3] (1 - 5^Rational[1, 2]), 
             Rational[-100, 3] (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
            Rational[-100, 3] Sin[Rational[7, 60] Pi], Rational[-100, 3] 
             Cos[Rational[7, 60] Pi]}, {
            Rational[-100, 3] Sin[Rational[2, 15] Pi], Rational[-100, 3] 
             Cos[Rational[2, 15] Pi]}, {
            Rational[-100, 3] Sin[Rational[3, 20] Pi], Rational[-100, 3] 
             Cos[Rational[3, 20] Pi]}, {
            Rational[-50, 3], (-50) 3^Rational[-1, 2]}, {
            Rational[-100, 3] Sin[Rational[11, 60] Pi], Rational[-100, 3] 
             Cos[Rational[11, 60] Pi]}, {
            Rational[-100, 3] (Rational[5, 8] + 
               Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[25, 3] (-1 - 5^Rational[1, 2])}, {
            Rational[-100, 3] Sin[Rational[13, 60] Pi], Rational[-100, 3] 
             Cos[Rational[13, 60] Pi]}, {
            Rational[-100, 3] Sin[Rational[7, 30] Pi], Rational[-100, 3] 
             Cos[Rational[7, 30] Pi]}, {
            Rational[-50, 3] 2^Rational[1, 2], Rational[-50, 3] 
             2^Rational[1, 2]}, {
            Rational[-100, 3] Cos[Rational[7, 30] Pi], Rational[-100, 3] 
             Sin[Rational[7, 30] Pi]}, {
            Rational[-100, 3] Cos[Rational[13, 60] Pi], Rational[-100, 3] 
             Sin[Rational[13, 60] Pi]}, {
            Rational[25, 3] (-1 - 5^Rational[1, 2]), 
             Rational[-100, 3] (Rational[5, 8] + 
               Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
            Rational[-100, 3] Cos[Rational[11, 60] Pi], Rational[-100, 3] 
             Sin[Rational[11, 60] Pi]}, {(-50) 3^Rational[-1, 2], 
             Rational[-50, 3]}, {
            Rational[-100, 3] Cos[Rational[3, 20] Pi], Rational[-100, 3] 
             Sin[Rational[3, 20] Pi]}, {
            Rational[-100, 3] Cos[Rational[2, 15] Pi], Rational[-100, 3] 
             Sin[Rational[2, 15] Pi]}, {
            Rational[-100, 3] Cos[Rational[7, 60] Pi], Rational[-100, 3] 
             Sin[Rational[7, 60] Pi]}, {
            Rational[-100, 3] (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[25, 3] (1 - 5^Rational[1, 2])}, {
            Rational[-25, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2]), 
             Rational[-25, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2])}, {
            Rational[-100, 3] Cos[Rational[1, 15] Pi], Rational[-100, 3] 
             Sin[Rational[1, 15] Pi]}, {
            Rational[-100, 3] Cos[Rational[1, 20] Pi], Rational[-100, 3] 
             Sin[Rational[1, 20] Pi]}, {
            Rational[-100, 3] Cos[Rational[1, 30] Pi], Rational[-100, 3] 
             Sin[Rational[1, 30] Pi]}, {
            Rational[-100, 3] Cos[Rational[1, 60] Pi], Rational[-100, 3] 
             Sin[Rational[1, 60] Pi]}, {Rational[-100, 3], 0}, {
            Rational[-100, 3] Cos[Rational[1, 60] Pi], Rational[100, 3] 
             Sin[Rational[1, 60] Pi]}, {
            Rational[-100, 3] Cos[Rational[1, 30] Pi], Rational[100, 3] 
             Sin[Rational[1, 30] Pi]}, {
            Rational[-100, 3] Cos[Rational[1, 20] Pi], Rational[100, 3] 
             Sin[Rational[1, 20] Pi]}, {
            Rational[-100, 3] Cos[Rational[1, 15] Pi], Rational[100, 3] 
             Sin[Rational[1, 15] Pi]}, {
            Rational[-25, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2]), 
             Rational[25, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2])}, {
            Rational[-100, 3] (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[25, 3] (-1 + 5^Rational[1, 2])}, {
            Rational[-100, 3] Cos[Rational[7, 60] Pi], Rational[100, 3] 
             Sin[Rational[7, 60] Pi]}, {
            Rational[-100, 3] Cos[Rational[2, 15] Pi], Rational[100, 3] 
             Sin[Rational[2, 15] Pi]}, {
            Rational[-100, 3] Cos[Rational[3, 20] Pi], Rational[100, 3] 
             Sin[Rational[3, 20] Pi]}, {(-50) 3^Rational[-1, 2], Rational[
             50, 3]}, {
            Rational[-100, 3] Cos[Rational[11, 60] Pi], Rational[100, 3] 
             Sin[Rational[11, 60] Pi]}, {
            Rational[25, 3] (-1 - 5^Rational[1, 2]), 
             Rational[
              100, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {
            Rational[-100, 3] Cos[Rational[13, 60] Pi], Rational[100, 3] 
             Sin[Rational[13, 60] Pi]}, {
            Rational[-100, 3] Cos[Rational[7, 30] Pi], Rational[100, 3] 
             Sin[Rational[7, 30] Pi]}, {
            Rational[-50, 3] 2^Rational[1, 2], Rational[50, 3] 
             2^Rational[1, 2]}, {
            Rational[-100, 3] Sin[Rational[7, 30] Pi], Rational[100, 3] 
             Cos[Rational[7, 30] Pi]}, {
            Rational[-100, 3] Sin[Rational[13, 60] Pi], Rational[100, 3] 
             Cos[Rational[13, 60] Pi]}, {
            Rational[-100, 3] (Rational[5, 8] + 
               Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[25, 3] (1 + 5^Rational[1, 2])}, {
            Rational[-100, 3] Sin[Rational[11, 60] Pi], Rational[100, 3] 
             Cos[Rational[11, 60] Pi]}, {
            Rational[-50, 3], 50 3^Rational[-1, 2]}, {
            Rational[-100, 3] Sin[Rational[3, 20] Pi], Rational[100, 3] 
             Cos[Rational[3, 20] Pi]}, {
            Rational[-100, 3] Sin[Rational[2, 15] Pi], Rational[100, 3] 
             Cos[Rational[2, 15] Pi]}, {
            Rational[-100, 3] Sin[Rational[7, 60] Pi], Rational[100, 3] 
             Cos[Rational[7, 60] Pi]}, {
            Rational[25, 3] (1 - 5^Rational[1, 2]), 
             Rational[
              100, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {
            Rational[-25, 3] 2^Rational[1, 2] (-1 + 3^Rational[1, 2]), 
             Rational[25, 3] 2^Rational[1, 2] (1 + 3^Rational[1, 2])}, {
            Rational[-100, 3] Sin[Rational[1, 15] Pi], Rational[100, 3] 
             Cos[Rational[1, 15] Pi]}, {
            Rational[-100, 3] Sin[Rational[1, 20] Pi], Rational[100, 3] 
             Cos[Rational[1, 20] Pi]}, {
            Rational[-100, 3] Sin[Rational[1, 30] Pi], Rational[100, 3] 
             Cos[Rational[1, 30] Pi]}, {
            Rational[-100, 3] Sin[Rational[1, 60] Pi], Rational[100, 3] 
             Cos[Rational[1, 60] Pi]}, {0, Rational[100, 3]}}, {{
            0, 33.333333333333336`}, {1.7445318747647944`, 
            33.287651158485794`}, {3.484282108921782, 33.15072984560911}, {
            5.214482168007696, 32.92294468650459}, {6.930389693925311, 
            32.60492002446019}, {8.627301503417359, 32.19752754296895}, {
            10.300566479164916`, 31.70188387650512}, {11.945598318176677`, 
            31.119347549906728`}, {13.557888102526674`, 
            30.451515254753364`}, {15.133016657984893`, 29.7002174729456}, {
            16.666666666666668`, 28.86751345948129}, {18.1546345005009, 
            27.955685598180803`}, {19.592841743082438`, 
            26.967233145831585`}, {20.977346368327918`, 25.90486538189903}, {
            22.304353545295275`, 24.77149418257981}, {23.57022603955159, 
            23.57022603955159}, {24.77149418257981, 22.304353545295275`}, {
            25.90486538189903, 20.977346368327918`}, {26.967233145831585`, 
            19.592841743082438`}, {27.955685598180803`, 18.1546345005009}, {
            28.86751345948129, 16.666666666666668`}, {29.7002174729456, 
            15.133016657984893`}, {30.451515254753364`, 
            13.557888102526674`}, {31.119347549906728`, 
            11.945598318176677`}, {31.70188387650512, 10.300566479164916`}, {
            32.19752754296895, 8.627301503417359}, {32.60492002446019, 
            6.930389693925311}, {32.92294468650459, 5.214482168007696}, {
            33.15072984560911, 3.484282108921782}, {33.287651158485794`, 
            1.7445318747647944`}, {33.333333333333336`, 0}, {
            33.287651158485794`, -1.7445318747647944`}, {
            33.15072984560911, -3.484282108921782}, {
            32.92294468650459, -5.214482168007696}, {
            32.60492002446019, -6.930389693925311}, {
            32.19752754296895, -8.627301503417359}, {
            31.70188387650512, -10.300566479164916`}, {
            31.119347549906728`, -11.945598318176677`}, {
            30.451515254753364`, -13.557888102526674`}, {
            29.7002174729456, -15.133016657984893`}, {
            28.86751345948129, -16.666666666666668`}, {
            27.955685598180803`, -18.1546345005009}, {
            26.967233145831585`, -19.592841743082438`}, {
            25.90486538189903, -20.977346368327918`}, {
            24.77149418257981, -22.304353545295275`}, {
            23.57022603955159, -23.57022603955159}, {
            22.304353545295275`, -24.77149418257981}, {
            20.977346368327918`, -25.90486538189903}, {
            19.592841743082438`, -26.967233145831585`}, {
            18.1546345005009, -27.955685598180803`}, {
            16.666666666666668`, -28.86751345948129}, {
            15.133016657984893`, -29.7002174729456}, {
            13.557888102526674`, -30.451515254753364`}, {
            11.945598318176677`, -31.119347549906728`}, {
            10.300566479164916`, -31.70188387650512}, {
            8.627301503417359, -32.19752754296895}, {
            6.930389693925311, -32.60492002446019}, {
            5.214482168007696, -32.92294468650459}, {
            3.484282108921782, -33.15072984560911}, {
            1.7445318747647944`, -33.287651158485794`}, {
            0, -33.333333333333336`}, {-1.7445318747647944`, \
-33.287651158485794`}, {-3.484282108921782, -33.15072984560911}, \
{-5.214482168007696, -32.92294468650459}, {-6.930389693925311, \
-32.60492002446019}, {-8.627301503417359, -32.19752754296895}, \
{-10.300566479164916`, -31.70188387650512}, {-11.945598318176677`, \
-31.119347549906728`}, {-13.557888102526674`, -30.451515254753364`}, \
{-15.133016657984893`, -29.7002174729456}, {-16.666666666666668`, \
-28.86751345948129}, {-18.1546345005009, -27.955685598180803`}, \
{-19.592841743082438`, -26.967233145831585`}, {-20.977346368327918`, \
-25.90486538189903}, {-22.304353545295275`, -24.77149418257981}, \
{-23.57022603955159, -23.57022603955159}, {-24.77149418257981, \
-22.304353545295275`}, {-25.90486538189903, -20.977346368327918`}, \
{-26.967233145831585`, -19.592841743082438`}, {-27.955685598180803`, \
-18.1546345005009}, {-28.86751345948129, -16.666666666666668`}, \
{-29.7002174729456, -15.133016657984893`}, {-30.451515254753364`, \
-13.557888102526674`}, {-31.119347549906728`, -11.945598318176677`}, \
{-31.70188387650512, -10.300566479164916`}, {-32.19752754296895, \
-8.627301503417359}, {-32.60492002446019, -6.930389693925311}, \
{-32.92294468650459, -5.214482168007696}, {-33.15072984560911, \
-3.484282108921782}, {-33.287651158485794`, -1.7445318747647944`}, \
{-33.333333333333336`, 0}, {-33.287651158485794`, 
            1.7445318747647944`}, {-33.15072984560911, 
            3.484282108921782}, {-32.92294468650459, 
            5.214482168007696}, {-32.60492002446019, 
            6.930389693925311}, {-32.19752754296895, 
            8.627301503417359}, {-31.70188387650512, 
            10.300566479164916`}, {-31.119347549906728`, 
            11.945598318176677`}, {-30.451515254753364`, 
            13.557888102526674`}, {-29.7002174729456, 
            15.133016657984893`}, {-28.86751345948129, 
            16.666666666666668`}, {-27.955685598180803`, 
            18.1546345005009}, {-26.967233145831585`, 
            19.592841743082438`}, {-25.90486538189903, 
            20.977346368327918`}, {-24.77149418257981, 
            22.304353545295275`}, {-23.57022603955159, 
            23.57022603955159}, {-22.304353545295275`, 
            24.77149418257981}, {-20.977346368327918`, 
            25.90486538189903}, {-19.592841743082438`, 
            26.967233145831585`}, {-18.1546345005009, 
            27.955685598180803`}, {-16.666666666666668`, 
            28.86751345948129}, {-15.133016657984893`, 
            29.7002174729456}, {-13.557888102526674`, 
            30.451515254753364`}, {-11.945598318176677`, 
            31.119347549906728`}, {-10.300566479164916`, 
            31.70188387650512}, {-8.627301503417359, 
            32.19752754296895}, {-6.930389693925311, 
            32.60492002446019}, {-5.214482168007696, 
            32.92294468650459}, {-3.484282108921782, 
            33.15072984560911}, {-1.7445318747647944`, 33.287651158485794`}, {
            0, 33.333333333333336`}}]], 
         BezierCurveBox[
          NCache[{{0, Rational[50, 3]}, {
            Rational[50, 3] Sin[Rational[1, 60] Pi], Rational[50, 3] 
             Cos[Rational[1, 60] Pi]}, {
            Rational[50, 3] Sin[Rational[1, 30] Pi], Rational[50, 3] 
             Cos[Rational[1, 30] Pi]}, {
            Rational[50, 3] Sin[Rational[1, 20] Pi], Rational[50, 3] 
             Cos[Rational[1, 20] Pi]}, {
            Rational[50, 3] Sin[Rational[1, 15] Pi], Rational[50, 3] 
             Cos[Rational[1, 15] Pi]}, {
            Rational[25, 3] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 
             Rational[25, 3] 2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
            Rational[25, 6] (-1 + 5^Rational[1, 2]), 
             Rational[
              50, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {
            Rational[50, 3] Sin[Rational[7, 60] Pi], Rational[50, 3] 
             Cos[Rational[7, 60] Pi]}, {
            Rational[50, 3] Sin[Rational[2, 15] Pi], Rational[50, 3] 
             Cos[Rational[2, 15] Pi]}, {
            Rational[50, 3] Sin[Rational[3, 20] Pi], Rational[50, 3] 
             Cos[Rational[3, 20] Pi]}, {
            Rational[25, 3], 25 3^Rational[-1, 2]}, {
            Rational[50, 3] Sin[Rational[11, 60] Pi], Rational[50, 3] 
             Cos[Rational[11, 60] Pi]}, {
            Rational[
              50, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[25, 6] (1 + 5^Rational[1, 2])}, {
            Rational[50, 3] Sin[Rational[13, 60] Pi], Rational[50, 3] 
             Cos[Rational[13, 60] Pi]}, {
            Rational[50, 3] Sin[Rational[7, 30] Pi], Rational[50, 3] 
             Cos[Rational[7, 30] Pi]}, {
            Rational[25, 3] 2^Rational[1, 2], Rational[25, 3] 
             2^Rational[1, 2]}, {
            Rational[50, 3] Cos[Rational[7, 30] Pi], Rational[50, 3] 
             Sin[Rational[7, 30] Pi]}, {
            Rational[50, 3] Cos[Rational[13, 60] Pi], Rational[50, 3] 
             Sin[Rational[13, 60] Pi]}, {
            Rational[25, 6] (1 + 5^Rational[1, 2]), 
             Rational[
              50, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {
            Rational[50, 3] Cos[Rational[11, 60] Pi], Rational[50, 3] 
             Sin[Rational[11, 60] Pi]}, {
            25 3^Rational[-1, 2], Rational[25, 3]}, {
            Rational[50, 3] Cos[Rational[3, 20] Pi], Rational[50, 3] 
             Sin[Rational[3, 20] Pi]}, {
            Rational[50, 3] Cos[Rational[2, 15] Pi], Rational[50, 3] 
             Sin[Rational[2, 15] Pi]}, {
            Rational[50, 3] Cos[Rational[7, 60] Pi], Rational[50, 3] 
             Sin[Rational[7, 60] Pi]}, {
            Rational[
              50, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[25, 6] (-1 + 5^Rational[1, 2])}, {
            Rational[25, 3] 2^Rational[-1, 2] (1 + 3^Rational[1, 2]), 
             Rational[25, 3] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {
            Rational[50, 3] Cos[Rational[1, 15] Pi], Rational[50, 3] 
             Sin[Rational[1, 15] Pi]}, {
            Rational[50, 3] Cos[Rational[1, 20] Pi], Rational[50, 3] 
             Sin[Rational[1, 20] Pi]}, {
            Rational[50, 3] Cos[Rational[1, 30] Pi], Rational[50, 3] 
             Sin[Rational[1, 30] Pi]}, {
            Rational[50, 3] Cos[Rational[1, 60] Pi], Rational[50, 3] 
             Sin[Rational[1, 60] Pi]}, {Rational[50, 3], 0}, {
            Rational[50, 3] Cos[Rational[1, 60] Pi], Rational[-50, 3] 
             Sin[Rational[1, 60] Pi]}, {
            Rational[50, 3] Cos[Rational[1, 30] Pi], Rational[-50, 3] 
             Sin[Rational[1, 30] Pi]}, {
            Rational[50, 3] Cos[Rational[1, 20] Pi], Rational[-50, 3] 
             Sin[Rational[1, 20] Pi]}, {
            Rational[50, 3] Cos[Rational[1, 15] Pi], Rational[-50, 3] 
             Sin[Rational[1, 15] Pi]}, {
            Rational[25, 3] 2^Rational[-1, 2] (1 + 3^Rational[1, 2]), 
             Rational[-25, 3] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {
            Rational[
              50, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[25, 6] (1 - 5^Rational[1, 2])}, {
            Rational[50, 3] Cos[Rational[7, 60] Pi], Rational[-50, 3] 
             Sin[Rational[7, 60] Pi]}, {
            Rational[50, 3] Cos[Rational[2, 15] Pi], Rational[-50, 3] 
             Sin[Rational[2, 15] Pi]}, {
            Rational[50, 3] Cos[Rational[3, 20] Pi], Rational[-50, 3] 
             Sin[Rational[3, 20] Pi]}, {
            25 3^Rational[-1, 2], Rational[-25, 3]}, {
            Rational[50, 3] Cos[Rational[11, 60] Pi], Rational[-50, 3] 
             Sin[Rational[11, 60] Pi]}, {
            Rational[25, 6] (1 + 5^Rational[1, 2]), 
             Rational[-50, 3] (Rational[5, 8] + 
               Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
            Rational[50, 3] Cos[Rational[13, 60] Pi], Rational[-50, 3] 
             Sin[Rational[13, 60] Pi]}, {
            Rational[50, 3] Cos[Rational[7, 30] Pi], Rational[-50, 3] 
             Sin[Rational[7, 30] Pi]}, {
            Rational[25, 3] 2^Rational[1, 2], Rational[-25, 3] 
             2^Rational[1, 2]}, {
            Rational[50, 3] Sin[Rational[7, 30] Pi], Rational[-50, 3] 
             Cos[Rational[7, 30] Pi]}, {
            Rational[50, 3] Sin[Rational[13, 60] Pi], Rational[-50, 3] 
             Cos[Rational[13, 60] Pi]}, {
            Rational[
              50, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2], Rational[25, 6] (-1 - 5^Rational[1, 2])}, {
            Rational[50, 3] Sin[Rational[11, 60] Pi], Rational[-50, 3] 
             Cos[Rational[11, 60] Pi]}, {
            Rational[25, 3], (-25) 3^Rational[-1, 2]}, {
            Rational[50, 3] Sin[Rational[3, 20] Pi], Rational[-50, 3] 
             Cos[Rational[3, 20] Pi]}, {
            Rational[50, 3] Sin[Rational[2, 15] Pi], Rational[-50, 3] 
             Cos[Rational[2, 15] Pi]}, {
            Rational[50, 3] Sin[Rational[7, 60] Pi], Rational[-50, 3] 
             Cos[Rational[7, 60] Pi]}, {
            Rational[25, 6] (-1 + 5^Rational[1, 2]), 
             Rational[-50, 3] (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
            Rational[25, 3] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 
             Rational[-25, 3] 2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
            Rational[50, 3] Sin[Rational[1, 15] Pi], Rational[-50, 3] 
             Cos[Rational[1, 15] Pi]}, {
            Rational[50, 3] Sin[Rational[1, 20] Pi], Rational[-50, 3] 
             Cos[Rational[1, 20] Pi]}, {
            Rational[50, 3] Sin[Rational[1, 30] Pi], Rational[-50, 3] 
             Cos[Rational[1, 30] Pi]}, {
            Rational[50, 3] Sin[Rational[1, 60] Pi], Rational[-50, 3] 
             Cos[Rational[1, 60] Pi]}, {0, Rational[-50, 3]}, {
            Rational[-50, 3] Sin[Rational[1, 60] Pi], Rational[-50, 3] 
             Cos[Rational[1, 60] Pi]}, {
            Rational[-50, 3] Sin[Rational[1, 30] Pi], Rational[-50, 3] 
             Cos[Rational[1, 30] Pi]}, {
            Rational[-50, 3] Sin[Rational[1, 20] Pi], Rational[-50, 3] 
             Cos[Rational[1, 20] Pi]}, {
            Rational[-50, 3] Sin[Rational[1, 15] Pi], Rational[-50, 3] 
             Cos[Rational[1, 15] Pi]}, {
            Rational[-25, 3] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 
             Rational[-25, 3] 2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
            Rational[25, 6] (1 - 5^Rational[1, 2]), 
             Rational[-50, 3] (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
            Rational[-50, 3] Sin[Rational[7, 60] Pi], Rational[-50, 3] 
             Cos[Rational[7, 60] Pi]}, {
            Rational[-50, 3] Sin[Rational[2, 15] Pi], Rational[-50, 3] 
             Cos[Rational[2, 15] Pi]}, {
            Rational[-50, 3] Sin[Rational[3, 20] Pi], Rational[-50, 3] 
             Cos[Rational[3, 20] Pi]}, {
            Rational[-25, 3], (-25) 3^Rational[-1, 2]}, {
            Rational[-50, 3] Sin[Rational[11, 60] Pi], Rational[-50, 3] 
             Cos[Rational[11, 60] Pi]}, {
            Rational[-50, 3] (Rational[5, 8] + 
               Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[25, 6] (-1 - 5^Rational[1, 2])}, {
            Rational[-50, 3] Sin[Rational[13, 60] Pi], Rational[-50, 3] 
             Cos[Rational[13, 60] Pi]}, {
            Rational[-50, 3] Sin[Rational[7, 30] Pi], Rational[-50, 3] 
             Cos[Rational[7, 30] Pi]}, {
            Rational[-25, 3] 2^Rational[1, 2], Rational[-25, 3] 
             2^Rational[1, 2]}, {
            Rational[-50, 3] Cos[Rational[7, 30] Pi], Rational[-50, 3] 
             Sin[Rational[7, 30] Pi]}, {
            Rational[-50, 3] Cos[Rational[13, 60] Pi], Rational[-50, 3] 
             Sin[Rational[13, 60] Pi]}, {
            Rational[25, 6] (-1 - 5^Rational[1, 2]), 
             Rational[-50, 3] (Rational[5, 8] + 
               Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
            Rational[-50, 3] Cos[Rational[11, 60] Pi], Rational[-50, 3] 
             Sin[Rational[11, 60] Pi]}, {(-25) 3^Rational[-1, 2], 
             Rational[-25, 3]}, {
            Rational[-50, 3] Cos[Rational[3, 20] Pi], Rational[-50, 3] 
             Sin[Rational[3, 20] Pi]}, {
            Rational[-50, 3] Cos[Rational[2, 15] Pi], Rational[-50, 3] 
             Sin[Rational[2, 15] Pi]}, {
            Rational[-50, 3] Cos[Rational[7, 60] Pi], Rational[-50, 3] 
             Sin[Rational[7, 60] Pi]}, {
            Rational[-50, 3] (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[25, 6] (1 - 5^Rational[1, 2])}, {
            Rational[-25, 3] 2^Rational[-1, 2] (1 + 3^Rational[1, 2]), 
             Rational[-25, 3] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {
            Rational[-50, 3] Cos[Rational[1, 15] Pi], Rational[-50, 3] 
             Sin[Rational[1, 15] Pi]}, {
            Rational[-50, 3] Cos[Rational[1, 20] Pi], Rational[-50, 3] 
             Sin[Rational[1, 20] Pi]}, {
            Rational[-50, 3] Cos[Rational[1, 30] Pi], Rational[-50, 3] 
             Sin[Rational[1, 30] Pi]}, {
            Rational[-50, 3] Cos[Rational[1, 60] Pi], Rational[-50, 3] 
             Sin[Rational[1, 60] Pi]}, {Rational[-50, 3], 0}, {
            Rational[-50, 3] Cos[Rational[1, 60] Pi], Rational[50, 3] 
             Sin[Rational[1, 60] Pi]}, {
            Rational[-50, 3] Cos[Rational[1, 30] Pi], Rational[50, 3] 
             Sin[Rational[1, 30] Pi]}, {
            Rational[-50, 3] Cos[Rational[1, 20] Pi], Rational[50, 3] 
             Sin[Rational[1, 20] Pi]}, {
            Rational[-50, 3] Cos[Rational[1, 15] Pi], Rational[50, 3] 
             Sin[Rational[1, 15] Pi]}, {
            Rational[-25, 3] 2^Rational[-1, 2] (1 + 3^Rational[1, 2]), 
             Rational[25, 3] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {
            Rational[-50, 3] (Rational[5, 8] + 
               Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[25, 6] (-1 + 5^Rational[1, 2])}, {
            Rational[-50, 3] Cos[Rational[7, 60] Pi], Rational[50, 3] 
             Sin[Rational[7, 60] Pi]}, {
            Rational[-50, 3] Cos[Rational[2, 15] Pi], Rational[50, 3] 
             Sin[Rational[2, 15] Pi]}, {
            Rational[-50, 3] Cos[Rational[3, 20] Pi], Rational[50, 3] 
             Sin[Rational[3, 20] Pi]}, {(-25) 3^Rational[-1, 2], Rational[
             25, 3]}, {
            Rational[-50, 3] Cos[Rational[11, 60] Pi], Rational[50, 3] 
             Sin[Rational[11, 60] Pi]}, {
            Rational[25, 6] (-1 - 5^Rational[1, 2]), 
             Rational[
              50, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {
            Rational[-50, 3] Cos[Rational[13, 60] Pi], Rational[50, 3] 
             Sin[Rational[13, 60] Pi]}, {
            Rational[-50, 3] Cos[Rational[7, 30] Pi], Rational[50, 3] 
             Sin[Rational[7, 30] Pi]}, {
            Rational[-25, 3] 2^Rational[1, 2], Rational[25, 3] 
             2^Rational[1, 2]}, {
            Rational[-50, 3] Sin[Rational[7, 30] Pi], Rational[50, 3] 
             Cos[Rational[7, 30] Pi]}, {
            Rational[-50, 3] Sin[Rational[13, 60] Pi], Rational[50, 3] 
             Cos[Rational[13, 60] Pi]}, {
            Rational[-50, 3] (Rational[5, 8] + 
               Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
             Rational[25, 6] (1 + 5^Rational[1, 2])}, {
            Rational[-50, 3] Sin[Rational[11, 60] Pi], Rational[50, 3] 
             Cos[Rational[11, 60] Pi]}, {
            Rational[-25, 3], 25 3^Rational[-1, 2]}, {
            Rational[-50, 3] Sin[Rational[3, 20] Pi], Rational[50, 3] 
             Cos[Rational[3, 20] Pi]}, {
            Rational[-50, 3] Sin[Rational[2, 15] Pi], Rational[50, 3] 
             Cos[Rational[2, 15] Pi]}, {
            Rational[-50, 3] Sin[Rational[7, 60] Pi], Rational[50, 3] 
             Cos[Rational[7, 60] Pi]}, {
            Rational[25, 6] (1 - 5^Rational[1, 2]), 
             Rational[
              50, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2]}, {
            Rational[-25, 3] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 
             Rational[25, 3] 2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
            Rational[-50, 3] Sin[Rational[1, 15] Pi], Rational[50, 3] 
             Cos[Rational[1, 15] Pi]}, {
            Rational[-50, 3] Sin[Rational[1, 20] Pi], Rational[50, 3] 
             Cos[Rational[1, 20] Pi]}, {
            Rational[-50, 3] Sin[Rational[1, 30] Pi], Rational[50, 3] 
             Cos[Rational[1, 30] Pi]}, {
            Rational[-50, 3] Sin[Rational[1, 60] Pi], Rational[50, 3] 
             Cos[Rational[1, 60] Pi]}, {0, Rational[50, 3]}}, {{
            0, 16.666666666666668`}, {0.8722659373823972, 
            16.643825579242897`}, {1.742141054460891, 16.575364922804557`}, {
            2.607241084003848, 16.461472343252296`}, {3.4651948469626555`, 
            16.302460012230096`}, {4.313650751708679, 16.09876377148447}, {
            5.150283239582458, 15.85094193825256}, {5.972799159088338, 
            15.559673774953364`}, {6.778944051263337, 15.225757627376682`}, {
            7.566508328992446, 14.8501087364728}, {8.333333333333334, 
            14.433756729740645`}, {9.07731725025045, 13.977842799090402`}, {
            9.796420871541219, 13.483616572915793`}, {10.488673184163959`, 
            12.952432690949514`}, {11.152176772647637`, 
            12.385747091289906`}, {11.785113019775794`, 
            11.785113019775794`}, {12.385747091289906`, 
            11.152176772647637`}, {12.952432690949514`, 
            10.488673184163959`}, {13.483616572915793`, 9.796420871541219}, {
            13.977842799090402`, 9.07731725025045}, {14.433756729740645`, 
            8.333333333333334}, {14.8501087364728, 7.566508328992446}, {
            15.225757627376682`, 6.778944051263337}, {15.559673774953364`, 
            5.972799159088338}, {15.85094193825256, 5.150283239582458}, {
            16.09876377148447, 4.313650751708679}, {16.302460012230096`, 
            3.4651948469626555`}, {16.461472343252296`, 2.607241084003848}, {
            16.575364922804557`, 1.742141054460891}, {16.643825579242897`, 
            0.8722659373823972}, {16.666666666666668`, 0}, {
            16.643825579242897`, -0.8722659373823972}, {
            16.575364922804557`, -1.742141054460891}, {
            16.461472343252296`, -2.607241084003848}, {
            16.302460012230096`, -3.4651948469626555`}, {
            16.09876377148447, -4.313650751708679}, {
            15.85094193825256, -5.150283239582458}, {
            15.559673774953364`, -5.972799159088338}, {
            15.225757627376682`, -6.778944051263337}, {
            14.8501087364728, -7.566508328992446}, {
            14.433756729740645`, -8.333333333333334}, {
            13.977842799090402`, -9.07731725025045}, {
            13.483616572915793`, -9.796420871541219}, {
            12.952432690949514`, -10.488673184163959`}, {
            12.385747091289906`, -11.152176772647637`}, {
            11.785113019775794`, -11.785113019775794`}, {
            11.152176772647637`, -12.385747091289906`}, {
            10.488673184163959`, -12.952432690949514`}, {
            9.796420871541219, -13.483616572915793`}, {
            9.07731725025045, -13.977842799090402`}, {
            8.333333333333334, -14.433756729740645`}, {
            7.566508328992446, -14.8501087364728}, {
            6.778944051263337, -15.225757627376682`}, {
            5.972799159088338, -15.559673774953364`}, {
            5.150283239582458, -15.85094193825256}, {
            4.313650751708679, -16.09876377148447}, {
            3.4651948469626555`, -16.302460012230096`}, {
            2.607241084003848, -16.461472343252296`}, {
            1.742141054460891, -16.575364922804557`}, {
            0.8722659373823972, -16.643825579242897`}, {
            0, -16.666666666666668`}, {-0.8722659373823972, \
-16.643825579242897`}, {-1.742141054460891, -16.575364922804557`}, \
{-2.607241084003848, -16.461472343252296`}, {-3.4651948469626555`, \
-16.302460012230096`}, {-4.313650751708679, -16.09876377148447}, \
{-5.150283239582458, -15.85094193825256}, {-5.972799159088338, \
-15.559673774953364`}, {-6.778944051263337, -15.225757627376682`}, \
{-7.566508328992446, -14.8501087364728}, {-8.333333333333334, \
-14.433756729740645`}, {-9.07731725025045, -13.977842799090402`}, \
{-9.796420871541219, -13.483616572915793`}, {-10.488673184163959`, \
-12.952432690949514`}, {-11.152176772647637`, -12.385747091289906`}, \
{-11.785113019775794`, -11.785113019775794`}, {-12.385747091289906`, \
-11.152176772647637`}, {-12.952432690949514`, -10.488673184163959`}, \
{-13.483616572915793`, -9.796420871541219}, {-13.977842799090402`, \
-9.07731725025045}, {-14.433756729740645`, -8.333333333333334}, \
{-14.8501087364728, -7.566508328992446}, {-15.225757627376682`, \
-6.778944051263337}, {-15.559673774953364`, -5.972799159088338}, \
{-15.85094193825256, -5.150283239582458}, {-16.09876377148447, \
-4.313650751708679}, {-16.302460012230096`, -3.4651948469626555`}, \
{-16.461472343252296`, -2.607241084003848}, {-16.575364922804557`, \
-1.742141054460891}, {-16.643825579242897`, -0.8722659373823972}, \
{-16.666666666666668`, 0}, {-16.643825579242897`, 
            0.8722659373823972}, {-16.575364922804557`, 
            1.742141054460891}, {-16.461472343252296`, 
            2.607241084003848}, {-16.302460012230096`, 
            3.4651948469626555`}, {-16.09876377148447, 
            4.313650751708679}, {-15.85094193825256, 
            5.150283239582458}, {-15.559673774953364`, 
            5.972799159088338}, {-15.225757627376682`, 
            6.778944051263337}, {-14.8501087364728, 
            7.566508328992446}, {-14.433756729740645`, 
            8.333333333333334}, {-13.977842799090402`, 
            9.07731725025045}, {-13.483616572915793`, 
            9.796420871541219}, {-12.952432690949514`, 
            10.488673184163959`}, {-12.385747091289906`, 
            11.152176772647637`}, {-11.785113019775794`, 
            11.785113019775794`}, {-11.152176772647637`, 
            12.385747091289906`}, {-10.488673184163959`, 
            12.952432690949514`}, {-9.796420871541219, 
            13.483616572915793`}, {-9.07731725025045, 
            13.977842799090402`}, {-8.333333333333334, 
            14.433756729740645`}, {-7.566508328992446, 
            14.8501087364728}, {-6.778944051263337, 
            15.225757627376682`}, {-5.972799159088338, 
            15.559673774953364`}, {-5.150283239582458, 
            15.85094193825256}, {-4.313650751708679, 
            16.09876377148447}, {-3.4651948469626555`, 
            16.302460012230096`}, {-2.607241084003848, 
            16.461472343252296`}, {-1.742141054460891, 
            16.575364922804557`}, {-0.8722659373823972, 
            16.643825579242897`}, {
            0, 16.666666666666668`}}]]}}, {{{}, {}}, {}, {{}, 
         GraphicsComplexBox[CompressedData["
1:eJxdkns4FPgexmfcsnFCUQe5FRLjOswwxvn9io7Loi2XpWxJqJOWXBrrki7a
ItZlRRi3Zra1sjyVTYtZvx/lrjRLchkjd3KbcQu5nNZ59vzR+zzf5/vP+7zv
+8dHwyfouJ8IgUAI+nR/fflS24FIeUnMINfcfp1cyYkXaH4Vul8CJ0mvBGTS
+lH/qm/KZJ4oFi9f2lmfMoXqOn1K5pMIWPX7yWO/q86jwKeBw+7Kq6im2bFz
bWwRcfv9d9x8JEQbL+qJ7+QXkcOn9E8VyO4chffFzDTK/mk2/pv9L5CFXdqm
2sNe1F7LMlZovI8idptafUFpQl7Du7x5qpH0rVmlb5HR73vu1FtgoDzzoMOZ
OIYUTqiGyzh2gfcu0kGnHgnQs60ho8CY5PKbfMk8sqj7g5j8XADODFR+jFyd
R74PilOg6SJwqYekrmYhUrB2SigGy4CwpSkkBKTvbZJXgO6dX9aUmYOI+trn
yelTKyBktfpW3DAX/c/3t59AMFA30mNWL4LIpYDar399Ba455Ds9E84Bfu/m
DPNuL6B/3Lvr6b1ZYLX9LfuS1SAIcllSDIuZACYOUoc8fEfAzuiOHn+dYZD3
yvLctPg4OJFcu6jj1Q/E6r317ulMApdQzdPz7LeAEB93eJQuAJp51L1uoa2g
ge91j6a3AJihOy73yuTQg7cKVkBpa3kMHn6D+DMLpLjtm2BZSabMTTCBzNrc
+Nu5RCi6tXoJPf2NczXsH6KQUlUTMmS9iZbpI29d74vAhpSzWhdaRDFjcqlD
NocAQ0MGTeZ4EtjP/y+tgoUnOyIV0iWx4WvPH9aHhWCD1Xnca0QSZ7hcuG2Q
PAA+44e+3yEq1tBxFSnbJD7eJlLCwczoJm7SOgqFijKCrg6kxlGSmjEm4C6a
h3A1bQyZe3UXEQMImNg2iSiLc0ic0uA3E72O0szWDJ2rl5FrRNX9jsYFdDFD
9bJq3TKKqM5XMuwbQkpGPPFRshBFEbTON6rWoRbSh9rron2oAKjc0CWHIdqz
wsVGdg4SNRZPmkj3oceaagd6dWN06OTpArmXP4KQsqYjcr9Uoioftxz6cQaQ
n2La8IuS0IWpN8HW/hXAIlWgoL5Zh940jbNIJC5Itj64Wye8A7n+rBkistwP
RI0apMjtPahB965cWsw4qLPOQiw7HhITLK0X3hUAEvXWy/L9XaidHTjMDV4A
zd5K9eOdrai03Odqt9WH//OUxVbvoQUugwDNxwE6llywtnxp6GHGBxBVG+bV
rDcAkioSJFMfL4B/85Cn0sgYIHSJldpaCsCaVqPdWatJ0H3TSaU+eBTE98bO
JaD3QLQ+6ralWC+4bWgox/IbA4Hmju7+Uy3gP1mH7MQMhkBzoqP3H5vlQMLe
jjjg9A5MHBvgxmRdpzNmh9J2TPSDTGH7ySGLCkSj/7hXdnAAiFDKKkNJr5Ci
t+yVRxXD4D3nSKnlpR6kZOxKY4yMAh48M62bPIQMG0zOHD06BuKbTa8OjE2g
kohqqTbOCFhrk8mY3CZA9iavbrXeGATfVTKs/TTnUeJmfoQvvxccYr/DRb5L
yNf5QF96Rhv4jB/6bNPzwyWe5rhH0ipfk/eeE8rJnCq2pGJpFJQj8JHFg003
HXZUmOHChRdkeoEaPpx29GTzNlNsYxuyIqNxAK8/iNrzRNsEF2jntsozDLB/
doVq2KQhnvK9uaIvTsZRUpo6MZq6+Gs/1/N8NgUjZoW92Y19eO+f4Z4y31rg
ef1alSjpXXhJ4BiyQrTEF8v+fMIw4tPpztxUr1OW+NmevOfBTTth7L/WK6dZ
NDzDGUw9b7IPNqZMFQRtmuPc4pKu06q6kH3PV5iaR8E966sq16ONYJ7trMrL
B2RsIfrP8hUXMlTz3KfTRTXCfewpwUSCGYyNB3doAzo4M+5LxSpFKlTY/Cjb
9Vodr3w73ZP6gQqZElV24WOyONNRIdFhnzn8m6df22WKzNOpsGtOwFRkycIL
G6yWLGcKtGGkU1bp6nDhcnaUlocp5NM2Gd1XDsBzKWw1UosxpOfyf4rm6cOD
DxXdr/2gD42OVRxVzjGGTtkSR+Y7tWGopF4ss4EMySNG2P2wGswZaSpL/s4M
6tq6t94Qk4UsvlVr01MKTMiu2Wgb76afbOcMyV+hQodcSTculsXciI/EekyF
GldODCaIaWDr9suFNd5U6Gafe02bdRBbHePqrZtQYGOiy4nCHiOs9WhjO3G3
KRQaRFv+/KUpNj670PdwmzGM2Bnuqd9NwaanKu2lfXRhfjHTY9zDHPMUOXGG
FRowGnlTL740x0XmiS6OMXLwM37o/wXoeHUv
          "], {{}, {}, 
           {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
            0.009166666666666668], Thickness[0.01], 
            LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 
             17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 
             33, 34, 35, 36, 37}]}, 
           {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
            0.009166666666666668], Thickness[0.01], 
            LineBox[{38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
             52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 
             68, 69, 70, 71, 72, 73, 74}]}, 
           {RGBColor[0.560181, 0.691569, 0.194885], PointSize[
            0.009166666666666668], Thickness[0.01], 
            LineBox[{75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 
             89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 
             104, 105, 106, 107, 108, 109, 110, 
             111}]}}], {}, {}, {{}, {}}}, {}, {}, {{}, {}}, {}, {{{}, {}, {}, \
{}}, {}}}},
      ImageSize->600], 
     TemplateBox[{GraphicsBox[{{
          Opacity[0.9], {
           LineBox[{{0, 0}, {0, 5}}], 
           LineBox[
            NCache[{{0, 0}, {
               Rational[5, 2], Rational[5, 2] 3^Rational[1, 2]}}, {{0, 0}, {
              2.5, 4.330127018922193}}]], 
           LineBox[
            NCache[{{0, 0}, {Rational[5, 2] 3^Rational[1, 2], 
               Rational[5, 2]}}, {{0, 0}, {4.330127018922193, 2.5}}]], 
           LineBox[{{0, 0}, {5, 0}}], 
           LineBox[
            NCache[{{0, 0}, {Rational[5, 2] 3^Rational[1, 2], 
               Rational[-5, 2]}}, {{0, 0}, {4.330127018922193, -2.5}}]], 
           LineBox[
            NCache[{{0, 0}, {
               Rational[5, 2], Rational[-5, 2] 3^Rational[1, 2]}}, {{0, 0}, {
              2.5, -4.330127018922193}}]], 
           LineBox[{{0, 0}, {0, -5}}], 
           LineBox[
            NCache[{{0, 0}, {
               Rational[-5, 2], Rational[-5, 2] 3^Rational[1, 2]}}, {{0, 
              0}, {-2.5, -4.330127018922193}}]], 
           LineBox[
            NCache[{{0, 0}, {Rational[-5, 2] 3^Rational[1, 2], 
               Rational[-5, 2]}}, {{0, 0}, {-4.330127018922193, -2.5}}]], 
           LineBox[{{0, 0}, {-5, 0}}], 
           LineBox[
            NCache[{{0, 0}, {Rational[-5, 2] 3^Rational[1, 2], 
               Rational[5, 2]}}, {{0, 0}, {-4.330127018922193, 2.5}}]], 
           LineBox[
            NCache[{{0, 0}, {
               Rational[-5, 2], Rational[5, 2] 3^Rational[1, 2]}}, {{0, 
              0}, {-2.5, 4.330127018922193}}]], 
           LineBox[{{0, 0}, {0, 5}}]}, {
           InsetBox[
            FormBox[
             StyleBox[
              
              TemplateBox[{"\"0\"", "\"\[Degree]\""}, "Superscript", 
               SyntaxForm -> SuperscriptBox], 30, StripOnInput -> False], 
             TraditionalForm], {5.5, 0.}], 
           InsetBox[
            FormBox[
             StyleBox[
              
              TemplateBox[{"\"30\"", "\"\[Degree]\""}, "Superscript", 
               SyntaxForm -> SuperscriptBox], 30, StripOnInput -> False], 
             TraditionalForm], {4.763139720814412, 2.75}], 
           InsetBox[
            FormBox[
             StyleBox[
              
              TemplateBox[{"\"60\"", "\"\[Degree]\""}, "Superscript", 
               SyntaxForm -> SuperscriptBox], 30, StripOnInput -> False], 
             TraditionalForm], {2.75, 4.763139720814412}], 
           InsetBox[
            FormBox[
             StyleBox[
              
              TemplateBox[{"\"90\"", "\"\[Degree]\""}, "Superscript", 
               SyntaxForm -> SuperscriptBox], 30, StripOnInput -> False], 
             TraditionalForm], {0., 5.5}], 
           InsetBox[
            FormBox[
             StyleBox[
              
              TemplateBox[{"\"120\"", "\"\[Degree]\""}, "Superscript", 
               SyntaxForm -> SuperscriptBox], 30, StripOnInput -> False], 
             TraditionalForm], {-2.75, 4.763139720814412}], 
           InsetBox[
            FormBox[
             StyleBox[
              
              TemplateBox[{"\"150\"", "\"\[Degree]\""}, "Superscript", 
               SyntaxForm -> SuperscriptBox], 30, StripOnInput -> False], 
             TraditionalForm], {-4.763139720814412, 2.75}], 
           InsetBox[
            FormBox[
             StyleBox[
              
              TemplateBox[{"\"180\"", "\"\[Degree]\""}, "Superscript", 
               SyntaxForm -> SuperscriptBox], 30, StripOnInput -> False], 
             TraditionalForm], {-5.5, 0.}], 
           InsetBox[
            FormBox[
             StyleBox[
              
              TemplateBox[{"\"210\"", "\"\[Degree]\""}, "Superscript", 
               SyntaxForm -> SuperscriptBox], 30, StripOnInput -> False], 
             TraditionalForm], {-4.763139720814412, -2.75}], 
           InsetBox[
            FormBox[
             StyleBox[
              
              TemplateBox[{"\"240\"", "\"\[Degree]\""}, "Superscript", 
               SyntaxForm -> SuperscriptBox], 30, StripOnInput -> False], 
             TraditionalForm], {-2.75, -4.763139720814412}], 
           InsetBox[
            FormBox[
             StyleBox[
              
              TemplateBox[{"\"270\"", "\"\[Degree]\""}, "Superscript", 
               SyntaxForm -> SuperscriptBox], 30, StripOnInput -> False], 
             TraditionalForm], {0., -5.5}], 
           InsetBox[
            FormBox[
             StyleBox[
              
              TemplateBox[{"\"300\"", "\"\[Degree]\""}, "Superscript", 
               SyntaxForm -> SuperscriptBox], 30, StripOnInput -> False], 
             TraditionalForm], {2.75, -4.763139720814412}], 
           InsetBox[
            FormBox[
             StyleBox[
              
              TemplateBox[{"\"330\"", "\"\[Degree]\""}, "Superscript", 
               SyntaxForm -> SuperscriptBox], 30, StripOnInput -> False], 
             TraditionalForm], {4.763139720814412, -2.75}]}, {
           BezierCurveBox[
            
            NCache[{{0, 5}, {
              5 Sin[Rational[1, 60] Pi], 5 Cos[Rational[1, 60] Pi]}, {
              5 Sin[Rational[1, 30] Pi], 5 Cos[Rational[1, 30] Pi]}, {
              5 Sin[Rational[1, 20] Pi], 5 Cos[Rational[1, 20] Pi]}, {
              5 Sin[Rational[1, 15] Pi], 5 Cos[Rational[1, 15] Pi]}, {
              Rational[5, 2] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 
               Rational[5, 2] 2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
              Rational[5, 4] (-1 + 5^Rational[1, 2]), 
               5 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2]}, {
              5 Sin[Rational[7, 60] Pi], 5 Cos[Rational[7, 60] Pi]}, {
              5 Sin[Rational[2, 15] Pi], 5 Cos[Rational[2, 15] Pi]}, {
              5 Sin[Rational[3, 20] Pi], 5 Cos[Rational[3, 20] Pi]}, {
               Rational[5, 2], Rational[5, 2] 3^Rational[1, 2]}, {
              5 Sin[Rational[11, 60] Pi], 5 Cos[Rational[11, 60] Pi]}, {
              5 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], Rational[5, 4] (1 + 5^Rational[1, 2])}, {
              5 Sin[Rational[13, 60] Pi], 5 Cos[Rational[13, 60] Pi]}, {
              5 Sin[Rational[7, 30] Pi], 5 Cos[Rational[7, 30] Pi]}, {
              5 2^Rational[-1, 2], 5 2^Rational[-1, 2]}, {
              5 Cos[Rational[7, 30] Pi], 5 Sin[Rational[7, 30] Pi]}, {
              5 Cos[Rational[13, 60] Pi], 5 Sin[Rational[13, 60] Pi]}, {
              Rational[5, 4] (1 + 5^Rational[1, 2]), 
               5 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2]}, {
              5 Cos[Rational[11, 60] Pi], 5 Sin[Rational[11, 60] Pi]}, {
              Rational[5, 2] 3^Rational[1, 2], 
               Rational[5, 2]}, {
              5 Cos[Rational[3, 20] Pi], 5 Sin[Rational[3, 20] Pi]}, {
              5 Cos[Rational[2, 15] Pi], 5 Sin[Rational[2, 15] Pi]}, {
              5 Cos[Rational[7, 60] Pi], 5 Sin[Rational[7, 60] Pi]}, {
              5 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], Rational[5, 4] (-1 + 5^Rational[1, 2])}, {
              Rational[5, 2] 2^Rational[-1, 2] (1 + 3^Rational[1, 2]), 
               Rational[5, 2] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {
              5 Cos[Rational[1, 15] Pi], 5 Sin[Rational[1, 15] Pi]}, {
              5 Cos[Rational[1, 20] Pi], 5 Sin[Rational[1, 20] Pi]}, {
              5 Cos[Rational[1, 30] Pi], 5 Sin[Rational[1, 30] Pi]}, {
              5 Cos[Rational[1, 60] Pi], 5 Sin[Rational[1, 60] Pi]}, {5, 0}, {
              5 Cos[Rational[1, 60] Pi], (-5) Sin[Rational[1, 60] Pi]}, {
              5 Cos[Rational[1, 30] Pi], (-5) Sin[Rational[1, 30] Pi]}, {
              5 Cos[Rational[1, 20] Pi], (-5) Sin[Rational[1, 20] Pi]}, {
              5 Cos[Rational[1, 15] Pi], (-5) Sin[Rational[1, 15] Pi]}, {
              Rational[5, 2] 2^Rational[-1, 2] (1 + 3^Rational[1, 2]), 
               Rational[-5, 2] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {
              5 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], Rational[5, 4] (1 - 5^Rational[1, 2])}, {
              5 Cos[Rational[7, 60] Pi], (-5) Sin[Rational[7, 60] Pi]}, {
              5 Cos[Rational[2, 15] Pi], (-5) Sin[Rational[2, 15] Pi]}, {
              5 Cos[Rational[3, 20] Pi], (-5) Sin[Rational[3, 20] Pi]}, {
              Rational[5, 2] 3^Rational[1, 2], 
               Rational[-5, 2]}, {
              5 Cos[Rational[11, 60] Pi], (-5) Sin[Rational[11, 60] Pi]}, {
              Rational[5, 4] (1 + 
                5^Rational[1, 2]), (-5) (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              5 Cos[Rational[13, 60] Pi], (-5) Sin[Rational[13, 60] Pi]}, {
              5 Cos[Rational[7, 30] Pi], (-5) Sin[Rational[7, 30] Pi]}, {
              5 2^Rational[-1, 2], (-5) 2^Rational[-1, 2]}, {
              5 Sin[Rational[7, 30] Pi], (-5) Cos[Rational[7, 30] Pi]}, {
              5 Sin[Rational[13, 60] Pi], (-5) Cos[Rational[13, 60] Pi]}, {
              5 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], Rational[5, 4] (-1 - 5^Rational[1, 2])}, {
              5 Sin[Rational[11, 60] Pi], (-5) Cos[Rational[11, 60] Pi]}, {
               Rational[5, 2], Rational[-5, 2] 3^Rational[1, 2]}, {
              5 Sin[Rational[3, 20] Pi], (-5) Cos[Rational[3, 20] Pi]}, {
              5 Sin[Rational[2, 15] Pi], (-5) Cos[Rational[2, 15] Pi]}, {
              5 Sin[Rational[7, 60] Pi], (-5) Cos[Rational[7, 60] Pi]}, {
              Rational[5, 4] (-1 + 
                5^Rational[1, 2]), (-5) (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              Rational[5, 2] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 
               Rational[-5, 2] 2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
              5 Sin[Rational[1, 15] Pi], (-5) Cos[Rational[1, 15] Pi]}, {
              5 Sin[Rational[1, 20] Pi], (-5) Cos[Rational[1, 20] Pi]}, {
              5 Sin[Rational[1, 30] Pi], (-5) Cos[Rational[1, 30] Pi]}, {
              5 Sin[Rational[1, 60] Pi], (-5) Cos[Rational[1, 60] Pi]}, {
              0, -5}, {(-5) Sin[Rational[1, 60] Pi], (-5) 
               Cos[Rational[1, 60] Pi]}, {(-5) Sin[Rational[1, 30] Pi], (-5) 
               Cos[Rational[1, 30] Pi]}, {(-5) Sin[Rational[1, 20] Pi], (-5) 
               Cos[Rational[1, 20] Pi]}, {(-5) Sin[Rational[1, 15] Pi], (-5) 
               Cos[Rational[1, 15] Pi]}, {
              Rational[-5, 2] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 
               Rational[-5, 2] 2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
              Rational[5, 4] (1 - 5^
                Rational[1, 2]), (-5) (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {(-5) 
               Sin[Rational[7, 60] Pi], (-5) Cos[Rational[7, 60] Pi]}, {(-5) 
               Sin[Rational[2, 15] Pi], (-5) Cos[Rational[2, 15] Pi]}, {(-5) 
               Sin[Rational[3, 20] Pi], (-5) Cos[Rational[3, 20] Pi]}, {
               Rational[-5, 2], Rational[-5, 2] 3^Rational[1, 2]}, {(-5) 
               Sin[Rational[11, 60] Pi], (-5) 
               Cos[Rational[11, 60] Pi]}, {(-5) (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[5, 4] (-1 - 5^Rational[1, 2])}, {(-5) 
               Sin[Rational[13, 60] Pi], (-5) 
               Cos[Rational[13, 60] Pi]}, {(-5) Sin[Rational[7, 30] Pi], (-5) 
               Cos[Rational[7, 30] Pi]}, {(-5) 2^Rational[-1, 2], (-5) 
               2^Rational[-1, 2]}, {(-5) Cos[Rational[7, 30] Pi], (-5) 
               Sin[Rational[7, 30] Pi]}, {(-5) Cos[Rational[13, 60] Pi], (-5) 
               Sin[Rational[13, 60] Pi]}, {
              Rational[5, 4] (-1 - 5^
                Rational[1, 2]), (-5) (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {(-5) 
               Cos[Rational[11, 60] Pi], (-5) Sin[Rational[11, 60] Pi]}, {
              Rational[-5, 2] 3^Rational[1, 2], 
               Rational[-5, 2]}, {(-5) Cos[Rational[3, 20] Pi], (-5) 
               Sin[Rational[3, 20] Pi]}, {(-5) Cos[Rational[2, 15] Pi], (-5) 
               Sin[Rational[2, 15] Pi]}, {(-5) Cos[Rational[7, 60] Pi], (-5) 
               Sin[Rational[7, 60] Pi]}, {(-5) (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[5, 4] (1 - 5^Rational[1, 2])}, {
              Rational[-5, 2] 2^Rational[-1, 2] (1 + 3^Rational[1, 2]), 
               Rational[-5, 2] 
               2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {(-5) 
               Cos[Rational[1, 15] Pi], (-5) Sin[Rational[1, 15] Pi]}, {(-5) 
               Cos[Rational[1, 20] Pi], (-5) Sin[Rational[1, 20] Pi]}, {(-5) 
               Cos[Rational[1, 30] Pi], (-5) Sin[Rational[1, 30] Pi]}, {(-5) 
               Cos[Rational[1, 60] Pi], (-5) Sin[Rational[1, 60] Pi]}, {-5, 
              0}, {(-5) Cos[Rational[1, 60] Pi], 5 
               Sin[Rational[1, 60] Pi]}, {(-5) Cos[Rational[1, 30] Pi], 5 
               Sin[Rational[1, 30] Pi]}, {(-5) Cos[Rational[1, 20] Pi], 5 
               Sin[Rational[1, 20] Pi]}, {(-5) Cos[Rational[1, 15] Pi], 5 
               Sin[Rational[1, 15] Pi]}, {
              Rational[-5, 2] 2^Rational[-1, 2] (1 + 3^Rational[1, 2]), 
               Rational[5, 2] 
               2^Rational[-1, 2] (-1 + 
                3^Rational[1, 2])}, {(-5) (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[5, 4] (-1 + 5^Rational[1, 2])}, {(-5) 
               Cos[Rational[7, 60] Pi], 5 Sin[Rational[7, 60] Pi]}, {(-5) 
               Cos[Rational[2, 15] Pi], 5 Sin[Rational[2, 15] Pi]}, {(-5) 
               Cos[Rational[3, 20] Pi], 5 Sin[Rational[3, 20] Pi]}, {
              Rational[-5, 2] 3^Rational[1, 2], 
               Rational[5, 2]}, {(-5) Cos[Rational[11, 60] Pi], 5 
               Sin[Rational[11, 60] Pi]}, {
              Rational[5, 4] (-1 - 5^Rational[1, 2]), 
               5 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2]}, {(-5) Cos[Rational[13, 60] Pi], 5 
               Sin[Rational[13, 60] Pi]}, {(-5) Cos[Rational[7, 30] Pi], 5 
               Sin[Rational[7, 30] Pi]}, {(-5) 2^Rational[-1, 2], 5 
               2^Rational[-1, 2]}, {(-5) Sin[Rational[7, 30] Pi], 5 
               Cos[Rational[7, 30] Pi]}, {(-5) Sin[Rational[13, 60] Pi], 5 
               Cos[Rational[13, 60] Pi]}, {(-5) (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[5, 4] (1 + 5^Rational[1, 2])}, {(-5) 
               Sin[Rational[11, 60] Pi], 5 Cos[Rational[11, 60] Pi]}, {
               Rational[-5, 2], Rational[5, 2] 3^Rational[1, 2]}, {(-5) 
               Sin[Rational[3, 20] Pi], 5 Cos[Rational[3, 20] Pi]}, {(-5) 
               Sin[Rational[2, 15] Pi], 5 Cos[Rational[2, 15] Pi]}, {(-5) 
               Sin[Rational[7, 60] Pi], 5 Cos[Rational[7, 60] Pi]}, {
              Rational[5, 4] (1 - 5^Rational[1, 2]), 
               5 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2]}, {
              Rational[-5, 2] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 
               Rational[5, 2] 
               2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {(-5) 
               Sin[Rational[1, 15] Pi], 5 Cos[Rational[1, 15] Pi]}, {(-5) 
               Sin[Rational[1, 20] Pi], 5 Cos[Rational[1, 20] Pi]}, {(-5) 
               Sin[Rational[1, 30] Pi], 5 Cos[Rational[1, 30] Pi]}, {(-5) 
               Sin[Rational[1, 60] Pi], 5 Cos[Rational[1, 60] Pi]}, {0, 
              5}}, {{0, 5}, {0.26167978121471913`, 4.993147673772869}, {
              0.5226423163382673, 4.972609476841367}, {0.7821723252011543, 
              4.938441702975689}, {1.0395584540887965`, 
              4.8907380036690284`}, {1.2940952255126035`, 
              4.829629131445341}, {1.5450849718747373`, 4.755282581475767}, {
              1.7918397477265013`, 4.667902132486009}, {2.0336832153790008`, 
              4.567727288213004}, {2.2699524986977337`, 4.455032620941839}, {
              2.5, 4.330127018922193}, {2.723195175075135, 
              4.193352839727121}, {2.938926261462366, 4.045084971874737}, {
              3.1466019552491877`, 3.885729807284854}, {3.345653031794291, 
              3.715724127386971}, {3.5355339059327373`, 
              3.5355339059327373`}, {3.715724127386971, 3.345653031794291}, {
              3.885729807284854, 3.1466019552491877`}, {4.045084971874737, 
              2.938926261462366}, {4.193352839727121, 2.723195175075135}, {
              4.330127018922193, 2.5}, {4.455032620941839, 
              2.2699524986977337`}, {4.567727288213004, 
              2.0336832153790008`}, {4.667902132486009, 
              1.7918397477265013`}, {4.755282581475767, 
              1.5450849718747373`}, {4.829629131445341, 
              1.2940952255126035`}, {4.8907380036690284`, 
              1.0395584540887965`}, {4.938441702975689, 0.7821723252011543}, {
              4.972609476841367, 0.5226423163382673}, {4.993147673772869, 
              0.26167978121471913`}, {5, 0}, {
              4.993147673772869, -0.26167978121471913`}, {
              4.972609476841367, -0.5226423163382673}, {
              4.938441702975689, -0.7821723252011543}, {
              4.8907380036690284`, -1.0395584540887965`}, {
              4.829629131445341, -1.2940952255126035`}, {
              4.755282581475767, -1.5450849718747373`}, {
              4.667902132486009, -1.7918397477265013`}, {
              4.567727288213004, -2.0336832153790008`}, {
              4.455032620941839, -2.2699524986977337`}, {
              4.330127018922193, -2.5}, {
              4.193352839727121, -2.723195175075135}, {
              4.045084971874737, -2.938926261462366}, {
              3.885729807284854, -3.1466019552491877`}, {
              3.715724127386971, -3.345653031794291}, {
              3.5355339059327373`, -3.5355339059327373`}, {
              3.345653031794291, -3.715724127386971}, {
              3.1466019552491877`, -3.885729807284854}, {
              2.938926261462366, -4.045084971874737}, {
              2.723195175075135, -4.193352839727121}, {
              2.5, -4.330127018922193}, {
              2.2699524986977337`, -4.455032620941839}, {
              2.0336832153790008`, -4.567727288213004}, {
              1.7918397477265013`, -4.667902132486009}, {
              1.5450849718747373`, -4.755282581475767}, {
              1.2940952255126035`, -4.829629131445341}, {
              1.0395584540887965`, -4.8907380036690284`}, {
              0.7821723252011543, -4.938441702975689}, {
              0.5226423163382673, -4.972609476841367}, {
              0.26167978121471913`, -4.993147673772869}, {
              0, -5}, {-0.26167978121471913`, -4.993147673772869}, \
{-0.5226423163382673, -4.972609476841367}, {-0.7821723252011543, \
-4.938441702975689}, {-1.0395584540887965`, -4.8907380036690284`}, \
{-1.2940952255126035`, -4.829629131445341}, {-1.5450849718747373`, \
-4.755282581475767}, {-1.7918397477265013`, -4.667902132486009}, \
{-2.0336832153790008`, -4.567727288213004}, {-2.2699524986977337`, \
-4.455032620941839}, {-2.5, -4.330127018922193}, {-2.723195175075135, \
-4.193352839727121}, {-2.938926261462366, -4.045084971874737}, \
{-3.1466019552491877`, -3.885729807284854}, {-3.345653031794291, \
-3.715724127386971}, {-3.5355339059327373`, -3.5355339059327373`}, \
{-3.715724127386971, -3.345653031794291}, {-3.885729807284854, \
-3.1466019552491877`}, {-4.045084971874737, -2.938926261462366}, \
{-4.193352839727121, -2.723195175075135}, {-4.330127018922193, -2.5}, \
{-4.455032620941839, -2.2699524986977337`}, {-4.567727288213004, \
-2.0336832153790008`}, {-4.667902132486009, -1.7918397477265013`}, \
{-4.755282581475767, -1.5450849718747373`}, {-4.829629131445341, \
-1.2940952255126035`}, {-4.8907380036690284`, -1.0395584540887965`}, \
{-4.938441702975689, -0.7821723252011543}, {-4.972609476841367, \
-0.5226423163382673}, {-4.993147673772869, -0.26167978121471913`}, {-5, 
              0}, {-4.993147673772869, 
              0.26167978121471913`}, {-4.972609476841367, 
              0.5226423163382673}, {-4.938441702975689, 
              0.7821723252011543}, {-4.8907380036690284`, 
              1.0395584540887965`}, {-4.829629131445341, 
              1.2940952255126035`}, {-4.755282581475767, 
              1.5450849718747373`}, {-4.667902132486009, 
              1.7918397477265013`}, {-4.567727288213004, 
              2.0336832153790008`}, {-4.455032620941839, 
              2.2699524986977337`}, {-4.330127018922193, 
              2.5}, {-4.193352839727121, 
              2.723195175075135}, {-4.045084971874737, 
              2.938926261462366}, {-3.885729807284854, 
              3.1466019552491877`}, {-3.715724127386971, 
              3.345653031794291}, {-3.5355339059327373`, 
              3.5355339059327373`}, {-3.345653031794291, 
              3.715724127386971}, {-3.1466019552491877`, 
              3.885729807284854}, {-2.938926261462366, 
              4.045084971874737}, {-2.723195175075135, 
              4.193352839727121}, {-2.5, 
              4.330127018922193}, {-2.2699524986977337`, 
              4.455032620941839}, {-2.0336832153790008`, 
              4.567727288213004}, {-1.7918397477265013`, 
              4.667902132486009}, {-1.5450849718747373`, 
              4.755282581475767}, {-1.2940952255126035`, 
              4.829629131445341}, {-1.0395584540887965`, 
              4.8907380036690284`}, {-0.7821723252011543, 
              4.938441702975689}, {-0.5226423163382673, 
              4.972609476841367}, {-0.26167978121471913`, 
              4.993147673772869}, {0, 5}}]], 
           BezierCurveBox[
            NCache[{{0, 
               Rational[10, 3]}, {
              Rational[10, 3] Sin[Rational[1, 60] Pi], Rational[10, 3] 
               Cos[Rational[1, 60] Pi]}, {
              Rational[10, 3] Sin[Rational[1, 30] Pi], Rational[10, 3] 
               Cos[Rational[1, 30] Pi]}, {
              Rational[10, 3] Sin[Rational[1, 20] Pi], Rational[10, 3] 
               Cos[Rational[1, 20] Pi]}, {
              Rational[10, 3] Sin[Rational[1, 15] Pi], Rational[10, 3] 
               Cos[Rational[1, 15] Pi]}, {
              Rational[5, 3] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 
               Rational[5, 3] 2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
              Rational[5, 6] (-1 + 5^Rational[1, 2]), 
               Rational[
                10, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2]}, {
              Rational[10, 3] Sin[Rational[7, 60] Pi], Rational[10, 3] 
               Cos[Rational[7, 60] Pi]}, {
              Rational[10, 3] Sin[Rational[2, 15] Pi], Rational[10, 3] 
               Cos[Rational[2, 15] Pi]}, {
              Rational[10, 3] Sin[Rational[3, 20] Pi], Rational[10, 3] 
               Cos[Rational[3, 20] Pi]}, {
               Rational[5, 3], 5 3^Rational[-1, 2]}, {
              Rational[10, 3] Sin[Rational[11, 60] Pi], Rational[10, 3] 
               Cos[Rational[11, 60] Pi]}, {
              Rational[
                10, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], Rational[5, 6] (1 + 5^Rational[1, 2])}, {
              Rational[10, 3] Sin[Rational[13, 60] Pi], Rational[10, 3] 
               Cos[Rational[13, 60] Pi]}, {
              Rational[10, 3] Sin[Rational[7, 30] Pi], Rational[10, 3] 
               Cos[Rational[7, 30] Pi]}, {
              Rational[5, 3] 2^Rational[1, 2], Rational[5, 3] 
               2^Rational[1, 2]}, {
              Rational[10, 3] Cos[Rational[7, 30] Pi], Rational[10, 3] 
               Sin[Rational[7, 30] Pi]}, {
              Rational[10, 3] Cos[Rational[13, 60] Pi], Rational[10, 3] 
               Sin[Rational[13, 60] Pi]}, {
              Rational[5, 6] (1 + 5^Rational[1, 2]), 
               Rational[
                10, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2]}, {
              Rational[10, 3] Cos[Rational[11, 60] Pi], Rational[10, 3] 
               Sin[Rational[11, 60] Pi]}, {5 3^Rational[-1, 2], 
               Rational[5, 3]}, {
              Rational[10, 3] Cos[Rational[3, 20] Pi], Rational[10, 3] 
               Sin[Rational[3, 20] Pi]}, {
              Rational[10, 3] Cos[Rational[2, 15] Pi], Rational[10, 3] 
               Sin[Rational[2, 15] Pi]}, {
              Rational[10, 3] Cos[Rational[7, 60] Pi], Rational[10, 3] 
               Sin[Rational[7, 60] Pi]}, {
              Rational[
                10, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], Rational[5, 6] (-1 + 5^Rational[1, 2])}, {
              Rational[5, 3] 2^Rational[-1, 2] (1 + 3^Rational[1, 2]), 
               Rational[5, 3] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {
              Rational[10, 3] Cos[Rational[1, 15] Pi], Rational[10, 3] 
               Sin[Rational[1, 15] Pi]}, {
              Rational[10, 3] Cos[Rational[1, 20] Pi], Rational[10, 3] 
               Sin[Rational[1, 20] Pi]}, {
              Rational[10, 3] Cos[Rational[1, 30] Pi], Rational[10, 3] 
               Sin[Rational[1, 30] Pi]}, {
              Rational[10, 3] Cos[Rational[1, 60] Pi], Rational[10, 3] 
               Sin[Rational[1, 60] Pi]}, {
               Rational[10, 3], 0}, {
              Rational[10, 3] Cos[Rational[1, 60] Pi], Rational[-10, 3] 
               Sin[Rational[1, 60] Pi]}, {
              Rational[10, 3] Cos[Rational[1, 30] Pi], Rational[-10, 3] 
               Sin[Rational[1, 30] Pi]}, {
              Rational[10, 3] Cos[Rational[1, 20] Pi], Rational[-10, 3] 
               Sin[Rational[1, 20] Pi]}, {
              Rational[10, 3] Cos[Rational[1, 15] Pi], Rational[-10, 3] 
               Sin[Rational[1, 15] Pi]}, {
              Rational[5, 3] 2^Rational[-1, 2] (1 + 3^Rational[1, 2]), 
               Rational[-5, 3] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {
              Rational[
                10, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], Rational[5, 6] (1 - 5^Rational[1, 2])}, {
              Rational[10, 3] Cos[Rational[7, 60] Pi], Rational[-10, 3] 
               Sin[Rational[7, 60] Pi]}, {
              Rational[10, 3] Cos[Rational[2, 15] Pi], Rational[-10, 3] 
               Sin[Rational[2, 15] Pi]}, {
              Rational[10, 3] Cos[Rational[3, 20] Pi], Rational[-10, 3] 
               Sin[Rational[3, 20] Pi]}, {5 3^Rational[-1, 2], 
               Rational[-5, 3]}, {
              Rational[10, 3] Cos[Rational[11, 60] Pi], Rational[-10, 3] 
               Sin[Rational[11, 60] Pi]}, {
              Rational[5, 6] (1 + 5^Rational[1, 2]), 
               Rational[-10, 3] (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              Rational[10, 3] Cos[Rational[13, 60] Pi], Rational[-10, 3] 
               Sin[Rational[13, 60] Pi]}, {
              Rational[10, 3] Cos[Rational[7, 30] Pi], Rational[-10, 3] 
               Sin[Rational[7, 30] Pi]}, {
              Rational[5, 3] 2^Rational[1, 2], Rational[-5, 3] 
               2^Rational[1, 2]}, {
              Rational[10, 3] Sin[Rational[7, 30] Pi], Rational[-10, 3] 
               Cos[Rational[7, 30] Pi]}, {
              Rational[10, 3] Sin[Rational[13, 60] Pi], Rational[-10, 3] 
               Cos[Rational[13, 60] Pi]}, {
              Rational[
                10, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], Rational[5, 6] (-1 - 5^Rational[1, 2])}, {
              Rational[10, 3] Sin[Rational[11, 60] Pi], Rational[-10, 3] 
               Cos[Rational[11, 60] Pi]}, {
               Rational[5, 3], (-5) 3^Rational[-1, 2]}, {
              Rational[10, 3] Sin[Rational[3, 20] Pi], Rational[-10, 3] 
               Cos[Rational[3, 20] Pi]}, {
              Rational[10, 3] Sin[Rational[2, 15] Pi], Rational[-10, 3] 
               Cos[Rational[2, 15] Pi]}, {
              Rational[10, 3] Sin[Rational[7, 60] Pi], Rational[-10, 3] 
               Cos[Rational[7, 60] Pi]}, {
              Rational[5, 6] (-1 + 5^Rational[1, 2]), 
               Rational[-10, 3] (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              Rational[5, 3] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 
               Rational[-5, 3] 2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
              Rational[10, 3] Sin[Rational[1, 15] Pi], Rational[-10, 3] 
               Cos[Rational[1, 15] Pi]}, {
              Rational[10, 3] Sin[Rational[1, 20] Pi], Rational[-10, 3] 
               Cos[Rational[1, 20] Pi]}, {
              Rational[10, 3] Sin[Rational[1, 30] Pi], Rational[-10, 3] 
               Cos[Rational[1, 30] Pi]}, {
              Rational[10, 3] Sin[Rational[1, 60] Pi], Rational[-10, 3] 
               Cos[Rational[1, 60] Pi]}, {0, 
               Rational[-10, 3]}, {
              Rational[-10, 3] Sin[Rational[1, 60] Pi], Rational[-10, 3] 
               Cos[Rational[1, 60] Pi]}, {
              Rational[-10, 3] Sin[Rational[1, 30] Pi], Rational[-10, 3] 
               Cos[Rational[1, 30] Pi]}, {
              Rational[-10, 3] Sin[Rational[1, 20] Pi], Rational[-10, 3] 
               Cos[Rational[1, 20] Pi]}, {
              Rational[-10, 3] Sin[Rational[1, 15] Pi], Rational[-10, 3] 
               Cos[Rational[1, 15] Pi]}, {
              Rational[-5, 3] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 
               Rational[-5, 3] 2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
              Rational[5, 6] (1 - 5^Rational[1, 2]), 
               Rational[-10, 3] (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              Rational[-10, 3] Sin[Rational[7, 60] Pi], Rational[-10, 3] 
               Cos[Rational[7, 60] Pi]}, {
              Rational[-10, 3] Sin[Rational[2, 15] Pi], Rational[-10, 3] 
               Cos[Rational[2, 15] Pi]}, {
              Rational[-10, 3] Sin[Rational[3, 20] Pi], Rational[-10, 3] 
               Cos[Rational[3, 20] Pi]}, {
               Rational[-5, 3], (-5) 3^Rational[-1, 2]}, {
              Rational[-10, 3] Sin[Rational[11, 60] Pi], Rational[-10, 3] 
               Cos[Rational[11, 60] Pi]}, {
              Rational[-10, 3] (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[5, 6] (-1 - 5^Rational[1, 2])}, {
              Rational[-10, 3] Sin[Rational[13, 60] Pi], Rational[-10, 3] 
               Cos[Rational[13, 60] Pi]}, {
              Rational[-10, 3] Sin[Rational[7, 30] Pi], Rational[-10, 3] 
               Cos[Rational[7, 30] Pi]}, {
              Rational[-5, 3] 2^Rational[1, 2], Rational[-5, 3] 
               2^Rational[1, 2]}, {
              Rational[-10, 3] Cos[Rational[7, 30] Pi], Rational[-10, 3] 
               Sin[Rational[7, 30] Pi]}, {
              Rational[-10, 3] Cos[Rational[13, 60] Pi], Rational[-10, 3] 
               Sin[Rational[13, 60] Pi]}, {
              Rational[5, 6] (-1 - 5^Rational[1, 2]), 
               Rational[-10, 3] (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              Rational[-10, 3] Cos[Rational[11, 60] Pi], Rational[-10, 3] 
               Sin[Rational[11, 60] Pi]}, {(-5) 3^Rational[-1, 2], 
               Rational[-5, 3]}, {
              Rational[-10, 3] Cos[Rational[3, 20] Pi], Rational[-10, 3] 
               Sin[Rational[3, 20] Pi]}, {
              Rational[-10, 3] Cos[Rational[2, 15] Pi], Rational[-10, 3] 
               Sin[Rational[2, 15] Pi]}, {
              Rational[-10, 3] Cos[Rational[7, 60] Pi], Rational[-10, 3] 
               Sin[Rational[7, 60] Pi]}, {
              Rational[-10, 3] (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[5, 6] (1 - 5^Rational[1, 2])}, {
              Rational[-5, 3] 2^Rational[-1, 2] (1 + 3^Rational[1, 2]), 
               Rational[-5, 3] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {
              Rational[-10, 3] Cos[Rational[1, 15] Pi], Rational[-10, 3] 
               Sin[Rational[1, 15] Pi]}, {
              Rational[-10, 3] Cos[Rational[1, 20] Pi], Rational[-10, 3] 
               Sin[Rational[1, 20] Pi]}, {
              Rational[-10, 3] Cos[Rational[1, 30] Pi], Rational[-10, 3] 
               Sin[Rational[1, 30] Pi]}, {
              Rational[-10, 3] Cos[Rational[1, 60] Pi], Rational[-10, 3] 
               Sin[Rational[1, 60] Pi]}, {
               Rational[-10, 3], 0}, {
              Rational[-10, 3] Cos[Rational[1, 60] Pi], Rational[10, 3] 
               Sin[Rational[1, 60] Pi]}, {
              Rational[-10, 3] Cos[Rational[1, 30] Pi], Rational[10, 3] 
               Sin[Rational[1, 30] Pi]}, {
              Rational[-10, 3] Cos[Rational[1, 20] Pi], Rational[10, 3] 
               Sin[Rational[1, 20] Pi]}, {
              Rational[-10, 3] Cos[Rational[1, 15] Pi], Rational[10, 3] 
               Sin[Rational[1, 15] Pi]}, {
              Rational[-5, 3] 2^Rational[-1, 2] (1 + 3^Rational[1, 2]), 
               Rational[5, 3] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {
              Rational[-10, 3] (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[5, 6] (-1 + 5^Rational[1, 2])}, {
              Rational[-10, 3] Cos[Rational[7, 60] Pi], Rational[10, 3] 
               Sin[Rational[7, 60] Pi]}, {
              Rational[-10, 3] Cos[Rational[2, 15] Pi], Rational[10, 3] 
               Sin[Rational[2, 15] Pi]}, {
              Rational[-10, 3] Cos[Rational[3, 20] Pi], Rational[10, 3] 
               Sin[Rational[3, 20] Pi]}, {(-5) 3^Rational[-1, 2], 
               Rational[5, 3]}, {
              Rational[-10, 3] Cos[Rational[11, 60] Pi], Rational[10, 3] 
               Sin[Rational[11, 60] Pi]}, {
              Rational[5, 6] (-1 - 5^Rational[1, 2]), 
               Rational[
                10, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2]}, {
              Rational[-10, 3] Cos[Rational[13, 60] Pi], Rational[10, 3] 
               Sin[Rational[13, 60] Pi]}, {
              Rational[-10, 3] Cos[Rational[7, 30] Pi], Rational[10, 3] 
               Sin[Rational[7, 30] Pi]}, {
              Rational[-5, 3] 2^Rational[1, 2], Rational[5, 3] 
               2^Rational[1, 2]}, {
              Rational[-10, 3] Sin[Rational[7, 30] Pi], Rational[10, 3] 
               Cos[Rational[7, 30] Pi]}, {
              Rational[-10, 3] Sin[Rational[13, 60] Pi], Rational[10, 3] 
               Cos[Rational[13, 60] Pi]}, {
              Rational[-10, 3] (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[5, 6] (1 + 5^Rational[1, 2])}, {
              Rational[-10, 3] Sin[Rational[11, 60] Pi], Rational[10, 3] 
               Cos[Rational[11, 60] Pi]}, {
               Rational[-5, 3], 5 3^Rational[-1, 2]}, {
              Rational[-10, 3] Sin[Rational[3, 20] Pi], Rational[10, 3] 
               Cos[Rational[3, 20] Pi]}, {
              Rational[-10, 3] Sin[Rational[2, 15] Pi], Rational[10, 3] 
               Cos[Rational[2, 15] Pi]}, {
              Rational[-10, 3] Sin[Rational[7, 60] Pi], Rational[10, 3] 
               Cos[Rational[7, 60] Pi]}, {
              Rational[5, 6] (1 - 5^Rational[1, 2]), 
               Rational[
                10, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2]}, {
              Rational[-5, 3] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 
               Rational[5, 3] 2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
              Rational[-10, 3] Sin[Rational[1, 15] Pi], Rational[10, 3] 
               Cos[Rational[1, 15] Pi]}, {
              Rational[-10, 3] Sin[Rational[1, 20] Pi], Rational[10, 3] 
               Cos[Rational[1, 20] Pi]}, {
              Rational[-10, 3] Sin[Rational[1, 30] Pi], Rational[10, 3] 
               Cos[Rational[1, 30] Pi]}, {
              Rational[-10, 3] Sin[Rational[1, 60] Pi], Rational[10, 3] 
               Cos[Rational[1, 60] Pi]}, {0, 
               Rational[10, 3]}}, {{0, 3.3333333333333335`}, {
              0.17445318747647942`, 3.3287651158485794`}, {0.3484282108921782,
               3.3150729845609113`}, {0.5214482168007696, 
              3.2922944686504594`}, {0.6930389693925311, 3.260492002446019}, {
              0.8627301503417358, 3.2197527542968944`}, {1.0300566479164917`, 
              3.1701883876505117`}, {1.1945598318176676`, 
              3.1119347549906724`}, {1.3557888102526672`, 
              3.0451515254753363`}, {1.5133016657984892`, 
              2.9700217472945596`}, {1.6666666666666667`, 
              2.886751345948129}, {1.81546345005009, 2.79556855981808}, {
              1.9592841743082439`, 2.696723314583158}, {2.097734636832792, 
              2.5904865381899027`}, {2.2304353545295275`, 
              2.477149418257981}, {2.3570226039551585`, 
              2.3570226039551585`}, {2.477149418257981, 
              2.2304353545295275`}, {2.5904865381899027`, 
              2.097734636832792}, {2.696723314583158, 1.9592841743082439`}, {
              2.79556855981808, 1.81546345005009}, {2.886751345948129, 
              1.6666666666666667`}, {2.9700217472945596`, 
              1.5133016657984892`}, {3.0451515254753363`, 
              1.3557888102526672`}, {3.1119347549906724`, 
              1.1945598318176676`}, {3.1701883876505117`, 
              1.0300566479164917`}, {3.2197527542968944`, 
              0.8627301503417358}, {3.260492002446019, 0.6930389693925311}, {
              3.2922944686504594`, 0.5214482168007696}, {3.3150729845609113`, 
              0.3484282108921782}, {3.3287651158485794`, 
              0.17445318747647942`}, {3.3333333333333335`, 0}, {
              3.3287651158485794`, -0.17445318747647942`}, {
              3.3150729845609113`, -0.3484282108921782}, {
              3.2922944686504594`, -0.5214482168007696}, {
              3.260492002446019, -0.6930389693925311}, {
              3.2197527542968944`, -0.8627301503417358}, {
              3.1701883876505117`, -1.0300566479164917`}, {
              3.1119347549906724`, -1.1945598318176676`}, {
              3.0451515254753363`, -1.3557888102526672`}, {
              2.9700217472945596`, -1.5133016657984892`}, {
              2.886751345948129, -1.6666666666666667`}, {
              2.79556855981808, -1.81546345005009}, {
              2.696723314583158, -1.9592841743082439`}, {
              2.5904865381899027`, -2.097734636832792}, {
              2.477149418257981, -2.2304353545295275`}, {
              2.3570226039551585`, -2.3570226039551585`}, {
              2.2304353545295275`, -2.477149418257981}, {
              2.097734636832792, -2.5904865381899027`}, {
              1.9592841743082439`, -2.696723314583158}, {
              1.81546345005009, -2.79556855981808}, {
              1.6666666666666667`, -2.886751345948129}, {
              1.5133016657984892`, -2.9700217472945596`}, {
              1.3557888102526672`, -3.0451515254753363`}, {
              1.1945598318176676`, -3.1119347549906724`}, {
              1.0300566479164917`, -3.1701883876505117`}, {
              0.8627301503417358, -3.2197527542968944`}, {
              0.6930389693925311, -3.260492002446019}, {
              0.5214482168007696, -3.2922944686504594`}, {
              0.3484282108921782, -3.3150729845609113`}, {
              0.17445318747647942`, -3.3287651158485794`}, {
              0, -3.3333333333333335`}, {-0.17445318747647942`, \
-3.3287651158485794`}, {-0.3484282108921782, -3.3150729845609113`}, \
{-0.5214482168007696, -3.2922944686504594`}, {-0.6930389693925311, \
-3.260492002446019}, {-0.8627301503417358, -3.2197527542968944`}, \
{-1.0300566479164917`, -3.1701883876505117`}, {-1.1945598318176676`, \
-3.1119347549906724`}, {-1.3557888102526672`, -3.0451515254753363`}, \
{-1.5133016657984892`, -2.9700217472945596`}, {-1.6666666666666667`, \
-2.886751345948129}, {-1.81546345005009, -2.79556855981808}, \
{-1.9592841743082439`, -2.696723314583158}, {-2.097734636832792, \
-2.5904865381899027`}, {-2.2304353545295275`, -2.477149418257981}, \
{-2.3570226039551585`, -2.3570226039551585`}, {-2.477149418257981, \
-2.2304353545295275`}, {-2.5904865381899027`, -2.097734636832792}, \
{-2.696723314583158, -1.9592841743082439`}, {-2.79556855981808, \
-1.81546345005009}, {-2.886751345948129, -1.6666666666666667`}, \
{-2.9700217472945596`, -1.5133016657984892`}, {-3.0451515254753363`, \
-1.3557888102526672`}, {-3.1119347549906724`, -1.1945598318176676`}, \
{-3.1701883876505117`, -1.0300566479164917`}, {-3.2197527542968944`, \
-0.8627301503417358}, {-3.260492002446019, -0.6930389693925311}, \
{-3.2922944686504594`, -0.5214482168007696}, {-3.3150729845609113`, \
-0.3484282108921782}, {-3.3287651158485794`, -0.17445318747647942`}, \
{-3.3333333333333335`, 0}, {-3.3287651158485794`, 
              0.17445318747647942`}, {-3.3150729845609113`, 
              0.3484282108921782}, {-3.2922944686504594`, 
              0.5214482168007696}, {-3.260492002446019, 
              0.6930389693925311}, {-3.2197527542968944`, 
              0.8627301503417358}, {-3.1701883876505117`, 
              1.0300566479164917`}, {-3.1119347549906724`, 
              1.1945598318176676`}, {-3.0451515254753363`, 
              1.3557888102526672`}, {-2.9700217472945596`, 
              1.5133016657984892`}, {-2.886751345948129, 
              1.6666666666666667`}, {-2.79556855981808, 
              1.81546345005009}, {-2.696723314583158, 
              1.9592841743082439`}, {-2.5904865381899027`, 
              2.097734636832792}, {-2.477149418257981, 
              2.2304353545295275`}, {-2.3570226039551585`, 
              2.3570226039551585`}, {-2.2304353545295275`, 
              2.477149418257981}, {-2.097734636832792, 
              2.5904865381899027`}, {-1.9592841743082439`, 
              2.696723314583158}, {-1.81546345005009, 
              2.79556855981808}, {-1.6666666666666667`, 
              2.886751345948129}, {-1.5133016657984892`, 
              2.9700217472945596`}, {-1.3557888102526672`, 
              3.0451515254753363`}, {-1.1945598318176676`, 
              3.1119347549906724`}, {-1.0300566479164917`, 
              3.1701883876505117`}, {-0.8627301503417358, 
              3.2197527542968944`}, {-0.6930389693925311, 
              3.260492002446019}, {-0.5214482168007696, 
              3.2922944686504594`}, {-0.3484282108921782, 
              3.3150729845609113`}, {-0.17445318747647942`, 
              3.3287651158485794`}, {0, 3.3333333333333335`}}]], 
           BezierCurveBox[
            NCache[{{0, 
               Rational[5, 3]}, {
              Rational[5, 3] Sin[Rational[1, 60] Pi], Rational[5, 3] 
               Cos[Rational[1, 60] Pi]}, {
              Rational[5, 3] Sin[Rational[1, 30] Pi], Rational[5, 3] 
               Cos[Rational[1, 30] Pi]}, {
              Rational[5, 3] Sin[Rational[1, 20] Pi], Rational[5, 3] 
               Cos[Rational[1, 20] Pi]}, {
              Rational[5, 3] Sin[Rational[1, 15] Pi], Rational[5, 3] 
               Cos[Rational[1, 15] Pi]}, {
              Rational[5, 6] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 
               Rational[5, 6] 2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
              Rational[5, 12] (-1 + 5^Rational[1, 2]), 
               Rational[
                5, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2]}, {
              Rational[5, 3] Sin[Rational[7, 60] Pi], Rational[5, 3] 
               Cos[Rational[7, 60] Pi]}, {
              Rational[5, 3] Sin[Rational[2, 15] Pi], Rational[5, 3] 
               Cos[Rational[2, 15] Pi]}, {
              Rational[5, 3] Sin[Rational[3, 20] Pi], Rational[5, 3] 
               Cos[Rational[3, 20] Pi]}, {
               Rational[5, 6], Rational[5, 2] 3^Rational[-1, 2]}, {
              Rational[5, 3] Sin[Rational[11, 60] Pi], Rational[5, 3] 
               Cos[Rational[11, 60] Pi]}, {
              Rational[
                5, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], Rational[5, 12] (1 + 5^Rational[1, 2])}, {
              Rational[5, 3] Sin[Rational[13, 60] Pi], Rational[5, 3] 
               Cos[Rational[13, 60] Pi]}, {
              Rational[5, 3] Sin[Rational[7, 30] Pi], Rational[5, 3] 
               Cos[Rational[7, 30] Pi]}, {
              Rational[5, 3] 2^Rational[-1, 2], Rational[5, 3] 
               2^Rational[-1, 2]}, {
              Rational[5, 3] Cos[Rational[7, 30] Pi], Rational[5, 3] 
               Sin[Rational[7, 30] Pi]}, {
              Rational[5, 3] Cos[Rational[13, 60] Pi], Rational[5, 3] 
               Sin[Rational[13, 60] Pi]}, {
              Rational[5, 12] (1 + 5^Rational[1, 2]), 
               Rational[
                5, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2]}, {
              Rational[5, 3] Cos[Rational[11, 60] Pi], Rational[5, 3] 
               Sin[Rational[11, 60] Pi]}, {Rational[5, 2] 3^Rational[-1, 2], 
               Rational[5, 6]}, {
              Rational[5, 3] Cos[Rational[3, 20] Pi], Rational[5, 3] 
               Sin[Rational[3, 20] Pi]}, {
              Rational[5, 3] Cos[Rational[2, 15] Pi], Rational[5, 3] 
               Sin[Rational[2, 15] Pi]}, {
              Rational[5, 3] Cos[Rational[7, 60] Pi], Rational[5, 3] 
               Sin[Rational[7, 60] Pi]}, {
              Rational[
                5, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], Rational[5, 12] (-1 + 5^Rational[1, 2])}, {
              Rational[5, 6] 2^Rational[-1, 2] (1 + 3^Rational[1, 2]), 
               Rational[5, 6] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {
              Rational[5, 3] Cos[Rational[1, 15] Pi], Rational[5, 3] 
               Sin[Rational[1, 15] Pi]}, {
              Rational[5, 3] Cos[Rational[1, 20] Pi], Rational[5, 3] 
               Sin[Rational[1, 20] Pi]}, {
              Rational[5, 3] Cos[Rational[1, 30] Pi], Rational[5, 3] 
               Sin[Rational[1, 30] Pi]}, {
              Rational[5, 3] Cos[Rational[1, 60] Pi], Rational[5, 3] 
               Sin[Rational[1, 60] Pi]}, {
               Rational[5, 3], 0}, {
              Rational[5, 3] Cos[Rational[1, 60] Pi], Rational[-5, 3] 
               Sin[Rational[1, 60] Pi]}, {
              Rational[5, 3] Cos[Rational[1, 30] Pi], Rational[-5, 3] 
               Sin[Rational[1, 30] Pi]}, {
              Rational[5, 3] Cos[Rational[1, 20] Pi], Rational[-5, 3] 
               Sin[Rational[1, 20] Pi]}, {
              Rational[5, 3] Cos[Rational[1, 15] Pi], Rational[-5, 3] 
               Sin[Rational[1, 15] Pi]}, {
              Rational[5, 6] 2^Rational[-1, 2] (1 + 3^Rational[1, 2]), 
               Rational[-5, 6] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {
              Rational[
                5, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], Rational[5, 12] (1 - 5^Rational[1, 2])}, {
              Rational[5, 3] Cos[Rational[7, 60] Pi], Rational[-5, 3] 
               Sin[Rational[7, 60] Pi]}, {
              Rational[5, 3] Cos[Rational[2, 15] Pi], Rational[-5, 3] 
               Sin[Rational[2, 15] Pi]}, {
              Rational[5, 3] Cos[Rational[3, 20] Pi], Rational[-5, 3] 
               Sin[Rational[3, 20] Pi]}, {Rational[5, 2] 3^Rational[-1, 2], 
               Rational[-5, 6]}, {
              Rational[5, 3] Cos[Rational[11, 60] Pi], Rational[-5, 3] 
               Sin[Rational[11, 60] Pi]}, {
              Rational[5, 12] (1 + 5^Rational[1, 2]), 
               Rational[-5, 3] (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              Rational[5, 3] Cos[Rational[13, 60] Pi], Rational[-5, 3] 
               Sin[Rational[13, 60] Pi]}, {
              Rational[5, 3] Cos[Rational[7, 30] Pi], Rational[-5, 3] 
               Sin[Rational[7, 30] Pi]}, {
              Rational[5, 3] 2^Rational[-1, 2], Rational[-5, 3] 
               2^Rational[-1, 2]}, {
              Rational[5, 3] Sin[Rational[7, 30] Pi], Rational[-5, 3] 
               Cos[Rational[7, 30] Pi]}, {
              Rational[5, 3] Sin[Rational[13, 60] Pi], Rational[-5, 3] 
               Cos[Rational[13, 60] Pi]}, {
              Rational[
                5, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], Rational[5, 12] (-1 - 5^Rational[1, 2])}, {
              Rational[5, 3] Sin[Rational[11, 60] Pi], Rational[-5, 3] 
               Cos[Rational[11, 60] Pi]}, {
               Rational[5, 6], Rational[-5, 2] 3^Rational[-1, 2]}, {
              Rational[5, 3] Sin[Rational[3, 20] Pi], Rational[-5, 3] 
               Cos[Rational[3, 20] Pi]}, {
              Rational[5, 3] Sin[Rational[2, 15] Pi], Rational[-5, 3] 
               Cos[Rational[2, 15] Pi]}, {
              Rational[5, 3] Sin[Rational[7, 60] Pi], Rational[-5, 3] 
               Cos[Rational[7, 60] Pi]}, {
              Rational[5, 12] (-1 + 5^Rational[1, 2]), 
               Rational[-5, 3] (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              Rational[5, 6] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 
               Rational[-5, 6] 2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
              Rational[5, 3] Sin[Rational[1, 15] Pi], Rational[-5, 3] 
               Cos[Rational[1, 15] Pi]}, {
              Rational[5, 3] Sin[Rational[1, 20] Pi], Rational[-5, 3] 
               Cos[Rational[1, 20] Pi]}, {
              Rational[5, 3] Sin[Rational[1, 30] Pi], Rational[-5, 3] 
               Cos[Rational[1, 30] Pi]}, {
              Rational[5, 3] Sin[Rational[1, 60] Pi], Rational[-5, 3] 
               Cos[Rational[1, 60] Pi]}, {0, 
               Rational[-5, 3]}, {
              Rational[-5, 3] Sin[Rational[1, 60] Pi], Rational[-5, 3] 
               Cos[Rational[1, 60] Pi]}, {
              Rational[-5, 3] Sin[Rational[1, 30] Pi], Rational[-5, 3] 
               Cos[Rational[1, 30] Pi]}, {
              Rational[-5, 3] Sin[Rational[1, 20] Pi], Rational[-5, 3] 
               Cos[Rational[1, 20] Pi]}, {
              Rational[-5, 3] Sin[Rational[1, 15] Pi], Rational[-5, 3] 
               Cos[Rational[1, 15] Pi]}, {
              Rational[-5, 6] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 
               Rational[-5, 6] 2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
              Rational[5, 12] (1 - 5^Rational[1, 2]), 
               Rational[-5, 3] (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              Rational[-5, 3] Sin[Rational[7, 60] Pi], Rational[-5, 3] 
               Cos[Rational[7, 60] Pi]}, {
              Rational[-5, 3] Sin[Rational[2, 15] Pi], Rational[-5, 3] 
               Cos[Rational[2, 15] Pi]}, {
              Rational[-5, 3] Sin[Rational[3, 20] Pi], Rational[-5, 3] 
               Cos[Rational[3, 20] Pi]}, {
               Rational[-5, 6], Rational[-5, 2] 3^Rational[-1, 2]}, {
              Rational[-5, 3] Sin[Rational[11, 60] Pi], Rational[-5, 3] 
               Cos[Rational[11, 60] Pi]}, {
              Rational[-5, 3] (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[5, 12] (-1 - 5^Rational[1, 2])}, {
              Rational[-5, 3] Sin[Rational[13, 60] Pi], Rational[-5, 3] 
               Cos[Rational[13, 60] Pi]}, {
              Rational[-5, 3] Sin[Rational[7, 30] Pi], Rational[-5, 3] 
               Cos[Rational[7, 30] Pi]}, {
              Rational[-5, 3] 2^Rational[-1, 2], Rational[-5, 3] 
               2^Rational[-1, 2]}, {
              Rational[-5, 3] Cos[Rational[7, 30] Pi], Rational[-5, 3] 
               Sin[Rational[7, 30] Pi]}, {
              Rational[-5, 3] Cos[Rational[13, 60] Pi], Rational[-5, 3] 
               Sin[Rational[13, 60] Pi]}, {
              Rational[5, 12] (-1 - 5^Rational[1, 2]), 
               Rational[-5, 3] (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              Rational[-5, 3] Cos[Rational[11, 60] Pi], Rational[-5, 3] 
               Sin[Rational[11, 60] Pi]}, {Rational[-5, 2] 3^Rational[-1, 2], 
               Rational[-5, 6]}, {
              Rational[-5, 3] Cos[Rational[3, 20] Pi], Rational[-5, 3] 
               Sin[Rational[3, 20] Pi]}, {
              Rational[-5, 3] Cos[Rational[2, 15] Pi], Rational[-5, 3] 
               Sin[Rational[2, 15] Pi]}, {
              Rational[-5, 3] Cos[Rational[7, 60] Pi], Rational[-5, 3] 
               Sin[Rational[7, 60] Pi]}, {
              Rational[-5, 3] (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[5, 12] (1 - 5^Rational[1, 2])}, {
              Rational[-5, 6] 2^Rational[-1, 2] (1 + 3^Rational[1, 2]), 
               Rational[-5, 6] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {
              Rational[-5, 3] Cos[Rational[1, 15] Pi], Rational[-5, 3] 
               Sin[Rational[1, 15] Pi]}, {
              Rational[-5, 3] Cos[Rational[1, 20] Pi], Rational[-5, 3] 
               Sin[Rational[1, 20] Pi]}, {
              Rational[-5, 3] Cos[Rational[1, 30] Pi], Rational[-5, 3] 
               Sin[Rational[1, 30] Pi]}, {
              Rational[-5, 3] Cos[Rational[1, 60] Pi], Rational[-5, 3] 
               Sin[Rational[1, 60] Pi]}, {
               Rational[-5, 3], 0}, {
              Rational[-5, 3] Cos[Rational[1, 60] Pi], Rational[5, 3] 
               Sin[Rational[1, 60] Pi]}, {
              Rational[-5, 3] Cos[Rational[1, 30] Pi], Rational[5, 3] 
               Sin[Rational[1, 30] Pi]}, {
              Rational[-5, 3] Cos[Rational[1, 20] Pi], Rational[5, 3] 
               Sin[Rational[1, 20] Pi]}, {
              Rational[-5, 3] Cos[Rational[1, 15] Pi], Rational[5, 3] 
               Sin[Rational[1, 15] Pi]}, {
              Rational[-5, 6] 2^Rational[-1, 2] (1 + 3^Rational[1, 2]), 
               Rational[5, 6] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2])}, {
              Rational[-5, 3] (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[5, 12] (-1 + 5^Rational[1, 2])}, {
              Rational[-5, 3] Cos[Rational[7, 60] Pi], Rational[5, 3] 
               Sin[Rational[7, 60] Pi]}, {
              Rational[-5, 3] Cos[Rational[2, 15] Pi], Rational[5, 3] 
               Sin[Rational[2, 15] Pi]}, {
              Rational[-5, 3] Cos[Rational[3, 20] Pi], Rational[5, 3] 
               Sin[Rational[3, 20] Pi]}, {Rational[-5, 2] 3^Rational[-1, 2], 
               Rational[5, 6]}, {
              Rational[-5, 3] Cos[Rational[11, 60] Pi], Rational[5, 3] 
               Sin[Rational[11, 60] Pi]}, {
              Rational[5, 12] (-1 - 5^Rational[1, 2]), 
               Rational[
                5, 3] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2]}, {
              Rational[-5, 3] Cos[Rational[13, 60] Pi], Rational[5, 3] 
               Sin[Rational[13, 60] Pi]}, {
              Rational[-5, 3] Cos[Rational[7, 30] Pi], Rational[5, 3] 
               Sin[Rational[7, 30] Pi]}, {
              Rational[-5, 3] 2^Rational[-1, 2], Rational[5, 3] 
               2^Rational[-1, 2]}, {
              Rational[-5, 3] Sin[Rational[7, 30] Pi], Rational[5, 3] 
               Cos[Rational[7, 30] Pi]}, {
              Rational[-5, 3] Sin[Rational[13, 60] Pi], Rational[5, 3] 
               Cos[Rational[13, 60] Pi]}, {
              Rational[-5, 3] (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[5, 12] (1 + 5^Rational[1, 2])}, {
              Rational[-5, 3] Sin[Rational[11, 60] Pi], Rational[5, 3] 
               Cos[Rational[11, 60] Pi]}, {
               Rational[-5, 6], Rational[5, 2] 3^Rational[-1, 2]}, {
              Rational[-5, 3] Sin[Rational[3, 20] Pi], Rational[5, 3] 
               Cos[Rational[3, 20] Pi]}, {
              Rational[-5, 3] Sin[Rational[2, 15] Pi], Rational[5, 3] 
               Cos[Rational[2, 15] Pi]}, {
              Rational[-5, 3] Sin[Rational[7, 60] Pi], Rational[5, 3] 
               Cos[Rational[7, 60] Pi]}, {
              Rational[5, 12] (1 - 5^Rational[1, 2]), 
               Rational[
                5, 3] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2]}, {
              Rational[-5, 6] 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 
               Rational[5, 6] 2^Rational[-1, 2] (1 + 3^Rational[1, 2])}, {
              Rational[-5, 3] Sin[Rational[1, 15] Pi], Rational[5, 3] 
               Cos[Rational[1, 15] Pi]}, {
              Rational[-5, 3] Sin[Rational[1, 20] Pi], Rational[5, 3] 
               Cos[Rational[1, 20] Pi]}, {
              Rational[-5, 3] Sin[Rational[1, 30] Pi], Rational[5, 3] 
               Cos[Rational[1, 30] Pi]}, {
              Rational[-5, 3] Sin[Rational[1, 60] Pi], Rational[5, 3] 
               Cos[Rational[1, 60] Pi]}, {0, 
               Rational[5, 3]}}, {{0, 1.6666666666666667`}, {
              0.08722659373823971, 1.6643825579242897`}, {0.1742141054460891, 
              1.6575364922804556`}, {0.2607241084003848, 
              1.6461472343252297`}, {0.34651948469626553`, 
              1.6302460012230096`}, {0.4313650751708679, 
              1.6098763771484472`}, {0.5150283239582458, 
              1.5850941938252558`}, {0.5972799159088338, 
              1.5559673774953362`}, {0.6778944051263336, 
              1.5225757627376681`}, {0.7566508328992446, 
              1.4850108736472798`}, {0.8333333333333334, 
              1.4433756729740645`}, {0.907731725025045, 1.39778427990904}, {
              0.9796420871541219, 1.348361657291579}, {1.048867318416396, 
              1.2952432690949514`}, {1.1152176772647637`, 
              1.2385747091289905`}, {1.1785113019775793`, 
              1.1785113019775793`}, {1.2385747091289905`, 
              1.1152176772647637`}, {1.2952432690949514`, 
              1.048867318416396}, {1.348361657291579, 0.9796420871541219}, {
              1.39778427990904, 0.907731725025045}, {1.4433756729740645`, 
              0.8333333333333334}, {1.4850108736472798`, 
              0.7566508328992446}, {1.5225757627376681`, 
              0.6778944051263336}, {1.5559673774953362`, 
              0.5972799159088338}, {1.5850941938252558`, 
              0.5150283239582458}, {1.6098763771484472`, 
              0.4313650751708679}, {1.6302460012230096`, 
              0.34651948469626553`}, {1.6461472343252297`, 
              0.2607241084003848}, {1.6575364922804556`, 
              0.1742141054460891}, {1.6643825579242897`, 
              0.08722659373823971}, {1.6666666666666667`, 0}, {
              1.6643825579242897`, -0.08722659373823971}, {
              1.6575364922804556`, -0.1742141054460891}, {
              1.6461472343252297`, -0.2607241084003848}, {
              1.6302460012230096`, -0.34651948469626553`}, {
              1.6098763771484472`, -0.4313650751708679}, {
              1.5850941938252558`, -0.5150283239582458}, {
              1.5559673774953362`, -0.5972799159088338}, {
              1.5225757627376681`, -0.6778944051263336}, {
              1.4850108736472798`, -0.7566508328992446}, {
              1.4433756729740645`, -0.8333333333333334}, {
              1.39778427990904, -0.907731725025045}, {
              1.348361657291579, -0.9796420871541219}, {
              1.2952432690949514`, -1.048867318416396}, {
              1.2385747091289905`, -1.1152176772647637`}, {
              1.1785113019775793`, -1.1785113019775793`}, {
              1.1152176772647637`, -1.2385747091289905`}, {
              1.048867318416396, -1.2952432690949514`}, {
              0.9796420871541219, -1.348361657291579}, {
              0.907731725025045, -1.39778427990904}, {
              0.8333333333333334, -1.4433756729740645`}, {
              0.7566508328992446, -1.4850108736472798`}, {
              0.6778944051263336, -1.5225757627376681`}, {
              0.5972799159088338, -1.5559673774953362`}, {
              0.5150283239582458, -1.5850941938252558`}, {
              0.4313650751708679, -1.6098763771484472`}, {
              0.34651948469626553`, -1.6302460012230096`}, {
              0.2607241084003848, -1.6461472343252297`}, {
              0.1742141054460891, -1.6575364922804556`}, {
              0.08722659373823971, -1.6643825579242897`}, {
              
              0, -1.6666666666666667`}, {-0.08722659373823971, \
-1.6643825579242897`}, {-0.1742141054460891, -1.6575364922804556`}, \
{-0.2607241084003848, -1.6461472343252297`}, {-0.34651948469626553`, \
-1.6302460012230096`}, {-0.4313650751708679, -1.6098763771484472`}, \
{-0.5150283239582458, -1.5850941938252558`}, {-0.5972799159088338, \
-1.5559673774953362`}, {-0.6778944051263336, -1.5225757627376681`}, \
{-0.7566508328992446, -1.4850108736472798`}, {-0.8333333333333334, \
-1.4433756729740645`}, {-0.907731725025045, -1.39778427990904}, \
{-0.9796420871541219, -1.348361657291579}, {-1.048867318416396, \
-1.2952432690949514`}, {-1.1152176772647637`, -1.2385747091289905`}, \
{-1.1785113019775793`, -1.1785113019775793`}, {-1.2385747091289905`, \
-1.1152176772647637`}, {-1.2952432690949514`, -1.048867318416396}, \
{-1.348361657291579, -0.9796420871541219}, {-1.39778427990904, \
-0.907731725025045}, {-1.4433756729740645`, -0.8333333333333334}, \
{-1.4850108736472798`, -0.7566508328992446}, {-1.5225757627376681`, \
-0.6778944051263336}, {-1.5559673774953362`, -0.5972799159088338}, \
{-1.5850941938252558`, -0.5150283239582458}, {-1.6098763771484472`, \
-0.4313650751708679}, {-1.6302460012230096`, -0.34651948469626553`}, \
{-1.6461472343252297`, -0.2607241084003848}, {-1.6575364922804556`, \
-0.1742141054460891}, {-1.6643825579242897`, -0.08722659373823971}, \
{-1.6666666666666667`, 0}, {-1.6643825579242897`, 
              0.08722659373823971}, {-1.6575364922804556`, 
              0.1742141054460891}, {-1.6461472343252297`, 
              0.2607241084003848}, {-1.6302460012230096`, 
              0.34651948469626553`}, {-1.6098763771484472`, 
              0.4313650751708679}, {-1.5850941938252558`, 
              0.5150283239582458}, {-1.5559673774953362`, 
              0.5972799159088338}, {-1.5225757627376681`, 
              0.6778944051263336}, {-1.4850108736472798`, 
              0.7566508328992446}, {-1.4433756729740645`, 
              0.8333333333333334}, {-1.39778427990904, 
              0.907731725025045}, {-1.348361657291579, 
              0.9796420871541219}, {-1.2952432690949514`, 
              1.048867318416396}, {-1.2385747091289905`, 
              1.1152176772647637`}, {-1.1785113019775793`, 
              1.1785113019775793`}, {-1.1152176772647637`, 
              1.2385747091289905`}, {-1.048867318416396, 
              1.2952432690949514`}, {-0.9796420871541219, 
              1.348361657291579}, {-0.907731725025045, 
              1.39778427990904}, {-0.8333333333333334, 
              1.4433756729740645`}, {-0.7566508328992446, 
              1.4850108736472798`}, {-0.6778944051263336, 
              1.5225757627376681`}, {-0.5972799159088338, 
              1.5559673774953362`}, {-0.5150283239582458, 
              1.5850941938252558`}, {-0.4313650751708679, 
              1.6098763771484472`}, {-0.34651948469626553`, 
              1.6302460012230096`}, {-0.2607241084003848, 
              1.6461472343252297`}, {-0.1742141054460891, 
              1.6575364922804556`}, {-0.08722659373823971, 
              1.6643825579242897`}, {
              0, 1.6666666666666667`}}]]}}, {{{}, {}}, {}, {{}, 
           GraphicsComplexBox[CompressedData["
1:eJxd0ns0FIgeB/AxjZSyu0oqyqvt2jySknJm9BuP5MSairJEHsuukFdLIZQe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            "], {{{}, {}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                PointSize[0.009166666666666668], 
                RGBColor[0.368417, 0.506779, 0.709798], 
                AbsoluteThickness[1.6], 
                Thickness[0.01]], 
               
               LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 
                32, 33, 34, 35, 36, 37}]}, {
               Hue[0.9060679774997897, 0.6, 0.6], 
               Directive[
                PointSize[0.009166666666666668], 
                RGBColor[0.880722, 0.611041, 0.142051], 
                AbsoluteThickness[1.6], 
                Thickness[0.01]], 
               
               LineBox[{38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 
                51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 
                66, 67, 68, 69, 70, 71, 72, 73, 74}]}, {
               Hue[0.1421359549995791, 0.6, 0.6], 
               Directive[
                PointSize[0.009166666666666668], 
                RGBColor[0.560181, 0.691569, 0.194885], 
                AbsoluteThickness[1.6], 
                Thickness[0.01]], 
               
               LineBox[{75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 
                88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102,
                 103, 104, 105, 106, 107, 108, 109, 110, 
                111}]}}}], {}, {}, {{}, {}}}, {}, {}, {{}, {}}, {}, {{{}, {}, \
{}, {}}, {}}}}, {ImageSize -> 600}],FormBox[
        FormBox[
         TemplateBox[{
           StyleBox[
           "\"\\!\\(\\*SubscriptBox[\\\"F\\\", \\\"a\\\"]\\)\"", 50, 
            StripOnInput -> False], 
           StyleBox[
           "\"\\!\\(\\*SubscriptBox[\\\"F\\\", \\\"b\\\"]\\)\"", 50, 
            StripOnInput -> False], 
           StyleBox[
           "\"\\!\\(\\*SubscriptBox[\\\"F\\\", \\\"c\\\"]\\)\"", 50, 
            StripOnInput -> False]}, "PointLegend", 
          DisplayFunction -> (FormBox[
            StyleBox[
             StyleBox[
              PaneBox[
               TagBox[
                GridBox[{{
                   TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[0.18]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[0.18]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[0.18]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[0.18]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6], 
                    Thickness[0.18]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6], 
                    Thickness[0.18]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                 False, GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                "Grid"], Alignment -> Left, AppearanceElements -> None, 
               ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
               "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
             FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
             False], TraditionalForm]& ), 
          InterpretationFunction :> (RowBox[{"PointLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.01`", "]"}]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.01`", "]"}]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.560181, 0.691569, 0.194885]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.01`", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
               RowBox[{"LegendMarkers", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
               RowBox[{"Joined", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"{", "}"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
          Editable -> True], TraditionalForm], TraditionalForm]},
      "Legended",
      DisplayFunction->(GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"], 
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ),
      Editable->True,
      InterpretationFunction->(RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.9543996225752163`*^9, 3.9543996398418007`*^9}, 
   3.954399672039648*^9, 3.9543998776592503`*^9, {3.9543999320903387`*^9, 
   3.954399970919401*^9}, 3.954400165466818*^9, {3.954400208821863*^9, 
   3.95440021727326*^9}, 3.9544002508189926`*^9, {3.9544030707866335`*^9, 
   3.9544030787074413`*^9}, 3.9544032357784305`*^9, 3.954403319519314*^9, 
   3.9544033778409014`*^9, 3.9544036116280384`*^9, 3.954403764448978*^9, 
   3.954476920960204*^9, 3.9544769793444605`*^9, 3.9574833978025465`*^9, 
   3.9574834512499747`*^9, 3.957483529750285*^9, 3.957483585638762*^9, 
   3.9574836531947355`*^9, 3.9574837607594814`*^9, {3.9574840845887175`*^9, 
   3.9574840962590575`*^9}, 3.957484472723222*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VisualizeMolecularFrameWithLabels", "[", 
  RowBox[{"rMatrix", ",", "alphaC", ",", "tfp"}], "]"}]], "Input",
 CellChangeTimes->{{3.954400367471016*^9, 3.954400367483019*^9}}],

Cell[BoxData[
 Graphics3DBox[{
   {AbsoluteThickness[3], EdgeForm[None], Specularity[
     GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJxTTMoPSmViYGAQBWJmIPbpaZvG/c/5QAvr9eLk/kgHBgLAbtbPmlWtiWB1
B4T/2kBEV+5hLQh9VFye6nBDtu5Vp7Cng8j9CdYxt4MOPMuq+Jb20P3Aro/i
UqcnBh0QOLXj2IEpcQ6X7B4fv/FO4YBNf1/9n9+pBwIddrbkTopzuH1cM1q1
TP3A+62HP19UNj+geTOlXT43y4HlzLEnKycmH3igq/flflPwgeOGagW8yfEO
izQ2f1pi53Xg0K1jOR/X+x/41jih+CNnwoGKnLzvz4zSD4it2LN+lZvXAcco
wVUh7IkHrjZ4bLVzfr3f9jPXnp2bXuw3W839sbck98Adk57p/yJND5yZ4jGD
gzfjQN0Dppu5GYkHIOFjDA0fTwfUcAiEhsNbaDjM3KPUuly/vy7Z4SY4HCyh
4eB04O4dJ98P+2wPmN3nmL4/yuOAxPyEr/tvpzjse5ayiLkr8sBZfuX2UK7g
A29q86Wf/45zmGVVqCEra3NAsmMWzyOX+AMGrDtVp0+Oc+hYaCN/qdTpQK13
1WeWn/EHrDZ6LtPfmXBgoZm0yYRDsQdyDjry+f32OSDz7gLf4o6EA0u9Ot5u
XG11wKP5tmYcp8OBaWJ+m+z3px0AAM2N4QE=
     "], {
      {RGBColor[0.65, 0.7, 0.7], SphereBox[1, 24.], SphereBox[4, 24.], 
       SphereBox[6, 24.], SphereBox[7, 24.], SphereBox[8, 24.]}, 
      {RGBColor[0.4, 0.4, 0.4], SphereBox[2, 34.], SphereBox[5, 34.], 
       SphereBox[9, 34.]}, 
      {RGBColor[0.800498, 0.201504, 0.192061], SphereBox[3, 31.]}, 
      {RGBColor[0.578462, 0.85539, 0.408855], SphereBox[10, 30.], 
       SphereBox[11, 30.], SphereBox[12, 30.]}, 
      {RGBColor[0.65, 0.7, 0.7], CylinderBox[{1, 13}, 15.], 
       CylinderBox[{15, 4}, 15.], CylinderBox[{16, 7}, 15.], 
       CylinderBox[{17, 8}, 15.], CylinderBox[{18, 6}, 15.]}, 
      {RGBColor[0.4, 0.4, 0.4], CylinderBox[{13, 2}, 15.], 
       CylinderBox[{2, 14}, 15.], CylinderBox[{2, 5}, 15.], 
       CylinderBox[{2, 9}, 15.], CylinderBox[{5, 16}, 15.], 
       CylinderBox[{5, 17}, 15.], CylinderBox[{5, 18}, 15.], 
       CylinderBox[{9, 19}, 15.], CylinderBox[{9, 20}, 15.], 
       CylinderBox[{9, 21}, 15.]}, 
      {RGBColor[0.800498, 0.201504, 0.192061], CylinderBox[{14, 3}, 15.], 
       CylinderBox[{3, 15}, 15.]}, 
      {RGBColor[0.578462, 0.85539, 0.408855], CylinderBox[{19, 12}, 15.], 
       CylinderBox[{20, 10}, 15.], CylinderBox[{21, 11}, 15.]}}]}, {
    {RGBColor[
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333], 1], 
     CylinderBox[{{-39.98472863740662, 102.24044509885977`, 0.}, {0., 0., 
      0.}}, 16], 
     CylinderBox[{{0., 0., 0.}, {140.17706154585352`, 
      6.456423937151179*^-15, -1.734723475976807*^-16}}, 16], 
     CylinderBox[{{140.17706154585352`, 
      6.456423937151179*^-15, -1.734723475976807*^-16}, {171.73289601027514`, 
      50.15264636190449, -75.42750443599317}}, 16]}, 
    {GrayLevel[0], Text3DBox[
      StyleBox["\<\"\\!\\(\\*SubscriptBox[\\\"F\\\", \\\"a\\\"]\\)\"\>",
       StripOnInput->False,
       SingleLetterItalics->False,
       FontSize->30,
       FontWeight->
        Bold], {-185.59069415633326`, -52.55208393775699, \
-136.22908500088855`}], Text3DBox[
      StyleBox["\<\"\\!\\(\\*SubscriptBox[\\\"F\\\", \\\"b\\\"]\\)\"\>",
       StripOnInput->False,
       SingleLetterItalics->False,
       FontSize->30,
       FontWeight->
        Bold], {-0.8519586125076112, -0.7718170807562285, \
-235.64232685355245`}], Text3DBox[
      StyleBox["\<\"\\!\\(\\*SubscriptBox[\\\"F\\\", \\\"c\\\"]\\)\"\>",
       StripOnInput->False,
       SingleLetterItalics->False,
       FontSize->30,
       FontWeight->
        Bold], {-21.3515410153676, -192.40729917694114`, \
-139.26340914308452`}]}}},
  Boxed->False,
  ImageSize->800,
  Lighting->"Neutral",
  ViewPoint->{1.6924399043011829`, -2.922171928081657, -0.1447701387045491},
  ViewVertical->{0.9081452449628932, -0.9287622886130882, 
   0.16295733887154784`}]], "Output",
 CellChangeTimes->{3.9544003788817587`*^9, 3.9544006150146685`*^9, 
  3.954403418083076*^9, 3.95440361245877*^9, 3.9544037651557198`*^9, 
  3.954476982962125*^9, 3.95447702832003*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Histogram", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ExtractDihedralAngles", "[", "20", "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ExtractDihedralAngles", "[", "33", "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ExtractDihedralAngles", "[", "40", "]"}]}], 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", "360", ",", 
    "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
    RowBox[{"ChartLegends", "\[Rule]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
      "\"\<0 V\[CenterDot]nm\:207b\.b9\>\"", ",", 
       "\"\<1 V\[CenterDot]nm\:207b\.b9\>\"", ",", 
       "\"\<5 V\[CenterDot]nm\:207b\.b9\>\""}], "\[IndentingNewLine]", 
      "}"}]}]}], "\[IndentingNewLine]", "]"}], "\n"}]], "Input",
 CellChangeTimes->{{3.9544008565411415`*^9, 3.954400895263154*^9}}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{
      Directive[
       EdgeForm[
        Directive[
         Opacity[0.]]], 
       RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`]], {{{{}, {
          Directive[
           Opacity[0.5], 
           Directive[
            EdgeForm[
             Directive[
              Opacity[0.]]], 
            RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`]], 
           Directive[
            RGBColor[0.97858, 0.678934, 0.157834]]], {{{
             
             RectangleBox[{-180., 0.}, {-179., 2431}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-179., 0.}, {-178., 2662}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-178., 0.}, {-177., 2732}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-177., 0.}, {-176., 2866}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-176., 0.}, {-175., 2978}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-175., 0.}, {-174., 3100}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-174., 0.}, {-173., 3177}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-173., 0.}, {-172., 3295}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-172., 0.}, {-171., 3291}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-171., 0.}, {-170., 3489}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-170., 0.}, {-169., 3571}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-169., 0.}, {-168., 3580}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-168., 0.}, {-167., 3499}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-167., 0.}, {-166., 3714}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-166., 0.}, {-165., 3731}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-165., 0.}, {-164., 3712}, "RoundingRadius" -> 
              0]}}, {{
             RectangleBox[{-164., 0.}, {-163., 3802}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-163., 0.}, {-162., 3640}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-162., 0.}, {-161., 3736}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-161., 0.}, {-160., 3766}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-160., 0.}, {-159., 3692}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-159., 0.}, {-158., 3619}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-158., 0.}, {-157., 3659}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-157., 0.}, {-156., 3546}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-156., 0.}, {-155., 3581}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-155., 0.}, {-154., 3538}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-154., 0.}, {-153., 3422}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-153., 0.}, {-152., 3336}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-152., 0.}, {-151., 3228}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-151., 0.}, {-150., 3236}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-150., 0.}, {-149., 3151}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-149., 0.}, {-148., 3129}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-148., 0.}, {-147., 3127}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-147., 0.}, {-146., 3014}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-146., 0.}, {-145., 2955}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-145., 0.}, {-144., 2883}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-144., 0.}, {-143., 2770}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-143., 0.}, {-142., 2839}, "RoundingRadius" -> 
              0]}}, {{
             RectangleBox[{-142., 0.}, {-141., 2742}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-141., 0.}, {-140., 2704}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-140., 0.}, {-139., 2668}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-139., 0.}, {-138., 2562}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-138., 0.}, {-137., 2529}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-137., 0.}, {-136., 2479}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-136., 0.}, {-135., 2413}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-135., 0.}, {-134., 2426}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-134., 0.}, {-133., 2369}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-133., 0.}, {-132., 2331}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-132., 0.}, {-131., 2379}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-131., 0.}, {-130., 2205}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-130., 0.}, {-129., 2276}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-129., 0.}, {-128., 2261}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-128., 0.}, {-127., 2273}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-127., 0.}, {-126., 2239}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-126., 0.}, {-125., 2267}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-125., 0.}, {-124., 2274}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-124., 0.}, {-123., 2305}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-123., 0.}, {-122., 2264}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-122., 0.}, {-121., 2283}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-121., 0.}, {-120., 2274}, "RoundingRadius" -> 
              0]}}, {{
             RectangleBox[{-120., 0.}, {-119., 2302}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-119., 0.}, {-118., 2276}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-118., 0.}, {-117., 2438}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-117., 0.}, {-116., 2502}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-116., 0.}, {-115., 2482}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-115., 0.}, {-114., 2431}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-114., 0.}, {-113., 2495}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-113., 0.}, {-112., 2531}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-112., 0.}, {-111., 2606}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-111., 0.}, {-110., 2710}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-110., 0.}, {-109., 2784}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-109., 0.}, {-108., 2803}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-108., 0.}, {-107., 2942}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-107., 0.}, {-106., 3133}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-106., 0.}, {-105., 3124}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-105., 0.}, {-104., 3343}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-104., 0.}, {-103., 3463}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-103., 0.}, {-102., 3555}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-102., 0.}, {-101., 3684}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-101., 0.}, {-100., 3710}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-100., 0.}, {-99., 3872}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-99., 0.}, {-98., 4012}, "RoundingRadius" -> 
              0]}}, {{
             RectangleBox[{-98., 0.}, {-97., 4217}, "RoundingRadius" -> 0]}},
            {{
             
             RectangleBox[{-97., 0.}, {-96., 4344}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-96., 0.}, {-95., 4598}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-95., 0.}, {-94., 4786}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-94., 0.}, {-93., 5016}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-93., 0.}, {-92., 5178}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-92., 0.}, {-91., 5497}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-91., 0.}, {-90., 5609}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-90., 0.}, {-89., 5986}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-89., 0.}, {-88., 6144}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-88., 0.}, {-87., 6499}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-87., 0.}, {-86., 6662}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-86., 0.}, {-85., 7014}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-85., 0.}, {-84., 7429}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-84., 0.}, {-83., 7464}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-83., 0.}, {-82., 7869}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-82., 0.}, {-81., 8216}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-81., 0.}, {-80., 8578}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-80., 0.}, {-79., 8618}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-79., 0.}, {-78., 8850}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-78., 0.}, {-77., 9357}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-77., 0.}, {-76., 9659}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-76., 0.}, {-75., 9842}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-75., 0.}, {-74., 10098}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-74., 0.}, {-73., 10369}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-73., 0.}, {-72., 10614}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-72., 0.}, {-71., 10935}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-71., 0.}, {-70., 11049}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-70., 0.}, {-69., 11302}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-69., 0.}, {-68., 11322}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-68., 0.}, {-67., 11486}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-67., 0.}, {-66., 11644}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-66., 0.}, {-65., 11857}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-65., 0.}, {-64., 11775}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-64., 0.}, {-63., 11806}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-63., 0.}, {-62., 11709}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-62., 0.}, {-61., 11856}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-61., 0.}, {-60., 11677}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-60., 0.}, {-59., 11447}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-59., 0.}, {-58., 11559}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-58., 0.}, {-57., 11330}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-57., 0.}, {-56., 11088}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-56., 0.}, {-55., 10624}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-55., 0.}, {-54., 10578}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-54., 0.}, {-53., 10140}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-53., 0.}, {-52., 9757}, "RoundingRadius" -> 
              0]}}, {{
             RectangleBox[{-52., 0.}, {-51., 9618}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-51., 0.}, {-50., 8978}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-50., 0.}, {-49., 8775}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-49., 0.}, {-48., 8204}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-48., 0.}, {-47., 7975}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-47., 0.}, {-46., 7482}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-46., 0.}, {-45., 6897}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-45., 0.}, {-44., 6603}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-44., 0.}, {-43., 6248}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-43., 0.}, {-42., 5829}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-42., 0.}, {-41., 5456}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-41., 0.}, {-40., 5125}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-40., 0.}, {-39., 4597}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-39., 0.}, {-38., 4413}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-38., 0.}, {-37., 4012}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-37., 0.}, {-36., 3647}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-36., 0.}, {-35., 3354}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-35., 0.}, {-34., 3050}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-34., 0.}, {-33., 2823}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-33., 0.}, {-32., 2648}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-32., 0.}, {-31., 2317}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-31., 0.}, {-30., 2067}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-30., 0.}, {-29., 1907}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-29., 0.}, {-28., 1774}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-28., 0.}, {-27., 1616}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-27., 0.}, {-26., 1368}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-26., 0.}, {-25., 1261}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-25., 0.}, {-24., 1163}, "RoundingRadius" -> 
              0]}}, {{
             RectangleBox[{-24., 0.}, {-23., 988}, "RoundingRadius" -> 0]}}, {{
             
             RectangleBox[{-23., 0.}, {-22., 1007}, "RoundingRadius" -> 
              0]}}, {{
             RectangleBox[{-22., 0.}, {-21., 872}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-21., 0.}, {-20., 782}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-20., 0.}, {-19., 701}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-19., 0.}, {-18., 605}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-18., 0.}, {-17., 557}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-17., 0.}, {-16., 499}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-16., 0.}, {-15., 508}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-15., 0.}, {-14., 454}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-14., 0.}, {-13., 396}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-13., 0.}, {-12., 349}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-12., 0.}, {-11., 367}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-11., 0.}, {-10., 280}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-10., 0.}, {-9., 276}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-9., 0.}, {-8., 251}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-8., 0.}, {-7., 230}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-7., 0.}, {-6., 216}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-6., 0.}, {-5., 198}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-5., 0.}, {-4., 198}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-4., 0.}, {-3., 161}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-3., 0.}, {-2., 163}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-2., 0.}, {-1., 150}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-1., 0.}, {0., 153}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{0., 0.}, {1., 147}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{1., 0.}, {2., 138}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{2., 0.}, {3., 113}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{3., 0.}, {4., 122}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{4., 0.}, {5., 119}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{5., 0.}, {6., 98}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{6., 0.}, {7., 97}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{7., 0.}, {8., 96}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{8., 0.}, {9., 88}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{9., 0.}, {10., 89}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{10., 0.}, {11., 74}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{11., 0.}, {12., 83}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{12., 0.}, {13., 86}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{13., 0.}, {14., 70}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{14., 0.}, {15., 75}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{15., 0.}, {16., 75}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{16., 0.}, {17., 70}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{17., 0.}, {18., 69}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{18., 0.}, {19., 79}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{19., 0.}, {20., 88}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{20., 0.}, {21., 71}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{21., 0.}, {22., 59}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{22., 0.}, {23., 70}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{23., 0.}, {24., 70}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{24., 0.}, {25., 70}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{25., 0.}, {26., 62}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{26., 0.}, {27., 72}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{27., 0.}, {28., 82}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{28., 0.}, {29., 58}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{29., 0.}, {30., 81}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{30., 0.}, {31., 62}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{31., 0.}, {32., 69}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{32., 0.}, {33., 71}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{33., 0.}, {34., 60}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{34., 0.}, {35., 71}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{35., 0.}, {36., 77}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{36., 0.}, {37., 60}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{37., 0.}, {38., 61}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{38., 0.}, {39., 59}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{39., 0.}, {40., 62}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{40., 0.}, {41., 71}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{41., 0.}, {42., 67}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{42., 0.}, {43., 68}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{43., 0.}, {44., 73}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{44., 0.}, {45., 78}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{45., 0.}, {46., 80}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{46., 0.}, {47., 79}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{47., 0.}, {48., 60}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{48., 0.}, {49., 59}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{49., 0.}, {50., 55}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{50., 0.}, {51., 61}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{51., 0.}, {52., 70}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{52., 0.}, {53., 64}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{53., 0.}, {54., 53}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{54., 0.}, {55., 57}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{55., 0.}, {56., 66}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{56., 0.}, {57., 43}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{57., 0.}, {58., 48}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{58., 0.}, {59., 40}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{59., 0.}, {60., 48}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{60., 0.}, {61., 45}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{61., 0.}, {62., 37}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{62., 0.}, {63., 38}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{63., 0.}, {64., 34}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{64., 0.}, {65., 32}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{65., 0.}, {66., 28}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{66., 0.}, {67., 25}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{67., 0.}, {68., 25}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{68., 0.}, {69., 33}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{69., 0.}, {70., 29}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{70., 0.}, {71., 12}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{71., 0.}, {72., 28}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{72., 0.}, {73., 18}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{73., 0.}, {74., 20}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{74., 0.}, {75., 11}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{75., 0.}, {76., 14}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{76., 0.}, {77., 20}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{77., 0.}, {78., 10}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{78., 0.}, {79., 11}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{79., 0.}, {80., 16}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{80., 0.}, {81., 10}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{81., 0.}, {82., 11}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{82., 0.}, {83., 10}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{83., 0.}, {84., 7}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{84., 0.}, {85., 12}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{85., 0.}, {86., 6}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{86., 0.}, {87., 10}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{87., 0.}, {88., 6}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{88., 0.}, {89., 10}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{89., 0.}, {90., 7}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{90., 0.}, {91., 3}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{91., 0.}, {92., 5}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{92., 0.}, {93., 5}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{93., 0.}, {94., 4}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{94., 0.}, {95., 7}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{95., 0.}, {96., 5}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{96., 0.}, {97., 1}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{97., 0.}, {98., 3}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{98., 0.}, {99., 4}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{99., 0.}, {100., 1}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{100., 0.}, {101., 4}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{101., 0.}, {102., 3}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{102., 0.}, {103., 1}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{103., 0.}, {104., 2}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{104., 0.}, {105., 3}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{105., 0.}, {106., 1}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{106., 0.}, {107., 2}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{107., 0.}, {108., 1}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{108., 0.}, {109., 3}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{109., 0.}, {110., 2}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{110., 0.}, {111., 4}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{111., 0.}, {112., 5}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{112., 0.}, {113., 4}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{113., 0.}, {114., 3}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{114., 0.}, {115., 1}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{115., 0.}, {116., 2}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{116., 0.}, {117., 6}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{117., 0.}, {118., 4}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{118., 0.}, {119., 4}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{119., 0.}, {120., 5}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{120., 0.}, {121., 2}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{121., 0.}, {122., 3}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{122., 0.}, {123., 2}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{123., 0.}, {124., 5}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{124., 0.}, {125., 2}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{125., 0.}, {126., 3}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{126., 0.}, {127., 3}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{127., 0.}, {128., 6}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{128., 0.}, {129., 11}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{129., 0.}, {130., 6}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{130., 0.}, {131., 10}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{131., 0.}, {132., 9}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{132., 0.}, {133., 11}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{133., 0.}, {134., 12}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{134., 0.}, {135., 13}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{135., 0.}, {136., 14}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{136., 0.}, {137., 16}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{137., 0.}, {138., 19}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{138., 0.}, {139., 16}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{139., 0.}, {140., 24}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{140., 0.}, {141., 20}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{141., 0.}, {142., 29}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{142., 0.}, {143., 37}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{143., 0.}, {144., 29}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{144., 0.}, {145., 40}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{145., 0.}, {146., 37}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{146., 0.}, {147., 56}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{147., 0.}, {148., 72}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{148., 0.}, {149., 85}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{149., 0.}, {150., 94}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{150., 0.}, {151., 73}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{151., 0.}, {152., 109}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{152., 0.}, {153., 121}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{153., 0.}, {154., 157}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{154., 0.}, {155., 169}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{155., 0.}, {156., 199}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{156., 0.}, {157., 216}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{157., 0.}, {158., 247}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{158., 0.}, {159., 269}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{159., 0.}, {160., 326}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{160., 0.}, {161., 366}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{161., 0.}, {162., 421}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{162., 0.}, {163., 494}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{163., 0.}, {164., 530}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{164., 0.}, {165., 577}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{165., 0.}, {166., 720}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{166., 0.}, {167., 773}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{167., 0.}, {168., 834}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{168., 0.}, {169., 954}, "RoundingRadius" -> 0]}}, {{
             
             RectangleBox[{169., 0.}, {170., 1079}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{170., 0.}, {171., 1243}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{171., 0.}, {172., 1283}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{172., 0.}, {173., 1469}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{173., 0.}, {174., 1547}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{174., 0.}, {175., 1656}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{175., 0.}, {176., 1715}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{176., 0.}, {177., 1914}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{177., 0.}, {178., 2025}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{178., 0.}, {179., 2178}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{179., 0.}, {180., 2274}, "RoundingRadius" -> 
              0]}}}}, {}, {}}}, {{{}, {
          Directive[
           Opacity[0.5], 
           Directive[
            EdgeForm[
             Directive[
              Opacity[0.]]], 
            RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`]], 
           Directive[
            RGBColor[0.368417, 0.506779, 0.709798]]], {{{
             RectangleBox[{-180., 0.}, {-179., 3321}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-179., 0.}, {-178., 3605}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-178., 0.}, {-177., 3510}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-177., 0.}, {-176., 3718}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-176., 0.}, {-175., 3777}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-175., 0.}, {-174., 3784}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-174., 0.}, {-173., 3907}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-173., 0.}, {-172., 4082}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-172., 0.}, {-171., 4191}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-171., 0.}, {-170., 4069}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-170., 0.}, {-169., 4059}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-169., 0.}, {-168., 4127}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-168., 0.}, {-167., 4032}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-167., 0.}, {-166., 4156}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-166., 0.}, {-165., 4013}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-165., 0.}, {-164., 3984}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-164., 0.}, {-163., 3948}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-163., 0.}, {-162., 3802}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-162., 0.}, {-161., 3834}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-161., 0.}, {-160., 3700}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-160., 0.}, {-159., 3673}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-159., 0.}, {-158., 3548}, "RoundingRadius" -> 
              0]}}, {{
             RectangleBox[{-158., 0.}, {-157., 3593}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-157., 0.}, {-156., 3250}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-156., 0.}, {-155., 3209}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-155., 0.}, {-154., 3272}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-154., 0.}, {-153., 3137}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-153., 0.}, {-152., 3065}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-152., 0.}, {-151., 2909}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-151., 0.}, {-150., 2813}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-150., 0.}, {-149., 2762}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-149., 0.}, {-148., 2623}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-148., 0.}, {-147., 2600}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-147., 0.}, {-146., 2584}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-146., 0.}, {-145., 2510}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-145., 0.}, {-144., 2355}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-144., 0.}, {-143., 2336}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-143., 0.}, {-142., 2340}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-142., 0.}, {-141., 2177}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-141., 0.}, {-140., 2129}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-140., 0.}, {-139., 1999}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-139., 0.}, {-138., 1877}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-138., 0.}, {-137., 1968}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-137., 0.}, {-136., 1907}, "RoundingRadius" -> 
              0]}}, {{
             RectangleBox[{-136., 0.}, {-135., 1798}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-135., 0.}, {-134., 1758}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-134., 0.}, {-133., 1811}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-133., 0.}, {-132., 1737}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-132., 0.}, {-131., 1741}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-131., 0.}, {-130., 1671}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-130., 0.}, {-129., 1629}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-129., 0.}, {-128., 1577}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-128., 0.}, {-127., 1620}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-127., 0.}, {-126., 1468}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-126., 0.}, {-125., 1520}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-125., 0.}, {-124., 1504}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-124., 0.}, {-123., 1429}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-123., 0.}, {-122., 1538}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-122., 0.}, {-121., 1525}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-121., 0.}, {-120., 1565}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-120., 0.}, {-119., 1551}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-119., 0.}, {-118., 1543}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-118., 0.}, {-117., 1617}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-117., 0.}, {-116., 1563}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-116., 0.}, {-115., 1571}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-115., 0.}, {-114., 1739}, "RoundingRadius" -> 
              0]}}, {{
             RectangleBox[{-114., 0.}, {-113., 1652}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-113., 0.}, {-112., 1727}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-112., 0.}, {-111., 1776}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-111., 0.}, {-110., 1880}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-110., 0.}, {-109., 1867}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-109., 0.}, {-108., 1853}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-108., 0.}, {-107., 1969}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-107., 0.}, {-106., 2042}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-106., 0.}, {-105., 2070}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-105., 0.}, {-104., 2190}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-104., 0.}, {-103., 2293}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-103., 0.}, {-102., 2398}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-102., 0.}, {-101., 2452}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-101., 0.}, {-100., 2554}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-100., 0.}, {-99., 2718}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-99., 0.}, {-98., 2766}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-98., 0.}, {-97., 2953}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-97., 0.}, {-96., 3118}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-96., 0.}, {-95., 3216}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-95., 0.}, {-94., 3363}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-94., 0.}, {-93., 3563}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-93., 0.}, {-92., 3702}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-92., 0.}, {-91., 4072}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-91., 0.}, {-90., 4079}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-90., 0.}, {-89., 4305}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-89., 0.}, {-88., 4514}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-88., 0.}, {-87., 4914}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-87., 0.}, {-86., 5074}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-86., 0.}, {-85., 5287}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-85., 0.}, {-84., 5539}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-84., 0.}, {-83., 5721}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-83., 0.}, {-82., 5989}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-82., 0.}, {-81., 6399}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-81., 0.}, {-80., 6680}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-80., 0.}, {-79., 6927}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-79., 0.}, {-78., 7399}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-78., 0.}, {-77., 7729}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-77., 0.}, {-76., 7896}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-76., 0.}, {-75., 8108}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-75., 0.}, {-74., 8657}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-74., 0.}, {-73., 8876}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-73., 0.}, {-72., 9155}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-72., 0.}, {-71., 9558}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-71., 0.}, {-70., 9793}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-70., 0.}, {-69., 10260}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-69., 0.}, {-68., 10357}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-68., 0.}, {-67., 10639}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-67., 0.}, {-66., 10819}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-66., 0.}, {-65., 11172}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-65., 0.}, {-64., 11215}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-64., 0.}, {-63., 11329}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-63., 0.}, {-62., 11580}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-62., 0.}, {-61., 11627}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-61., 0.}, {-60., 11566}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-60., 0.}, {-59., 11843}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-59., 0.}, {-58., 11650}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-58., 0.}, {-57., 11790}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-57., 0.}, {-56., 11449}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-56., 0.}, {-55., 11613}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-55., 0.}, {-54., 11374}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-54., 0.}, {-53., 11194}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-53., 0.}, {-52., 10918}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-52., 0.}, {-51., 10518}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-51., 0.}, {-50., 10310}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-50., 0.}, {-49., 9956}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-49., 0.}, {-48., 9816}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-48., 0.}, {-47., 9430}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-47., 0.}, {-46., 8991}, "RoundingRadius" -> 
              0]}}, {{
             RectangleBox[{-46., 0.}, {-45., 8806}, "RoundingRadius" -> 0]}},
            {{
             
             RectangleBox[{-45., 0.}, {-44., 8302}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-44., 0.}, {-43., 7961}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-43., 0.}, {-42., 7403}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-42., 0.}, {-41., 7089}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-41., 0.}, {-40., 6576}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-40., 0.}, {-39., 6192}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-39., 0.}, {-38., 5845}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-38., 0.}, {-37., 5496}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-37., 0.}, {-36., 5132}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-36., 0.}, {-35., 4657}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-35., 0.}, {-34., 4493}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-34., 0.}, {-33., 4147}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-33., 0.}, {-32., 3795}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-32., 0.}, {-31., 3583}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-31., 0.}, {-30., 3268}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-30., 0.}, {-29., 2967}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-29., 0.}, {-28., 2763}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-28., 0.}, {-27., 2562}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-27., 0.}, {-26., 2269}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-26., 0.}, {-25., 2122}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-25., 0.}, {-24., 1908}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-24., 0.}, {-23., 1732}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-23., 0.}, {-22., 1661}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-22., 0.}, {-21., 1523}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-21., 0.}, {-20., 1335}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-20., 0.}, {-19., 1355}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-19., 0.}, {-18., 1202}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-18., 0.}, {-17., 1052}, "RoundingRadius" -> 
              0]}}, {{
             RectangleBox[{-17., 0.}, {-16., 981}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-16., 0.}, {-15., 914}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-15., 0.}, {-14., 878}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-14., 0.}, {-13., 836}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-13., 0.}, {-12., 769}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-12., 0.}, {-11., 695}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-11., 0.}, {-10., 651}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-10., 0.}, {-9., 604}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-9., 0.}, {-8., 593}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-8., 0.}, {-7., 517}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-7., 0.}, {-6., 517}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-6., 0.}, {-5., 467}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-5., 0.}, {-4., 416}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-4., 0.}, {-3., 481}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-3., 0.}, {-2., 401}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-2., 0.}, {-1., 385}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-1., 0.}, {0., 387}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{0., 0.}, {1., 319}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{1., 0.}, {2., 320}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{2., 0.}, {3., 349}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{3., 0.}, {4., 304}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{4., 0.}, {5., 315}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{5., 0.}, {6., 290}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{6., 0.}, {7., 254}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{7., 0.}, {8., 252}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{8., 0.}, {9., 300}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{9., 0.}, {10., 279}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{10., 0.}, {11., 277}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{11., 0.}, {12., 250}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{12., 0.}, {13., 268}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{13., 0.}, {14., 246}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{14., 0.}, {15., 240}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{15., 0.}, {16., 251}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{16., 0.}, {17., 228}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{17., 0.}, {18., 260}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{18., 0.}, {19., 243}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{19., 0.}, {20., 226}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{20., 0.}, {21., 242}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{21., 0.}, {22., 253}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{22., 0.}, {23., 227}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{23., 0.}, {24., 245}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{24., 0.}, {25., 265}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{25., 0.}, {26., 241}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{26., 0.}, {27., 261}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{27., 0.}, {28., 289}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{28., 0.}, {29., 265}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{29., 0.}, {30., 270}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{30., 0.}, {31., 249}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{31., 0.}, {32., 250}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{32., 0.}, {33., 245}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{33., 0.}, {34., 290}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{34., 0.}, {35., 275}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{35., 0.}, {36., 258}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{36., 0.}, {37., 272}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{37., 0.}, {38., 267}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{38., 0.}, {39., 288}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{39., 0.}, {40., 289}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{40., 0.}, {41., 294}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{41., 0.}, {42., 261}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{42., 0.}, {43., 245}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{43., 0.}, {44., 286}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{44., 0.}, {45., 285}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{45., 0.}, {46., 272}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{46., 0.}, {47., 306}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{47., 0.}, {48., 260}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{48., 0.}, {49., 269}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{49., 0.}, {50., 259}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{50., 0.}, {51., 245}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{51., 0.}, {52., 235}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{52., 0.}, {53., 223}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{53., 0.}, {54., 193}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{54., 0.}, {55., 214}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{55., 0.}, {56., 223}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{56., 0.}, {57., 214}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{57., 0.}, {58., 199}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{58., 0.}, {59., 195}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{59., 0.}, {60., 186}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{60., 0.}, {61., 144}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{61., 0.}, {62., 167}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{62., 0.}, {63., 124}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{63., 0.}, {64., 141}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{64., 0.}, {65., 131}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{65., 0.}, {66., 121}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{66., 0.}, {67., 121}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{67., 0.}, {68., 128}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{68., 0.}, {69., 119}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{69., 0.}, {70., 98}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{70., 0.}, {71., 90}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{71., 0.}, {72., 84}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{72., 0.}, {73., 76}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{73., 0.}, {74., 75}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{74., 0.}, {75., 64}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{75., 0.}, {76., 54}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{76., 0.}, {77., 56}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{77., 0.}, {78., 55}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{78., 0.}, {79., 40}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{79., 0.}, {80., 51}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{80., 0.}, {81., 51}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{81., 0.}, {82., 49}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{82., 0.}, {83., 43}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{83., 0.}, {84., 30}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{84., 0.}, {85., 24}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{85., 0.}, {86., 31}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{86., 0.}, {87., 19}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{87., 0.}, {88., 23}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{88., 0.}, {89., 22}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{89., 0.}, {90., 33}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{90., 0.}, {91., 19}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{91., 0.}, {92., 14}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{92., 0.}, {93., 12}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{93., 0.}, {94., 20}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{94., 0.}, {95., 14}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{95., 0.}, {96., 15}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{96., 0.}, {97., 11}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{97., 0.}, {98., 10}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{98., 0.}, {99., 10}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{99., 0.}, {100., 12}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{100., 0.}, {101., 9}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{101., 0.}, {102., 5}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{102., 0.}, {103., 6}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{103., 0.}, {104., 5}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{104., 0.}, {105., 8}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{105., 0.}, {106., 13}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{106., 0.}, {107., 6}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{107., 0.}, {108., 13}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{108., 0.}, {109., 9}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{109., 0.}, {110., 5}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{110., 0.}, {111., 9}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{111., 0.}, {112., 5}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{112., 0.}, {113., 6}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{113., 0.}, {114., 4}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{114., 0.}, {115., 11}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{115., 0.}, {116., 5}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{116., 0.}, {117., 7}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{117., 0.}, {118., 7}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{118., 0.}, {119., 8}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{119., 0.}, {120., 12}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{120., 0.}, {121., 12}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{121., 0.}, {122., 14}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{122., 0.}, {123., 14}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{123., 0.}, {124., 11}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{124., 0.}, {125., 14}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{125., 0.}, {126., 8}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{126., 0.}, {127., 11}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{127., 0.}, {128., 11}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{128., 0.}, {129., 14}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{129., 0.}, {130., 21}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{130., 0.}, {131., 14}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{131., 0.}, {132., 24}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{132., 0.}, {133., 34}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{133., 0.}, {134., 27}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{134., 0.}, {135., 28}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{135., 0.}, {136., 40}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{136., 0.}, {137., 39}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{137., 0.}, {138., 45}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{138., 0.}, {139., 54}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{139., 0.}, {140., 57}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{140., 0.}, {141., 55}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{141., 0.}, {142., 60}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{142., 0.}, {143., 68}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{143., 0.}, {144., 95}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{144., 0.}, {145., 95}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{145., 0.}, {146., 108}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{146., 0.}, {147., 104}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{147., 0.}, {148., 147}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{148., 0.}, {149., 148}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{149., 0.}, {150., 181}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{150., 0.}, {151., 166}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{151., 0.}, {152., 245}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{152., 0.}, {153., 245}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{153., 0.}, {154., 284}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{154., 0.}, {155., 323}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{155., 0.}, {156., 379}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{156., 0.}, {157., 415}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{157., 0.}, {158., 516}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{158., 0.}, {159., 527}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{159., 0.}, {160., 594}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{160., 0.}, {161., 672}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{161., 0.}, {162., 761}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{162., 0.}, {163., 800}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{163., 0.}, {164., 980}, "RoundingRadius" -> 0]}}, {{
             
             RectangleBox[{164., 0.}, {165., 1086}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{165., 0.}, {166., 1171}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{166., 0.}, {167., 1296}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{167., 0.}, {168., 1393}, "RoundingRadius" -> 
              0]}}, {{
             RectangleBox[{168., 0.}, {169., 1626}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{169., 0.}, {170., 1727}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{170., 0.}, {171., 1830}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{171., 0.}, {172., 2043}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{172., 0.}, {173., 2134}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{173., 0.}, {174., 2328}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{174., 0.}, {175., 2477}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{175., 0.}, {176., 2641}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{176., 0.}, {177., 2794}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{177., 0.}, {178., 2857}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{178., 0.}, {179., 3027}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{179., 0.}, {180., 3351}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{180., 0.}, {181., 2}, "RoundingRadius" -> 
              0]}}}}, {}, {}}}, {{{}, {
          Directive[
           Opacity[0.5], 
           Directive[
            EdgeForm[
             Directive[
              Opacity[0.]]], 
            RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`]], 
           Directive[
            RGBColor[0.560181, 0.691569, 0.194885]]], {{{
             
             RectangleBox[{-180., 0.}, {-179., 1049}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-179., 0.}, {-178., 1001}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-178., 0.}, {-177., 996}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-177., 0.}, {-176., 951}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-176., 0.}, {-175., 920}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-175., 0.}, {-174., 837}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-174., 0.}, {-173., 775}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-173., 0.}, {-172., 728}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-172., 0.}, {-171., 715}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-171., 0.}, {-170., 685}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-170., 0.}, {-169., 608}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-169., 0.}, {-168., 592}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-168., 0.}, {-167., 513}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-167., 0.}, {-166., 449}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-166., 0.}, {-165., 377}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-165., 0.}, {-164., 403}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-164., 0.}, {-163., 376}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-163., 0.}, {-162., 305}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-162., 0.}, {-161., 333}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-161., 0.}, {-160., 266}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-160., 0.}, {-159., 248}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-159., 0.}, {-158., 206}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-158., 0.}, {-157., 244}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-157., 0.}, {-156., 212}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-156., 0.}, {-155., 224}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-155., 0.}, {-154., 163}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-154., 0.}, {-153., 168}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-153., 0.}, {-152., 164}, "RoundingRadius" -> 
              0]}}, {{
             RectangleBox[{-152., 0.}, {-151., 119}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-151., 0.}, {-150., 124}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-150., 0.}, {-149., 104}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-149., 0.}, {-148., 103}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-148., 0.}, {-147., 104}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-147., 0.}, {-146., 88}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-146., 0.}, {-145., 101}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-145., 0.}, {-144., 86}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-144., 0.}, {-143., 63}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-143., 0.}, {-142., 83}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-142., 0.}, {-141., 66}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-141., 0.}, {-140., 67}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-140., 0.}, {-139., 64}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-139., 0.}, {-138., 52}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-138., 0.}, {-137., 54}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-137., 0.}, {-136., 57}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-136., 0.}, {-135., 43}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-135., 0.}, {-134., 39}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-134., 0.}, {-133., 45}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-133., 0.}, {-132., 38}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-132., 0.}, {-131., 26}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-131., 0.}, {-130., 45}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-130., 0.}, {-129., 38}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-129., 0.}, {-128., 43}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-128., 0.}, {-127., 40}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-127., 0.}, {-126., 26}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-126., 0.}, {-125., 36}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-125., 0.}, {-124., 35}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-124., 0.}, {-123., 24}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-123., 0.}, {-122., 36}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-122., 0.}, {-121., 20}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-121., 0.}, {-120., 32}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-120., 0.}, {-119., 30}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-119., 0.}, {-118., 37}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-118., 0.}, {-117., 34}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-117., 0.}, {-116., 36}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-116., 0.}, {-115., 31}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-115., 0.}, {-114., 34}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-114., 0.}, {-113., 30}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-113., 0.}, {-112., 33}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-112., 0.}, {-111., 39}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-111., 0.}, {-110., 40}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-110., 0.}, {-109., 35}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-109., 0.}, {-108., 28}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-108., 0.}, {-107., 49}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-107., 0.}, {-106., 22}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-106., 0.}, {-105., 53}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-105., 0.}, {-104., 32}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-104., 0.}, {-103., 42}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-103., 0.}, {-102., 51}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-102., 0.}, {-101., 42}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-101., 0.}, {-100., 38}, "RoundingRadius" -> 
              0]}}, {{
             RectangleBox[{-100., 0.}, {-99., 68}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-99., 0.}, {-98., 55}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-98., 0.}, {-97., 59}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-97., 0.}, {-96., 45}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-96., 0.}, {-95., 70}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-95., 0.}, {-94., 66}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-94., 0.}, {-93., 52}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-93., 0.}, {-92., 68}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-92., 0.}, {-91., 59}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-91., 0.}, {-90., 78}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-90., 0.}, {-89., 91}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-89., 0.}, {-88., 96}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-88., 0.}, {-87., 98}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-87., 0.}, {-86., 103}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-86., 0.}, {-85., 107}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-85., 0.}, {-84., 115}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-84., 0.}, {-83., 123}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-83., 0.}, {-82., 162}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-82., 0.}, {-81., 129}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-81., 0.}, {-80., 145}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-80., 0.}, {-79., 162}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-79., 0.}, {-78., 187}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-78., 0.}, {-77., 182}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-77., 0.}, {-76., 172}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-76., 0.}, {-75., 226}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-75., 0.}, {-74., 241}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-74., 0.}, {-73., 251}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-73., 0.}, {-72., 265}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-72., 0.}, {-71., 288}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-71., 0.}, {-70., 308}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-70., 0.}, {-69., 326}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-69., 0.}, {-68., 389}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-68., 0.}, {-67., 397}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-67., 0.}, {-66., 453}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-66., 0.}, {-65., 480}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-65., 0.}, {-64., 476}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-64., 0.}, {-63., 519}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-63., 0.}, {-62., 590}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-62., 0.}, {-61., 565}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-61., 0.}, {-60., 654}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-60., 0.}, {-59., 698}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-59., 0.}, {-58., 751}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-58., 0.}, {-57., 733}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-57., 0.}, {-56., 916}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-56., 0.}, {-55., 887}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-55., 0.}, {-54., 919}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-54., 0.}, {-53., 998}, "RoundingRadius" -> 0]}}, {{
             
             RectangleBox[{-53., 0.}, {-52., 1010}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-52., 0.}, {-51., 1115}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-51., 0.}, {-50., 1138}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-50., 0.}, {-49., 1266}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-49., 0.}, {-48., 1318}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-48., 0.}, {-47., 1424}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-47., 0.}, {-46., 1365}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-46., 0.}, {-45., 1399}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-45., 0.}, {-44., 1456}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-44., 0.}, {-43., 1548}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-43., 0.}, {-42., 1601}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-42., 0.}, {-41., 1706}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-41., 0.}, {-40., 1702}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-40., 0.}, {-39., 1689}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-39., 0.}, {-38., 1737}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-38., 0.}, {-37., 1770}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-37., 0.}, {-36., 1805}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-36., 0.}, {-35., 1880}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-35., 0.}, {-34., 1941}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-34., 0.}, {-33., 1814}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-33., 0.}, {-32., 1951}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-32., 0.}, {-31., 1877}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-31., 0.}, {-30., 1901}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-30., 0.}, {-29., 1980}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-29., 0.}, {-28., 1889}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-28., 0.}, {-27., 1953}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-27., 0.}, {-26., 1943}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-26., 0.}, {-25., 1991}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-25., 0.}, {-24., 1962}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-24., 0.}, {-23., 1868}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-23., 0.}, {-22., 1920}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-22., 0.}, {-21., 1881}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-21., 0.}, {-20., 1903}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-20., 0.}, {-19., 1925}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-19., 0.}, {-18., 1914}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-18., 0.}, {-17., 1889}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-17., 0.}, {-16., 1957}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-16., 0.}, {-15., 1861}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-15., 0.}, {-14., 1968}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-14., 0.}, {-13., 1845}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-13., 0.}, {-12., 2009}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-12., 0.}, {-11., 1935}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{-11., 0.}, {-10., 1895}, "RoundingRadius" -> 
              0]}}, {{
             RectangleBox[{-10., 0.}, {-9., 1901}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-9., 0.}, {-8., 1968}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-8., 0.}, {-7., 1871}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-7., 0.}, {-6., 2007}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-6., 0.}, {-5., 2018}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-5., 0.}, {-4., 2004}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-4., 0.}, {-3., 1975}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-3., 0.}, {-2., 2177}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-2., 0.}, {-1., 2081}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{-1., 0.}, {0., 2188}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{0., 0.}, {1., 2268}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{1., 0.}, {2., 2324}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{2., 0.}, {3., 2251}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{3., 0.}, {4., 2386}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{4., 0.}, {5., 2490}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{5., 0.}, {6., 2561}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{6., 0.}, {7., 2673}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{7., 0.}, {8., 2729}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{8., 0.}, {9., 2840}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{9., 0.}, {10., 2985}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{10., 0.}, {11., 2991}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{11., 0.}, {12., 3332}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{12., 0.}, {13., 3257}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{13., 0.}, {14., 3559}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{14., 0.}, {15., 3626}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{15., 0.}, {16., 3846}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{16., 0.}, {17., 4004}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{17., 0.}, {18., 4194}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{18., 0.}, {19., 4452}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{19., 0.}, {20., 4673}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{20., 0.}, {21., 5037}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{21., 0.}, {22., 5297}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{22., 0.}, {23., 5567}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{23., 0.}, {24., 5779}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{24., 0.}, {25., 5972}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{25., 0.}, {26., 6323}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{26., 0.}, {27., 6838}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{27., 0.}, {28., 7247}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{28., 0.}, {29., 7566}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{29., 0.}, {30., 7841}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{30., 0.}, {31., 8398}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{31., 0.}, {32., 8761}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{32., 0.}, {33., 9260}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{33., 0.}, {34., 9563}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{34., 0.}, {35., 10114}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{35., 0.}, {36., 10273}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{36., 0.}, {37., 11024}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{37., 0.}, {38., 11193}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{38., 0.}, {39., 11881}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{39., 0.}, {40., 12184}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{40., 0.}, {41., 12400}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{41., 0.}, {42., 12926}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{42., 0.}, {43., 13189}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{43., 0.}, {44., 13327}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{44., 0.}, {45., 13649}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{45., 0.}, {46., 13586}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{46., 0.}, {47., 13938}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{47., 0.}, {48., 13818}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{48., 0.}, {49., 13993}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{49., 0.}, {50., 13966}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{50., 0.}, {51., 13881}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{51., 0.}, {52., 13727}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{52., 0.}, {53., 13713}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{53., 0.}, {54., 13573}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{54., 0.}, {55., 13317}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{55., 0.}, {56., 13116}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{56., 0.}, {57., 12643}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{57., 0.}, {58., 12253}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{58., 0.}, {59., 11907}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{59., 0.}, {60., 11450}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{60., 0.}, {61., 11058}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{61., 0.}, {62., 10528}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{62., 0.}, {63., 10034}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{63., 0.}, {64., 9486}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{64., 0.}, {65., 9159}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{65., 0.}, {66., 8632}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{66., 0.}, {67., 8082}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{67., 0.}, {68., 7587}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{68., 0.}, {69., 7144}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{69., 0.}, {70., 6619}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{70., 0.}, {71., 6230}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{71., 0.}, {72., 5807}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{72., 0.}, {73., 5424}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{73., 0.}, {74., 5060}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{74., 0.}, {75., 4637}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{75., 0.}, {76., 4171}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{76., 0.}, {77., 3911}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{77., 0.}, {78., 3551}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{78., 0.}, {79., 3264}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{79., 0.}, {80., 3041}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{80., 0.}, {81., 2793}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{81., 0.}, {82., 2489}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{82., 0.}, {83., 2395}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{83., 0.}, {84., 2090}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{84., 0.}, {85., 1961}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{85., 0.}, {86., 1749}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{86., 0.}, {87., 1659}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{87., 0.}, {88., 1537}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{88., 0.}, {89., 1354}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{89., 0.}, {90., 1271}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{90., 0.}, {91., 1116}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{91., 0.}, {92., 1027}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{92., 0.}, {93., 935}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{93., 0.}, {94., 871}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{94., 0.}, {95., 820}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{95., 0.}, {96., 792}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{96., 0.}, {97., 664}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{97., 0.}, {98., 613}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{98., 0.}, {99., 537}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{99., 0.}, {100., 524}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{100., 0.}, {101., 517}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{101., 0.}, {102., 462}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{102., 0.}, {103., 419}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{103., 0.}, {104., 426}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{104., 0.}, {105., 381}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{105., 0.}, {106., 406}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{106., 0.}, {107., 366}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{107., 0.}, {108., 339}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{108., 0.}, {109., 306}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{109., 0.}, {110., 309}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{110., 0.}, {111., 272}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{111., 0.}, {112., 262}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{112., 0.}, {113., 306}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{113., 0.}, {114., 228}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{114., 0.}, {115., 256}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{115., 0.}, {116., 236}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{116., 0.}, {117., 243}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{117., 0.}, {118., 236}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{118., 0.}, {119., 239}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{119., 0.}, {120., 229}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{120., 0.}, {121., 246}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{121., 0.}, {122., 248}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{122., 0.}, {123., 255}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{123., 0.}, {124., 244}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{124., 0.}, {125., 246}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{125., 0.}, {126., 245}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{126., 0.}, {127., 237}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{127., 0.}, {128., 255}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{128., 0.}, {129., 244}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{129., 0.}, {130., 290}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{130., 0.}, {131., 245}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{131., 0.}, {132., 255}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{132., 0.}, {133., 258}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{133., 0.}, {134., 278}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{134., 0.}, {135., 246}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{135., 0.}, {136., 272}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{136., 0.}, {137., 312}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{137., 0.}, {138., 302}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{138., 0.}, {139., 329}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{139., 0.}, {140., 319}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{140., 0.}, {141., 359}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{141., 0.}, {142., 357}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{142., 0.}, {143., 389}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{143., 0.}, {144., 419}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{144., 0.}, {145., 433}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{145., 0.}, {146., 457}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{146., 0.}, {147., 461}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{147., 0.}, {148., 488}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{148., 0.}, {149., 489}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{149., 0.}, {150., 519}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{150., 0.}, {151., 562}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{151., 0.}, {152., 671}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{152., 0.}, {153., 661}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{153., 0.}, {154., 646}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{154., 0.}, {155., 723}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{155., 0.}, {156., 742}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{156., 0.}, {157., 734}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{157., 0.}, {158., 853}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{158., 0.}, {159., 936}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{159., 0.}, {160., 898}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{160., 0.}, {161., 975}, "RoundingRadius" -> 0]}}, {{
             RectangleBox[{161., 0.}, {162., 966}, "RoundingRadius" -> 0]}}, {{
             
             RectangleBox[{162., 0.}, {163., 1024}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{163., 0.}, {164., 1004}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{164., 0.}, {165., 1081}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{165., 0.}, {166., 1116}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{166., 0.}, {167., 1153}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{167., 0.}, {168., 1143}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{168., 0.}, {169., 1160}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{169., 0.}, {170., 1199}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{170., 0.}, {171., 1226}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{171., 0.}, {172., 1308}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{172., 0.}, {173., 1331}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{173., 0.}, {174., 1197}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{174., 0.}, {175., 1196}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{175., 0.}, {176., 1227}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{176., 0.}, {177., 1193}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{177., 0.}, {178., 1165}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{178., 0.}, {179., 1077}, "RoundingRadius" -> 
              0]}}, {{
             
             RectangleBox[{179., 0.}, {180., 1087}, "RoundingRadius" -> 
              0]}}}}, {}, {}}}}}, {{{{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {}}}, {{{{}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {}}}, {{{{}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {}}}}}, {
    AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
     Axes -> {True, True}, AxesLabel -> {None, None}, 
     AxesOrigin -> {-187.22, 0.}, FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], PlotRange -> {{-180., 181.}, {All, All}}, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}],FormBox[
    FormBox[
     TemplateBox[{
      "\"0 V\[CenterDot]nm\:207b\.b9\"", "\"1 V\[CenterDot]nm\:207b\.b9\"", 
       "\"5 V\[CenterDot]nm\:207b\.b9\""}, "SwatchLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    Opacity[0.5], 
                    EdgeForm[
                    Directive[
                    Opacity[0.]]], 
                    RGBColor[0.97858, 0.678934, 0.157834]], 
                    RectangleBox[{0, 0}, {10, 10}, "RoundingRadius" -> 0]}, 
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    Opacity[0.5], 
                    EdgeForm[
                    Directive[
                    Opacity[0.]]], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    RectangleBox[{0, 0}, {10, 10}, "RoundingRadius" -> 0]}, 
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    Opacity[0.5], 
                    EdgeForm[
                    Directive[
                    Opacity[0.]]], 
                    RGBColor[0.560181, 0.691569, 0.194885]], 
                    RectangleBox[{0, 0}, {10, 10}, "RoundingRadius" -> 0]}, 
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"SwatchLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.97858, 0.678934, 0.157834], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.6523866666666667, 0.45262266666666673`, 
                    0.10522266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.97858, 0.678934, 0.157834]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.97858, 0.678934, 0.157834]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.97858, 0.678934, 0.157834], Editable -> False, 
                    Selectable -> False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.560181, 0.691569, 0.194885]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False]}], "]"}]}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[1], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"Opacity", "[", "0.`", "]"}], "]"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[1]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
           