(* ::Package:: *)

BeginPackage["NMER`"];


UseNumericalValues::usage = "UseNumericalValues[\!\(\*
StyleBox[\"expr\",\nFontSlant->\"Italic\"]\),\!\(\*
StyleBox[\"n\",\nFontSlant->\"Italic\"]\)]
Substitutes constants of the \!\(\*SuperscriptBox[
StyleBox[\"n\",\nFontSlant->\"Italic\"], \(th\)]\) spin system in the expression \!\(\*
StyleBox[\"expr\",\nFontSlant->\"Italic\"]\)";


Begin["Global`"]


Antisymmetry=Function[{property,frequency},
Which[
  property=="jcoupling",
     expr=((Subscript[\[ScriptC], 1]+Subscript[\[ScriptC], 2])Exp[I \[Phi]]/2+(Subscript[\[ScriptC], 1]-Subscript[\[ScriptC], 2])Exp[-I \[Phi]]/2+Subscript[\[ScriptC], 3])/.\[Phi]->\[Pi] (Subscript[\[ScriptC], 4] ArcTan[Subscript[\[ScriptC], 5] frequency]+180)/180,
  property=="shielding",
     expr=((Subscript[\[ScriptC], 1]+Subscript[\[ScriptC], 2])Exp[I \[Phi]]/2+(Subscript[\[ScriptC], 1]-Subscript[\[ScriptC], 2])Exp[-I \[Phi]]/2+Subscript[\[ScriptC], 3])/.\[Phi]->\[Pi] (Subscript[\[ScriptC], 4] ArcTan[Subscript[\[ScriptC], 5] frequency]+0)/180
];
{\[ScriptCapitalA]->AbsArg[expr][[1]],\[Phi]->AbsArg[expr][[2]]}
];


End[]


EndPackage[];
