(* ::Package:: *)

BeginPackage["NMER`"];


DataConverter::usage = "DataConverter[\!\(\*
StyleBox[\"file\",\nFontSlant->\"Italic\"]\),\!\(\*
StyleBox[\"operaton\",\nFontSlant->\"Italic\"]\)]
Converts a \!\(\*
StyleBox[\"file\",\nFontSlant->\"Italic\"]\) into a text file applying an \!\(\*
StyleBox[\"operaton\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\".\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",\nFontSlant->\"Italic\"]\)Recognises Dalton (.out) and Gromacs (.gro) files. Operations: XYZ - [atom] [x-coordiante] [y-coordiante] [z-coordiante]";


DataConverter[File_,Time_:0,MoleculeNumber_:1,Operation_]:=
Which[
  StringTake[File,-3]=="gro",
    Which[
       Operation=="XYZ",
           GromacsToXYZ[File,MoleculeNumber,Time,12],
       Operation=="DATA",
         <<Gromacs2RawData.wl;
         <<FindLocalFrameAndDihedralAngle.wl;
           Gromacs2RawData[File,12]] 
]


EndPackage[];
