(* ::Package:: *)

Clear[ExtractDihedralAngles]
Options[ExtractDihedralAngles] = {
  "Mode" -> "Histogram",   (* or "MeanTrajectory" *)
  "Steps" -> 828,
  "Stride" -> 0.1,
  "TotalSteps" -> 100
};

ExtractDihedralAngles[dataSet_, opts : OptionsPattern[]] := Module[
  {
    file, str, mode, steps, stride, total, readBlock, data
  },

  mode = OptionValue["Mode"];
  steps = OptionValue["Steps"];
  stride = OptionValue["Stride"];
  total = OptionValue["TotalSteps"];
  file = "Data//"<> ToString[dataSet] <> ".gro_lf.dat";
  str = OpenRead[file];

  readBlock[] := Read[str, Table[Number, {10}]][[-1]];

  data = Switch[mode,

    "Histogram",
    Sort@Table[readBlock[], {i, 1, total * steps / stride}],

    "MeanTrajectory",
    Table[
      Module[{chunk},
        chunk = Sort@Table[readBlock[], {i, 1, steps}];
        {stride * j, Mean[chunk]}
      ],
      {j, total}
    ],

    _, 
    (Close[str]; Return[$Failed, Module])
  ];

  Close[str];
  data
];
