(* ::Package:: *)

FindAmplitudePeriodPhase = 
  Function[{data, n0},
    Module[{subdata, n, spectrum, dominantFreqPos, rephasedData, rephasedSpectrum, rephasedPos, amplitude, period, phase},
      If[n0 >= Length[data],
        Return[$Failed]
      ];
      subdata = Take[data, {n0 + 1, Length[data]}];
      n = Length[subdata];
      spectrum = Abs[Fourier[subdata]];
      dominantFreqPos = First@First@Position[spectrum, Max[spectrum]];
      
      rephasedData = subdata * Exp[2 Pi I (dominantFreqPos - 2) N[Range[0, n - 1]] / n];
      rephasedSpectrum = Fourier[rephasedData, FourierParameters -> {0, 2/n}];
      rephasedPos = First@First@Position[Abs[rephasedSpectrum], Max[Abs[rephasedSpectrum]]];
      
      amplitude = Abs[rephasedSpectrum[[rephasedPos]]];
      period = N[n / (dominantFreqPos - 2 + 2 (rephasedPos - 1)/n)];
      phase = 180 ArcTan[Re[rephasedSpectrum[[rephasedPos]]], Im[rephasedSpectrum[[rephasedPos]]]] / Pi;
      
      {amplitude, period, phase}
    ]
  ];
