(* ::Package:: *)

FindLocalFrameAndDihedralAngle::usage = "Computes (i) rotation matrix of a local frame formed by the first three points, (ii) dihedral angle cooresponding to the four points, and (iii) Cartesian cooridnates of the origin of the local frame based on Cartesian coordinates of four points (atoms)."


FindLocalFrameAndDihedralAngle=Function[atoms,
\[ScriptCapitalH]6= atoms[[1]];     (* CH proton *)
\[ScriptCapitalC]3  = atoms[[2]];    (* CH carbon *)
\[ScriptCapitalO]2 = atoms[[3]];     (* CH(OH) oxygen *)
\[ScriptCapitalH]1= atoms[[4]];    (* CH(OH) proton *) 

\[ScriptX]=Normalize[\[ScriptCapitalO]2-\[ScriptCapitalC]3];
\[ScriptY]=Normalize[Normalize[\[ScriptCapitalH]6-\[ScriptCapitalC]3]-(Normalize[\[ScriptCapitalH]6-\[ScriptCapitalC]3].Normalize[\[ScriptCapitalO]2-\[ScriptCapitalC]3])Normalize[\[ScriptCapitalO]2-\[ScriptCapitalC]3]];
\[ScriptZ]=Normalize[Cross[\[ScriptX],\[ScriptY]]];

(* vectors of the axes of the frame are columns of the rotation matrix *)

\[ScriptCapitalR]=Transpose[{\[ScriptX],\[ScriptY],\[ScriptZ]}];  

u1=\[ScriptCapitalC]3 -\[ScriptCapitalH]6;
u2=\[ScriptCapitalO]2 -\[ScriptCapitalC]3 ;
u3=\[ScriptCapitalH]1-\[ScriptCapitalO]2 ;

(* the formula below gives the same dihedral angles as, e.g., Marcury 4.1.0 *)

\[Theta]=(180/\[Pi])ArcTan[Norm[u2] Cross[u1,u2].Cross[u2,u3],u2.Cross[Cross[u1,u2],Cross[u2,u3]]];

{\[ScriptCapitalR],\[Theta]}];
