(* ::Package:: *)

Clear[FindMolecularFrame]
FindMolecularFrame::usage =
"FindMolecularFrame[xyzFile] reads the first 12 atoms from an XYZ file and returns:
  {rMatrix, angle, alphaCarbonCoords, labeledCoords}, where:
  - rMatrix is the 3\[Times]3 rotation matrix defining the local molecular frame,
  - angle is the computed dihedral angle (in degrees or radians, depending on the source),
  - alphaCarbonCoords is the 3D coordinate vector of the second atom,
  - labeledCoords is the full list of atoms with labels and coordinates.";


FindMolecularFrame[xyzFile_String] := Module[{str, atoms, rMatrix, angle},
  str = OpenRead[xyzFile];
  atoms = Table[
    Read[str, {Word, Number, Number, Number}],
    {12}
  ];
  Close[str];

  {rMatrix, angle} = FindLocalFrameAndDihedralAngle[Take[atoms[[All, 2 ;; 4]], 4]];

  {rMatrix, angle, atoms[[2, 2 ;; 4]], atoms}
];
