(* ::Package:: *)

BeginPackage["NMER`"];


Gromacs2RawData::usage = "Computes local reference frame and permenent electric dipole moment from the Gromacs file (file name is provided without .gro extension)"


Begin["Private`"]


Gromacs2RawData=Function[{filename,atomsnumber},
DeleteFile[StringJoin[filename,"_lf.dat"]];
str=OpenRead[filename];
(*{MoleculesNumber,FieldStrength,Frequency,TotalTime,Step}=Read[str,{Number,Number,Number,Number,Number}];
Skip[str,Word];*)
{MoleculesNumber,FieldStrength,Frequency,TotalTime,Step}={828,1.0,0.0,50000,1};
Do[
LocalFrames={};
Skip[str,Word,2];
Time=Read[str,Number];
Skip[str,Word,3];
Do[
AtomsPositions=Transpose[
                 Take[
                   Transpose[
                      Read[str,Table[{Word,Word,Number,Number,Number,Number},{i,1,atomsnumber}]]],{4,6}]];           
LocalFrames=Append[LocalFrames,
   Flatten[
    FindLocalFrameAndDihedralAngle[{
           AtomsPositions[[3]],
           AtomsPositions[[2]],
           AtomsPositions[[4]],
           AtomsPositions[[12]]}]]],{j,1,828}];
Skip[str,Word,3];
str2=OpenAppend[StringJoin[filename,"_lf.dat"]];
Export[str2, LocalFrames];
WriteString[str2, "\n"];
Close[str2],    
{k,1,TotalTime/Step}];
Close[str]]


End[]


EndPackage[];
