(* ::Package:: *)

BeginPackage["NMER`"];


LeaveOutFastOscillatingTerms::usage = "LeaveOutFastOscillatingTerms[\!\(\*
StyleBox[\"expr\",\nFontSlant->\"Italic\"]\)],
Leaves out terms exp(constant \[Times] \[ScriptT]) in the expression \!\(\*
StyleBox[\"expr\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"\\\"\",\nFontSlant->\"Italic\"]\).";


Begin["Global`"]


RealInteractionParameters={
Subscript[\[Omega], 1],Subscript[\[Omega], 2],Subscript[\[Tau], 2],
\[ScriptCapitalJ],Subscript[\[ScriptB], FF],Subscript[\[ScriptB], FH],Subscript[\[ScriptB], HH],\[ScriptCapitalA],\[HBar] ,1/(kB T),kB,T,1/kB,1/T,cos\[Phi],sin\[Phi]};
RealParameters/:n_\[Element]RealParameters:=With[{q=(Count[RealInteractionParameters,n]>0)},q/;q==True||q==False]
LeaveOutFastOscillatingTerms[A_+B_]:=LeaveOutFastOscillatingTerms[A]+LeaveOutFastOscillatingTerms[B];
LeaveOutFastOscillatingTerms[A_ B_]:=LeaveOutFastOscillatingTerms[A]LeaveOutFastOscillatingTerms[B];
LeaveOutFastOscillatingTerms[A_]:=A/;A\[Element]RealParameters\[Or]A\[Element]Complexes
LeaveOutFastOscillatingTerms[A_ Exp[\[ScriptT]*B_]]:=A LeaveOutFastOscillatingTerms[Exp[\[ScriptT]*B]]
LeaveOutFastOscillatingTerms[Exp[B_]]:=0;
LeaveOutFastOscillatingTerms[0]:=0;
LeaveOutFastOscillatingTerms[Subscript[\[ScriptB], FF]^2]:=Subscript[\[ScriptB], FF]^2;
LeaveOutFastOscillatingTerms[Subscript[\[ScriptB], FH]^2]:=Subscript[\[ScriptB], FH]^2;
LeaveOutFastOscillatingTerms[Subscript[\[ScriptB], HH]^2]:=Subscript[\[ScriptB], HH]^2;


End[]


EndPackage[];
