(* ::Package:: *)

BeginPackage["NMER`"];


LindbladIntegrate::usage = "LindbladIntegrate[\!\(\*
StyleBox[\"expr\",\nFontSlant->\"Italic\"]\)]
symbolically simplifies the expression \!\(\*
StyleBox[\"expr\",\nFontSlant->\"Italic\"]\) according to the Lindblad theory";


Begin["Global`"]


RealInteractionParameters={\[ScriptCapitalA],sin\[Phi],cos\[Phi],Subscript[\[Omega], 1],Subscript[\[Omega], 2],Subscript[\[ScriptB], FF],Subscript[\[ScriptB], FH],Subscript[\[ScriptB], HH],\[HBar],kB,T,1/kB,1/T};
RealParameters/:n_\[Element]RealParameters:=With[{q=(Count[RealInteractionParameters,n]>0)},q/;q==True||q==False]
Adjoint[A_]:=A/;A\[Element]RealParameters
Adjoint[\[GothicCapitalD][l_,a_,b_,\[Tau]_]]:=Conjugate[\[GothicCapitalD][l,a,b,\[Tau]]]
Off[General::spell1,ClebschGordan::phy];
ClearAttributes[Conjugate,Protected];
\[GothicCapitalD]/:\[GothicCapitalD][l_,a_,b_,0]Conjugate[\[GothicCapitalD][k_,c_,d_,Subscript[\[Tau], c]]]:=1/(2l+1) KroneckerDelta[l,k]KroneckerDelta[a,c]KroneckerDelta[b,d]Subscript[G, l][\[Tau]];
Adjoint[A_]:=A/;A\[Element]RealParameters
Adjoint[\[GothicCapitalD][l_,a_,b_,\[Tau]_]]:=Conjugate[\[GothicCapitalD][l,a,b,\[Tau]]]
Conjugate[A_]:=A/;A\[Element]RealParameters
Conjugate[A_ B__]:=Conjugate[A]Conjugate[Times[B]];
Conjugate[A_+B__]:=Conjugate[A]+Conjugate[Plus[B]];
LindbladIntegrate[A_+B_]:=LindbladIntegrate[A]+LindbladIntegrate[B];
LindbladIntegrate[A_ B_]:=A LindbladIntegrate[B]/;A\[Element]Complexes\[Or]A\[Element]RealParameters
LindbladIntegrate[Power[A_,k_] B_]:=Power[A,k] LindbladIntegrate[B]/;k\[Element]Integers&&(A\[Element]Complexes\[Or]A\[Element]RealParameters)
(*LindbladIntegrate[E^(A_) Subscript[G, l_][\[Tau]]]:=Subscript[J, l][(A/(I Subscript[\[Tau], c]))//Simplify]Exp[-\[HBar] A/(2 kB T I Subscript[\[Tau], c])//Simplify];*)
LindbladIntegrate[E^(A_) Subscript[G, l_][\[Tau]]]:=Subscript[\[Tau], l](1-\[HBar] A/(2 kB T I Subscript[\[Tau], c])//Simplify);
(*LindbladIntegrate[Subscript[G, l_][\[Tau]]]:=Subscript[J, l][0];*)
LindbladIntegrate[Subscript[G, l_][\[Tau]]]:=Subscript[\[Tau], l];
LindbladIntegrate[0]:=0;


End[]


EndPackage[];
