(* ::Package:: *)

BeginPackage["NMER`"];


Lindbladian::usage = "SchrodingerToInteractionPicture[\!\(\*SubscriptBox[
StyleBox[\"L\",\nFontSlant->\"Italic\"], \(1\)]\),\!\(\*SubscriptBox[
StyleBox[\"L\",\nFontSlant->\"Italic\"], \(2\)]\)]
transforms the Liouvillian \!\(\*SubscriptBox[
StyleBox[\"L\",\nFontSlant->\"Italic\"], \(1\)]\) in the Schr\[ODoubleDot]dinger picture to the interaction picture given by the Liouvillian \!\(\*SubscriptBox[
StyleBox[\"L\",\nFontSlant->\"Italic\"], \(2\)]\)";


Begin["Global`"]


Lindbladian=Function[{U1,U2,n},
U1m=MatrixRepresentation[U1];
U2m=MatrixRepresentation[U2];
Bm=Table[MatrixRepresentation[BasisOperators[][[i]]],{i,1,(2^n)^2}];
L=Transpose[
        Table[
            OperatorVectorRepresentation[
               Operator[-U2m.U1m.(Bm[[i]])+2 U1m.(Bm[[i]]).U2m-(Bm[[i]]).U2m.U1m]],{i,1,(2^n)^2}]];
Table[LindbladIntegrate[L[[i,j]]//ExpandAll],{i,1,(2^n)^2},{j,1,(2^n)^2}]
];


End[]


EndPackage[];
