(* ::Package:: *)

Clear[PlotInterpolatedCouplings]
PlotInterpolatedCouplings::usage =
"PlotInterpolatedCouplings[couplingFunc, center, {\[Theta]min, \[Theta]max}, step, highlightAngle] \
visualizes antisymmetric coupling vectors rotated into the molecular frame and centered \
at a point in 3D. The vector at highlightAngle (in degrees) is emphasized.";


PlotInterpolatedCouplings[
  couplingFunc_, 
  center_, 
  {thetaMinDeg_, thetaMaxDeg_}, 
  stepDeg_: 10, 
  highlightAngleDeg_: -60
] := Module[
  {anglesDeg, anglesRad, vectors, arrows, highlightIndex, labelStyle},

  anglesDeg = Range[thetaMinDeg, thetaMaxDeg, stepDeg];
  anglesRad = anglesDeg Degree;

  vectors = couplingFunc /@ anglesRad;

  highlightIndex = FirstPosition[anglesDeg, highlightAngleDeg, {None}][[1]];
  labelStyle = Style[#, 16, Black] &;

  arrows = Table[
    {
      If[i === highlightIndex, Opacity[1.0], Opacity[0.1]],
      Darker[Orange],
      Arrow[
        Tube[{100 center, 100 center + 100 vectors[[i]]}]
      ],
      If[i === highlightIndex, Opacity[1.0], Opacity[0]],
      Text[
        labelStyle[ToString[anglesDeg[[i]]] <> "\[Degree]"], 
        100 center + 110 vectors[[i]]
      ]
    },
    {i, Length[anglesDeg]}
  ];

  Graphics3D[arrows, Axes -> False, Boxed -> False]
];
