(* ::Package:: *)

Clear[PlotInterpolatedDipoles]
PlotInterpolatedDipoles::usage =
"PlotInterpolatedDipoles[dipoleFunc, {\[Theta]min, \[Theta]max}, step, highlightAngle] visualizes \
dipole vectors from dipoleFunc[\[Theta]] over a range of angles in degrees. \
The vector corresponding to highlightAngle (in degrees) is emphasized.";

PlotInterpolatedDipoles[
  dipoleFunc_, 
  {thetaMinDeg_, thetaMaxDeg_}, 
  stepDeg_: 10, 
  highlightAngleDeg_: -60
] := Module[
  {anglesDeg, anglesRad, dipoles, arrows, labelStyle, highlightIndex},

  anglesDeg = Range[thetaMinDeg, thetaMaxDeg, stepDeg];
  anglesRad = anglesDeg Degree;

  dipoles = dipoleFunc /@ anglesRad;

  labelStyle = Style[#, 16, Black] &;

  (* Find which angle matches the highlight *)
  highlightIndex = FirstPosition[anglesDeg, highlightAngleDeg, {None}][[1]];

  arrows = Table[
    {
      If[i === highlightIndex, Opacity[1.0], Opacity[0.1]],
      Darker[Green],
      Arrow[Tube[{{0, 0, 0}, 400 dipoles[[i]]}]],
      Opacity[0.5],
      Text[labelStyle[ToString[anglesDeg[[i]]] <> "\[Degree]"], 400 dipoles[[i]]]
    },
    {i, Length[anglesDeg]}
  ];

  Graphics3D[arrows, Axes -> False, Boxed -> False]
];
